/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.po.CAPFormRelationRecord;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.manager.CAPTransFormDataBeanManager;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class CAPTransFormDataBeanManagerImpl
implements CAPTransFormDataBeanManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPTransFormDataBeanManagerImpl.class);
    private static final Pattern structPattern = Pattern.compile("(\"[^\"]+\":)(\\d+\\.\\d+)?E(\\+|\\-)(\\d+)");

    @Override
    public FormDataMasterBean transFormDataBeanFromMap(Map<String, Object> dataMap) {
        List relationRecordMaps;
        FormDataMasterBean formDataMasterBean = null;
        if (dataMap == null) {
            return formDataMasterBean;
        }
        CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        Long formId = CAPParamUtil.getLong(dataMap, (String)"formId");
        FormBean formBean = cap4FormCacheManager.getForm(formId);
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        Map masterData = (Map)dataMap.get(masterTableBean.getTableName());
        masterData.put(Enums.MasterTableField.start_date.getKey(), masterData.get(Enums.MasterTableField.start_date.getKey()) == null ? null : DateUtil.toDate((String)masterData.get(Enums.MasterTableField.start_date.getKey()).toString(), (String)"yyyy-MM-dd HH:mm:ss"));
        masterData.put(Enums.MasterTableField.ratify_date.getKey(), masterData.get(Enums.MasterTableField.ratify_date.getKey()) == null ? null : DateUtil.toDate((String)masterData.get(Enums.MasterTableField.ratify_date.getKey()).toString(), (String)"yyyy-MM-dd HH:mm:ss"));
        masterData.put(Enums.MasterTableField.modify_date.getKey(), masterData.get(Enums.MasterTableField.modify_date.getKey()) == null ? null : DateUtil.toDate((String)masterData.get(Enums.MasterTableField.modify_date.getKey()).toString(), (String)"yyyy-MM-dd HH:mm:ss"));
        masterData.put(Enums.MasterTableField.approve_date.getKey(), masterData.get(Enums.MasterTableField.approve_date.getKey()) == null ? null : DateUtil.toDate((String)masterData.get(Enums.MasterTableField.approve_date.getKey()).toString(), (String)"yyyy-MM-dd HH:mm:ss"));
        formDataMasterBean = new FormDataMasterBean(masterData, masterTableBean, new boolean[]{true});
        List subTableBeans = formBean.getSubTableBean();
        for (Object formTableBean : subTableBeans) {
            List subDataList = CAPParamUtil.getParamsListByKey(dataMap, (String)formTableBean.getTableName());
            ArrayList<FormDataSubBean> newBeans = new ArrayList<FormDataSubBean>();
            if (Strings.isEmpty((Collection)subDataList)) {
                FormDataSubBean formDataSubBean = new FormDataSubBean((FormTableBean)formTableBean, formDataMasterBean, new boolean[]{true});
                newBeans.add(formDataSubBean);
            } else {
                for (Map subData : subDataList) {
                    FormDataSubBean formDataSubBean = new FormDataSubBean(subData, (FormTableBean)formTableBean, formDataMasterBean, new boolean[]{true});
                    newBeans.add(formDataSubBean);
                }
            }
            formDataMasterBean.setSubData(formTableBean.getTableName(), newBeans);
        }
        List attachmentMaps = CAPParamUtil.getParamsListByKey(dataMap, (String)"attachments");
        if (Strings.isNotEmpty((Collection)attachmentMaps)) {
            for (Map map : attachmentMaps) {
                Attachment attachment = CAPAttachmentUtil.importAttachmentFromMap(map);
                ArrayList<Object> subReferenceAttachs = formDataMasterBean.getSessionAttachments(String.valueOf(attachment.getSubReference()));
                if (subReferenceAttachs == null) {
                    subReferenceAttachs = new ArrayList<Object>();
                }
                subReferenceAttachs.add(attachment);
                formDataMasterBean.putSessionAttachments(String.valueOf(attachment.getSubReference()), subReferenceAttachs);
            }
        }
        if (Strings.isNotEmpty((Collection)(relationRecordMaps = CAPParamUtil.getParamsListByKey(dataMap, (String)"relationRecords")))) {
            ArrayList<CAPFormRelationRecord> capFormRelationRecords = new ArrayList<CAPFormRelationRecord>();
            for (Map map : relationRecordMaps) {
                CAPFormRelationRecord capFormRelationRecord = new CAPFormRelationRecord();
                capFormRelationRecord.importFromDataMap(map);
                capFormRelationRecords.add(capFormRelationRecord);
            }
            try {
                CAP4FormRelationActionManager cap4FormRelationActionManager = (CAP4FormRelationActionManager)AppContext.getBean((String)"cap4FormRelationActionManager");
                cap4FormRelationActionManager.upgradeCAPFormRelationRecords(formBean, capFormRelationRecords, false);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"structureFormDataBeanByJSON.upgradeCAPFormRelationRecords", (Throwable)e);
            }
            formDataMasterBean.setRelationRecords(capFormRelationRecords);
        }
        return formDataMasterBean;
    }

    @Override
    public FormDataMasterBean transFormDataBeanFromJson(String dataJson) {
        if (Strings.isBlank((String)dataJson)) {
            return null;
        }
        Map dataMap = (Map)JSONUtil.parseJSONString((String)this.formatDataBeanJSON(dataJson));
        return this.transFormDataBeanFromMap(dataMap);
    }

    @Override
    public FormDataMasterBean transFormDataBeanFromFormBean(FormBean formBean, String dataJson, FormAuthViewBean formAuthViewBean) throws BusinessException {
        Map subTables;
        List datalist = (List)JSONUtil.parseJSONString((String)this.formatDataBeanJSON(dataJson));
        Map masterData = (Map)datalist.get(0);
        Long oldId = Long.parseLong(String.valueOf(masterData.get(Enums.MasterTableField.id.getKey())));
        HashMap<Long, Long> subIdMapping = new HashMap<Long, Long>();
        this.formatMasterData(masterData, formBean, formAuthViewBean);
        masterData.remove(Enums.MasterTableField.id.getKey());
        FormDataMasterBean formDataMasterBean = new FormDataMasterBean(masterData, formBean.getMasterTableBean(), new boolean[]{true});
        List subTableList = formBean.getSubTableBean();
        if (datalist.size() > 1) {
            for (int i = 1; i < datalist.size(); ++i) {
                Map map = (Map)datalist.get(i);
                for (Map.Entry entry : map.entrySet()) {
                    ArrayList<FormDataSubBean> formDataSubBeanList = new ArrayList<FormDataSubBean>();
                    List entryList = (List)entry.getValue();
                    FormTableBean formTableBean = null;
                    if (subTableList != null && subTableList.size() > 0) {
                        for (FormTableBean bean : subTableList) {
                            if (!((String)entry.getKey()).equals(bean.getTableName())) continue;
                            formTableBean = bean;
                            break;
                        }
                    }
                    for (Object object : entryList) {
                        Map dataMap = (Map)object;
                        Long oldSubId = 0L;
                        if (dataMap.containsKey(Enums.SubTableField.id.getKey())) {
                            oldSubId = dataMap.get(Enums.SubTableField.id.getKey()) == null ? 0L : Long.valueOf(dataMap.get(Enums.SubTableField.id.getKey()).toString());
                            dataMap.remove(Enums.SubTableField.id.getKey());
                        }
                        FormDataSubBean subBean = new FormDataSubBean((Map)object, formTableBean, formDataMasterBean, new boolean[]{true});
                        subIdMapping.put(oldSubId, subBean.getId());
                        formDataSubBeanList.add(subBean);
                    }
                    formDataMasterBean.setSubData((String)entry.getKey(), formDataSubBeanList);
                }
            }
        }
        if (subTableList != null && subTableList.size() > 0 && (formDataMasterBean.getSubTables() == null || formDataMasterBean.getSubTables().size() == 0)) {
            for (FormTableBean formTableBean : subTableList) {
                FormDataSubBean subLine = new FormDataSubBean(formTableBean, formDataMasterBean, new boolean[]{true});
                formDataMasterBean.addSubData(formTableBean.getTableName(), subLine);
            }
        }
        if ((subTables = formDataMasterBean.getSubTables()) != null) {
            for (FormTableBean formTableBean : subTableList) {
                if (subTables.get(formTableBean.getTableName()) != null) continue;
                ArrayList formDataSubBeanList = new ArrayList();
                formDataMasterBean.setSubData(formTableBean.getTableName(), formDataSubBeanList);
            }
        }
        CAP4FormRelationActionManager cap4FormRelationActionManager = (CAP4FormRelationActionManager)AppContext.getBean((String)"cap4FormRelationActionManager");
        List<CAPFormRelationRecord> capFormRelationRecords = cap4FormRelationActionManager.getCAPFormRelationRecordsByMasterDataId(oldId);
        cap4FormRelationActionManager.upgradeCAPFormRelationRecords(formBean, capFormRelationRecords, true);
        formDataMasterBean.setRelationRecords(new ArrayList());
        for (CAPFormRelationRecord record : capFormRelationRecords) {
            CAPFormRelationRecord newRecord = new CAPFormRelationRecord();
            newRecord.setNewId();
            newRecord.setFromMasterDataId(formDataMasterBean.getId());
            newRecord.setToMasterDataId(record.getToMasterDataId());
            newRecord.setFromFormId(formBean.getId());
            newRecord.setToFormId(record.getToFormId());
            newRecord.setFromSubdataId(record.getFromSubdataId());
            if (record.getFromSubdataId() != null && record.getFromSubdataId() != 0L && record.getFromSubdataId() != -1L) {
                Long newSubId = (Long)subIdMapping.get(record.getFromSubdataId());
                newRecord.setFromSubdataId(newSubId);
            }
            newRecord.setToSubdataId(record.getToSubdataId());
            newRecord.setFieldName(record.getFieldName());
            newRecord.setFormType(record.getFormType());
            newRecord.setType(record.getType());
            newRecord.setMemberId(record.getMemberId());
            newRecord.setDataInfo(record.getDataInfo());
            newRecord.setViewThrough(record.getViewThrough());
            newRecord.setRelationShipId(record.getRelationShipId());
            formDataMasterBean.getRelationRecords().add(newRecord);
        }
        formDataMasterBean.initRelationRecordMap();
        return formDataMasterBean;
    }

    private void formatMasterData(Map<String, Object> masterData, FormBean form, FormAuthViewBean formAuthViewBean) {
        if (masterData == null || form == null || formAuthViewBean == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : masterData.entrySet()) {
            FormFieldBean field;
            Enums.MasterTableField fieldEnum;
            FormAuthViewFieldBean authorizationField = formAuthViewBean.getFormAuthorizationField(entry.getKey());
            if (authorizationField != null && authorizationField.isSerialNumberDefaultValue()) {
                entry.setValue(null);
            }
            if (authorizationField != null && authorizationField.getDefaultValue() != null && FormulaEnums.FormulaVar.getEnumByKey((String)authorizationField.getDefaultValue()) != null) {
                entry.setValue(null);
            }
            if ((fieldEnum = Enums.MasterTableField.getEnumByKey((String)entry.getKey())) != null) {
                entry.setValue(null);
            }
            if ((field = form.getFieldBeanByName(entry.getKey())) == null || field.getFormConditionList() == null || field.getFormConditionList().size() <= 0) continue;
            entry.setValue(null);
        }
    }

    private String formatDataBeanJSON(String dataJson) {
        Matcher m = structPattern.matcher(dataJson);
        StringBuffer sb = new StringBuffer("");
        while (m.find()) {
            String fieldName = m.group(1);
            String temp2 = m.group(2);
            String temp3 = m.group(3);
            String temp4 = m.group(4);
            temp2 = temp2.replace(".", "");
            if (temp3 != null && "-".equals(temp3)) {
                temp2 = temp3 + temp2;
            }
            for (int i = Integer.parseInt(temp4); i > 1; --i) {
                temp2 = temp2 + "0";
            }
            String replacement = fieldName + temp2;
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        dataJson = sb.toString();
        return dataJson;
    }
}

