/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPUnFlowButtonManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPButtonManager;
import com.seeyon.cap4.template.vo.UnFlowButtonVO;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;

public class CAPUnFlowButtonManagerImpl
extends AbstractCAPButtonManager
implements CAPUnFlowButtonManager {
    private CAPFormManager capFormManager;

    @Override
    public <T> List<T> getListButtons(Class<T> tClass, FormBean formBean, FormBindAuthBean bindAuthBean, List<Map<String, String>> buttons, Enums.ViewType viewType, FormBindAuthBean.ShowPosition showPosition) {
        List<Object> list = null;
        List<UnFlowButtonVO> vos = this.getListButtons(formBean, bindAuthBean, buttons, viewType, showPosition);
        if (Strings.isNotEmpty(vos)) {
            if (UnFlowButtonVO.class.equals(tClass)) {
                list = vos;
            } else {
                list = new ArrayList();
                for (UnFlowButtonVO vo : vos) {
                    list.add(new BeanMap((Object)vo));
                }
            }
        }
        return list == null ? new ArrayList() : list;
    }

    private List<UnFlowButtonVO> getListButtons(FormBean formBean, FormBindAuthBean bindAuthBean, List<Map<String, String>> buttons, Enums.ViewType viewType, FormBindAuthBean.ShowPosition showPosition) {
        ArrayList<UnFlowButtonVO> buttonList = new ArrayList<UnFlowButtonVO>();
        for (Map<String, String> button : buttons) {
            Map position;
            if (button == null || button.isEmpty() || "false".equals((position = (Map)JSONUtil.parseJSONString((String)button.get("position"), Map.class)).get(showPosition.getKey()))) continue;
            String name = button.get("name");
            if (viewType == Enums.ViewType.Phone && (FormBindAuthBean.AuthName.BATHUPDATE.getKey().equals(name) || FormBindAuthBean.AuthName.BATHFRESH.getKey().equals(name) || FormBindAuthBean.AuthName.ALLOWEXPORT.getKey().equals(name) || FormBindAuthBean.AuthName.ALLOWIMPORT.getKey().equals(name) || FormBindAuthBean.AuthName.ALLOWPRINT.getKey().equals(name) || FormBindAuthBean.AuthName.ALLOWLOG.getKey().equals(name))) continue;
            UnFlowButtonVO btn = new UnFlowButtonVO();
            btn.setName(button.get("display"));
            btn.setType(button.get("name"));
            btn.setPosition(showPosition.getKey());
            String value = button.get("value");
            if (FormBindAuthBean.AuthName.ADD.getKey().equals(name) || this.isUpdateButton(button) || FormBindAuthBean.AuthName.BROWSE.getKey().equals(name)) {
                String rightId = viewType == Enums.ViewType.SeeyonForm ? value : button.get("phoneValue");
                if (Strings.isBlank((String)rightId)) continue;
                if (FormBindAuthBean.AuthName.BROWSE.getKey().equals(name)) {
                    rightId = this.getButtonBrowseRightId(rightId);
                }
                if (this.isUpdateButton(button)) {
                    btn.setType(FormBindAuthBean.AuthName.UPDATE.getKey() + rightId);
                }
                btn.setRightId(rightId);
                this.capFormManager.addRightId(formBean.getId(), rightId);
            }
            if (FormBindAuthBean.AuthName.BATHFRESH.getKey().equals(name)) {
                btn.setIsDoTrigger(formBean.getFormTriggerIdList().isEmpty() ? CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
            }
            if (FormBindAuthBean.AuthName.BATHUPDATE.getKey().equals(name)) {
                btn.setValue(value);
            }
            this.setButtonCustomInfo(bindAuthBean.getCustomBtnInfoById(button.get("name")), button, btn, viewType);
            if (("false".equals(value) || Strings.isBlank((String)value)) && Strings.isBlank((String)button.get("isCustomBtn"))) continue;
            buttonList.add(btn);
        }
        if (viewType == Enums.ViewType.SeeyonForm && showPosition == FormBindAuthBean.ShowPosition.ToolBar && AppContext.hasPlugin((String)"barCode")) {
            UnFlowButtonVO btn = new UnFlowButtonVO();
            btn.setName(ResourceUtil.getString((String)"cap.form.unFlow.list.barCodeName"));
            btn.setType("barCode");
            buttonList.add(btn);
        }
        return buttonList;
    }

    private boolean isUpdateButton(Map<String, String> button) {
        return FormBindAuthBean.AuthName.getEnumByKey((String)button.get("name")) == null && Strings.isBlank((String)button.get("isCustomBtn"));
    }

    private String getButtonBrowseRightId(String rightId) {
        String[] rightIds = rightId.split("[|]");
        StringBuilder sb = new StringBuilder();
        int j = rightIds.length;
        for (int i = 0; i < j; ++i) {
            if (i == j - 1) {
                sb.append(rightIds[i]);
                continue;
            }
            sb.append(rightIds[i]).append("_");
        }
        return sb.toString();
    }

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }
}

