/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.FormDataListFormatBean;
import com.seeyon.cap4.template.manager.CAPUnFlowFormatManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPDataListFormatManager;
import com.seeyon.cap4.template.vo.ListFieldVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;

public class CAPUnFlowFormatManagerImpl
extends AbstractCAPDataListFormatManager
implements CAPUnFlowFormatManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPUnFlowFormatManagerImpl.class);

    @Override
    public List<Map<String, Object>> format(FormBean formBean, List<Map<String, Object>> formDataList, FormDataListFormatBean paramFormatBean) throws BusinessException {
        if (Strings.isEmpty(formDataList)) {
            return new ArrayList<Map<String, Object>>();
        }
        HashSet<String> displayImageFields = new HashSet();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(formDataList.size());
        if (paramFormatBean.getShowFields() == null) {
            HashMap<String, String> fieldAuthMap = new HashMap<String, String>();
            Map<String, Object> firstData = formDataList.get(0);
            String rightId = paramFormatBean.getRightId().replaceAll("[|]", "_");
            boolean byAuthBean = Strings.isNotBlank((String)rightId);
            List<FormAuthViewBean> authViewBeans = this.getFormAuthViewBeans(formBean, rightId.split("_"));
            boolean hasImageField = false;
            for (Map.Entry<String, Object> entry : firstData.entrySet()) {
                String fieldName = entry.getKey();
                FormFieldBean fieldBean = formBean.getFieldBeanByName(fieldName, false);
                if (fieldBean == null) continue;
                String filedAuth = byAuthBean ? this.getFieldAuthByAuthBean(fieldBean, authViewBeans) : this.getFieldAuthByAllViews(fieldBean, formBean);
                fieldAuthMap.put(fieldBean.getName(), filedAuth);
                if (fieldBean.isDisplayImage()) {
                    displayImageFields.add(fieldBean.getName());
                }
                if (hasImageField || !FormFieldComEnum.EXTEND_IMAGE.getKey().equals(fieldBean.getInputType())) continue;
                hasImageField = true;
            }
            Map<String, List<Map<String, String>>> capFormAttachmentsMap = this.getDataAttachmentMap(formDataList, hasImageField, Enums.MasterTableField.id.getKey());
            for (Map<String, Object> dataMap : formDataList) {
                resultList.add(this.getOneLineDisplayValue(formBean, dataMap, fieldAuthMap, displayImageFields, paramFormatBean, capFormAttachmentsMap));
            }
        } else {
            displayImageFields = this.getDisplayImageFields(formBean, paramFormatBean.getShowFields());
            Map<String, List<Map<String, String>>> capFormAttachmentsMap = this.getDataAttachmentMap(formDataList, this.hasImageField(paramFormatBean.getShowFields()), Enums.MasterTableField.id.getKey());
            for (Map<String, Object> dataMap : formDataList) {
                resultList.add(this.getOneLineAppointDisplayValue(formBean, dataMap, displayImageFields, paramFormatBean, capFormAttachmentsMap));
            }
        }
        return resultList;
    }

    private Map<String, Object> getOneLineAppointDisplayValue(FormBean formBean, Map<String, Object> dataMap, Set<String> displayImageFields, FormDataListFormatBean paramFormatBean, Map<String, List<Map<String, String>>> capFormAttachmentsMap) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(Enums.MasterTableField.id.getKey(), MapUtils.getString(dataMap, (Object)Enums.MasterTableField.id.getKey()));
            map.put(Enums.MasterTableField.state.getKey(), MapUtils.getString(dataMap, (Object)Enums.MasterTableField.state.getKey()));
            for (ListFieldVO fieldVO : paramFormatBean.getShowFields()) {
                String key = fieldVO.getFieldName();
                if (Enums.MasterTableField.id.getKey().equals(key) || Enums.MasterTableField.state.getKey().equals(key)) continue;
                HashMap<String, Object> fieldData = new HashMap<String, Object>(1);
                Object value = dataMap.get(key);
                FormFieldBean fieldBean = formBean.getFieldBeanByName(key, true);
                if (fieldBean != null) {
                    Object v = this.getFormFieldDisplayValue(formBean, fieldBean, dataMap, fieldVO.getAuth(), displayImageFields, paramFormatBean, capFormAttachmentsMap);
                    value = fieldBean.isImageEnumField() ? this.resetEnumImageValue(v, fieldData) : v;
                }
                fieldData.put("value", value);
                map.put(key, paramFormatBean.isForExport() ? value : fieldData);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u65e0\u6d41\u7a0b\u5217\u8868\u6570\u636e\u7ec4\u88c5\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return map;
    }

    private Map<String, Object> getOneLineDisplayValue(FormBean formBean, Map<String, Object> dataMap, Map<String, String> fieldAuthMap, Set<String> displayImageFields, FormDataListFormatBean paramFormatBean, Map<String, List<Map<String, String>>> capFormAttachmentsMap) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                FormFieldBean fieldBean = formBean.getFieldBeanByName(key, true);
                HashMap<String, Object> fieldData = new HashMap<String, Object>(1);
                if (fieldBean != null) {
                    String fieldAuth = fieldAuthMap.get(fieldBean.getName());
                    Object v = this.getFormFieldDisplayValue(formBean, fieldBean, dataMap, fieldAuth, displayImageFields, paramFormatBean, capFormAttachmentsMap);
                    Object object = value = fieldBean.isImageEnumField() ? this.resetEnumImageValue(v, fieldData) : v;
                }
                if (fieldBean != null && (fieldBean.getName().equals(Enums.MasterTableField.id.getKey()) || fieldBean.getName().equals(Enums.MasterTableField.state.getKey()))) {
                    map.put(key, value);
                    continue;
                }
                fieldData.put("value", value);
                map.put(key, paramFormatBean.isForExport() ? value : fieldData);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u65e0\u6d41\u7a0b\u5217\u8868\u6570\u636e\u7ec4\u88c5\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return map;
    }

    @Override
    public Object getConstantFieldValue(int formType, String fieldName, Map<String, Object> dataMap) throws Exception {
        Object value = dataMap.get(fieldName);
        Enums.MasterTableField masterConstField = Enums.MasterTableField.getEnumByKey((String)fieldName);
        switch (masterConstField) {
            case start_member_id: {
                V3xOrgMember member = this.orgManager.getMemberById(Long.valueOf(Long.parseLong(value.toString())));
                if (member == null) break;
                value = member.getName();
                break;
            }
            case state: {
                Enums.FormDataStateEnum dateAuditedSate = null;
                int state = Integer.parseInt(value.toString());
                if (formType == Enums.FormType.processesForm.getKey()) {
                    switch (state) {
                        case 2: {
                            dateAuditedSate = Enums.FormDataStateEnum.FLOW_AUDITEDPASS;
                            break;
                        }
                        case 3: {
                            dateAuditedSate = Enums.FormDataStateEnum.FLOW_AUDITEDUNPASS;
                            break;
                        }
                        default: {
                            dateAuditedSate = Enums.FormDataStateEnum.FLOW_UNAUDITED;
                            break;
                        }
                    }
                } else if (formType == Enums.FormType.unFlowForm.getKey()) {
                    dateAuditedSate = Enums.FormDataStateEnum.getUnFlowFormDataStateEnumByKey((int)state);
                }
                if (dateAuditedSate == null) break;
                value = dateAuditedSate.getKey();
                break;
            }
            case ratifyflag: {
                Enums.FormDataRatifyFlagEnum dateVouchSate;
                int state = Integer.parseInt(value.toString());
                switch (state) {
                    case 1: {
                        dateVouchSate = Enums.FormDataRatifyFlagEnum.FLOW_VOUCHPASS;
                        break;
                    }
                    case 2: {
                        dateVouchSate = Enums.FormDataRatifyFlagEnum.FLOW_VOUCHUNPASS;
                        break;
                    }
                    default: {
                        dateVouchSate = Enums.FormDataRatifyFlagEnum.FLOW_UNVOUCH;
                    }
                }
                value = dateVouchSate.getText();
                break;
            }
            case finishedflag: {
                Enums.FromDataFinishedFlagEnum flowState;
                int state = Integer.parseInt(value.toString());
                switch (state) {
                    case 0: {
                        flowState = Enums.FromDataFinishedFlagEnum.END_NO;
                        break;
                    }
                    case 1: {
                        flowState = Enums.FromDataFinishedFlagEnum.END_YES;
                        break;
                    }
                    default: {
                        flowState = Enums.FromDataFinishedFlagEnum.STOP;
                    }
                }
                value = flowState.getText();
                break;
            }
            case modify_date: 
            case start_date: {
                value = DateUtil.formatDateTime((Date)((Date)value));
                break;
            }
        }
        value = value == null ? "" : String.valueOf(value);
        return value;
    }

    @Override
    public List<FormAuthViewBean> getFormAuthViewBeans(FormBean formBean, String[] rights) {
        ArrayList<FormAuthViewBean> authViewBeans = new ArrayList<FormAuthViewBean>();
        if (rights != null) {
            for (String right : rights) {
                String[] rightIdStr;
                Long rightId;
                FormAuthViewBean auth;
                if (StringUtil.checkNull((String)right) || (auth = formBean.getAuthViewBeanById(rightId = Long.valueOf((rightIdStr = right.split("\\.")).length > 1 ? rightIdStr[1] : rightIdStr[0]))) == null) continue;
                authViewBeans.add(auth);
            }
        }
        return authViewBeans;
    }

    @Override
    public String getFieldAuthByAuthBean(FormFieldBean fieldBean, List<FormAuthViewBean> authViewBeans) {
        boolean hide = true;
        for (FormAuthViewBean auth : authViewBeans) {
            String access;
            FormAuthViewFieldBean fieldAuth = auth.getFormAuthorizationField(fieldBean.getName());
            if (fieldAuth == null || (access = fieldAuth.getAccess()).equals(Enums.FieldAccessType.hide.getKey())) continue;
            hide = false;
            break;
        }
        return hide ? Enums.FieldAccessType.hide.getKey() : Enums.FieldAccessType.browse.getKey();
    }

    @Override
    public String getFieldAuthByAllViews(FormFieldBean fieldBean, FormBean formBean) {
        boolean hide = true;
        List views = formBean.getFormViewList();
        for (FormViewBean view : views) {
            List operations = view.getAllOperations();
            for (FormAuthViewBean op : operations) {
                FormAuthViewFieldBean fieldAuth;
                if (!formBean.isSystemAuth(op.getId().longValue()) || !Enums.FormAuthorizationType.show.getKey().equals(op.getType()) || (fieldAuth = op.getFormAuthorizationField(fieldBean.getName())) == null || fieldAuth.getAccess().equals(Enums.FieldAccessType.hide.getKey())) continue;
                hide = false;
                break;
            }
            if (hide) continue;
            break;
        }
        return hide ? Enums.FieldAccessType.hide.getKey() : Enums.FieldAccessType.browse.getKey();
    }
}

