/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.google.common.collect.Lists;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormQueryResult;
import com.seeyon.cap4.form.bean.FormQueryTypeEnum;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.template.bean.FilterFieldBean;
import com.seeyon.cap4.template.bean.FormDataListFormatBean;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.bean.UnFlowFormDataListQueryBean;
import com.seeyon.cap4.template.bean.ValidListButtonParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPFilterFieldConditionManager;
import com.seeyon.cap4.template.manager.CAPFilterFieldManager;
import com.seeyon.cap4.template.manager.CAPUnFlowButtonManager;
import com.seeyon.cap4.template.manager.CAPUnFlowFormatManager;
import com.seeyon.cap4.template.manager.CAPUnFlowManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPDataListManager;
import com.seeyon.cap4.template.vo.FilterFieldVO;
import com.seeyon.cap4.template.vo.ListFieldVO;
import com.seeyon.cap4.template.vo.UnFlowButtonVO;
import com.seeyon.cap4.template.vo.UnFlowListInitVO;
import com.seeyon.cap4.template.vo.UnFlowListVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class CAPUnFlowManagerImpl
extends AbstractCAPDataListManager
implements CAPUnFlowManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPUnFlowManagerImpl.class);
    private CAP4FormManager cap4FormManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormDataManager cap4FormDataManager;
    private CAPUnFlowFormatManager capUnFlowFormatManager;
    private CAPUnFlowButtonManager capUnFlowButtonManager;
    private CAPFilterFieldManager capFilterFieldManager;
    private CAPFilterFieldConditionManager capFilterFieldConditionManager;

    @Override
    public CAPBusinessEnum.DataListTypeEnum getListType() {
        return CAPBusinessEnum.DataListTypeEnum.UN_FLOW;
    }

    @Override
    public boolean checkButton(ValidListButtonParamBean paramBean) throws BusinessException {
        FormBean formBean = this.cap4FormManager.getForm(paramBean.getFormId(), false);
        if (!formBean.isEnabled()) {
            return false;
        }
        FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById(paramBean.getFormTemplateId());
        if (bindAuthBean == null || !bindAuthBean.checkRight(AppContext.currentUserId())) {
            return false;
        }
        Enums.ViewType viewType = paramBean.getViewType();
        FormBindAuthBean.ShowPosition showPosition = paramBean.getShowPosition();
        List buttons = bindAuthBean.getAllBtnListByBtnOrder(viewType, showPosition);
        List<UnFlowButtonVO> hasRightButtons = this.capUnFlowButtonManager.getListButtons(UnFlowButtonVO.class, formBean, bindAuthBean, buttons, viewType, showPosition);
        for (UnFlowButtonVO vo : hasRightButtons) {
            if (!StringUtils.equals((CharSequence)paramBean.getType(), (CharSequence)vo.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkRight(Long userId, FormDataListParamBean paramBean) throws BusinessException {
        return this.cap4FormManager.checkRight(Enums.FormModuleAuthModuleType.BindAppForm, paramBean.getFormTemplateId(), userId, paramBean.getFormId());
    }

    @Override
    public UnFlowListVO getList(FormDataListParamBean paramBean) throws BusinessException {
        UnFlowListVO unFlowListVO;
        FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
        FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById(paramBean.getFormTemplateId());
        List<FilterFieldVO> filterFieldVOS = null;
        if (CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(paramBean.getInit())) {
            unFlowListVO = new UnFlowListInitVO();
            ((UnFlowListInitVO)unFlowListVO).setName(bindAuthBean.getName());
            List searchFields = bindAuthBean.getSearchFieldList();
            List<FilterFieldBean> filterFieldBeans = this.capFilterFieldManager.getFilterFieldBeans(formBean, searchFields, FormQueryTypeEnum.infoManageQuery);
            filterFieldVOS = this.capFilterFieldManager.getFilterFields(filterFieldBeans);
            ((UnFlowListInitVO)unFlowListVO).setFilterFields(filterFieldVOS);
            Enums.ViewType viewType = paramBean.getViewType();
            List toolbarButtons = bindAuthBean.getAllBtnListByBtnOrder(viewType, FormBindAuthBean.ShowPosition.ToolBar);
            List dataRowButtons = bindAuthBean.getAllBtnListByBtnOrder(viewType, FormBindAuthBean.ShowPosition.DataRow);
            HashMap<String, List<UnFlowButtonVO>> buttons = new HashMap<String, List<UnFlowButtonVO>>(2);
            buttons.put(FormBindAuthBean.ShowPosition.ToolBar.getKey(), this.capUnFlowButtonManager.getListButtons(UnFlowButtonVO.class, formBean, bindAuthBean, toolbarButtons, viewType, FormBindAuthBean.ShowPosition.ToolBar));
            buttons.put(FormBindAuthBean.ShowPosition.DataRow.getKey(), this.capUnFlowButtonManager.getListButtons(UnFlowButtonVO.class, formBean, bindAuthBean, dataRowButtons, viewType, FormBindAuthBean.ShowPosition.DataRow));
            ((UnFlowListInitVO)unFlowListVO).setButtons(buttons);
        } else {
            unFlowListVO = new UnFlowListVO();
        }
        List<ListFieldVO> fields = this.getListShowFields(formBean, bindAuthBean, paramBean);
        unFlowListVO.setFields(fields);
        UnFlowFormDataListQueryBean queryBean = this.getDataListQueryBean(formBean, bindAuthBean, paramBean, filterFieldVOS);
        FlipInfo fi = this.getFormDataList(queryBean, paramBean.getFlipInfo());
        String rightId = FormUtil.getUnflowFormAuth((FormBean)formBean, (String)String.valueOf(paramBean.getFormTemplateId()));
        FormDataListFormatBean formatBean = new FormDataListFormatBean();
        formatBean.setRightId(rightId);
        formatBean.setShowFields(fields);
        formatBean.setForExport(paramBean.isForExport());
        fi.setData(this.capUnFlowFormatManager.format(formBean, fi.getData(), formatBean));
        unFlowListVO.setDatas(fi.getData());
        unFlowListVO.setPage(String.valueOf(fi.getPage()));
        unFlowListVO.setPageSize(String.valueOf(fi.getSize()));
        unFlowListVO.setTotal(String.valueOf(fi.getTotal()));
        unFlowListVO.setPages(String.valueOf(fi.getPages()));
        unFlowListVO.setFormId(paramBean.getFormId().toString());
        unFlowListVO.setFormTemplateId(paramBean.getFormTemplateId().toString());
        return unFlowListVO;
    }

    private UnFlowFormDataListQueryBean getDataListQueryBean(FormBean formBean, FormBindAuthBean bindAuthBean, FormDataListParamBean paramBean, List<FilterFieldVO> filterFieldVOS) throws BusinessException {
        UnFlowFormDataListQueryBean queryBean = new UnFlowFormDataListQueryBean();
        queryBean.setQueryType(FormQueryTypeEnum.infoManageQuery);
        queryBean.setFormBean(formBean);
        queryBean.setFormBindAuthBean(bindAuthBean);
        queryBean.setUserOrderBy(paramBean.getUserOrderBy());
        if (paramBean.getUserConditions() == null) {
            if (filterFieldVOS == null) {
                List<FilterFieldBean> filterFieldBeans = this.capFilterFieldManager.getFilterFieldBeans(formBean, bindAuthBean.getSearchFieldList(), FormQueryTypeEnum.infoManageQuery);
                filterFieldVOS = this.capFilterFieldManager.getFilterFields(filterFieldBeans);
            }
            queryBean.setUserConditions(this.capFilterFieldConditionManager.getDefaultConditionBeans(filterFieldVOS));
        } else {
            queryBean.setUserConditions(this.capFilterFieldConditionManager.getConditionBeans(paramBean.getUserConditions()));
        }
        queryBean.setDataConditions(paramBean.getDataConditions());
        return queryBean;
    }

    @Override
    public FormQueryWhereClause getFormQueryWhereClause(FormDataListParamBean paramBean, FormQueryTypeEnum typeEnum) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
        FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById(paramBean.getFormTemplateId());
        UnFlowFormDataListQueryBean queryBean = this.getDataListQueryBean(formBean, bindAuthBean, paramBean, null);
        queryBean.setQueryType(typeEnum);
        return this.getFormQuerySql(queryBean);
    }

    @Override
    public boolean checkData4OperationRange(FormBean formBean, FormBindAuthBean formBindAuthBean, Long dataId) throws BusinessException {
        FormQueryWhereClause operationWhereClause = this.capDataListSqlHelpManager.getOperationRangeWhereClause(formBindAuthBean);
        FormQueryWhereClause idClause = new FormQueryWhereClause();
        ArrayList<FormQueryWhereClause> whereClauses = new ArrayList<FormQueryWhereClause>();
        whereClauses.add(operationWhereClause);
        whereClauses.add(idClause);
        FormQueryWhereClause queryClause = this.getFormQuerySqlForOneBind(formBean, whereClauses, null);
        FormQueryWhereClause querySql = this.buildLastWhereClause(queryClause);
        LOGGER.info((Object)("\u3010\u65e0\u6d41\u7a0b\u64cd\u4f5c\u8303\u56f4\u9a8c\u8bc1\u3011" + formBindAuthBean.getId() + "-" + formBindAuthBean.getName()));
        return false;
    }

    private FlipInfo getFormDataList(UnFlowFormDataListQueryBean queryBean, FlipInfo flipInfo) throws BusinessException {
        queryBean.setReverse(false);
        return this.getFormDataQueryResult(queryBean, flipInfo).getFlipInfo();
    }

    private FormQueryResult getFormDataQueryResult(UnFlowFormDataListQueryBean queryBean, FlipInfo flipInfo) throws BusinessException {
        FormQueryWhereClause querySql = this.getFormQuerySql(queryBean);
        LOGGER.info((Object)("\u3010\u65e0\u6d41\u7a0b\u5217\u8868\u67e5\u8be2\u3011" + queryBean.getFormBindAuthBean().getId() + "-" + queryBean.getFormBindAuthBean().getName()));
        return this.getFormQueryResult(querySql, flipInfo);
    }

    private FormQueryWhereClause getFormQuerySql(UnFlowFormDataListQueryBean queryBean) throws BusinessException {
        FormQueryWhereClause operationWhereClause = this.capDataListSqlHelpManager.getOperationRangeWhereClause(queryBean.getFormBindAuthBean());
        FormQueryWhereClause customConditionWhereClause = this.capDataListSqlHelpManager.getFormQueryWhereClauseByConditionBean(queryBean.getUserConditions(), true);
        FormQueryWhereClause dataConditionWhereCause = this.cap4FormDataManager.getFieldDataConditionFormQueryWhereClause(queryBean.getFormBean(), queryBean.getDataConditions(), true);
        ArrayList<FormQueryWhereClause> whereClauses = new ArrayList<FormQueryWhereClause>();
        whereClauses.add(operationWhereClause);
        whereClauses.add(customConditionWhereClause);
        whereClauses.add(dataConditionWhereCause);
        FormQueryWhereClause queryClause = this.getFormQuerySqlForOneBind(queryBean.getFormBean(), whereClauses, queryBean);
        return this.buildLastWhereClause(queryClause);
    }

    private FormQueryWhereClause getFormQuerySqlForOneBind(FormBean formBean, List<FormQueryWhereClause> whereClauses, UnFlowFormDataListQueryBean queryBean) throws BusinessException {
        FormQueryWhereClause allWhereClause = new FormQueryWhereClause();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        FormBindAuthBean bindAuth = queryBean.getFormBindAuthBean();
        String whereClause = this.capDataListSqlHelpManager.getSQLWhere(whereClauses, queryParams);
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        StringBuilder sql = new StringBuilder();
        if (queryBean.getQueryType() == FormQueryTypeEnum.unFlowExport) {
            sql.append(" SELECT ").append(masterTableBean.getTableName()).append(".id");
        } else {
            Set<String> fieldSet = this.capDataListSqlHelpManager.getSQLSelectFields(masterTableBean.getTableName(), bindAuth.getShowFieldList(), queryBean.getCustomShowFields());
            sql.append(" SELECT DISTINCT ").append(StringUtils.join(fieldSet, (String)","));
        }
        sql.append(" FROM ").append(masterTableBean.getTableName()).append(" ").append(masterTableBean.getTableName()).append(" ");
        sql.append(this.capDataListSqlHelpManager.getSQLFrom(formBean, sql, whereClause));
        List subTables = formBean.getSubTableBean();
        StringBuilder subTableWhereSb = new StringBuilder();
        for (FormTableBean subTable : subTables) {
            if (subTable.isMainTable() || sql.indexOf(subTable.getTableName()) == -1 || subTableWhereSb.indexOf(subTable.getTableName()) != -1) continue;
            subTableWhereSb.append(" AND (").append(this.capDataListSqlHelpManager.getSQLMasterEqualSub4Id(masterTableBean.getTableName(), subTable.getTableName())).append(") ");
        }
        if (Strings.isNotEmpty((String)subTableWhereSb.toString().trim())) {
            String str = subTableWhereSb.toString();
            str = str.indexOf(" AND") == 0 ? str.substring(4, str.length()) : str;
            whereClause = str + " AND " + whereClause;
        }
        if (Strings.isNotEmpty((String)whereClause.trim())) {
            sql.append(" WHERE ");
            whereClause = FormUtil.changeAndAddNullWhereSql((String)whereClause);
            sql.append(whereClause);
        }
        allWhereClause.setWhereClause(whereClause);
        boolean customSort = false;
        if (Strings.isNotEmpty(queryBean.getUserOrderBy())) {
            allWhereClause.setOrderByClause(this.capDataListSqlHelpManager.getSQLOrder4CustomString(queryBean.getUserOrderBy(), masterTableBean.getTableName(), queryBean.isReverse()));
            customSort = true;
        }
        if (!customSort && queryBean.getQueryType() != FormQueryTypeEnum.unFlowExport) {
            String sortFields = bindAuth.getSortStr(masterTableBean.getTableName(), queryBean.isReverse());
            allWhereClause.setOrderByClause(this.capDataListSqlHelpManager.getSQLSort(masterTableBean, sortFields, queryBean.isReverse()));
        }
        allWhereClause.setAllSqlClause(sql.toString());
        allWhereClause.setQueryParams(queryParams);
        return allWhereClause;
    }

    private List<ListFieldVO> getListShowFields(FormBean formBean, FormBindAuthBean bindAuthBean, FormDataListParamBean paramBean) throws BusinessException {
        ArrayList fields = Lists.newArrayList();
        String rightId = FormUtil.getUnflowFormAuth((FormBean)formBean, (String)paramBean.getFormTemplateId().toString());
        rightId = rightId.replaceAll("[|]", "_");
        boolean byAuthBean = Strings.isNotBlank((String)rightId);
        List<FormAuthViewBean> authViewBeans = this.capUnFlowFormatManager.getFormAuthViewBeans(formBean, rightId.split("_"));
        for (SimpleObjectBean simpleObjectBean : bindAuthBean.getShowFieldList()) {
            FormFieldBean formFieldBean = FormSearchUtil.getFormFieldBean(formBean, simpleObjectBean);
            if (formFieldBean.isAttachment() && !FormFieldComEnum.EXTEND_IMAGE.getKey().equals(formFieldBean.getInputType())) continue;
            ListFieldVO field = new ListFieldVO();
            String display = formFieldBean.getDisplay();
            String value = simpleObjectBean.getValue();
            if (value != null && !StringUtils.equals((CharSequence)display, (CharSequence)value) && value.indexOf("(") > -1) {
                display = value.substring(value.indexOf("(") + 1, value.indexOf(")"));
            }
            field.setFieldName(formFieldBean.getName());
            field.setDisplay(display);
            field.setInputType(formFieldBean.getInputType());
            field.setFieldType(formFieldBean.getFieldType());
            field.setAliasTableName(formFieldBean.getOwnerTableName());
            String filedAuth = formFieldBean.isMasterField() && formFieldBean.isConstantField() ? Enums.FieldAccessType.edit.getKey() : (byAuthBean ? this.capUnFlowFormatManager.getFieldAuthByAuthBean(formFieldBean, authViewBeans) : this.capUnFlowFormatManager.getFieldAuthByAllViews(formFieldBean, formBean));
            field.setAuth(filedAuth);
            fields.add(field);
        }
        return fields;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCapUnFlowFormatManager(CAPUnFlowFormatManager capUnFlowFormatManager) {
        this.capUnFlowFormatManager = capUnFlowFormatManager;
    }

    public void setCapUnFlowButtonManager(CAPUnFlowButtonManager capUnFlowButtonManager) {
        this.capUnFlowButtonManager = capUnFlowButtonManager;
    }

    public void setCapFilterFieldManager(CAPFilterFieldManager capFilterFieldManager) {
        this.capFilterFieldManager = capFilterFieldManager;
    }

    public void setCapFilterFieldConditionManager(CAPFilterFieldConditionManager capFilterFieldConditionManager) {
        this.capFilterFieldConditionManager = capFilterFieldConditionManager;
    }
}

