/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.apps.collaboration.enums.ColHandleType;
import com.seeyon.apps.collaboration.enums.ColOpenFrom;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.apps.collaboration.vo.ColListSimpleVO;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.monitor.utils.CAP4MonitorUtil;
import com.seeyon.cap4.template.bo.CAPBusinessConfigBO;
import com.seeyon.cap4.template.bo.FormFlowListBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.CAPBusinessConfigManager;
import com.seeyon.cap4.template.manager.FormFlowListManager;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.affair.manager.AffairManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.comment.Comment;
import com.seeyon.ctp.common.ctpenumnew.EnumNameEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.permission.manager.PermissionManager;
import com.seeyon.ctp.common.permission.vo.PermissionVO;
import com.seeyon.ctp.common.po.affair.CtpAffair;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.util.StringUtils;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormFlowListManagerImpl
extends AbstractColumnElementDataManager
implements FormFlowListManager {
    private static final Log LOGGER = CtpLogFactory.getLog(FormFlowListManagerImpl.class);
    private PermissionManager permissionManager;
    private CollaborationApi collaborationApi;
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormDataDAO cap4FormDataDAO;
    private CAPBusinessConfigManager capBusinessConfigManager;
    private AffairManager affairManager;
    private EnumManager enumManagerNew;
    private WorkflowApiManager wapi = (WorkflowApiManager)AppContext.getBean((String)"wapi");
    private static final String TEMPLATE_ID = "templateId";
    private static final String BUSS_ID = "bussId";
    private static final String PAGE = "page";
    private static final String PAGE_SIZE = "pageSize";
    private static final String TYPE = "type";
    private static final String TEMPLETE_IDS = "templeteIds";
    private static final String OPINION = "Opinion";

    @Override
    public String transStepBack(Long affairId, Map<String, Object> commentMap, boolean isWFTrace) {
        if (affairId == null) {
            return "params affairId is null";
        }
        try {
            CtpAffair ctpAffair = this.affairManager.get(affairId);
            if (AppContext.hasPlugin((String)"fk") && ctpAffair == null) {
                ctpAffair = this.affairManager.getByHis(affairId);
            }
            if (ctpAffair == null) {
                return "ctpAffair is null";
            }
            ColSummary colSummary = this.collaborationApi.getColSummary(ctpAffair.getObjectId());
            Comment comment = this.createComment(colSummary, ctpAffair, AppContext.getCurrentUser(), ColHandleType.stepBack, commentMap);
            String transResult = this.collaborationApi.transStepBack(affairId, comment, isWFTrace);
            LOGGER.info((Object)("transStepBack affairId:" + affairId + ", Result : " + transResult));
            return null;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"finishWorkItem is exception", (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public boolean finishWorkItem(Long affairId, Long summaryId, Map<String, Object> trackParamMap, Map<String, Object> commentMap) {
        if (affairId == null || summaryId == null) {
            return false;
        }
        try {
            CtpAffair ctpAffair = this.affairManager.get(affairId);
            if (AppContext.hasPlugin((String)"fk") && ctpAffair == null) {
                ctpAffair = this.affairManager.getByHis(affairId);
            }
            if (ctpAffair == null) {
                LOGGER.error((Object)"finishWorkItem ctpAffair is null");
                return false;
            }
            ColSummary colSummary = this.collaborationApi.getColSummary(summaryId);
            Comment comment = this.createComment(colSummary, ctpAffair, AppContext.getCurrentUser(), ColHandleType.finish, commentMap);
            if (trackParamMap == null) {
                trackParamMap = new HashMap<String, Object>();
            }
            this.collaborationApi.finishWorkItem(ctpAffair, colSummary, comment, trackParamMap);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"finishWorkItem is exception", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Comment createComment(ColSummary summary, CtpAffair affair, User user, ColHandleType handleType, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        String content = map.get("content") != null ? (String)map.get("content") : null;
        String attitude = map.get("attitude") != null ? (String)map.get("attitude") : null;
        String hide = map.get("hide") != null ? (String)map.get("hide") : null;
        boolean isHide = "1".equals(hide);
        String relateInfo = map.get("fileJson") != null ? (String)map.get("fileJson") : "[]";
        String likeSummary = map.get("likeSummary") != null ? (String)map.get("likeSummary") : null;
        Comment comment = new Comment();
        comment.setId(null);
        comment.setContent(content);
        comment.setHidden(Boolean.valueOf(isHide));
        StringBuilder showToIds = new StringBuilder();
        if (isHide) {
            showToIds.append("Member|").append(summary.getStartMemberId());
        }
        comment.setShowToId(showToIds.toString());
        comment.setTitle(summary.getSubject());
        comment.setPid(Long.valueOf(0L));
        comment.setClevel(Integer.valueOf(1));
        comment.setPath(AppContext.getCurrentUser().getUserAgentFrom() == null ? "pc" : AppContext.getCurrentUser().getUserAgentFrom());
        comment.setModuleType(Integer.valueOf(ApplicationCategoryEnum.collaboration.getKey()));
        comment.setModuleId(summary.getId());
        comment.setCtype(Integer.valueOf(Comment.CommentType.comment.getKey()));
        comment.setAffairId(affair.getId());
        comment.setCreateDate(DateUtil.currentDate());
        comment.setExtAtt1(attitude);
        comment.setPraiseToSummary(Boolean.valueOf("1".equals(likeSummary)));
        comment.setRelateInfo(relateInfo);
        Long userId = user.getId();
        if (!userId.equals(affair.getMemberId())) {
            comment.setExtAtt2(user.getName());
        }
        if (handleType == ColHandleType.wait) {
            comment.setExtAtt3("collaboration.dealAttitude.temporaryAbeyance");
            comment.setExtAtt1("");
        } else if (handleType == ColHandleType.specialback || handleType == ColHandleType.stepBack) {
            comment.setExtAtt3("collaboration.dealAttitude.rollback");
        }
        return comment;
    }

    @Override
    public boolean transSendCollFromWait(Long templateId, Long formMasterId) {
        if (templateId == null || formMasterId == null) {
            return false;
        }
        return this.transSendColl(ColConstant.SendType.immediate.name(), templateId, formMasterId, null, null);
    }

    @Override
    public boolean transDoForward(Map<String, String> params) {
        User user = AppContext.getCurrentUser();
        try {
            this.collaborationApi.transDoForward(user, params);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"transDoForward is exception", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteAffair(String pageType, Long affairId) {
        try {
            this.collaborationApi.deleteAffair(pageType, affairId.longValue());
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"deleteAffair is exception", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> takeBack(Long affairId, boolean isSaveOpinion) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("code", "1002");
        try {
            CtpAffair ctpAffair = this.affairManager.get(affairId);
            if (AppContext.hasPlugin((String)"fk") && ctpAffair == null) {
                ctpAffair = this.affairManager.getByHis(affairId);
            }
            if (ctpAffair == null) {
                jsonObject.put("message", "ctpAffair is null");
                return jsonObject;
            }
            ColSummary colSummary = this.collaborationApi.getColSummary(ctpAffair.getObjectId());
            String wfCheck = this.wapi.canTakeBack(ApplicationCategoryEnum.collaboration.name(), String.valueOf(colSummary.getProcessId()), String.valueOf(ctpAffair.getActivityId()), String.valueOf(ctpAffair.getSubObjectId()));
            Map wfObject = (Map)JSONUtil.parseJSONString((String)wfCheck, Map.class);
            if (Boolean.valueOf(false).equals(wfObject.get("canTakeBack"))) {
                jsonObject.put("canTakeBack", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                jsonObject.put("state", wfObject.get("state"));
                jsonObject.put("I18N", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                jsonObject.put("message", ResourceUtil.getString((String)("collaboration.takeBackErr." + wfObject.get("state") + ".msg")));
                return jsonObject;
            }
            String message = this.collaborationApi.takeBack(affairId.longValue(), isSaveOpinion);
            jsonObject.put("code", Strings.isBlank((String)message) ? "1000" : "1002");
            jsonObject.put("message", message);
            return jsonObject;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"takeBack is exception", (Throwable)e);
            jsonObject.put("message", e.getMessage());
            return jsonObject;
        }
    }

    @Override
    public Map<String, Object> transRepeal(Long affairId, String content, Integer isWFTrace) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("content", content);
        params.put("isWFTrace", String.valueOf(isWFTrace == null ? 0 : isWFTrace));
        HashMap<String, Object> result = new HashMap();
        try {
            result = this.collaborationApi.transRepeal(affairId, params);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"transRepeal is exception", (Throwable)e);
            result.put("isSucess", false);
            result.put("errorMsg", e.getMessage());
        }
        return result;
    }

    @Override
    public boolean transSendColl(String sendType, Long templateId, Long formMasterId, Long parentSummaryId, Long newSumamryId) {
        try {
            Long senderId = AppContext.currentUserId();
            ColConstant.SendType colSendType = ColConstant.SendType.valueOf((String)sendType);
            if (colSendType == null) {
                LOGGER.error((Object)("transSendColl is error.sendType not found. params: sendType:" + sendType));
                return false;
            }
            this.collaborationApi.transSendColl(colSendType, templateId, senderId, formMasterId, parentSummaryId, newSumamryId);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"transSendColl is exception", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getColumnElementData(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        result.put("code", "1000");
        result.put("message", "the operation is success!!!");
        result.put("data", data);
        String bussId = (String)params.get(BUSS_ID);
        String templateId = (String)params.get(TEMPLATE_ID);
        String type = (String)params.get(TYPE);
        if (Strings.isBlank((String)type)) {
            result.put("code", "1001");
            result.put("message", String.format("this param %s is null!", TYPE));
            return result;
        }
        try {
            String templeteIds;
            if (Strings.isNotBlank((String)bussId)) {
                BizConfigBean bizConfig = this.businessManager4.findBizConfigById(Long.valueOf(bussId));
                JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u6d41\u7a0b\u5217\u8868", CAP4MonitorUtil.contactTag(bizConfig)});
            } else {
                Long formId = this.templateManager.getCtpTemplate(Long.valueOf(templateId)).getFormAppId();
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formId);
                FormBean formBean1 = this.cap4FormCacheManager.getForm(formId);
                if (null != bizConfigBean) {
                    JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u6d41\u7a0b\u5217\u8868", CAP4MonitorUtil.contactTag(bizConfigBean), CAP4MonitorUtil.contactTag(formBean1)});
                } else {
                    JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u6d41\u7a0b\u5217\u8868", CAP4MonitorUtil.contactTag(formBean1)});
                }
            }
            ArrayList<Long> templeteLongIds = new ArrayList<Long>();
            if (Strings.isNotBlank((String)bussId)) {
                StringBuilder templateIdsSb = new StringBuilder();
                List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(Long.valueOf(bussId));
                for (CAPFormDefinition formDefine : formList) {
                    FormBean fb = this.cap4FormCacheManager.getForm(formDefine.getId());
                    if (Enums.FormType.processesForm.getKey() != fb.getFormType()) continue;
                    List templateList = this.templateManager.getCtpTemplates(fb.getId().longValue(), false);
                    for (CtpTemplate ctpTemplate : templateList) {
                        templateIdsSb.append(ctpTemplate.getId()).append(",");
                        templeteLongIds.add(ctpTemplate.getId());
                    }
                }
                templeteIds = StringUtils.replaceLast((String)templateIdsSb.toString(), (String)",", (String)"");
            } else {
                templeteIds = templateId;
                templeteLongIds.add(Long.valueOf(templateId));
            }
            List<CAPBusinessConfigBO> capBusinessConfigBOs = this.capBusinessConfigManager.getCAPBusinessConfigBOsByPathIds(templeteLongIds);
            HashMap configParams = new HashMap();
            if (capBusinessConfigBOs != null) {
                for (CAPBusinessConfigBO capBusinessConfigBO : capBusinessConfigBOs) {
                    HashMap<String, Object> configParam = new HashMap<String, Object>();
                    Map<String, Object> dataInfo = capBusinessConfigBO.getDataInfo();
                    List fieldArray = (List)dataInfo.get("configedFields");
                    String[] fields = new String[fieldArray.size()];
                    for (int i = 0; i < fieldArray.size(); ++i) {
                        Map field = (Map)fieldArray.get(i);
                        if (Strings.isNotBlank((String)CAPParamUtil.getString((Map)field, (String)"display"))) {
                            configParam.put(CAPParamUtil.getString((Map)field, (String)"fieldName"), CAPParamUtil.getString((Map)field, (String)"display"));
                        }
                        fields[i] = CAPParamUtil.getString((Map)field, (String)"fieldName");
                    }
                    configParam.put("fields", fields);
                    configParams.put(capBusinessConfigBO.getPathId(), configParam);
                }
            }
            FlipInfo flipInfo = new FlipInfo(1, 20);
            Object configInfo = params.get("configInfo");
            if (configInfo != null) {
                Map configInfoMap = (Map)configInfo;
                if (configInfoMap.get(PAGE) != null) {
                    flipInfo.setPage(Integer.parseInt(String.valueOf(configInfoMap.get(PAGE))));
                }
                if (configInfoMap.get(PAGE_SIZE) != null) {
                    flipInfo.setSize(Integer.parseInt(String.valueOf(configInfoMap.get(PAGE_SIZE))));
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(TEMPLETE_IDS, templeteIds);
            if (params.get("userConditions") != null) {
                map.putAll((Map)params.get("userConditions"));
            }
            HashMap<String, PermissionVO> permission = new HashMap<String, PermissionVO>();
            List permissionVOs = this.permissionManager.getPermission(EnumNameEnum.col_flow_perm_policy.name(), Integer.valueOf(1), Long.valueOf(AppContext.currentAccountId()));
            for (PermissionVO permissionVO : permissionVOs) {
                permission.put(permissionVO.getLabel(), permissionVO);
            }
            if (ColOpenFrom.listPending.name().equals(type)) {
                flipInfo = this.collaborationApi.findPendingAffairs(flipInfo, map);
            } else if (ColOpenFrom.listDone.name().equals(type)) {
                flipInfo = this.collaborationApi.findDoneAffairs(flipInfo, map);
            } else if (ColOpenFrom.listSent.name().equals(type)) {
                flipInfo = this.collaborationApi.findSentAffairs(flipInfo, map);
            } else if (ColOpenFrom.listWaitSend.name().equals(type)) {
                flipInfo = this.collaborationApi.findWaitSentAffairs(flipInfo, map);
            }
            HashMap<Long, FormAuthViewBean> formAuthViewBeanMap = new HashMap<Long, FormAuthViewBean>();
            List colListSimpleVOs = flipInfo.getData();
            ArrayList<Map<String, Object>> flows = new ArrayList<Map<String, Object>>();
            data.put("flows", flows);
            block12: for (ColListSimpleVO colListSimpleVO : colListSimpleVOs) {
                CtpAffair ctpAffair;
                String multiViewStr;
                FormFlowListBO formFlowListBO = new FormFlowListBO();
                formFlowListBO.setCanDelete(colListSimpleVO.getCanReMove() != false ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                formFlowListBO.setCanForward(colListSimpleVO.getCanForward() != false ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                formFlowListBO.setSummaryId(colListSimpleVO.getSummaryId());
                formFlowListBO.setProcessId(colListSimpleVO.getProcessId());
                formFlowListBO.setActivityId(String.valueOf(colListSimpleVO.getActivityId()));
                formFlowListBO.setWorkitemId(String.valueOf(colListSimpleVO.getWorkitemId()));
                formFlowListBO.setFormViewOperation(colListSimpleVO.getFormViewOperation());
                formFlowListBO.setTemplateId(colListSimpleVO.getTempleteId().toString());
                formFlowListBO.setAffairId(String.valueOf(colListSimpleVO.getAffairId()));
                formFlowListBO.setIsRead(colListSimpleVO.getSubState() == 12 ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                formFlowListBO.setImgUrl(Functions.getAvatarImageUrl((Long)colListSimpleVO.getStartMemberId()));
                String[] titles = colListSimpleVO.getSubject().split("\\|");
                formFlowListBO.setTitle(titles != null && titles.length > 0 ? titles[0] : colListSimpleVO.getSubject());
                formFlowListBO.setSenderId(String.valueOf(colListSimpleVO.getStartMemberId()));
                formFlowListBO.setSender(colListSimpleVO.getStartMemberName());
                formFlowListBO.setSendTime(DateUtil.getDate((Date)colListSimpleVO.getStartDate(), (String)"yyyy-MM-dd HH:mm"));
                formFlowListBO.setReceiveTime(DateUtil.getDate((Date)colListSimpleVO.getReceiveTime(), (String)"yyyy-MM-dd HH:mm"));
                formFlowListBO.setParentHandler(colListSimpleVO.getPreApproverName());
                formFlowListBO.setHandleTerm(colListSimpleVO.getNodeDeadLineName());
                formFlowListBO.setReminders(String.valueOf(colListSimpleVO.getHastenTimes()));
                formFlowListBO.setHandleStateName(colListSimpleVO.getSubStateName());
                formFlowListBO.setHandleStateType(String.valueOf(colListSimpleVO.getSubState()));
                formFlowListBO.setCurrentNoteName(colListSimpleVO.getNodeName());
                formFlowListBO.setImportance(String.valueOf(colListSimpleVO.getImportantLevel()));
                formFlowListBO.setHasAttsFlag(colListSimpleVO.getHasAttsFlag() != false ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                formFlowListBO.setCurrentHandler(colListSimpleVO.getCurrentNodesInfo());
                formFlowListBO.setTrackState(colListSimpleVO.getIsTrack() != false ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                formFlowListBO.setFlowFinished(colListSimpleVO.getFlowFinished() != false ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                formFlowListBO.setCreateTime(DateUtil.getDate((Date)colListSimpleVO.getCreateDate(), (String)"yyyy-MM-dd"));
                formFlowListBO.setFlowTerm(colListSimpleVO.getProcessDeadLineName());
                formFlowListBO.setMasterDataId(String.valueOf(colListSimpleVO.getFormRecordid()));
                formFlowListBO.setCaseId(String.valueOf(colListSimpleVO.getCaseId()));
                formFlowListBO.setState(String.valueOf(colListSimpleVO.getState()));
                PermissionVO permissionVO = (PermissionVO)permission.get(formFlowListBO.getCurrentNoteName());
                formFlowListBO.setNoteType(permissionVO.getName());
                String basicOperation = permissionVO.getBasicOperation();
                String[] basicArray = basicOperation.split(",");
                List<String> basicList = Arrays.asList(basicArray);
                formFlowListBO.setHasOpinion(basicList.contains(OPINION) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                formFlowListBO.setHasAttitude(Strings.isNotBlank((String)permissionVO.getAttitude()) ? CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                flows.add(formFlowListBO.exportToJSon());
                if (!ColOpenFrom.listPending.name().equals(type)) continue;
                Map configParam = (Map)configParams.get(colListSimpleVO.getTempleteId().toString());
                if (configParam != null) {
                    Object formAppId = configParam.get("formAppId");
                    ArrayList<Long> ids = (ArrayList<Long>)configParam.get("ids");
                    if (formAppId == null) {
                        configParam.put("formAppId", colListSimpleVO.getFormAppId());
                    }
                    if (ids == null) {
                        ids = new ArrayList<Long>();
                        ids.add(colListSimpleVO.getFormRecordid());
                        configParam.put("ids", ids);
                    } else {
                        ids.add(colListSimpleVO.getFormRecordid());
                    }
                }
                if ((multiViewStr = (ctpAffair = this.affairManager.get(colListSimpleVO.getAffairId())).getMultiViewStr()).indexOf("_") <= -1 && multiViewStr.indexOf(".") <= -1) continue;
                FormBean formBean = this.cap4FormCacheManager.getForm(ctpAffair.getFormAppId());
                String[] viewStrs = multiViewStr.split("_");
                for (int i = 0; i < viewStrs.length; ++i) {
                    String rightIdStr = viewStrs[i].split("\\.")[1];
                    FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightIdStr)));
                    FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
                    if ((AppContext.getCurrentUser().getLoginSign() != Constants.login_sign.phone.value() || Enums.ViewType.Phone != formViewBean.getFormViewTypeEnum()) && (AppContext.getCurrentUser().getLoginSign() != Constants.login_sign.pc.value() || Enums.ViewType.SeeyonForm != formViewBean.getFormViewTypeEnum())) continue;
                    formAuthViewBeanMap.put(colListSimpleVO.getFormRecordid(), formAuthViewBean);
                    continue block12;
                }
            }
            data.put("size", String.valueOf(flipInfo.getTotal()));
            data.put(TYPE, type);
            HashMap formDatas = new HashMap();
            data.put("formDatas", formDatas);
            if (ColOpenFrom.listPending.name().equals(type)) {
                for (Map.Entry entry : configParams.entrySet()) {
                    String key = (String)entry.getKey();
                    Map configParam = (Map)configParams.get(key);
                    Long formAppId = (Long)configParam.get("formAppId");
                    if (formAppId == null) continue;
                    FormBean formBean = this.cap4FormCacheManager.getForm(formAppId);
                    List ids = (List)configParam.get("ids");
                    String[] fields = (String[])configParam.get("fields");
                    List<FormDataMasterBean> formDataMasterBeans = this.cap4FormDataDAO.selectMasterDataById(ids.toArray(new Long[ids.size()]), formBean.getMasterTableBean(), fields);
                    for (FormDataMasterBean formDataMasterBean : formDataMasterBeans) {
                        FormAuthViewBean formAuthViewBean = (FormAuthViewBean)formAuthViewBeanMap.get(formDataMasterBean.getId());
                        ArrayList formData = new ArrayList();
                        formDatas.put(String.valueOf(formDataMasterBean.getId()), formData);
                        for (int i = 0; i < fields.length; ++i) {
                            FormAuthViewFieldBean formAuthViewFieldBean = formAuthViewBean.getFormAuthorizationField(fields[i]);
                            HashMap<String, Object> displayField = new HashMap<String, Object>();
                            FormFieldBean formFieldBean = formBean.getFieldBeanByName(fields[i]);
                            Object[] values = formFieldBean.getDisplayValue(formDataMasterBean.getFieldValue(fields[i]));
                            displayField.put("fieldName", fields[i]);
                            displayField.put("display", configParam.get(fields[i]) == null ? formFieldBean.getDisplay() : configParam.get(fields[i]));
                            if (Enums.FieldAccessType.hide.getKey().equals(formAuthViewFieldBean.getAccess())) {
                                displayField.put("value", "***");
                                displayField.put("showValue", "***");
                            } else {
                                Object value = values[0];
                                if (value != null && (FormFieldComEnum.IMAGE_RADIO.getKey().equals(formFieldBean.getInputType()) || FormFieldComEnum.IMAGE_SELECT.getKey().equals(formFieldBean.getInputType()))) {
                                    CtpEnumItem ctpEnumItem = this.enumManagerNew.getCtpEnumItem((Long)value);
                                    if ("0".equals(String.valueOf(value)) || ctpEnumItem == null) {
                                        displayField.put("value", "");
                                        displayField.put("showValue", "");
                                    } else {
                                        StringBuilder sb = new StringBuilder(SystemEnvironment.getContextPath());
                                        sb.append("/fileUpload.do?method=showRTE&fileId=").append(ctpEnumItem.getImageId()).append("&type=image").append(Functions.csrfSuffix());
                                        displayField.put("value", value);
                                        displayField.put("showValue", sb.toString());
                                    }
                                } else {
                                    displayField.put("value", values[0]);
                                    displayField.put("showValue", values[1]);
                                }
                            }
                            displayField.put("inputType", formFieldBean.getInputType());
                            displayField.put("fieldType", formFieldBean.getFieldType());
                            formData.add(displayField);
                        }
                    }
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e);
            result.put("code", "1002");
            result.put("message", String.format("%s option exception!", "FormFlowListManagerImpl.BusinessException"));
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            LOGGER.error((Object)e);
            result.put("code", "1002");
            result.put("message", String.format("%s option exception!", "FormFlowListManagerImpl.selectMasterDataById.SQLException"));
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            JMTrackUtils.clearTrack();
        }
        return result;
    }

    @Override
    public List<String> checkForwardPermission(String affairIds) {
        try {
            return this.collaborationApi.checkForwardPermission(affairIds);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("checkForwardPermission.BusinessException, affairIds=" + affairIds), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getClassId() {
        return String.valueOf(CAPBusinessEnum.ColumnType.FLOW_LIST.getType());
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setCapBusinessConfigManager(CAPBusinessConfigManager capBusinessConfigManager) {
        this.capBusinessConfigManager = capBusinessConfigManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setAffairManager(AffairManager affairManager) {
        this.affairManager = affairManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }
}

