/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.FormQueryListManager;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.engine.api.bo.ReportConfig;
import com.seeyon.ctp.report.engine.api.bo.ReportQueryParams;
import com.seeyon.ctp.report.engine.api.bo.ReportResult;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class FormQueryListManagerImpl
extends AbstractColumnElementDataManager
implements FormQueryListManager {
    private static final Log LOGGER = CtpLogFactory.getLog(FormQueryListManagerImpl.class);
    private ReportApi reportApi;

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    @Override
    public String getClassId() {
        return String.valueOf(CAPBusinessEnum.ColumnType.QUERY_RESULT.getType());
    }

    @Override
    public Map<String, Object> getColumnElementData(Map<String, Object> params) {
        String queryId = MapUtils.getString(params, (Object)"queryId");
        if (StringUtils.isEmpty((String)queryId)) {
            return super.illegalArgumentError(queryId);
        }
        Long designId = Long.parseLong(queryId);
        Long memberId = AppContext.currentUserId();
        try {
            if (!this.reportApi.checkAuth(designId, memberId)) {
                return super.illegalAccessError();
            }
            HashMap data = Maps.newHashMap();
            if (params.containsKey("penetrate")) {
                data.put("queryPenetrate", this.getQueryPenetrate(MapUtils.getMap(params, (Object)"penetrate"), designId));
            } else {
                HashMap defaultValueMap = Maps.newHashMap();
                ArrayList finalUserConditions = Lists.newArrayList();
                List userConditions = (List)params.get("userConditions");
                FormSearchUtil.getMergeConditions(queryId, defaultValueMap, finalUserConditions, userConditions, true);
                ReportConfig reportConfig = this.reportApi.getReport(designId, memberId.longValue(), new HashMap());
                String init = MapUtils.getString(params, (Object)"init", (String)CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                if (StringUtils.equals((String)init, (String)CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey())) {
                    List filterFields = (List)reportConfig.get((Object)"filterFields");
                    reportConfig.put((Object)"filterFields", CAPFormUtil.getReportFilterFields(filterFields, defaultValueMap));
                } else {
                    reportConfig.remove((Object)"filterFields");
                }
                reportConfig.put((Object)"waterMark", CAPFormUtil.getWaterMark("report", null));
                data.put("queryInfo", reportConfig);
                ReportResult reportResult = this.getReportResult(params, designId, memberId, finalUserConditions);
                data.put("queryData", JSONUtil.parseJSONString((String)JSONUtil.toJSONString((Object)reportResult), ReportResult.class));
            }
            Map<String, Object> result = super.success();
            result.put("data", data);
            return result;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("FormQueryListManagerImpl.BusinessException params=" + params.toString()), (Throwable)e);
            return super.operationError("FormQueryListManagerImpl.BusinessException");
        }
    }

    private List<Map<String, Object>> getQueryPenetrate(Map<String, Object> penetrateObj, Long designId) throws BusinessException {
        HashMap params = Maps.newHashMap();
        params.put("rptDesignId", designId);
        params.put("extendParams", JSONUtil.toJSONString((Object)penetrateObj.get("rowParams")));
        List queryPenetrate = this.reportApi.getQueryPenetrate((Map)params);
        return Lists.transform((List)queryPenetrate, (Function)new Function<Map<String, Object>, Map<String, Object>>(){

            public Map<String, Object> apply(Map<String, Object> input) {
                String formType = MapUtils.getString(input, (Object)"formType");
                input.put("formType", formType);
                return input;
            }
        });
    }

    private ReportResult getReportResult(Map<String, Object> params, Long designId, Long memberId, List<Map<String, Object>> userConditions) throws BusinessException {
        List customCondition;
        Map configInfo = MapUtils.getMap(params, (Object)"configInfo", new HashMap());
        Integer page = MapUtils.getInteger((Map)configInfo, (Object)"page", (Integer)1);
        Integer size = MapUtils.getInteger((Map)configInfo, (Object)"pageSize", (Integer)50);
        ReportQueryParams reportQueryParams = new ReportQueryParams();
        reportQueryParams.put((Object)"designId", (Object)designId);
        reportQueryParams.put((Object)"userId", (Object)memberId);
        reportQueryParams.put((Object)"page", (Object)page);
        reportQueryParams.put((Object)"size", (Object)size);
        reportQueryParams.put((Object)"needTotal", (Object)true);
        reportQueryParams.put((Object)"userConditions", userConditions);
        List userOrderBy = (List)params.get("userOrderBy");
        if (userOrderBy != null) {
            reportQueryParams.put((Object)"customOrderFields", (Object)userOrderBy);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customCondition = (List)params.get("customCondition")))) {
            ArrayList customConditions = Lists.newArrayListWithCapacity((int)customCondition.size());
            for (Map map : customCondition) {
                Object fieldValue = map.get("fieldValue");
                if (!(fieldValue instanceof List) || ((List)fieldValue).size() <= 0) continue;
                customConditions.add(map);
            }
            reportQueryParams.setCustomCondition((List)customConditions);
        }
        return this.reportApi.findResult(reportQueryParams);
    }
}

