/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.task.ReportTaskExecuteManager;
import com.seeyon.cap4.task.ReportTaskExecuteManagerImpl;
import com.seeyon.cap4.template.cache.CAPReportGuavaCache;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.FormStatisticsManager;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.bo.ReportConfig;
import com.seeyon.ctp.report.engine.api.bo.ReportQueryParams;
import com.seeyon.ctp.report.engine.api.bo.ReportResult;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.report.engine.bean.DisplayField;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.songjian.utils.json.JSONArray;

public class FormStatisticsManagerImpl
extends AbstractColumnElementDataManager
implements FormStatisticsManager {
    private static final Log LOGGER = CtpLogFactory.getLog(FormStatisticsManagerImpl.class);
    private static final String MESSAGE5 = "startColumn greater than endColumn or startColumn less than 0 or endColumn less than 0!";
    private static final int CACHE_DATA_FLAG = 200;
    private static final int MAX_STATS_FIELDS_INDEX = 10;
    private static final String HAS_COLUMN_MERGE_FORMAT_DATA_KEY = "col_%s_%s_%s";
    private static final String NOT_COLUMN_MERGE_FORMAT_DATA_KEY = "%s_%s";
    private static final String STATISTICS_ID = "statisticsId";
    private static final String TYPE_TABLE = "table";
    private static final String TYPE_CHART = "chart";
    private static final String TYPE_GANTT_CHART = "ganttChart";
    private ReportApi reportApi;
    private ReportTaskExecuteManager reportTaskExecuteManager;

    @Override
    public Map<String, Object> getColumnElementData(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String statisticsId = ParamUtil.getString(params, (String)STATISTICS_ID);
        if (Strings.isBlank((String)statisticsId)) {
            result.put("code", "1001");
            result.put("message", String.format("this param %s is null!", STATISTICS_ID));
            return result;
        }
        try {
            if (this.reportApi.checkAuth(Long.valueOf(Long.parseLong(statisticsId)), Long.valueOf(AppContext.currentUserId()))) {
                int platform = ParamUtil.getInt(params, (String)"platform", (int)AppContext.getCurrentUser().getLoginSign());
                HashMap<String, Object> data = new HashMap<String, Object>();
                if (params.get("reqId") != null && params.get("cancelReport") != null && CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(params.get("cancelReport"))) {
                    this.reportTaskExecuteManager.cancelReport(CAPParamUtil.getString(params, (String)"reqId"));
                } else if (params.get("flowInfo") != null) {
                    data.put("flowInfo", CAPFormUtil.getFlowInfo((Map)params.get("flowInfo")));
                } else if (params.get("statsHistory") != null) {
                    data.put("statsHistoryList", this.getStatsHistoryList((Map)params.get("statsHistory"), statisticsId));
                } else {
                    String init = ParamUtil.getString(params, (String)"init", (String)CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                    HashMap<String, Map<String, Object>> defaultValueMap = new HashMap<String, Map<String, Object>>();
                    ArrayList<Map<String, Object>> finalUserConditions = new ArrayList<Map<String, Object>>();
                    FormSearchUtil.getMergeConditions(statisticsId, defaultValueMap, finalUserConditions, (List)params.get("userConditions"), true);
                    ReportConfig reportConfig = this.getFormStatisticsInfo(statisticsId, init, AppContext.currentUserId(), defaultValueMap);
                    reportConfig.put("waterMark", CAPFormUtil.getWaterMark("report", null));
                    if (ReportConstants.DesignType.SCHEDULEDSTATS.name().equals(String.valueOf(reportConfig.get("designType")))) {
                        this.getScheduledData(params, statisticsId, platform, data, (Map<String, Object>)reportConfig);
                    } else if (params.get("penetrate") == null) {
                        this.getStatisticeData(params, statisticsId, platform, data, (Map<String, Object>)reportConfig, finalUserConditions);
                    } else {
                        Map<String, Object> penetrateData = this.getPenetrateData(statisticsId, params.get("penetrate"), finalUserConditions);
                        data.put("statisticsPenetrate", penetrateData);
                    }
                }
                result.put("code", "1000");
                result.put("message", "the operation is success!!!");
                result.put("data", data);
            } else {
                LOGGER.info((Object)("FormStatisticsManagerImpl not auth option this statistics or this statistics not exist, params=" + params.toString()));
                result.put("code", "1004");
                result.put("message", "this option not auth or not exist!");
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("FormStatisticsManagerImpl.BusinessException params=" + params.toString()), (Throwable)e);
            result.put("code", "1002");
            result.put("message", String.format("%s option exception!", "FormStatisticsManagerImpl.BusinessException"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("FormStatisticsManagerImpl.UnsupportedEncodingException params=" + params.toString()), (Throwable)e);
            result.put("code", "1002");
            result.put("message", String.format("%s option exception!", "FormStatisticsManagerImpl.UnsupportedEncodingException"));
        }
        return result;
    }

    private void getStatisticeData(Map<String, Object> params, String statisticsId, int platform, Map<String, Object> data, Map<String, Object> reportConfig, List<Map<String, Object>> userConditions) throws BusinessException, UnsupportedEncodingException {
        Boolean sysConUseOrgVar = (Boolean)reportConfig.get("sysConUseOrgVar");
        if (params.get("refreshReport") != null && CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(ParamUtil.getString(params, (String)"refreshReport"))) {
            String cacheKey = this.getCacheKey(sysConUseOrgVar, statisticsId, userConditions, reportConfig, CAPBusinessEnum.ReportCacheKeyEnum.data);
            CAPReportGuavaCache.instance.remove(cacheKey);
        } else {
            Map configInfoMap = CAPParamUtil.getParamsMapByKey(params, (String)"configInfo");
            if (configInfoMap != null && configInfoMap.get("type") != null) {
                String cacheKey = this.getCacheKey(sysConUseOrgVar, statisticsId, userConditions, reportConfig, CAPBusinessEnum.ReportCacheKeyEnum.data);
                String cacheData = (String)CAPReportGuavaCache.instance.getCache(cacheKey);
                String type = String.valueOf(configInfoMap.get("type"));
                if (TYPE_TABLE.equalsIgnoreCase(type)) {
                    int endColumn;
                    int page = Constants.login_sign.phone.value() == platform ? ParamUtil.getInt((Map)configInfoMap, (String)"startRow", (int)1) : ParamUtil.getInt((Map)configInfoMap, (String)"page", (int)1);
                    int pageSize = ParamUtil.getInt((Map)configInfoMap, (String)"pageSize", (int)50);
                    int startColumn = ParamUtil.getInt((Map)configInfoMap, (String)"startColumn", (int)1);
                    if (startColumn > (endColumn = ParamUtil.getInt((Map)configInfoMap, (String)"endColumn", (int)(Constants.login_sign.phone.value() == platform ? 100 : 200)).intValue()) || startColumn < 0 || endColumn < 0) {
                        throw new BusinessException(MESSAGE5);
                    }
                    if (Strings.isBlank((String)cacheData)) {
                        if (this.getReportTaskData(params, statisticsId, data, userConditions, reportConfig)) {
                            Map resultData = (Map)data.get("result");
                            Map statisticsData = (Map)resultData.get("statisticsData");
                            if (((Boolean)statisticsData.get("canShow")).booleanValue()) {
                                Integer columnTotal = (Integer)statisticsData.get("columnTotal");
                                Integer rowTotal = (Integer)statisticsData.get("rowTotal");
                                if (columnTotal > 200 && rowTotal > 200) {
                                    this.saveReportCacheData(statisticsId, userConditions, sysConUseOrgVar, statisticsData, reportConfig);
                                    statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                                }
                                this.getCurrentPageDataListOfTable(page, pageSize, startColumn, endColumn, statisticsData, reportConfig, platform);
                            } else {
                                this.saveReportCacheData(statisticsId, userConditions, sysConUseOrgVar, statisticsData, reportConfig);
                                statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                            }
                        }
                    } else {
                        Map<String, Object> statisticsData = this.getReportCacheData(statisticsId, data, userConditions, reportConfig, sysConUseOrgVar);
                        Boolean canShow = (Boolean)statisticsData.get("canShow");
                        if (canShow.booleanValue()) {
                            this.getCurrentPageDataListOfTable(page, pageSize, startColumn, endColumn, statisticsData, reportConfig, platform);
                        }
                        statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                    }
                } else if (TYPE_CHART.equalsIgnoreCase(type)) {
                    List statsFieldsIndexs;
                    Integer page = ParamUtil.getInt((Map)configInfoMap, (String)"page");
                    Integer pageSize = ParamUtil.getInt((Map)configInfoMap, (String)"pageSize");
                    Integer colDataIndex = ParamUtil.getInt((Map)configInfoMap, (String)"colDataIndex", (int)0);
                    List list = statsFieldsIndexs = configInfoMap.get("statsFieldsIndex") == null ? null : (List)configInfoMap.get("statsFieldsIndex");
                    if (Strings.isBlank((String)cacheData)) {
                        if (this.getReportTaskData(params, statisticsId, data, userConditions, reportConfig)) {
                            Map resultData = (Map)data.get("result");
                            Map statisticsData = (Map)resultData.get("statisticsData");
                            if (((Boolean)statisticsData.get("canShow")).booleanValue()) {
                                Integer columnTotal = (Integer)statisticsData.get("columnTotal");
                                Integer rowTotal = (Integer)statisticsData.get("rowTotal");
                                if (columnTotal > 200 && rowTotal > 200) {
                                    this.saveReportCacheData(statisticsId, userConditions, sysConUseOrgVar, statisticsData, reportConfig);
                                    statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                                }
                                this.getCurrentPageDataListOfChart(page, pageSize, colDataIndex, statsFieldsIndexs, statisticsData, reportConfig);
                            } else {
                                this.saveReportCacheData(statisticsId, userConditions, sysConUseOrgVar, statisticsData, reportConfig);
                                statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                            }
                        }
                    } else {
                        Map<String, Object> statisticsData = this.getReportCacheData(statisticsId, data, userConditions, reportConfig, sysConUseOrgVar);
                        Boolean canShow = (Boolean)statisticsData.get("canShow");
                        if (canShow.booleanValue()) {
                            this.getCurrentPageDataListOfChart(page, pageSize, colDataIndex, statsFieldsIndexs, statisticsData, reportConfig);
                        }
                        statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                    }
                } else if (TYPE_GANTT_CHART.equalsIgnoreCase(type)) {
                    int page = ParamUtil.getInt((Map)configInfoMap, (String)"startRow", (int)1);
                    int pageSize = ParamUtil.getInt((Map)configInfoMap, (String)"pageSize", (int)50);
                    Integer colDataIndex = ParamUtil.getInt((Map)configInfoMap, (String)"colDataIndex", (int)0);
                    if (Strings.isBlank((String)cacheData)) {
                        if (this.getReportTaskData(params, statisticsId, data, userConditions, reportConfig)) {
                            Map resultData = (Map)data.get("result");
                            Map statisticsData = (Map)resultData.get("statisticsData");
                            if (((Boolean)statisticsData.get("canShow")).booleanValue()) {
                                Integer columnTotal = (Integer)statisticsData.get("columnTotal");
                                Integer rowTotal = (Integer)statisticsData.get("rowTotal");
                                if (columnTotal > 200 && rowTotal > 200) {
                                    this.saveReportCacheData(statisticsId, userConditions, sysConUseOrgVar, statisticsData, reportConfig);
                                    statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                                }
                                this.getCurrentPageDataListOfGanttChart(page, pageSize, colDataIndex, statisticsData, reportConfig);
                            } else {
                                this.saveReportCacheData(statisticsId, userConditions, sysConUseOrgVar, statisticsData, reportConfig);
                                statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                            }
                        }
                    } else {
                        Map<String, Object> statisticsData = this.getReportCacheData(statisticsId, data, userConditions, reportConfig, sysConUseOrgVar);
                        Boolean canShow = (Boolean)statisticsData.get("canShow");
                        if (canShow.booleanValue()) {
                            this.getCurrentPageDataListOfGanttChart(page, pageSize, colDataIndex, statisticsData, reportConfig);
                        }
                        statisticsData.put("lastCacheTime", CAPReportGuavaCache.instance.getCache(cacheKey));
                    }
                }
            } else {
                this.getReportTaskData(params, statisticsId, data, userConditions, reportConfig);
            }
        }
    }

    private void getData(Map<String, Object> data, Map<String, String> state, Map<String, Object> result) {
        data.put("state", state);
        data.put("result", result);
    }

    private void getScheduledData(Map<String, Object> params, String statisticsId, int platform, Map<String, Object> data, Map<String, Object> reportConfig) throws BusinessException, UnsupportedEncodingException {
        HashMap<String, String> state = new HashMap<String, String>();
        state.put("code", ReportTaskExecuteManagerImpl.ResultEnum.Ok.getKey());
        state.put("message", ResourceUtil.getString((String)"cap.statistics.task.result.enum.ok"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("statsHistoryList", this.getStatsHistoryList(null, statisticsId));
        String preview = ParamUtil.getString(params, (String)"preview");
        if (CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(preview)) {
            result.put("statisticsInfo", reportConfig);
            ReportResult reportResult = this.getFormStatisticsData(Long.valueOf(statisticsId), new ArrayList<Map<String, Object>>(), AppContext.currentUserId());
            result.put("statisticsData", reportResult);
            result.put("startDate", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm"));
            this.getScheduledstatsCurrentData(params, (Map<String, Object>)reportResult, reportConfig, platform);
        } else {
            ReportQueryParams reportQueryParams = new ReportQueryParams();
            reportQueryParams.put((Object)"designId", (Object)statisticsId);
            String schstatsStoreId = ParamUtil.getString(params, (String)"schstatsStoreId");
            if (Strings.isNotBlank((String)schstatsStoreId)) {
                reportQueryParams.put((Object)"schstatsStoreId", (Object)schstatsStoreId);
            }
            Map schStatsResult = this.reportApi.findSchStats(reportQueryParams);
            reportConfig = (Map)schStatsResult.get("reportConfig");
            if (((Boolean)schStatsResult.get("exist")).booleanValue()) {
                reportConfig.put("title", schStatsResult.get("title"));
                result.put("statisticsData", schStatsResult.get("data"));
                result.put("startDate", schStatsResult.get("startDate"));
                this.getScheduledstatsCurrentData(params, (Map)schStatsResult.get("data"), reportConfig, platform);
            } else {
                result.put("startDate", schStatsResult.get("nextStartTime"));
            }
            result.put("statisticsInfo", reportConfig);
        }
        this.getData(data, state, result);
    }

    private void getScheduledstatsCurrentData(Map<String, Object> params, Map<String, Object> statisticsData, Map<String, Object> reportConfig, int platform) throws BusinessException, UnsupportedEncodingException {
        Map configInfoMap = CAPParamUtil.getParamsMapByKey(params, (String)"configInfo");
        if (configInfoMap != null && configInfoMap.get("type") != null) {
            String type = String.valueOf(configInfoMap.get("type"));
            if (TYPE_TABLE.equalsIgnoreCase(type)) {
                int endColumn;
                int page = Constants.login_sign.phone.value() == platform ? ParamUtil.getInt((Map)configInfoMap, (String)"startRow", (int)1) : ParamUtil.getInt((Map)configInfoMap, (String)"page", (int)1);
                int pageSize = ParamUtil.getInt((Map)configInfoMap, (String)"pageSize", (int)50);
                int startColumn = ParamUtil.getInt((Map)configInfoMap, (String)"startColumn", (int)1);
                if (startColumn > (endColumn = ParamUtil.getInt((Map)configInfoMap, (String)"endColumn", (int)(Constants.login_sign.phone.value() == platform ? 100 : 200)).intValue()) || startColumn < 0 || endColumn < 0) {
                    throw new BusinessException(MESSAGE5);
                }
                this.getCurrentPageDataListOfTable(page, pageSize, startColumn, endColumn, statisticsData, reportConfig, platform);
            } else if (TYPE_CHART.equalsIgnoreCase(type)) {
                Integer page = ParamUtil.getInt((Map)configInfoMap, (String)"page");
                Integer pageSize = ParamUtil.getInt((Map)configInfoMap, (String)"pageSize");
                Integer colDataIndex = ParamUtil.getInt((Map)configInfoMap, (String)"colDataIndex", (int)0);
                List statsFieldsIndexs = configInfoMap.get("statsFieldsIndex") == null ? null : (List)configInfoMap.get("statsFieldsIndex");
                this.getCurrentPageDataListOfChart(page, pageSize, colDataIndex, statsFieldsIndexs, statisticsData, reportConfig);
            } else if (TYPE_GANTT_CHART.equalsIgnoreCase(type)) {
                int page = ParamUtil.getInt((Map)configInfoMap, (String)"startRow", (int)1);
                int pageSize = ParamUtil.getInt((Map)configInfoMap, (String)"pageSize", (int)50);
                Integer colDataIndex = ParamUtil.getInt((Map)configInfoMap, (String)"colDataIndex", (int)0);
                this.getCurrentPageDataListOfGanttChart(page, pageSize, colDataIndex, statisticsData, reportConfig);
            }
        }
    }

    private void saveReportCacheData(String statisticsId, List<Map<String, Object>> userConditions, Boolean sysConUseOrgVar, Map<String, Object> statisticsData, Map<String, Object> reportConfig) {
        String cacheKey = this.getCacheKey(sysConUseOrgVar, statisticsId, userConditions, reportConfig, CAPBusinessEnum.ReportCacheKeyEnum.data);
        CAPReportGuavaCache.instance.set(cacheKey, JSONUtil.toJSONString(statisticsData));
    }

    private Map<String, Object> getReportCacheData(String statisticsId, Map<String, Object> data, List<Map<String, Object>> userConditions, Map<String, Object> reportConfig, Boolean sysConUseOrgVar) {
        HashMap<String, String> stateMap = new HashMap<String, String>();
        stateMap.put("code", ReportTaskExecuteManagerImpl.ResultEnum.Ok.getKey());
        stateMap.put("message", ResourceUtil.getString((String)"cap.statistics.task.result.enum.ok"));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("statisticsInfo", reportConfig);
        String dataString = (String)CAPReportGuavaCache.instance.get(this.getCacheKey(sysConUseOrgVar, statisticsId, userConditions, reportConfig, CAPBusinessEnum.ReportCacheKeyEnum.data));
        Map statisticsData = (Map)JSONUtil.parseJSONString((String)dataString, Map.class);
        resultMap.put("statisticsData", statisticsData);
        this.getData(data, stateMap, resultMap);
        return statisticsData;
    }

    private void getCurrentPageDataListOfGanttChart(Integer page, Integer pageSize, Integer colDataIndex, Map<String, Object> statisticsData, Map<String, Object> reportConfig) throws UnsupportedEncodingException {
        List dataList = (List)statisticsData.get("data");
        String encoding = this.getRunningEncoding();
        HashMap<String, Integer> currentPageColumnValueMaxSize = new HashMap<String, Integer>();
        if (dataList == null || dataList.size() == 0) {
            this.getColumnValueMaxSizeOfNotData(reportConfig, currentPageColumnValueMaxSize, encoding);
            return;
        }
        int rowTotal = dataList.size() == 0 ? 0 : ((Boolean)reportConfig.get("rowMerge") != false ? dataList.size() - 1 : dataList.size());
        statisticsData.put("rowTotal", rowTotal);
        ArrayList<Map<String, Object>> currentPageData = new ArrayList<Map<String, Object>>();
        this.getRowHeaderPagingPage(page, pageSize, statisticsData, reportConfig, dataList, currentPageColumnValueMaxSize, currentPageData);
        statisticsData.put("data", currentPageData);
        List statsFields = (List)reportConfig.get("statsFields");
        List rowHeaders = (List)reportConfig.get("rowHeaders");
        if (reportConfig.get("colHeaders") != null) {
            reportConfig.put("colDataIndex", colDataIndex);
            ArrayList<String> dataKeys = new ArrayList<String>(statsFields.size());
            HashMap<String, DisplayField> dataKeyFieldsMap = new HashMap<String, DisplayField>();
            int j = statsFields.size();
            for (int i = 0; i < j; ++i) {
                DisplayField displayField = (DisplayField)statsFields.get(i);
                String dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, colDataIndex, displayField.getAliasTableName(), displayField.getName());
                dataKeys.add(dataKey);
                dataKeyFieldsMap.put(dataKey, displayField);
            }
            for (Map oneLineData : dataList) {
                for (DisplayField rowHeader : rowHeaders) {
                    String dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, rowHeader.getAliasTableName(), rowHeader.getName());
                    this.getMaxValueSize(rowHeader, currentPageColumnValueMaxSize, dataKey, oneLineData.get(dataKey), encoding);
                }
                for (String key : dataKeys) {
                    this.getMaxValueSize((DisplayField)dataKeyFieldsMap.get(key), currentPageColumnValueMaxSize, key, oneLineData.get(key), encoding);
                }
            }
            ArrayList newDatas = new ArrayList();
            for (Map map : currentPageData) {
                HashMap newOneLineData = new HashMap();
                newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                newOneLineData.put("rowType", map.get("rowType"));
                for (DisplayField rowHeader : rowHeaders) {
                    String dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, rowHeader.getAliasTableName(), rowHeader.getName());
                    newOneLineData.put(dataKey, map.get(dataKey));
                }
                for (String key : dataKeys) {
                    newOneLineData.put(key, map.get(key));
                }
                newDatas.add(newOneLineData);
            }
            statisticsData.put("data", newDatas);
        } else {
            for (Map oneLineDate : dataList) {
                for (DisplayField rowHeader : rowHeaders) {
                    String string = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, rowHeader.getAliasTableName(), rowHeader.getName());
                    this.getMaxValueSize(rowHeader, currentPageColumnValueMaxSize, string, oneLineDate.get(string), encoding);
                }
                for (DisplayField statsField : statsFields) {
                    String string = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, statsField.getAliasTableName(), statsField.getName());
                    this.getMaxValueSize(statsField, currentPageColumnValueMaxSize, string, oneLineDate.get(string), encoding);
                }
            }
        }
        reportConfig.put("columnValueMaxSize", currentPageColumnValueMaxSize);
    }

    /*
     * WARNING - void declaration
     */
    private void getCurrentPageDataListOfChart(Integer page, Integer pageSize, Integer colDataIndex, List<Integer> statsFieldsIndexs, Map<String, Object> statisticsData, Map<String, Object> reportConfig) {
        List dataList = (List)statisticsData.get("data");
        if (dataList == null || dataList.size() == 0) {
            return;
        }
        this.getTotalCalculation(statisticsData, reportConfig);
        Boolean groupMerge = (Boolean)reportConfig.get("groupMerge");
        if (groupMerge.booleanValue()) {
            Iterator iterator = dataList.iterator();
            while (iterator.hasNext()) {
                Map oneLineData = (Map)iterator.next();
                String rowType = String.valueOf(oneLineData.get("rowType"));
                if (!"0".equals(rowType)) continue;
                iterator.remove();
            }
        }
        ArrayList<Map<String, Object>> currentPageData = new ArrayList(page == null || pageSize == null ? dataList.size() : pageSize.intValue());
        if (page != null && pageSize != null) {
            this.getCurrentPageData(page, pageSize, dataList, currentPageData);
        } else {
            currentPageData = dataList;
        }
        statisticsData.put("data", currentPageData);
        ArrayList<DisplayField> currentDataStatsFields = new ArrayList<DisplayField>(10);
        reportConfig.put("currentDataStatsFields", currentDataStatsFields);
        List rowHeaders = (List)reportConfig.get("rowHeaders");
        List statsFields = (List)reportConfig.get("statsFields");
        int statsFieldsSize = statsFields.size();
        DisplayField headerField = (DisplayField)reportConfig.get("colHeaders");
        ArrayList newDatas = new ArrayList();
        ArrayList<String> dataKeys = new ArrayList<String>(10);
        if (headerField == null) {
            HashMap newOneLineData;
            String dataKey;
            DisplayField statsField;
            if (statsFieldsIndexs == null && statsFieldsSize <= 10) {
                currentDataStatsFields.addAll(statsFields);
                return;
            }
            if (statsFieldsIndexs == null && statsFieldsSize > 10) {
                for (int i = 0; i < 10; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    currentDataStatsFields.add(statsField);
                    dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                }
                for (Map map : currentPageData) {
                    newOneLineData = new HashMap();
                    newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                    newOneLineData.put("rowType", map.get("rowType"));
                    for (DisplayField displayField : rowHeaders) {
                        dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, displayField.getAliasTableName(), displayField.getName());
                        newOneLineData.put(dataKey, map.get(dataKey));
                    }
                    for (String string : dataKeys) {
                        newOneLineData.put(string, map.get(string));
                    }
                    newDatas.add(newOneLineData);
                }
            }
            if (null != statsFieldsIndexs && Strings.isNotEmpty(statsFieldsIndexs)) {
                void var21_32;
                int indexCount = statsFieldsIndexs.size();
                boolean bl = false;
                while (var21_32 < indexCount) {
                    int n = statsFieldsIndexs.get((int)var21_32);
                    statsField = (DisplayField)statsFields.get(n);
                    currentDataStatsFields.add(statsField);
                    dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                    ++var21_32;
                }
                for (Map map : currentPageData) {
                    newOneLineData = new HashMap();
                    newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                    newOneLineData.put("rowType", map.get("rowType"));
                    for (DisplayField rowHeader : rowHeaders) {
                        dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, rowHeader.getAliasTableName(), rowHeader.getName());
                        newOneLineData.put(dataKey, map.get(dataKey));
                    }
                    for (String key : dataKeys) {
                        newOneLineData.put(key, map.get(key));
                    }
                    newDatas.add(newOneLineData);
                }
            }
        } else {
            HashMap newOneLineData;
            String dataKey;
            DisplayField statsField;
            reportConfig.put("colDataIndex", colDataIndex);
            if (statsFieldsIndexs == null && statsFieldsSize <= 10) {
                currentDataStatsFields.addAll(statsFields);
                for (int i = 0; i < statsFieldsSize; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, colDataIndex, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                }
                for (Map map : currentPageData) {
                    newOneLineData = new HashMap();
                    newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                    newOneLineData.put("rowType", map.get("rowType"));
                    for (DisplayField displayField : rowHeaders) {
                        dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, displayField.getAliasTableName(), displayField.getName());
                        newOneLineData.put(dataKey, map.get(dataKey));
                    }
                    for (String string : dataKeys) {
                        newOneLineData.put(string, map.get(string));
                    }
                    newDatas.add(newOneLineData);
                }
            }
            if (statsFieldsIndexs == null && statsFieldsSize > 10) {
                for (int i = 0; i < 10; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    currentDataStatsFields.add(statsField);
                    dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, colDataIndex, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                }
                for (Map map : currentPageData) {
                    newOneLineData = new HashMap();
                    newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                    newOneLineData.put("rowType", map.get("rowType"));
                    for (DisplayField displayField : rowHeaders) {
                        dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, displayField.getAliasTableName(), displayField.getName());
                        newOneLineData.put(dataKey, map.get(dataKey));
                    }
                    for (String string : dataKeys) {
                        newOneLineData.put(string, map.get(string));
                    }
                    newDatas.add(newOneLineData);
                }
            }
            if (null != statsFieldsIndexs && Strings.isNotEmpty(statsFieldsIndexs)) {
                void var21_38;
                int indexCount = statsFieldsIndexs.size();
                boolean bl = false;
                while (var21_38 < indexCount) {
                    int n = statsFieldsIndexs.get((int)var21_38);
                    statsField = (DisplayField)statsFields.get(n);
                    currentDataStatsFields.add(statsField);
                    dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, colDataIndex, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                    ++var21_38;
                }
                for (Map map : currentPageData) {
                    newOneLineData = new HashMap();
                    newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                    newOneLineData.put("rowType", map.get("rowType"));
                    for (DisplayField rowHeader : rowHeaders) {
                        dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, rowHeader.getAliasTableName(), rowHeader.getName());
                        newOneLineData.put(dataKey, map.get(dataKey));
                    }
                    for (String key : dataKeys) {
                        newOneLineData.put(key, map.get(key));
                    }
                    newDatas.add(newOneLineData);
                }
            }
        }
        statisticsData.put("data", newDatas);
    }

    private void getMaxValueSize(DisplayField displayField, Map<String, Integer> columnValueMaxSize, String dataKey, Object value, String encoding) throws UnsupportedEncodingException {
        int valueSize;
        int valueDisplayLength = valueSize = displayField.getAliasDisplay().getBytes(encoding).length;
        if (value == null) {
            valueDisplayLength = 0;
        } else if (value instanceof Object[]) {
            valueDisplayLength = String.valueOf(((Object[])value)[0]).getBytes(encoding).length;
        } else if (value instanceof JSONArray) {
            valueDisplayLength = String.valueOf(((Object[])JSONUtil.parseJSONString((String)JSONUtil.toJSONString((Object)value), Object[].class))[0]).getBytes(encoding).length;
        } else if (value instanceof ArrayList) {
            valueDisplayLength = String.valueOf(((List)value).get(0)).getBytes(encoding).length;
        }
        if (columnValueMaxSize.get(dataKey) == null) {
            if (valueDisplayLength > valueSize) {
                columnValueMaxSize.put(dataKey, valueDisplayLength);
            } else {
                columnValueMaxSize.put(dataKey, valueSize);
            }
        } else if (columnValueMaxSize.get(dataKey) < valueDisplayLength) {
            columnValueMaxSize.put(dataKey, valueDisplayLength);
        }
    }

    private void getColumnValueMaxSizeOfNotData(Map<String, Object> reportConfig, Map<String, Integer> currentPageColumnValueMaxSize, String encoding) throws UnsupportedEncodingException {
        int size;
        String key;
        List statsFields = (List)reportConfig.get("statsFields");
        for (DisplayField displayField : statsFields) {
            key = displayField.getAliasTableName() + "_" + displayField.getName();
            size = displayField.getAliasDisplay().getBytes(encoding).length;
            currentPageColumnValueMaxSize.put(key, size);
        }
        List rowHeaders = (List)reportConfig.get("rowHeaders");
        for (DisplayField displayField : rowHeaders) {
            key = displayField.getAliasTableName() + "_" + displayField.getName();
            size = displayField.getAliasDisplay().getBytes(encoding).length;
            currentPageColumnValueMaxSize.put(key, size);
        }
        reportConfig.put("columnValueMaxSize", currentPageColumnValueMaxSize);
    }

    private void getCurrentPageDataListOfTable(int page, int pageSize, int startColumn, int endColumn, Map<String, Object> statisticsData, Map<String, Object> reportConfig, int platform) throws UnsupportedEncodingException {
        int statsFieldsSize;
        List dataList = (List)statisticsData.get("data");
        String encoding = this.getRunningEncoding();
        HashMap<String, Integer> currentPageColumnValueMaxSize = new HashMap<String, Integer>();
        if (dataList == null || dataList.size() == 0) {
            this.getColumnValueMaxSizeOfNotData(reportConfig, currentPageColumnValueMaxSize, encoding);
            return;
        }
        statisticsData.put("rowTotal", dataList.size());
        ArrayList<Map<String, Object>> currentPageData = new ArrayList<Map<String, Object>>();
        if (Constants.login_sign.pc.value() == platform) {
            this.getCurrentPageData(page, pageSize, dataList, currentPageData);
        } else if (Constants.login_sign.phone.value() == platform) {
            this.getRowHeaderPagingPage(page, pageSize, statisticsData, reportConfig, dataList, currentPageColumnValueMaxSize, currentPageData);
        }
        int colDataSize = 1;
        DisplayField headerField = (DisplayField)reportConfig.get("colHeaders");
        if (headerField != null) {
            colDataSize = ((List)statisticsData.get("colData")).size();
        }
        List statsFields = (List)reportConfig.get("statsFields");
        int columnTotal = statsFieldsSize = statsFields.size();
        Boolean hasColumnMerge = (Boolean)reportConfig.get("columnMerge");
        columnTotal = hasColumnMerge != false ? colDataSize * statsFieldsSize + statsFieldsSize : colDataSize * statsFieldsSize;
        endColumn = endColumn > columnTotal ? columnTotal : endColumn;
        statisticsData.put("columnTotal", columnTotal);
        ArrayList newCurrentPageDatas = new ArrayList();
        List rowHeaders = (List)reportConfig.get("rowHeaders");
        String dataKey = "";
        if (headerField == null) {
            if (endColumn > statsFieldsSize) {
                endColumn = statsFieldsSize;
            }
            for (Map map : currentPageData) {
                HashMap newOneLineData = new HashMap();
                newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                newOneLineData.put("rowType", map.get("rowType"));
                for (DisplayField headerField1 : rowHeaders) {
                    dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, headerField1.getAliasTableName(), headerField1.getName());
                    Object value = map.get(dataKey);
                    newOneLineData.put(dataKey, value);
                    this.getMaxValueSize(headerField1, currentPageColumnValueMaxSize, dataKey, value, encoding);
                }
                for (int i = startColumn - 1; i < endColumn; ++i) {
                    DisplayField statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, statsField.getAliasTableName(), statsField.getName());
                    Object value = map.get(dataKey);
                    newOneLineData.put(dataKey, value);
                    this.getMaxValueSize(statsField, currentPageColumnValueMaxSize, dataKey, value, encoding);
                }
                newCurrentPageDatas.add(newOneLineData);
            }
            statisticsData.put("startFieldIndex", startColumn - 1);
            statisticsData.put("endFieldIndex", endColumn - 1);
        } else {
            int j;
            int i;
            DisplayField statsField;
            int n;
            int startColumnIndex = startColumn - 1 == 0 ? 0 : startColumn - 1;
            int n2 = startColumn / statsFieldsSize;
            int startFieldsIndex = startColumn % statsFieldsSize - 1;
            if (startColumn % statsFieldsSize == 0) {
                n = n2 - 1;
                startFieldsIndex = statsFieldsSize - 1;
            }
            int endColumnIndex = endColumn - 1 == 0 ? 0 : endColumn - 1;
            int endColDataIndex = endColumn / statsFieldsSize;
            int endFieldsIndex = endColumn % statsFieldsSize - 1;
            if (endColumn % statsFieldsSize == 0) {
                --endColDataIndex;
                endFieldsIndex = statsFieldsSize - 1;
            }
            HashMap<String, Boolean> columnMargeKeys = new HashMap<String, Boolean>(statsFieldsSize);
            HashMap<String, Boolean> startColKeys = new HashMap<String, Boolean>(statsFieldsSize);
            HashMap<String, Boolean> endColKeys = new HashMap<String, Boolean>(statsFieldsSize);
            ArrayList<String> dataKeys = new ArrayList<String>();
            if (startColumnIndex == endColumnIndex && n == endColDataIndex && startFieldsIndex == endFieldsIndex && endColumnIndex < colDataSize * statsFieldsSize) {
                statsField = (DisplayField)statsFields.get(startFieldsIndex);
                dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, n, statsField.getAliasTableName(), statsField.getName());
                dataKeys.add(dataKey);
                startColKeys.put(dataKey, true);
                endColKeys.put(dataKey, true);
                statisticsData.put("startColDataIndex", n);
                statisticsData.put("endColDataIndex", endColDataIndex);
                statisticsData.put("startColKeys", startColKeys);
                statisticsData.put("endColKeys", endColKeys);
            }
            if (startColumnIndex == endColumnIndex && n == endColDataIndex && startFieldsIndex == endFieldsIndex && endColumnIndex >= colDataSize * statsFieldsSize) {
                statsField = (DisplayField)statsFields.get(startFieldsIndex);
                dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, statsField.getAliasTableName(), statsField.getName());
                dataKeys.add(dataKey);
                columnMargeKeys.put(dataKey, true);
                statisticsData.put("columnMargeKeys", columnMargeKeys);
            }
            if (startColumnIndex < endColumnIndex && n == endColDataIndex && startFieldsIndex < endFieldsIndex && endColumnIndex < colDataSize * statsFieldsSize) {
                for (i = startFieldsIndex; i <= endFieldsIndex; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, n, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                    startColKeys.put(dataKey, true);
                    endColKeys.put(dataKey, true);
                }
                statisticsData.put("startColDataIndex", n);
                statisticsData.put("endColDataIndex", endColDataIndex);
                statisticsData.put("startColKeys", startColKeys);
                statisticsData.put("endColKeys", endColKeys);
            }
            if (startColumnIndex < endColumnIndex && n == endColDataIndex && startFieldsIndex < endFieldsIndex && endColumnIndex >= colDataSize * statsFieldsSize) {
                for (i = startFieldsIndex; i <= endFieldsIndex; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                    columnMargeKeys.put(dataKey, true);
                }
                statisticsData.put("columnMargeKeys", columnMargeKeys);
            }
            if (startColumnIndex < endColumnIndex && n < endColDataIndex && endColumnIndex < colDataSize * statsFieldsSize) {
                for (i = startFieldsIndex; i < statsFieldsSize; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, n, statsField.getAliasTableName(), statsField.getName());
                    startColKeys.put(dataKey, true);
                    dataKeys.add(dataKey);
                }
                if (endColDataIndex - n > 1) {
                    for (i = n; i <= endColDataIndex; ++i) {
                        for (j = 0; j < statsFieldsSize; ++j) {
                            statsField = (DisplayField)statsFields.get(j);
                            dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, i, statsField.getAliasTableName(), statsField.getName());
                            dataKeys.add(dataKey);
                        }
                    }
                }
                for (i = 0; i <= endFieldsIndex; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, endColDataIndex, statsField.getAliasTableName(), statsField.getName());
                    endColKeys.put(dataKey, true);
                    dataKeys.add(dataKey);
                }
                statisticsData.put("startColDataIndex", n);
                statisticsData.put("endColDataIndex", endColDataIndex);
                statisticsData.put("startColKeys", startColKeys);
                statisticsData.put("endColKeys", endColKeys);
            }
            if (startColumnIndex < endColumnIndex && n < endColDataIndex && endColumnIndex >= colDataSize * statsFieldsSize) {
                for (i = startFieldsIndex; i < statsFieldsSize; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, n, statsField.getAliasTableName(), statsField.getName());
                    startColKeys.put(dataKey, true);
                    dataKeys.add(dataKey);
                }
                if (endColDataIndex - n > 1) {
                    for (i = n; i < endColDataIndex; ++i) {
                        for (j = 0; j < statsFieldsSize; ++j) {
                            statsField = (DisplayField)statsFields.get(j);
                            dataKey = String.format(HAS_COLUMN_MERGE_FORMAT_DATA_KEY, i, statsField.getAliasTableName(), statsField.getName());
                            dataKeys.add(dataKey);
                        }
                    }
                }
                for (i = 0; i <= endFieldsIndex; ++i) {
                    statsField = (DisplayField)statsFields.get(i);
                    dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, statsField.getAliasTableName(), statsField.getName());
                    dataKeys.add(dataKey);
                    columnMargeKeys.put(dataKey, true);
                }
                statisticsData.put("startColDataIndex", n);
                statisticsData.put("startColKeys", startColKeys);
                statisticsData.put("columnMargeKeys", columnMargeKeys);
            }
            HashMap<String, DisplayField> statsFieldMap = new HashMap<String, DisplayField>(statsFields.size());
            for (DisplayField displayField : statsFields) {
                String key = displayField.getAliasTableName() + "_" + displayField.getName();
                statsFieldMap.put(key, displayField);
            }
            for (Map map : currentPageData) {
                HashMap newOneLineData = new HashMap();
                newOneLineData.put("rowSumKey", map.get("rowSumKey"));
                newOneLineData.put("rowType", map.get("rowType"));
                for (DisplayField headerField1 : rowHeaders) {
                    dataKey = String.format(NOT_COLUMN_MERGE_FORMAT_DATA_KEY, headerField1.getAliasTableName(), headerField1.getName());
                    Object value = map.get(dataKey);
                    newOneLineData.put(dataKey, value);
                    this.getMaxValueSize(headerField1, currentPageColumnValueMaxSize, dataKey, value, encoding);
                }
                if (!dataKeys.isEmpty()) {
                    for (String dk : dataKeys) {
                        String key;
                        Object value = map.get(dk);
                        newOneLineData.put(dk, value);
                        if (dk.startsWith("col_")) {
                            String startStr = "col_" + dk.split("col_")[1].split("_")[0] + "_";
                            key = dk.split(startStr)[1];
                        } else {
                            key = dk;
                        }
                        DisplayField displayField = (DisplayField)statsFieldMap.get(key);
                        this.getMaxValueSize(displayField, currentPageColumnValueMaxSize, dk, value, encoding);
                    }
                }
                newCurrentPageDatas.add(newOneLineData);
            }
            if (endColDataIndex >= colDataSize) {
                endColDataIndex = colDataSize - 1;
            }
            if (startColumnIndex >= colDataSize * statsFieldsSize && endColumnIndex >= colDataSize * statsFieldsSize) {
                statisticsData.put("colData", new ArrayList());
            } else {
                ArrayList newColDataList = new ArrayList(endColDataIndex - n + 1);
                List list = (List)statisticsData.get("colData");
                endColDataIndex = endColDataIndex <= 0 ? 0 : endColDataIndex;
                for (int i2 = n; i2 <= endColDataIndex; ++i2) {
                    newColDataList.add(list.get(i2));
                }
                statisticsData.put("colData", newColDataList);
            }
        }
        statisticsData.put("data", newCurrentPageDatas);
        reportConfig.put("columnValueMaxSize", currentPageColumnValueMaxSize);
    }

    private void getRowHeaderPagingPage(int page, int pageSize, Map<String, Object> statisticsData, Map<String, Object> reportConfig, List<Map<String, Object>> dataList, Map<String, Integer> currentPageColumnValueMaxSize, List<Map<String, Object>> currentPageData) throws UnsupportedEncodingException {
        if (page == 1 && ((Boolean)reportConfig.get("rowMerge")).booleanValue()) {
            statisticsData.put("rowMergeData", dataList.get(dataList.size() - 1));
            statisticsData.put("startRow", page);
        }
        if (((Boolean)reportConfig.get("rowMerge")).booleanValue()) {
            dataList.remove(dataList.size() - 1);
        }
        if (page <= dataList.size()) {
            int pageIndex = page - 1;
            for (int i = 0; i < pageSize; ++i) {
                currentPageData.add(dataList.get(pageIndex));
                if (pageIndex == dataList.size() - 1) break;
                ++pageIndex;
            }
        }
        if (currentPageData.size() == 0) {
            String encoding = this.getRunningEncoding();
            this.getColumnValueMaxSizeOfNotData(reportConfig, currentPageColumnValueMaxSize, encoding);
        }
        if (currentPageData.size() > 0) {
            Map<String, Object> currenData;
            int i;
            List rowHeaders = (List)reportConfig.get("rowHeaders");
            if (((Boolean)reportConfig.get("rowMerge")).booleanValue() && ((Boolean)reportConfig.get("groupMerge")).booleanValue() && rowHeaders.size() >= 2) {
                Map<String, Object> currenPageLastData = currentPageData.get(currentPageData.size() - 1);
                Object rowType = currenPageLastData.get("rowType");
                Object rowSumKey = currenPageLastData.get("rowSumKey");
                DisplayField secontHeaderField = (DisplayField)rowHeaders.get(1);
                String secondRowSumKey = secontHeaderField.getAliasTableName() + "_" + secontHeaderField.getName();
                if (rowType == null || "0".equals(String.valueOf(rowType)) && !String.valueOf(secondRowSumKey).equals(String.valueOf(rowSumKey))) {
                    for (i = page + pageSize - 1; i < dataList.size(); ++i) {
                        currenData = dataList.get(i);
                        rowType = currenData.get("rowType");
                        rowSumKey = currenData.get("rowSumKey");
                        if (rowType != null && "0".equals(String.valueOf(rowType)) && String.valueOf(secondRowSumKey).equals(String.valueOf(rowSumKey))) {
                            currentPageData.add(currenData);
                            break;
                        }
                        currentPageData.add(currenData);
                    }
                }
            }
            if (((Boolean)reportConfig.get("groupMerge")).booleanValue() && !((Boolean)reportConfig.get("rowMerge")).booleanValue()) {
                Map<String, Object> currenPageLastData = currentPageData.get(currentPageData.size() - 1);
                DisplayField firstHeaderField = (DisplayField)rowHeaders.get(0);
                String key = firstHeaderField.getAliasTableName() + "_" + firstHeaderField.getName();
                Object value = currenPageLastData.get(key);
                String valueString = "";
                if (value instanceof Object[]) {
                    valueString = String.valueOf(((Object[])value)[0]);
                } else if (value instanceof JSONArray) {
                    valueString = String.valueOf(((Object[])JSONUtil.parseJSONString((String)JSONUtil.toJSONString((Object)value), Object[].class))[0]);
                }
                for (i = page + pageSize - 1; i < dataList.size(); ++i) {
                    currenData = dataList.get(i);
                    Object tempValue = currenData.get(key);
                    String tempValueString = "";
                    if (tempValue instanceof Object[]) {
                        tempValueString = String.valueOf(((Object[])tempValue)[0]);
                    } else if (tempValue instanceof JSONArray) {
                        tempValueString = String.valueOf(((Object[])JSONUtil.parseJSONString((String)JSONUtil.toJSONString((Object)tempValue), Object[].class))[0]);
                    }
                    if (!valueString.equals(tempValueString)) break;
                    currentPageData.add(currenData);
                }
            }
        }
    }

    private void getCurrentPageData(int page, int pageSize, List<Map<String, Object>> dataList, List<Map<String, Object>> currentPageData) {
        int startIndex;
        int n = startIndex = (page - 1) * pageSize == 0 ? 0 : (page - 1) * pageSize;
        if (startIndex >= dataList.size()) {
            return;
        }
        if (startIndex < dataList.size()) {
            for (int i = 0; i < pageSize; ++i) {
                currentPageData.add(dataList.get(startIndex));
                if (startIndex == dataList.size() - 1) break;
                ++startIndex;
            }
        }
    }

    private boolean getReportTaskData(Map<String, Object> params, String statisticsId, Map<String, Object> data, List<Map<String, Object>> userConditions, Map<String, Object> reportConfig) throws BusinessException {
        Map<String, Object> reportResult;
        boolean isOk = false;
        String reqId = CAPParamUtil.getString(params, (String)"reqId");
        if (Strings.isBlank((String)reqId)) {
            reqId = String.valueOf(UUIDLong.longUUID());
            HashMap<String, Object> request = new HashMap<String, Object>();
            HashMap<String, Object> reqParamsKey = new HashMap<String, Object>();
            request.put("reqId", reqId);
            request.put("params", reqParamsKey);
            reqParamsKey.put("designId", statisticsId);
            reqParamsKey.put("userConditions", userConditions);
            reqParamsKey.put("userId", String.valueOf(AppContext.currentUserId()));
            reportResult = this.reportTaskExecuteManager.addReportReq(request);
        } else {
            reportResult = this.reportTaskExecuteManager.getReport(reqId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> state = new HashMap<String, String>();
        state.put("reqId", reqId);
        String code = String.valueOf(reportResult.get("code"));
        state.put("code", code);
        ReportTaskExecuteManagerImpl.ResultEnum resultEnum = ReportTaskExecuteManagerImpl.ResultEnum.getEnumByKey(code);
        switch (resultEnum) {
            case Ok: {
                state.put("message", ResourceUtil.getString((String)"cap.statistics.task.result.enum.ok"));
                result.put("statisticsInfo", reportConfig);
                Map statisticsData = (Map)reportResult.get("data");
                if (((Boolean)statisticsData.get("canShow")).booleanValue()) {
                    this.getTotalCalculation(statisticsData, reportConfig);
                }
                result.put("statisticsData", statisticsData);
                isOk = true;
                break;
            }
            case Wait: {
                state.put("message", ResourceUtil.getString((String)"cap.statistics.task.result.enum.wait"));
                state.put("taskCount", String.valueOf(this.reportTaskExecuteManager.getCurentTaskBeforeCount(reqId)));
                break;
            }
            case Retry: {
                state.put("message", ResourceUtil.getString((String)"cap.statistics.task.result.enum.retry"));
                state.put("taskCount", String.valueOf(this.reportTaskExecuteManager.getTaskQueueSize()));
                break;
            }
            case Fail: {
                state.put("message", ResourceUtil.getString((String)"cap.statistics.task.result.enum.fail"));
                break;
            }
        }
        this.getData(data, state, result);
        return isOk;
    }

    private void getTotalCalculation(Map<String, Object> statisticsData, Map<String, Object> reportConfig) {
        int statsFieldsSize;
        int colDataSize = 1;
        if (reportConfig.get("colHeaders") != null) {
            colDataSize = ((List)statisticsData.get("colData")).size();
        }
        int columnTotal = statsFieldsSize = ((List)reportConfig.get("statsFields")).size();
        Boolean hasColumnMerge = (Boolean)reportConfig.get("columnMerge");
        if (!hasColumnMerge.booleanValue()) {
            columnTotal = colDataSize * statsFieldsSize;
        }
        if (hasColumnMerge.booleanValue()) {
            columnTotal = colDataSize * statsFieldsSize + statsFieldsSize;
        }
        statisticsData.put("columnTotal", columnTotal);
        statisticsData.put("rowTotal", ((List)statisticsData.get("data")).size());
    }

    private Object getStatsHistoryList(Map<String, Object> statsHistory, String statisticsId) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("designId", Long.parseLong(statisticsId));
        if (statsHistory != null) {
            requestParams.put("page", statsHistory.get("page") == null ? 1 : Integer.parseInt(String.valueOf(statsHistory.get("page"))));
            requestParams.put("size", statsHistory.get("size") == null ? 20 : Integer.parseInt(String.valueOf(statsHistory.get("size"))));
            if (statsHistory.get("title") != null) {
                requestParams.put("title", statsHistory.get("title"));
            }
        }
        List statsHstoryList = this.reportApi.findSchStatsList(requestParams);
        return JSONUtil.parseJSONString((String)JSONUtil.toJSONString((Object)statsHstoryList));
    }

    private ReportConfig getFormStatisticsInfo(String designId, String init, long userId, Map<String, Map<String, Object>> defaultValueMap) throws BusinessException {
        HashMap paramsMap = new HashMap();
        ReportConfig statisticsInfo = this.reportApi.getReport(Long.valueOf(designId), userId, paramsMap);
        if (CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(init)) {
            List<Map<String, Object>> filterFieldJsonArray = CAPFormUtil.getReportFilterFields((List)statisticsInfo.get((Object)"filterFields"), defaultValueMap);
            statisticsInfo.put((Object)"filterFields", filterFieldJsonArray);
        } else {
            statisticsInfo.remove((Object)"filterFields");
        }
        return statisticsInfo;
    }

    private ReportResult getFormStatisticsData(Long designId, List<Map<String, Object>> userConditions, long userId) throws BusinessException {
        ReportQueryParams params = new ReportQueryParams();
        params.put((Object)"designId", (Object)designId);
        params.put((Object)"userId", (Object)userId);
        params.put((Object)"userConditions", userConditions);
        ReportResult reportData = this.reportApi.findResult(params);
        return reportData;
    }

    private Map<String, Object> getPenetrateData(String designId, Object penetrate, List<Map<String, Object>> userConditions) throws BusinessException {
        Map penetrateJson = (Map)penetrate;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> listTitleParam = new HashMap<String, Object>();
        listTitleParam.put("rptDesignId", Long.parseLong(designId));
        listTitleParam.put("statisticItem", JSONUtil.toJSONString(penetrateJson.get("statisticItem")));
        Map listTitle = this.reportApi.getStatsPenetrate(listTitleParam);
        result.put("listTitle", listTitle);
        HashMap<String, Object> listDataParam = new HashMap<String, Object>();
        Integer page = penetrateJson.get("page") == null ? 1 : Integer.parseInt(String.valueOf(penetrateJson.get("page")));
        Integer pageSize = penetrateJson.get("pageSize") == null ? 50 : Integer.parseInt(String.valueOf(penetrateJson.get("pageSize")));
        FlipInfo flipInfo = new FlipInfo();
        flipInfo.setPage(page.intValue());
        flipInfo.setSize(pageSize.intValue());
        listDataParam.put("rptDesignId", Long.parseLong(designId));
        listDataParam.put("rowData", penetrateJson.get("rowData"));
        listDataParam.put("colData", penetrateJson.get("colData"));
        listDataParam.put("statisticItem", penetrateJson.get("statisticItem"));
        listDataParam.put("userConditions", userConditions);
        flipInfo = this.reportApi.getStatsPenetrateData(flipInfo, listDataParam);
        result.put("listData", JSONUtil.parseJSONString((String)JSONUtil.toJSONString((Object)flipInfo.getData())));
        result.put("size", String.valueOf(flipInfo.getTotal()));
        return result;
    }

    private String getCacheKey(boolean sysConUseOrgVar, String statisticsId, List<Map<String, Object>> userConditions, Map<String, Object> reportConfig, CAPBusinessEnum.ReportCacheKeyEnum reportCacheKeyEnum) {
        StringBuilder cacheKeySb = new StringBuilder();
        if (sysConUseOrgVar) {
            cacheKeySb.append(AppContext.currentUserId()).append("_");
        }
        String conditionMd5String = DigestUtils.md5Hex((String)JSONUtil.toJSONString(userConditions));
        String configMd5String = DigestUtils.md5Hex((String)JSONUtil.toJSONString(reportConfig));
        cacheKeySb.append(statisticsId).append("_").append(conditionMd5String).append("_").append(configMd5String).append("_").append(reportCacheKeyEnum.getName());
        return DigestUtils.md5Hex((String)cacheKeySb.toString());
    }

    private String getRunningEncoding() {
        return CAPBusinessEnum.CalcValueLengthLanguageEnum.getEncodingByLanguage(AppContext.getLocale().getLanguage());
    }

    @Override
    public String getClassId() {
        return String.valueOf(CAPBusinessEnum.ColumnType.CACL_RESULT.getType());
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setReportTaskExecuteManager(ReportTaskExecuteManager reportTaskExecuteManager) {
        this.reportTaskExecuteManager = reportTaskExecuteManager;
    }
}

