/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.result;

import com.seeyon.cap4.template.exception.FormDataBusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;

public abstract class AbstractResult<T> {
    private String code;
    private String message;
    private T data;

    protected abstract String successCode();

    protected abstract String exceptionCode();

    public abstract void error(String var1);

    public boolean isSuccessResult() {
        return this.successCode().equals(this.code);
    }

    public void error(String code, String message) {
        this.setCode(code);
        this.setMessage(message);
    }

    private void build(String code, String message, T data) {
        this.setCode(code);
        this.setMessage(message);
        this.setData(data);
    }

    public void success() {
        this.success(this.getData());
    }

    public void success(T data) {
        this.build(this.successCode(), ResourceUtil.getString((String)"cap.template.message.success"), data);
    }

    public void exception() {
        this.build(this.exceptionCode(), ResourceUtil.getString((String)"cap.template.message.exception"), null);
    }

    public void exception(Exception e) {
        if (e instanceof FormDataBusinessException) {
            this.build(((FormDataBusinessException)((Object)e)).getCode(), e.getMessage(), null);
        } else {
            this.exception();
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

