/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.template.bean.FormDataParamBean;
import com.seeyon.cap4.template.manager.CAPRuntimeCalcManager;
import com.seeyon.cap4.template.manager.CAPRuntimeDataLockManager;
import com.seeyon.cap4.template.service.AbstractCAPFormBaseService;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public abstract class AbstractCAPFormDataService
extends AbstractCAPFormBaseService {
    private static final Log LOGGER = CtpLogFactory.getLog(AbstractCAPFormDataService.class);
    protected static final String VALUE = "value";
    protected static final String SHOW_VALUE = "showValue";
    protected static final String SHOW_VALUE2 = "showValue2";
    protected static final String CONTENT_DATA_ID = "contentDataId";
    protected static final String ADD = "add";
    protected static final String COPY = "copy";
    protected static final String REPEAL = "repeal";
    protected static final String DELETE = "delete";
    protected static final String DELETE_ALL = "deleteAll";
    protected static final String TABLE_NAME = "tableName";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String CONTENT_TEMPLATE_ID = "contentTemplateId";
    protected static final String TABLE_DATA = "tableData";
    protected static final String MERGE_DATA = "mergeData";
    protected static final String MODULE_ID = "moduleId";
    protected static final String MODULE_TYPE = "moduleType";
    protected static final String OPERATE_TYPE = "operateType";
    protected static final String FROM = "from";
    protected static final String MODULE_TEMPLATE_ID = "moduleTemplateId";
    protected static final String NEED_CHECK_RULE = "needCheckRule";
    protected static final String IS_MERGE = "isMerge";
    protected static final String NEED_DATA_UNIQUE = "needDataUnique";
    protected static final String NEED_SN = "needSn";
    protected static final String CONTENT_TYPE = "contentType";
    protected static final String FORMSON_NUM_THRESHOLD = "formsonNumThreshold";
    protected static final String DEFAULT_RIGHT_ID = "-1";
    protected static final String PC_ISIGNATURE_PROTECTED_DATA = "pcISignatureProtectedData";
    protected static final String PHONE_ISIGNATURE_PROTECTED_DATA = "phoneISignatureProtectedData";
    protected CAP4FormRelationActionManager cap4FormRelationActionManager;
    protected CAPRuntimeCalcManager capRuntimeCalcManager;
    protected CAPRuntimeDataLockManager capRuntimeDataLockManager;
    protected CollaborationApi collaborationApi;
    protected CAPFormDataCacheManager capFormDataCacheManager;
    protected AttachmentManager attachmentManager;
    protected MainbodyManager ctpMainbodyManager;
    private WorkflowApiManager wapi;

    protected void initAddSubDataBean(FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormTableBean formTableBean, FormDataSubBean formDataSubBean) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formTableBean.getFormId());
        List subFormFieldBeans = formTableBean.getFields();
        for (FormFieldBean formFieldBean : subFormFieldBeans) {
            this.cap4FormDataManager.procFieldDefaultVal((FormDataBean)formDataSubBean, formAuthViewBean, false, formFieldBean);
        }
        for (FormFieldBean formFieldBean : subFormFieldBeans) {
            FormFieldBean parentFieldBean;
            Object value;
            if (!formFieldBean.isEnumField() || !Strings.isNotBlank((String)formFieldBean.getEnumParent()) || (value = (parentFieldBean = formBean.getFieldBeanByName(formFieldBean.getEnumParent())).isMasterField() ? formDataMasterBean.getFieldValue(parentFieldBean.getName()) : formDataSubBean.getFieldValue(parentFieldBean.getName())) == null) continue;
            CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(formFieldBean, formDataSubBean), Long.parseLong(value.toString()));
        }
    }

    protected List<FormDataSubBean> initAddSubDataBeans(FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormTableBean formTableBean, List<FormDataSubBean> newFormDataSubBeans) throws BusinessException {
        for (FormDataSubBean formDataSubBean : newFormDataSubBeans) {
            this.initAddSubDataBean(formDataMasterBean, formAuthViewBean, formTableBean, formDataSubBean);
        }
        return newFormDataSubBeans;
    }

    protected FormDataMasterBean mergeFormData(FormDataMasterBean cacheFormDataMasterBean, Map<String, Object> mergeData) {
        if (mergeData == null || mergeData.isEmpty()) {
            return cacheFormDataMasterBean;
        }
        Map content = (Map)mergeData.get("content");
        Long formId = Long.valueOf((String)content.get(CONTENT_TEMPLATE_ID));
        Long rightId = Long.valueOf((String)content.get("rightId"));
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, rightId);
        return this.capRuntimeCalcManager.mergeFormData(formBean, cacheFormDataMasterBean, formAuthViewBean, mergeData);
    }

    protected void mergeAutoDelete2Result(Map<String, Set<String>> tableName2DeleteIds, Map<String, Map<String, Object>> tableName2DataMaps) {
        if (tableName2DeleteIds == null || tableName2DeleteIds.isEmpty()) {
            return;
        }
        for (String tableName : tableName2DeleteIds.keySet()) {
            HashSet deleteIds;
            if (tableName2DeleteIds.get(tableName) == null || tableName2DeleteIds.get(tableName).size() == 0) continue;
            Map<String, Object> tableData = tableName2DataMaps.get(tableName);
            if (tableData == null) {
                tableData = new HashMap<String, Object>();
                tableName2DataMaps.put(tableName, tableData);
            }
            if ((deleteIds = (HashSet)tableData.get(DELETE)) == null) {
                deleteIds = new HashSet();
                tableData.put(DELETE, deleteIds);
            }
            deleteIds.addAll(tableName2DeleteIds.get(tableName));
        }
    }

    protected Map<String, List<FormDataSubBean>> calculateAutoIncreaseByField(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, FormFieldBean formFieldBean, Set<String> fillBackFields, Map<String, Set<String>> tableName2DeleteIds, boolean doExec) throws BusinessException {
        HashMap<String, List<FormDataSubBean>> tableName2AddSubBeans = null;
        if (formFieldBean == null || formFieldBean.isSubField()) {
            return tableName2AddSubBeans;
        }
        Set<FormRelationshipMapBean> mapBeans = this.cap4FormRelationActionManager.getAutoIncreaseByConditionField(formBean, formFieldBean);
        if (Strings.isNotEmpty(mapBeans)) {
            tableName2AddSubBeans = new HashMap<String, List<FormDataSubBean>>(mapBeans.size());
            for (FormRelationshipMapBean mapBean : mapBeans) {
                LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " cause by " + formFieldBean.getName() + " " + formFieldBean.getDisplay() + " do calc auto increase row " + mapBean.export4Log()));
                tableName2AddSubBeans.putAll(this.cap4FormRelationActionManager.getRelationAutoIncreaseRow(formBean, cacheFormDataMasterBean, formAuthViewBean, mapBean, tableName2DeleteIds, null));
            }
            if (doExec && tableName2AddSubBeans.size() > 0) {
                Set<String> fields = this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, CAPFormUtil.getTableName2FormSubDataBeanIds(tableName2AddSubBeans));
                fillBackFields.addAll(fields);
                for (String tableName : tableName2AddSubBeans.keySet()) {
                    tableName2AddSubBeans.put(tableName, cacheFormDataMasterBean.getSubData(tableName));
                }
            }
        }
        return tableName2AddSubBeans;
    }

    protected Long getAttachmentRealReference(ModuleType mType, Long id) {
        Long realId = id;
        if (mType == ModuleType.collaboration) {
            try {
                Long parentProcessId;
                String processId;
                ColSummary summary = this.collaborationApi.getColSummary(id);
                if (summary != null && Integer.valueOf(ColConstant.NewflowType.child.ordinal()).equals(summary.getNewflowType()) && Strings.isNotBlank((String)(processId = summary.getProcessId())) && null != (parentProcessId = this.wapi.getMainProcessIdBySubProcessId(Long.valueOf(processId)))) {
                    ColSummary colSummaryById = this.collaborationApi.getColSummaryByProcessId(String.valueOf(parentProcessId));
                    realId = null != colSummaryById ? colSummaryById.getId() : id;
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("getAttachmentRealReference is exception " + id), (Throwable)e);
            }
        }
        return realId;
    }

    protected CtpContentAll getCtpContentAllByModuleIdAndType(FormDataParamBean formDataParamBean) {
        CtpContentAll ctpContentAll = null;
        if (formDataParamBean.getModuleId() != null && formDataParamBean.getModuleType() != null) {
            ctpContentAll = this.getCtpContentAll(formDataParamBean.getModuleId(), formDataParamBean.getModuleType());
        }
        return ctpContentAll;
    }

    protected CtpContentAll getCtpContentAllByModuleIdAndType(Map<String, Object> params) {
        CtpContentAll ctpContentAll = null;
        String moduleId = CAPParamUtil.getString(params, (String)MODULE_ID);
        String moduleType = CAPParamUtil.getString(params, (String)MODULE_TYPE);
        if (Strings.isNotBlank((String)moduleId) && Strings.isNotBlank((String)moduleType)) {
            ctpContentAll = this.getCtpContentAll(Long.valueOf(moduleId), Integer.parseInt(moduleType));
        }
        return ctpContentAll;
    }

    protected CtpContentAll getCtpContentAll(Long moduleId, Integer moduleType) {
        CtpContentAll ctpContentAll = null;
        HashMap<String, Number> contentParams = new HashMap<String, Number>(2);
        contentParams.put(MODULE_TYPE, moduleType);
        contentParams.put(MODULE_ID, moduleId);
        List contentPoList = this.ctpMainbodyManager.getContentList(contentParams);
        if (contentPoList != null && contentPoList.size() > 0) {
            ctpContentAll = (CtpContentAll)contentPoList.get(0);
        }
        return ctpContentAll;
    }

    public void setCap4FormRelationActionManager(CAP4FormRelationActionManager cap4FormRelationActionManager) {
        this.cap4FormRelationActionManager = cap4FormRelationActionManager;
    }

    public void setCapRuntimeCalcManager(CAPRuntimeCalcManager capRuntimeCalcManager) {
        this.capRuntimeCalcManager = capRuntimeCalcManager;
    }

    public void setCapRuntimeDataLockManager(CAPRuntimeDataLockManager capRuntimeDataLockManager) {
        this.capRuntimeDataLockManager = capRuntimeDataLockManager;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManager capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setCtpMainbodyManager(MainbodyManager ctpMainbodyManager) {
        this.ctpMainbodyManager = ctpMainbodyManager;
    }

    public void setWapi(WorkflowApiManager wapi) {
        this.wapi = wapi;
    }
}

