/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.google.common.collect.Lists;
import com.seeyon.cap4.bizportal.datasource.bean.DefaultDataSetList;
import com.seeyon.cap4.bizportal.vo.ServiceResult;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.AbstractCAPFormBaseService;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPConditionService
extends AbstractCAPFormBaseService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPConditionService.class);
    private EnumManager enumManager;

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManager = enumManagerNew;
    }

    public FormDataResult<List<EnumItem>> getEnumItemResult(List<String> enumIds) {
        FormDataResult<List<EnumItem>> result = new FormDataResult<List<EnumItem>>();
        if (CollectionUtils.isEmpty(enumIds)) {
            result.error("2001", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), enumIds));
            return result;
        }
        ArrayList data = Lists.newArrayList();
        try {
            for (String enumId : enumIds) {
                List childEnumItems = this.enumManager.getChildEnumItems(Long.parseLong(enumId));
                for (CtpEnumItem item : childEnumItems) {
                    EnumItem eItem = new EnumItem();
                    eItem.setId(item.getId().toString());
                    eItem.setEnumValue(item.getEnumvalue());
                    eItem.setShowValue(item.getShowvalue());
                    eItem.setLevel(String.valueOf(item.getLevelNum()));
                    if (item.getImageId() != null) {
                        eItem.setUrl(SystemEnvironment.getContextPath() + "/fileUpload.do?method=showRTE&fileId=" + item.getImageId() + "&type=image" + Functions.csrfSuffix());
                    }
                    data.add(eItem);
                }
            }
            result.success(data);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"", (Throwable)e);
            LOGGER.error((Object)("\u83b7\u53d6\u591a\u7ea7\u679a\u4e3e\u503c\u51fa\u9519, \u53c2\u6570\u503c:" + enumIds + ", \u5f02\u5e38\uff1a"), (Throwable)e);
            result.error("2001", e.getMessage());
        }
        return result;
    }

    public ServiceResult getEnumTreeResult(Long enumItemId) {
        try {
            CtpEnumItem ctpEnumItem = this.enumManager.getCtpEnumItem(enumItemId);
            Long enumId = ctpEnumItem.getRefEnumid();
            Integer levelNum = ctpEnumItem.getLevelNum();
            DefaultDataSetList dataSetList = new DefaultDataSetList();
            for (int i = 0; i <= levelNum; ++i) {
                List list = this.enumManager.getCtpEnumItem(enumId, i);
                if (i < levelNum) {
                    for (CtpEnumItem item : list) {
                        dataSetList.addNode(dataSetList.createBranchNode(item.getId().toString(), item.getShowvalue(), item.getParentId().toString()));
                    }
                    continue;
                }
                for (CtpEnumItem item : list) {
                    dataSetList.addNode(dataSetList.createLeafNode(item.getId().toString(), item.getShowvalue(), item.getParentId().toString()));
                }
            }
            return ServiceResult.success(dataSetList);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"\u83b7\u53d6\u679a\u4e3e\u6811\u5f62\u7ed3\u6784\u6570\u636e\u51fa\u9519", (Throwable)e);
            return ServiceResult.internalError(e.getMessage());
        }
    }

    public static class EnumItem
    implements Serializable {
        private String id;
        private String enumValue;
        private String showValue;
        private String level;
        private String url;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getEnumValue() {
            return this.enumValue;
        }

        public void setEnumValue(String enumValue) {
            this.enumValue = enumValue;
        }

        public String getShowValue() {
            return this.showValue;
        }

        public void setShowValue(String showValue) {
            this.showValue = showValue;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

