/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.template.manager.CAPRuntimeCalcManager;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class CAPCustomService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPCustomService.class);
    private CAPRuntimeCalcManager capRuntimeCalcManager;
    private CAPFormManager capFormManager;
    private CAP4FormManager cap4FormManager;
    private static final String CONTENT = "content";
    private static final String RIGHT_ID = "rightId";
    private static final String MAPPING_DATA = "mappingData";
    private static final String MAPPING_FIELD = "mappingField";
    private static final String VALUE = "value";
    private static final String ATTACHMENTS = "attachments";
    public static final String SRC = "src";
    public static final String DST = "dst";
    private Map<String, Object> mappingDataCache = new ConcurrentHashMap<String, Object>();

    public Map<String, Map<String, Object>> calculate(FormBean formBean, FormDataMasterBean formDataMasterBean, Long rightId, Set<String> changeFields, Map<String, List<Long>> tableName2AddSubIds) {
        HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
        try {
            FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(rightId);
            if (Strings.isNotEmpty(changeFields)) {
                Iterator<String> iterator = changeFields.iterator();
                while (iterator.hasNext()) {
                    FormFieldBean fieldBean;
                    String str;
                    String fieldName = str = iterator.next();
                    Long recordId = null;
                    if (str.indexOf("_") > 0) {
                        fieldName = str.split("_")[0];
                        recordId = Long.valueOf(str.split("_")[1]);
                    }
                    if ((fieldBean = formBean.getFieldBeanByName(fieldName)) == null) continue;
                    if (fieldBean.isMasterField()) {
                        formDataMasterBean.addFieldChanges4Calc(fieldBean, formDataMasterBean.getFieldValue(fieldName), null);
                        continue;
                    }
                    if (!fieldBean.isSubField() || recordId == null) continue;
                    FormDataSubBean formDataSubBean = formDataMasterBean.getFormDataSubBeanById(fieldBean.getOwnerTableName(), recordId);
                    formDataMasterBean.addFieldChanges4Calc(fieldBean, formDataSubBean.getFieldValue(fieldName), formDataSubBean);
                }
            }
            Set<String> calcChangeFields = this.capRuntimeCalcManager.execCalcAll(formBean, formDataMasterBean, formAuthViewBean, tableName2AddSubIds);
            this.capRuntimeCalcManager.buildCalcAllResult(formBean, formDataMasterBean, formAuthViewBean, tableName2AddSubIds, calcChangeFields, null, tableName2DataMaps);
            this.cap4FormManager.saveSessioMasterDataBean(formDataMasterBean.getId(), formDataMasterBean);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e);
        }
        return tableName2DataMaps;
    }

    public FormDataMasterBean fillMappingData(FormBean fromFormBean, FormDataMasterBean formDataMasterBean, Long fromModuleId, Long formRecordId, Map<String, Object> mappingData, Map<String, String> mappingField) throws BusinessException {
        return CAPFormUtil.fillMappingData(fromFormBean, formDataMasterBean, fromModuleId, formRecordId, mappingData, mappingField);
    }

    public FormDataMasterBean fillMappingData(FormBean fromFormBean, FormDataMasterBean formDataMasterBean, Long fromModuleId, String mappingKey) throws BusinessException {
        Map mappingCache = (Map)this.mappingDataCache.get(mappingKey);
        if (mappingCache != null) {
            List mappingDataList = (List)mappingCache.get(MAPPING_DATA);
            List mappingFields = (List)mappingCache.get(MAPPING_FIELD);
            HashMap tableNameMappingFields = new HashMap();
            for (Map map : mappingFields) {
                String key = (String)map.get(SRC);
                String value = (String)map.get(DST);
                FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName(value);
                String tableName = formFieldBean.getOwnerTableName();
                ArrayList tableNameMappingFieldList = (ArrayList)tableNameMappingFields.get(tableName);
                if (tableNameMappingFieldList == null) {
                    tableNameMappingFieldList = new ArrayList();
                }
                HashMap<String, String> mappingField = new HashMap<String, String>(1);
                mappingField.put(key, value);
                tableNameMappingFieldList.add(mappingField);
                tableNameMappingFields.put(tableName, tableNameMappingFieldList);
            }
            HashSet<String> clearedTable = new HashSet<String>();
            HashSet<String> subReferences = new HashSet<String>();
            AppContext.putThreadContext((String)"fieldChangeTag", new HashMap());
            for (Map mappingData : mappingDataList) {
                for (String key : tableNameMappingFields.keySet()) {
                    FormTableBean tableBean = fromFormBean.getTableByTableName(key);
                    if (tableBean.isMainTable()) {
                        List mappingFieldList = (List)tableNameMappingFields.get(key);
                        for (Object mappingField : mappingFieldList) {
                            formDataMasterBean = CAPFormUtil.fillMappingData(fromFormBean, formDataMasterBean, fromModuleId, null, mappingData, (Map<String, String>)mappingField);
                        }
                        continue;
                    }
                    boolean execClear = false;
                    if (!clearedTable.contains(tableBean.getTableName())) {
                        Object mappingField;
                        List oldSubBeans = formDataMasterBean.getSubData(tableBean.getTableName());
                        mappingField = oldSubBeans.iterator();
                        while (mappingField.hasNext()) {
                            FormDataSubBean formDataSubBean = (FormDataSubBean)mappingField.next();
                            for (FormFieldBean fieldBean : tableBean.getFields()) {
                                if (!fieldBean.isAttachment() || formDataSubBean.getFieldValue(fieldBean.getName()) == null) continue;
                                subReferences.add(String.valueOf(formDataSubBean.getFieldValue(fieldBean.getName())));
                            }
                        }
                        execClear = true;
                        clearedTable.add(tableBean.getTableName());
                    }
                    FormDataSubBean dataSubBean = new FormDataSubBean(tableBean, formDataMasterBean, new boolean[]{true});
                    dataSubBean.setFormmainId(formDataMasterBean.getId().longValue());
                    if (execClear) {
                        ArrayList<FormDataSubBean> subBeans = new ArrayList<FormDataSubBean>();
                        subBeans.add(dataSubBean);
                        formDataMasterBean.setSubData(tableBean.getTableName(), subBeans);
                    } else {
                        formDataMasterBean.addSubData(tableBean.getTableName(), dataSubBean);
                    }
                    List mappingFieldList = (List)tableNameMappingFields.get(key);
                    for (Map mappingField : mappingFieldList) {
                        formDataMasterBean = CAPFormUtil.fillMappingData(fromFormBean, formDataMasterBean, fromModuleId, dataSubBean.getId(), mappingData, mappingField);
                    }
                }
            }
            CAPAttachmentUtil.removeSessionAttachmentsBySubReferences(formDataMasterBean, subReferences);
        }
        return formDataMasterBean;
    }

    public String putMappingDataToCache(Map<String, Object> mappingData, List<Map<String, String>> mappingFields) throws BusinessException {
        ArrayList<Map<String, Object>> mappingDatas = new ArrayList<Map<String, Object>>();
        mappingDatas.add(mappingData);
        return this.putMappingDataToCache(mappingDatas, mappingFields);
    }

    public String putMappingDataToCache(List<Map<String, Object>> mappingDatas, List<Map<String, String>> mappingFields) throws BusinessException {
        String key = String.valueOf(UUIDLong.longUUID());
        HashMap<String, List<Map<String, Object>>> mappingCache = new HashMap<String, List<Map<String, Object>>>();
        mappingCache.put(MAPPING_FIELD, mappingFields);
        mappingCache.put(MAPPING_DATA, mappingDatas);
        this.mappingDataCache.put(key, mappingCache);
        return key;
    }

    public void removeMappingDataCache(String key) {
        LOGGER.info((Object)(AppContext.currentUserId() + " remove mapping data " + key));
        this.mappingDataCache.remove(key);
    }

    public Object getFieldMappingData(FormDataMasterBean formDataMasterBean, FormFieldBean formFieldBean, Object fieldValue) {
        if (fieldValue != null && formFieldBean.isAttachment()) {
            List attachments = formDataMasterBean.getSessionAttachments(String.valueOf(fieldValue));
            return this.getFieldMappingData(formFieldBean, fieldValue, attachments);
        }
        return fieldValue;
    }

    public Object getFieldMappingData(FormFieldBean formFieldBean, Object fieldValue, List<Attachment> attachments) {
        if (fieldValue != null && formFieldBean.isAttachment()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put(VALUE, fieldValue);
            if (Strings.isNotEmpty(attachments)) {
                valueMap.put(ATTACHMENTS, attachments);
            }
            return valueMap;
        }
        return fieldValue;
    }

    public void mergeFormData(FormBean formBean, FormDataMasterBean formDataMasterBean, Map<String, Object> mergeData) {
        if (mergeData == null || mergeData.isEmpty()) {
            return;
        }
        Map content = (Map)mergeData.get(CONTENT);
        Long rightId = Long.valueOf((String)content.get(RIGHT_ID));
        FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, formDataMasterBean, rightId);
        this.capRuntimeCalcManager.mergeFormData(formBean, formDataMasterBean, formAuthViewBean, mergeData);
    }

    public void addShowRecordRight(String rightId) {
        if (Strings.isNotBlank((String)rightId)) {
            if (rightId.indexOf("_") > -1 || rightId.indexOf(".") > -1) {
                String[] viewStrs = rightId.split("_");
                for (int i = 0; i < viewStrs.length; ++i) {
                    if (Strings.isBlank((String)viewStrs[i])) continue;
                    String rightIdStr = viewStrs[i].indexOf(".") > -1 ? viewStrs[i].split("\\.")[1] : viewStrs[i];
                    this.capFormManager.addRightId(Long.valueOf(rightIdStr));
                }
            } else {
                this.capFormManager.addRightId(Long.valueOf(rightId));
            }
        }
    }

    public void setCapRuntimeCalcManager(CAPRuntimeCalcManager capRuntimeCalcManager) {
        this.capRuntimeCalcManager = capRuntimeCalcManager;
    }

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }
}

