/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.bean.AbstractParamBean;
import com.seeyon.cap4.template.exception.FormDataBusinessException;
import com.seeyon.cap4.template.manager.CAPExcelManager;
import com.seeyon.cap4.template.manager.CAPExportManager;
import com.seeyon.cap4.template.result.ExportResult;
import com.seeyon.cap4.template.service.AbstractCAPFormBaseService;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.Workbook;

public class CAPExportService
extends AbstractCAPFormBaseService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPExportService.class);
    private CAPExcelManager capExcelManager;

    public ExportResult<ExportFileVO> export(Map<String, Object> params) {
        ExportResult<ExportFileVO> result;
        try {
            result = new ExportResult();
            ExportFileVO fileVO = new ExportFileVO();
            String type = (String)params.get("type");
            Workbook workbook = this.execExport(type, params, fileVO);
            if (workbook != null) {
                this.capExcelManager.saveExcel(fileVO, workbook);
                result.success(fileVO);
            } else {
                result.error("3003", "excel data is empty");
            }
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)("export " + params), (Throwable)e);
            result = this.formatException(e.getTargetException());
        }
        catch (Exception e) {
            LOGGER.error((Object)("export " + params), (Throwable)e);
            result = this.formatException(e);
        }
        return result;
    }

    private ExportResult<ExportFileVO> formatException(Throwable e) {
        ExportResult<ExportFileVO> result = new ExportResult<ExportFileVO>();
        if (e instanceof FormDataBusinessException) {
            FormDataBusinessException e1 = (FormDataBusinessException)((Object)e);
            result.error(e1.getCode(), e.getMessage());
        } else {
            result.exception();
        }
        return result;
    }

    public void export(Map<String, Object> params, HttpServletResponse response) throws Exception {
        ExportFileVO fileVO;
        String type = (String)params.get("type");
        Workbook workbook = this.execExport(type, params, fileVO = new ExportFileVO());
        if (workbook != null) {
            this.capExcelManager.downloadExcel(workbook, fileVO.getFileName(), response);
        }
    }

    private <T> Workbook execExport(String type, Map<String, Object> params, ExportFileVO fileVO) throws Exception {
        Map map = AppContext.getBeansOfType(CAPExportManager.class);
        Workbook workbook = null;
        for (Map.Entry entry : map.entrySet()) {
            if (!((CAPExportManager)entry.getValue()).getType().equals(type)) continue;
            ParamClass paramClass = ((CAPExportManager)entry.getValue()).getClass().getAnnotation(ParamClass.class);
            Object bean = AbstractParamBean.convert(params, paramClass.clazz());
            workbook = (Workbook)((CAPExportManager)entry.getValue()).export(bean, fileVO);
            break;
        }
        return workbook;
    }

    public void setCapExcelManager(CAPExcelManager capExcelManager) {
        this.capExcelManager = capExcelManager;
    }
}

