/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.FormDataForwardParamBean;
import com.seeyon.cap4.template.bean.FormDataParamBean;
import com.seeyon.cap4.template.bean.FormDataSignatureParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.result.FormDataForwardResult;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.AbstractCAPFormDataService;
import com.seeyon.cap4.template.service.CAPFormDataOpenService;
import com.seeyon.cap4.template.service.CAPFormDataSignatureService;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.vo.FormDataVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPFormDataForwardService
extends AbstractCAPFormDataService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataForwardService.class);
    private static final String FROM_RIGHT_INFO = "formRightInfo";
    private static final String ISIGNATURE_PROTECTED_DATA = "iSignatureProtectedData";
    private CAPFormDataOpenService capFormDataOpenService;
    private CAPFormDataSignatureService capFormDataSignatureService;

    protected Map<String, Object> doCreateForwardMap(FormDataParamBean formDataParamBean, CtpContentAll contentAll) {
        Map formInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map map = (Map)JSONUtil.parseJSONString((String)contentAll.getContent());
        int userAgent = this.capFormDataOpenService.getUserAgent(formDataParamBean);
        Map dataMap = (Map)map.get(String.valueOf(userAgent));
        String currentRightId = formDataParamBean.getCurrentRightId();
        String rightId = formDataParamBean.getRightId();
        if (Strings.isNotBlank((String)currentRightId)) {
            result.putAll((Map)dataMap.get(currentRightId));
        } else if (Strings.isNotBlank((String)rightId) && rightId.indexOf("_") == -1 && rightId.indexOf(".") == -1) {
            result.putAll((Map)dataMap.get(rightId));
        } else {
            for (String key : dataMap.keySet()) {
                Map objectMap = (Map)dataMap.get(key);
                if (!"0".equals(objectMap.get("viewSort"))) continue;
                result.putAll(objectMap);
                break;
            }
        }
        Map iSignatureProtectedData = CAPFormUtil.isPcLogin(userAgent) ? (Map)map.get("pcISignatureProtectedData") : (Map)map.get("phoneISignatureProtectedData");
        Map data = (Map)result.get("data");
        Map content = (Map)data.get("content");
        if (content != null) {
            content.put("isForward", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
            if (iSignatureProtectedData != null) {
                content.put(ISIGNATURE_PROTECTED_DATA, iSignatureProtectedData);
            }
        }
        if ((formInfo = (Map)data.get("formInfo")) != null) {
            formInfo.put("isEg", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        }
        CAPAttachmentUtil.resetForwardAttachmentForCreate(result, contentAll.getModuleId());
        return result;
    }

    @ValidateRequestParam(notEmpty={"moduleId", "moduleType", "rightId", "newSummaryId", "formId"})
    public Map<String, Object> getFormDataContent(FormDataForwardParamBean formDataForwardParamBean) throws BusinessException {
        LOGGER.info((Object)("getFormDataContent " + formDataForwardParamBean.toString()));
        HashMap<String, Object> result = new HashMap<String, Object>();
        FormBean formBean = this.cap4FormCacheManager.getForm(formDataForwardParamBean.getFormId());
        CtpContentAll contentAll = this.getCtpContentAll(formDataForwardParamBean.getModuleId(), formDataForwardParamBean.getModuleType());
        String lang = AppContext.getLocale().toString();
        FormDataParamBean paramBean = new FormDataParamBean();
        paramBean.setModuleId(formDataForwardParamBean.getModuleId());
        paramBean.setModuleType(formDataForwardParamBean.getModuleType());
        paramBean.setFrom(CAPBusinessEnum.FormOpenFrom.API_FORWARD.getKey());
        paramBean.setOperateType(CAPBusinessEnum.FormOperateType.BROWSE.getKey());
        paramBean.setNewSummaryId(formDataForwardParamBean.getNewSummaryId());
        paramBean.setCurrentUser(AppContext.getCurrentUser());
        paramBean.setLang(lang);
        int agentPhone = Constants.login_sign.phone.value();
        int agentPc = Constants.login_sign.pc.value();
        int sortPhone = 0;
        int sortPc = 0;
        try {
            HashMap<String, FormDataForwardResult<FormDataVO>> pcDataMap = new HashMap<String, FormDataForwardResult<FormDataVO>>();
            HashMap<String, FormDataForwardResult<FormDataVO>> phoneDataMap = new HashMap<String, FormDataForwardResult<FormDataVO>>();
            if (formDataForwardParamBean.getRightId().indexOf("_") > -1 || formDataForwardParamBean.getRightId().indexOf(".") > -1) {
                String[] viewStrs = formDataForwardParamBean.getRightId().split("_");
                for (int i = 0; i < viewStrs.length; ++i) {
                    String rightIdStr = viewStrs[i].indexOf(".") > -1 ? viewStrs[i].split("\\.")[1] : viewStrs[i];
                    FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightIdStr)));
                    FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
                    paramBean.setCurrentRightId(rightIdStr);
                    paramBean.setRightId(formDataForwardParamBean.getRightId());
                    FormDataForwardResult<FormDataVO> dataForwardResult = new FormDataForwardResult<FormDataVO>();
                    if (formViewBean.isPhone()) {
                        paramBean.setUserAgent(agentPhone);
                        this.capFormDataOpenService.doCreateOrEditNormalForm(paramBean, false, contentAll, dataForwardResult);
                        dataForwardResult.setViewSort(sortPhone);
                        ++sortPhone;
                        phoneDataMap.put(rightIdStr, dataForwardResult);
                    } else if (formViewBean.isPc()) {
                        paramBean.setUserAgent(agentPc);
                        this.capFormDataOpenService.doCreateOrEditNormalForm(paramBean, false, contentAll, dataForwardResult);
                        dataForwardResult.setViewSort(sortPc);
                        ++sortPc;
                        pcDataMap.put(rightIdStr, dataForwardResult);
                    }
                    if ("2000".equals(dataForwardResult.getCode())) continue;
                    throw new BusinessException("Forward is error");
                }
            } else {
                LOGGER.error((Object)("Forward params right error , " + formDataForwardParamBean.toString()));
                throw new BusinessException("Forward is error");
            }
            result.put(String.valueOf(agentPc), pcDataMap);
            result.put(String.valueOf(agentPhone), phoneDataMap);
            result.put(FROM_RIGHT_INFO, this.cap4FormManager.getFormDataRightInfo(formDataForwardParamBean.getFormId(), formDataForwardParamBean.getRightId(), null, lang));
            if (this.collaborationApi.hasCtpIsignature(formDataForwardParamBean.getModuleId())) {
                FormDataSignatureParamBean signatureParamBean = new FormDataSignatureParamBean();
                signatureParamBean.setModuleId(formDataForwardParamBean.getModuleId());
                signatureParamBean.setFormMasterDataId(contentAll == null ? null : contentAll.getContentDataId());
                signatureParamBean.setFormId(formDataForwardParamBean.getFormId());
                FormDataResult<Map> pcISignatureProtectedData = this.capFormDataSignatureService.getiSignatureProtectedData(signatureParamBean);
                if (pcISignatureProtectedData.getData() != null) {
                    result.put("pcISignatureProtectedData", pcISignatureProtectedData.getData());
                }
                signatureParamBean.setFrom(CAPBusinessEnum.FormOpenFrom.LIGHT_FORM.getKey());
                FormDataResult<Map> phoneISignatureProtectedData = this.capFormDataSignatureService.getiSignatureProtectedData(signatureParamBean);
                if (phoneISignatureProtectedData.getData() != null) {
                    result.put("phoneISignatureProtectedData", phoneISignatureProtectedData.getData());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Forward is exception , " + e.getMessage()), (Throwable)e);
            throw new BusinessException("Forward is error", (Throwable)e);
        }
        return result;
    }

    public void setCapFormDataOpenService(CAPFormDataOpenService capFormDataOpenService) {
        this.capFormDataOpenService = capFormDataOpenService;
    }

    public void setCapFormDataSignatureService(CAPFormDataSignatureService capFormDataSignatureService) {
        this.capFormDataSignatureService = capFormDataSignatureService;
    }
}

