/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.exception.FormDataNoAuthBusinessException;
import com.seeyon.cap4.template.manager.CAPDataListManager;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.AbstractCAPFormDataService;
import com.seeyon.cap4.template.vo.ListVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPFormDataListService
extends AbstractCAPFormDataService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataListService.class);

    @ValidateRequestParam(notEmpty={"formId", "formTemplateId", "queryType"})
    public FormDataResult<? extends ListVO> getList(FormDataListParamBean paramBean) {
        FormDataResult<ListVO> result = new FormDataResult<ListVO>();
        CAPBusinessEnum.DataListTypeEnum typeEnum = CAPBusinessEnum.DataListTypeEnum.getEnumByValue(paramBean.getQueryType());
        if (typeEnum == null) {
            LOGGER.error((Object)("queryType is error " + paramBean));
            result.exception();
        } else {
            try {
                Map map = AppContext.getBeansOfType(CAPDataListManager.class);
                for (Map.Entry entry : map.entrySet()) {
                    if (!typeEnum.equals((Object)((CAPDataListManager)entry.getValue()).getListType())) continue;
                    if (!((CAPDataListManager)entry.getValue()).checkRight(AppContext.currentUserId(), paramBean)) {
                        throw new FormDataNoAuthBusinessException();
                    }
                    result.success((ListVO)((CAPDataListManager)entry.getValue()).getList(paramBean));
                    break;
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                result.exception((Exception)((Object)e));
            }
        }
        return result;
    }
}

