/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.api.ExtendManager;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormQueryTypeEnum;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerSourceRecordDAO;
import com.seeyon.cap4.form.po.CAPFormRelationRecord;
import com.seeyon.cap4.form.po.CAPFormTriggerSourceRecord;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.monitor.utils.CAP4MonitorUtil;
import com.seeyon.cap4.template.bean.FormDataParamBean;
import com.seeyon.cap4.template.bean.FormDataSignatureParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.exception.FormDataBusinessException;
import com.seeyon.cap4.template.manager.CAPTransFormDataBeanManager;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.AbstractCAPFormDataService;
import com.seeyon.cap4.template.service.CAPCustomService;
import com.seeyon.cap4.template.service.CAPFormDataForwardService;
import com.seeyon.cap4.template.service.CAPFormDataSignatureService;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormDataLogUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.vo.AFormTableDataVO;
import com.seeyon.cap4.template.vo.FormDataVO;
import com.seeyon.cap4.template.vo.FormTableFormmainDataVO;
import com.seeyon.cap4.template.vo.FormTableFormsonDataVO;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.affair.manager.AffairManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.config.PerformanceConfig;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.content.affair.constants.SubStateEnum;
import com.seeyon.ctp.common.content.mainbody.MainbodyType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.affair.CtpAffair;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.workflow.simulation.api.SimulationApi;
import com.seeyon.v3x.common.security.AccessControlBean;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPFormDataOpenService
extends AbstractCAPFormDataService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataOpenService.class);
    private AffairManager affairManager;
    private SerialCalRecordManager serialCalRecordManager;
    private ReportApi reportApi;
    private SimulationApi simulationApi;
    private CAP4FormTriggerSourceRecordDAO cap4FormTriggerSourceRecordDAO;
    private CAPCustomService capCustomService;
    private CAPFormManager capFormManager;
    private CAPFormDataSignatureService capFormDataSignatureService;
    private CAPFormDataForwardService capFormDataForwardService;
    private CAPTransFormDataBeanManager capTransFormDataBeanManager;
    private static final String ATTACHMENT_INFO = "attachmentInfo";
    private static final String RELATION_INFO = "relationInfo";
    private static final String RELATION_DATA = "relationData";
    private static final String ENUMS = "enums";
    private static final String TRIGGER_DATA = "triggerData";
    private static final String RECORD_ID = "recordId";
    private static final int PHONE_FORMSON_NUM_THRESHOLD = 200;
    private static final int PHONE_FORMSON_TOTAL_THRESHOLD = 2000;

    public Object createOrEditForm(FormDataParamBean formDataParamBean) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (formDataParamBean.getCurrentUser() == null) {
                formDataParamBean.setCurrentUser(AppContext.getCurrentUser());
            }
            if (Strings.isBlank((String)formDataParamBean.getLang())) {
                formDataParamBean.setLang(AppContext.getLocale().toString());
            }
            if (formDataParamBean.getFormId() != null) {
                return this.doCreatePreForm(formDataParamBean);
            }
            if ("simulate".equals(formDataParamBean.getDataFrom())) {
                return this.doCreateSimulationMap(formDataParamBean);
            }
            return this.doCreateOrEditForm(formDataParamBean, true);
        }
        catch (FormDataBusinessException e) {
            result.put("code", e.getCode());
            result.put("message", e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)"createOrEditForm Exception ", (Throwable)e);
            if (e instanceof BusinessException && "2012".equals(((BusinessException)((Object)e)).getCode())) {
                result.put("code", "2012");
                result.put("message", ResourceUtil.getString((String)"form.data.exception.customfunc.error.tips"));
                this.cap4FormManager.removeSessionMasterDataBean(formDataParamBean.getModuleId());
            }
            result.put("code", "2001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.exception") + " " + e.getMessage());
        }
        return result;
    }

    private FormDataVO.FormInfo createResultFormInfo(FormDataVO formDataVO, FormBean formBean) throws BusinessException {
        FormDataVO.FormInfo formInfo = formDataVO.new FormDataVO.FormInfo();
        formInfo.setFormType(String.valueOf(formBean.getFormType()));
        formInfo.setCategoryId(String.valueOf(formBean.getCategoryId()));
        formInfo.setFormName(formBean.getFormName());
        formInfo.setDesc(formBean.getDesc());
        formInfo.setIsEg(formBean.isPublished() ? CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        formInfo.setExtendFilePaths(CAPFormUtil.getExtendFilePath());
        formInfo.setWaterMark(CAPFormUtil.getFormWaterMark(formBean));
        Integer time = PerformanceConfig.getInstance().getIntegerConfig("cap4.sessionFormDataValidTime");
        if (time == null) {
            String configTime = AppContext.getSystemProperty((String)"cap4.sessionFormDataValidTime");
            time = configTime == null ? time : Integer.parseInt(configTime);
        }
        if (time != null) {
            time = time > 120 ? 120 : time;
            formInfo.setDataValidTime(String.valueOf(time));
        }
        formDataVO.setFormInfo(formInfo);
        return formInfo;
    }

    private void createResultPreViewInfo(FormDataVO formDataVO, FormViewBean formViewBean) {
        FormDataVO.ViewInfo viewInfo = formDataVO.new FormDataVO.ViewInfo();
        viewInfo.setViewId(String.valueOf(formViewBean.getId()));
        viewInfo.setName(formViewBean.getFormViewName());
        viewInfo.setViewContent(formViewBean.getFormViewContent());
        formDataVO.setViewInfo(viewInfo);
    }

    private void createResultTableData(AFormTableDataVO dataVO, FormTableBean tableBean, Map<String, Object> fieldInfos) {
        dataVO.setTableName(tableBean.getTableName());
        dataVO.setFrontTableName(tableBean.getFrontTableName());
        dataVO.setDisplay(tableBean.getDisplay());
        dataVO.setFieldInfo(fieldInfos);
    }

    private FormDataResult doCreatePreForm(FormDataParamBean formDataParamBean) throws BusinessException {
        FormViewBean formViewBean;
        FormBean formBean = this.cap4FormCacheManager.getForm(formDataParamBean.getFormId());
        if (formDataParamBean.getViewId() != null) {
            formViewBean = formBean.getFormView(formDataParamBean.getViewId().longValue(), formDataParamBean.getLang());
        } else if (Strings.isNotBlank((String)formDataParamBean.getRightId()) && !"-1".equals(formDataParamBean.getRightId())) {
            formViewBean = formBean.getFormView(Long.parseLong(formDataParamBean.getRightId().split("[.]")[0]), formDataParamBean.getLang());
        } else {
            List pcFormViewBeans = formBean.getFormViewList(Enums.ViewType.SeeyonForm, formDataParamBean.getLang());
            FormViewBean formViewBean2 = formViewBean = CollectionUtils.isNotEmpty((Collection)pcFormViewBeans) ? (FormViewBean)pcFormViewBeans.get(0) : null;
        }
        if (formViewBean == null) {
            throw new FormDataBusinessException("2013", ResourceUtil.getString((String)"cap.template.form.data.noViewBean"));
        }
        FormDataVO formDataVO = new FormDataVO();
        FormDataVO.FormInfo formInfo = this.createResultFormInfo(formDataVO, formBean);
        formInfo.setFlowDealOptionCount(String.valueOf(this.getFlowDealOptionCount(formBean, null)));
        this.createResultPreViewInfo(formDataVO, formViewBean);
        FormDataVO.TableInfo tableInfo = formDataVO.new FormDataVO.TableInfo();
        formDataVO.setTableInfo(tableInfo);
        HashMap<String, Object> masterFieldMap = new HashMap<String, Object>();
        FormDataMasterBean formDataMasterBean = FormDataMasterBean.newInstance((FormBean)formBean);
        Map<String, List<FormFieldBean>> fieldBeanMap = CAPFormUtil.getTableName2FieldBeans(formBean, formViewBean);
        List<FormFieldBean> masterFields = fieldBeanMap.get(formBean.getMasterTableBean().getTableName());
        HashMap<String, List<Map<String, String>>> capFormAttachmentsMap = new HashMap<String, List<Map<String, String>>>();
        if (masterFields != null) {
            for (FormFieldBean formFieldBean : masterFields) {
                Map<String, Object> fieldInfo = CAPFormUtil.getFormFieldInfo(formFieldBean, formDataMasterBean);
                CAPFormUtil.resetFormFieldInfo(fieldInfo, CAPBusinessEnum.FormOperateType.BROWSE.getKey(), null);
                if (formFieldBean.isAttachment()) {
                    fieldInfo.put(ATTACHMENT_INFO, CAPAttachmentUtil.getFieldAttachmentMap(formDataMasterBean.getId(), formFieldBean, null, capFormAttachmentsMap));
                }
                Map<String, Object> dataInfo = CAPFormUtil.getDisplayValueMap(formDataMasterBean.getFieldValue(formFieldBean.getName()), formFieldBean, null);
                fieldInfo.putAll(dataInfo);
                masterFieldMap.put(formFieldBean.getName(), fieldInfo);
            }
        }
        FormTableFormmainDataVO formmain = new FormTableFormmainDataVO();
        this.createResultTableData(formmain, formBean.getMasterTableBean(), masterFieldMap);
        tableInfo.setFormmain(formmain);
        ArrayList<FormTableFormsonDataVO> formsons = new ArrayList<FormTableFormsonDataVO>();
        tableInfo.setFormson(formsons);
        for (FormTableBean subTable : formBean.getSubTableBean()) {
            List<FormFieldBean> subFields = fieldBeanMap.get(subTable.getTableName());
            HashMap<String, Object> subFieldInfos = new HashMap<String, Object>();
            if (subFields != null) {
                for (FormFieldBean formFieldBean : subFields) {
                    Map<String, Object> fieldInfo = CAPFormUtil.getFormFieldInfo(formFieldBean, formDataMasterBean);
                    CAPFormUtil.resetFormFieldInfo(fieldInfo, CAPBusinessEnum.FormOperateType.BROWSE.getKey(), null);
                    if (formFieldBean.isAttachment()) {
                        fieldInfo.put(ATTACHMENT_INFO, CAPAttachmentUtil.getFieldAttachmentMap(formDataMasterBean.getId(), formFieldBean, null, capFormAttachmentsMap));
                    }
                    subFieldInfos.put(formFieldBean.getName(), fieldInfo);
                }
            }
            ArrayList<Map<String, Object>> dataSubLineInfos = new ArrayList<Map<String, Object>>();
            Map dataSubBeanMap = formDataMasterBean.getSubTables();
            List dataSubBeans = (List)dataSubBeanMap.get(subTable.getTableName());
            for (FormDataSubBean formDataSubBean : dataSubBeans) {
                HashMap<String, Object> dataSubInfos = new HashMap<String, Object>();
                dataSubLineInfos.add(dataSubInfos);
                dataSubInfos.put(RECORD_ID, String.valueOf(formDataSubBean.getId()));
                if (subFields == null) continue;
                for (FormFieldBean formFieldBean : subFields) {
                    Map<String, Object> dataInfo = CAPFormUtil.getDisplayValueMap(formDataSubBean.getFieldValue(formFieldBean.getName()), formFieldBean, null);
                    if (FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(formFieldBean.getInputType())) {
                        dataInfo.put(ENUMS, CAPFormUtil.getFieldEnumJSON(formFieldBean, formDataMasterBean, formDataSubBean, false));
                    }
                    dataSubInfos.put(formFieldBean.getName(), dataInfo);
                }
            }
            FormTableFormsonDataVO formson = new FormTableFormsonDataVO();
            this.createResultTableData(formson, subTable, subFieldInfos);
            formson.setDataSubLineInfos(dataSubLineInfos);
            formson.setTableButton(this.capRuntimeCalcManager.getFormSonAuthButtons(formBean, null, subTable, null, true));
            formson.setTableAuth(this.capRuntimeCalcManager.getFormSonAuth(null, true));
            formsons.add(formson);
        }
        FormDataResult<FormDataVO> formDataResult = new FormDataResult<FormDataVO>();
        formDataResult.success(formDataVO);
        return formDataResult;
    }

    private Object doCreateOrEditForm(FormDataParamBean formDataParamBean, boolean needCheckAuth) throws BusinessException, SQLException {
        CtpContentAll contentAll = this.getCtpContentAllByModuleIdAndType(formDataParamBean);
        if (contentAll == null) {
            LOGGER.info((Object)("doCreateOrEditForm \u627e\u4e0d\u5230\u6b63\u6587\uff01" + formDataParamBean.toString()));
            throw new FormDataBusinessException("2011", ResourceUtil.getString((String)"cap.template.form.data.message.delete"));
        }
        if (Strings.isNotBlank((String)contentAll.getContent()) && contentAll.getContentType().equals(MainbodyType.HTML.getKey())) {
            return this.capFormDataForwardService.doCreateForwardMap(formDataParamBean, contentAll);
        }
        FormDataResult<FormDataVO> result = new FormDataResult<FormDataVO>();
        return this.doCreateOrEditNormalForm(formDataParamBean, needCheckAuth, contentAll, result);
    }

    protected FormDataResult<FormDataVO> doCreateOrEditNormalForm(FormDataParamBean formDataParamBean, boolean needCheckAuth, CtpContentAll contentAll, FormDataResult<FormDataVO> result) throws BusinessException, SQLException {
        this.dealRightIdAndViews(formDataParamBean, contentAll.getContentTemplateId());
        if (Strings.isBlank((String)formDataParamBean.getRightId()) || Strings.isBlank((String)formDataParamBean.getOperateType())) {
            result.error("2004", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "rightId or operateType"));
        } else {
            boolean isAccess;
            boolean bl = isAccess = !needCheckAuth || this.checkCreateOrEditAuth(contentAll, formDataParamBean);
            if (!isAccess) {
                result.error("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
            } else {
                try {
                    FormDataVO formDataVO = this.doCreateOrEditPackDataMap(contentAll, formDataParamBean, null);
                    result.success(formDataVO);
                }
                catch (FormDataBusinessException e) {
                    result.error(e.getCode(), e.getMessage());
                }
            }
        }
        return result;
    }

    private FormDataResult<FormDataVO> doCreateSimulationMap(FormDataParamBean formDataParamBean) throws BusinessException, SQLException {
        FormDataMasterBean formDataMasterBean;
        Long formMasterId = formDataParamBean.getFormMasterId();
        FormDataMasterBean formDataMasterBean2 = formDataMasterBean = formMasterId == null ? null : this.cap4FormManager.getSessioMasterDataBean(formMasterId);
        if (formDataMasterBean == null) {
            String dataStr = this.simulationApi.getFormBeanData(String.valueOf(formDataParamBean.getModuleId()));
            formDataMasterBean = this.capTransFormDataBeanManager.transFormDataBeanFromJson(dataStr);
        }
        FormDataResult<FormDataVO> result = new FormDataResult<FormDataVO>();
        if (formDataMasterBean == null) {
            formDataParamBean.setDataFrom(null);
            CtpContentAll contentAll = this.getCtpContentAllByModuleIdAndType(formDataParamBean);
            if (contentAll == null) {
                result.error("2011", ResourceUtil.getString((String)"cap.template.form.data.message.delete"));
                return result;
            }
            this.doCreateOrEditNormalForm(formDataParamBean, true, contentAll, result);
        } else {
            CtpContentAll contentAll = new CtpContentAll();
            FormBean formBean = this.cap4FormCacheManager.getForm(formDataMasterBean.getFormTable().getFormId());
            contentAll.setContentTemplateId(formBean.getId());
            contentAll.setContentType(Integer.valueOf(MainbodyType.FORM.getKey()));
            contentAll.setModuleType(Integer.valueOf(formBean.getFormType() == Enums.FormType.processesForm.getKey() ? ModuleType.collaboration.getKey() : ModuleType.cap4UnflowForm.getKey()));
            contentAll.setModuleTemplateId(Long.valueOf(-1L));
            contentAll.setModuleId(formDataParamBean.getModuleId());
            contentAll.setContentDataId(formDataMasterBean.getId());
            contentAll.setNewId();
            formDataMasterBean.putExtraAttr("isNew", true);
            this.dealRightIdAndViews(formDataParamBean, formBean.getId());
            FormDataVO formDataVO = this.doCreateOrEditPackDataMap(contentAll, formDataParamBean, formDataMasterBean);
            result.success(formDataVO);
        }
        return result;
    }

    private FormDataVO.Content createResultContent(FormDataVO formDataVO, CtpContentAll contentAll) {
        FormDataVO.Content content = formDataVO.new FormDataVO.Content();
        content.setId(String.valueOf(contentAll.getId()));
        content.setModuleTemplateId(String.valueOf(contentAll.getModuleTemplateId()));
        content.setContentTemplateId(String.valueOf(contentAll.getContentTemplateId()));
        content.setContentType(String.valueOf(contentAll.getContentType()));
        content.setModuleId(String.valueOf(contentAll.getModuleId()));
        content.setTitle(contentAll.getTitle());
        formDataVO.setContent(content);
        return content;
    }

    private void createResultViewInfo(FormDataVO formDataVO, FormViewBean formViewBean, FormDataParamBean formDataParamBean) {
        int userAgent = formDataParamBean.getUserAgent();
        FormDataVO.ViewInfo viewInfo = formDataVO.new FormDataVO.ViewInfo();
        formDataVO.setViewInfo(viewInfo);
        viewInfo.setPcViewCount(String.valueOf(formDataParamBean.getPcRightIdSet().size()));
        viewInfo.setPhoneViewCount(String.valueOf(formDataParamBean.getPhoneRightIdSet().size()));
        viewInfo.setViewId(String.valueOf(formViewBean.getId()));
        viewInfo.setName(formViewBean.getFormViewName());
        if (formViewBean.isPhone() && CAPFormUtil.isPhoneLogin(userAgent) || formViewBean.isPc() && CAPFormUtil.isPcLogin(userAgent)) {
            viewInfo.setViewContent(formViewBean.getFormViewContent());
        } else {
            viewInfo.setViewContent("");
        }
    }

    private void createExtend(FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, CreateOrEditExtendData extendData, FormDataVO formDataVO, FormDataParamBean formDataParamBean) {
        ExtendManager extendManager = CAPFormUtil.getExtendManager();
        if (extendManager != null) {
            FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId(), formDataParamBean.getLang());
            formDataVO.getExtend().put("conditionHidden", extendManager.getFormConditionHidden(formDataMasterBean, String.valueOf(formBean.getId()), String.valueOf(formViewBean.getId()), formDataParamBean.getUserAgent().intValue()));
        }
        formDataVO.getExtend().putAll(this.buildExtendResult(formBean, formDataMasterBean, formAuthViewBean, null));
    }

    private void checkUpdateLock(Long formId, Long contentDataId) throws BusinessException, SQLException {
        boolean checkLock = this.cap4FormManager.checkLock(formId, String.valueOf(contentDataId));
        if (checkLock) {
            throw new FormDataBusinessException("2008", ResourceUtil.getString((String)"cap.template.form.data.message.dataLock"));
        }
        String checkDataLockForEdit = this.cap4FormManager.checkDataLockForEdit(String.valueOf(contentDataId));
        if (Strings.isNotBlank((String)checkDataLockForEdit)) {
            throw new FormDataBusinessException("2009", checkDataLockForEdit);
        }
        this.cap4FormManager.lockFormData(contentDataId);
    }

    private void initNewUnFlow(FormBindAuthBean formBindAuthBean, FormDataParamBean formDataParamBean) throws FormDataBusinessException {
        int userAgent = formDataParamBean.getUserAgent();
        SimpleObjectBean simpleObjectBean = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.ADD.getKey());
        if (CAPFormUtil.isPhoneLogin(userAgent) && Strings.isBlank((String)simpleObjectBean.getPhoneValue()) || CAPFormUtil.isPcLogin(userAgent) && Strings.isBlank((String)simpleObjectBean.getValue())) {
            throw new FormDataBusinessException("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
        }
        if ("-1".equals(formDataParamBean.getRightId())) {
            String valueStr;
            String string = valueStr = CAPFormUtil.isPhoneLogin(userAgent) ? simpleObjectBean.getPhoneValue() : simpleObjectBean.getValue();
            if (valueStr.contains(".")) {
                formDataParamBean.setRightId(valueStr.split("\\.")[1]);
            }
            if (Strings.isNotBlank((String)simpleObjectBean.getPhoneValue())) {
                formDataParamBean.getPhoneRightIdSet().add(simpleObjectBean.getPhoneValue().split("\\.")[1]);
            }
            if (Strings.isNotBlank((String)simpleObjectBean.getValue())) {
                formDataParamBean.getPcRightIdSet().add(simpleObjectBean.getValue().split("\\.")[1]);
            }
        }
    }

    private void initUnFlowBrowse(FormBean formBean, FormBindAuthBean formBindAuthBean, FormDataParamBean formDataParamBean) {
        String valueStr;
        int userAgent = formDataParamBean.getUserAgent();
        List<Map<String, Object>> views = formDataParamBean.getViews();
        SimpleObjectBean simpleObjectBean = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.BROWSE.getKey());
        String string = valueStr = CAPFormUtil.isPhoneLogin(userAgent) ? simpleObjectBean.getPhoneValue() : simpleObjectBean.getValue();
        if (valueStr.contains("|")) {
            String[] values = valueStr.split("\\|");
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].contains(".")) continue;
                String[] value = values[i].split("\\.");
                boolean hasView = false;
                for (Map<String, Object> tempView : views) {
                    if (!value[1].equals(String.valueOf(tempView.get("rightId")))) continue;
                    hasView = true;
                    break;
                }
                if (hasView) continue;
                FormViewBean formViewBean = formBean.getFormView(Long.parseLong(value[0]));
                HashMap<String, String> view = new HashMap<String, String>();
                view.put("rightId", value[1]);
                view.put("name", formViewBean.getFormViewName());
                views.add(view);
            }
        }
    }

    private void doWhenViewsEmpty(FormBean formBean, FormDataParamBean formDataParamBean) throws FormDataBusinessException {
        String rightId = formDataParamBean.getRightId();
        int userAgent = formDataParamBean.getUserAgent();
        FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)));
        if (formAuthViewBean == null) {
            throw new FormDataBusinessException("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
        }
        FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId(), formDataParamBean.getLang());
        if (formViewBean == null) {
            throw new FormDataBusinessException("2013", ResourceUtil.getString((String)"cap.template.form.data.noViewBean"));
        }
        HashMap<String, String> view = new HashMap<String, String>();
        view.put("rightId", rightId);
        view.put("name", formViewBean.getFormViewName());
        formDataParamBean.getViews().add(view);
        if (formViewBean.isPhone() && CAPFormUtil.isPhoneLogin(userAgent)) {
            formDataParamBean.getPhoneRightIdSet().add(rightId);
        } else if (formViewBean.isPc() && CAPFormUtil.isPcLogin(userAgent)) {
            formDataParamBean.getPcRightIdSet().add(rightId);
        }
    }

    private int getFlowDealOptionCount(FormBean formBean, FormAuthViewBean formAuthViewBean) {
        List flowDealOptionFields = formBean.getFieldsByType(FormFieldComEnum.FLOWDEALOPITION);
        int flowDealOptionCount = 0;
        if (formAuthViewBean != null) {
            for (FormFieldBean formFieldBean : flowDealOptionFields) {
                String auth = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName()).getAccess();
                if (!Enums.FieldAccessType.edit.getKey().equals(auth) && !Enums.FieldAccessType.add.getKey().equals(auth)) continue;
                ++flowDealOptionCount;
            }
        } else {
            flowDealOptionCount = flowDealOptionFields.size();
        }
        return flowDealOptionCount;
    }

    private FormDataVO doCreateOrEditPackDataMap(CtpContentAll contentAll, FormDataParamBean formDataParamBean, FormDataMasterBean formDataMasterBean) throws BusinessException, SQLException {
        Map<String, Object> fieldInfos;
        FormDataVO formDataVO = new FormDataVO();
        FormDataVO.Content content = this.createResultContent(formDataVO, contentAll);
        if (formDataParamBean.getRightId().contains(".")) {
            formDataParamBean.setRightId(formDataParamBean.getRightId().split("\\.")[1]);
        }
        int userAgent = formDataParamBean.getUserAgent();
        List<Map<String, Object>> views = formDataParamBean.getViews();
        formDataVO.setViews(views);
        String moduleId = formDataParamBean.getModuleId() == null ? null : formDataParamBean.getModuleId().toString();
        String operateType = formDataParamBean.getOperateType();
        Integer moduleType = formDataParamBean.getModuleType();
        String from = formDataParamBean.getFrom();
        ModuleType mType = ModuleType.getEnumByKey((int)moduleType);
        Long contentDataId = contentAll.getContentDataId();
        FormBean formBean = this.cap4FormCacheManager.getForm(contentAll.getContentTemplateId());
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formBean.getId());
        if (null != bizConfigBean) {
            JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u4fee\u6539\u8be6\u60c5", CAP4MonitorUtil.contactTag(bizConfigBean), CAP4MonitorUtil.contactTag(formBean)});
        } else {
            JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u4fee\u6539\u8be6\u60c5", CAP4MonitorUtil.contactTag(formBean)});
        }
        if (formDataParamBean.getPcRightIdSet() == null) {
            formDataParamBean.setPcRightIdSet(new HashSet<String>());
        }
        if (formDataParamBean.getPhoneRightIdSet() == null) {
            formDataParamBean.setPhoneRightIdSet(new HashSet<String>());
        }
        SimpleObjectBean printSimpleObjectBean = null;
        if (mType == ModuleType.cap4UnflowForm) {
            FormBindAuthBean formBindAuthBean = formDataParamBean.getFormBindAuthBean();
            String allowQRScan = CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(operateType) ? CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey() : formBindAuthBean.getScanCodeInput();
            content.setAllowQRScan(!CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey().equals(allowQRScan));
            content.setBarCode(AppContext.hasPlugin((String)"barCode"));
            if (CAPBusinessEnum.FormOperateType.UPDATE.getKey().equals(operateType)) {
                this.checkUpdateLock(formBean.getId(), contentDataId);
            }
            if (formDataParamBean.getFormTemplateId() != null) {
                if (contentDataId == null) {
                    this.initNewUnFlow(formBindAuthBean, formDataParamBean);
                }
                if (CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(operateType)) {
                    this.initUnFlowBrowse(formBean, formBindAuthBean, formDataParamBean);
                    printSimpleObjectBean = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.ALLOWPRINT.getKey());
                }
            }
        }
        if (views.size() == 0) {
            this.doWhenViewsEmpty(formBean, formDataParamBean);
        }
        content.setRightId(formDataParamBean.getRightId());
        content.setModuleType(moduleType.toString());
        content.setIsMerge(CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        content.setNeedCheckRule(CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        content.setNeedDataUnique(CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        content.setNeedSn(CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(formDataParamBean.getRightId())));
        FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId(), formDataParamBean.getLang());
        if (formViewBean == null) {
            throw new FormDataBusinessException("2013", ResourceUtil.getString((String)"cap.template.form.data.noViewBean"));
        }
        FormDataVO.FormInfo formInfo = this.createResultFormInfo(formDataVO, formBean);
        formInfo.setIsPrint(printSimpleObjectBean != null && CAPBusinessEnum.TrueOrFalseEnum.TRUE.getName().equals(printSimpleObjectBean.getValue()) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        formInfo.setFlowDealOptionCount(String.valueOf(this.getFlowDealOptionCount(formBean, formAuthViewBean)));
        CreateOrEditExtendData extendData = new CreateOrEditExtendData();
        extendData.setOperateType(operateType);
        formDataMasterBean = this.getCreateOrEditFormDataMasterBean(formDataMasterBean, formBean, formAuthViewBean, contentAll, extendData, formDataParamBean);
        this.removeEmptyFieldsRightId(formBean, formDataParamBean.getPcRightIdSet(), formDataParamBean);
        this.removeEmptyFieldsRightId(formBean, formDataParamBean.getPhoneRightIdSet(), formDataParamBean);
        this.createResultViewInfo(formDataVO, formViewBean, formDataParamBean);
        this.cap4FormRelationActionManager.removeCacheRelationData(formDataMasterBean.getId());
        boolean isEdit = CAPBusinessEnum.FormOperateType.NEW.getKey().equals(operateType) || CAPBusinessEnum.FormOperateType.UPDATE.getKey().equals(operateType);
        CAPFormDataLogUtil.recordTrace(formDataMasterBean, "\u6253\u5f00\u8ba1\u7b97\u524d");
        if (isEdit) {
            CtpAffair ctpAffair;
            this.capRuntimeDataLockManager.remove(formDataMasterBean.getId());
            if (ModuleType.collaboration == mType && formDataMasterBean.getState() == Enums.FormDataStateEnum.FLOW_DRAFT.getKey() && (ctpAffair = this.affairManager.getSenderAffair(Long.valueOf(Long.parseLong(moduleId)))) != null && ctpAffair.getState().intValue() == StateEnum.col_waitSend.getKey()) {
                int subState;
                int n = subState = ctpAffair.getSubState() == null ? -1 : ctpAffair.getSubState();
                if (subState == SubStateEnum.col_waitSend_stepBack.getKey() || subState == SubStateEnum.col_waitSend_cancel.getKey()) {
                    formDataMasterBean.putExtraAttr("waitSendByBackOrRepeal", true);
                }
            }
            boolean isWaitSent = this.isWaitSentEdit(mType, operateType, contentDataId);
            formDataMasterBean.putExtraAttr("moduleId", CAPBusinessEnum.FormOperateType.NEW.getKey().equals(operateType) ? formDataMasterBean.getId().toString() : moduleId);
            this.cap4FormManager.putSessioMasterDataBean(formBean, formDataMasterBean, true, false);
            AppContext.putThreadContext((String)"waitSentOpen", (Object)isWaitSent);
            this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, formAuthViewBean, false, false, true, true);
            AppContext.removeThreadContext((String)"waitSentOpen");
            if (Strings.isNotBlank((String)formDataParamBean.getMappingDataKey())) {
                LOGGER.info((Object)(formDataParamBean.getCurrentUser().getId() + " dataId " + formDataMasterBean.getId() + " fill mapping data " + formDataParamBean.getMappingDataKey()));
                this.capCustomService.fillMappingData(formBean, formDataMasterBean, Long.valueOf(moduleId), formDataParamBean.getMappingDataKey());
                AppContext.putThreadContext((String)"waitSentOpen", (Object)isWaitSent);
                this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, formAuthViewBean, false, false, true, false);
                AppContext.removeThreadContext((String)"waitSentOpen");
                this.capCustomService.removeMappingDataCache(formDataParamBean.getMappingDataKey());
            }
            List<FormRelationshipMapBean> autoIncreaseRowBeans = this.cap4FormRelationActionManager.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.auto_increase_row.getKey());
            this.dealAutoIncreaseRow(autoIncreaseRowBeans, formBean, formDataMasterBean, formAuthViewBean, formDataParamBean.getRightId(), isWaitSent, extendData.getClearSubReferences());
            formDataMasterBean.removeExtraMap("waitSendByBackOrRepeal");
            CAPFormDataLogUtil.recordTrace(formDataMasterBean, "\u6253\u5f00\u8ba1\u7b97\u540e");
        }
        if (mType == ModuleType.collaboration && contentDataId != null && !CAPBusinessEnum.FormOpenFrom.API_FORWARD.getKey().equals(from) && this.collaborationApi.hasCtpIsignature(contentAll.getModuleId())) {
            FormDataSignatureParamBean signatureParamBean = new FormDataSignatureParamBean();
            signatureParamBean.setModuleId(Long.valueOf(moduleId));
            signatureParamBean.setFormMasterDataId(contentDataId);
            signatureParamBean.setFormId(formBean.getId());
            signatureParamBean.setUserAgent(userAgent);
            FormDataResult<Map> iSignatureProtectedData = this.capFormDataSignatureService.getiSignatureProtectedData(signatureParamBean);
            if (iSignatureProtectedData.getData() != null) {
                content.setiSignatureProtectedData((Map)iSignatureProtectedData.getData());
            }
        }
        Map<String, Object> auth = this.cap4FormDataManager.dealFormRightChangeResult(formBean, formAuthViewBean, formDataMasterBean, true);
        Map subTableAuthMap = (Map)auth.get("subTableAuthMap");
        content.setContentDataId(String.valueOf(formDataMasterBean.getId()));
        if (contentDataId == null) {
            content.setModuleId(String.valueOf(formDataMasterBean.getId()));
            CAPFormUtil.addFormAccessControl(formDataMasterBean.getId(), formDataParamBean.getCurrentUser().getId());
        }
        this.setCreateOrEditRelation(formDataMasterBean, formBean, extendData, formDataVO, contentDataId, from);
        this.setCreateOrEditTriggerData(formDataMasterBean, contentDataId, extendData);
        this.setCreateOrEditAttachments(formDataMasterBean, extendData, formDataParamBean, contentDataId, mType);
        extendData.setThreshold(this.checkFormsonNum(from, formDataMasterBean));
        if (extendData.isThreshold()) {
            content.setFormsonNumThreshold(String.valueOf(200));
        }
        extendData.setAutoIncConditionFields(this.cap4FormRelationActionManager.getValidAutoIncreaseConditionFields(formBean));
        FormDataVO.TableInfo tableInfo = formDataVO.new FormDataVO.TableInfo();
        formDataVO.setTableInfo(tableInfo);
        extendData.setFieldBeanMap(CAPFormUtil.getTableName2FieldBeans(formBean, formViewBean));
        if (extendData.getFieldBeanMap().get(formBean.getMasterTableBean().getTableName()) == null) {
            LOGGER.info((Object)("createOrEditForm, this view not field! formViewBean id = " + formViewBean.getId() + ", formViewBean info = " + formViewBean.getFormViewContent()));
            fieldInfos = new HashMap<String, Object>();
        } else {
            fieldInfos = this.buildCreateOrEditMasterFields(formDataMasterBean, formAuthViewBean, extendData);
        }
        FormTableFormmainDataVO formmain = new FormTableFormmainDataVO();
        this.createResultTableData(formmain, formBean.getMasterTableBean(), fieldInfos);
        tableInfo.setFormmain(formmain);
        ArrayList<FormTableFormsonDataVO> formsons = new ArrayList<FormTableFormsonDataVO>();
        tableInfo.setFormson(formsons);
        for (FormTableBean subTable : formBean.getSubTableBean()) {
            Map<String, Object> subFieldInfos = this.buildCreateOrEditFormSonFields(formDataMasterBean, subTable, extendData);
            List<FormDataSubBean> dataSubBeans = formDataMasterBean.getSubData(subTable.getTableName());
            LOGGER.info((Object)(formDataMasterBean.getId() + " \u6253\u5f00\u8868\u5355 " + subTable.getTableName() + " " + dataSubBeans.size() + "\u884c"));
            if (extendData.isThreshold() && dataSubBeans.size() > 200) {
                dataSubBeans = dataSubBeans.subList(0, 200);
            }
            FormTableFormsonDataVO formson = new FormTableFormsonDataVO();
            this.createResultTableData(formson, subTable, subFieldInfos);
            List dataSubLineInfos = this.buildCreateOrEditFormSonData(formDataMasterBean, dataSubBeans, subTable, formAuthViewBean, subFieldInfos, extendData);
            formson.setDataSubLineInfos(dataSubLineInfos);
            this.buildCreateOrEditFormSonAuth(formson, subTableAuthMap, formBean, formAuthViewBean, subTable, extendData);
            formsons.add(formson);
        }
        this.createResultUser(formDataVO, formDataParamBean.getCurrentUser());
        this.createExtend(formBean, formDataMasterBean, formAuthViewBean, extendData, formDataVO, formDataParamBean);
        if (isEdit) {
            this.cap4FormManager.saveSessioMasterDataBean(formDataMasterBean.getId(), formDataMasterBean);
        }
        JMTrackUtils.clearTrack();
        return formDataVO;
    }

    private void setCreateOrEditRelation(FormDataMasterBean formDataMasterBean, FormBean formBean, CreateOrEditExtendData extendData, FormDataVO formDataVO, Long contentDataId, String from) throws BusinessException {
        extendData.setManualFormRelationshipMapBeanMap(CAPBusinessEnum.FormOpenFrom.API_FORWARD.getKey().equalsIgnoreCase(from) ? new HashMap() : this.cap4FormRelationActionManager.getFormField4ManualRelationMapBeans(formBean));
        if (formDataMasterBean.getRelationRecords() != null) {
            extendData.setCapFormRelationRecords(formDataMasterBean.getRelationRecords());
        } else if (contentDataId != null && extendData.getManualFormRelationshipMapBeanMap().size() > 0) {
            List<CAPFormRelationRecord> relationRecords = this.cap4FormRelationActionManager.getCAPFormRelationRecordsByMasterDataId(contentDataId);
            this.cap4FormRelationActionManager.upgradeCAPFormRelationRecords(formBean, relationRecords, true);
            extendData.setCapFormRelationRecords(relationRecords);
            formDataMasterBean.setRelationRecords(relationRecords);
        }
        ArrayList<Map<String, String>> relationRecordArray = new ArrayList<Map<String, String>>();
        for (CAPFormRelationRecord capFormRelationRecord : extendData.getCapFormRelationRecords()) {
            relationRecordArray.add(capFormRelationRecord.exportToMap());
        }
        formDataVO.setRelationRecords(relationRecordArray);
        formDataMasterBean.initRelationRecordMap();
        extendData.setCapFormRelationRecordMap(formDataMasterBean.getRelationRecordMap());
    }

    private void setCreateOrEditAttachments(FormDataMasterBean formDataMasterBean, CreateOrEditExtendData extendData, FormDataParamBean formDataParamBean, Long contentDataId, ModuleType mType) throws BusinessException {
        List<Attachment> attachments = formDataMasterBean.getSessionAttachments(null);
        if (CAPBusinessEnum.FormOpenFrom.API_FORWARD.getKey().equals(formDataParamBean.getFrom()) && formDataParamBean.getRebuildAttachments() != null && formDataParamBean.getNewSummaryId() != null) {
            extendData.setCapFormAttachmentsMap(formDataParamBean.getRebuildAttachments());
        } else {
            if (extendData.getQueryDbAttachments() && (this.isWaitSentEdit(mType, extendData.getOperateType(), contentDataId) || !CAPBusinessEnum.FormOperateType.NEW.getKey().equals(extendData.getOperateType()))) {
                Long reference = formDataParamBean.getModuleId();
                Long realReference = this.getAttachmentRealReference(mType, reference);
                List dbAttachments = this.attachmentManager.getByReference(realReference);
                if (Strings.isNotEmpty((Collection)dbAttachments)) {
                    Iterator iterator = dbAttachments.iterator();
                    while (iterator.hasNext()) {
                        Attachment attachment = (Attachment)iterator.next();
                        if (!extendData.getClearSubReferences().contains(String.valueOf(attachment.getSubReference()))) continue;
                        iterator.remove();
                    }
                }
                if (!CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(extendData.getOperateType())) {
                    Map<String, List<Attachment>> dbReferenceMap = CAPAttachmentUtil.buildAttachmentSubReferenceToList(dbAttachments);
                    CAPAttachmentUtil.putDbAttachmentsToSession(formDataMasterBean, dbReferenceMap);
                }
                attachments = CAPAttachmentUtil.mergeAttachments(attachments, dbAttachments);
            }
            if (Strings.isNotEmpty((Collection)attachments)) {
                Collections.sort(attachments, new Comparator<Attachment>(){

                    @Override
                    public int compare(Attachment o1, Attachment o2) {
                        return o1.getSort() - o2.getSort();
                    }
                });
            }
            extendData.setCapFormAttachmentsMap(CAPAttachmentUtil.buildAttachmentSubReferenceToListMap(attachments, true));
        }
        if (CAPBusinessEnum.FormOpenFrom.API_FORWARD.getKey().equals(formDataParamBean.getFrom()) && formDataParamBean.getRebuildAttachments() == null && formDataParamBean.getNewSummaryId() != null) {
            CAPAttachmentUtil.copyApiForwardFormAttachments(attachments, formDataParamBean.getNewSummaryId(), extendData.getCapFormAttachmentsMap());
            formDataParamBean.setRebuildAttachments(extendData.getCapFormAttachmentsMap());
        }
    }

    private void setCreateOrEditTriggerData(FormDataMasterBean formDataMasterBean, Long contentDataId, CreateOrEditExtendData extendData) throws BusinessException {
        if (contentDataId != null) {
            List<CAPFormTriggerSourceRecord> capFormTriggerSourceRecords = this.cap4FormTriggerSourceRecordDAO.getSourceRecordList(contentDataId);
            for (CAPFormTriggerSourceRecord capFormTriggerSourceRecord : capFormTriggerSourceRecords) {
                String key = capFormTriggerSourceRecord.getFieldName();
                if (capFormTriggerSourceRecord.getTargetSubDataId() != 0L) {
                    key = key + "_" + capFormTriggerSourceRecord.getTargetSubDataId();
                }
                extendData.getCapFormTriggerSourceRecordMap().put(key, capFormTriggerSourceRecord);
            }
        }
        formDataMasterBean.getExtraMap().put("capFormTriggerSourceRecordMap", extendData.getCapFormTriggerSourceRecordMap());
    }

    private FormDataMasterBean getCreateOrEditFormDataMasterBean(FormDataMasterBean formDataMasterBean, FormBean formBean, FormAuthViewBean formAuthViewBean, CtpContentAll contentAll, CreateOrEditExtendData extendData, FormDataParamBean formDataParamBean) throws BusinessException {
        if (formDataMasterBean == null) {
            Long contentDataId = contentAll.getContentDataId();
            if (contentDataId == null) {
                if (formDataParamBean.getFormMasterId() != null) {
                    formDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(formDataParamBean.getFormMasterId());
                } else {
                    HashMap changeTag = new HashMap();
                    AppContext.putThreadContext((String)"fieldChangeTag", changeTag);
                    formDataMasterBean = FormDataMasterBean.newInstance((FormBean)formBean);
                    formDataMasterBean.putExtraAttr("isNew", true);
                }
            } else {
                if (Strings.isNotBlank((String)contentAll.getContent())) {
                    if (formDataParamBean.getFormMasterId() == null) {
                        formDataMasterBean = this.capTransFormDataBeanManager.transFormDataBeanFromFormBean(formBean, contentAll.getContent(), formAuthViewBean);
                        this.clearSelfTemplateData(formBean, formDataMasterBean, formAuthViewBean.getId());
                        formDataMasterBean.putExtraAttr("isNew", true);
                        formDataMasterBean.putExtraAttr("waitSendByBackOrRepeal", true);
                    } else {
                        formDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(formDataParamBean.getFormMasterId());
                    }
                } else {
                    FormDataMasterBean formDataMasterBean2 = formDataMasterBean = CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(extendData.getOperateType()) ? null : this.cap4FormManager.getSessioMasterDataBean(contentDataId);
                    if (formDataParamBean.isPrintFlag() && formDataMasterBean == null) {
                        formDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(contentDataId);
                    }
                    if (formDataMasterBean == null) {
                        formDataMasterBean = this.capFormDataCacheManager.get4Data(contentDataId, formBean.getId());
                        extendData.setQueryDbAttachments(true);
                    }
                    if (formDataMasterBean == null) {
                        throw new FormDataBusinessException("2011", ResourceUtil.getString((String)"cap.template.form.data.message.delete"));
                    }
                }
                List serialRecordList = this.serialCalRecordManager.selectAllByFormData(formBean.getId(), formDataMasterBean.getId());
                formDataMasterBean.putExtraAttr("serialCalRecords", serialRecordList);
            }
        }
        return formDataMasterBean;
    }

    private List buildCreateOrEditFormSonData(FormDataMasterBean formDataMasterBean, List<FormDataSubBean> dataSubBeans, FormTableBean subTable, FormAuthViewBean formAuthViewBean, Map<String, Object> subFieldInfos, CreateOrEditExtendData extendData) throws BusinessException {
        ArrayList dataSubLineInfos = new ArrayList();
        List<FormFieldBean> subFields = extendData.getFieldBeanMap().get(subTable.getTableName());
        for (FormDataSubBean formDataSubBean : dataSubBeans) {
            HashMap<String, Object> dataSubInfos = new HashMap<String, Object>();
            dataSubLineInfos.add(dataSubInfos);
            dataSubInfos.put(RECORD_ID, String.valueOf(formDataSubBean.getId()));
            if (subFields == null) continue;
            for (FormFieldBean formFieldBean : subFields) {
                String authKey = formFieldBean.getName() + "_" + String.valueOf(formDataSubBean.getId());
                FormAuthViewFieldBean formAuthViewFieldBean = CAPFormUtil.getFormAuthViewFieldBean(formAuthViewBean, formFieldBean, formDataMasterBean, String.valueOf(formDataSubBean.getId()));
                List<Map<String, Object>> enums = null;
                if (FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(formFieldBean.getInputType())) {
                    enums = CAPFormUtil.getFieldEnumJSON(formFieldBean, formDataMasterBean, formDataSubBean, false);
                }
                Object fieldValue = formDataSubBean.getFieldValue(formFieldBean.getName());
                if (FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(formFieldBean.getInputType()) && fieldValue != null && Strings.isEmpty(enums)) {
                    fieldValue = null;
                    formDataSubBean.addFieldValue(formFieldBean.getName(), fieldValue);
                }
                Map<String, Object> dataInfo = CAPFormUtil.getDisplayValueMap(fieldValue, formFieldBean, formAuthViewFieldBean);
                if (formFieldBean.isAttachment()) {
                    dataInfo.put(ATTACHMENT_INFO, CAPAttachmentUtil.getFieldAttachmentMap(formDataMasterBean.getId(), formFieldBean, fieldValue, extendData.getCapFormAttachmentsMap()));
                }
                if (FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(formFieldBean.getInputType())) {
                    dataInfo.put(ENUMS, enums);
                }
                List<FormRelationshipMapBean> formRelationshipMapBeans = extendData.getManualFormRelationshipMapBeanMap().get(formFieldBean.getName());
                Map<String, String> authMap = CAPFormUtil.getAuthMap(formFieldBean, formAuthViewFieldBean, extendData.getOperateType(), extendData.isThreshold());
                dataSubInfos.put(formFieldBean.getName(), dataInfo);
                if (CollectionUtils.isNotEmpty(formRelationshipMapBeans)) {
                    Map<String, String> relationData = CAPFormUtil.getRelationData(formRelationshipMapBeans, extendData.getCapFormRelationRecordMap(), (FormDataBean)formDataSubBean, formFieldBean.getName(), authMap);
                    dataInfo.put(RELATION_DATA, relationData);
                }
                if (extendData.getCapFormTriggerSourceRecordMap().containsKey(authKey)) {
                    Map<String, String> triggerData = CAPFormUtil.getTriggerDataJSON(extendData.getCapFormTriggerSourceRecordMap(), formFieldBean, authMap, String.valueOf(formDataSubBean.getId()));
                    dataInfo.put(TRIGGER_DATA, triggerData);
                }
                dataInfo.putAll(authMap);
            }
        }
        return dataSubLineInfos;
    }

    private void buildCreateOrEditFormSonAuth(FormTableFormsonDataVO formson, Map<String, FormAuthorizationTableBean> subTableAuthMap, FormBean formBean, FormAuthViewBean formAuthViewBean, FormTableBean subTable, CreateOrEditExtendData extendData) {
        Map<String, String> tableAuth;
        List<Map<String, Object>> tableButtons;
        FormAuthorizationTableBean authTableBean;
        FormAuthorizationTableBean formAuthorizationTableBean = authTableBean = subTableAuthMap.get(subTable.getTableName()) == null ? formAuthViewBean.getSubTableAuth(subTable.getDisplay()) : subTableAuthMap.get(subTable.getTableName());
        if (CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(extendData.getOperateType()) || extendData.isThreshold()) {
            tableButtons = new ArrayList<Map<String, Object>>();
            tableAuth = new HashMap<String, String>();
        } else {
            tableButtons = this.capRuntimeCalcManager.getFormSonAuthButtons(formBean, formAuthViewBean, subTable, authTableBean, false);
            tableAuth = this.capRuntimeCalcManager.getFormSonAuth(authTableBean, false);
        }
        formson.setTableButton(tableButtons);
        formson.setTableAuth(tableAuth);
    }

    private Map<String, Object> buildCreateOrEditFormSonFields(FormDataMasterBean formDataMasterBean, FormTableBean subTable, CreateOrEditExtendData extendData) throws BusinessException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        List<FormFieldBean> subFields = extendData.getFieldBeanMap().get(subTable.getTableName());
        if (subFields == null) {
            return fieldMap;
        }
        for (FormFieldBean formFieldBean : subFields) {
            Map<String, Object> subFieldInfo = CAPFormUtil.getFormFieldInfo(formFieldBean, formDataMasterBean);
            CAPFormUtil.resetFormFieldInfo(subFieldInfo, extendData.getOperateType(), extendData.getAutoIncConditionFields());
            List<FormRelationshipMapBean> formRelationshipMapBeans = extendData.getManualFormRelationshipMapBeanMap().get(formFieldBean.getName());
            if (CollectionUtils.isNotEmpty(formRelationshipMapBeans)) {
                subFieldInfo.put(RELATION_INFO, CAPFormUtil.getRelationInfoMaps(formRelationshipMapBeans));
            }
            fieldMap.put(formFieldBean.getName(), subFieldInfo);
        }
        return fieldMap;
    }

    private Map<String, Object> buildCreateOrEditMasterFields(FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, CreateOrEditExtendData extendData) throws BusinessException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        List<FormFieldBean> masterFields = extendData.getFieldBeanMap().get(formDataMasterBean.getFormTable().getTableName());
        for (FormFieldBean formFieldBean : masterFields) {
            FormAuthViewFieldBean formAuthViewFieldBean = CAPFormUtil.getFormAuthViewFieldBean(formAuthViewBean, formFieldBean, formDataMasterBean, null);
            Map<String, String> authMap = CAPFormUtil.getAuthMap(formFieldBean, formAuthViewFieldBean, extendData.getOperateType(), extendData.isThreshold());
            Map<String, Object> fieldInfo = CAPFormUtil.getFormFieldInfo(formFieldBean, formDataMasterBean);
            Object fieldValue = formDataMasterBean.getFieldValue(formFieldBean.getName());
            if (FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(formFieldBean.getInputType()) && fieldValue != null && fieldInfo.get(ENUMS) != null && Strings.isEmpty((Collection)((List)fieldInfo.get(ENUMS)))) {
                fieldValue = null;
                formDataMasterBean.addFieldValue(formFieldBean.getName(), fieldValue);
            }
            CAPFormUtil.resetFormFieldInfo(fieldInfo, extendData.getOperateType(), extendData.getAutoIncConditionFields());
            Map<String, Object> dataInfo = CAPFormUtil.getDisplayValueMap(fieldValue, formFieldBean, formAuthViewFieldBean);
            List<FormRelationshipMapBean> formRelationshipMapBeans = extendData.getManualFormRelationshipMapBeanMap().get(formFieldBean.getName());
            if (CollectionUtils.isNotEmpty(formRelationshipMapBeans)) {
                Map<String, String> relationData = CAPFormUtil.getRelationData(formRelationshipMapBeans, extendData.getCapFormRelationRecordMap(), (FormDataBean)formDataMasterBean, formFieldBean.getName(), authMap);
                fieldInfo.put(RELATION_INFO, CAPFormUtil.getRelationInfoMaps(formRelationshipMapBeans));
                dataInfo.put(RELATION_DATA, relationData);
            }
            if (extendData.getCapFormTriggerSourceRecordMap().containsKey(formFieldBean.getName())) {
                Map<String, String> triggerData = CAPFormUtil.getTriggerDataJSON(extendData.getCapFormTriggerSourceRecordMap(), formFieldBean, authMap, null);
                dataInfo.put(TRIGGER_DATA, triggerData);
            }
            if (formFieldBean.isAttachment()) {
                fieldInfo.put(ATTACHMENT_INFO, CAPAttachmentUtil.getFieldAttachmentMap(formDataMasterBean.getId(), formFieldBean, fieldValue, extendData.getCapFormAttachmentsMap()));
            }
            dataInfo.putAll(authMap);
            fieldInfo.putAll(dataInfo);
            fieldMap.put(formFieldBean.getName(), fieldInfo);
        }
        return fieldMap;
    }

    private void createResultUser(FormDataVO formDataVO, User currentUser) {
        FormDataVO.User user = formDataVO.new FormDataVO.User();
        user.setId(String.valueOf(currentUser.getId()));
        user.setName(currentUser.getName());
        user.setLoginName(currentUser.getLoginName());
        formDataVO.setUser(user);
    }

    private void dealAutoIncreaseRow(List<FormRelationshipMapBean> autoIncreaseRowBeans, FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, String rightId, boolean isWaitSentEdit, Set<String> clearSubReferences) throws BusinessException {
        HashMap<String, Set<String>> tableName2DeleteIds = new HashMap<String, Set<String>>();
        Iterator<FormRelationshipMapBean> it = autoIncreaseRowBeans.iterator();
        boolean flag = false;
        while (it.hasNext()) {
            FormRelationshipMapBean autoIncreaseRowBean = it.next();
            if (autoIncreaseRowBean.getRefreshOperationUpdate() != null && autoIncreaseRowBean.getRefreshOperationUpdate().contains(rightId)) {
                flag = true;
                this.cap4FormRelationActionManager.getRelationAutoIncreaseRow(formBean, formDataMasterBean, formAuthViewBean, autoIncreaseRowBean, tableName2DeleteIds, clearSubReferences);
                continue;
            }
            if (autoIncreaseRowBean.getRefreshOperationAdd() != null && autoIncreaseRowBean.getRefreshOperationAdd().contains(rightId)) {
                if (isWaitSentEdit) {
                    if (autoIncreaseRowBean.getWaitSentRefresh() != 1) continue;
                    flag = true;
                    this.cap4FormRelationActionManager.getRelationAutoIncreaseRow(formBean, formDataMasterBean, formAuthViewBean, autoIncreaseRowBean, tableName2DeleteIds, clearSubReferences);
                    continue;
                }
                flag = true;
                this.cap4FormRelationActionManager.getRelationAutoIncreaseRow(formBean, formDataMasterBean, formAuthViewBean, autoIncreaseRowBean, tableName2DeleteIds, clearSubReferences);
                continue;
            }
            if (autoIncreaseRowBean.getWaitSentRefresh() == 1 && isWaitSentEdit) {
                flag = true;
                this.cap4FormRelationActionManager.getRelationAutoIncreaseRow(formBean, formDataMasterBean, formAuthViewBean, autoIncreaseRowBean, tableName2DeleteIds, clearSubReferences);
                continue;
            }
            it.remove();
        }
        if (flag) {
            AppContext.putThreadContext((String)"waitSentOpen", (Object)isWaitSentEdit);
            this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, formAuthViewBean, false, false, true, false);
            AppContext.removeThreadContext((String)"waitSentOpen");
        }
    }

    private boolean checkFormsonNum(String from, FormDataMasterBean formDataMasterBean) {
        if (CAPBusinessEnum.FormOpenFrom.ORIGINAL_FORM.getKey().equals(from) || CAPBusinessEnum.FormOpenFrom.LIGHT_FORM.getKey().equals(from)) {
            Map dataSubBeanMap = formDataMasterBean.getSubTables();
            Iterator it = dataSubBeanMap.keySet().iterator();
            int formsonTotal = 0;
            while (it.hasNext()) {
                List formDataSubBeans = (List)dataSubBeanMap.get(it.next());
                formsonTotal += formDataSubBeans.size();
            }
            if (formsonTotal > 2000) {
                return true;
            }
        }
        return false;
    }

    private void dealRightIdAndViews(FormDataParamBean formDataParamBean, Long formId) {
        int userAgent = this.getUserAgent(formDataParamBean);
        String rightId = formDataParamBean.getRightId();
        String currentRightId = formDataParamBean.getCurrentRightId();
        if (CAPBusinessEnum.FormOpenFrom.TRIGGER_MESSAGE.getKey().equals(formDataParamBean.getFrom())) {
            rightId = CAPFormUtil.isPcLogin(userAgent) ? rightId.split(",")[0] : rightId.split(",")[1];
        }
        HashSet<String> pcRightIdSet = new HashSet<String>();
        HashSet<String> phoneRightIdSet = new HashSet<String>();
        ArrayList<Map<String, Object>> views = new ArrayList<Map<String, Object>>();
        if (Strings.isNotBlank((String)rightId)) {
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            if (rightId.indexOf("_") > -1 || rightId.indexOf(".") > -1) {
                String[] viewStrs = rightId.split("_");
                for (int i = 0; i < viewStrs.length; ++i) {
                    String rightIdStr = viewStrs[i].indexOf(".") > -1 ? viewStrs[i].split("\\.")[1].split("[|]")[0] : viewStrs[i].split("[|]")[0];
                    FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightIdStr)));
                    if (formAuthViewBean == null) continue;
                    FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
                    if (CAPFormUtil.isPhoneLogin(userAgent) && Enums.ViewType.Phone == formViewBean.getFormViewTypeEnum() || CAPFormUtil.isPcLogin(userAgent) && Enums.ViewType.SeeyonForm == formViewBean.getFormViewTypeEnum()) {
                        HashMap<String, String> view = new HashMap<String, String>();
                        view.put("rightId", rightIdStr);
                        view.put("name", formViewBean.getFormViewName());
                        views.add(view);
                        if (Strings.isBlank((String)currentRightId)) {
                            currentRightId = rightIdStr;
                        }
                    }
                    if (formViewBean.isPc()) {
                        pcRightIdSet.add(rightIdStr);
                    }
                    if (!formViewBean.isPhone()) continue;
                    phoneRightIdSet.add(rightIdStr);
                }
            }
            if (Strings.isNotBlank((String)currentRightId)) {
                rightId = currentRightId;
            } else {
                rightId = rightId.contains("_") ? rightId.split("_")[0] : rightId;
                rightId = rightId.contains(".") ? rightId.split("[.]")[1] : rightId;
                rightId = rightId.contains("|") ? rightId.split("[|]")[0] : rightId;
            }
        }
        formDataParamBean.setCurrentRightId(currentRightId);
        formDataParamBean.setRightId(rightId);
        formDataParamBean.setViews(views);
        formDataParamBean.setUserAgent(userAgent);
        formDataParamBean.setPcRightIdSet(pcRightIdSet);
        formDataParamBean.setPhoneRightIdSet(phoneRightIdSet);
    }

    private boolean checkCreateOrEditAuth(CtpContentAll contentAll, FormDataParamBean formDataParamBean) throws BusinessException {
        User currentUser = formDataParamBean.getCurrentUser();
        boolean isAccess = false;
        Long contentDataId = contentAll.getContentDataId();
        String designId = formDataParamBean.getDesignId();
        FormBean formBean = this.cap4FormCacheManager.getForm(contentAll.getContentTemplateId());
        String rightId = formDataParamBean.getRightId();
        if (contentDataId == null) {
            if (contentAll.getModuleType().intValue() == ModuleType.cap4UnflowForm.getKey()) {
                FormBindAuthBean formBindAuthBean = null;
                if (formDataParamBean.getFormTemplateId() != null) {
                    formBindAuthBean = formBean.getBind().getFormBindAuthBean(formDataParamBean.getFormTemplateId().toString());
                }
                formDataParamBean.setFormBindAuthBean(formBindAuthBean);
                isAccess = formBindAuthBean != null && formBindAuthBean.checkRight(currentUser.getId().longValue());
            } else if (contentAll.getModuleType().intValue() == ModuleType.collaboration.getKey()) {
                isAccess = this.capFormManager.checkRightId(Long.valueOf(rightId));
            }
        } else {
            Long moduleId = contentAll.getModuleId();
            if (contentAll.getModuleType().intValue() == ModuleType.cap4UnflowForm.getKey()) {
                FormBindAuthBean formBindAuthBean = null;
                if (formDataParamBean.getFormTemplateId() != null) {
                    formBindAuthBean = formBean.getBind().getFormBindAuthBean(formDataParamBean.getFormTemplateId().toString());
                }
                if (!(isAccess = AccessControlBean.getInstance().isAccess(ApplicationCategoryEnum.form, moduleId.toString(), currentUser.getId().longValue())) && Strings.isNotBlank((String)designId)) {
                    isAccess = this.reportApi.checkAuth(Long.valueOf(designId), currentUser.getId());
                }
                if (!isAccess && formBindAuthBean != null) {
                    isAccess = formBindAuthBean.checkRight(currentUser.getId().longValue());
                }
                if (!isAccess) {
                    List allBindAuths = formBean.getBind().getUnflowFormBindAuthByUserId(currentUser.getId());
                    block0: for (FormBindAuthBean bindAuthBean : allBindAuths) {
                        List list = bindAuthBean.getAuthList();
                        for (SimpleObjectBean sob : list) {
                            if ((!Strings.isNotBlank((String)sob.getValue()) || sob.getValue().indexOf(rightId) <= -1) && (!Strings.isNotBlank((String)sob.getPhoneValue()) || sob.getPhoneValue().indexOf(rightId) <= -1)) continue;
                            formBindAuthBean = bindAuthBean;
                            isAccess = true;
                            continue block0;
                        }
                    }
                }
                if (formBindAuthBean != null && formBindAuthBean.getFormFormulaBean() != null) {
                    FlipInfo flipInfo = new FlipInfo();
                    AppContext.putThreadContext((String)"check_right_data_id", (Object)contentDataId);
                    this.cap4FormDataManager.getFormQueryResult(currentUser.getId(), flipInfo, false, formBean, null, FormQueryTypeEnum.unFlowCheckRight, null, null, null, null, null, false);
                    AppContext.removeThreadContext((String)"check_right_data_id");
                    isAccess = !Strings.isEmpty((Collection)flipInfo.getData());
                }
                formDataParamBean.setFormBindAuthBean(formBindAuthBean);
                if (isAccess) {
                    CAPFormUtil.addFormAccessControl(moduleId, currentUser.getId());
                }
            } else if (contentAll.getModuleType().intValue() == ModuleType.collaboration.getKey() && (isAccess = this.capFormManager.checkRightId(Long.valueOf(rightId)))) {
                isAccess = AccessControlBean.getInstance().isAccess(ApplicationCategoryEnum.form, moduleId.toString(), currentUser.getId().longValue());
            }
        }
        return isAccess;
    }

    private boolean isWaitSentEdit(ModuleType mType, String operateType, Long contentDataId) {
        return mType == ModuleType.collaboration && CAPBusinessEnum.FormOperateType.NEW.getKey().equals(operateType) && contentDataId != null;
    }

    private void removeEmptyFieldsRightId(FormBean formBean, Set<String> rightIds, FormDataParamBean formDataParamBean) {
        if (rightIds != null) {
            Iterator<String> iterator = rightIds.iterator();
            while (iterator.hasNext()) {
                String rightId = iterator.next();
                FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(rightId));
                if (formAuthViewBean == null) {
                    iterator.remove();
                    continue;
                }
                FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId(), formDataParamBean.getLang());
                if (formViewBean != null && formViewBean.hasFields()) continue;
                iterator.remove();
            }
        }
    }

    private void clearSelfTemplateData(FormBean formBean, FormDataMasterBean formDataMasterBean, Long rightId) throws BusinessException {
        Map<String, Map<String, Object>> fields = this.cap4FormDataManager.getClearFields(formBean, String.valueOf(rightId));
        if (fields != null) {
            Map capFormRelationRecordMap = formDataMasterBean.getRelationRecordMap();
            List capFormRelationRecords = formDataMasterBean.getRelationRecords();
            String masterTableName = formBean.getMasterTableBean().getTableName();
            Map<String, Object> clearMasterFields = fields.get(masterTableName);
            if (clearMasterFields != null) {
                for (String key : clearMasterFields.keySet()) {
                    formDataMasterBean.addFieldValue(key, clearMasterFields.get(key));
                    if (capFormRelationRecordMap.get(key) == null) continue;
                    capFormRelationRecords.remove(capFormRelationRecordMap.get(key));
                }
            }
            List subTableBeans = formBean.getSubTableBean();
            for (FormTableBean formTableBean : subTableBeans) {
                String subTableName = formTableBean.getTableName();
                Map<String, Object> clearSubFields = fields.get(subTableName);
                if (clearSubFields == null) continue;
                Iterator<String> it = clearSubFields.keySet().iterator();
                List formDataSubBeans = formDataMasterBean.getSubData(subTableName);
                while (it.hasNext()) {
                    String key = it.next();
                    for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                        formDataSubBean.addFieldValue(key, clearSubFields.get(key));
                        String key1 = key + "_" + formDataSubBean.getId();
                        if (capFormRelationRecordMap.get(key1) == null) continue;
                        capFormRelationRecords.remove(capFormRelationRecordMap.get(key1));
                    }
                }
            }
        }
    }

    protected int getUserAgent(FormDataParamBean formDataParamBean) {
        int userAgent = formDataParamBean.getCurrentUser().getLoginSign();
        String from = formDataParamBean.getFrom();
        if (CAPBusinessEnum.FormOpenFrom.ORIGINAL_FORM.getKey().equals(from)) {
            userAgent = Constants.login_sign.pc.value();
        } else if (CAPBusinessEnum.FormOpenFrom.LIGHT_FORM.getKey().equals(from)) {
            userAgent = Constants.login_sign.phone.value();
        } else if (CAPBusinessEnum.FormOpenFrom.API_FORWARD.getKey().equals(from)) {
            userAgent = formDataParamBean.getUserAgent();
        }
        if (Constants.login_sign.ucpc.value() == userAgent) {
            userAgent = Constants.login_sign.pc.value();
        }
        if (Constants.login_sign.wechat.value() == userAgent) {
            userAgent = Constants.login_sign.phone.value();
        }
        return userAgent;
    }

    public void setAffairManager(AffairManager affairManager) {
        this.affairManager = affairManager;
    }

    public void setSerialCalRecordManager(SerialCalRecordManager serialCalRecordManager) {
        this.serialCalRecordManager = serialCalRecordManager;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setSimulationApi(SimulationApi simulationApi) {
        this.simulationApi = simulationApi;
    }

    public void setCap4FormTriggerSourceRecordDAO(CAP4FormTriggerSourceRecordDAO cap4FormTriggerSourceRecordDAO) {
        this.cap4FormTriggerSourceRecordDAO = cap4FormTriggerSourceRecordDAO;
    }

    public void setCapCustomService(CAPCustomService capCustomService) {
        this.capCustomService = capCustomService;
    }

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public void setCapFormDataSignatureService(CAPFormDataSignatureService capFormDataSignatureService) {
        this.capFormDataSignatureService = capFormDataSignatureService;
    }

    public void setCapFormDataForwardService(CAPFormDataForwardService capFormDataForwardService) {
        this.capFormDataForwardService = capFormDataForwardService;
    }

    public void setCapTransFormDataBeanManager(CAPTransFormDataBeanManager capTransFormDataBeanManager) {
        this.capTransFormDataBeanManager = capTransFormDataBeanManager;
    }

    private class CreateOrEditExtendData {
        private Map<String, CAPFormTriggerSourceRecord> capFormTriggerSourceRecordMap = new HashMap<String, CAPFormTriggerSourceRecord>();
        private Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeanMap = new HashMap<String, List<FormRelationshipMapBean>>();
        private Map<String, CAPFormRelationRecord> capFormRelationRecordMap = new HashMap<String, CAPFormRelationRecord>();
        private Map<String, List<Map<String, String>>> capFormAttachmentsMap = new HashMap<String, List<Map<String, String>>>();
        private Map<String, List<FormFieldBean>> fieldBeanMap = new HashMap<String, List<FormFieldBean>>();
        private List<CAPFormRelationRecord> capFormRelationRecords = new ArrayList<CAPFormRelationRecord>();
        private Set<String> clearSubReferences = new HashSet<String>();
        private Set<String> autoIncConditionFields;
        private String operateType;
        private boolean isThreshold;
        private boolean queryDbAttachments = false;

        private CreateOrEditExtendData() {
        }

        public Map<String, CAPFormTriggerSourceRecord> getCapFormTriggerSourceRecordMap() {
            return this.capFormTriggerSourceRecordMap;
        }

        public void setCapFormTriggerSourceRecordMap(Map<String, CAPFormTriggerSourceRecord> capFormTriggerSourceRecordMap) {
            this.capFormTriggerSourceRecordMap = capFormTriggerSourceRecordMap;
        }

        public Map<String, List<FormRelationshipMapBean>> getManualFormRelationshipMapBeanMap() {
            return this.manualFormRelationshipMapBeanMap;
        }

        public void setManualFormRelationshipMapBeanMap(Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeanMap) {
            this.manualFormRelationshipMapBeanMap = manualFormRelationshipMapBeanMap;
        }

        public Map<String, CAPFormRelationRecord> getCapFormRelationRecordMap() {
            return this.capFormRelationRecordMap;
        }

        public void setCapFormRelationRecordMap(Map<String, CAPFormRelationRecord> capFormRelationRecordMap) {
            this.capFormRelationRecordMap = capFormRelationRecordMap;
        }

        public Map<String, List<Map<String, String>>> getCapFormAttachmentsMap() {
            return this.capFormAttachmentsMap;
        }

        public void setCapFormAttachmentsMap(Map<String, List<Map<String, String>>> capFormAttachmentsMap) {
            this.capFormAttachmentsMap = capFormAttachmentsMap;
        }

        public Map<String, List<FormFieldBean>> getFieldBeanMap() {
            return this.fieldBeanMap;
        }

        public void setFieldBeanMap(Map<String, List<FormFieldBean>> fieldBeanMap) {
            this.fieldBeanMap = fieldBeanMap;
        }

        public List<CAPFormRelationRecord> getCapFormRelationRecords() {
            return this.capFormRelationRecords;
        }

        public void setCapFormRelationRecords(List<CAPFormRelationRecord> capFormRelationRecords) {
            this.capFormRelationRecords = capFormRelationRecords;
        }

        public Set<String> getAutoIncConditionFields() {
            return this.autoIncConditionFields;
        }

        public void setAutoIncConditionFields(Set<String> autoIncConditionFields) {
            this.autoIncConditionFields = autoIncConditionFields;
        }

        public String getOperateType() {
            return this.operateType;
        }

        public void setOperateType(String operateType) {
            this.operateType = operateType;
        }

        public boolean isThreshold() {
            return this.isThreshold;
        }

        public void setThreshold(boolean threshold) {
            this.isThreshold = threshold;
        }

        public boolean getQueryDbAttachments() {
            return this.queryDbAttachments;
        }

        public void setQueryDbAttachments(boolean queryDbAttachments) {
            this.queryDbAttachments = queryDbAttachments;
        }

        public Set<String> getClearSubReferences() {
            return this.clearSubReferences;
        }

        public void setClearSubReferences(Set<String> clearSubReferences) {
            this.clearSubReferences = clearSubReferences;
        }
    }
}

