/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.apps.index.api.IndexApi;
import com.seeyon.cap4.form.api.FormApi4Cap4;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.event.FormDataAfterSubmitEvent;
import com.seeyon.cap4.form.modules.event.FormDataBeforeSubmitEvent;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.po.CAPFormRelationRecord;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.monitor.utils.CAP4MonitorUtil;
import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.FlowFormCopyDataParamBean;
import com.seeyon.cap4.template.bean.FormDataAttachmentParamBean;
import com.seeyon.cap4.template.bean.FormDataCalculateParamBean;
import com.seeyon.cap4.template.bean.FormDataSubRowOperationParamBean;
import com.seeyon.cap4.template.bean.LockObjectBean;
import com.seeyon.cap4.template.bean.ScreenCapture4FormParamBean;
import com.seeyon.cap4.template.bean.UnFlowFormGetFormDataRightParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.result.FormDataSubRowOperationResult;
import com.seeyon.cap4.template.result.ScreenCaptureResult;
import com.seeyon.cap4.template.service.AbstractCAPFormDataService;
import com.seeyon.cap4.template.service.CAPScreenCaptureService;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormDataLogUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.mainbody.MainbodyStatus;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMCallingObj;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMTrackUtils;
import com.seeyon.ctp.monitor.performance.FormRunTypeEnum;
import com.seeyon.ctp.monitor.performance.JMMonitorService;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class CAPFormDataService
extends AbstractCAPFormDataService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataService.class);
    private static final String UPDATE_LOG = "cap.template.form.data.log.update";
    private static final String CREATE_LOG = "cap.template.form.data.log.create";
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private CAP4SerialNumberManager cap4SerialNumberManager;
    private JMMonitorService jmMonitorService;
    private CAPScreenCaptureService capScreenCaptureService;
    private FormApi4Cap4 formApi4Cap4;
    private static final String SAVE_TYPE = "saveType";
    private static final String CUSTOM_FIELDS = "customFields";
    private static final String TABLE_NAME_TO_ADD_SUB_OBJECTS = "tableName2AddSubObjects";
    private static final String TABLE_NAME_TO_DELETE_IDS = "table2DeleteIds";
    private static final String FILL_BACK_FIELDS = "fillBackFields";
    private static final String CLEAR_TABLES = "clearTables";

    @ValidateRequestParam(notEmpty={"formMasterDataId"}, validateCacheBeanKey="formMasterDataId")
    public FormDataResult copyFormData(FlowFormCopyDataParamBean paramBean) {
        CtpContentAll contentAll = this.getCtpContentAllByModuleIdAndType(paramBean.getCopyFrom());
        FormDataResult<Map<String, Object>> result = new FormDataResult<Map<String, Object>>();
        if (contentAll == null) {
            result.error("2011", ResourceUtil.getString((String)"cap.template.form.data.message.delete"));
            return result;
        }
        try {
            HashSet<String> fillBackFields = new HashSet<String>();
            HashSet<String> clearTables = new HashSet<String>();
            FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            FormDataMasterBean formDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterDataId());
            FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(paramBean.getRightId());
            FormDataMasterBean copyFromMasterBean = this.capFormDataCacheManager.get4Data(contentAll.getContentDataId(), formBean.getId());
            Map<String, List<FormFieldBean>> fieldBeanMap = CAPFormUtil.getTableName2FieldBeans(formBean, formAuthViewBean.getViewBean(formBean));
            if (fieldBeanMap.containsKey(formBean.getMasterTableBean().getTableName())) {
                List<FormFieldBean> masterFields = fieldBeanMap.get(formBean.getMasterTableBean().getTableName());
                for (FormFieldBean fieldBean : masterFields) {
                    this.fillCopyFormFieldData(formBean, (FormDataBean)formDataMasterBean, (FormDataBean)copyFromMasterBean, fieldBean, formAuthViewBean, fillBackFields);
                }
            }
            HashMap<String, List<FormDataSubBean>> tableName2AddSubBeans = new HashMap<String, List<FormDataSubBean>>();
            HashMap<String, Set<String>> tableName2DeleteIds = new HashMap<String, Set<String>>();
            for (String tableName : fieldBeanMap.keySet()) {
                FormTableBean tableBean = formBean.getTableByTableName(tableName);
                if (tableBean.isMainTable()) continue;
                HashSet<String> oldIds = new HashSet<String>();
                List oldSubBeans = formDataMasterBean.getSubData(tableBean.getTableName());
                for (FormDataSubBean subBean : oldSubBeans) {
                    oldIds.add(String.valueOf(subBean.getId()));
                }
                tableName2DeleteIds.put(tableBean.getTableName(), oldIds);
                List<FormFieldBean> subFields = fieldBeanMap.get(tableName);
                List copyFromSubBeans = copyFromMasterBean.getSubData(tableBean.getTableName());
                ArrayList<FormDataSubBean> newSubBeans = new ArrayList<FormDataSubBean>();
                for (FormDataSubBean subBean : copyFromSubBeans) {
                    FormDataSubBean newSubBean = new FormDataSubBean(tableBean, formDataMasterBean, new boolean[]{true});
                    newSubBean.setFormmainId(formDataMasterBean.getId().longValue());
                    this.initAddSubDataBean(formDataMasterBean, formAuthViewBean, tableBean, newSubBean);
                    for (FormFieldBean fieldBean : subFields) {
                        this.fillCopyFormFieldData(formBean, (FormDataBean)newSubBean, (FormDataBean)subBean, fieldBean, formAuthViewBean, null);
                    }
                    newSubBeans.add(newSubBean);
                }
                formDataMasterBean.setSubData(tableBean.getTableName(), newSubBeans);
                clearTables.add(tableBean.getTableName());
                tableName2AddSubBeans.put(tableBean.getTableName(), newSubBeans);
            }
            Set<String> calcFillBackFields = this.capRuntimeCalcManager.execCalcAll(formBean, formDataMasterBean, formAuthViewBean, CAPFormUtil.getTableName2FormSubDataBeanIds(tableName2AddSubBeans));
            fillBackFields.addAll(calcFillBackFields);
            HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
            this.capRuntimeCalcManager.buildCalcAllResult(formBean, formDataMasterBean, formAuthViewBean, tableName2AddSubBeans, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.COPY_FORM_DATA, tableName2DataMaps);
            this.mergeAutoDelete2Result(tableName2DeleteIds, tableName2DataMaps);
            HashMap<String, Cloneable> resultData = new HashMap<String, Cloneable>();
            resultData.put("tableData", tableName2DataMaps);
            resultData.put(CLEAR_TABLES, clearTables);
            result.success(resultData);
            this.buildExtendResult(formBean, formDataMasterBean, formAuthViewBean, result);
            this.cap4FormManager.saveSessioMasterDataBean(formDataMasterBean.getId(), formDataMasterBean);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e);
            result.error("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
        return result;
    }

    private boolean checkEnumParentAuth(FormBean formBean, FormAuthViewBean formAuthViewBean, FormFieldBean fieldBean) {
        boolean result = true;
        if (Strings.isNotEmpty((String)fieldBean.getEnumParent())) {
            FormAuthViewFieldBean parentAuthField = formAuthViewBean.getFormAuthorizationField(fieldBean.getEnumParent());
            if (!Enums.FieldAccessType.edit.getKey().equals(parentAuthField.getAccess())) {
                return false;
            }
            FormFieldBean parentFieldBean = formBean.getFieldBeanByName(fieldBean.getEnumParent());
            if (Strings.isNotEmpty((String)parentFieldBean.getEnumParent())) {
                return this.checkEnumParentAuth(formBean, formAuthViewBean, parentFieldBean);
            }
        }
        return result;
    }

    private void fillCopyFormFieldData(FormBean formBean, FormDataBean cacheDataBean, FormDataBean copyFromBean, FormFieldBean fieldBean, FormAuthViewBean formAuthViewBean, Set<String> fillBackFields) throws BusinessException {
        if (fieldBean.isFormulaSn() || fieldBean.isSn() || fieldBean.isCustomerCtrl() || FormFieldComEnum.FLOWDEALOPITION.getKey().equalsIgnoreCase(fieldBean.getInputType())) {
            return;
        }
        FormAuthViewFieldBean formAuthViewFieldBean = formAuthViewBean.getFormAuthorizationField(fieldBean.getName());
        if (!Enums.FieldAccessType.edit.getKey().equals(formAuthViewFieldBean.getAccess())) {
            return;
        }
        if (fieldBean.isEnumField() && !this.checkEnumParentAuth(formBean, formAuthViewBean, fieldBean)) {
            return;
        }
        FormDataSubBean cacheSubBean = cacheDataBean instanceof FormDataSubBean ? (FormDataSubBean)cacheDataBean : null;
        FormDataMasterBean cacheFormDataMasterBean = cacheSubBean != null ? cacheSubBean.getMasterData() : (FormDataMasterBean)cacheDataBean;
        Object oldDataValue = cacheDataBean.getFieldValue(fieldBean.getName());
        Object value = copyFromBean.getFieldValue(fieldBean.getName());
        if (value != null && (fieldBean.isAttachment() || fieldBean.isMap()) && Strings.isNotBlank((String)String.valueOf(value))) {
            Long subReference = Long.valueOf(String.valueOf(value));
            Long newSubReference = null;
            if (fieldBean.isMap()) {
                newSubReference = CAPFormUtil.copyLBS(formBean.getId(), cacheFormDataMasterBean.getId(), null, subReference, fieldBean);
            }
            if (fieldBean.isAttachment()) {
                newSubReference = CAPAttachmentUtil.copyAttachment(cacheFormDataMasterBean, fieldBean, subReference, cacheFormDataMasterBean.getId(), newSubReference, false);
            }
            value = newSubReference;
        }
        if ((fieldBean.isAttachment() || fieldBean.isMap()) && oldDataValue != null && !String.valueOf(oldDataValue).equals(String.valueOf(value))) {
            cacheFormDataMasterBean.putSessionAttachments(String.valueOf(oldDataValue), null);
        }
        cacheDataBean.addFieldValue(fieldBean.getName(), value);
        if (fillBackFields != null) {
            fillBackFields.add(cacheDataBean.generageFillbackKey(fieldBean.getName()));
        }
        cacheFormDataMasterBean.addFieldChanges4Calc(fieldBean, value, cacheSubBean);
    }

    public FormDataResult getFormDataRightInfo(UnFlowFormGetFormDataRightParamBean paramBean) {
        FormDataResult<Map<String, String>> result = new FormDataResult<Map<String, String>>();
        CtpContentAll contentAll = this.getCtpContentAll(paramBean.getModuleId(), paramBean.getModuleType());
        if (contentAll == null) {
            result.error("2011", ResourceUtil.getString((String)"cap.template.form.data.message.delete"));
            return result;
        }
        try {
            Long formId = contentAll.getContentTemplateId();
            String rightId = paramBean.getRightId();
            if (contentAll.getModuleType().intValue() == ModuleType.cap4UnflowForm.getKey() && contentAll.getContentDataId() == null && StringUtils.equals((String)"-1", (String)rightId) && paramBean.getFormTemplateId() != null) {
                FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                FormBindAuthBean formBindAuthBean = formBean.getBind().getUnFlowTemplateById(paramBean.getFormTemplateId());
                SimpleObjectBean simpleObjectBean = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.ADD.getKey());
                rightId = simpleObjectBean.getValue() + "_" + simpleObjectBean.getPhoneValue();
            }
            result.success(this.cap4FormManager.getFormDataRightInfo(formId, rightId, contentAll, AppContext.getLocale().toString()));
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"\u79fb\u52a8\u7aef\u65e0\u6d41\u7a0b\u8868\u5355\u2014\u2014\u83b7\u53d6\u8868\u5355\u7684\u89c6\u56fe\u4fe1\u606f:", (Throwable)e);
            result.error("2001", e.getMessage());
        }
        return result;
    }

    public Map<String, Object> removeSessionFormCache(String contentDataId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "2000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        this.cap4FormManager.removeSessionMasterDataBean(Long.valueOf(contentDataId));
        return result;
    }

    public Map<String, Object> removeSessionFormCache(String contentDataId, String moduleId, String moduleType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "2000");
        result.put("message", "cap.template.message.success");
        contentDataId = "undefined".equalsIgnoreCase(contentDataId) ? "" : contentDataId;
        moduleId = "undefined".equalsIgnoreCase(moduleId) ? "" : moduleId;
        moduleType = "undefined".equalsIgnoreCase(moduleType) ? "" : moduleType;
        Long userId = AppContext.currentUserId();
        if (!StringUtil.checkNull((String)contentDataId)) {
            this.cap4FormManager.removeSessionMasterDataBean(Long.valueOf(contentDataId));
            this.cap4FormRelationActionManager.removeCacheRelationData(Long.valueOf(contentDataId));
            LOGGER.info((Object)("removeSessionFormCache by contentDataId " + contentDataId + " " + userId));
        }
        if (!(StringUtil.checkNull((String)moduleId) || StringUtil.checkNull((String)moduleType) || String.valueOf(contentDataId).equals(String.valueOf(moduleId)))) {
            LOGGER.info((Object)("removeSessionFormCache by moduleId " + moduleId + " " + userId));
            HashMap<String, Number> contentParams = new HashMap<String, Number>(2);
            contentParams.put("moduleType", Integer.parseInt(moduleType));
            contentParams.put("moduleId", Long.valueOf(moduleId));
            List contentPoList = this.ctpMainbodyManager.getContentList(contentParams);
            CtpContentAll ctpContentAll = null;
            if (contentPoList != null && contentPoList.size() > 0) {
                ctpContentAll = (CtpContentAll)contentPoList.get(0);
            }
            if (ctpContentAll != null && ctpContentAll.getContentDataId() != null) {
                this.cap4FormManager.removeSessionMasterDataBean(ctpContentAll.getContentDataId());
                this.cap4FormRelationActionManager.removeCacheRelationData(ctpContentAll.getContentDataId());
                LOGGER.info((Object)("removeSessionFormCache by moduleId " + moduleId + " contentDataId " + ctpContentAll.getContentDataId() + " " + userId));
            }
        }
        return result;
    }

    private static Boolean getParamBooleanValue(Object value, boolean inputBoolean) {
        if (value instanceof Boolean) {
            inputBoolean = (Boolean)value;
        } else if (value instanceof String) {
            inputBoolean = Strings.isNotBlank((String)((String)value)) && "1".equals((String)value);
        }
        return inputBoolean;
    }

    public FormDataResult<Map<String, Object>> saveOrUpdateForm(Map<String, Object> params) {
        FormDataResult<Map<String, Object>> result = new FormDataResult<Map<String, Object>>();
        result.error("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        try {
            Map content = (Map)params.get("content");
            if (content == null) {
                result.error("2004", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "content"));
            } else {
                String contentDataId = (String)content.get("contentDataId");
                FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(Long.valueOf(contentDataId));
                if (cacheFormDataMasterBean == null) {
                    result.error("2010", ResourceUtil.getString((String)"cap.template.form.data.message.cacheDisabled"));
                } else {
                    result = this.saveFormData(cacheFormDataMasterBean, content, params);
                    this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"saveFormData.BusinessException.error is", (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"saveFormData.SQLException.error is", (Throwable)e);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Object)"saveFormData.CloneNotSupportedException.error is", (Throwable)e);
        }
        return result;
    }

    public Map<String, Object> saveOrUpdateFlowFormData(Long masterId, Integer formSaveType, boolean needSn, boolean needCheckRule) throws BusinessException, SQLException {
        FormDataResult<Object> result = new FormDataResult();
        result.error("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(masterId);
        try {
            if (cacheFormDataMasterBean == null) {
                result.error("2010", ResourceUtil.getString((String)"cap.template.form.data.message.cacheDisabled"));
            } else {
                Map content = (Map)cacheFormDataMasterBean.getExtraMap().get("content");
                if (content == null) {
                    result.error("2004", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "content"));
                } else {
                    content.put("isMerge", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    content.put("needCheckRule", needCheckRule ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    content.put("needSn", needSn ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    content.put(SAVE_TYPE, String.valueOf(formSaveType));
                    result = this.saveFormData(cacheFormDataMasterBean, content, null);
                    this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Object)"saveFormData.CloneNotSupportedException.error is", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        if (!result.isSuccessResult()) {
            LOGGER.info((Object)("saveOrUpdateFlowFormData fail " + result));
            throw new BusinessException(result.getMessage());
        }
        BeanMap map = new BeanMap(result);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private FormDataResult<Map<String, Object>> saveFormData(FormDataMasterBean cacheFormDataMasterBean, Map<String, Object> content, Map<String, Object> params) throws BusinessException, SQLException, CloneNotSupportedException {
        boolean typeNotDealSn;
        Object checkResult;
        String validateResult;
        Date nowDate;
        CtpContentAll ctpContentAll;
        BizConfigBean bizConfigBean;
        JMCallingObj jmCallingObj;
        FormBean formBean;
        ModuleType mType;
        Boolean needSn;
        Boolean needDataUnique;
        Boolean needCheckRule;
        String isMerge;
        Integer saveType;
        boolean isNew;
        String moduleType;
        String moduleId;
        String rightId;
        HashMap<String, Object> data;
        FormDataResult<Map<String, Object>> result;
        block48: {
            block49: {
                FormDataResult<Map<String, Object>> formDataResult;
                result = new FormDataResult<Map<String, Object>>();
                data = new HashMap<String, Object>();
                result.success(data);
                String operateType = (String)content.get("operateType");
                Object formsonNumThreshold = content.get("formsonNumThreshold");
                if (CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(operateType)) return result;
                if (formsonNumThreshold != null) {
                    return result;
                }
                rightId = (String)content.get("rightId");
                moduleId = (String)content.get("moduleId");
                moduleType = (String)content.get("moduleType");
                String moduleTemplateId = (String)content.get("moduleTemplateId");
                String contentTemplateId = (String)content.get("contentTemplateId");
                String contentType = (String)content.get("contentType");
                isNew = cacheFormDataMasterBean.getExtraAttr("isNew") != null;
                String id = (String)content.get("id");
                saveType = Integer.valueOf((String)content.get(SAVE_TYPE));
                isMerge = Strings.isNotBlank((String)((String)content.get("isMerge"))) ? (String)content.get("isMerge") : "0";
                needCheckRule = CAPFormDataService.getParamBooleanValue(content.get("needCheckRule"), true);
                needDataUnique = CAPFormDataService.getParamBooleanValue(content.get("needDataUnique"), true);
                needSn = CAPFormDataService.getParamBooleanValue(content.get("needSn"), true);
                mType = ModuleType.getEnumByKey((int)Integer.parseInt(moduleType));
                formBean = this.cap4FormCacheManager.getForm(Long.valueOf(contentTemplateId));
                Long formMasterDataId = cacheFormDataMasterBean.getId();
                if (formBean == null) {
                    result.error("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
                    return result;
                }
                cacheFormDataMasterBean.refreshFormTable(formBean);
                String nodeName = String.valueOf(AppContext.getSessionContext((String)String.valueOf(cacheFormDataMasterBean.getId())));
                jmCallingObj = null;
                try {
                    LockObjectBean lockObjectBean;
                    bizConfigBean = this.businessManager4.findBizConfigByFormId(formBean.getId());
                    jmCallingObj = isNew ? this.jmMonitorService.putJMCall(Long.parseLong(contentTemplateId), (Object)FormRunTypeEnum.NEW, "CAPFormDataService.saveFormData", nodeName != null && !"null".equals(nodeName) ? nodeName : AppContext.currentUserName(), formBean, (CapBizConfig)bizConfigBean) : this.jmMonitorService.putJMCall(Long.parseLong(contentTemplateId), (Object)FormRunTypeEnum.SAVE, "CAPFormDataService.saveFormData", nodeName != null && !"null".equals(nodeName) ? nodeName : AppContext.currentUserName(), formBean, (CapBizConfig)bizConfigBean);
                    ctpContentAll = null;
                    if (null != bizConfigBean) {
                        JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u8868\u5355\u4fdd\u5b58", CAP4MonitorUtil.contactTag(bizConfigBean), CAP4MonitorUtil.contactTag(formBean)});
                    } else {
                        JMTrackUtils.getAndNew((String[])new String[]{"\u8ddf\u8e2aSQL", "\u8868\u5355\u4fdd\u5b58", CAP4MonitorUtil.contactTag(formBean)});
                    }
                    ctpContentAll = this.ctpMainbodyManager.getContentById(Long.valueOf(id));
                    nowDate = new Date();
                    LockObjectBean lockObjectBean2 = lockObjectBean = this.capRuntimeDataLockManager.get(formMasterDataId);
                    // MONITORENTER : lockObjectBean2
                    if (CAPBusinessEnum.FormSaveType.SAVE_AS_TEMPLATE.getType().equals(saveType) || isNew) {
                        ctpContentAll = new CtpContentAll();
                        ctpContentAll.setIdIfNew();
                        ctpContentAll.setModuleType(Integer.valueOf(moduleType));
                        ctpContentAll.setModuleId(Long.valueOf(moduleId));
                        if (CAPBusinessEnum.FormSaveType.SAVE_AS_TEMPLATE.getType().equals(saveType)) {
                            isNew = false;
                            ctpContentAll.setModuleTemplateId(Long.valueOf(-1L));
                            ctpContentAll.setContentDataId(Long.valueOf(UUIDLong.longUUID()));
                        } else {
                            if (mType == ModuleType.cap4UnflowForm) {
                                ctpContentAll.setModuleTemplateId(Long.valueOf(id));
                            } else if (mType == ModuleType.collaboration) {
                                ctpContentAll.setModuleTemplateId(Long.valueOf(moduleTemplateId));
                            }
                            ctpContentAll.setContentDataId(cacheFormDataMasterBean.getId());
                        }
                        ctpContentAll.setContentType(Integer.valueOf(contentType));
                        ctpContentAll.setContentTemplateId(Long.valueOf(contentTemplateId));
                        ctpContentAll.setModifyId(Long.valueOf(AppContext.currentUserId()));
                        ctpContentAll.setModifyDate(nowDate);
                        ctpContentAll.setCreateId(Long.valueOf(AppContext.currentUserId()));
                        ctpContentAll.setCreateDate(nowDate);
                        ctpContentAll.setSort(Integer.valueOf(0));
                        cacheFormDataMasterBean.setStartDate(nowDate);
                        cacheFormDataMasterBean.setStartMemberId(AppContext.currentUserId());
                        cacheFormDataMasterBean.setModifyDate(nowDate);
                        cacheFormDataMasterBean.setModifyMemberId(AppContext.currentUserId());
                        break block48;
                    }
                    boolean formMasterExit = this.cap4FormDataDAO.isExist(String.valueOf(cacheFormDataMasterBean.getId()), formBean.getMasterTableBean().getTableName());
                    if (formMasterExit || ctpContentAll != null) break block49;
                    result.error("2011", ResourceUtil.getString((String)"cap.template.form.data.message.delete"));
                    formDataResult = result;
                    // MONITOREXIT : lockObjectBean2
                    if (jmCallingObj == null) return formDataResult;
                }
                catch (Throwable throwable) {
                    if (jmCallingObj == null) throw throwable;
                    this.jmMonitorService.endJMCall(jmCallingObj);
                    throw throwable;
                }
                this.jmMonitorService.endJMCall(jmCallingObj);
                return formDataResult;
            }
            cacheFormDataMasterBean.setModifyDate(nowDate);
            cacheFormDataMasterBean.setModifyMemberId(AppContext.currentUserId());
        }
        FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, Long.valueOf(rightId));
        if (params != null) {
            this.mergeFormData(cacheFormDataMasterBean, params);
        }
        Map<String, Object> autoSubDataMap = this.dealAutoCollectSubDatas(formBean, cacheFormDataMasterBean, formAuthViewBean, rightId);
        if (needCheckRule.booleanValue() && Strings.isNotBlank((String)(validateResult = this.dealCheckRule(formBean, cacheFormDataMasterBean, formAuthViewBean, isNew)))) {
            result.error("2002", ResourceUtil.getString((String)"cap.template.form.data.message.validate.error"));
            data.put("validateResult", validateResult);
            data.put("tableData", this.buildSaveMergeAutoData(formBean, cacheFormDataMasterBean, formAuthViewBean, autoSubDataMap));
            data.put(CLEAR_TABLES, autoSubDataMap.get(CLEAR_TABLES));
            this.buildExtendResult(formBean, cacheFormDataMasterBean, formAuthViewBean, result);
            this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
            FormDataResult<Map<String, Object>> formDataResult = result;
            // MONITOREXIT : lockObjectBean2
            if (jmCallingObj == null) return formDataResult;
            this.jmMonitorService.endJMCall(jmCallingObj);
            return formDataResult;
        }
        if (needDataUnique.booleanValue() && (checkResult = this.cap4FormDataManager.validateDataUnique(formBean, cacheFormDataMasterBean)).size() == 2) {
            result.error("2003", ResourceUtil.getString((String)"cap.template.form.data.message.unique.error"));
            data.put("validateDataUnique", checkResult);
            data.put("tableData", this.buildSaveMergeAutoData(formBean, cacheFormDataMasterBean, formAuthViewBean, autoSubDataMap));
            data.put(CLEAR_TABLES, autoSubDataMap.get(CLEAR_TABLES));
            this.buildExtendResult(formBean, cacheFormDataMasterBean, formAuthViewBean, result);
            this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
            FormDataResult<Map<String, Object>> formDataResult = result;
            // MONITOREXIT : lockObjectBean2
            if (jmCallingObj == null) return formDataResult;
            this.jmMonitorService.endJMCall(jmCallingObj);
            return formDataResult;
        }
        if (CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(isMerge)) {
            if (mType == ModuleType.collaboration) {
                cacheFormDataMasterBean.getExtraMap().put("content", content);
                if (null != params) {
                    cacheFormDataMasterBean.getExtraMap().put(CUSTOM_FIELDS, params.get(CUSTOM_FIELDS));
                }
                data.put("content", JSONUtil.parseJSONString((String)ctpContentAll.toJSON()));
            }
            data.put("tableData", this.buildSaveMergeAutoData(formBean, cacheFormDataMasterBean, formAuthViewBean, autoSubDataMap));
            data.put(CLEAR_TABLES, autoSubDataMap.get(CLEAR_TABLES));
            this.buildExtendResult(formBean, cacheFormDataMasterBean, formAuthViewBean, result);
            this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
            checkResult = result;
            // MONITOREXIT : lockObjectBean2
            if (jmCallingObj == null) return checkResult;
            this.jmMonitorService.endJMCall(jmCallingObj);
            return checkResult;
        }
        boolean bl = typeNotDealSn = CAPBusinessEnum.FormSaveType.SAVE_AS.getType().equals(saveType) || CAPBusinessEnum.FormSaveType.SAVE_AS_TEMPLATE.getType().equals(saveType);
        if (needSn.booleanValue() && !typeNotDealSn) {
            List snInfos = this.dealSn(formBean, formAuthViewBean, cacheFormDataMasterBean);
            data.put("snInfo", snInfos);
        }
        List relationRecords = cacheFormDataMasterBean.getRelationRecords();
        this.cap4FormRelationActionManager.saveOrUpdateCAPFormRelationRecords(cacheFormDataMasterBean.getId(), relationRecords);
        if (CAPBusinessEnum.FormSaveType.SAVE_AS_TEMPLATE.getType().equals(saveType)) {
            ctpContentAll.setContent(cacheFormDataMasterBean.getDataJsonString());
            data.put("content", JSONUtil.parseJSONString((String)ctpContentAll.toJSON()));
            try {
                CtpDynamicDataSource.setDataSourceKey((String)DataSourceName.BASE.getSource());
                this.ctpMainbodyManager.saveOrUpdateContentAll(ctpContentAll);
            }
            finally {
                CtpDynamicDataSource.clearDataSourceKey();
            }
            FormDataResult<Map<String, Object>> formDataResult = result;
            // MONITOREXIT : lockObjectBean2
            if (jmCallingObj == null) return formDataResult;
            this.jmMonitorService.endJMCall(jmCallingObj);
            return formDataResult;
        }
        cacheFormDataMasterBean.setModifyDate(nowDate);
        if (isNew) {
            if (mType == ModuleType.cap4UnflowForm) {
                cacheFormDataMasterBean.setState(Enums.FormDataStateEnum.FLOW_UNAUDITED.getKey());
            } else if (mType == ModuleType.collaboration) {
                cacheFormDataMasterBean.setState(Enums.FormDataStateEnum.FLOW_UNOFFICIAL.getKey());
            }
        }
        FormDataMasterBean oldFormDataMasterBean = null;
        if (mType == ModuleType.cap4UnflowForm) {
            oldFormDataMasterBean = this.capFormDataCacheManager.get4Data(cacheFormDataMasterBean.getId(), formBean.getId());
        }
        FormDataBeforeSubmitEvent formDataBeforeSubmitEvent = new FormDataBeforeSubmitEvent(cacheFormDataMasterBean);
        EventDispatcher.fireEvent((Event)formDataBeforeSubmitEvent);
        Map customFields = params != null ? (Map)params.get(CUSTOM_FIELDS) : (Map)cacheFormDataMasterBean.getExtraAttr(CUSTOM_FIELDS);
        this.doSaveCustomCtrl(customFields, moduleId, formBean, cacheFormDataMasterBean);
        CAPFormDataLogUtil.recordTrace(cacheFormDataMasterBean, "\u4fdd\u5b58\u5165\u5e93\u524d");
        this.cap4FormManager.saveOrUpdateFormData(cacheFormDataMasterBean, formBean.getId(), true);
        try {
            CtpDynamicDataSource.setDataSourceKey((String)DataSourceName.BASE.getSource());
            this.ctpMainbodyManager.saveOrUpdateContentAll(ctpContentAll);
        }
        finally {
            CtpDynamicDataSource.clearDataSourceKey();
        }
        this.saveAttachments(formBean, cacheFormDataMasterBean, moduleId, mType);
        LOGGER.info((Object)("\u6570\u636e\u4fdd\u5b58\u7ed3\u675f:" + cacheFormDataMasterBean.getId() + " \u4eba\u5458:" + AppContext.currentUserId()));
        FormDataAfterSubmitEvent formDataAfterSubmitEvent = new FormDataAfterSubmitEvent(cacheFormDataMasterBean);
        EventDispatcher.fireEvent((Event)formDataAfterSubmitEvent);
        if (!CAPBusinessEnum.FormSaveType.SAVE_CURRENT.getType().equals(saveType)) {
            cacheFormDataMasterBean.setRelationRecords(null);
        }
        if (mType == ModuleType.cap4UnflowForm) {
            if (AppContext.hasPlugin((String)"index")) {
                IndexApi indexApi = (IndexApi)AppContext.getBean((String)"indexApi");
                indexApi.update(ctpContentAll.getModuleId(), Integer.valueOf(ApplicationCategoryEnum.form.getKey()));
            }
            String dataLog = null;
            int capLogType = Enums.CapLogType.INSERT.getKey();
            if (isNew) {
                dataLog = String.format(ResourceUtil.getString((String)CREATE_LOG), formBean.getFormName()) + this.capRunningLogManager.getDataLog(formBean, cacheFormDataMasterBean, MainbodyStatus.STATUS_POST_SAVE);
            } else {
                capLogType = Enums.CapLogType.MODIFY.getKey();
                dataLog = String.format(ResourceUtil.getString((String)UPDATE_LOG), formBean.getFormName()) + this.capRunningLogManager.getDataLog(formBean, cacheFormDataMasterBean, MainbodyStatus.STATUS_POST_UPDATE, oldFormDataMasterBean);
            }
            Long bizId = bizConfigBean != null ? bizConfigBean.getId() : null;
            String bizName = bizConfigBean != null ? bizConfigBean.getName() : null;
            this.capRunningLogManager.saveRunningLog(bizId, bizName, formBean.getId(), formBean.getFormName(), cacheFormDataMasterBean.getId(), capLogType, dataLog, AppContext.currentUserId(), cacheFormDataMasterBean.getStartMemberId(), cacheFormDataMasterBean.getStartDate(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
            if (!CAPBusinessEnum.FormSaveType.SAVE_CURRENT.getType().equals(saveType)) {
                this.cap4FormManager.removeSessionMasterDataBean(ctpContentAll.getContentDataId());
            }
            this.cap4FormTriggerManager.doTrigger(Integer.parseInt(moduleType), (long)cacheFormDataMasterBean.getId(), (long)formBean.getId(), rightId, null, "dataSave");
            if (CAPBusinessEnum.FormSaveType.SAVE_AND_COPY.getType().equals(saveType)) {
                FormDataMasterBean cloneFormDataMasterBean = this.copyFormDataMasterBean(formBean, cacheFormDataMasterBean, formAuthViewBean, relationRecords);
                data.put("formMasterId", String.valueOf(cloneFormDataMasterBean.getId()));
            }
        } else if (mType == ModuleType.collaboration) {
            data.put("content", JSONUtil.parseJSONString((String)ctpContentAll.toJSON()));
            cacheFormDataMasterBean.removeExtraMap("content");
            cacheFormDataMasterBean.removeExtraMap(CUSTOM_FIELDS);
        }
        // MONITOREXIT : lockObjectBean2
        LOGGER.info((Object)("save form data finish, id:" + ctpContentAll.getContentDataId() + ", moduleId:" + moduleId));
        JMTrackUtils.clearTrack();
        if (jmCallingObj == null) return result;
        this.jmMonitorService.endJMCall(jmCallingObj);
        return result;
    }

    private FormDataMasterBean copyFormDataMasterBean(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, List<CAPFormRelationRecord> capFormRelationRecords) throws BusinessException, CloneNotSupportedException {
        cacheFormDataMasterBean.clearSessionAttachments();
        FormDataMasterBean cloneFormDataMasterBean = (FormDataMasterBean)cacheFormDataMasterBean.clone();
        cloneFormDataMasterBean.putExtraAttr("isNew", true);
        cloneFormDataMasterBean.setNewId();
        this.cap4FormManager.putSessioMasterDataBean(formBean, cloneFormDataMasterBean, true, false);
        List masterFields = formBean.getMasterTableBean().getFields();
        for (FormFieldBean formFieldBean : masterFields) {
            FormAuthViewFieldBean fieldAuth;
            Object fieldValue;
            if (formFieldBean.isCustomerCtrl()) {
                cloneFormDataMasterBean.addFieldValue(formFieldBean.getName(), null);
                continue;
            }
            if ((formFieldBean.isAttachment() || formFieldBean.isMap()) && (fieldValue = cacheFormDataMasterBean.getFieldValue(formFieldBean.getName())) != null) {
                Long subReference = Long.parseLong(String.valueOf(fieldValue));
                Long newSubReference = null;
                if (formFieldBean.isMap()) {
                    newSubReference = CAPFormUtil.copyLBS(formBean.getId(), cloneFormDataMasterBean.getId(), null, subReference, formFieldBean);
                }
                if (formFieldBean.isAttachment()) {
                    newSubReference = newSubReference == null ? UUIDLong.longUUID() : newSubReference;
                    newSubReference = CAPAttachmentUtil.copyAttachment(cloneFormDataMasterBean, formFieldBean, subReference, cloneFormDataMasterBean.getId(), newSubReference, false);
                }
                cloneFormDataMasterBean.addFieldValue(formFieldBean.getName(), (Object)newSubReference);
            }
            if (!(fieldAuth = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName())).isSerialNumberDefaultValue()) continue;
            cloneFormDataMasterBean.addFieldValue(fieldAuth.getFieldName(), null);
        }
        HashMap<String, String> oldSubId2NewId = new HashMap<String, String>();
        List subTableBeans = formBean.getSubTableBean();
        for (FormTableBean formTableBean : subTableBeans) {
            List subDatas = cloneFormDataMasterBean.getSubData(formTableBean.getTableName());
            if (subDatas == null) continue;
            List subFields = formTableBean.getFields();
            ArrayList<FormDataSubBean> newSubDatas = new ArrayList<FormDataSubBean>();
            for (FormDataSubBean oldBean : subDatas) {
                Long oldId = oldBean.getId();
                FormDataSubBean formDataSubBean = new FormDataSubBean(oldBean.getRowData(), formTableBean, cloneFormDataMasterBean, new boolean[]{true});
                formDataSubBean.setNewId();
                oldSubId2NewId.put(oldId.toString(), formDataSubBean.getId().toString());
                for (FormFieldBean formFieldBean : subFields) {
                    Object fieldValue;
                    if (formFieldBean.isCustomerCtrl()) {
                        formDataSubBean.addFieldValue(formFieldBean.getName(), null);
                        continue;
                    }
                    if (!formFieldBean.isAttachment() && !formFieldBean.isMap() || (fieldValue = formDataSubBean.getFieldValue(formFieldBean.getName())) == null) continue;
                    Long subReference = Long.parseLong(String.valueOf(fieldValue));
                    Long newSubReference = null;
                    if (formFieldBean.isMap()) {
                        newSubReference = CAPFormUtil.copyLBS(formBean.getId(), cloneFormDataMasterBean.getId(), formDataSubBean.getId(), subReference, formFieldBean);
                    }
                    if (formFieldBean.isAttachment()) {
                        newSubReference = newSubReference == null ? UUIDLong.longUUID() : newSubReference;
                        newSubReference = CAPAttachmentUtil.copyAttachment(cloneFormDataMasterBean, formFieldBean, subReference, cloneFormDataMasterBean.getId(), newSubReference, false);
                    }
                    formDataSubBean.addFieldValue(formFieldBean.getName(), (Object)newSubReference);
                }
                newSubDatas.add(formDataSubBean);
            }
            cloneFormDataMasterBean.setSubData(formTableBean.getTableName(), newSubDatas);
        }
        if (Strings.isNotEmpty(capFormRelationRecords)) {
            for (CAPFormRelationRecord capFormRelationRecord : capFormRelationRecords) {
                capFormRelationRecord.setNewId();
                capFormRelationRecord.setFromMasterDataId(cloneFormDataMasterBean.getId());
                if (capFormRelationRecord.getFromSubdataId() == null || oldSubId2NewId.get(capFormRelationRecord.getFromSubdataId().toString()) == null) continue;
                capFormRelationRecord.setFromSubdataId(Long.valueOf((String)oldSubId2NewId.get(capFormRelationRecord.getFromSubdataId().toString())));
            }
        }
        cloneFormDataMasterBean.setRelationRecords(capFormRelationRecords);
        cloneFormDataMasterBean.initRelationRecordMap();
        return cloneFormDataMasterBean;
    }

    private void doSaveCustomCtrl(Map<String, Object> customFields, String moduleId, FormBean formBean, FormDataMasterBean formDataMasterBean) {
        List allCustomFields = formBean.getCustomFields();
        try {
            if (null == customFields) {
                for (FormFieldBean formFieldBean : allCustomFields) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("formFieldBean", formFieldBean);
                    param.put("formDataMasterBean", formDataMasterBean);
                    param.put("formBean", formBean);
                    param.put("moduleId", Long.valueOf(moduleId));
                    ((FormFieldCustomCtrl)formFieldBean.getFieldCtrl()).handleSaving(param);
                }
            } else {
                ArrayList<FormFieldBean> temp = new ArrayList<FormFieldBean>();
                for (String key : customFields.keySet()) {
                    String fieldName = key.split("_")[0];
                    FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName);
                    Object object = customFields.get(key);
                    if (object == null || !(object instanceof Map)) continue;
                    Map customParam = (Map)object;
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("fieldName", fieldName);
                    param.put("formDataMasterBean", (String)formDataMasterBean);
                    customParam.put("param", param);
                    ((FormFieldCustomCtrl)formFieldBean.getFieldCtrl()).handleSaving(customParam);
                    temp.add(formFieldBean);
                }
                if (temp.size() < allCustomFields.size()) {
                    allCustomFields.removeAll(temp);
                    for (FormFieldBean formFieldBean : allCustomFields) {
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put("formFieldBean", formFieldBean);
                        param.put("formDataMasterBean", formDataMasterBean);
                        param.put("formBean", formBean);
                        param.put("moduleId", Long.valueOf(moduleId));
                        ((FormFieldCustomCtrl)formFieldBean.getFieldCtrl()).handleSaving(param);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to save custom controls! cause:" + e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> dealAutoCollectSubDatas(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, String rightId) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, List<FormDataSubBean>> autoCollectSubMaps = new HashMap<String, List<FormDataSubBean>>();
        List<FormRelationshipMapBean> autoCollectBeans = this.cap4FormRelationActionManager.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.auto_collect.getKey());
        HashMap<String, Set<String>> tableName2DeleteIds = new HashMap<String, Set<String>>();
        if (Strings.isNotEmpty(autoCollectBeans)) {
            Map<String, List<FormDataSubBean>> data;
            String value;
            String key;
            LinkedList<FormRelationshipMapBean> needAutoCollectBeans = new LinkedList<FormRelationshipMapBean>();
            for (FormRelationshipMapBean mapBean : autoCollectBeans) {
                if (!mapBean.isForceRefresh()) continue;
                if (mapBean.getRefreshOperationUpdate() != null && mapBean.getRefreshOperationUpdate().contains(rightId)) {
                    needAutoCollectBeans.add(mapBean);
                    continue;
                }
                if (mapBean.getRefreshOperationAdd() == null || !mapBean.getRefreshOperationAdd().contains(rightId)) continue;
                needAutoCollectBeans.add(mapBean);
            }
            Collections.sort(needAutoCollectBeans, new Comparator<FormRelationshipMapBean>(){

                @Override
                public int compare(FormRelationshipMapBean o1, FormRelationshipMapBean o2) {
                    return o1.getRelationshipBean().getModifyTime().compareTo(o2.getRelationshipBean().getModifyTime());
                }
            });
            ArrayList resultTables = new ArrayList();
            ArrayList<FormRelationshipMapBean> noResultAutoCollectBeans = new ArrayList<FormRelationshipMapBean>();
            ArrayList<String> dealedTables = new ArrayList<String>();
            for (FormRelationshipMapBean mapBean : needAutoCollectBeans) {
                for (Map.Entry entry : mapBean.getCollectMapping().entrySet()) {
                    resultTables.add(entry.getValue());
                }
            }
            for (FormRelationshipMapBean mapBean : needAutoCollectBeans) {
                for (Map.Entry entry : mapBean.getCollectMapping().entrySet()) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    if (resultTables.contains(key)) {
                        noResultAutoCollectBeans.add(mapBean);
                        continue;
                    }
                    data = this.cap4FormRelationActionManager.getRelationAutoSummaryFromSelf(formBean, cacheFormDataMasterBean, formAuthViewBean, mapBean, tableName2DeleteIds);
                    this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, CAPFormUtil.getTableName2FormSubDataBeanIds(data));
                    dealedTables.add(value);
                    autoCollectSubMaps.putAll(data);
                }
            }
            while (noResultAutoCollectBeans.size() > 0) {
                Iterator iterator = noResultAutoCollectBeans.iterator();
                while (iterator.hasNext()) {
                    FormRelationshipMapBean mapBean;
                    mapBean = (FormRelationshipMapBean)iterator.next();
                    for (Map.Entry entry : mapBean.getCollectMapping().entrySet()) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        if (!dealedTables.contains(key)) continue;
                        data = this.cap4FormRelationActionManager.getRelationAutoSummaryFromSelf(formBean, cacheFormDataMasterBean, formAuthViewBean, mapBean, tableName2DeleteIds);
                        this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, CAPFormUtil.getTableName2FormSubDataBeanIds(data));
                        dealedTables.add(value);
                        autoCollectSubMaps.putAll(data);
                        iterator.remove();
                    }
                }
            }
        }
        if (autoCollectSubMaps.size() > 0) {
            Set<String> fillBackFields = this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, CAPFormUtil.getTableName2FormSubDataBeanIds(autoCollectSubMaps));
            for (String tableName : autoCollectSubMaps.keySet()) {
                autoCollectSubMaps.put(tableName, cacheFormDataMasterBean.getSubData(tableName));
            }
            LOGGER.info((Object)("save do autoSubData. calc change filed " + fillBackFields.toString() + " , dataId " + cacheFormDataMasterBean.getId()));
            result.put(TABLE_NAME_TO_ADD_SUB_OBJECTS, autoCollectSubMaps);
            result.put(FILL_BACK_FIELDS, fillBackFields);
            result.put(TABLE_NAME_TO_DELETE_IDS, tableName2DeleteIds);
        }
        return result;
    }

    private Map<String, Map<String, Object>> buildSaveMergeAutoData(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, Map<String, Object> data) throws BusinessException {
        Map tableName2AddBeans;
        HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
        if (data == null) {
            return tableName2DataMaps;
        }
        HashSet<String> fillBackFields = (HashSet<String>)data.get(FILL_BACK_FIELDS);
        if (fillBackFields == null) {
            fillBackFields = new HashSet<String>();
        }
        if ((tableName2AddBeans = (Map)data.get(TABLE_NAME_TO_ADD_SUB_OBJECTS)) != null && !tableName2AddBeans.isEmpty()) {
            data.put(CLEAR_TABLES, tableName2AddBeans.keySet());
        }
        this.capRuntimeCalcManager.buildCalcAllResult(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddBeans, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.SAVE_AUTO_COLLECT, tableName2DataMaps);
        this.mergeAutoDelete2Result((Map)data.get(TABLE_NAME_TO_DELETE_IDS), tableName2DataMaps);
        return tableName2DataMaps;
    }

    private List<Long> getIgnoreSubReferences(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean) {
        ArrayList<Long> ignoreSubReferences = new ArrayList<Long>();
        List wordFields = this.formApi4Cap4.getAllWordInjectionCtrls(formBean.getId());
        if (CollectionUtils.isEmpty((Collection)wordFields)) {
            return ignoreSubReferences;
        }
        Set wordInjectionCtrlSet = (Set)cacheFormDataMasterBean.getExtraMap().get("wordInjectionCtrl");
        if (CollectionUtils.isNotEmpty((Collection)wordInjectionCtrlSet)) {
            Iterator iterator = wordFields.iterator();
            while (iterator.hasNext()) {
                FormFieldBean fieldBean = (FormFieldBean)iterator.next();
                if (!wordInjectionCtrlSet.contains(fieldBean.getName())) continue;
                iterator.remove();
            }
        }
        for (FormFieldBean formFieldBean : wordFields) {
            if (cacheFormDataMasterBean.getFieldValue(formFieldBean.getName()) == null) continue;
            ignoreSubReferences.add(Long.parseLong(String.valueOf(cacheFormDataMasterBean.getFieldValue(formFieldBean.getName()))));
        }
        return ignoreSubReferences;
    }

    private void saveAttachments(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, String moduleId, ModuleType mType) {
        HashSet<Long> dbExitsAttIds = new HashSet<Long>();
        HashMap<Long, Integer> exitMaxSortMap = new HashMap<Long, Integer>();
        Long realModuleId = this.getAttachmentRealReference(mType, Long.valueOf(moduleId));
        List dbAttachments = this.attachmentManager.getByReference(realModuleId);
        List<Long> ignoreSubReferences = this.getIgnoreSubReferences(formBean, cacheFormDataMasterBean);
        if (Strings.isNotEmpty((Collection)dbAttachments)) {
            for (Attachment attachment : dbAttachments) {
                Integer exitMaxSort;
                if (attachment.getCategory().intValue() != ApplicationCategoryEnum.cap4Form.key() || attachment.getSubReference() == null) continue;
                if (!ignoreSubReferences.contains(attachment.getSubReference())) {
                    dbExitsAttIds.add(attachment.getId());
                }
                exitMaxSort = (exitMaxSort = (Integer)exitMaxSortMap.get(attachment.getSubReference())) == null ? 0 : exitMaxSort;
                exitMaxSort = exitMaxSort < attachment.getSort() ? attachment.getSort() : exitMaxSort.intValue();
                exitMaxSortMap.put(attachment.getSubReference(), exitMaxSort);
            }
        }
        List sessionAttachments = cacheFormDataMasterBean.getSessionAttachments(null);
        ArrayList<Attachment> insertAttachments = new ArrayList<Attachment>();
        if (Strings.isNotEmpty((Collection)sessionAttachments)) {
            int sortAll = 0;
            for (Attachment attachment : sessionAttachments) {
                if (ignoreSubReferences.contains(attachment.getSubReference())) continue;
                if (mType == ModuleType.collaboration) {
                    attachment.setReference(realModuleId);
                }
                if (exitMaxSortMap.get(attachment.getSubReference()) != null) {
                    int sort = (Integer)exitMaxSortMap.get(attachment.getSubReference()) + 1;
                    attachment.setSort(sort);
                    exitMaxSortMap.put(attachment.getSubReference(), sort);
                } else {
                    attachment.setSort(sortAll++);
                }
                insertAttachments.add(attachment);
            }
        }
        if (dbExitsAttIds.size() > 0) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.addAll(dbExitsAttIds);
            this.attachmentManager.deleteByIds(list);
        }
        if (insertAttachments.size() > 0) {
            for (Attachment attachment : insertAttachments) {
                attachment.setNewId();
            }
            this.attachmentManager.create(insertAttachments, false);
        }
    }

    private boolean hasWithholdingAction(FormBean formBean) {
        List formTriggerIdList = formBean.getFormTriggerIdList();
        if (Strings.isNotEmpty((Collection)formTriggerIdList)) {
            for (Long triggerId : formTriggerIdList) {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                if (triggerBean == null || !triggerBean.hasWithholdingAction()) continue;
                return true;
            }
        }
        return false;
    }

    private String dealCheckRule(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, boolean isNew) throws CloneNotSupportedException, BusinessException {
        FormDataMasterBean checkRuleFormDataMasterBean = null;
        if ((isNew || cacheFormDataMasterBean.getState() == 0) && formBean.isFlowForm() && this.hasWithholdingAction(formBean)) {
            Set<FormRelationshipBean> formRelationshipBeans = this.cap4FormCacheManager.getFormRelationshipBeanListByFormId(formBean.getId());
            for (FormRelationshipBean formRelationshipBean : formRelationshipBeans) {
                if (formRelationshipBean == null || formRelationshipBean.getRelationType() != FormRelationEnums.ViewSelectType.system.getKey()) continue;
                if (checkRuleFormDataMasterBean == null) {
                    checkRuleFormDataMasterBean = (FormDataMasterBean)cacheFormDataMasterBean.clone();
                }
                List formRelationshipMapBeans = formRelationshipBean.getRelationMapList();
                for (FormRelationshipMapBean formRelationshipMapBean : formRelationshipMapBeans) {
                    Map<String, String> conditionFields = this.cap4FormRelationActionManager.getRelationFormulaFieldMap(formRelationshipMapBean.getConditionFormula());
                    ArrayList<FormFieldBean> masterFieldBeans = new ArrayList<FormFieldBean>();
                    ArrayList<FormFieldBean> subFieldBeans = new ArrayList<FormFieldBean>();
                    for (String fieldName : conditionFields.keySet()) {
                        FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName);
                        if (formFieldBean.isMasterField()) {
                            masterFieldBeans.add(formFieldBean);
                            continue;
                        }
                        subFieldBeans.add(formFieldBean);
                    }
                    if (masterFieldBeans.size() > 0 && subFieldBeans.isEmpty()) {
                        this.cap4FormRelationActionManager.dealSysRelationByShipBean4FieldIn(formBean, checkRuleFormDataMasterBean, formAuthViewBean, null, null, formRelationshipBean);
                    }
                    if (subFieldBeans.isEmpty()) continue;
                    FormFieldBean formFieldBean = (FormFieldBean)subFieldBeans.get(0);
                    List formDataSubBeans = checkRuleFormDataMasterBean.getSubData(formFieldBean.getOwnerTableName());
                    for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                        this.cap4FormRelationActionManager.dealSysRelationByShipBean4FieldIn(formBean, checkRuleFormDataMasterBean, formAuthViewBean, formDataSubBean, null, formRelationshipBean);
                    }
                }
            }
        }
        String validateResult = this.cap4FormManager.validate(formBean.getId(), checkRuleFormDataMasterBean == null ? cacheFormDataMasterBean : checkRuleFormDataMasterBean);
        return validateResult;
    }

    private List dealSn(FormBean formBean, FormAuthViewBean formAuth, FormDataMasterBean cacheMasterData) throws BusinessException {
        ArrayList snInfos = new ArrayList();
        List masterFields = formBean.getMasterTableBean().getFields();
        for (FormFieldBean formFieldBean : masterFields) {
            String val;
            FormAuthViewFieldBean fieldAuth = formAuth.getFormAuthorizationField(formFieldBean.getName());
            if (!fieldAuth.isSerialNumberDefaultValue() || !Strings.isBlank((String)(val = (String)cacheMasterData.getFieldValue(fieldAuth.getFieldName())))) continue;
            FormFieldBean authSnField = formBean.getFieldBeanByName(fieldAuth.getFieldName());
            String snmu = this.cap4SerialNumberManager.getSerialNumber(fieldAuth);
            if (Strings.isNotBlank((String)snmu)) {
                if (FormFieldComEnum.TEXTAREA != authSnField.getInputTypeEnum() && snmu.length() > authSnField.getMaxLength(false)) {
                    cacheMasterData.addFieldValue(fieldAuth.getFieldName(), (Object)snmu.substring(0, authSnField.getMaxLength(true)));
                } else {
                    cacheMasterData.addFieldValue(fieldAuth.getFieldName(), (Object)snmu);
                }
                HashMap<String, String> snInfo = new HashMap<String, String>();
                snInfo.put("snmu", snmu);
                snInfo.put("display", formFieldBean.getDisplay());
                snInfos.add(snInfo);
            }
            this.cap4FormDataManager.calcAllWithFieldIn(formBean, authSnField, cacheMasterData, null, null, formAuth, false);
        }
        CAPFormUtil.processSerial4Formula(cacheMasterData, formBean, formAuth);
        return snInfos;
    }

    private List<FormDataSubBean> initCopyAddSubDataBean(FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormTableBean formTableBean, List<String> recordIds) throws BusinessException {
        ArrayList<FormDataSubBean> newFormDataSubBeans = new ArrayList<FormDataSubBean>();
        Map capFormRelationRecordMap = null;
        List capFormRelationRecords = formDataMasterBean.getRelationRecords();
        if (CollectionUtils.isNotEmpty((Collection)capFormRelationRecords)) {
            capFormRelationRecordMap = formDataMasterBean.getRelationRecordMap();
        }
        ArrayList<CAPFormRelationRecord> addRelationRecords = new ArrayList<CAPFormRelationRecord>();
        for (String recordId : recordIds) {
            FormDataSubBean formDataSubBean = new FormDataSubBean(formTableBean, formDataMasterBean, new boolean[]{true});
            formDataSubBean.setFormmainId(formDataMasterBean.getId().longValue());
            newFormDataSubBeans.add(formDataSubBean);
            formDataMasterBean.addSubData4CopyRow(formTableBean.getTableName(), formDataSubBean, Long.valueOf(recordId));
            if (!Strings.isNotEmpty((Collection)capFormRelationRecords)) continue;
            for (CAPFormRelationRecord relationRecord : capFormRelationRecords) {
                if (relationRecord.getFromSubdataId() == null || !relationRecord.getFromSubdataId().toString().equals(recordId)) continue;
                try {
                    CAPFormRelationRecord nrr = (CAPFormRelationRecord)relationRecord.clone();
                    nrr.setNewId();
                    nrr.setFromSubdataId(formDataSubBean.getId());
                    addRelationRecords.add(nrr);
                    capFormRelationRecordMap.put(relationRecord.getFieldName() + "_" + formDataSubBean.getId(), nrr);
                }
                catch (CloneNotSupportedException e) {
                    throw new BusinessException((Throwable)e);
                }
            }
        }
        if (!addRelationRecords.isEmpty()) {
            capFormRelationRecords.addAll(addRelationRecords);
        }
        return this.initAddSubDataBeans(formDataMasterBean, formAuthViewBean, formTableBean, newFormDataSubBeans);
    }

    private List<FormDataSubBean> initNewAddSubDataBean(FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormTableBean formTableBean, List<String> recordIds, Long preRecordId) throws BusinessException {
        ArrayList<FormDataSubBean> newFormDataSubBeans = new ArrayList<FormDataSubBean>();
        Long preId = preRecordId != null ? preRecordId : null;
        for (String recordId : recordIds) {
            FormDataSubBean formDataSubBean = new FormDataSubBean(formTableBean, formDataMasterBean, new boolean[]{true});
            formDataSubBean.setFormmainId(formDataMasterBean.getId().longValue());
            newFormDataSubBeans.add(formDataSubBean);
            if (preId != null) {
                if (preId.equals(-1L)) {
                    formDataMasterBean.addSubDataWithIndex(formTableBean.getTableName(), formDataSubBean, 0);
                } else {
                    formDataMasterBean.addSubData(formTableBean.getTableName(), formDataSubBean, preId);
                }
            } else {
                formDataMasterBean.addSubData(formTableBean.getTableName(), formDataSubBean);
            }
            preId = formDataSubBean.getId();
        }
        return this.initAddSubDataBeans(formDataMasterBean, formAuthViewBean, formTableBean, newFormDataSubBeans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateRequestParam(notEmpty={"recordIds"}, validateCacheBeanKey="formMasterId")
    @JMCalling4Service(runType=FormRunTypeEnum.SAVE)
    public FormDataSubRowOperationResult<Map<String, Object>> addOrDelDataSubBean(FormDataSubRowOperationParamBean paramBean) {
        FormDataSubRowOperationResult<Map<String, Object>> result = new FormDataSubRowOperationResult<Map<String, Object>>();
        String tableName = paramBean.getTableName();
        String type = paramBean.getType();
        String firstRecordId = paramBean.getFirstRecordId();
        String preRecordId = paramBean.getPreRecordId();
        try {
            LockObjectBean lockObjectBean;
            FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            LockObjectBean lockObjectBean2 = lockObjectBean = this.capRuntimeDataLockManager.get(paramBean.getFormMasterId());
            synchronized (lockObjectBean2) {
                FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterId());
                this.mergeFormData(cacheFormDataMasterBean, paramBean.getMergeData());
                FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, paramBean.getRightId());
                FormTableBean formTableBean = formBean.getTableByTableName(tableName);
                if ("delete".equals(type)) {
                    String string = type = paramBean.getRecordIds().size() == cacheFormDataMasterBean.getSubData(tableName).size() ? "deleteAll" : "delete";
                }
                if (!this.checkAddOrDelDataSubBeanAuth(formAuthViewBean, formTableBean, type)) {
                    result.error("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
                    return result;
                }
                HashMap<String, HashMap<String, Map<String, Object>>> data = new HashMap<String, HashMap<String, Map<String, Object>>>();
                if (Strings.isNotBlank((String)firstRecordId)) {
                    FormDataSubBean formDataSubBean = cacheFormDataMasterBean.getFormDataSubBeanById(tableName, Long.valueOf(firstRecordId));
                    result.setFirstIsNull(formDataSubBean == null || formDataSubBean.isEmpty() ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                }
                HashMap<String, List<Long>> tableName2AddSubIds = new HashMap<String, List<Long>>();
                HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
                if ("delete".equals(type) || "deleteAll".equals(type) || "repeal".equals(type)) {
                    HashSet<String> deleteIds;
                    HashMap tableMap = (HashMap)tableName2DataMaps.get(tableName);
                    if (tableMap == null) {
                        tableMap = new HashMap();
                        tableName2DataMaps.put(tableName, tableMap);
                    }
                    if ((deleteIds = (HashSet<String>)tableMap.get("delete")) == null) {
                        deleteIds = new HashSet<String>();
                        tableMap.put("delete", deleteIds);
                    }
                    for (String recordId : paramBean.getRecordIds()) {
                        cacheFormDataMasterBean.removeSubData(tableName, Long.valueOf(recordId));
                        deleteIds.add(recordId);
                    }
                    if (cacheFormDataMasterBean.getSubData(tableName) == null || cacheFormDataMasterBean.getSubData(tableName).isEmpty()) {
                        ArrayList<String> addRows = new ArrayList<String>();
                        addRows.add("");
                        List<FormDataSubBean> formDataSubBeans = this.initNewAddSubDataBean(cacheFormDataMasterBean, formAuthViewBean, formTableBean, addRows, null);
                        ArrayList<Long> subIds = new ArrayList<Long>();
                        for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                            subIds.add(formDataSubBean.getId());
                        }
                        tableName2AddSubIds.put(tableName, subIds);
                    }
                } else if ("copy".equals(type) || "add".equals(type)) {
                    List<FormDataSubBean> formDataSubBeans = "add".equals(type) ? this.initNewAddSubDataBean(cacheFormDataMasterBean, formAuthViewBean, formTableBean, paramBean.getRecordIds(), Strings.isBlank((String)preRecordId) ? null : Long.valueOf(preRecordId)) : this.initCopyAddSubDataBean(cacheFormDataMasterBean, formAuthViewBean, formTableBean, paramBean.getRecordIds());
                    ArrayList<Long> subIds = new ArrayList<Long>();
                    for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                        subIds.add(formDataSubBean.getId());
                    }
                    tableName2AddSubIds.put(tableName, subIds);
                }
                Set<String> fillBackFields = this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddSubIds);
                this.capRuntimeCalcManager.buildCalcAllResult(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddSubIds, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.FRONT_SUBMIT, tableName2DataMaps);
                data.put("tableData", tableName2DataMaps);
                result.success(data);
                this.buildExtendResult(formBean, cacheFormDataMasterBean, formAuthViewBean, result);
                this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("addOrDelDataSubBean is exception masterId " + paramBean.getFormMasterId() + " , type " + type + " , recordIds " + paramBean.getRecordIds() + " " + e.getMessage()), (Throwable)e);
            result.error("2001", e.getMessage());
        }
        return result;
    }

    public boolean validateSubTableAuth(FormAuthViewBean formAuthViewBean, FormTableBean formTableBean, Integer type) {
        return this.validateSubTableAuth(formAuthViewBean, formTableBean, CAPBusinessEnum.FormsonButtonType.getEnumByType(type));
    }

    private boolean validateSubTableAuth(FormAuthViewBean formAuthViewBean, FormTableBean formTableBean, CAPBusinessEnum.FormsonButtonType buttonType) {
        FormAuthorizationTableBean authTableBean = formAuthViewBean == null ? null : formAuthViewBean.getSubTableAuth(formTableBean.getDisplay());
        boolean isAccess = false;
        if (authTableBean != null && buttonType != null) {
            switch (buttonType) {
                case ADD: {
                    isAccess = authTableBean.isAdd();
                    break;
                }
                case COPY: {
                    isAccess = authTableBean.isCopy();
                    break;
                }
                case IMPORT_EXCEL: {
                    isAccess = authTableBean.isImportData();
                    break;
                }
                case EXPORT_EXCEL: {
                    isAccess = authTableBean.isExportData();
                    break;
                }
                case DELETE: {
                    isAccess = authTableBean.isDelete();
                    break;
                }
                case DELETE_ALL: {
                    isAccess = authTableBean.isDeleteAll();
                    break;
                }
            }
        }
        return isAccess;
    }

    @ValidateRequestParam(notEmpty={"type", "formMasterId", "formId", "rightId", "tableName"})
    public FormDataSubRowOperationResult validateSubTableAuth(FormDataSubRowOperationParamBean paramBean) {
        FormDataSubRowOperationResult result = new FormDataSubRowOperationResult();
        result.error("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
        FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
        FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterId());
        FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, paramBean.getRightId());
        FormTableBean formTableBean = formBean.getTableByTableName(paramBean.getTableName());
        if (this.validateSubTableAuth(formAuthViewBean, formTableBean, Integer.parseInt(paramBean.getType()))) {
            result.success();
        }
        return result;
    }

    private boolean checkAddOrDelDataSubBeanAuth(FormAuthViewBean formAuthViewBean, FormTableBean tableBean, String operation) {
        if ("repeal".equals(operation)) {
            return true;
        }
        return this.validateSubTableAuth(formAuthViewBean, tableBean, CAPBusinessEnum.FormsonButtonType.getEnumByAlias(operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateRequestParam(notEmpty={"formMasterDataId", "formId", "rightId"}, validateCacheBeanKey="formMasterDataId")
    public FormDataResult calculate(FormDataCalculateParamBean paramBean) {
        FormDataResult<Map<String, Object>> result = new FormDataResult<Map<String, Object>>();
        String fieldName = paramBean.getFieldName();
        Long fromRecordId = paramBean.getFromRecordId();
        String formSonTableName = paramBean.getFormSonTableName();
        boolean calcAll = Strings.isBlank((String)fieldName);
        FormDataMasterBean cacheFormDataMasterBean = null;
        try {
            LockObjectBean lockObjectBean;
            FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            FormFieldBean formFieldBean = Strings.isBlank((String)fieldName) ? null : formBean.getFieldBeanByName(fieldName);
            LockObjectBean lockObjectBean2 = lockObjectBean = this.capRuntimeDataLockManager.get(paramBean.getFormMasterDataId());
            synchronized (lockObjectBean2) {
                HashSet<String> fillBackFields;
                cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterDataId());
                FormDataMasterBean oldCacheFormDataMasterBean = null;
                if (!calcAll) {
                    oldCacheFormDataMasterBean = (FormDataMasterBean)cacheFormDataMasterBean.clone();
                }
                this.mergeFormData(cacheFormDataMasterBean, paramBean.getMergeData());
                FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, paramBean.getRightId());
                HashMap<String, Set<String>> tableName2DeleteIds = new HashMap<String, Set<String>>();
                Map<String, List<FormDataSubBean>> tableName2AddSubBeans = null;
                HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
                if (calcAll) {
                    if (fromRecordId != null && Strings.isNotBlank((String)formSonTableName)) {
                        FormDataSubBean formDataSubBean = cacheFormDataMasterBean.getFormDataSubBeanById(formSonTableName, fromRecordId);
                        List formFieldBeans = formBean.getTableByTableName(formSonTableName).getFields();
                        for (FormFieldBean fieldBean : formFieldBeans) {
                            cacheFormDataMasterBean.addFieldChanges4Calc(fieldBean, formDataSubBean.getFieldValue(fieldBean.getName()), formDataSubBean);
                        }
                    }
                    fillBackFields = this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, null);
                } else {
                    fillBackFields = new HashSet();
                    if (fromRecordId != null && Strings.isNotBlank((String)formSonTableName)) {
                        FormDataSubBean subBean = cacheFormDataMasterBean.getFormDataSubBeanById(formSonTableName, fromRecordId);
                        FormDataSubBean oldSubBean = oldCacheFormDataMasterBean.getFormDataSubBeanById(formSonTableName, fromRecordId);
                        if (this.capRuntimeCalcManager.needCalc((FormDataBean)oldSubBean, (FormDataBean)subBean, formFieldBean, null)) {
                            this.cap4FormDataManager.calcAllWithFieldIn(formBean, formFieldBean, cacheFormDataMasterBean, subBean, fillBackFields, formAuthViewBean, this.capRuntimeCalcManager.needCalcSysRelation((FormDataBean)oldSubBean, (FormDataBean)subBean, formFieldBean, null, null));
                        }
                    } else if (this.capRuntimeCalcManager.needCalc((FormDataBean)oldCacheFormDataMasterBean, (FormDataBean)cacheFormDataMasterBean, formFieldBean, null)) {
                        this.cap4FormDataManager.calcAllWithFieldIn(formBean, formFieldBean, cacheFormDataMasterBean, null, fillBackFields, formAuthViewBean, this.capRuntimeCalcManager.needCalcSysRelation((FormDataBean)oldCacheFormDataMasterBean, (FormDataBean)cacheFormDataMasterBean, formFieldBean, null, null));
                    }
                    tableName2AddSubBeans = this.calculateAutoIncreaseByField(formBean, cacheFormDataMasterBean, formAuthViewBean, formFieldBean, fillBackFields, tableName2DeleteIds, true);
                }
                this.capRuntimeCalcManager.buildCalcAllResult(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddSubBeans, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.FRONT_COLLECT_OR_INCREASE, tableName2DataMaps);
                if (!tableName2DeleteIds.isEmpty()) {
                    this.mergeAutoDelete2Result(tableName2DeleteIds, tableName2DataMaps);
                }
                HashMap<String, HashMap<String, Map<String, Object>>> resultData = new HashMap<String, HashMap<String, Map<String, Object>>>();
                resultData.put("tableData", tableName2DataMaps);
                result.success(resultData);
                this.buildExtendResult(formBean, cacheFormDataMasterBean, formAuthViewBean, result);
                this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"calculate.getDataJSON.error ", (Throwable)e);
            result.error("2001", e.getMessage());
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Object)"calculate.getDataJSON.clone.error ", (Throwable)e);
            result.error("2001", e.getMessage());
        }
        finally {
            AppContext.removeThreadContext((String)"fieldInnerChangeMap");
            if (cacheFormDataMasterBean != null) {
                cacheFormDataMasterBean.clearFieldChangesByCalc();
            }
            JMTrackUtils.clearTrack();
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"attachments", "subReference", "reference", "formMasterId"}, validateCacheBeanKey="formMasterId")
    public FormDataResult<List<Map<String, String>>> addOrDelAttachment(FormDataAttachmentParamBean paramBean) {
        FormDataResult<List<Map<String, String>>> result = new FormDataResult<List<Map<String, String>>>();
        String type = paramBean.getType() != null ? paramBean.getType() : "add";
        String subType = paramBean.getSubType() != null ? paramBean.getSubType() : "";
        Map<String, String> baseInfo = paramBean.getBaseAttachmentInfo();
        FormDataMasterBean formDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterId());
        ArrayList<Attachment> sessionAttachment = formDataMasterBean.getSessionAttachments(String.valueOf(paramBean.getSubReference()));
        if (sessionAttachment == null || "document".equals(subType) && "add".equals(type)) {
            sessionAttachment = new ArrayList<Attachment>();
        }
        for (Map<String, Object> map : paramBean.getAttachments()) {
            if ("delete".equals(type)) {
                Long attId = CAPParamUtil.getLong(map, (String)"id");
                if (!Strings.isNotEmpty(sessionAttachment)) continue;
                Iterator iterator = sessionAttachment.iterator();
                while (iterator.hasNext()) {
                    Attachment temp = (Attachment)iterator.next();
                    if (!attId.equals(temp.getId()) && (!"document".equals(subType) || !attId.equals(temp.getId()) && !attId.equals(temp.getFileUrl()))) continue;
                    iterator.remove();
                }
                continue;
            }
            HashMap<String, String> attMap = new HashMap<String, String>();
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (!(value instanceof String)) continue;
                attMap.put(key, String.valueOf(value));
            }
            if (attMap.get("createdate") == null && attMap.get("createDate") != null) {
                attMap.put("createdate", (String)attMap.get("createDate"));
            }
            attMap.put("subReference", String.valueOf(paramBean.getSubReference()));
            attMap.put("reference", String.valueOf(paramBean.getReference()));
            attMap.put("category", baseInfo.get("category"));
            attMap.put("type", baseInfo.get("type"));
            attMap.put("mimeType", String.valueOf(map.get("mimeType") == null ? baseInfo.get("mimeType") : map.get("mimeType")));
            Attachment att = new Attachment(attMap);
            if (Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal() == att.getType().intValue()) {
                att.setGenesisId(Strings.isNotBlank((String)((String)attMap.get("genesisId"))) && !"null".equals(attMap.get("genesisId")) ? Long.valueOf((String)attMap.get("genesisId")) : null);
                att.setDescription(attMap.get("description") != null && !"null".equals(attMap.get("description")) ? (String)attMap.get("description") : null);
                att.setSort(attMap.get("sort") != null && !"null".equals(attMap.get("sort")) ? Integer.parseInt(String.valueOf(attMap.get("sort"))) : 0);
            }
            att.setId(Long.valueOf(attMap.get("id") != null && !"null".equals(attMap.get("id")) ? Long.valueOf((String)attMap.get("id")) : UUIDLong.longUUID()));
            att.putExtraAttr("v", (String)attMap.get("v"));
            if ("update".equals(type)) {
                Iterator iterator = sessionAttachment.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Attachment temp = (Attachment)iterator.next();
                    if (att.getId().equals(temp.getId())) {
                        iterator.remove();
                        break;
                    }
                    ++index;
                }
                sessionAttachment.add(index, att);
                continue;
            }
            sessionAttachment.add(att);
        }
        formDataMasterBean.putSessionAttachments(String.valueOf(paramBean.getSubReference()), sessionAttachment);
        this.cap4FormManager.saveSessioMasterDataBean(formDataMasterBean.getId(), formDataMasterBean);
        result.success(CAPAttachmentUtil.buildAttachmentMaps(sessionAttachment, true));
        return result;
    }

    public ScreenCaptureResult screenCapture(ScreenCapture4FormParamBean paramBean) {
        FormDataMasterBean masterBean;
        if (paramBean.getFormMasterId() != null && (masterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterId())) != null) {
            this.mergeFormData(masterBean, paramBean.getMergeData());
        }
        return this.capScreenCaptureService.doFormScreenCapture4File(paramBean);
    }

    @Override
    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }

    public void setCap4SerialNumberManager(CAP4SerialNumberManager cap4SerialNumberManager) {
        this.cap4SerialNumberManager = cap4SerialNumberManager;
    }

    public void setJmMonitorService(JMMonitorService jmMonitorService) {
        this.jmMonitorService = jmMonitorService;
    }

    public void setCapScreenCaptureService(CAPScreenCaptureService capScreenCaptureService) {
        this.capScreenCaptureService = capScreenCaptureService;
    }

    public void setFormApi4Cap4(FormApi4Cap4 formApi4Cap4) {
        this.formApi4Cap4 = formApi4Cap4;
    }
}

