/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldExtendCtrl;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.FormDataSignatureParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.AbstractCAPFormDataService;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPFormDataSignatureService
extends AbstractCAPFormDataService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataSignatureService.class);

    @ValidateRequestParam(notEmpty={"formMasterDataId", "moduleId", "formId"})
    public FormDataResult<Map> getiSignatureProtectedData(FormDataSignatureParamBean paramBean) {
        FormDataResult<Map> result = new FormDataResult<Map>();
        try {
            int userAgent;
            String from = paramBean.getFrom();
            int n = userAgent = paramBean.getUserAgent() == null ? AppContext.getCurrentUser().getLoginSign() : paramBean.getUserAgent().intValue();
            if (Strings.isNotBlank((String)from) && (CAPBusinessEnum.FormOpenFrom.ORIGINAL_FORM.getKey().equals(from) || CAPBusinessEnum.FormOpenFrom.LIGHT_FORM.getKey().equals(from))) {
                userAgent = Constants.login_sign.phone.value();
            }
            FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterDataId());
            if (cacheFormDataMasterBean != null) {
                this.mergeFormData(cacheFormDataMasterBean, paramBean.getMergeData());
            } else {
                cacheFormDataMasterBean = this.capFormDataCacheManager.get4Data(paramBean.getFormMasterDataId(), formBean.getId());
            }
            List attachmentList = cacheFormDataMasterBean.getSessionAttachments(null);
            if (attachmentList == null) {
                Long realModuleId = this.getAttachmentRealReference(ModuleType.collaboration, paramBean.getModuleId());
                attachmentList = this.attachmentManager.getByReference(realModuleId);
            }
            Map<String, List<Attachment>> attachments = CAPAttachmentUtil.buildAttachmentSubReferenceToList(attachmentList);
            HashMap<String, Object> data = new HashMap<String, Object>();
            FormTableBean masterTableBean = formBean.getMasterTableBean();
            List masterFields = masterTableBean.getFields();
            if (CAPFormUtil.isPcLogin(userAgent)) {
                StringBuilder value = new StringBuilder();
                StringBuilder display = new StringBuilder();
                for (FormFieldBean formFieldBean : masterFields) {
                    if (formFieldBean.isCustomerCtrl()) continue;
                    display.append("my:" + formFieldBean.getDisplay() + "=my:" + formFieldBean.getDisplay() + ";");
                    List<Attachment> tempValue = cacheFormDataMasterBean.getFieldValue(formFieldBean.getName());
                    if (attachments.get(tempValue) != null && formFieldBean.getFieldCtrl() instanceof FormFieldExtendCtrl) {
                        tempValue = attachments.get(tempValue);
                    }
                    String protectedValue = formFieldBean.getFieldCtrl().getProtectedValue((Object)tempValue);
                    if (FormFieldComEnum.TEXT.getKey().equalsIgnoreCase(formFieldBean.getInputType()) && Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType()) && "0".equals(protectedValue)) {
                        Object[] values = formFieldBean.getDisplayValue((Object)value);
                        protectedValue = String.valueOf(values[0]);
                    }
                    String replaceProtectedValue = protectedValue.replaceAll("\r\n", ";").replaceAll("\n", ";");
                    value.append("my:" + formFieldBean.getDisplay() + "=" + replaceProtectedValue + "\r\n");
                }
                Map subDataBeans = cacheFormDataMasterBean.getSubTables();
                for (String tName : subDataBeans.keySet()) {
                    FormTableBean subTableBean = formBean.getTableByTableName(tName);
                    List subFields = subTableBean.getFields();
                    List subRows = (List)subDataBeans.get(tName);
                    for (FormFieldBean formFieldBean : subFields) {
                        if (formFieldBean.isCustomerCtrl()) continue;
                        display.append("my:" + formFieldBean.getDisplay() + "=my:" + formFieldBean.getDisplay() + ";");
                        value.append("my:" + formFieldBean.getDisplay() + "=");
                        StringBuilder tempSubValue = new StringBuilder();
                        for (FormDataSubBean subRow : subRows) {
                            List<Attachment> tempValue = subRow.getFieldValue(formFieldBean.getName());
                            if (attachments.get(tempValue) != null && formFieldBean.getFieldCtrl() instanceof FormFieldExtendCtrl) {
                                tempValue = attachments.get(tempValue);
                            }
                            String protectedValue = formFieldBean.getFieldCtrl().getProtectedValue((Object)tempValue);
                            if (FormFieldComEnum.TEXT.getKey().equalsIgnoreCase(formFieldBean.getInputType()) && Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType()) && "0".equals(protectedValue)) {
                                Object[] values = formFieldBean.getDisplayValue(tempValue);
                                protectedValue = String.valueOf(values[0]);
                            }
                            tempSubValue.append(protectedValue + ";");
                        }
                        String protectedValue = tempSubValue.toString();
                        String replaceProtectedValue = protectedValue.replaceAll("\r\n", ";").replaceAll("\n", ";");
                        value.append(replaceProtectedValue.substring(0, replaceProtectedValue.length() - 1) + "\r\n");
                    }
                }
                String valueStr = value.toString();
                String displayStr = display.toString();
                data.put("displayStr", displayStr.substring(0, displayStr.length() - 1));
                data.put("valueStr", valueStr);
            } else {
                for (FormFieldBean formFieldBean : masterFields) {
                    if (formFieldBean.isCustomerCtrl()) continue;
                    HashMap<String, Object> fieldDatas = new HashMap<String, Object>();
                    data.put(formFieldBean.getDisplay(), fieldDatas);
                    fieldDatas.put("fieldType", formFieldBean.getInputType());
                    ArrayList<String> fieldData = new ArrayList<String>();
                    fieldDatas.put("data", fieldData);
                    List<Attachment> value = cacheFormDataMasterBean.getFieldValue(formFieldBean.getName());
                    if (attachments.get(value) != null && formFieldBean.getFieldCtrl() instanceof FormFieldExtendCtrl) {
                        value = attachments.get(value);
                    }
                    fieldData.add(formFieldBean.getFieldCtrl().getProtectedValue((Object)value));
                }
                Map subDataBeans = cacheFormDataMasterBean.getSubTables();
                for (String tName : subDataBeans.keySet()) {
                    FormTableBean subTableBean = formBean.getTableByTableName(tName);
                    List subFields = subTableBean.getFields();
                    List subRows = (List)subDataBeans.get(tName);
                    for (FormFieldBean formFieldBean : subFields) {
                        if (formFieldBean.isCustomerCtrl()) continue;
                        HashMap<String, Object> fieldDatas = new HashMap<String, Object>();
                        data.put(formFieldBean.getDisplay(), fieldDatas);
                        fieldDatas.put("fieldType", formFieldBean.getInputType());
                        ArrayList<String> fieldData = new ArrayList<String>();
                        fieldDatas.put("data", fieldData);
                        for (FormDataSubBean subRow : subRows) {
                            List<Attachment> value = subRow.getFieldValue(formFieldBean.getName());
                            if (attachments.get(value) != null && formFieldBean.getFieldCtrl() instanceof FormFieldExtendCtrl) {
                                value = attachments.get(value);
                            }
                            fieldData.add(formFieldBean.getFieldCtrl().getProtectedValue((Object)value));
                        }
                    }
                }
            }
            result.success(data);
        }
        catch (Exception e) {
            LOGGER.error((Object)"getiSignatureProtectedData Exception ", (Throwable)e);
            result.error("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
        return result;
    }
}

