/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.apps.index.api.IndexApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.FormLogUtil;
import com.seeyon.cap4.template.event.CAPBatchOperationIndexEvent;
import com.seeyon.cap4.template.event.CAPBatchOperationLogEvent;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.annotation.ListenEvent;
import org.apache.commons.logging.Log;

public class CAPFormEventService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormEventService.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private CapRunningLogManager capRunningLogManager;
    private IndexApi indexApi;

    @ListenEvent(event=CAPBatchOperationIndexEvent.class, async=true)
    public void onBatchOperationIndexEvent(CAPBatchOperationIndexEvent event) {
        if (event != null) {
            LOGGER.info((Object)("CAPBatchOperationIndexEvent " + event.toString()));
            if (AppContext.hasPlugin((String)"index")) {
                try {
                    for (String dataId : event.getMasterIds()) {
                        this.indexApi.update(Long.valueOf(Long.parseLong(dataId)), Integer.valueOf(ApplicationCategoryEnum.form.getKey()));
                    }
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)"updateIndexApi BusinessException", (Throwable)e);
                }
            }
        }
    }

    @ListenEvent(event=CAPBatchOperationLogEvent.class, async=true)
    public void onBatchOperationLogEvent(CAPBatchOperationLogEvent event) {
        if (event != null) {
            try {
                LOGGER.info((Object)("CAPBatchOperationLogEvent " + event.toString()));
                User user = event.getCurrentUser();
                FormBean formBean = this.cap4FormCacheManager.getForm(event.getFormId());
                String desc = FormLogUtil.getLogForBatchOperation(formBean.getFormName(), event.getCapLogType().getText(), event.getSuccessNum(), event.getErrorNum());
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formBean.getId());
                Long bizId = bizConfigBean == null ? null : bizConfigBean.getId();
                String bizName = bizConfigBean == null ? null : bizConfigBean.getName();
                this.capRunningLogManager.saveRunningLog(bizId, bizName, formBean.getId(), formBean.getFormName(), 0L, event.getCapLogType().getKey(), desc, user.getId(), user.getId(), DateUtil.currentDate(), user.getLoginAccountName(), user.getRemoteAddr());
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapRunningLogManager(CapRunningLogManager capRunningLogManager) {
        this.capRunningLogManager = capRunningLogManager;
    }

    public void setIndexApi(IndexApi indexApi) {
        this.indexApi = indexApi;
    }
}

