/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.modules.engin.plugin.CAPFormPluginManager;
import com.seeyon.cap4.form.modules.engin.plugin.FormPluginParamBean;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.FormPluginConfigParamBean;
import com.seeyon.cap4.template.dao.CAPFormPluginWhitelistDAO;
import com.seeyon.cap4.template.po.CAPFormPluginWhitelist;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.vo.FormPluginVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPFormPluginService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormPluginService.class);
    private CAPFormPluginManager capFormPluginManager;
    private CAPFormPluginWhitelistDAO capFormPluginWhitelistDAO;

    public FormDataResult getWhitePlugins(FormPluginConfigParamBean paramBean) {
        FormDataResult<List> result = new FormDataResult<List>();
        result.success(this.capFormPluginManager.getAllWhitePlugins());
        return result;
    }

    @ValidateRequestParam(notEmpty={"type"})
    public FormDataResult getConfigedPlugins(FormPluginConfigParamBean paramBean) {
        List<CAPFormPluginWhitelist> whitelists = null;
        FormDataResult result = new FormDataResult();
        try {
            if ("formId".equals(paramBean.getType())) {
                whitelists = this.capFormPluginWhitelistDAO.getByFormId(paramBean.getFormId());
            } else if ("bindId".equals(paramBean.getType())) {
                whitelists = this.capFormPluginWhitelistDAO.getByBindId(paramBean.getBindId());
            }
            ArrayList<FormPluginVO> vos = new ArrayList<FormPluginVO>();
            if (CollectionUtils.isNotEmpty(whitelists)) {
                for (CAPFormPluginWhitelist plugin : whitelists) {
                    vos.add(new FormPluginVO(plugin));
                }
            }
            result.success(vos);
        }
        catch (BusinessException e) {
            LOGGER.info((Object)("getConfigedPlugins " + paramBean), (Throwable)e);
            result.exception();
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"type"})
    public FormDataResult<FormPluginVO> saveConfigPlugins(FormPluginConfigParamBean paramBean) {
        FormDataResult<FormPluginVO> result = new FormDataResult<FormPluginVO>();
        try {
            if ("formId".equals(paramBean.getType())) {
                this.capFormPluginWhitelistDAO.deleteByFormId(paramBean.getFormId());
            } else if ("bindId".equals(paramBean.getType())) {
                this.capFormPluginWhitelistDAO.deleteByBindId(paramBean.getBindId());
            }
            if (paramBean.getValue() != null && !paramBean.getValue().isEmpty()) {
                ArrayList<CAPFormPluginWhitelist> whitelists = new ArrayList<CAPFormPluginWhitelist>();
                Long createId = AppContext.currentUserId();
                Timestamp date = DateUtil.currentTimestamp();
                for (Map.Entry<String, List<String>> entry : paramBean.getValue().entrySet()) {
                    for (String value : entry.getValue()) {
                        CAPFormPluginWhitelist whitelist = new CAPFormPluginWhitelist();
                        if ("formId".equals(paramBean.getType())) {
                            whitelist.setFormId(paramBean.getFormId());
                        } else if ("bindId".equals(paramBean.getType())) {
                            whitelist.setBindId(paramBean.getBindId());
                            whitelist.setFormId(paramBean.getFormId());
                        }
                        whitelist.setPluginName(value);
                        whitelist.setNewId();
                        whitelist.setCreateId(createId);
                        whitelist.setCreateTime(date);
                        whitelist.setModifyTime(date);
                        whitelist.setDataInfo(entry.getKey());
                        whitelists.add(whitelist);
                    }
                }
                this.capFormPluginWhitelistDAO.insert(whitelists);
            }
            this.capFormPluginManager.initPlugins();
            result.success();
        }
        catch (BusinessException e) {
            LOGGER.info((Object)("saveConfigPlugins " + paramBean), (Throwable)e);
            result.exception();
        }
        return result;
    }

    public void initFormPlugins() {
        this.capFormPluginManager.initPlugins();
    }

    public String getFormPlugins4Document(FormPluginParamBean paramBean) {
        return this.capFormPluginManager.getFormPlugins4Document(paramBean);
    }

    public List<Map<String, Object>> getFormPlugins(FormPluginParamBean paramBean) {
        return this.capFormPluginManager.getFormPlugins(paramBean);
    }

    public void setCapFormPluginManager(CAPFormPluginManager capFormPluginManager) {
        this.capFormPluginManager = capFormPluginManager;
    }

    public void setCapFormPluginWhitelistDAO(CAPFormPluginWhitelistDAO capFormPluginWhitelistDAO) {
        this.capFormPluginWhitelistDAO = capFormPluginWhitelistDAO;
    }
}

