/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.google.common.collect.Sets;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormQueryTypeEnum;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.relation.bo.CAP4RelationQueryParamsBO;
import com.seeyon.cap4.form.po.CAPFormRelationRecord;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.magic.execute.ICAP4MagicExecuteManager;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.FilterFieldBean;
import com.seeyon.cap4.template.bean.RelationParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPFilterFieldManager;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.AbstractCAPFormDataService;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormDataLogUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.vo.FilterFieldVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPFormRelationService
extends AbstractCAPFormDataService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormRelationService.class);
    private static final String CODE13 = "2013";
    private static final String MESSAGE13 = "cap.template.relation.ship.disabled";
    private static final String MESSAGE14 = "cap.template.relation.record.missing";
    private Integer relationAutoFillSize = null;
    private static final String RELATION_SHIP_ID = "relationShipId";
    private static final String RELATION_DATA = "relationData";
    private static final String CLEAN_CACHE_RELATION_DATA = "cleanCacheRelationData";
    private CAPFilterFieldManager capFilterFieldManager;

    @ValidateRequestParam(notEmpty={"relationShipId", "rightId", "formId"}, validateCacheBeanKey="formMasterId")
    public FormDataResult refreshSubData(RelationParamBean relationParamBean) {
        FormDataResult<Map<String, Object>> result = new FormDataResult<Map<String, Object>>();
        FormBean formBean = this.cap4FormCacheManager.getForm(relationParamBean.getFormId());
        FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(relationParamBean.getFormMasterId());
        this.mergeFormData(cacheFormDataMasterBean, relationParamBean.getMergeData());
        FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationParamBean.getRelationShipId());
        if (formRelationshipBean == null || formRelationshipBean.getState() == 0) {
            result.error(CODE13, ResourceUtil.getString((String)MESSAGE13));
            return result;
        }
        FormRelationshipMapBean formRelationshipMapBean = (FormRelationshipMapBean)formRelationshipBean.getRelationMapList().get(0);
        FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, relationParamBean.getRightId());
        try {
            LOGGER.info((Object)("refreshSubData data:" + cacheFormDataMasterBean.getId() + ",relation:" + formRelationshipMapBean.export4Log()));
            Map<String, List<FormDataSubBean>> formDataSubBeanMaps = null;
            HashMap<String, Set<String>> tableName2DeleteIds = new HashMap<String, Set<String>>();
            if (formRelationshipBean.getRelationType() == FormRelationEnums.ViewSelectType.auto_collect.getKey()) {
                formDataSubBeanMaps = this.cap4FormRelationActionManager.getRelationAutoSummaryFromSelf(formBean, cacheFormDataMasterBean, formAuthViewBean, formRelationshipMapBean, tableName2DeleteIds);
            } else if (formRelationshipBean.getRelationType() == FormRelationEnums.ViewSelectType.auto_increase_row.getKey()) {
                formDataSubBeanMaps = this.cap4FormRelationActionManager.getRelationAutoIncreaseRow(formBean, cacheFormDataMasterBean, formAuthViewBean, formRelationshipMapBean, tableName2DeleteIds, null);
            }
            HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
            if (formDataSubBeanMaps != null && formDataSubBeanMaps.size() > 0) {
                Set<String> fillBackFields = this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, CAPFormUtil.getTableName2FormSubDataBeanIds(formDataSubBeanMaps));
                HashMap<String, List> tableName2AddSubBeans = new HashMap<String, List>();
                for (String tableName : formDataSubBeanMaps.keySet()) {
                    tableName2AddSubBeans.put(tableName, cacheFormDataMasterBean.getSubData(tableName));
                }
                this.capRuntimeCalcManager.buildCalcAllResult(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddSubBeans, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.FRONT_COLLECT_OR_INCREASE, tableName2DataMaps);
                this.mergeAutoDelete2Result(tableName2DeleteIds, tableName2DataMaps);
            }
            HashMap<String, HashMap<String, Map<String, Object>>> data = new HashMap<String, HashMap<String, Map<String, Object>>>();
            data.put("tableData", tableName2DataMaps);
            result.success(data);
            this.buildExtendResult(formBean, cacheFormDataMasterBean, formAuthViewBean, result);
            this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
        }
        catch (Exception e) {
            LOGGER.error((Object)("refreshSubData is error " + e.getMessage()), (Throwable)e);
            result.error("2001", e.getMessage());
        }
        return result;
    }

    private void dealRelationData(FormRelationshipMapBean formRelationshipMapBean, Map<String, Object> map, FormBean formBean, FormDataMasterBean formDataMasterBean, FormDataSubBean formDataSubBean, Map<String, String> summaryId2Subject, boolean isUpdate) throws BusinessException {
        if (map.get(RELATION_DATA) == null) {
            LOGGER.error((Object)(formDataMasterBean.getId() + " \u624b\u52a8\u5173\u8054\u56de\u586b\u65e0\u6570\u636e"));
            return;
        }
        Map relationData = (Map)map.get(RELATION_DATA);
        Map fieldMap = formRelationshipMapBean.getFormRelationFieldMap();
        Iterator iterator = fieldMap.keySet().iterator();
        HashMap<String, Object> changeField = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            FormDataSubBean formDataBean;
            String fromFieldName = (String)iterator.next();
            FormFieldBean fromFormFieldBean = formBean.getFieldBeanByName(fromFieldName);
            Object fieldValue = null;
            if (FormRelationEnums.SpecialRelationItem.FLOW_NAME.getKey().equals(fieldMap.get(fromFieldName))) {
                String summaryId = (String)map.get("summaryId");
                if (Strings.isNotBlank((String)summaryId) && !"0".equals(summaryId)) {
                    if (summaryId2Subject.containsKey(summaryId)) {
                        fieldValue = summaryId2Subject.get(summaryId);
                    } else {
                        ColSummary colSummary = this.collaborationApi.getColSummary(Long.valueOf(summaryId));
                        fieldValue = colSummary == null ? null : colSummary.getSubject();
                        summaryId2Subject.put(summaryId, colSummary == null ? null : colSummary.getSubject());
                    }
                } else {
                    LOGGER.error((Object)(formDataMasterBean.getId() + " \u624b\u52a8\u5173\u8054\u9009\u62e9\u6d41\u7a0b summaryId " + summaryId));
                }
            } else {
                Map fieldValueMap = (Map)relationData.get(fromFieldName);
                fieldValue = fieldValueMap.get("value");
                if (Enums.FieldType.DATETIME.getKey().equals(fromFormFieldBean.getFieldType()) || Enums.FieldType.TIMESTAMP.getKey().equals(fromFormFieldBean.getFieldType())) {
                    if (Strings.isBlank((String)String.valueOf(fieldValueMap.get("showValue2")))) {
                        fieldValue = null;
                    } else {
                        Object[] values = fromFormFieldBean.getDisplayValue(fieldValueMap.get("showValue2"));
                        fieldValue = values[0];
                    }
                }
            }
            Object object = formDataBean = formDataSubBean != null ? formDataSubBean : formDataMasterBean;
            if ((fromFormFieldBean.isAttachment() || fromFormFieldBean.isMap()) && fieldValue != null && Strings.isNotBlank((String)String.valueOf(fieldValue))) {
                Long subReference = Long.parseLong(String.valueOf(fieldValue));
                Long newSubReference = null;
                if (fromFormFieldBean.isMap()) {
                    Long subDataId = formDataSubBean != null ? formDataBean.getId() : null;
                    newSubReference = CAPFormUtil.copyLBS(formBean.getId(), formDataMasterBean.getId(), subDataId, subReference, fromFormFieldBean);
                }
                if (fromFormFieldBean.isAttachment()) {
                    newSubReference = CAPAttachmentUtil.copyAttachment(formDataMasterBean, fromFormFieldBean, subReference, formDataMasterBean.getId(), newSubReference, false);
                }
                fieldValue = newSubReference;
            }
            Object oldValue = null;
            if (fromFormFieldBean.isMasterField()) {
                oldValue = formDataMasterBean.getFieldValue(fromFormFieldBean.getName());
                formDataMasterBean.addFieldChanges4Calc(fromFormFieldBean, fieldValue, null, isUpdate);
                formDataMasterBean.addFieldValue(fromFieldName, fieldValue);
                changeField.put(fromFieldName, fieldValue);
            } else if (formDataBean != null) {
                oldValue = formDataBean.getFieldValue(fromFormFieldBean.getName());
                formDataMasterBean.addFieldChanges4Calc(fromFormFieldBean, fieldValue, formDataSubBean, isUpdate);
                formDataBean.addFieldValue(fromFieldName, fieldValue);
                changeField.put(formDataBean.generageFillbackKey(fromFieldName), fieldValue);
            }
            if (oldValue == null || String.valueOf(oldValue).equals(String.valueOf(fieldValue)) || !fromFormFieldBean.isAttachment()) continue;
            formDataMasterBean.putSessionAttachments(String.valueOf(oldValue), null);
        }
        CAPFormDataLogUtil.recordRelation(formRelationshipMapBean, formDataMasterBean.getId(), changeField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValidateRequestParam(notEmpty={"relationShipId", "selectDatas"}, validateCacheBeanKey="fromDataId")
    public FormDataResult dealSelectedRelationData(RelationParamBean relationParamBean) {
        FormDataResult<Map<String, Object>> result = new FormDataResult<Map<String, Object>>();
        Long fromMasterDataId = relationParamBean.getFormMasterId();
        Long fromRightId = relationParamBean.getRightId() == null ? -1L : relationParamBean.getRightId();
        Map<String, String> selectRecordIds = relationParamBean.getSelectRecordIds();
        Long fromRecordId = relationParamBean.getRecordId();
        FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationParamBean.getRelationShipId());
        if (formRelationshipBean == null || formRelationshipBean.getState() == 0) {
            result.error(CODE13, ResourceUtil.getString((String)MESSAGE13));
            return result;
        }
        FormDataMasterBean fromFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(fromMasterDataId);
        List formRelationshipMapBeans = formRelationshipBean.getRelationMapList();
        if (fromFormDataMasterBean.getRelationRecords() == null) {
            fromFormDataMasterBean.setRelationRecords(new ArrayList());
        }
        List capFormRelationRecords = fromFormDataMasterBean.getRelationRecords();
        Long fromFormId = formRelationshipBean.getSourceFormId();
        FormBean fromFormBean = this.cap4FormCacheManager.getForm(fromFormId);
        FormAuthViewBean fromFormAuthViewBean = CAPFormUtil.getFormAuthViewBean(fromFormBean, fromFormDataMasterBean, fromRightId);
        List formViewFields = fromFormAuthViewBean.getViewBean(fromFormBean).getFieldList();
        HashMap<String, HashMap<String, Map<String, Object>>> resultData = new HashMap<String, HashMap<String, Map<String, Object>>>();
        try {
            Map<String, List<FormDataSubBean>> fieldTableName2AddSubBeans;
            HashMap<String, String> summaryId2Subject = new HashMap<String, String>();
            HashMap<String, List<Long>> tableName2AddSubIds = new HashMap<String, List<Long>>();
            HashSet<String> relationUpdateFields4Return = new HashSet<String>();
            Map capFormRelationRecordMap = fromFormDataMasterBean.getRelationRecordMap();
            boolean isInsertMulti = false;
            Long insertMultiPreRecordId = null;
            Map<String, Object> relationDataMap = this.cap4FormRelationActionManager.getCacheRelationData(fromFormDataMasterBean.getId());
            FormFieldBean formCalcAutoIncreaseField = null;
            for (Map<String, Object> map : relationParamBean.getSelectDatas()) {
                boolean isMainSelectField = CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(String.valueOf(map.get("isMainSelecter")));
                String selectFieldName = String.valueOf(map.get("fromRelationAttr"));
                FormDataSubBean fromFormDataSubBean = null;
                FormFieldBean fromFormFieldBean = fromFormBean.getFieldBeanByName(selectFieldName);
                FormFieldBean formFieldBean = formCalcAutoIncreaseField = formCalcAutoIncreaseField == null && isMainSelectField ? fromFormFieldBean : null;
                if (fromRecordId != null && fromFormFieldBean.isSubField()) {
                    fromFormDataSubBean = fromFormDataMasterBean.getFormDataSubBeanById(fromFormFieldBean.getOwnerTableName(), fromRecordId);
                }
                if (fromFormDataSubBean == null && fromFormFieldBean.isSubField() && !isMainSelectField) {
                    if (insertMultiPreRecordId == null && selectRecordIds != null && Strings.isNotBlank((String)selectRecordIds.get(fromFormFieldBean.getOwnerTableName()))) {
                        insertMultiPreRecordId = Long.valueOf(selectRecordIds.get(fromFormFieldBean.getOwnerTableName()));
                    }
                    isInsertMulti = true;
                    List<FormDataSubBean> subBeans = this.initRelationAddSubDataBean(fromFormDataMasterBean, fromFormAuthViewBean, fromFormBean.getTableByTableName(fromFormFieldBean.getOwnerTableName()), insertMultiPreRecordId);
                    fromFormDataSubBean = subBeans.get(0);
                    insertMultiPreRecordId = fromFormDataSubBean.getId();
                }
                FormRelationshipMapBean mapBean = this.cap4FormRelationActionManager.getFormRelationshipMapBeanBySelectedFieldName(formRelationshipBean, selectFieldName);
                if (map.get(RELATION_DATA) == null && relationDataMap != null) {
                    map.put(RELATION_DATA, relationDataMap.get(map.get("unique")));
                }
                this.dealRelationData(mapBean, map, fromFormBean, fromFormDataMasterBean, fromFormDataSubBean, summaryId2Subject, !isInsertMulti);
                if (isInsertMulti) {
                    if (fromFormDataSubBean == null) continue;
                    ArrayList<Long> newMultiSubIds = (ArrayList<Long>)tableName2AddSubIds.get(fromFormFieldBean.getOwnerTableName());
                    if (newMultiSubIds == null) {
                        newMultiSubIds = new ArrayList<Long>();
                    }
                    newMultiSubIds.add(fromFormDataSubBean.getId());
                    CAPFormRelationRecord capFormRelationRecord = this.convertRelationSelectMap2RelationRecord(fromFormId, fromMasterDataId, fromFormDataSubBean.getId(), mapBean, map);
                    capFormRelationRecordMap.put(capFormRelationRecord.getFieldName() + "_" + fromFormDataSubBean.getId(), capFormRelationRecord);
                    capFormRelationRecords.add(capFormRelationRecord);
                    tableName2AddSubIds.put(fromFormFieldBean.getOwnerTableName(), newMultiSubIds);
                } else {
                    if (fromFormFieldBean.isSubField() && fromFormDataSubBean == null) continue;
                    Set relationFieldList = mapBean.getFormRelationFieldMap().keySet();
                    for (String fieldName : relationFieldList) {
                        FormFieldBean formFieldBean2 = fromFormBean.getFieldBeanByName(fieldName);
                        if (formFieldBean2 == null || !formViewFields.contains(fieldName)) continue;
                        relationUpdateFields4Return.add(formFieldBean2.isSubField() ? fromFormDataSubBean.generageFillbackKey(fieldName) : fieldName);
                    }
                    CAPFormRelationRecord oldCapFormRelationRecord = this.getCAPFormRelationRecordById(capFormRelationRecords, fromFormFieldBean, fromMasterDataId, fromRecordId);
                    if (oldCapFormRelationRecord != null) {
                        LOGGER.info((Object)("\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55(session),cause by manual selection," + oldCapFormRelationRecord.exportToMap()));
                        capFormRelationRecords.remove(oldCapFormRelationRecord);
                    }
                    CAPFormRelationRecord capFormRelationRecord = this.convertRelationSelectMap2RelationRecord(fromFormId, fromMasterDataId, fromRecordId, mapBean, map);
                    capFormRelationRecords.add(capFormRelationRecord);
                    String recordKey = capFormRelationRecord.getFieldName();
                    if (fromFormDataSubBean != null) {
                        recordKey = recordKey + "_" + fromFormDataSubBean.getId();
                    }
                    capFormRelationRecordMap.put(recordKey, capFormRelationRecord);
                }
                if (!isMainSelectField || formRelationshipMapBeans.isEmpty()) continue;
                for (FormRelationshipMapBean formRelationshipMapBean : formRelationshipMapBeans) {
                    FormFieldBean selectFieldBean = fromFormBean.getFieldBeanByName(formRelationshipMapBean.getSelectedField());
                    if (formRelationshipMapBean.getAutoFillRepeat() != 1 || selectFieldBean.isMasterField()) continue;
                    HashMap<String, Object> queryParams = new HashMap<String, Object>();
                    queryParams.put("page", "1");
                    queryParams.put("pageSize", this.relationAutoFillSize == null ? "100" : String.valueOf(this.relationAutoFillSize));
                    queryParams.put(RELATION_SHIP_ID, String.valueOf(relationParamBean.getRelationShipId()));
                    queryParams.put("fromRelationAttr", formRelationshipMapBean.getSelectedField());
                    queryParams.put("isMainSelecter", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    queryParams.put("fromDataId", String.valueOf(fromMasterDataId));
                    queryParams.put("fromRecordId", "");
                    queryParams.put("selectedMasterDataId", String.valueOf(map.get("dataId")));
                    queryParams.put("needShowData", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    queryParams.put(CLEAN_CACHE_RELATION_DATA, CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    Map<String, Object> queryResult = this.getManualRelationDatas(queryParams, formRelationshipBean, formRelationshipMapBean, 0, formRelationshipMapBean.getSelectedField());
                    List mapList = (List)queryResult.get("data");
                    if (mapList == null || mapList.isEmpty()) continue;
                    ArrayList<Long> newAutoFillSubIds = new ArrayList<Long>();
                    FormTableBean fromFormTableBean = fromFormBean.getTableByTableName(selectFieldBean.getOwnerTableName());
                    Long autoPreRecordId = selectRecordIds == null ? null : (Strings.isBlank((String)selectRecordIds.get(selectFieldBean.getOwnerTableName())) ? null : Long.valueOf(selectRecordIds.get(selectFieldBean.getOwnerTableName())));
                    for (Map tempMap : mapList) {
                        List<FormDataSubBean> subBeans = this.initRelationAddSubDataBean(fromFormDataMasterBean, fromFormAuthViewBean, fromFormTableBean, autoPreRecordId);
                        this.dealRelationData(formRelationshipMapBean, tempMap, fromFormBean, fromFormDataMasterBean, subBeans.get(0), summaryId2Subject, false);
                        Long subId = subBeans.get(0).getId();
                        if (autoPreRecordId != null) {
                            autoPreRecordId = subId;
                        }
                        newAutoFillSubIds.add(subId);
                        CAPFormRelationRecord capFormRelationRecord = this.convertRelationSelectMap2RelationRecord(fromFormId, fromMasterDataId, subId, formRelationshipMapBean, tempMap);
                        capFormRelationRecords.add(capFormRelationRecord);
                        capFormRelationRecordMap.put(capFormRelationRecord.getFieldName() + "_" + subId, capFormRelationRecord);
                    }
                    tableName2AddSubIds.put(selectFieldBean.getOwnerTableName(), newAutoFillSubIds);
                }
            }
            HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
            HashMap<String, Set<String>> tableName2DeleteIds = new HashMap<String, Set<String>>();
            HashSet<String> fillBackFields = new HashSet<String>();
            if (!tableName2AddSubIds.isEmpty()) {
                this.capRuntimeCalcManager.mergeFirstDelete2Result(fromFormDataMasterBean, tableName2DataMaps, tableName2AddSubIds, selectRecordIds, tableName2DeleteIds);
            }
            if ((fieldTableName2AddSubBeans = this.calculateAutoIncreaseByField(fromFormBean, fromFormDataMasterBean, fromFormAuthViewBean, formCalcAutoIncreaseField, fillBackFields, tableName2DeleteIds, false)) != null) {
                Map<String, List<Long>> fieldTableName2AddSubIds = CAPFormUtil.getTableName2FormSubDataBeanIds(fieldTableName2AddSubBeans);
                for (String tableName : fieldTableName2AddSubIds.keySet()) {
                    if (tableName2AddSubIds.get(tableName) != null) {
                        LOGGER.info((Object)(fromFormDataMasterBean.getId() + " dealRelationData clear table relation add by field auto increase , " + tableName));
                        tableName2AddSubIds.remove(tableName);
                        continue;
                    }
                    LOGGER.info((Object)(fromFormDataMasterBean.getId() + " dealRelationData table data add by field auto increase , " + tableName));
                }
                tableName2AddSubIds.putAll(fieldTableName2AddSubIds);
            }
            fillBackFields.addAll(this.capRuntimeCalcManager.execCalcAll(fromFormBean, fromFormDataMasterBean, fromFormAuthViewBean, tableName2AddSubIds));
            fillBackFields.addAll(relationUpdateFields4Return);
            this.capRuntimeCalcManager.buildCalcAllResult(fromFormBean, fromFormDataMasterBean, fromFormAuthViewBean, tableName2AddSubIds, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.MANUAL_RELATION, tableName2DataMaps);
            if (!tableName2DeleteIds.isEmpty()) {
                this.mergeAutoDelete2Result(tableName2DeleteIds, tableName2DataMaps);
            }
            resultData.put("tableData", tableName2DataMaps);
            result.success(resultData);
            this.buildExtendResult(fromFormBean, fromFormDataMasterBean, fromFormAuthViewBean, result);
            this.cap4FormManager.saveSessioMasterDataBean(fromFormDataMasterBean.getId(), fromFormDataMasterBean);
        }
        catch (Exception e) {
            LOGGER.error((Object)("method dealSelectedRelationData is error." + e.getMessage()), (Throwable)e);
            result.error("2001", e.getMessage());
        }
        finally {
            this.cap4FormRelationActionManager.removeCacheRelationData(fromFormDataMasterBean.getId());
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"relationShipId", "rightId", "fromRelationAttr"}, validateCacheBeanKey="formMasterDataId")
    public FormDataResult cleanRelationData(RelationParamBean relationParamBean) {
        FormDataResult<Map<String, Object>> result = new FormDataResult<Map<String, Object>>();
        Long fromMasterDataId = relationParamBean.getFormMasterId();
        FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(fromMasterDataId);
        if (relationParamBean.getMergeData() != null) {
            this.mergeFormData(cacheFormDataMasterBean, relationParamBean.getMergeData());
        }
        Long relationShipId = relationParamBean.getRelationShipId();
        Long fromRightId = relationParamBean.getRightId();
        Long fromRecordId = relationParamBean.getRecordId();
        String fromRelationAttr = relationParamBean.getFromRelationAttr();
        FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationShipId);
        if (formRelationshipBean == null || formRelationshipBean.getState() == 0) {
            result.error(CODE13, ResourceUtil.getString((String)MESSAGE13));
            return result;
        }
        try {
            CAPFormRelationRecord capFormRelationRecord;
            FormRelationshipMapBean formRelationshipMapBean = this.cap4FormRelationActionManager.getFormRelationshipMapBeanBySelectedFieldName(formRelationshipBean, fromRelationAttr);
            FormBean formBean = this.cap4FormCacheManager.getForm(formRelationshipBean.getSourceFormId());
            FormFieldBean fieldBean = formBean.getFieldBeanByName(fromRelationAttr);
            FormDataSubBean formDataSubBean = null;
            if (fieldBean.isSubField()) {
                if (fromRecordId == null) {
                    result.error("2004", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "recordId"));
                    return result;
                }
                formDataSubBean = cacheFormDataMasterBean.getFormDataSubBeanById(fieldBean.getOwnerTableName(), fromRecordId);
                if (formDataSubBean == null) {
                    throw new BusinessException(ResourceUtil.getString((String)MESSAGE14));
                }
            }
            FormAuthViewBean fromFormAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, fromRightId);
            List formViewFields = fromFormAuthViewBean.getViewBean(formBean).getFieldList();
            Map fieldMap = formRelationshipMapBean.getFormRelationFieldMap();
            Iterator iterator = fieldMap.keySet().iterator();
            HashSet<String> relationCleanFields4Return = new HashSet<String>();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(key);
                if (formFieldBean.isAttachment()) {
                    Object oldValue;
                    Object object = oldValue = formDataSubBean == null ? cacheFormDataMasterBean.getFieldValue(formFieldBean.getName()) : formDataSubBean.getFieldValue(formFieldBean.getName());
                    if (oldValue != null) {
                        cacheFormDataMasterBean.putSessionAttachments(String.valueOf(oldValue), null);
                    }
                }
                cacheFormDataMasterBean.addFieldChanges4Calc(formFieldBean, null, formDataSubBean, true);
                if (formDataSubBean == null) {
                    cacheFormDataMasterBean.addFieldValue(key, null);
                } else {
                    formDataSubBean.addFieldValue(key, null);
                }
                if (formFieldBean == null || !formViewFields.contains(formFieldBean.getName())) continue;
                relationCleanFields4Return.add(formDataSubBean != null ? formDataSubBean.generageFillbackKey(formFieldBean.getName()) : formFieldBean.getName());
            }
            LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " clear manual relation " + formRelationshipMapBean.export4Log() + ", fields " + fieldMap.keySet().toString()));
            if (cacheFormDataMasterBean.getRelationRecords() != null && (capFormRelationRecord = this.getCAPFormRelationRecordById(cacheFormDataMasterBean.getRelationRecords(), fieldBean, fromMasterDataId, fromRecordId)) != null) {
                LOGGER.info((Object)("\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55(session),cause by cleanRelationData," + capFormRelationRecord.exportToMap()));
                cacheFormDataMasterBean.getRelationRecords().remove(capFormRelationRecord);
            }
            Map capFormRelationRecordMap = cacheFormDataMasterBean.getRelationRecordMap();
            capFormRelationRecordMap.remove(formDataSubBean == null ? fieldBean.getName() : formDataSubBean.generageFillbackKey(fieldBean.getName()));
            HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
            HashSet<String> fillBackFields = new HashSet<String>();
            Map<String, List<FormDataSubBean>> fieldTableName2AddSubBeans = null;
            HashMap<String, Set<String>> tableName2DeleteIds = new HashMap<String, Set<String>>();
            HashMap<String, List<Long>> tableName2AddSubIds = new HashMap<String, List<Long>>();
            if (fieldBean.isMasterField()) {
                fieldTableName2AddSubBeans = this.calculateAutoIncreaseByField(formBean, cacheFormDataMasterBean, fromFormAuthViewBean, fieldBean, fillBackFields, tableName2DeleteIds, false);
                if (fieldTableName2AddSubBeans != null) {
                    Map<String, List<Long>> fieldTableName2AddSubIds = CAPFormUtil.getTableName2FormSubDataBeanIds(fieldTableName2AddSubBeans);
                    tableName2AddSubIds.putAll(fieldTableName2AddSubIds);
                }
                LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " clear manual relation " + fieldBean.getName() + " trigger new line details " + (fieldTableName2AddSubBeans == null ? null : fieldTableName2AddSubBeans.keySet().toString())));
            }
            fillBackFields.addAll(this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, fromFormAuthViewBean, tableName2AddSubIds));
            fillBackFields.addAll(relationCleanFields4Return);
            this.capRuntimeCalcManager.buildCalcAllResult(formBean, cacheFormDataMasterBean, fromFormAuthViewBean, tableName2AddSubIds, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.MANUAL_RELATION, tableName2DataMaps);
            if (!tableName2DeleteIds.isEmpty()) {
                this.mergeAutoDelete2Result(tableName2DeleteIds, tableName2DataMaps);
            }
            HashMap<String, HashMap<String, Map<String, Object>>> resultData = new HashMap<String, HashMap<String, Map<String, Object>>>();
            resultData.put("tableData", tableName2DataMaps);
            result.success(resultData);
            this.buildExtendResult(formBean, cacheFormDataMasterBean, fromFormAuthViewBean, result);
            this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method cleanRelationData is error." + e.getMessage()), (Throwable)e);
            result.error("2001", e.getMessage());
        }
        return result;
    }

    private List<FormDataSubBean> initRelationAddSubDataBean(FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormTableBean formTableBean, Long preRecordId) throws BusinessException {
        ArrayList<FormDataSubBean> newFormDataSubBeans = new ArrayList<FormDataSubBean>();
        FormDataSubBean formDataSubBean = new FormDataSubBean(formTableBean, formDataMasterBean, new boolean[]{true});
        formDataSubBean.setFormmainId(formDataMasterBean.getId().longValue());
        newFormDataSubBeans.add(formDataSubBean);
        if (preRecordId != null) {
            formDataMasterBean.addSubData(formTableBean.getTableName(), formDataSubBean, Long.valueOf(preRecordId));
        } else {
            formDataMasterBean.addSubData(formTableBean.getTableName(), formDataSubBean);
        }
        return this.initAddSubDataBeans(formDataMasterBean, formAuthViewBean, formTableBean, newFormDataSubBeans);
    }

    private CAPFormRelationRecord convertRelationSelectMap2RelationRecord(Long fromFormId, Long fromMasterDataId, Long fromSubDataId, FormRelationshipMapBean relationshipMapBean, Map<String, Object> relationRecord) {
        CAPFormRelationRecord record = new CAPFormRelationRecord();
        record.setNewId();
        record.setMemberId(Long.valueOf(AppContext.currentUserId()));
        record.setFromMasterDataId(fromMasterDataId);
        record.setFromSubdataId(fromSubDataId);
        record.setFromFormId(fromFormId);
        record.setType(Integer.valueOf(1));
        record.setFormType(Integer.valueOf(Integer.parseInt((String)relationRecord.get("toFormType"))));
        record.setFieldName((String)relationRecord.get("fromRelationAttr"));
        record.setToFormId(Long.valueOf((String)relationRecord.get("toFormId")));
        record.setToMasterDataId(Long.valueOf((String)relationRecord.get("dataId")));
        record.setToSubdataId(Strings.isBlank((String)((String)relationRecord.get("subDataId"))) ? null : Long.valueOf((String)relationRecord.get("subDataId")));
        record.setDataInfo(relationshipMapBean);
        return record;
    }

    private CAPFormRelationRecord getCAPFormRelationRecordById(List<CAPFormRelationRecord> capFormRelationRecords, FormFieldBean fromFormFieldBean, Long fromMasterId, Long fromSubId) {
        for (CAPFormRelationRecord capFormRelationRecord : capFormRelationRecords) {
            Long fromMasterDataId = capFormRelationRecord.getFromMasterDataId();
            Long fromSubDataId = capFormRelationRecord.getFromSubdataId();
            String fromFieldName = capFormRelationRecord.getFieldName();
            if (fromMasterDataId.longValue() != fromMasterId.longValue() || !fromFormFieldBean.getName().equals(fromFieldName) || (fromSubId != null || fromSubDataId != null) && (fromSubId == null || fromSubDataId == null || fromSubId.longValue() != fromSubDataId.longValue())) continue;
            return capFormRelationRecord;
        }
        return null;
    }

    @ValidateRequestParam(notEmpty={"relationShipId", "fromRelationAttr"})
    public Map<String, Object> getFormRelationDatas(Map<String, Object> params) {
        Map<String, Object> result = new HashMap<String, Object>();
        if (params.get("mergeData") != null) {
            Map mergeData = (Map)params.get("mergeData");
            Map content = (Map)mergeData.get("content");
            if (content == null) {
                result.put("code", "2004");
                result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "content"));
                return result;
            }
            Long formMasterDataId = Long.valueOf((String)content.get("contentDataId"));
            FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(formMasterDataId);
            if (cacheFormDataMasterBean == null) {
                result.put("code", "2010");
                result.put("message", ResourceUtil.getString((String)"cap.template.form.data.message.cacheDisabled"));
                return result;
            }
            this.mergeFormData(cacheFormDataMasterBean, mergeData);
        }
        Long relationShipId = CAPParamUtil.getLong(params, (String)RELATION_SHIP_ID);
        String fromRelationAttr = CAPParamUtil.getString(params, (String)"fromRelationAttr");
        int isMainSelecter = CAPParamUtil.getIntValue(params, (String)"isMainSelecter");
        Integer pageSize = CAPParamUtil.getInteger(params, (String)"pageSize");
        params.put("pageSize", pageSize == null ? 50 : pageSize);
        FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationShipId);
        if (formRelationshipBean == null || formRelationshipBean.getState() == 0) {
            result.put("code", CODE13);
            result.put("message", ResourceUtil.getString((String)MESSAGE13));
            return result;
        }
        FormRelationshipMapBean mainSelecterBean = formRelationshipBean.getMainSelector();
        FormRelationshipMapBean formRelationshipMapBean = null;
        formRelationshipMapBean = isMainSelecter == 1 ? mainSelecterBean : this.cap4FormRelationActionManager.getFormRelationshipMapBeanBySelectedFieldName(formRelationshipBean, fromRelationAttr);
        params.put(CLEAN_CACHE_RELATION_DATA, CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        try {
            result = this.getManualRelationDatas(params, formRelationshipBean, formRelationshipMapBean, isMainSelecter, fromRelationAttr);
            List filterFields = (List)result.get("filterFields");
            if (CollectionUtils.isNotEmpty((Collection)filterFields)) {
                HashSet fieldKeys = Sets.newHashSet();
                for (FilterFieldVO map : filterFields) {
                    fieldKeys.add(map.getName());
                }
                for (FilterFieldVO map : filterFields) {
                    String toRelationAttr = map.getToRelationAttr();
                    if (toRelationAttr != null) {
                        if (fieldKeys.contains(toRelationAttr)) {
                            map.setMultiEnum(CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                            map.setParentField(map.getAliasTableName() + "_" + toRelationAttr);
                            continue;
                        }
                        map.setMultiEnum(CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        continue;
                    }
                    map.setMultiEnum(CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getFormRelationDatas is error . param is " + params.toString()), (Throwable)e);
            result.put("code", "2001");
            result.put("message", e.getMessage());
        }
        return result;
    }

    private Map<String, Object> getManualRelationDatas(Map<String, Object> params, FormRelationshipBean formRelationshipBean, FormRelationshipMapBean formRelationshipMapBean, int isMainSelecter, String fromRelationAttr) throws BusinessException {
        Map<Object, Object> result = new HashMap();
        Integer isInit = CAPParamUtil.getInteger(params, (String)"isInit");
        isInit = isInit == null ? 0 : isInit;
        if (this.cap4FormRelationActionManager.isMagicManualRelation(formRelationshipBean)) {
            ICAP4MagicExecuteManager cap4MagicExecuteManager = (ICAP4MagicExecuteManager)AppContext.getBean((String)"cap4MagicExecuteManager");
            result = cap4MagicExecuteManager.getFormRelationDatasByMagic(params, formRelationshipBean, formRelationshipMapBean);
        } else {
            Long selectedMasterDataId;
            Integer page = CAPParamUtil.getInteger(params, (String)"page");
            Integer pageSize = CAPParamUtil.getInteger(params, (String)"pageSize");
            List conditions = params.get("conditions") != null ? (List)params.get("conditions") : null;
            page = page == null ? 1 : page;
            pageSize = pageSize == null ? 50 : pageSize;
            Long fromDataId = CAPParamUtil.getLong(params, (String)"fromDataId");
            Long fromRecordId = CAPParamUtil.getLong(params, (String)"fromRecordId");
            FlipInfo flipInfo = new FlipInfo(page.intValue());
            flipInfo.setSize(pageSize.intValue());
            FormBean toFormBean = this.cap4FormCacheManager.getForm(formRelationshipBean.getTargetFormId());
            CAP4RelationQueryParamsBO cap4RelationQueryParamsBO = new CAP4RelationQueryParamsBO();
            if (isMainSelecter != 1 && (selectedMasterDataId = CAPParamUtil.getLong(params, (String)"selectedMasterDataId")) != null) {
                if (Enums.FormType.processesForm.getKey() == toFormBean.getFormType()) {
                    ColSummary colSummary = this.collaborationApi.getColSummary(selectedMasterDataId);
                    cap4RelationQueryParamsBO.setSelectedToMasterDataId(colSummary.getFormRecordid());
                } else {
                    cap4RelationQueryParamsBO.setSelectedToMasterDataId(selectedMasterDataId);
                }
            }
            cap4RelationQueryParamsBO.setFromFormId(formRelationshipBean.getSourceFormId());
            cap4RelationQueryParamsBO.setFromDataId(fromDataId);
            cap4RelationQueryParamsBO.setFromRecordId(fromRecordId);
            cap4RelationQueryParamsBO.setFromRelationAttr(fromRelationAttr);
            cap4RelationQueryParamsBO.setFormRelationshipMapBean(formRelationshipMapBean);
            result.put("data", this.getCAPManualRelationDataList(toFormBean, formRelationshipMapBean, cap4RelationQueryParamsBO, conditions, flipInfo, fromRelationAttr, isMainSelecter));
            if (isInit == 1) {
                this.getInitData(formRelationshipMapBean, toFormBean, result);
            }
            this.getCAPManualRelationOtherResult(result, formRelationshipMapBean, flipInfo, toFormBean);
            result.put("code", "2000");
        }
        if ("2000".equals(result.get("code")) && CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(params.get(CLEAN_CACHE_RELATION_DATA))) {
            List list;
            Long masterId = CAPParamUtil.getLong(params, (String)"fromDataId");
            boolean isPc = CAPFormUtil.isPcLogin(AppContext.getCurrentUser().getLoginSign());
            if (isPc) {
                this.cap4FormRelationActionManager.removeCacheRelationData(masterId);
            }
            if (Strings.isNotEmpty((Collection)(list = (List)result.get("data")))) {
                Map<String, Object> exitsMap;
                HashMap<String, Object> relationDataMap = new HashMap<String, Object>();
                if (!isPc && (exitsMap = this.cap4FormRelationActionManager.getCacheRelationData(masterId)) != null) {
                    relationDataMap.putAll(exitsMap);
                }
                for (Map map : list) {
                    relationDataMap.put(String.valueOf(map.get("unique")), map.get(RELATION_DATA));
                    map.remove(RELATION_DATA);
                }
                this.cap4FormRelationActionManager.addCacheRelationData(masterId, relationDataMap);
            }
        }
        return result;
    }

    private void getInitData(FormRelationshipMapBean formRelationshipMapBean, FormBean toFormBean, Map<String, Object> result) throws BusinessException {
        List searchFields = formRelationshipMapBean.getQueryFieldList();
        if (Strings.isEmpty((Collection)searchFields)) {
            List showFields = formRelationshipMapBean.getShowFieldList();
            searchFields = showFields.size() > 3 ? showFields.subList(0, 3) : showFields;
        }
        List<FilterFieldBean> filterFieldBeanList = this.capFilterFieldManager.getFilterFieldBeans(toFormBean, searchFields, FormQueryTypeEnum.relationFormQuery);
        result.put("filterFields", this.capFilterFieldManager.getFilterFields(filterFieldBeanList));
        ArrayList list = new ArrayList(formRelationshipMapBean.getShowFieldList().size());
        for (SimpleObjectBean simpleObjectBean : formRelationshipMapBean.getShowFieldList()) {
            FormFieldBean fieldBean = toFormBean.getFieldBeanByName(simpleObjectBean.getName());
            if (fieldBean == null) continue;
            HashMap<String, String> dataMap = new HashMap<String, String>(4);
            if (simpleObjectBean.getValue() != null && simpleObjectBean.getValue().contains("(")) {
                dataMap.put("title", simpleObjectBean.getValue().substring(simpleObjectBean.getValue().indexOf("(") + 1, simpleObjectBean.getValue().indexOf(")")));
            } else {
                dataMap.put("title", simpleObjectBean.getValue());
            }
            dataMap.put("field", simpleObjectBean.getName());
            dataMap.put("fieldType", fieldBean.getFieldType());
            dataMap.put("inputType", fieldBean.getInputType());
            list.add(dataMap);
        }
        result.put("columnFields", list);
    }

    private void getCAPManualRelationOtherResult(Map<String, Object> result, FormRelationshipMapBean formRelationshipMapBean, FlipInfo flipInfo, FormBean toFormBean) {
        String pcRightId = "";
        String phoneRightId = "";
        if (formRelationshipMapBean.getListThrough() == 1) {
            if (!Strings.isBlank((String)formRelationshipMapBean.getListPcView())) {
                pcRightId = formRelationshipMapBean.getListPcView();
            }
            if (!Strings.isBlank((String)formRelationshipMapBean.getListPhoneView())) {
                phoneRightId = formRelationshipMapBean.getListPhoneView();
            }
        }
        result.put("pcRightId", pcRightId);
        result.put("phoneRightId", phoneRightId);
        result.put("page", String.valueOf(flipInfo.getPage()));
        result.put("pageSize", String.valueOf(flipInfo.getSize()));
        result.put("dataCount", String.valueOf(flipInfo.getDataCount()));
        result.put("total", String.valueOf(flipInfo.getTotal()));
        result.put("toFormId", String.valueOf(toFormBean.getId()));
        if (Enums.FormType.unFlowForm.getKey() == toFormBean.getFormType()) {
            result.put("toFormType", ModuleType.cap4UnflowForm.getValue());
        } else if (Enums.FormType.processesForm.getKey() == toFormBean.getFormType()) {
            result.put("toFormType", ModuleType.collaboration.getValue());
        }
        result.put("toVersion", formRelationshipMapBean.getRelationshipBean().getTargetFormVersion());
        this.cap4FormRelationActionManager.addRelationThroughUnFlowRight(formRelationshipMapBean, "list");
    }

    private List<Map<String, Object>> getCAPManualRelationDataList(FormBean toFormBean, FormRelationshipMapBean formRelationshipMapBean, CAP4RelationQueryParamsBO cap4RelationQueryParamsBO, List<Map<String, Object>> conditions, FlipInfo flipInfo, String fromRelationAttr, int isMainSelecter) throws BusinessException {
        ArrayList<Map<String, Object>> contents = new ArrayList<Map<String, Object>>();
        FormBean fromFormBean = this.cap4FormCacheManager.getForm(formRelationshipMapBean.getRelationshipBean().getSourceFormId());
        Map relationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
        String toRelationAttr = (String)relationFieldMap.get(fromRelationAttr);
        FormFieldBean toRelationFieldBean = toFormBean.getFieldBeanByName(toRelationAttr);
        boolean isRelMasterTable = toRelationFieldBean == null ? true : toRelationFieldBean.isMasterField();
        conditions = FormSearchUtil.getUserConditions(toFormBean, conditions);
        if (isRelMasterTable) {
            this.cap4FormRelationActionManager.getFormRelationDataList(flipInfo, cap4RelationQueryParamsBO, conditions);
        } else {
            this.cap4FormRelationActionManager.getFormRelationSubDataList(flipInfo, cap4RelationQueryParamsBO, conditions);
        }
        List relationDatas = flipInfo.getData();
        List<String> mergeFieldList = this.cap4FormRelationActionManager.getRelationQueryFields(formRelationshipMapBean);
        ArrayList<String> showFieldList = new ArrayList<String>();
        HashMap<String, String> fieldNameToShowValue = new HashMap<String, String>();
        for (SimpleObjectBean temp : formRelationshipMapBean.getShowFieldList()) {
            showFieldList.add(temp.getName());
            FormFieldBean formFieldBean = toFormBean.getFieldBeanByName(temp.getName());
            if (temp.getValue() != null && temp.getValue().indexOf("(") > -1) {
                fieldNameToShowValue.put(temp.getName(), temp.getValue().substring(temp.getValue().indexOf("(") + 1, temp.getValue().indexOf(")")));
                continue;
            }
            fieldNameToShowValue.put(temp.getName(), formFieldBean.getDisplay());
        }
        HashSet<Long> masterDataIdSets = new HashSet<Long>();
        for (int i = 0; i < relationDatas.size(); ++i) {
            String dataId;
            Map relationData = (Map)relationDatas.get(i);
            String string = dataId = isRelMasterTable ? String.valueOf(relationData.get("id")) : String.valueOf(relationData.get(Enums.SubTableField.formmain_id.getKey()));
            if (!Strings.isNotBlank((String)dataId)) continue;
            masterDataIdSets.add(Long.valueOf(dataId));
        }
        Map<Long, Long> masterDataId2SummeryId = this.cap4FormRelationActionManager.getMasterIdToModuleIdAndAddRight(toFormBean.getFormType(), masterDataIdSets, formRelationshipMapBean.getListThrough() == 1 || formRelationshipMapBean.getViewThrough() == 1);
        for (int i = 0; i < relationDatas.size(); ++i) {
            Map relationData = (Map)relationDatas.get(i);
            String dataId = isRelMasterTable ? String.valueOf(relationData.get("id")) : String.valueOf(relationData.get(Enums.SubTableField.formmain_id.getKey()));
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("unique", String.valueOf(UUIDLong.longUUID()));
            HashMap mergeRecordData = new HashMap();
            for (int k = 0; k < mergeFieldList.size(); ++k) {
                String rShowField = mergeFieldList.get(k);
                FormFieldBean toFormFieldBean = toFormBean.getFieldBeanByName(rShowField);
                HashMap<String, Object> toContentValue = new HashMap<String, Object>();
                toContentValue.putAll(CAPFormUtil.getDisplayValueMap(relationData.get(rShowField), toFormFieldBean, null));
                String display = (String)fieldNameToShowValue.get(toFormFieldBean.getName());
                toContentValue.put("display", display != null ? display : toFormFieldBean.getDisplay());
                toContentValue.put("isAttach", toFormFieldBean.isAttachment() ? "1" : "0");
                mergeRecordData.put(rShowField, toContentValue);
            }
            HashMap fromKeyDatas = new HashMap();
            Iterator iteratorField = relationFieldMap.keySet().iterator();
            while (iteratorField.hasNext()) {
                String key = iteratorField.next().toString();
                if (FormRelationEnums.SpecialRelationItem.FLOW_NAME.getKey().equals(relationFieldMap.get(key))) continue;
                HashMap tempData = (HashMap)mergeRecordData.get(relationFieldMap.get(key));
                HashMap<String, String> newData = new HashMap<String, String>();
                FormFieldBean fromFieldBean = fromFormBean.getFieldBeanByName(key);
                newData.put("tableName", fromFieldBean.getOwnerTableName());
                newData.put("value", (String)tempData.get("value"));
                newData.put("showValue", (String)tempData.get("showValue"));
                newData.put("showValue2", (String)tempData.get("showValue2"));
                fromKeyDatas.put(key, newData);
            }
            content.put("showData", mergeRecordData);
            content.put("showDataList", showFieldList);
            content.put(RELATION_DATA, fromKeyDatas);
            content.put("masterId", dataId);
            content.put("isMainSelecter", String.valueOf(isMainSelecter));
            content.put("toFormId", String.valueOf(toFormBean.getId()));
            if (Enums.FormType.unFlowForm.getKey() == toFormBean.getFormType()) {
                content.put("toFormType", ModuleType.cap4UnflowForm.getValue());
            } else if (Enums.FormType.processesForm.getKey() == toFormBean.getFormType()) {
                content.put("toFormType", ModuleType.collaboration.getValue());
            }
            content.put("toVersion", formRelationshipMapBean.getRelationshipBean().getTargetFormVersion());
            content.put("fromRelationAttr", fromRelationAttr);
            if (Enums.FormType.processesForm.getKey() == toFormBean.getFormType()) {
                Long summaryId = masterDataId2SummeryId.get(Long.valueOf(dataId));
                content.put("summaryId", String.valueOf(summaryId));
                content.put("dataId", String.valueOf(summaryId));
            } else {
                content.put("dataId", dataId);
            }
            contents.add(content);
        }
        return contents;
    }

    public CAPFilterFieldManager getCapFilterFieldManager() {
        return this.capFilterFieldManager;
    }

    public void setCapFilterFieldManager(CAPFilterFieldManager capFilterFieldManager) {
        this.capFilterFieldManager = capFilterFieldManager;
    }
}

