/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.FormFlowListManager;
import com.seeyon.cap4.template.service.AbstractCAPFormBaseService;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.ctp.workflow.exception.BPMException;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPFormToCollService
extends AbstractCAPFormBaseService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormToCollService.class);
    private WorkflowApiManager wapi;
    private FormFlowListManager formFlowListManager;

    public Map<String, Object> transStepBack(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String affairId = (String)params.get("affairId");
        String isWFTrace = (String)params.get("isWFTrace");
        if (affairId == null || isWFTrace == null) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "affairId or isWFTrace"));
            return result;
        }
        Map commentMap = null;
        if (params.get("comment") != null) {
            commentMap = (Map)params.get("comment");
        }
        String doResult = this.formFlowListManager.transStepBack(Long.valueOf(affairId), commentMap, "1".equals(isWFTrace));
        return this.fastReturnQueryResult(Strings.isBlank((String)doResult), doResult, result);
    }

    public Map<String, Object> finishWorkItem(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String affairId = (String)params.get("affairId");
        String summaryId = (String)params.get("summaryId");
        if (affairId == null || summaryId == null) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "affairId or summaryId"));
            return result;
        }
        Map trackParamMap = null;
        if (params.get("trackParam") != null) {
            trackParamMap = (Map)params.get("trackParam");
        }
        Map commentMap = null;
        if (params.get("comment") != null) {
            commentMap = (Map)params.get("comment");
        }
        boolean doResult = this.formFlowListManager.finishWorkItem(Long.valueOf(affairId), Long.valueOf(summaryId), trackParamMap, commentMap);
        return this.fastReturnQueryResult(doResult, null, result);
    }

    public Map<String, Object> transRepeal(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String content = (String)params.get("content");
        String affairId = (String)params.get("affairId");
        String isWFTrace = (String)params.get("isWFTrace");
        if (Strings.isBlank((String)content) || Strings.isBlank((String)isWFTrace) || Strings.isBlank((String)affairId)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "content or affairId or isWFTrace"));
            return result;
        }
        Map<String, Object> map = this.formFlowListManager.transRepeal(Long.valueOf(affairId), content, "1".equals(isWFTrace) ? 1 : 0);
        boolean isSuccess = (Boolean)map.get("isSucess");
        return this.fastReturnQueryResult(isSuccess, String.valueOf(map.get("errorMsg")), result);
    }

    public Map<String, Object> checkTransRepeal(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String appName = (String)params.get("appName");
        String processId = (String)params.get("processId");
        if (Strings.isBlank((String)appName) || Strings.isBlank((String)processId)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "appName or processId"));
            return result;
        }
        try {
            String[] canTransRepeal = this.wapi.canRepeal(appName, processId, null);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("canTransRepeal", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getName().equalsIgnoreCase(canTransRepeal[0]) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            data.put("message", canTransRepeal[1]);
            result.put("code", "2000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", data);
        }
        catch (BPMException e) {
            LOGGER.error((Object)("CAPFormToCollService.canTransRepeal BPMException, params=" + params.toString()), (Throwable)e);
            result.put("code", "2001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
        return result;
    }

    public Map<String, Object> takeBack(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String isSaveOpinion = (String)params.get("isSaveOpinion");
        String affairId = (String)params.get("affairId");
        if (Strings.isBlank((String)isSaveOpinion) || Strings.isBlank((String)affairId)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "isSaveOpinion or affairId"));
            return result;
        }
        Map<String, Object> takeResult = this.formFlowListManager.takeBack(Long.valueOf(affairId), !"1".equals(isSaveOpinion));
        if ("1000".equals(takeResult.get("code"))) {
            takeResult.put("code", "2000");
        } else {
            takeResult.put("code", "2001");
        }
        return takeResult;
    }

    public Map<String, Object> checkTakeBack(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String appName = (String)params.get("appName");
        String processId = (String)params.get("processId");
        String activityId = (String)params.get("activityId");
        String workitemId = (String)params.get("workitemId");
        if (Strings.isBlank((String)appName) || Strings.isBlank((String)processId) || Strings.isBlank((String)activityId) || Strings.isBlank((String)workitemId)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "appName or processId or activityId or workitemId"));
            return result;
        }
        try {
            String canTakeBackResult = this.wapi.canTakeBack(appName, processId, activityId, workitemId);
            Map canTakeBackMap = (Map)JSONUtil.parseJSONString((String)canTakeBackResult, Map.class);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("canTakeBack", (Boolean)canTakeBackMap.get("canTakeBack") != false ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
            data.put("state", String.valueOf(canTakeBackMap.get("state")));
            result.put("code", "2000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", data);
        }
        catch (BPMException e) {
            LOGGER.error((Object)("CAPFormToCollService.canTakeBack BPMException, params=" + params.toString()), (Throwable)e);
            result.put("code", "2001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
        return result;
    }

    public Map<String, Object> deleteAffair(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String pageType = (String)params.get("pageType");
        List affairIds = CAPParamUtil.getParamsListByKey(params, (String)"affairIds");
        if (Strings.isBlank((String)pageType) || affairIds == null || affairIds.size() == 0) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "pageType or affairIds"));
            return result;
        }
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        Iterator iterator = affairIds.iterator();
        while (iterator.hasNext()) {
            String str;
            boolean deleteResult = this.formFlowListManager.deleteAffair(pageType, Long.valueOf(str = (String)iterator.next()));
            jsonObject.put(str, deleteResult ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        }
        result.put("code", "2000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        result.put("data", jsonObject);
        return result;
    }

    public Map<String, Object> transDoForward(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String summaryId = (String)params.get("summaryId");
        String affairId = (String)params.get("affairId");
        String forwardOriginalNote = (String)params.get("forwardOriginalNote");
        String forwardOriginalopinion = (String)params.get("forwardOriginalopinion");
        String track = (String)params.get("track");
        if (Strings.isBlank((String)summaryId) || Strings.isBlank((String)affairId) || Strings.isBlank((String)forwardOriginalNote) || Strings.isBlank((String)forwardOriginalopinion) || Strings.isBlank((String)track)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "summaryId or affairId or forwardOriginalNote or forwardOriginalopinion or track"));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("summaryId", summaryId);
        map.put("affairId", affairId);
        map.put("forwardOriginalNote", forwardOriginalNote);
        map.put("forwardOriginalopinion", forwardOriginalopinion);
        map.put("track", track);
        boolean transResult = this.formFlowListManager.transDoForward(map);
        return this.fastReturnQueryResult(transResult, null, result);
    }

    public Map<String, Object> checkForwardPermission(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String affairIds = (String)params.get("affairIds");
        if (Strings.isBlank((String)affairIds)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "affairIds"));
            return result;
        }
        List<String> checkResult = this.formFlowListManager.checkForwardPermission(affairIds);
        if (checkResult == null || checkResult.size() != 0) {
            result.put("data", checkResult);
        } else {
            result.put("data", new ArrayList());
        }
        result.put("code", "2000");
        result.put("message", "the operation is success!!!");
        return result;
    }

    public Map<String, Object> sendFromWait(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String templateId = (String)params.get("templateId");
        String dataId = (String)params.get("dataId");
        if (Strings.isBlank((String)templateId) || Strings.isBlank((String)dataId)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "templateId or dataId"));
            return result;
        }
        boolean transResult = this.formFlowListManager.transSendCollFromWait(Long.valueOf(templateId), Long.valueOf(dataId));
        return this.fastReturnQueryResult(transResult, null, result);
    }

    public Map<String, Object> transSendColl(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sendType = (String)params.get("sendType");
        String templateId = (String)params.get("templateId");
        String formMasterId = (String)params.get("formMasterId");
        String parentSummaryId = (String)params.get("parentSummaryId");
        if (Strings.isBlank((String)sendType) || Strings.isBlank((String)templateId) || Strings.isBlank((String)formMasterId)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "sendType or templateId or formMasterId"));
            return result;
        }
        boolean transResult = this.formFlowListManager.transSendColl(sendType, Long.valueOf(templateId), Long.valueOf(formMasterId), Strings.isBlank((String)parentSummaryId) ? null : Long.valueOf(parentSummaryId), null);
        return this.fastReturnQueryResult(transResult, null, result);
    }

    private Map<String, Object> fastReturnQueryResult(boolean isSuccess, String message, Map<String, Object> result) {
        if (result == null) {
            result = new HashMap<String, Object>();
        }
        if (isSuccess) {
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("code", "2000");
        } else {
            result.put("message", message == null ? ResourceUtil.getString((String)"cap.template.message.exception") : message);
            result.put("code", "2001");
        }
        return result;
    }

    public void setWapi(WorkflowApiManager wapi) {
        this.wapi = wapi;
    }

    public void setFormFlowListManager(FormFlowListManager formFlowListManager) {
        this.formFlowListManager = formFlowListManager;
    }
}

