/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.util.StringUtils;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.bean.UnFlowFormDeleteFormDataParamBean;
import com.seeyon.cap4.template.bean.UnFlowFormSetLockOrUnlockParamBean;
import com.seeyon.cap4.template.bean.ValidListButtonParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.exception.FormDataNoAuthBusinessException;
import com.seeyon.cap4.template.manager.CAPDataListManager;
import com.seeyon.cap4.template.manager.CAPDataListSqlHelpManager;
import com.seeyon.cap4.template.manager.CAPUnFlowButtonManager;
import com.seeyon.cap4.template.manager.CAPUnFlowManager;
import com.seeyon.cap4.template.result.FormDataResult;
import com.seeyon.cap4.template.service.AbstractCAPFormBaseService;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.vo.UnFlowFormListVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.SQLWildcardUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;

public class CAPFormToUnflowService
extends AbstractCAPFormBaseService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormToUnflowService.class);
    private static final String LOCK = "lock";
    private static final String DATA_IDS = "dataIds";
    private static final String PAGE = "page";
    private static final String PAGE_SIZE = "pageSize";
    private static final String TOTAL = "total";
    private static final String INPUT_TYPE = "inputType";
    private static final String FIELD_TYPE = "fieldType";
    private static final String AUTH = "auth";
    private static final String DATAS = "datas";
    private static final String USER_ORDERBY = "userOrderBy";
    private static final String USER_CONDITIONS = "userConditions";
    private static final String DATA_CONDITIONS = "dataConditions";
    private static final String FIELD_NAME = "fieldName";
    private static final String AVG = "avg";
    private static final String SUM = "sum";
    private static final String COUNT = "count";
    private static final String DISPLAY = "display";
    private static final String VALUE = "value";
    private EnumManager enumManagerNew;
    private CAPUnFlowManager capUnFlowManager;
    private CAPDataListSqlHelpManager capDataListSqlHelpManager;
    private CAPUnFlowButtonManager capUnFlowButtonManager;

    private Map<String, Object> getResult(String code, String msg) {
        HashMap map = Maps.newHashMap();
        map.put("code", code);
        map.put("message", msg);
        return map;
    }

    @Deprecated
    public Map<String, Object> getCAPFormUnFlowList(FormDataListParamBean paramBean) {
        try {
            Long formId = paramBean.getFormId();
            Long formTemplateId = paramBean.getFormTemplateId();
            if (!this.cap4FormManager.checkRight(Enums.FormModuleAuthModuleType.BindAppForm, formTemplateId, AppContext.currentUserId(), formId)) {
                return this.getResult("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
            }
            UnFlowFormListVO unFlowFormListVO = new UnFlowFormListVO();
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById(formTemplateId);
            List searchFields = bindAuthBean.getSearchFieldList();
            unFlowFormListVO.setFilterFields(CAPFormUtil.getFilterFields(formBean, searchFields));
            Enums.ViewType viewType = paramBean.getViewType();
            List toolbarButtons = bindAuthBean.getAllBtnListByBtnOrder(viewType, FormBindAuthBean.ShowPosition.ToolBar);
            List dataRowButtons = bindAuthBean.getAllBtnListByBtnOrder(viewType, FormBindAuthBean.ShowPosition.DataRow);
            Map<String, List<Map<String, Object>>> buttons = unFlowFormListVO.getButtons();
            buttons.put(FormBindAuthBean.ShowPosition.ToolBar.getKey(), this.capUnFlowButtonManager.getListButtons(Map.class, formBean, bindAuthBean, toolbarButtons, viewType, FormBindAuthBean.ShowPosition.ToolBar));
            buttons.put(FormBindAuthBean.ShowPosition.DataRow.getKey(), this.capUnFlowButtonManager.getListButtons(Map.class, formBean, bindAuthBean, dataRowButtons, viewType, FormBindAuthBean.ShowPosition.DataRow));
            ArrayList fields = Lists.newArrayList();
            String auth = FormUtil.getUnflowFormAuth((FormBean)formBean, (String)formTemplateId.toString());
            for (SimpleObjectBean simpleObjectBean : bindAuthBean.getShowFieldList()) {
                HashMap field = Maps.newHashMap();
                FormFieldBean formFieldBean = FormSearchUtil.getFormFieldBean(formBean, simpleObjectBean);
                if (formFieldBean.isAttachment()) continue;
                Object display = formFieldBean.getDisplay();
                String value = simpleObjectBean.getValue();
                if (value != null && !org.apache.commons.lang3.StringUtils.equals((CharSequence)display, (CharSequence)value) && value.indexOf("(") > -1) {
                    display = value.substring(value.indexOf("(") + 1, value.indexOf(")"));
                }
                field.put(FIELD_NAME, formFieldBean.getName());
                field.put(DISPLAY, display);
                field.put(INPUT_TYPE, formFieldBean.getInputType());
                field.put(FIELD_TYPE, formFieldBean.getFieldType());
                String filedAuth = Enums.FieldAccessType.edit.getKey();
                Enums.MasterTableField masterTableField = Enums.MasterTableField.getEnumByKey((String)formFieldBean.getName());
                if (masterTableField == null) {
                    filedAuth = FormUtil.getFieldAnthString((FormBean)formBean, (FormFieldBean)formFieldBean, (String)auth);
                }
                field.put(AUTH, filedAuth);
                fields.add(field);
            }
            unFlowFormListVO.setFields(fields);
            HashMap queryParam = Maps.newHashMap();
            queryParam.put("formId", paramBean.getFormId().toString());
            queryParam.put("formTemplateId", paramBean.getFormTemplateId().toString());
            if (paramBean.getUserOrderBy() != null) {
                queryParam.put(USER_ORDERBY, paramBean.getUserOrderBy());
            }
            if (paramBean.getUserConditions() == null) {
                queryParam.put(USER_CONDITIONS, FormSearchUtil.getFilterFieldsDefaultCondition(formBean, bindAuthBean.getSearchFieldList()));
            } else {
                queryParam.put(USER_CONDITIONS, FormSearchUtil.getUserConditions(formBean, paramBean.getUserConditions()));
            }
            queryParam.put(DATA_CONDITIONS, paramBean.getDataConditions());
            FlipInfo fi = this.cap4FormDataManager.getFormMasterDataListByFormId(paramBean.getFlipInfo(), queryParam, false);
            List fiData = fi.getData();
            ArrayList data = Lists.newArrayListWithCapacity((int)fiData.size());
            for (Map map : fiData) {
                HashMap entity = Maps.newHashMap();
                entity.put(Enums.MasterTableField.id.getKey(), MapUtils.getString((Map)map, (Object)Enums.MasterTableField.id.getKey()));
                entity.put(Enums.MasterTableField.state.getKey(), MapUtils.getString((Map)map, (Object)Enums.MasterTableField.state.getKey()));
                for (Map field : fields) {
                    HashMap fieldData = Maps.newHashMap();
                    String fieldName = MapUtils.getString((Map)field, (Object)FIELD_NAME);
                    Object fieldValue = map.get(fieldName);
                    if (fieldValue != null) {
                        CtpEnumItem enumItem;
                        FormFieldBean formFieldBean;
                        if (!"*".equals(fieldValue) && (formFieldBean = formBean.getFieldBeanByName(fieldName, true)).isImageEnumField() && (enumItem = this.enumManagerNew.getCtpEnumItem(Long.valueOf(Long.parseLong(fieldValue.toString())))) != null && enumItem.getImageId() != null) {
                            fieldValue = SystemEnvironment.getContextPath() + "/fileUpload.do?method=showRTE&fileId=" + enumItem.getImageId() + "&type=image" + Functions.csrfSuffix();
                        }
                    } else {
                        fieldValue = "";
                    }
                    fieldData.put(VALUE, fieldValue);
                    entity.put(fieldName, fieldData);
                }
                data.add(entity);
            }
            unFlowFormListVO.setDatas(data);
            unFlowFormListVO.setPage(String.valueOf(fi.getPage()));
            unFlowFormListVO.setPageSize(String.valueOf(fi.getSize()));
            unFlowFormListVO.setTotal(String.valueOf(fi.getTotal()));
            unFlowFormListVO.setFormId(paramBean.getFormId().toString());
            unFlowFormListVO.setFormTemplateId(paramBean.getFormTemplateId().toString());
            unFlowFormListVO.setName(bindAuthBean.getName());
            Map<String, Object> result = this.getResult("2000", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", unFlowFormListVO);
            return result;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("\u83b7\u53d6\u65e0\u6d41\u7a0b\u5217\u8868\u5f02\u5e38, paramBean=" + JSONUtil.toJSONString((Object)paramBean) + ":"), (Throwable)e);
            return this.getResult("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
    }

    @ValidateRequestParam(notEmpty={"formId", "formTemplateId", "position", "type"})
    public FormDataResult checkButton(ValidListButtonParamBean paramBean) {
        FormDataResult result = new FormDataResult();
        try {
            CAPBusinessEnum.DataListTypeEnum typeEnum = CAPBusinessEnum.DataListTypeEnum.getEnumByKey(paramBean.getListType(), "key");
            if (typeEnum == null) {
                throw new FormDataNoAuthBusinessException();
            }
            boolean isValid = false;
            Map map = AppContext.getBeansOfType(CAPDataListManager.class);
            for (Map.Entry entry : map.entrySet()) {
                if (!typeEnum.equals((Object)((CAPDataListManager)entry.getValue()).getListType())) continue;
                isValid = ((CAPDataListManager)entry.getValue()).checkButton(paramBean);
                break;
            }
            if (!isValid) {
                throw new FormDataNoAuthBusinessException();
            }
            result.success();
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("\u5217\u8868\u8868\u5355\u2014\u2014\u6821\u9a8c\u6309\u94ae\u51fa\u9519\uff0c\u53c2\u6570:" + JSONUtil.toJSONString((Object)paramBean)), (Throwable)e);
            result.exception((Exception)((Object)e));
        }
        return result;
    }

    public Map<String, Object> delFormData(UnFlowFormDeleteFormDataParamBean paramBean) {
        try {
            String dataLog;
            List<Map> lockState = this.cap4FormManager.getLockState(paramBean.getFormId(), paramBean.getDataIds());
            ArrayList canDeleteIds = Lists.newArrayList();
            for (Map map : lockState) {
                int state = MapUtils.getIntValue((Map)map, (Object)Enums.MasterTableField.state.getKey());
                if (state == Enums.FormDataStateEnum.UNFLOW_LOCKED.getKey()) continue;
                canDeleteIds.add(MapUtils.getLong((Map)map, (Object)Enums.MasterTableField.id.getKey()));
            }
            if (CollectionUtils.isEmpty((Collection)canDeleteIds)) {
                return this.getResult("2008", ResourceUtil.getString((String)"cap.template.form.data.message.dataLock"));
            }
            String deleteIds = org.apache.commons.lang3.StringUtils.join((Iterable)canDeleteIds, (String)",");
            String checkDataLock = this.cap4FormManager.checkDataLock(deleteIds);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)checkDataLock)) {
                return this.getResult("2009", ResourceUtil.getString((String)"cap.template.form.data.message.dataEditLock"));
            }
            Long formId = paramBean.getFormId();
            Long dataId = (Long)canDeleteIds.get(0);
            FormBean formBean = this.cap4FormManager.getForm(formId, false);
            Long startMemberId = AppContext.currentUserId();
            Date startDate = new Date();
            if (canDeleteIds.size() == 1) {
                FormDataMasterBean formDataMasterBean = this.cap4FormManager.getDataMasterBeanById(dataId, formBean, null);
                startMemberId = formDataMasterBean.getStartMemberId();
                startDate = formDataMasterBean.getStartDate();
                dataLog = ResourceUtil.getString((String)"cap.form.unFlow.list.deleteLog", (Object)formBean.getFormName()) + this.capRunningLogManager.getDeleteLog(formBean, formDataMasterBean);
            } else {
                dataLog = ResourceUtil.getString((String)"cap.form.unFlow.list.deleteMultipleLog", (Object)formBean.getFormName(), (Object)canDeleteIds.size());
            }
            this.cap4FormManager.delFormData(paramBean.getFormId(), deleteIds, paramBean.getFormTemplateId());
            this.saveRunningLog(formBean, dataId, Enums.CapLogType.DELETE, dataLog, startMemberId, startDate);
            return this.getResult("2000", ResourceUtil.getString((String)"cap.template.message.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u65e0\u6d41\u7a0b\u8868\u5355\u2014\u2014\u5220\u9664\u6570\u636e\uff0c\u53c2\u6570:" + JSONUtil.toJSONString((Object)paramBean)), (Throwable)e);
            return this.getResult("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
    }

    @Deprecated
    public Map<String, Object> setLockOrUnlock(UnFlowFormSetLockOrUnlockParamBean paramBean) {
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)paramBean.getOperation(), (CharSequence)LOCK) ? this.lockData(paramBean) : this.unLockData(paramBean);
    }

    public Map<String, Object> lockData(UnFlowFormSetLockOrUnlockParamBean paramBean) {
        try {
            CheckDataLockResult checkDataLockResult = this.checkDataLock(paramBean.getDataIdsWithLong());
            if (!checkDataLockResult.isSuccess()) {
                return checkDataLockResult.getResult();
            }
            String lockMsg = this.cap4FormDataManager.setLock(paramBean.getFormId(), paramBean.getDataIds(), paramBean.getFormTemplateId());
            FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            String dataLog = ResourceUtil.getString((String)"cap.form.unFlow.list.lockLog", (Object)formBean.getFormName(), (Object)paramBean.getDataIdsLength());
            this.saveRunningLog(formBean, null, Enums.CapLogType.LOCK, dataLog, AppContext.currentUserId(), new Date());
            Map<String, Object> result = this.getResult("2000", ResourceUtil.getString((String)"cap.template.message.success"));
            HashMap data = Maps.newHashMap();
            CAPBusinessEnum.TrueOrFalseEnum lockFlag = CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(lockMsg) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE : CAPBusinessEnum.TrueOrFalseEnum.FALSE;
            data.put("lockResult", lockFlag.getKey());
            result.put("data", data);
            return result;
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u65e0\u6d41\u7a0b\u8868\u5355\u2014\u2014\u6570\u636e\u52a0\u9501\u51fa\u9519\uff0c\u53c2\u6570\u4e3a\uff1a" + JSONUtil.toJSONString((Object)paramBean)), (Throwable)e);
            return this.getResult("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
    }

    public Map<String, Object> unLockData(UnFlowFormSetLockOrUnlockParamBean paramBean) {
        try {
            CheckDataLockResult checkDataLockResult = this.checkDataLock(paramBean.getDataIdsWithLong());
            if (!checkDataLockResult.isSuccess()) {
                return checkDataLockResult.getResult();
            }
            boolean unLock = this.cap4FormDataManager.unLock(paramBean.getFormId(), paramBean.getDataIds(), paramBean.getFormTemplateId());
            FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            String dataLog = ResourceUtil.getString((String)"cap.form.unFlow.list.unlockLog", (Object)formBean.getFormName(), (Object)paramBean.getDataIdsLength());
            this.saveRunningLog(formBean, null, Enums.CapLogType.UNLOCK, dataLog, AppContext.currentUserId(), new Date());
            Map<String, Object> result = this.getResult("2000", ResourceUtil.getString((String)"cap.template.message.success"));
            HashMap data = Maps.newHashMap();
            CAPBusinessEnum.TrueOrFalseEnum lockFlag = unLock ? CAPBusinessEnum.TrueOrFalseEnum.TRUE : CAPBusinessEnum.TrueOrFalseEnum.FALSE;
            data.put("unlockResult", lockFlag.getKey());
            result.put("data", data);
            return result;
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u65e0\u6d41\u7a0b\u8868\u5355\u2014\u2014\u6570\u636e\u89e3\u9501\u51fa\u9519\uff0c\u53c2\u6570\u4e3a\uff1a" + JSONUtil.toJSONString((Object)paramBean)), (Throwable)e);
            return this.getResult("2001", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
    }

    private void saveRunningLog(FormBean formBean, Long dataId, Enums.CapLogType capLogType, String dataLog, Long startMemberId, Date startDate) throws BusinessException {
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formBean.getId());
        Long bizId = bizConfigBean != null ? bizConfigBean.getId() : null;
        String bizName = bizConfigBean != null ? bizConfigBean.getName() : null;
        this.capRunningLogManager.saveRunningLog(bizId, bizName, formBean.getId(), formBean.getFormName(), dataId, capLogType.getKey(), dataLog, AppContext.currentUserId(), startMemberId, startDate, AppContext.currentAccountName(), AppContext.getRemoteAddr());
    }

    @Deprecated
    public Map<String, Object> validUnflowOperation(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "2000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        String formId = (String)params.get("formId");
        String formTemplateId = (String)params.get("formTemplateId");
        String type = (String)params.get("operation");
        String rightId = (String)params.get("rightId");
        if (Strings.isBlank((String)formId) || Strings.isBlank((String)formTemplateId) || Strings.isBlank((String)type)) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "formTemplateId or formId or operation"));
            return result;
        }
        FormBindAuthBean.AuthName authName = FormBindAuthBean.AuthName.getEnumByKey((String)type);
        try {
            String validStr = this.cap4FormManager.validUnflowOperation(Long.valueOf(formId), formTemplateId, rightId, authName.getKey());
            if (Strings.isNotBlank((String)validStr)) {
                result.put("code", "2006");
                result.put("message", validStr);
                return result;
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"validUnflowOperation.error is ", (Throwable)e);
            result.put("code", "2001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
        return result;
    }

    private boolean checkEditLock(String[] dataIds, Map<String, Object> result) throws BusinessException {
        boolean pass = true;
        HashMap<String, String> idToMessage = new HashMap<String, String>();
        for (int i = 0; i < dataIds.length; ++i) {
            String checkDataLockForEdit = this.cap4FormManager.checkDataLockFormEdit(dataIds[i], true, true);
            if (!Strings.isNotBlank((String)checkDataLockForEdit)) continue;
            idToMessage.put(dataIds[i], checkDataLockForEdit);
            result.put("code", "2009");
            result.put("message", checkDataLockForEdit);
            result.put("data", idToMessage);
            pass = false;
            break;
        }
        return pass;
    }

    private CheckDataLockResult checkDataLock(List<Long> dataIds) throws BusinessException {
        for (Long dataId : dataIds) {
            String checkMsg = this.cap4FormManager.checkDataLockFormEdit(dataId.toString(), true, true);
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)checkMsg)) continue;
            CheckDataLockResult checkDataLockResult = new CheckDataLockResult();
            Map<String, Object> result = this.getResult("2009", checkMsg);
            HashMap data = Maps.newHashMap();
            data.put(dataId.toString(), checkMsg);
            result.put("data", data);
            checkDataLockResult.setResult(result);
            return checkDataLockResult;
        }
        return CheckDataLockResult.successResult();
    }

    @Deprecated
    public Map<String, Object> checkLock(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "2000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        String formId = (String)params.get("formId");
        List dataIds = CAPParamUtil.getParamsListByKey(params, (String)DATA_IDS);
        if (Strings.isBlank((String)formId) || dataIds == null || dataIds.isEmpty()) {
            result.put("code", "2004");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "formId or dataIds"));
            return result;
        }
        String contentDataIdStr = org.apache.commons.lang3.StringUtils.join((Object[])dataIds.toArray(), (String)",");
        try {
            boolean checkDelete = this.cap4FormManager.checkDelete(Long.valueOf(formId), contentDataIdStr);
            if (!checkDelete) {
                result.put("code", "2011");
                result.put("message", ResourceUtil.getString((String)"cap.template.form.data.message.delete"));
                return result;
            }
            if (!this.checkEditLock(dataIds.toArray(new String[dataIds.size()]), result)) {
                return result;
            }
            boolean checkLock = this.cap4FormManager.checkLock(Long.valueOf(formId), contentDataIdStr);
            if (checkLock) {
                result.put("code", "2008");
                result.put("message", ResourceUtil.getString((String)"cap.template.form.data.message.dataLock"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            result.put("code", "2001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"formId", "formTemplateId", "fieldName"})
    public Map<String, Object> getFieldCalcData(FormDataListParamBean paramBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "2000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        HashMap<String, Object> data = new HashMap<String, Object>();
        result.put("data", data);
        try {
            if (this.cap4FormManager.checkRight(Enums.FormModuleAuthModuleType.BindAppForm, paramBean.getFormTemplateId(), AppContext.currentUserId(), paramBean.getFormId())) {
                FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
                FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(paramBean.getFormTemplateId().toString());
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(paramBean.getFieldName(), true);
                FormFieldComEnum formFieldComEnum = formFieldBean.getInputTypeEnum();
                switch (formFieldComEnum) {
                    case TEXT: {
                        if (Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType())) {
                            data.putAll(this.getNumberFieldCalcData(formBean, formBindAuthBean, formFieldBean, paramBean));
                            break;
                        }
                        data.put(COUNT, this.getFieldCountData(formBean, formBindAuthBean, formFieldBean, paramBean));
                        break;
                    }
                    default: {
                        data.put(COUNT, this.getFieldCountData(formBean, formBindAuthBean, formFieldBean, paramBean));
                        break;
                    }
                }
            } else {
                result.put("code", "2006");
                result.put("message", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
            }
        }
        catch (BusinessException e) {
            result.put("code", "2001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.exception"));
            LOGGER.error((Object)("getFieldCalcData.BusinessException params:" + paramBean.toString()), (Throwable)e);
        }
        return result;
    }

    private Map<String, Object> getNumberFieldCalcData(FormBean formBean, FormBindAuthBean formBindAuthBean, FormFieldBean formFieldBean, FormDataListParamBean paramBean) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SUM, "0");
        result.put(AVG, "0");
        result.put(COUNT, "0");
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        FormQueryWhereClause querySqlClause = this.getAllConditionWhereClause(formBean, formBindAuthBean, formFieldBean, paramBean);
        String whereClause = querySqlClause.getAllSqlClause();
        String tableName = formFieldBean.getOwnerTableName();
        String fieldName = tableName + "." + formFieldBean.getName();
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT SUM(").append(fieldName).append(") ").append(SUM).append(", AVG(").append(fieldName).append(") ").append(AVG).append(", COUNT(").append(fieldName).append(") ").append(COUNT).append(" FROM ").append(masterTableBean.getTableName()).append(" ").append(masterTableBean.getTableName()).append(" ");
        sqlSb.append(this.capDataListSqlHelpManager.getSQLFrom(formBean, sqlSb, whereClause));
        sqlSb.append(this.getWhereSql(formBean, whereClause, formFieldBean, fieldName, false));
        querySqlClause.setAllSqlClause(sqlSb.toString());
        List<Map> dataMaps = this.cap4FormDataDAO.selectDataBySql(querySqlClause.getAllSqlClause(), querySqlClause.getQueryParams());
        if (dataMaps != null && result.size() >= 1) {
            Map map = dataMaps.get(0);
            String auth = FormUtil.getUnflowFormAuth((FormBean)formBean, (String)String.valueOf(formBindAuthBean.getId()));
            ArrayList formDataList = new ArrayList();
            HashMap dataMap = new HashMap();
            formDataList.add(dataMap);
            Object sumObj = map.get(SUM);
            if (sumObj != null) {
                dataMap.put(formFieldBean.getName(), sumObj);
                List resultList = FormUtil.setShowValueList((FormBean)formBean, (String)auth, formDataList, (boolean)false, (boolean)false, (boolean)false);
                result.put(SUM, String.valueOf(((Map)resultList.get(0)).get(formFieldBean.getName())));
            } else {
                result.put(SUM, "0");
            }
            Object avgObj = map.get(AVG);
            if (avgObj != null) {
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(avgObj));
                String digitNum = formFieldBean.getDigitNum();
                bigDecimal.setScale(digitNum == null || "0".equals(digitNum) ? 2 : Integer.valueOf(digitNum), 4);
                dataMap.put(formFieldBean.getName(), avgObj);
                List resultList = FormUtil.setShowValueList((FormBean)formBean, (String)auth, formDataList, (boolean)false, (boolean)false, (boolean)true);
                result.put(AVG, String.valueOf(((Map)resultList.get(0)).get(formFieldBean.getName())));
            } else {
                result.put(AVG, "0");
            }
            result.put(COUNT, String.valueOf(map.get(COUNT) == null ? "0" : map.get(COUNT)));
        }
        return result;
    }

    private String getFieldCountData(FormBean formBean, FormBindAuthBean formBindAuthBean, FormFieldBean formFieldBean, FormDataListParamBean paramBean) throws BusinessException {
        String count = "0";
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        FormQueryWhereClause querySqlClause = this.getAllConditionWhereClause(formBean, formBindAuthBean, formFieldBean, paramBean);
        String whereClause = querySqlClause.getAllSqlClause();
        String tableName = formFieldBean.getOwnerTableName();
        String fieldName = tableName + "." + formFieldBean.getName();
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT COUNT(").append(fieldName).append(") ").append(COUNT).append(" FROM ").append(masterTableBean.getTableName()).append(" ").append(masterTableBean.getTableName()).append(" ");
        sqlSb.append(this.capDataListSqlHelpManager.getSQLFrom(formBean, sqlSb, whereClause));
        sqlSb.append(this.getWhereSql(formBean, whereClause, formFieldBean, fieldName, false));
        querySqlClause.setAllSqlClause(sqlSb.toString());
        List<Map> dataMaps = this.cap4FormDataDAO.selectDataBySql(querySqlClause.getAllSqlClause(), querySqlClause.getQueryParams());
        if (dataMaps != null && dataMaps.size() >= 1) {
            count = String.valueOf(dataMaps.get(0).get(COUNT));
        }
        return count;
    }

    @ValidateRequestParam(notEmpty={"formId", "formTemplateId", "fieldName"})
    public Map<String, Object> getFieldDataList(FormDataListParamBean paramBean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "2000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        try {
            FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(paramBean.getFieldName(), true);
            if (formFieldBean == null) {
                result.put("code", "2004");
                result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), paramBean.getFieldName()));
                return result;
            }
            FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(paramBean.getFormTemplateId().toString());
            FormQueryWhereClause querySqlClause = this.getAllConditionWhereClause(formBean, formBindAuthBean, formFieldBean, paramBean);
            String whereClause = querySqlClause.getAllSqlClause();
            StringBuilder sql = new StringBuilder();
            String fieldName = formFieldBean.getOwnerTableName() + "." + formFieldBean.getName();
            FormTableBean masterTableBean = formBean.getMasterTableBean();
            ArrayList<String> selectFieldList = new ArrayList<String>();
            selectFieldList.add("MAX(" + masterTableBean.getTableName() + ".id) id");
            List<Map<String, Object>> userOrderBy = paramBean.getUserOrderBy();
            if (Strings.isNotEmpty(userOrderBy)) {
                for (int i = 0; i < userOrderBy.size(); ++i) {
                    StringBuilder fieldSb = new StringBuilder();
                    Map<String, Object> orderBy = userOrderBy.get(i);
                    String orderField = String.valueOf(orderBy.get(FIELD_NAME));
                    if (orderField != null && orderField.equals(formFieldBean.getName())) {
                        selectFieldList.add(fieldName);
                        continue;
                    }
                    FormFieldBean fieldBean = formBean.getFieldBeanByName(orderField, true);
                    selectFieldList.add(fieldSb.append("MAX(").append(fieldBean.getOwnerTableName()).append(".").append(fieldBean.getName()).append(") ").append(fieldBean.getName()).toString());
                }
            } else {
                userOrderBy = new ArrayList<Map<String, Object>>();
                List orderList = formBindAuthBean.getOrderByList();
                for (int i = 0; i < orderList.size(); ++i) {
                    SimpleObjectBean simpleObjectBean = (SimpleObjectBean)orderList.get(i);
                    String orderType = simpleObjectBean.getValue();
                    String name = simpleObjectBean.getName();
                    if (name.contains(".")) {
                        name = name.split("[.]")[1];
                    }
                    FormFieldBean fieldBean = formBean.getFieldBeanByName(name, true);
                    StringBuilder fieldSb = new StringBuilder();
                    if (fieldName.equals(simpleObjectBean.getName())) {
                        selectFieldList.add(fieldName);
                    } else {
                        selectFieldList.add(fieldSb.append("MAX(").append(fieldBean.getOwnerTableName()).append(".").append(fieldBean.getName()).append(") ").append(fieldBean.getName()).toString());
                    }
                    HashMap<String, String> orderMap = new HashMap<String, String>();
                    orderMap.put(FIELD_NAME, name);
                    orderMap.put("orderType", orderType);
                    userOrderBy.add(orderMap);
                }
            }
            boolean isAddStartDateField = true;
            boolean isAddCurrendField = true;
            for (String selectField : selectFieldList) {
                if (selectField.contains("start_date")) {
                    isAddStartDateField = false;
                }
                if (!selectField.contains(fieldName)) continue;
                isAddCurrendField = false;
            }
            if (isAddStartDateField) {
                selectFieldList.add("MAX(" + masterTableBean.getTableName() + ".start_date) start_date");
            }
            if (isAddCurrendField && fieldName != null && !fieldName.endsWith("start_date")) {
                selectFieldList.add(fieldName);
            }
            String[] selectFields = new String[selectFieldList.size()];
            String selectFieldString = StringUtils.arrayToString((String[])selectFieldList.toArray(selectFields));
            sql.append(" SELECT ").append(selectFieldString).append(" FROM ").append(masterTableBean.getTableName()).append(" ").append(masterTableBean.getTableName()).append(" ");
            sql.append(this.capDataListSqlHelpManager.getSQLFrom(formBean, sql, whereClause));
            sql.append(this.getWhereSql(formBean, whereClause, formFieldBean, fieldName, false));
            this.cap4FormDataManager.getCustomOrderByString(userOrderBy, querySqlClause, false, null);
            sql.append(" GROUP BY ").append(fieldName);
            sql.append(" ORDER BY ").append(querySqlClause.getOrderByClause());
            querySqlClause.setAllSqlClause(sql.toString());
            boolean hasNull = false;
            StringBuilder hasNullSql = new StringBuilder();
            hasNullSql.append("SELECT COUNT(0) count FROM ").append(masterTableBean.getTableName()).append(" ").append(masterTableBean.getTableName()).append(" ");
            hasNullSql.append(this.capDataListSqlHelpManager.getSQLFrom(formBean, hasNullSql, whereClause));
            String whereSql = this.getWhereSql(formBean, whereClause, formFieldBean, fieldName, true);
            if (Strings.isBlank((String)whereSql)) {
                hasNullSql.append(" WHERE (").append(formFieldBean.getOwnerTableName()).append(".").append(formFieldBean.getName()).append(" IS NULL ");
                if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(formFieldBean.getFieldType()) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(formFieldBean.getFieldType())) {
                    hasNullSql.append(" OR ").append(fieldName).append(" = '' ");
                }
                hasNullSql.append(")");
            } else {
                hasNullSql.append(" WHERE 1 = 1 ").append(whereClause);
                hasNullSql.append(" AND (").append(formFieldBean.getOwnerTableName()).append(".").append(formFieldBean.getName()).append(" IS NULL ");
                if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(formFieldBean.getFieldType()) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(formFieldBean.getFieldType())) {
                    hasNullSql.append(" OR ").append(fieldName).append(" = '' ");
                }
                hasNullSql.append(")");
            }
            FlipInfo hasNullFlipInfo = new FlipInfo();
            this.cap4FormDataDAO.selectDataBySql(hasNullSql.toString(), querySqlClause.getQueryParams(), hasNullFlipInfo);
            List hasNullResoult = hasNullFlipInfo.getData();
            if (hasNullResoult.size() > 0 && Long.parseLong(String.valueOf(((Map)hasNullResoult.get(0)).get(COUNT))) > 0L) {
                hasNull = true;
            }
            int page = paramBean.getPage();
            int pageSize = paramBean.getPageSize();
            pageSize = hasNull && page == 1 ? pageSize - 1 : pageSize;
            FlipInfo flipInfo = new FlipInfo(page, pageSize);
            this.cap4FormDataDAO.selectDataBySql(querySqlClause.getAllSqlClause(), querySqlClause.getQueryParams(), flipInfo);
            List dataMaps = new ArrayList();
            if (page <= flipInfo.getPage()) {
                dataMaps = flipInfo.getData();
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            ArrayList datas = new ArrayList();
            data.put(PAGE, page);
            data.put(PAGE_SIZE, pageSize);
            data.put(TOTAL, String.valueOf(hasNull ? flipInfo.getTotal() + 1 : flipInfo.getTotal()));
            data.put(DATAS, datas);
            String rightStr = FormUtil.getUnflowFormAuth((FormBean)formBean, (String)paramBean.getFormTemplateId().toString());
            List showFieldDatas = FormUtil.setShowValueList((FormBean)formBean, (String)rightStr, dataMaps, (boolean)false, (boolean)true, (boolean)false);
            int j = dataMaps.size();
            for (int i = 0; i < j; ++i) {
                Map lineValues = (Map)dataMaps.get(i);
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put(VALUE, String.valueOf(lineValues.get(formFieldBean.getName())));
                dataMap.put("showValue", String.valueOf(((Map)showFieldDatas.get(i)).get(formFieldBean.getName())));
                datas.add(dataMap);
            }
            if (hasNull && page == 1) {
                HashMap<String, String> nullMap = new HashMap<String, String>();
                nullMap.put(VALUE, "");
                nullMap.put("showValue", ResourceUtil.getString((String)"cap.form.unFlow.list.nullValue"));
                datas.add(0, nullMap);
            }
            result.put("data", data);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"getFieldDataList.error is ", (Throwable)e);
            result.put("code", "2001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.exception"));
        }
        return result;
    }

    private String getWhereSql(FormBean formBean, String whereClause, FormFieldBean formFieldBean, String fieldName, boolean hasNull) {
        StringBuilder whereSql = new StringBuilder();
        if (Strings.isNotBlank((String)whereClause)) {
            whereSql.append(" WHERE 1 = 1 ").append(whereClause);
            if (!hasNull) {
                whereSql.append(" AND (").append(formFieldBean.getOwnerTableName()).append(".").append(formFieldBean.getName()).append(" IS NOT NULL ");
                if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(formFieldBean.getFieldType()) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(formFieldBean.getFieldType())) {
                    whereSql.append(" OR ").append(fieldName).append(" <> '' ");
                }
                whereSql.append(")");
            }
        } else if (!hasNull) {
            whereSql.append(" WHERE (").append(formFieldBean.getOwnerTableName()).append(".").append(formFieldBean.getName()).append(" IS NOT NULL ");
            if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(formFieldBean.getFieldType()) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(formFieldBean.getFieldType())) {
                whereSql.append(" OR ").append(fieldName).append(" <> '' ");
            }
            whereSql.append(")");
        }
        List subTables = formBean.getSubTableBean();
        StringBuffer subTablewhereSb = new StringBuffer();
        for (int i = 0; i < subTables.size(); ++i) {
            if (whereSql.indexOf(((FormTableBean)subTables.get(i)).getTableName()) == -1 || subTablewhereSb.indexOf(((FormTableBean)subTables.get(i)).getTableName()) != -1) continue;
            subTablewhereSb.append(" (").append(((FormTableBean)subTables.get(i)).getTableName()).append(".").append(Enums.SubTableField.formmain_id.getKey()).append("=").append(formBean.getMasterTableBean().getTableName()).append(".").append(Enums.MasterTableField.id.getKey()).append(") ");
            subTablewhereSb.append(" and ");
        }
        int andIndex = subTablewhereSb.lastIndexOf("and ");
        if (andIndex != -1) {
            subTablewhereSb = subTablewhereSb.replace(andIndex, andIndex + "and ".length(), "");
        }
        if (Strings.isNotBlank((String)subTablewhereSb.toString().trim())) {
            whereSql.append(" and ").append(subTablewhereSb).toString();
        }
        return whereSql.toString();
    }

    private FormQueryWhereClause getAllConditionWhereClause(FormBean formBean, FormBindAuthBean formBindAuthBean, FormFieldBean formFieldBean, FormDataListParamBean paramBean) throws BusinessException {
        String dataSearchCondition = paramBean.getDataSearchCondition();
        FormQueryWhereClause dataSearchConditionWhereCaluse = null;
        if (dataSearchCondition != null && !"".equalsIgnoreCase(dataSearchCondition)) {
            dataSearchConditionWhereCaluse = this.getFieldDataSearchConditionFormQueryWhereClause(formBean, formFieldBean.getName(), dataSearchCondition, true);
        }
        FormQueryWhereClause dataConditionWhereCause = this.cap4FormDataManager.getFieldDataConditionFormQueryWhereClause(formBean, paramBean.getDataConditions(), true);
        List<Map<String, Object>> userConditions = paramBean.getUserConditions() == null ? FormSearchUtil.getFilterFieldsDefaultCondition(formBean, formBindAuthBean.getSearchFieldList()) : FormSearchUtil.getUserConditions(formBean, paramBean.getUserConditions());
        FormQueryWhereClause userConditionWhereClause = this.capDataListSqlHelpManager.getFormQueryWhereClauseByMap(userConditions, true);
        FormQueryWhereClause formulaWhereClause = this.capDataListSqlHelpManager.getOperationRangeWhereClause(formBindAuthBean);
        ArrayList<FormQueryWhereClause> whereClauses = new ArrayList<FormQueryWhereClause>();
        whereClauses.add(dataSearchConditionWhereCaluse);
        whereClauses.add(dataConditionWhereCause);
        whereClauses.add(userConditionWhereClause);
        whereClauses.add(formulaWhereClause);
        FormQueryWhereClause querySqlClause = new FormQueryWhereClause();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        String sqlSb = this.capDataListSqlHelpManager.getSQLWhere(whereClauses, queryParams);
        querySqlClause.setAllSqlClause(Strings.isBlank((String)sqlSb) ? sqlSb : " AND " + sqlSb);
        querySqlClause.setQueryParams(queryParams);
        return querySqlClause;
    }

    private FormQueryWhereClause getFieldDataSearchConditionFormQueryWhereClause(FormBean formBean, String fieldName, String dataSearchCondition, boolean needTableName) {
        FormQueryWhereClause formQueryWhereClause = new FormQueryWhereClause();
        FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
        if (needTableName) {
            fieldName = formFieldBean.getOwnerTableName() + "." + fieldName;
        }
        String dbms = JDBCAgent.getDBType();
        ArrayList<String> queryParams = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        FormFieldComEnum formFieldComEnum = formFieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case TEXT: {
                if (Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType()) && "PostgreSQL".equalsIgnoreCase(dbms)) {
                    int i;
                    StringBuilder text = new StringBuilder();
                    int fieldLength = Integer.parseInt(formFieldBean.getFieldLength());
                    int digitNum = Integer.parseInt(formFieldBean.getDigitNum());
                    for (i = 0; i < fieldLength; ++i) {
                        text.append("9");
                    }
                    if (digitNum != 0) {
                        if (Strings.isBlank((String)text.toString())) {
                            text.append("9.");
                        } else {
                            text.append(".");
                        }
                        for (i = 0; i < digitNum; ++i) {
                            text.append("9");
                        }
                    } else {
                        text.append("9");
                    }
                    stringBuilder.append("TO_CHAR(").append(fieldName).append(",'").append(text.toString()).append("')").append(" LIKE ? ");
                    queryParams.add("%" + SQLWildcardUtil.escape((String)dataSearchCondition) + "%");
                    break;
                }
                stringBuilder.append(fieldName).append(" LIKE ? ");
                queryParams.add("%" + SQLWildcardUtil.escape((String)dataSearchCondition) + "%");
                break;
            }
            case TEXTAREA: {
                stringBuilder.append(fieldName).append(" LIKE ? ");
                queryParams.add("%" + SQLWildcardUtil.escape((String)dataSearchCondition) + "%");
                break;
            }
            case EXTEND_DATE: 
            case EXTEND_DATETIME: {
                String fieldWhere = this.formatDateTimeCondition(formFieldBean.getInputType(), fieldName);
                stringBuilder.append(fieldWhere).append(" LIKE ? ");
                queryParams.add("%" + SQLWildcardUtil.escape((String)dataSearchCondition) + "%");
                break;
            }
            case CHECKBOX: {
                ArrayList<Integer> values = new ArrayList<Integer>();
                boolean hasValue = false;
                if (CAPBusinessEnum.CheckBoxEnum.UN_CHECK.getDisplay().contains(dataSearchCondition)) {
                    values.add(0);
                    hasValue = true;
                }
                if (CAPBusinessEnum.CheckBoxEnum.CHECK.getDisplay().contains(dataSearchCondition)) {
                    values.add(1);
                    hasValue = true;
                }
                if (!hasValue) {
                    values.add(2);
                }
                stringBuilder.append(fieldName).append(" IN (");
                int j = values.size();
                for (int i = 0; i < j; ++i) {
                    if (i == j - 1) {
                        stringBuilder.append("?");
                    } else {
                        stringBuilder.append("?,");
                    }
                    queryParams.add((String)values.get(i));
                }
                stringBuilder.append(")");
                break;
            }
            default: {
                stringBuilder.append(" 1 = 1 ");
            }
        }
        stringBuilder.append(")");
        formQueryWhereClause.setAllSqlClause(stringBuilder.toString());
        formQueryWhereClause.setQueryParams(queryParams);
        return formQueryWhereClause;
    }

    private String formatDateTimeCondition(String inputType, String fieldName) {
        StringBuilder dateFormat = new StringBuilder();
        if (FormFieldComEnum.EXTEND_DATE.getKey().equals(inputType)) {
            if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isDMSQLRuntime() || JDBCAgent.isKingBaseesRunTime()) {
                dateFormat.append("TO_CHAR(").append(fieldName).append(",'yyyy-MM-dd')");
            } else if (ReportDBUtils.isSQLServerRuntime()) {
                dateFormat.append("CONVERT(varchar(100), ").append(fieldName).append(", 23)");
            } else if (ReportDBUtils.isPostgreSQLRuntime()) {
                dateFormat.append("TO_CHAR(").append(fieldName).append(",'YYYY-MM-DD')");
            } else {
                dateFormat.append("DATE_FORMAT(").append(fieldName).append(",'%Y-%m-%d')");
            }
        } else if (FormFieldComEnum.EXTEND_DATETIME.getKey().equals(inputType)) {
            if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isDMSQLRuntime() || JDBCAgent.isKingBaseesRunTime()) {
                dateFormat.append("TO_CHAR(").append(fieldName).append(",'yyyy-MM-dd hh24:mi')");
            } else if (ReportDBUtils.isSQLServerRuntime()) {
                dateFormat.append("SUBSTRING(CONVERT(varchar(100),").append(fieldName).append(",120),1,16)");
            } else if (ReportDBUtils.isPostgreSQLRuntime()) {
                dateFormat.append("TO_CHAR(").append(fieldName).append(",'YYYY-MM-DD HH24:MI')");
            } else {
                dateFormat.append("DATE_FORMAT(").append(fieldName).append(",'%Y-%m-%d %H:%i')");
            }
        }
        return dateFormat.toString();
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setCapUnFlowManager(CAPUnFlowManager capUnFlowManager) {
        this.capUnFlowManager = capUnFlowManager;
    }

    public void setCapDataListSqlHelpManager(CAPDataListSqlHelpManager capDataListSqlHelpManager) {
        this.capDataListSqlHelpManager = capDataListSqlHelpManager;
    }

    public void setCapUnFlowButtonManager(CAPUnFlowButtonManager capUnFlowButtonManager) {
        this.capUnFlowButtonManager = capUnFlowButtonManager;
    }

    public static class CheckDataLockResult {
        private boolean success;
        private Map<String, Object> result;

        public static CheckDataLockResult successResult() {
            CheckDataLockResult result = new CheckDataLockResult();
            result.setSuccess(true);
            return result;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public Map<String, Object> getResult() {
            return this.result;
        }

        public void setResult(Map<String, Object> result) {
            this.result = result;
        }
    }
}

