/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.AbstractParamBean;
import com.seeyon.cap4.template.bean.ExcelReadParamBean;
import com.seeyon.cap4.template.bean.ImportUpdateDataParamBean;
import com.seeyon.cap4.template.exception.FormDataBusinessException;
import com.seeyon.cap4.template.manager.CAPImportCacheDataManager;
import com.seeyon.cap4.template.manager.CAPImportManager;
import com.seeyon.cap4.template.result.ImportResult;
import com.seeyon.cap4.template.service.AbstractCAPFormBaseService;
import com.seeyon.cap4.template.vo.AImportDataVO;
import com.seeyon.cap4.template.vo.ImportReadDataVO;
import com.seeyon.cap4.template.vo.ImportReadSubDataVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.logging.Log;

public class CAPImportService
extends AbstractCAPFormBaseService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPImportService.class);
    private CAPImportCacheDataManager capImportCacheDataManager;

    public Object readData(Map<String, Object> params) {
        return this.invoke(params, "readData");
    }

    @ValidateRequestParam(code="3001", notEmpty={"tableName", "formId"})
    public Object readDataFromCacheDB(ExcelReadParamBean readBean) {
        ImportResult<AImportDataVO> result;
        try {
            AImportDataVO dataVO = this.capImportCacheDataManager.read4Result(readBean);
            if (dataVO instanceof ImportReadSubDataVO || dataVO instanceof ImportReadDataVO) {
                return this.resetResultMap(dataVO);
            }
            result = new ImportResult<AImportDataVO>();
            result.success(dataVO);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("readDataFromCacheDB " + readBean), (Throwable)e);
            result = this.formatException(e);
        }
        return result;
    }

    @ValidateRequestParam(code="3001", notEmpty={"tableName", "formId", "fieldName", "id", "updateIdenticalValue"})
    public ImportResult<AImportDataVO> updateCacheDBData(ImportUpdateDataParamBean paramBean) {
        ImportResult<AImportDataVO> result;
        try {
            AImportDataVO vo = this.capImportCacheDataManager.update(paramBean);
            result = new ImportResult<AImportDataVO>();
            result.success(vo);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("updateCacheDBData " + paramBean), (Throwable)e);
            result = this.formatException(e);
        }
        return result;
    }

    public Object execute(Map<String, Object> params) {
        return this.invoke(params, "execute");
    }

    public <T> Object invoke(Map<String, Object> params, String methodName) {
        ImportResult<AImportDataVO> result;
        try {
            String type = (String)params.get("type");
            CAPImportManager manager = this.getInstance(type);
            ParamClass paramClass = manager.getClass().getAnnotation(ParamClass.class);
            Class clazz = paramClass.clazz();
            Object bean = AbstractParamBean.convert(params, clazz);
            AImportDataVO dataVO = (AImportDataVO)manager.getClass().getMethod(methodName, clazz).invoke((Object)manager, bean);
            if (dataVO instanceof ImportReadSubDataVO || dataVO instanceof ImportReadDataVO) {
                return this.resetResultMap(dataVO);
            }
            result = new ImportResult();
            result.success(dataVO);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)("import invoke " + params), (Throwable)e);
            result = this.formatException(e.getTargetException());
        }
        catch (Exception e) {
            LOGGER.error((Object)("import invoke " + params), (Throwable)e);
            result = this.formatException(e);
        }
        return result;
    }

    private Map resetResultMap(AImportDataVO dataVO) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll((Map<String, String>)new BeanMap((Object)dataVO));
        map.put("code", "3000");
        if (map.get("message") == null) {
            map.put("message", "the operation is success!!!");
        }
        map.remove("class");
        return map;
    }

    private ImportResult<AImportDataVO> formatException(Throwable e) {
        ImportResult<AImportDataVO> result = new ImportResult<AImportDataVO>();
        if (e instanceof FormDataBusinessException) {
            FormDataBusinessException e1 = (FormDataBusinessException)((Object)e);
            result.error(e1.getCode(), e.getMessage());
        } else {
            result.exception();
        }
        return result;
    }

    private CAPImportManager getInstance(String type) throws BusinessException {
        Map map = AppContext.getBeansOfType(CAPImportManager.class);
        for (Map.Entry entry : map.entrySet()) {
            if (!((CAPImportManager)entry.getValue()).getType().equals(type)) continue;
            return (CAPImportManager)entry.getValue();
        }
        throw new FormDataBusinessException("3003", "excel data is empty");
    }

    public void setCapImportCacheDataManager(CAPImportCacheDataManager capImportCacheDataManager) {
        this.capImportCacheDataManager = capImportCacheDataManager;
    }
}

