/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.bo.BindResult;
import com.seeyon.apps.cloudapp.po.CloudAppDatas;
import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.RandomVerifyImgCodeUtil;
import com.seeyon.cap4.template.util.mall.Authcode;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

public class CAPMallOAuthService {
    private static final Log logger = CtpLogFactory.getLog(CAPMallOAuthService.class);
    private MallApi mallApi;
    private OrgManager orgManager;
    private CAPHttpRequestManager capHttpRequestManager;
    private static final int SEND_CODE_INTERVAL = 120;
    private static final String KEY_CLOUD_SMS_TIME = "CLOUD_SMS_TIME";
    private static final String KEY_CLOUD_SMS_CODE = "CLOUD_SMS_CODE";
    private static final String KEY_CLOUD_SMS_MOBILE = "CLOUD_SMS_MOBILE";
    private static final String KEY_CLOUD_SMS = "CLOUD_SMS";
    private static final String KEY_CODE = "code";
    private static final String KEY_MOBILE = "mobile";
    private static final String KEY_IMG_CODE = "imgcode";
    private static final String KEY_CLOUD_IMAGE_CODE = "CLOUD_IMAGE_CODE";
    private static final String KEY_CLOUD_AUTH_STATE = "CLOUD_AUTH_STATE";
    private static final String KEY_CLOUD_BIND_RESULT = "CLOUD_BIND_RESULT";
    private static final String AUTH_STATE_SUCCESS = "1";
    private static final String AUTH_STATE_FAIL = "0";
    private static final String AUTH_STATE_DOING = "2";
    private static final String CODE_PARAMS_ERROR = "1001";
    private static final String CODE_METHOD_ERROR = "1003";
    private static final String CODE_REQUEST_ERROR = "1004";
    private static final String MESSAGE1 = "cap.template.oauth.certificated.codeNull";
    private static final String MESSAGE2 = "cap.template.oauth.certificated.tokenError";
    private static final String MESSAGE3 = "cap.template.oauth.certificated.execute.error";
    private static final String MESSAGE4 = "cap.template.oauth.authorize.error";
    private static final String MESSAGE5 = "cap.template.oauth.account.create.fail";
    private static final String MESSAGE6 = "cap.template.oauth.imgCode.error";
    private static final String MESSAGE7 = "cap.template.oauth.code.notSend";
    private static final String MESSAGE8 = "cap.template.oauth.code.expired";
    private static final String MESSAGE9 = "cap.template.oauth.code.error";
    private static final String MESSAGE10 = "cap.template.oauth.mobile.empty";
    private static final String MESSAGE11 = "cap.template.oauth.generate.image.error";
    private static final String MESSAGE12 = "cap.template.oauth.mobile.error";

    public Map<String, Object> getRandomImg(Integer w, Integer h) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String imgcode = RandomVerifyImgCodeUtil.generateVerifyCode(4, "0123456789");
        String imageStr = RandomVerifyImgCodeUtil.getRandomBase64Image(imgcode, w, h);
        if (Strings.isBlank((String)imageStr)) {
            result.put(KEY_CODE, CODE_METHOD_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE11));
            return result;
        }
        AppContext.putSessionContext((String)KEY_CLOUD_IMAGE_CODE, (Object)imgcode);
        result.put(KEY_CODE, "1000");
        result.put("message", "the operation is success!!!");
        result.put("data", imageStr);
        return result;
    }

    public Map<String, Object> getAuthState() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String state = (String)AppContext.getSessionContext((String)KEY_CLOUD_AUTH_STATE);
        state = state == null ? AUTH_STATE_DOING : state;
        result.put(KEY_CODE, "1000");
        result.put("message", "the operation is success!!!");
        result.put("data", state);
        return result;
    }

    public Map<String, Object> checkBindMall() {
        CloudAppDatas ctpCloudAppData = this.mallApi.getBindMallUserData(Long.valueOf(AppContext.currentUserId()));
        BindResult bindResult = this.mallApi.getBindMallResult(ctpCloudAppData);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bindResult.isBind()) {
            result.put(KEY_CODE, "1000");
            result.put("message", "the operation is success!!!");
            result.put("data", ctpCloudAppData);
        } else {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("avatar", bindResult.getAvatar());
            data.put(KEY_MOBILE, bindResult.getMobile());
            result.put(KEY_CODE, "1101");
            result.put("message", "need bind mall user");
            result.put("data", data);
        }
        return result;
    }

    public Map<String, Object> sendCode(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String mobile = String.valueOf(map.get(KEY_MOBILE));
        String imgcode = String.valueOf(map.get(KEY_IMG_CODE));
        if (Strings.isBlank((String)mobile)) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE12));
            return result;
        }
        if (Strings.isBlank((String)imgcode) || !imgcode.equals(AppContext.getSessionContext((String)KEY_CLOUD_IMAGE_CODE))) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE6));
            return result;
        }
        AppContext.removeSessionArrribute((String)KEY_CLOUD_AUTH_STATE);
        param.put("appId", 9);
        param.put(KEY_CODE, Authcode.encode(mobile));
        param.put("param", mobile);
        param.put("m", "accountbind");
        param.put("a", "send_code");
        Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.STORE_API_URL, param, Map.class);
        if (AUTH_STATE_SUCCESS.equals(CAPParamUtil.getString((Map)httpResult, (String)"result"))) {
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            jsonObject.put(KEY_CLOUD_SMS_TIME, System.currentTimeMillis() / 1000L);
            jsonObject.put(KEY_CLOUD_SMS_CODE, CAPParamUtil.getString((Map)httpResult, (String)KEY_CODE));
            jsonObject.put(KEY_CLOUD_SMS_MOBILE, mobile);
            AppContext.putSessionContext((String)KEY_CLOUD_SMS, jsonObject);
            AppContext.removeSessionArrribute((String)KEY_CLOUD_IMAGE_CODE);
            result.put(KEY_CODE, "1000");
            result.put("message", "the operation is success!!!");
            result.put("data", 120);
            if (MallUtil.CLOUD_APP_URL.indexOf("test") > -1) {
                result.put("TODO", jsonObject);
            }
            return result;
        }
        String message = MallUtil.getMallErrorMessage(httpResult);
        result.put(KEY_CODE, CODE_REQUEST_ERROR);
        result.put("message", message);
        return result;
    }

    public Map<String, Object> checkCode(String mobile, String code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isBlank((String)mobile)) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE10));
            return result;
        }
        if (Strings.isBlank((String)code)) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE9));
            return result;
        }
        Map sessionData = (Map)AppContext.getSessionContext((String)KEY_CLOUD_SMS);
        if (sessionData == null) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE7));
            return result;
        }
        Long sendTime = CAPParamUtil.getLong((Map)sessionData, (String)KEY_CLOUD_SMS_TIME);
        Long nowTime = System.currentTimeMillis() / 1000L;
        if (sendTime == null || nowTime.intValue() - sendTime.intValue() > 120) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE8));
            return result;
        }
        String sessionCode = CAPParamUtil.getString((Map)sessionData, (String)KEY_CLOUD_SMS_CODE);
        String sessionMobile = CAPParamUtil.getString((Map)sessionData, (String)KEY_CLOUD_SMS_MOBILE);
        if (mobile.equals(sessionMobile) && code.equals(sessionCode)) {
            result.put(KEY_CODE, "1000");
            result.put("message", "the operation is success!!!");
        } else {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE9));
        }
        return result;
    }

    public Map<String, Object> checkImgCode(String imgcode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isBlank((String)imgcode) || !imgcode.equals(AppContext.getSessionContext((String)KEY_CLOUD_IMAGE_CODE))) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE6));
            return result;
        }
        result.put(KEY_CODE, "1000");
        result.put("message", "the operation is success!!!");
        return result;
    }

    public Map<String, Object> bindMallUser(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String mobile = String.valueOf(map.get(KEY_MOBILE));
        String code = String.valueOf(map.get(KEY_CODE));
        if (Strings.isBlank((String)mobile)) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE10));
            return result;
        }
        if (Strings.isBlank((String)code)) {
            result.put(KEY_CODE, CODE_PARAMS_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE9));
            return result;
        }
        Map<String, Object> checkCodeResult = this.checkCode(mobile, code);
        if (!"1000".equals(CAPParamUtil.getString(checkCodeResult, (String)KEY_CODE))) {
            return checkCodeResult;
        }
        Map<String, Object> jsonObject = this.createOrUpdateMallUser(mobile);
        String state = CAPParamUtil.getString(jsonObject, (String)"state");
        if (AUTH_STATE_SUCCESS.equals(state) || AUTH_STATE_FAIL.equals(state)) {
            AppContext.removeSessionArrribute((String)KEY_CLOUD_SMS);
            AppContext.putSessionContext((String)KEY_CLOUD_AUTH_STATE, (Object)AUTH_STATE_DOING);
            AppContext.putSessionContext((String)KEY_CLOUD_BIND_RESULT, jsonObject);
            return this.authorize(CAPParamUtil.getString(jsonObject, (String)"userid"));
        }
        result.put(KEY_CODE, CODE_METHOD_ERROR);
        result.put("message", ResourceUtil.getString((String)MESSAGE5));
        return result;
    }

    public Map<String, Object> authorize(String uid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            OAuthClientRequest outh2Request = this.getOuth2RequestByUid(uid);
            result.put(KEY_CODE, "1000");
            result.put("message", "the operation is success!!!");
            result.put("data", outh2Request.getLocationUri());
            return result;
        }
        catch (OAuthSystemException e) {
            logger.error((Object)("Cloud Auth method authorize is error AND param uid is " + uid), (Throwable)e);
            result.put(KEY_CODE, CODE_METHOD_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE4));
            return result;
        }
    }

    public Map<String, Object> certificated(HttpServletRequest request) {
        Map jsonObject;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(KEY_CODE, "1000");
        result.put("message", "the operation is success!!!");
        String code = ReqUtil.getString((HttpServletRequest)request, (String)KEY_CODE);
        if (Strings.isBlank((String)code)) {
            AppContext.putSessionContext((String)KEY_CLOUD_AUTH_STATE, (Object)AUTH_STATE_FAIL);
            result.put(KEY_CODE, CODE_METHOD_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE1));
            return result;
        }
        String scope = "";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("grant_type", "authorization_code");
        param.put(KEY_CODE, code);
        param.put("client_id", MallUtil.CLIENT_ID);
        param.put("client_secret", MallUtil.CLIENT_SECRET);
        if (!Strings.isBlank((String)scope)) {
            param.put("scope", scope);
        }
        if ("false".equals(CAPParamUtil.getString((Map)(jsonObject = this.capHttpRequestManager.postByFormPart(MallUtil.TOKEN_LOCATION, param, Map.class)), (String)"isSuccess"))) {
            logger.error((Object)("Cloud Auth certificated request token is fail . code is " + code + " , request data is " + jsonObject.toString()));
            if (!AUTH_STATE_SUCCESS.equals(AppContext.getSessionContext((String)KEY_CLOUD_AUTH_STATE))) {
                AppContext.putSessionContext((String)KEY_CLOUD_AUTH_STATE, (Object)AUTH_STATE_FAIL);
            }
            result.put(KEY_CODE, CODE_REQUEST_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE2));
            result.put("data", jsonObject);
            return result;
        }
        Long memberId = AppContext.currentUserId();
        CloudAppDatas ctpCloudAppData = this.mallApi.getByMemberId(memberId);
        logger.info((Object)("Cloud Auth \u7528\u6237\uff1a[" + AppContext.currentUserName() + "]\u6839\u636ecode:[" + code + "]\u83b7\u53d6\u7684token:" + jsonObject.toString()));
        boolean isNew = false;
        if (ctpCloudAppData == null) {
            isNew = true;
            ctpCloudAppData = new CloudAppDatas();
            ctpCloudAppData.setCid(Long.valueOf(UUIDLong.longUUID()));
        }
        ctpCloudAppData.setAccessToken(CAPParamUtil.getString((Map)jsonObject, (String)"access_token"));
        Date current = new Date();
        ctpCloudAppData.setApplyTime(Datetimes.parseDatetime((String)Datetimes.formatDatetime((Date)current)));
        ctpCloudAppData.setRefreshToken(CAPParamUtil.getString((Map)jsonObject, (String)"refresh_token"));
        Calendar cal = Calendar.getInstance();
        cal.add(5, 180);
        Date refreshTime = new Date(cal.getTime().getTime() - 60000L);
        ctpCloudAppData.setRefreshTime(refreshTime);
        ctpCloudAppData.setMemberId(memberId);
        jsonObject.put("isNew", isNew);
        boolean query = this.saveOrUpdate(jsonObject, ctpCloudAppData);
        if (query) {
            AppContext.putSessionContext((String)KEY_CLOUD_AUTH_STATE, (Object)AUTH_STATE_SUCCESS);
        } else {
            AppContext.putSessionContext((String)KEY_CLOUD_AUTH_STATE, (Object)AUTH_STATE_FAIL);
            result.put(KEY_CODE, CODE_METHOD_ERROR);
            result.put("message", ResourceUtil.getString((String)MESSAGE3));
        }
        return result;
    }

    private boolean saveOrUpdate(Map<String, Object> map, CloudAppDatas ctpCloudAppData) {
        CloudAppDatas oldCtpCloudAppData;
        User user = AppContext.getCurrentUser();
        boolean isNew = CAPParamUtil.getBooleanValue(map, (String)"isNew");
        String tokenType = CAPParamUtil.getString(map, (String)"token_type");
        Long expiresIn = CAPParamUtil.getLong(map, (String)"expires_in");
        ctpCloudAppData.setOrg_account_id(user.getAccountId());
        ctpCloudAppData.setTokenType(tokenType);
        ctpCloudAppData.setExpiresIn(expiresIn);
        ctpCloudAppData.setEwaccount(user.getLoginName());
        Map bindResult = (Map)AppContext.getSessionContext((String)KEY_CLOUD_BIND_RESULT);
        bindResult = bindResult == null ? new HashMap() : bindResult;
        String userID = CAPParamUtil.getString((Map)bindResult, (String)"userid");
        String serviceCodeObj = CAPParamUtil.getString((Map)bindResult, (String)"servicecode");
        ctpCloudAppData.setServiceCode(serviceCodeObj != null ? String.valueOf(serviceCodeObj) : null);
        ctpCloudAppData.setMallId(userID);
        ctpCloudAppData.setExpandS1(user.isGroupAdmin() ? AUTH_STATE_SUCCESS : AUTH_STATE_FAIL);
        ctpCloudAppData.setIsAdmin(Integer.valueOf(user.isAdmin() ? 1 : 0));
        String reBindObj = CAPParamUtil.getString((Map)bindResult, (String)"rebind");
        if (reBindObj != null && (oldCtpCloudAppData = this.mallApi.getByMemberId(ctpCloudAppData.getMemberId())) != null) {
            ctpCloudAppData.setIsAdmin(oldCtpCloudAppData.getIsAdmin());
        }
        ctpCloudAppData.setAdministrator(Integer.valueOf(user.isAdministrator() ? 1 : 0));
        ctpCloudAppData.setSystemadmin(Integer.valueOf(user.isSystemAdmin() ? 1 : 0));
        String mallAccount = CAPParamUtil.getString((Map)bindResult, (String)"account");
        if (Strings.isBlank((String)mallAccount)) {
            try {
                V3xOrgMember member = this.orgManager.getMemberById(user.getId());
                mallAccount = member.getTelNumber();
            }
            catch (BusinessException e) {
                logger.error((Object)("Cloud Auth method saveOrUpdate is error AND param jsonObject is " + map.toString() + " , AND param ctpCloudAppData is " + ctpCloudAppData.toString()), (Throwable)e);
                return false;
            }
        }
        ctpCloudAppData.setMallAccount(mallAccount);
        boolean query = false;
        query = isNew ? this.mallApi.save(ctpCloudAppData) : this.mallApi.update(ctpCloudAppData);
        return query;
    }

    public Map<String, Object> createOrUpdateMallUser(String telNum) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        User user = AppContext.getCurrentUser();
        String telNumber = "";
        param.put("oaAccount", user.getLoginName());
        param.put("orgName", user.getLoginAccountName());
        try {
            V3xOrgMember member = this.orgManager.getMemberById(user.getId());
            telNumber = member.getTelNumber();
            V3xOrgDepartment department = this.orgManager.getDepartmentById(member.getOrgDepartmentId());
            V3xOrgPost post = this.orgManager.getPostById(member.getOrgPostId());
            param.put("email", member.getEmailAddress());
            param.put("realname", member.getName());
            param.put("departName", department.getName());
            param.put("postName", post.getName());
        }
        catch (BusinessException e) {
            logger.error((Object)("Cloud Auth method saveOrUpdate is error AND param telNum is " + telNum), (Throwable)e);
        }
        if (Strings.isBlank((String)telNum)) {
            telNum = telNumber;
        }
        param.put(KEY_MOBILE, telNum);
        param.put("dogNo", CAPBusinessUtil.getDogNo());
        param.put("bindStr", "yes");
        param.put("isAdmin", user.isAdmin());
        param.put("ignoreDog", 1);
        param.put("m", "accountbind");
        param.put("a", "bind");
        Map result = this.capHttpRequestManager.postByFormPart(MallUtil.STORE_API_URL, param, Map.class);
        logger.info((Object)("Cloud Auth createOrUpdateMallUser return is : " + result.toString()));
        return result;
    }

    public OAuthClientRequest getOuth2RequestByUserName(String userName) throws OAuthSystemException {
        return this.getOuth2Request("u", Authcode.encode(userName));
    }

    public OAuthClientRequest getOuth2RequestByUid(String uid) throws OAuthSystemException {
        return this.getOuth2Request("uid", Authcode.encode(uid));
    }

    private OAuthClientRequest getOuth2Request(String paramName, String paramValue) throws OAuthSystemException {
        String redirectURL = CAPBusinessUtil.getCtxServerHost(AppContext.getRawRequest(), true) + "cap4/businessTemplateController.do?method=mallOAuthCertificated" + Functions.csrfSuffix();
        OAuthClientRequest outh2Request = OAuthClientRequest.authorizationLocation((String)MallUtil.CODE_LOCATION).setClientId(MallUtil.CLIENT_ID).setRedirectURI(redirectURL).setResponseType(KEY_CODE).setParameter(paramName, paramValue).setParameter("state", "xyz").setParameter("appid", String.valueOf(9)).buildQueryMessage();
        logger.info((Object)("Cloud Auth OAuthClientRequest Object is " + outh2Request.getLocationUri()));
        return outh2Request;
    }

    public void setMallApi(MallApi mallApi) {
        this.mallApi = mallApi;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCapHttpRequestManager(CAPHttpRequestManager capHttpRequestManager) {
        this.capHttpRequestManager = capHttpRequestManager;
    }
}

