/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.ScreenCapture4FormParamBean;
import com.seeyon.cap4.template.bean.ScreenCaptureParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.result.ScreenCaptureResult;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.util.PhantomJSUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class CAPScreenCaptureService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPScreenCaptureService.class);
    private static final String CODE1 = "5001";
    private static final String MESSAGE1 = "cap.template.message.paramNull";
    private static final String CODE2 = "5002";
    private static final String MESSAGE2 = "com.template.screen.capture.error";
    private static final String IMG_BASE64_KEY = "imgBase64Key";
    private static final String IMG_BASE64 = "imgBase64";
    private static final Map<String, String> IMG_BASE64S = new ConcurrentHashMap<String, String>();
    private Map<String, Long> timeOutMap = new ConcurrentHashMap<String, Long>();
    private final Thread thread = new Thread(new CleanTimeOutCacheExecutor());
    private static final int timeOut = 1800000;
    private static final AtomicBoolean threadStartState = new AtomicBoolean(false);
    private static final String IMG_BASE64_PREFIX = "data:image/png;base64,";

    @ValidateRequestParam(notEmpty={"moduleId", "moduleType", "rightId"}, code="5001")
    public ScreenCaptureResult doFormScreenCapture4File(ScreenCapture4FormParamBean paramBean) {
        Map<String, Object> screenParams = this.getFormScreenCaptureScreenParams(paramBean);
        String url = this.getFormScreenCaptureUrl(paramBean);
        String renderType = paramBean.getRenderType() == null ? "pdf" : paramBean.getRenderType();
        V3XFile file = PhantomJSUtil.doScreenCapture4File(url, paramBean.getScreenParams(), new HashMap<String, Object>(), renderType);
        ScreenCaptureResult<Map<String, Object>> result = new ScreenCaptureResult<Map<String, Object>>();
        if (file != null) {
            result.success(this.getScreenCaptureFileData(file));
        } else {
            result.error(CODE2, ResourceUtil.getString((String)MESSAGE2));
        }
        return result;
    }

    public String doFormDataContentScreenCapture(ScreenCapture4FormParamBean paramBean) {
        Map<String, Object> screenParams = this.getFormScreenCaptureScreenParams(paramBean);
        String url = this.getFormScreenCaptureUrl(paramBean);
        String img = PhantomJSUtil.doScreenCapture(url, screenParams, new HashMap<String, Object>(), "base64");
        StringBuilder html = new StringBuilder();
        html.append("<img src=\"");
        html.append(Strings.isBlank((String)img) ? "" : IMG_BASE64_PREFIX + img);
        html.append("\" />");
        return html.toString();
    }

    private Map<String, Object> getFormScreenCaptureScreenParams(ScreenCapture4FormParamBean paramBean) {
        HttpServletRequest request = AppContext.getRawRequest();
        String token = request.getHeader("token");
        HashMap<String, Object> screenParams = new HashMap<String, Object>();
        if (Strings.isNotBlank((String)token)) {
            screenParams.put("token", token);
        }
        if (paramBean.getCaptureType() != null) {
            screenParams.put("captureType", paramBean.getCaptureType());
        }
        if (paramBean.getModuleId() != null && Strings.isNotBlank((String)paramBean.getRightId())) {
            CAPFormUtil.addFormAccessControl(paramBean.getModuleId(), AppContext.getCurrentUser().getId());
        }
        return screenParams;
    }

    private String getFormScreenCaptureUrl(ScreenCapture4FormParamBean paramBean) {
        HttpServletRequest request = AppContext.getRawRequest();
        StringBuilder url = new StringBuilder(CAPBusinessUtil.getCtxServerHost(request, true));
        url.append("common/cap4/template/display/pc/form/dist/index.html");
        url.append("#/browse?rightId=");
        url.append(Strings.isBlank((String)paramBean.getRightId()) ? "" : paramBean.getRightId());
        url.append("&moduleId=");
        url.append(paramBean.getModuleId());
        url.append("&moduleType=");
        url.append(paramBean.getModuleType());
        if (paramBean.getFormMasterId() != null) {
            url.append("&formMasterId=").append(paramBean.getFormMasterId());
        }
        if (paramBean.getFormTemplateId() != null) {
            url.append("&formTemplateId=").append(paramBean.getFormTemplateId());
        }
        url.append("&printFlag=true&screenCapture=true");
        url.append("&from=");
        url.append(CAPBusinessEnum.FormOpenFrom.ORIGINAL_FORM.getKey());
        return url.toString();
    }

    public String doScreenCapture4base64(ScreenCaptureParamBean paramBean) {
        if (Strings.isBlank((String)paramBean.getUrl()) && paramBean.getScreenParams() == null) {
            return null;
        }
        return PhantomJSUtil.doScreenCapture(paramBean.getUrl(), paramBean.getScreenParams(), paramBean.getExtParams(), "base64");
    }

    @ValidateRequestParam(notEmpty={"url"}, notNull={"screenParams"}, code="5001")
    public ScreenCaptureResult doScreenCapture(ScreenCaptureParamBean paramBean) {
        ScreenCaptureResult<Map<Object, Object>> result = new ScreenCaptureResult<Map<Object, Object>>();
        HashMap<String, String> data = new HashMap<String, String>();
        String url = paramBean.getUrl();
        if (Integer.valueOf(1).equals(paramBean.getFillUrl())) {
            url = CAPBusinessUtil.getCtxServerHost(AppContext.getRawRequest(), true) + url;
        }
        if ("base64".equals(paramBean.getRenderType())) {
            String imgBase64 = PhantomJSUtil.doScreenCapture(url, paramBean.getScreenParams(), paramBean.getExtParams(), paramBean.getRenderType());
            if (Strings.isBlank((String)imgBase64)) {
                result.error(CODE2, ResourceUtil.getString((String)MESSAGE2));
                return result;
            }
            String imgBase64Key = String.valueOf(UUIDLong.longUUID());
            IMG_BASE64S.put(imgBase64Key, IMG_BASE64_PREFIX + imgBase64);
            this.timeOutMap.put(imgBase64Key, System.currentTimeMillis());
            data.put(IMG_BASE64_KEY, imgBase64Key);
            data.put(IMG_BASE64, IMG_BASE64S.get(imgBase64Key));
            if (!threadStartState.get()) {
                threadStartState.set(true);
                this.thread.start();
            }
            result.success(data);
        } else {
            V3XFile file = PhantomJSUtil.doScreenCapture4File(url, paramBean.getScreenParams(), paramBean.getExtParams(), paramBean.getRenderType());
            if (file != null) {
                result.success(this.getScreenCaptureFileData(file));
            } else {
                result.error(CODE2, ResourceUtil.getString((String)MESSAGE2));
            }
        }
        return result;
    }

    private Map<String, Object> getScreenCaptureFileData(V3XFile file) {
        StringBuilder downloadUrl = new StringBuilder();
        downloadUrl.append(CAPBusinessUtil.getCtxServerHost(AppContext.getRawRequest(), true));
        downloadUrl.append("fileDownload.do?method=doDownload&filename=").append(URLEncoder.encode(file.getFilename()));
        downloadUrl.append("&v=").append(file.getV());
        downloadUrl.append("&fileId=").append(file.getId());
        downloadUrl.append("&createDate=").append(DateUtil.format((Date)file.getCreateDate()));
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        data.put("url", downloadUrl.toString());
        data.put("fileId", String.valueOf(file.getId()));
        data.put("createDate", DateUtil.format((Date)file.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        data.put("filename", file.getFilename());
        data.put("v", file.getV());
        return data;
    }

    public String getScreenCaptureImgBase64(String imgBase64Key) {
        if (Strings.isBlank((String)imgBase64Key)) {
            return String.format(ResourceUtil.getString((String)MESSAGE1), IMG_BASE64_KEY);
        }
        String imgBase64 = IMG_BASE64S.get(imgBase64Key);
        this.timeOutMap.put(imgBase64Key, System.currentTimeMillis());
        return imgBase64;
    }

    protected class CleanTimeOutCacheExecutor
    implements Runnable {
        protected CleanTimeOutCacheExecutor() {
        }

        @Override
        public void run() {
            try {
                while (!threadStartState.get()) {
                    for (String imgBase64Key : CAPScreenCaptureService.this.timeOutMap.keySet()) {
                        Long time = (Long)CAPScreenCaptureService.this.timeOutMap.get(imgBase64Key);
                        Long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis < time + 1800000L) continue;
                        IMG_BASE64S.remove(imgBase64Key);
                        CAPScreenCaptureService.this.timeOutMap.remove(imgBase64Key);
                        LOGGER.info((Object)("\u6e05\u7406\u622a\u56fe\u7f13\u5b58:" + imgBase64Key));
                    }
                    long sleepTime = 1200000L;
                    Thread.sleep(sleepTime);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u6e05\u7406\u622a\u56fe\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

