/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.google.common.collect.Maps;
import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.enums.ColQueryCondition;
import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.api.BizPortalApi;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.bizportal.po.CAPPortalSpaceConfig;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.TemplateDataParamBean;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessOrgBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplate4EditManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateOrgManager;
import com.seeyon.cap4.template.manager.CAPBussinessMenuColumnManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.result.TemplateDataResult;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemInitializer;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.PartitionManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lbs.po.CmpLBSBase;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.util.StringUtils;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.privilege.manager.PrivilegeManager;
import com.seeyon.ctp.report.engine.api.bo.ReportQueryParams;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.report.engine.po.ReportIndex;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.springframework.util.ConcurrentReferenceHashMap;

public class CAPTemplateDataService
implements SystemInitializer {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPTemplateDataService.class);
    private static final String CODE = "4000";
    private static final String MESSAGE = "cap.template.message.success";
    public static final String CODE1 = "4001";
    private static final String MESSAGE1 = "cap.template.message.paramNull";
    private static final String CODE2 = "4002";
    private static final String MESSAGE2 = "%s option exception!";
    private static final String MEMBER_NAME = "memberName";
    private static final String MEMBER_IMG = "memberImg";
    private static final String MEMBER_ID = "memberId";
    private static final String MEMBER_POST_NAME = "memberPostName";
    private static final String TEMPLATE_ID = "templateId";
    private static final double DIS = 3.0;
    private OrgManager orgManager;
    private CAPBusinessManager capBusinessManager;
    private CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager;
    private CAPBusinessColumnManager capBusinessColumnManager;
    private CAPBusinessElementManager capBusinessElementManager;
    private BusinessManager businessManager4;
    private CAP4FormCacheManager cap4FormCacheManager;
    private ReportApi reportApi;
    private TemplateManager templateManager;
    private CollaborationApi collaborationApi;
    private CAPBussinessMenuColumnManager capBussinessMenuColumnManager;
    private PrivilegeManager privilegeManager;
    private PartitionManager partitionManager;
    private BizPortalApi bizPortalApi;
    private static final Map<String, Long> configLastModified = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Map<String, Object>> configJson = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private Map<String, AbstractColumnElementDataManager> elementDataManagerMap = Maps.newHashMap();

    public void initialize() {
        Map dataManagers = AppContext.getBeansOfType(AbstractColumnElementDataManager.class);
        for (Map.Entry entry : dataManagers.entrySet()) {
            AbstractColumnElementDataManager dataManager = (AbstractColumnElementDataManager)entry.getValue();
            this.elementDataManagerMap.put(dataManager.getClassId().toLowerCase(), dataManager);
        }
    }

    public void destroy() {
    }

    private AbstractColumnElementDataManager getAbstractColumnElementDataManagerByClassId(String classId) {
        return this.elementDataManagerMap.get(classId.toLowerCase());
    }

    @Deprecated
    public Map<String, Object> getDataByTemplateId(String templateId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        result.put("data", data);
        if (Strings.isBlank((String)templateId)) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), TEMPLATE_ID));
            return result;
        }
        if (this.validateDataAuth(templateId, false)) {
            try {
                List<CAPBusinessColumnBO> capBusinessColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(templateId));
                Map<String, Map<String, Object>> configInfos = this.getConfigInfoMap(templateId, null, false);
                this.getData1(capBusinessColumnBOs, data, configInfos, false);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"getDataByTemplateId is exception", (Throwable)e);
                result.put("code", CODE2);
                result.put("message", String.format(MESSAGE2, "getDataByTemplateId"));
            }
        }
        return result;
    }

    @ValidateRequestParam(notNull={"columnIds"}, notEmpty={"templateId"}, code="4001")
    public TemplateDataResult<Map<String, Object>> getDataByColumnIds(TemplateDataParamBean bean) {
        TemplateDataResult<Map<String, Object>> result = new TemplateDataResult<Map<String, Object>>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.validateDataAuth(String.valueOf(bean.getTemplateId()), bean.isEdit())) {
            try {
                int columnIdSize = bean.getColumnIds().size();
                ArrayList<CAPBusinessColumnBO> bos = null;
                if (bean.isEdit()) {
                    bos = this.capBusinessTemplate4EditManager.getCacheEditableCAPBusinessColumnBOs(bean.getTemplateId(), bean.getColumnIds(), true);
                }
                if (bos == null || bos.size() != columnIdSize) {
                    bos = new ArrayList();
                    List<CAPBusinessColumnBO> capBusinessColumnBOS = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(bean.getTemplateId());
                    for (CAPBusinessColumnBO columnBO : capBusinessColumnBOS) {
                        if (!bean.getColumnIds().contains(columnBO.getId()) || !String.valueOf(CAPBusinessEnum.State.ENABLE.getState()).equals(columnBO.getState())) continue;
                        bos.add(columnBO);
                    }
                }
                Map<String, Map<String, Object>> configInfos = this.getConfigInfoMap(String.valueOf(bean.getTemplateId()), bean.getColumnIds(), bean.isEdit());
                this.getData1(bos, data, configInfos, bean.isEdit());
                result.success(data);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("getDataByColumnIds is exception " + e.getMessage()), (Throwable)e);
                result.error(CODE2, String.format(MESSAGE2, "getDataByColumnIds"));
            }
        } else {
            result.success(data);
        }
        return result;
    }

    @Deprecated
    public Map<String, Object> getDataByElementIds(Map<String, Object> params) {
        List elementIds = CAPParamUtil.getParamsListByKey(params, (String)"elementIds");
        Long columnId = CAPParamUtil.getLong(params, (String)"columnId");
        Long templateId = CAPParamUtil.getLong(params, (String)TEMPLATE_ID);
        boolean isEdit = CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(CAPParamUtil.getString(params, (String)"isEdit"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        result.put("data", data);
        if (elementIds == null || columnId == null || templateId == null) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), "elementIds or columnId"));
            return result;
        }
        try {
            List<CAPBusinessElementBO> capBusinessElementBOs = null;
            CAPBusinessColumnBO capBusinessColumnBO = null;
            if (isEdit && (capBusinessColumnBO = this.capBusinessTemplate4EditManager.getCacheEditableCAPBusinessColumnBO(templateId, columnId)) != null) {
                capBusinessElementBOs = capBusinessColumnBO.getCapBusinessElementBOs();
            }
            if (capBusinessColumnBO == null) {
                capBusinessColumnBO = this.capBusinessColumnManager.getCAPBusinessColumnBOFromCacheById(templateId, columnId);
                capBusinessElementBOs = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(columnId);
            }
            ArrayList<CAPBusinessElementBO> elementBOS = new ArrayList<CAPBusinessElementBO>();
            for (CAPBusinessElementBO elementBO : capBusinessElementBOs) {
                if (!elementIds.contains(elementBO.getId())) continue;
                elementBOS.add(elementBO);
            }
            ArrayList<String> columnIds = new ArrayList<String>(1);
            columnIds.add(capBusinessColumnBO.getId());
            Map<String, Map<String, Object>> configInfos = this.getConfigInfoMap(capBusinessColumnBO.getTemplateId(), columnIds, isEdit);
            this.getData2(capBusinessColumnBO, elementBOS, data, configInfos, isEdit);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getDataByElementIds is exception " + e.getMessage()), (Throwable)e);
            result.put("code", CODE2);
            result.put("message", MESSAGE2);
        }
        return result;
    }

    public Map<String, Object> getDataByRealParams(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap data = new HashMap();
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        result.put("data", data);
        String elementType = String.valueOf(params.get("elementType"));
        Map dataInfo = (Map)params.get("dataInfo");
        String dynamicKey = (String)params.get("dynamicKey");
        AbstractColumnElementDataManager abstractColumnElementDataManage = this.getAbstractColumnElementDataManagerByClassId(elementType);
        if (abstractColumnElementDataManage == null) {
            LOGGER.error((Object)("elementType is error.elementType is " + elementType));
            return dataInfo;
        }
        if (dataInfo.get("configInfo") == null) {
            HashMap configInfo = new HashMap();
            if (dataInfo.get("page") != null) {
                configInfo.put("page", dataInfo.get("page"));
                dataInfo.remove("page");
            }
            if (dataInfo.get("pageSize") != null) {
                configInfo.put("pageSize", dataInfo.get("pageSize"));
                dataInfo.remove("pageSize");
            }
            dataInfo.put("configInfo", configInfo);
        }
        Map<String, Object> elementManagerData = abstractColumnElementDataManage.getColumnElementData(dataInfo);
        result.put("code", elementManagerData.get("code"));
        result.put("message", elementManagerData.get("message"));
        HashMap<String, Object> elementData = new HashMap<String, Object>();
        elementData.put("code", elementManagerData.get("code"));
        elementData.put("message", elementManagerData.get("message"));
        if ("1000".equals(elementManagerData.get("code"))) {
            elementData.putAll((Map)elementManagerData.get("data"));
        }
        elementData.put("isEg", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        data.put(dynamicKey, elementData);
        return result;
    }

    private void getData1(List<CAPBusinessColumnBO> capBusinessColumnBOs, Map<String, Object> data, Map<String, Map<String, Object>> configInfos, boolean isEdit) throws BusinessException {
        for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOs) {
            List<CAPBusinessElementBO> capBusinessElementBOs = isEdit && capBusinessColumnBO.getCapBusinessElementBOs() != null ? capBusinessColumnBO.getCapBusinessElementBOs() : this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(Long.valueOf(capBusinessColumnBO.getId()));
            this.getData2(capBusinessColumnBO, capBusinessElementBOs, data, configInfos, isEdit);
        }
    }

    private void getData2(CAPBusinessColumnBO capBusinessColumnBO, List<CAPBusinessElementBO> capBusinessElementBOs, Map<String, Object> data, Map<String, Map<String, Object>> configInfos, boolean isEdit) {
        if (capBusinessElementBOs == null) {
            return;
        }
        Map<String, Object> egData = null;
        for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOs) {
            HashMap<String, String> elementEgData;
            Map<String, Object> dataInfo = capBusinessElementBO.getDataInfo();
            String elementType = capBusinessElementBO.getElementType();
            Map<String, Object> extendInfo = capBusinessElementBO.getExtendInfo();
            String dynamicKey = CAPParamUtil.getString(extendInfo, (String)"dynamicKey");
            if (dataInfo != null) {
                HashMap<String, Object> elementData = new HashMap<String, Object>();
                AbstractColumnElementDataManager abstractColumnElementDataManage = this.getAbstractColumnElementDataManagerByClassId(elementType);
                if (abstractColumnElementDataManage == null) {
                    String message = "elementType is error.elementType is " + elementType + "and elementId is " + capBusinessElementBO.getId();
                    LOGGER.error((Object)message);
                    elementData.put("code", CODE2);
                    elementData.put("message", String.format(MESSAGE2, message));
                } else {
                    Map<String, Object> configInfo = configInfos.get(capBusinessElementBO.getId());
                    if (configInfo != null) {
                        dataInfo.put("configInfo", configInfo);
                    }
                    Map<String, Object> elementManagerData = abstractColumnElementDataManage.getColumnElementData(dataInfo);
                    if (configInfo != null) {
                        dataInfo.remove("configInfo");
                        elementData.put("configInfo", configInfo);
                    }
                    if ("1000".equals(elementManagerData.get("code"))) {
                        elementData.put("code", elementManagerData.get("code"));
                        elementData.put("message", elementManagerData.get("message"));
                        elementData.putAll((Map)elementManagerData.get("data"));
                    } else {
                        elementData.putAll(elementManagerData);
                    }
                }
                elementData.put("dataInfo", dataInfo);
                elementData.put("isEg", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                data.put(dynamicKey, elementData);
                continue;
            }
            if (CAPBusinessEnum.ColumnType.MENU_COLUMN.getType() == Integer.valueOf(elementType).intValue()) {
                String templateId = capBusinessColumnBO.getTemplateId();
                CAPBusinessTemplateBO capBusinessTemplateBO = this.capBusinessTemplateManager.getCAPBusinessTemplateBOById(Long.valueOf(templateId));
                String bussId = capBusinessTemplateBO.getEggId();
                String platform = capBusinessTemplateBO.getClient();
                Map<Object, Object> dataMap = new HashMap();
                try {
                    dataMap = this.capBussinessMenuColumnManager.getMenusByBussId(bussId, platform);
                    dataMap.put("code", "1000");
                    dataMap.put("message", "the operation is success!!!");
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)("getMenusByBussId.BusinessException, bussId = " + bussId + ", platform=" + platform), (Throwable)e);
                    dataMap.put("code", CODE2);
                    dataMap.put("message", String.format(MESSAGE2, "getMenusByBussId.BusinessException"));
                }
                dataMap.put("isEg", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                data.put(dynamicKey, dataMap);
                continue;
            }
            if (egData == null) {
                egData = this.getEGDataByTemplateId(capBusinessColumnBO.getTemplateId(), isEdit);
            }
            if ((elementEgData = (HashMap<String, String>)egData.get(dynamicKey)) == null) {
                elementEgData = new HashMap<String, String>();
            }
            elementEgData.put("isEg", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
            data.put(dynamicKey, elementEgData);
        }
    }

    public Map<String, Object> getEGDataByTemplateId(String templateId, boolean isEdit) {
        CAPBusinessTemplateBO capBusinessTemplateBO = this.capBusinessTemplateManager.getCAPBusinessTemplateBOById(Long.valueOf(templateId));
        String templatePath = CAPBusinessTemplateUtil.getTemplatePath("runtime", capBusinessTemplateBO, isEdit);
        HashMap result = CAPBusinessUtil.readConfigJSON(templatePath + "eg" + File.separator + "data.json");
        return result == null ? new HashMap() : result;
    }

    public Map<String, Object> getDefaultTemplateDatas(String bizId, String platform) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isBlank((String)bizId)) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), "bizId"));
            return result;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        result.put("data", data);
        Map<String, Object> userInfo = this.getCurrentUserInfo();
        if (!CODE.equals(userInfo.get("code"))) {
            return userInfo;
        }
        data.put("userInfo", userInfo.get("data"));
        Map<String, Object> menus = this.getMenusByBussId(bizId, platform);
        if (!CODE.equals(menus.get("code"))) {
            return menus;
        }
        data.put("menus", menus.get("data"));
        Map<String, Object> defaultData = this.getDefaultTemplateData(bizId);
        if (!CODE.equals(defaultData.get("code"))) {
            return defaultData;
        }
        data.put("defaultData", defaultData.get("data"));
        return result;
    }

    public Map<String, Object> getDefaultTemplateData(String bussId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, List> data = new HashMap<String, List>();
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        result.put("data", data);
        try {
            StringBuilder templeteIdStringBuilder = new StringBuilder("");
            List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(Long.valueOf(bussId));
            for (CAPFormDefinition formDefine : formList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formDefine.getId());
                if (Enums.FormType.processesForm.getKey() != fb.getFormType()) continue;
                List templateList = this.templateManager.getCtpTemplates(fb.getId().longValue(), false);
                for (CtpTemplate ctpTemplate : templateList) {
                    templeteIdStringBuilder.append(ctpTemplate.getId()).append(",");
                }
            }
            ArrayList flowDatas = new ArrayList();
            HashMap<String, String> originalField = new HashMap<String, String>();
            originalField.put("dbType", "DECIMAL");
            originalField.put("comType", "TEXT");
            HashMap<String, Object> listPending = new HashMap<String, Object>();
            listPending.put("name", CAPBusinessEnum.DataSource.LISTPENDING_NUN.getName());
            listPending.put("originalField", originalField);
            HashMap<String, Object> listDone = new HashMap<String, Object>();
            listDone.put("name", CAPBusinessEnum.DataSource.LISTDONE_NUN.getName());
            listDone.put("originalField", originalField);
            HashMap<String, Object> listWaitSend = new HashMap<String, Object>();
            listWaitSend.put("name", CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getName());
            listWaitSend.put("originalField", originalField);
            HashMap<String, Object> listSent = new HashMap<String, Object>();
            listSent.put("name", CAPBusinessEnum.DataSource.LISTSENT_NUN.getName());
            listSent.put("originalField", originalField);
            if (Strings.isBlank((String)templeteIdStringBuilder.toString())) {
                listPending.put("realValue", "0");
                listPending.put("display", "0");
                listDone.put("realValue", "0");
                listDone.put("display", "0");
                listWaitSend.put("realValue", "0");
                listWaitSend.put("display", "0");
                listSent.put("realValue", "0");
                listSent.put("display", "0");
            } else {
                String templeteIds = StringUtils.replaceLast((String)templeteIdStringBuilder.toString(), (String)",", (String)"");
                HashMap<String, String> requestMap = new HashMap<String, String>();
                requestMap.put(ColQueryCondition.templeteIds.name(), templeteIds);
                requestMap.put(ColQueryCondition.currentUser.name(), String.valueOf(AppContext.currentUserId()));
                requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_pending.getKey()));
                int listPendingNum = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                listPending.put("realValue", String.valueOf(listPendingNum));
                listPending.put("display", String.valueOf(listPendingNum));
                requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_done.getKey()));
                int listDoneNum = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                listDone.put("realValue", String.valueOf(listDoneNum));
                listDone.put("display", String.valueOf(listDoneNum));
                requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_waitSend.getKey()));
                int listWaitSendNum = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                listWaitSend.put("realValue", String.valueOf(listWaitSendNum));
                listWaitSend.put("display", String.valueOf(listWaitSendNum));
                requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_sent.getKey()));
                int listSentNum = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                listSent.put("realValue", String.valueOf(listSentNum));
                listSent.put("display", String.valueOf(listSentNum));
            }
            flowDatas.add(listPending);
            flowDatas.add(listDone);
            flowDatas.add(listWaitSend);
            flowDatas.add(listSent);
            data.put("flowDatas", flowDatas);
            List reportIndices = this.reportApi.findReportIndexWithAuth(ApplicationCategoryEnum.cap4biz.name(), bussId, AppContext.getCurrentUser());
            ArrayList<Long> indesIds = new ArrayList<Long>(reportIndices.size());
            for (ReportIndex reportIndex : reportIndices) {
                indesIds.add(reportIndex.getId());
            }
            List reportIndexResults = this.reportApi.findReportIndexResult(indesIds);
            data.put("indexDatas", reportIndexResults);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getDefaultTemplateData.BusinessException, bussId=" + bussId), (Throwable)e);
            result.put("code", CODE2);
            result.put("message", String.format(MESSAGE2, "getDefaultTemplateData.BusinessException"));
        }
        return result;
    }

    public Map<String, Object> getCurrentUserInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> data = new HashMap<String, String>();
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        result.put("data", data);
        try {
            data.put(MEMBER_NAME, AppContext.currentUserName());
            data.put(MEMBER_IMG, this.orgManager.getAvatarImageUrl(Long.valueOf(AppContext.currentUserId())));
            data.put(MEMBER_ID, String.valueOf(AppContext.currentUserId()));
            V3xOrgPost post = this.orgManager.getPostById(AppContext.getCurrentUser().getPostId());
            if (post != null) {
                data.put(MEMBER_POST_NAME, post.getName());
            } else {
                data.put(MEMBER_POST_NAME, "");
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"getCurrentUserInfo.BusinessException", (Throwable)e);
            result.put("code", CODE2);
            result.put("message", String.format(MESSAGE2, "getCurrentUserInfo.BusinessException"));
        }
        return result;
    }

    public Map<String, Object> getMenusByBussId(String bizId, String platform) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isBlank((String)bizId)) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), "bizId"));
            return result;
        }
        try {
            Map<String, Object> data = this.capBussinessMenuColumnManager.getMenusByBussId(bizId, platform);
            result.put("code", CODE);
            result.put("message", ResourceUtil.getString((String)MESSAGE));
            result.put("data", data);
            return result;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getMenusByBussId.BusinessException, bussId = " + bizId + ", platform=" + platform), (Throwable)e);
            result.put("code", CODE2);
            result.put("message", String.format(MESSAGE2, "getMenusByBussId.BusinessException"));
            return result;
        }
    }

    public Map<String, Object> getMenuSettingsList(String bizId, String platform) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isBlank((String)bizId)) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), "bizId"));
            return result;
        }
        try {
            Map<String, Object> data = this.capBussinessMenuColumnManager.getMenuSettingsList(bizId, platform);
            result.put("code", CODE);
            result.put("message", ResourceUtil.getString((String)MESSAGE));
            result.put("data", data);
            return result;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e);
            result.put("code", CODE2);
            result.put("message", String.format(MESSAGE2, "getMenuSettingsList.BusinessException"));
            return result;
        }
    }

    public List<CAPBusinessTemplateBO> getAuthorizeTemplates(Long bizId, Long uesrId, String clientType, String templateType) throws BusinessException {
        HashSet<CAPBusinessTemplateBO> bos = new HashSet<CAPBusinessTemplateBO>();
        List orgIds = this.orgManager.getAllUserDomainIDs(uesrId);
        List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        if (Strings.isNotEmpty(capBusinessTemplateBOS) && orgIds != null) {
            HashMap<String, CAPBusinessTemplateBO> map = new HashMap<String, CAPBusinessTemplateBO>();
            for (CAPBusinessTemplateBO bo : capBusinessTemplateBOS) {
                map.put(bo.getId(), bo);
            }
            List<CAPBusinessOrgBO> capBusinessOrgBOs = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByOrgIds(orgIds);
            for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOs) {
                String templateId = capBusinessOrgBO.getTemplateId();
                if (Strings.isBlank((String)templateId) || map.get(templateId) == null) continue;
                CAPBusinessTemplateBO capBusinessTemplateBO = (CAPBusinessTemplateBO)map.get(templateId);
                if (!String.valueOf(bizId).equals(capBusinessTemplateBO.getEggId()) || !String.valueOf(CAPBusinessEnum.State.ENABLE.getState()).equals(capBusinessTemplateBO.getState()) || !clientType.equals(capBusinessTemplateBO.getClient())) continue;
                if (templateType == null) {
                    bos.add(capBusinessTemplateBO);
                    continue;
                }
                if (!templateType.equals(capBusinessTemplateBO.getTemplateType())) continue;
                bos.add(capBusinessTemplateBO);
            }
        }
        ArrayList<CAPBusinessTemplateBO> boList = new ArrayList<CAPBusinessTemplateBO>();
        boList.addAll(bos);
        return boList;
    }

    public Map<String, Object> getAuthorizeTemplatesInfo(Long bizId, int templateType, String templateId) {
        User user = AppContext.getCurrentUser();
        int clientType = CAPBusinessEnum.Platform.PC.getType();
        if (user.getLoginSign() == Constants.login_sign.phone.value()) {
            clientType = CAPBusinessEnum.Platform.MOBILE.getType();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean hasCustomTemplate = false;
        boolean useFrame = true;
        String firstTemplateId = "";
        try {
            List<CAPBusinessTemplateBO> bos = this.getAuthorizeTemplates(bizId, AppContext.currentUserId(), String.valueOf(clientType), String.valueOf(templateType));
            if (bos.size() > 1) {
                Collections.sort(bos, new CAPBusinessTemplateBO.SortComparator());
            }
            if (!bos.isEmpty()) {
                hasCustomTemplate = templateId == null ? true : hasCustomTemplate;
                CAPBusinessTemplateBO firstBo = bos.get(0);
                if (templateId != null) {
                    for (CAPBusinessTemplateBO bo : bos) {
                        if (!templateId.equals(bo.getId())) continue;
                        hasCustomTemplate = true;
                        firstBo = bo;
                    }
                }
                useFrame = String.valueOf(CAPBusinessEnum.TemplateFrameType.NEED_FRAME.getType()).equals(firstBo.getFrameType());
                firstTemplateId = firstBo.getId();
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getAuthorizeTemplates is exception " + e.getMessage()), (Throwable)e);
        }
        map.put("hasCustomTemplate", hasCustomTemplate);
        map.put("useFrame", useFrame);
        map.put("firstTemplateId", firstTemplateId);
        return map;
    }

    public Map<String, Object> getTemplatesByCurrentUser(String bizId, String client) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList datas = new ArrayList();
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        if (Strings.isBlank((String)bizId) || Strings.isBlank((String)client)) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), "bizId or client"));
            return result;
        }
        result.put("data", datas);
        try {
            List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.getAuthorizeTemplates(Long.valueOf(bizId), AppContext.currentUserId(), client, null);
            if (capBusinessTemplateBOS.size() > 1) {
                Collections.sort(capBusinessTemplateBOS, new CAPBusinessTemplateBO.SortComparator());
            }
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", capBusinessTemplateBO.getId());
                data.put("sort", capBusinessTemplateBO.getSort());
                data.put("templateType", capBusinessTemplateBO.getTemplateType());
                data.put("name", capBusinessTemplateBO.getName());
                data.put("frameType", capBusinessTemplateBO.getFrameType());
                datas.add(data);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getTemplatesByCurrentUser is error.error is:" + e.getMessage()), (Throwable)e);
            result.put("code", CODE2);
            result.put("message", String.format(MESSAGE2, "getTemplatesByCurrentUser"));
            return result;
        }
        return result;
    }

    private boolean validateDataAuth(String templateId, boolean isEdit) {
        boolean result = false;
        CAPBusinessTemplateBO capBusinessTemplateBO = this.capBusinessTemplateManager.getCAPBusinessTemplateBOById(Long.valueOf(templateId));
        if (isEdit) {
            result = this.capBusinessManager.checkBizOwnerAuth4Template(Long.valueOf(capBusinessTemplateBO.getEggId()));
        } else if (CAPBusinessEnum.State.DISABLE.getState() == Integer.valueOf(capBusinessTemplateBO.getState()).intValue()) {
            result = false;
        } else {
            List orgIds = null;
            try {
                orgIds = this.orgManager.getAllUserDomainIDs(Long.valueOf(AppContext.currentUserId()));
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("getAllUserDomainIDs.BusinessException templateId=" + templateId), (Throwable)e);
            }
            List<CAPBusinessOrgBO> capBusinessOrgBOs = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByOrgIds(orgIds);
            for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOs) {
                if (!Strings.isNotBlank((String)templateId) || !templateId.equals(capBusinessOrgBO.getTemplateId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Map<String, Object> getMobileTemplatesByPathId(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String pathId = (String)params.get("pathId");
        Integer templateType = (Integer)params.get("templateType");
        result.put("code", CODE);
        result.put("message", ResourceUtil.getString((String)MESSAGE));
        if (Strings.isBlank((String)pathId) || templateType == null) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), "pathId or templateType"));
            return result;
        }
        CAPBusinessTemplate capBusinessTemplate = this.capBusinessTemplateManager.getCAPBusinessTemplateByPathIdAndTypeAndClient(Long.valueOf(pathId), templateType, CAPBusinessEnum.Platform.MOBILE.getType());
        if (capBusinessTemplate != null && capBusinessTemplate.getState() == 1) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", String.valueOf(capBusinessTemplate.getPathId()));
            data.put("templateType", String.valueOf(capBusinessTemplate.getTemplateType()));
            result.put("data", data);
        }
        return result;
    }

    private List<Map<String, String>> getMobileTemplates(Long bizId, List<Map<String, String>> data) {
        List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
            if (!capBusinessTemplateBO.getClient().equals(String.valueOf(CAPBusinessEnum.Platform.MOBILE.getType())) || capBusinessTemplateBO.getTemplateType().equals(String.valueOf(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", capBusinessTemplateBO.getPathId());
            map.put("templateType", capBusinessTemplateBO.getTemplateType());
            data.add(map);
        }
        return data;
    }

    public Map<String, Object> getMobileTemplatesByMenuId(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String menuId = (String)params.get("menuId");
        int sourceType = ParamUtil.getInt(params, (String)"sourceType", (int)-1);
        if (Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE.getKey() == sourceType) {
            PrivMenuBO privMenuBO = this.privilegeManager.findMenuById(Long.valueOf(Long.parseLong(menuId)));
            if (privMenuBO != null) {
                menuId = privMenuBO.getParentId() + "";
            }
        } else {
            Long bizId = MapUtils.getLong(params, (Object)"bizId");
            if (bizId != null) {
                try {
                    BizConfigBean configBean = this.businessManager4.findBizConfigById(bizId);
                    menuId = configBean.getMenuId().toString();
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)"", (Throwable)e);
                    result.put("code", CODE2);
                    result.put("message", String.format(MESSAGE2, "getMobileUpdatedTemplatesByMenuId"));
                }
            }
        }
        try {
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByMenuId(Long.valueOf(menuId));
            HashMap<String, Object> data = new HashMap<String, Object>();
            result.put("code", CODE);
            result.put("message", ResourceUtil.getString((String)MESSAGE));
            result.put("data", data);
            Map<String, Object> currentMap = this.getTemplatesByCurrentUser(String.valueOf(bizConfigBean.getId()), String.valueOf(CAPBusinessEnum.Platform.MOBILE.getType()));
            List currentUserTemplates = (List)currentMap.get("data");
            ArrayList<Map<String, String>> allTemplates = new ArrayList<Map<String, String>>();
            if (currentUserTemplates != null) {
                for (Map map : currentUserTemplates) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put("id", String.valueOf(map.get("id")));
                    tempMap.put("templateType", String.valueOf(map.get("templateType")));
                    allTemplates.add(tempMap);
                }
            }
            data.put("currentUserTemplates", currentUserTemplates);
            data.put("allTemplates", this.getMobileTemplates(bizConfigBean.getId(), allTemplates));
            data.put("bussId", String.valueOf(bizConfigBean.getId()));
            List<CAPPortalSpace> list = this.bizPortalApi.findAvailableCAPPortalSpace(ContextParam.of(AppContext.getCurrentUser(), bizConfigBean.getId(), BizPortalConstants.Platform.MOBILE));
            boolean isNew = CollectionUtils.isNotEmpty(list);
            if (isNew) {
                CAPPortalSpace portalSpace = list.get(0);
                CAPPortalSpaceConfig spaceConfig = this.bizPortalApi.getBizPortalSpaceConfig(portalSpace.getId());
                data.put("spaceId", portalSpace.getId().toString());
                data.put("configId", spaceConfig.getId().toString());
                List<Long> snapshotIds = this.bizPortalApi.findCAPPortalGoodSnapshotId(spaceConfig.getId());
                for (Long snapshotId : snapshotIds) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put("id", String.valueOf(snapshotId));
                    allTemplates.add(tempMap);
                }
            }
            data.put("useNewSpace", isNew);
        }
        catch (BusinessException e) {
            result.put("code", CODE2);
            result.put("message", String.format(MESSAGE2, "getMobileUpdatedTemplatesByMenuId"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReportExcel(Map<String, Object> params, HttpServletResponse response) {
        block13: {
            String designId = (String)params.get("designId");
            ServletOutputStream out = null;
            FileInputStream in = null;
            try {
                ReportApi.ExportExcelInfo info;
                ReportQueryParams reportQueryParams = new ReportQueryParams();
                reportQueryParams.put((Object)"designId", (Object)designId);
                reportQueryParams.put((Object)"userId", (Object)AppContext.currentUserId());
                String schstatsStoreId = (String)params.get("schstatsStoreId");
                if (Strings.isNotBlank((String)schstatsStoreId)) {
                    reportQueryParams.put((Object)"schstatsStoreId", (Object)schstatsStoreId);
                }
                if (params.get("userConditions") != null) {
                    List<Map<String, Object>> userConditions = FormSearchUtil.getReportUserConditions((List)params.get("userConditions"));
                    reportQueryParams.put((Object)"userConditions", userConditions);
                }
                if ((info = this.reportApi.exportExcel(reportQueryParams)) == null) {
                    LOGGER.error((Object)("exportReportExcel not found designId : " + designId));
                    return;
                }
                String path = this.partitionManager.getFolder(info.getDataPath(), true);
                File excelFile = new File(path + File.separator + info.getFileName());
                String targetName = FileUtil.getDownloadFileName((HttpServletRequest)AppContext.getRawRequest(), (String)(info.getExcelName() + ".xlsx"));
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Content-disposition", "attachment;" + targetName);
                out = response.getOutputStream();
                in = new FileInputStream(excelFile);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
                ((InputStream)in).close();
                in = null;
                excelFile.delete();
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("exportReportExcel.reportApi.exportExcel error, designId = " + designId), (Throwable)e);
                break block13;
            }
            catch (Exception e) {
                if ("ClientAbortException".equals(e.getClass().getSimpleName())) {
                } else {
                    LOGGER.error((Object)"exportReportExcel excel error\uff01", (Throwable)e);
                }
                break block13;
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public Map<String, Object> getNearbyMap(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String strLatitude = (String)params.get("latitude");
        String strLongitude = (String)params.get("longitude");
        if (Strings.isBlank((String)strLatitude) || Strings.isBlank((String)strLongitude)) {
            result.put("code", CODE1);
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE1), "latitude or longitude"));
            return result;
        }
        double dis = 3.0;
        String radius = (String)params.get("radius");
        String unit = (String)params.get("unit");
        if (Strings.isNotBlank((String)unit) && CAPBusinessEnum.DistanceUnitEnum.M.getKey().equals(unit) && Strings.isNotBlank((String)radius)) {
            dis = Double.parseDouble(radius) / 1000.0;
        }
        if (Strings.isNotBlank((String)unit) && CAPBusinessEnum.DistanceUnitEnum.KM.getKey().equals(unit) && Strings.isNotBlank((String)radius)) {
            dis = Double.parseDouble(radius);
        }
        double latitude = Double.parseDouble(strLatitude);
        double longitude = Double.parseDouble(strLongitude);
        double r = 6371.0;
        double dlng = 2.0 * Math.asin(Math.sin(dis / (2.0 * r)) / Math.cos(latitude * Math.PI / 180.0));
        dlng = dlng * 180.0 / Math.PI;
        double dlat = dis / r;
        dlat = dlat * 180.0 / Math.PI;
        float minlat = Double.valueOf(latitude - dlat).floatValue();
        float maxlat = Double.valueOf(latitude + dlat).floatValue();
        float minlng = Double.valueOf(longitude - dlng).floatValue();
        float maxlng = Double.valueOf(longitude + dlng).floatValue();
        LOGGER.info((Object)("\u9644\u8fd1\u6570\u636e\u56db\u70b9\u6570\u636eminlat:" + minlat + ",maxlat:" + maxlat + ",minlng:" + minlng + ",maxlng:" + maxlng));
        HashMap<String, Float> param = new HashMap<String, Float>();
        param.put("minlat", Float.valueOf(minlat));
        param.put("maxlat", Float.valueOf(maxlat));
        param.put("minlng", Float.valueOf(minlng));
        param.put("maxlng", Float.valueOf(maxlng));
        String hql = "from CmpLBSBase where lbsLongitude >=:minlng and lbsLongitude <=:maxlng and lbsLatitude >=:minlat and lbsLatitude <=:maxlat";
        FlipInfo fi = new FlipInfo(1, 1000);
        List lbsBases = DBAgent.find((String)hql, param, (FlipInfo)fi);
        ArrayList<String> data = new ArrayList<String>();
        for (CmpLBSBase lbsBase : lbsBases) {
            data.add(String.valueOf(lbsBase.getId()));
        }
        result.put("data", data);
        return result;
    }

    private Map<String, Map<String, Object>> getConfigInfoMap(String templateId, List<String> columIds, boolean isEdit) throws BusinessException {
        HashMap<String, Map<String, Object>> configInfos = new HashMap<String, Map<String, Object>>();
        try {
            List columns;
            Map<String, Object> configTemplateMap;
            CAPBusinessTemplate capBusinessTemplate = this.capBusinessTemplateManager.getCAPBusinessTemplateById(Long.valueOf(templateId));
            String configPath = CAPBusinessTemplateUtil.getTemplateConfigPath("runtime", capBusinessTemplate, isEdit);
            Long modifiedTime = configLastModified.get(templateId);
            File configFile = new File(configPath);
            if (modifiedTime == null) {
                configLastModified.put(templateId, configFile.lastModified());
                configTemplateMap = this.capBusinessTemplateManager.getConfigTemplateVO(configPath).exportToMap();
                configJson.put(templateId, configTemplateMap);
            } else {
                if (modifiedTime.longValue() == configFile.lastModified()) {
                    configTemplateMap = configJson.get(templateId);
                    if (configTemplateMap == null) {
                        configTemplateMap = this.capBusinessTemplateManager.getConfigTemplateVO(configPath).exportToMap();
                        configJson.put(templateId, configTemplateMap);
                    }
                } else {
                    configTemplateMap = this.capBusinessTemplateManager.getConfigTemplateVO(configPath).exportToMap();
                    configJson.put(templateId, configTemplateMap);
                }
                configLastModified.put(templateId, configFile.lastModified());
            }
            if (configTemplateMap != null && (columns = (List)configTemplateMap.get("columns")) != null) {
                if (Strings.isNotEmpty(columIds)) {
                    for (int i = 0; i < columns.size(); ++i) {
                        List elements;
                        Map column = (Map)columns.get(i);
                        if (!columIds.contains(String.valueOf(column.get("columnId"))) || (elements = (List)column.get("elements")) == null) continue;
                        for (int j = 0; j < elements.size(); ++j) {
                            Map element = (Map)elements.get(j);
                            Object configInfo = element.get("configInfo");
                            if (configInfo == null) continue;
                            String elementId = String.valueOf(element.get("elementId"));
                            configInfos.put(elementId, (Map)configInfo);
                        }
                    }
                } else {
                    for (int i = 0; i < columns.size(); ++i) {
                        Map column = (Map)columns.get(i);
                        List elements = (List)column.get("elements");
                        if (elements == null) continue;
                        for (int j = 0; j < elements.size(); ++j) {
                            Map element = (Map)elements.get(j);
                            Object configInfo = element.get("configInfo");
                            if (configInfo == null) continue;
                            String elementId = String.valueOf(element.get("elementId"));
                            configInfos.put(elementId, (Map)configInfo);
                        }
                    }
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"getConfigInfoMap BusinessException", (Throwable)e);
        }
        return configInfos;
    }

    public void setPartitionManager(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCapBusinessTemplateOrgManager(CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager) {
        this.capBusinessTemplateOrgManager = capBusinessTemplateOrgManager;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setCapBussinessMenuColumnManager(CAPBussinessMenuColumnManager capBussinessMenuColumnManager) {
        this.capBussinessMenuColumnManager = capBussinessMenuColumnManager;
    }

    public void setCapBusinessTemplate4EditManager(CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager) {
        this.capBusinessTemplate4EditManager = capBusinessTemplate4EditManager;
    }

    public void setCapBusinessElementManager(CAPBusinessElementManager capBusinessElementManager) {
        this.capBusinessElementManager = capBusinessElementManager;
    }

    public void setCapBusinessManager(CAPBusinessManager capBusinessManager) {
        this.capBusinessManager = capBusinessManager;
    }

    public void setPrivilegeManager(PrivilegeManager privilegeManager) {
        this.privilegeManager = privilegeManager;
    }

    public void setBizPortalApi(BizPortalApi bizPortalApi) {
        this.bizPortalApi = bizPortalApi;
    }
}

