/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.ElementAutoMatchParamBean;
import com.seeyon.cap4.template.bean.TemplateEditParamBean;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.manager.CAPBusinessTemplate4EditManager;
import com.seeyon.cap4.template.result.TemplateDesignResult;
import com.seeyon.cap4.template.service.AbstractCAPTemplateDesignService;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.vo.config.ConfigTemplateVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPTemplateDesignEditService
extends AbstractCAPTemplateDesignService {
    private static final Log logger = CtpLogFactory.getLog(CAPTemplateDesignEditService.class);
    private static final String CONFIG = "config";
    private CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager;

    public Map<String, Object> saveEditableTemplate(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "1000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        Long templateId = CAPParamUtil.getLong(params, (String)"templateId");
        Map map = (Map)params.get(CONFIG);
        try {
            ConfigTemplateVO configTemplateVO = new ConfigTemplateVO();
            configTemplateVO.importFromMap(map);
            this.capBusinessTemplate4EditManager.saveEditableTemplate(templateId, configTemplateVO);
        }
        catch (BusinessException e) {
            result.put("code", "1003");
            result.put("message", e.getMessage());
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, Object> putCacheEditableConfigJSON(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", "1000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        Long templateId = CAPParamUtil.getLong(params, (String)"templateId");
        Map map = params.get(CONFIG) == null ? null : (Map)params.get(CONFIG);
        try {
            ConfigTemplateVO configTemplateVO;
            if (map == null || map.isEmpty()) {
                configTemplateVO = null;
            } else {
                configTemplateVO = new ConfigTemplateVO();
                configTemplateVO.importFromMap(map);
            }
            this.capBusinessTemplate4EditManager.putCacheEditableTemplateConfigJSON(templateId, configTemplateVO);
        }
        catch (BusinessException e) {
            result.put("code", "1003");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "putCacheEditableConfigJSON") + " , " + e.getMessage());
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, Object> getCacheEditableConfigJSON(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long templateId = CAPParamUtil.getLong(params, (String)"templateId");
        try {
            ConfigTemplateVO configTemplateVO = this.capBusinessTemplate4EditManager.getCacheEditableTemplateConfigJSON(templateId);
            if (configTemplateVO == null) {
                result.put("code", "1004");
                result.put("message", ResourceUtil.getString((String)"cap.template.message.dataNull"));
            } else {
                result.put("code", "1000");
                result.put("data", configTemplateVO.exportToMap());
            }
        }
        catch (BusinessException e) {
            result.put("code", "1003");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getCacheEditableConfigJSON") + " , " + e.getMessage());
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, Object> removeCacheEditableConfigJSON(Map<String, Object> params) {
        params.put(CONFIG, null);
        return this.putCacheEditableConfigJSON(params);
    }

    public Map<String, Object> cancelEditTemplate(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        Long templateId = CAPParamUtil.getLong(params, (String)"templateId");
        result.put("code", "1000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        try {
            this.capBusinessTemplate4EditManager.cancelEditTemplate(templateId);
        }
        catch (BusinessException e) {
            result.put("code", "1003");
            result.put("message", e.getMessage());
            logger.error((Object)e);
        }
        return result;
    }

    public Map<String, Object> restoreToInitial(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("code", "1000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        Long templateId = CAPParamUtil.getLong(params, (String)"templateId");
        try {
            this.capBusinessTemplate4EditManager.restoreEditableTemplateToInitial(templateId);
        }
        catch (BusinessException e) {
            result.put("code", "1003");
            result.put("message", e.getMessage());
            logger.error((Object)("restoreEditableTemplateToInitial is exception " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"bizId", "templateId"}, code="1001")
    public TemplateDesignResult autoMatchElementData(ElementAutoMatchParamBean bean) {
        boolean execResult = true;
        try {
            this.capBusinessTemplate4EditManager.autoMatchEditableElementDataSource(bean.getBizId(), bean.getTemplateId());
        }
        catch (BusinessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            execResult = false;
        }
        TemplateDesignResult result = new TemplateDesignResult();
        if (execResult) {
            result.success();
        } else {
            result.error("1003");
        }
        return result;
    }

    public Map<String, Object> saveElementByColumnId(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String templateId = CAPParamUtil.getString(params, (String)"templateId");
        String columnId = CAPParamUtil.getString(params, (String)"columnId");
        Map element = CAPParamUtil.getParamsMapByKey(params, (String)"element");
        if (Strings.isBlank((String)templateId) || Strings.isBlank((String)columnId) || element == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "templateId or columnId or element"));
            return result;
        }
        try {
            this.capBusinessTemplate4EditManager.updateCacheEditableElement(Long.valueOf(templateId), Long.valueOf(columnId), element);
            result.put("code", "1000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        }
        catch (BusinessException e) {
            logger.error((Object)e);
            result.put("code", "1003");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "putCacheEditableElementDataSource"));
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"templateId"}, code="1001")
    public TemplateDesignResult<List<Map<String, Object>>> getColumnsByTemplateId(TemplateEditParamBean bean) {
        TemplateDesignResult<List<Map<String, Object>>> result = new TemplateDesignResult<List<Map<String, Object>>>();
        try {
            List<CAPBusinessColumnBO> capBusinessColumnBOS = this.capBusinessTemplate4EditManager.getAllCAPBusinessColumnBOs(bean.getTemplateId());
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(capBusinessColumnBOS.size());
            Collections.sort(capBusinessColumnBOS, new CAPBusinessColumnBO.SortCreateDateComparator());
            for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOS) {
                Map<String, Object> boObject = capBusinessColumnBO.exportToMapForDesign();
                list.add(boObject);
            }
            result.success(list);
        }
        catch (BusinessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.error("1003", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getColumnsByTemplateId"));
        }
        return result;
    }

    public Map<String, Object> getElementsByColumnId(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String templateId = ParamUtil.getString(params, (String)"templateId");
        String columnId = ParamUtil.getString(params, (String)"columnId");
        if (Strings.isBlank((String)templateId) || Strings.isBlank((String)columnId)) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "columnId or templateId"));
            return result;
        }
        try {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            int hasConfig = 0;
            int notConfig = 0;
            List<CAPBusinessElementBO> capBusinessElementBOS = this.capBusinessTemplate4EditManager.getEditableCAPBusinessElementBOs(Long.valueOf(templateId), Long.valueOf(columnId), true);
            int j = capBusinessElementBOS.size();
            ArrayList<Map<String, Object>> elementList = new ArrayList<Map<String, Object>>(j);
            for (int i = 0; i < j; ++i) {
                CAPBusinessElementBO capBusinessElementBO = capBusinessElementBOS.get(i);
                if (capBusinessElementBO.getDataInfo() == null) {
                    ++notConfig;
                } else {
                    ++hasConfig;
                }
                Map<String, Object> elementMap = capBusinessElementBO.exportToMapForDesign();
                elementList.add(elementMap);
            }
            data.put("hasConfigNum", Integer.valueOf(hasConfig));
            data.put("notConfigNum", Integer.valueOf(notConfig));
            data.put("elements", elementList);
            result.put("code", "1000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", data);
        }
        catch (BusinessException e) {
            logger.error((Object)("getElementsByColumnId BusinessException, params=" + params.toString()), (Throwable)e);
            result.put("code", "1003");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getEditableCAPBusinessElementBOs"));
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"operation", "columnIds", "value", "templateId"}, code="1001")
    public TemplateDesignResult updateColumns(TemplateEditParamBean bean) {
        TemplateDesignResult result = new TemplateDesignResult();
        if (!this.getUpdateColumnAllowOperation().contains(bean.getOperation())) {
            result.error("1001", ResourceUtil.getString((String)"cap.template.message.denied"));
            return result;
        }
        try {
            HashMap<String, Object> operation2Value = new HashMap<String, Object>(1);
            operation2Value.put(bean.getOperation(), bean.getValue());
            this.capBusinessTemplate4EditManager.updateCacheEditableColumns(bean.getTemplateId(), bean.getColumnIds(), operation2Value);
            result.success();
        }
        catch (BusinessException e) {
            logger.error((Object)e);
            result.error("1003", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "updateCacheEditableColumns"));
        }
        return result;
    }

    public void setCapBusinessTemplate4EditManager(CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager) {
        this.capBusinessTemplate4EditManager = capBusinessTemplate4EditManager;
    }
}

