/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.bo.BindResult;
import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.apps.cloudapp.po.CloudAppDatas;
import com.seeyon.cap4.template.bean.DownloadParamBean;
import com.seeyon.cap4.template.bo.AbstractMallBO;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessCustomCtrlBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPDownloadBaseManager;
import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.result.TemplateDesignResult;
import com.seeyon.cap4.template.service.AbstractCAPTemplateDesignService;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPTemplateDesignMallService
extends AbstractCAPTemplateDesignService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPTemplateDesignMallService.class);
    private MallApi mallApi;
    private CAPDownloadBaseManager capDownloadBaseManager;
    private CAPHttpRequestManager capHttpRequestManager;
    private static final String MESSAGE_TIP = "messageTip";
    private static final String CODE_REQUEST_ERROR = "1002";
    private static final String MESSAGE5 = "cap.template.message.paramError";
    private static final String VERSION = "version";
    private static final String PLATFORM = "platform";
    private static final String CAT_ALIAS = "catAlias";
    private static final String PAGE_SIZE = "pageSize";
    private static final String DATA_COUNT = "dataCount";
    private static final String COUNT = "count";
    private static final String LIST = "list";
    private static final String GOODS_ID = "goodsId";
    private static final String THUMB = "thumb";
    private static final String IMG = "img";
    private static final String PRESET_JSON = "preset.json";
    private static final String RESULTS = "results";

    public Map<String, Object> download(DownloadParamBean vo) {
        Map<Object, Object> result = new HashMap();
        try {
            result = this.capDownloadBaseManager.download(vo);
            if (result.get("code") == null) {
                result.put("code", "1000");
                result.put("message", "the operation is success!!!");
            }
        }
        catch (BusinessException e) {
            if (e.getCode() == null) {
                LOGGER.error((Object)("doDownload is exception " + e.getMessage()), (Throwable)e);
            } else {
                LOGGER.error((Object)("doDownload is exception " + e.getCode() + " " + e.getMessage()));
            }
            if ("1101".equals(e.getCode())) {
                BindResult bindResult = this.mallApi.getBindMallResult(null);
                if (bindResult.isBind()) {
                    result.put("code", "1000");
                    result.put("message", "the operation is success!!!");
                    result.put("data", bindResult.getCloudAppDatas());
                } else {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("avatar", bindResult.getAvatar());
                    data.put("mobile", bindResult.getMobile());
                    result.put("code", "1101");
                    result.put("message", "need bind mall user");
                    result.put("data", data);
                }
            }
            if ("1102".equals(e.getCode())) {
                result.put("code", e.getCode());
                result.put("goodUrl", e.getMessage());
            }
            result.put("code", e.getCode() == null ? "1005" : e.getCode());
            result.put("message", e.getMessage());
        }
        return result;
    }

    public TemplateDesignResult<Map<String, Object>> getGoods(Long goodId, Integer type) {
        TemplateDesignResult<Map<String, Object>> result = new TemplateDesignResult<Map<String, Object>>();
        HashMap<String, Object> jsonObject = new HashMap<String, Object>(1);
        jsonObject.put(GOODS_ID, goodId);
        Map<String, Object> parameterJson = MallUtil.getMallCommonParams(MallEnum.MallAction.INFO, jsonObject);
        Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), parameterJson, Map.class);
        if (MallUtil.isRequestSuccess(httpResult)) {
            Map<String, Object> data = null;
            if (CAPBusinessEnum.DownloadZipType.COLUMN.getType() == type.intValue()) {
                CAPBusinessColumnBO capBusinessColumnBO = new CAPBusinessColumnBO();
                capBusinessColumnBO.importFromMallMap((Map)httpResult.get("data"));
                data = capBusinessColumnBO.exportToMallMap(1);
            } else if (CAPBusinessEnum.DownloadZipType.TEMPLATE.getType() == type.intValue()) {
                CAPBusinessTemplateBO capBusinessTemplateBO = new CAPBusinessTemplateBO();
                capBusinessTemplateBO.importFromMallMap((Map)httpResult.get("data"));
                data = capBusinessTemplateBO.exportToMallMap(1);
            } else if (CAPBusinessEnum.DownloadZipType.CUSTOM_CTRL.getType() == type.intValue()) {
                CAPBusinessCustomCtrlBO capBusinessCustomCtrlBO = new CAPBusinessCustomCtrlBO();
                capBusinessCustomCtrlBO.importFromMallMap((Map)httpResult.get("data"));
                data = capBusinessCustomCtrlBO.exportToMallMap(1);
            }
            result.success(data);
        } else {
            String message = MallUtil.getMallErrorMessage(httpResult);
            result.error(CODE_REQUEST_ERROR, String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getMallGoods") + message);
        }
        return result;
    }

    public Map<String, Object> getBusinessCustomCtrlList(Integer type, FlipInfo fi) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (type == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "type"));
            return result;
        }
        CAPBusinessEnum.DownloadZipType downloadZipType = CAPBusinessEnum.DownloadZipType.getEnumByType(type);
        if (downloadZipType == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE5), "type"));
            return result;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put(VERSION, "4.3");
        requestParams.put(CAT_ALIAS, downloadZipType.getAlias());
        requestParams.put(PAGE_SIZE, fi.getSize());
        this.getMallRequestList(new CAPBusinessCustomCtrlBO(), requestParams, mapList, fi, result);
        return result;
    }

    public Map<String, Object> getBusinessColumnList(Integer type, Integer platform, FlipInfo fi) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (type == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "type"));
            return result;
        }
        CAPBusinessEnum.ColumnType columnType = CAPBusinessEnum.ColumnType.getEnumByType(type);
        if (columnType == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE5), "type"));
            return result;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put(VERSION, "4.3");
        requestParams.put(CAT_ALIAS, columnType.getAlias());
        requestParams.put(PLATFORM, platform);
        requestParams.put(PAGE_SIZE, fi.getSize());
        this.getMallRequestList(new CAPBusinessColumnBO(), requestParams, mapList, fi, result);
        return result;
    }

    public Map<String, Object> getBusinessTemplateList(Integer templateType, int clientType, FlipInfo fi) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (templateType == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "type"));
            return result;
        }
        CAPBusinessEnum.TemplateType templateTypeEnum = CAPBusinessEnum.TemplateType.getEnumByType(templateType);
        if (templateTypeEnum == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE5), "type"));
            return result;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (!templateType.equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
            List<Map<String, Object>> presetTemplates = CAPTemplateDesignMallService.getPresetTemplates(clientType, templateType);
            fi.setTotal(fi.getTotal() + presetTemplates.size());
            mapList.addAll(presetTemplates);
        }
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put(VERSION, "4.3");
        requestParams.put(PLATFORM, clientType);
        requestParams.put(CAT_ALIAS, templateTypeEnum.getAlias());
        requestParams.put(PAGE_SIZE, fi.getSize());
        this.getMallRequestList(new CAPBusinessTemplateBO(), requestParams, mapList, fi, result);
        return result;
    }

    private void getMallRequestList(AbstractMallBO abstractMallBO, Map<String, Object> requestParams, List<Map<String, Object>> mapList, FlipInfo fi, Map<String, Object> result) {
        try {
            Map<String, Object> requestData = this.sendMallListRequest(requestParams);
            List list = (List)requestData.get(LIST);
            for (Map map : list) {
                abstractMallBO.clear();
                abstractMallBO.importFromMallMap(map);
                mapList.add(abstractMallBO.exportToMallMap(0));
            }
            fi.setTotal(fi.getTotal() + CAPParamUtil.getIntValue(requestData, (String)COUNT));
        }
        catch (BusinessException e) {
            result.put(MESSAGE_TIP, String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getBusinessTemplateList") + e.getMessage());
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put(RESULTS, mapList);
        returnData.put(DATA_COUNT, String.valueOf(fi.getTotal()));
        returnData.put(PAGE_SIZE, String.valueOf(fi.getSize()));
        result.put("data", returnData);
        result.put("code", "1000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
    }

    private Map<String, Object> sendMallListRequest(Map<String, Object> map) throws BusinessException {
        CloudAppDatas ctpCloudAppData = this.mallApi.getBindMallUserData(Long.valueOf(AppContext.currentUserId()));
        if (ctpCloudAppData != null) {
            map.put("access_token", ctpCloudAppData.getAccessToken());
        }
        Map<String, Object> parameterJson = MallUtil.getMallCommonParams(MallEnum.MallAction.LIST, map);
        Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), parameterJson, Map.class);
        if (MallUtil.isRequestSuccess(httpResult)) {
            return (Map)JSONUtil.parseJSONString((String)CAPParamUtil.getString((Map)httpResult, (String)"data"));
        }
        String message = MallUtil.getMallErrorMessage(httpResult);
        throw new BusinessException(message);
    }

    private static List<Map<String, Object>> getPresetTemplates(Integer clientType, Integer templateType) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        String templateFolder = CAPBusinessTemplateUtil.getPresetTemplateFolder(clientType, templateType);
        String presetConfigPath = templateFolder + PRESET_JSON;
        File filePresetConfig = new File(presetConfigPath);
        String presetConfigStr = FileUtil.readFile((File)filePresetConfig);
        if (Strings.isBlank((String)presetConfigStr)) {
            return mapList;
        }
        List configArray = (List)JSONUtil.parseJSONString((String)presetConfigStr);
        if (configArray == null) {
            return mapList;
        }
        String contextPath = SystemEnvironment.getContextPath();
        for (Map map : configArray) {
            map.put(IMG, contextPath + CAPParamUtil.getString((Map)map, (String)IMG));
            map.put(THUMB, contextPath + CAPParamUtil.getString((Map)map, (String)IMG));
            mapList.add(map);
        }
        return mapList;
    }

    public void setMallApi(MallApi mallApi) {
        this.mallApi = mallApi;
    }

    public void setCapDownloadBaseManager(CAPDownloadBaseManager capDownloadBaseManager) {
        this.capDownloadBaseManager = capDownloadBaseManager;
    }

    public void setCapHttpRequestManager(CAPHttpRequestManager capHttpRequestManager) {
        this.capHttpRequestManager = capHttpRequestManager;
    }
}

