/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.ElementAutoMatchParamBean;
import com.seeyon.cap4.template.bean.TemplateEditParamBean;
import com.seeyon.cap4.template.bean.TemplateOperationParamBean;
import com.seeyon.cap4.template.bean.TemplatesParamBean;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessConfigBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessOrgBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessConfigManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateOrgManager;
import com.seeyon.cap4.template.po.CAPBusinessColumn;
import com.seeyon.cap4.template.po.CAPBusinessElement;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.result.TemplateDesignResult;
import com.seeyon.cap4.template.service.AbstractCAPTemplateDesignService;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPTemplateDesignService
extends AbstractCAPTemplateDesignService {
    private static final Log logger = CtpLogFactory.getLog(CAPTemplateDesignService.class);
    private CAPBusinessManager capBusinessManager;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager;
    private CAPBusinessElementManager capBusinessElementManager;
    private CAPBusinessColumnManager capBusinessColumnManager;
    private CAPBusinessConfigManager capBusinessConfigManager;
    private BusinessManager businessManager4;
    private CAP4FormCacheManager cap4FormCacheManager;
    private static final String MESSAGE2 = "cap.template.message.paramNull";
    private static final String MESSAGE12 = "cap.template.design.business.noApp";
    private static final String MESSAGE_QUERY_ERROR = "cap.template.message.exception";
    private static final String CODE_0 = "0";
    private static final String CODE_1 = "1";
    private static final String DEFAULT_STYLE = "cap.template.design.default.style";
    private static final String FLOW_ALL_NAME = "cap.template.design.approval.matters";
    private static final String APP_ALL_FORMS = "cap.template.design.app.allForms";
    private static final String ID = "id";
    private static final String SORT = "sort";
    private static final String CLIENT = "client";
    private static final String TEMPLATE_TYPE_NAME = "templateTypeName";
    private static final String AUTH = "auth";
    private static final String COLUMN_NAME = "columnName";
    private static final String COLUMN_ID = "columnId";
    private static final String TEMPLATE_NAME = "templateName";
    private static final String SOURCE_PACKAGE = "sourcePackage";
    private static final String IS_CONFIG = "isConfig";
    private static final String TEMPLATE = "template";
    private static final String ORG_TYPE = "orgType";
    private static final String ORG_ID = "orgId";
    private static final String CONFIG_TYPES = "configTypes";
    private static final String MOBILE = "mobile";
    private static final String PC = "pc";
    private static final String FORM_ID = "formId";
    private static final String FORM_NAME = "formName";
    private static final String PATH_ID = "pathId";
    private static final String FLOW = "flow";
    private static final String UN_FLOW = "unflow";
    private static final String CAN_CONFIG_WAIT = "canConfigWait";
    private static final String DISPLAY = "display";
    private static final String FORM_FIELDS = "formFields";
    private static final String CONFIGED_FIELDS = "configedFields";
    private static final String FIELD_DISPLAY = "fieldDisplay";
    private static final String FIELD_NAME = "fieldName";
    private static final String TEMPLATE_IDS = "templateIds";

    public TemplateDesignResult autoUpdateTemplate() {
        this.capBusinessTemplateManager.updateTemplateFile(true);
        TemplateDesignResult result = new TemplateDesignResult();
        result.success();
        return result;
    }

    @ValidateRequestParam(notEmpty={"templateIds", "bizId"}, code="1001")
    public TemplateDesignResult autoMatchElementData(ElementAutoMatchParamBean bean) {
        boolean execResult = false;
        try {
            execResult = this.capBusinessElementManager.autoMatchElementData(bean.getBizId(), bean.getTemplateIds());
        }
        catch (BusinessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        TemplateDesignResult result = new TemplateDesignResult();
        if (execResult) {
            result.success();
        } else {
            result.error("1003");
        }
        return result;
    }

    public Map<String, Object> saveElementName(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List data = CAPParamUtil.getParamsListByKey(params, (String)"data");
        if (Strings.isEmpty((Collection)data)) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "data"));
            return result;
        }
        HashMap<Long, Map> id2InputMap = new HashMap<Long, Map>();
        ArrayList<Long> elementIds = new ArrayList<Long>();
        ArrayList<Long> templateIds = new ArrayList<Long>();
        for (Map map : data) {
            Long elementId = Long.valueOf((String)map.get(ID));
            elementIds.add(elementId);
            templateIds.add(Long.valueOf((String)map.get("templateId")));
            id2InputMap.put(elementId, map);
        }
        boolean queryResult = false;
        try {
            List<CAPBusinessElement> capBusinessElements = this.capBusinessElementManager.getCAPBusinessElementsByElementIds(elementIds);
            if (Strings.isEmpty(capBusinessElements)) {
                result.put("code", "1004");
                result.put("message", ResourceUtil.getString((String)"cap.template.message.dataNull"));
                return result;
            }
            for (CAPBusinessElement element : capBusinessElements) {
                Map map = (Map)id2InputMap.get(element.getId());
                if (map == null) continue;
                element.setName((String)map.get("name"));
            }
            queryResult = this.capBusinessElementManager.updateCAPBusinessElements(capBusinessElements);
        }
        catch (BusinessException e) {
            logger.error((Object)e);
        }
        if (queryResult) {
            this.capBusinessTemplateManager.rewriteTemplateConfig(templateIds, true, true);
        }
        return this.fastReturnQueryResult(queryResult, result);
    }

    public Map<String, Object> clearElementDataConfig(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List elementsId = CAPParamUtil.convertParamListStringToLong(params, (String)"data");
        if (elementsId == null || elementsId.size() == 0) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "data"));
            return result;
        }
        boolean queryResult = false;
        try {
            List<CAPBusinessElement> capBusinessElements = this.capBusinessElementManager.getCAPBusinessElementsByElementIds(elementsId);
            if (Strings.isEmpty(capBusinessElements)) {
                result.put("code", "1004");
                result.put("message", ResourceUtil.getString((String)"cap.template.message.dataNull"));
                return result;
            }
            ArrayList<Long> cacheColumnIds = new ArrayList<Long>();
            for (CAPBusinessElement capBusinessElement : capBusinessElements) {
                if (!cacheColumnIds.contains(capBusinessElement.getColumnId())) {
                    cacheColumnIds.add(capBusinessElement.getColumnId());
                }
                capBusinessElement.setDataInfo(null);
            }
            queryResult = this.capBusinessElementManager.updateCAPBusinessElements(capBusinessElements);
        }
        catch (BusinessException e) {
            logger.error((Object)e);
        }
        return this.fastReturnQueryResult(queryResult, result);
    }

    public Map<String, Object> saveFlowFieldConfig(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long pathId = Long.valueOf((String)params.get(PATH_ID));
        List configFields = CAPParamUtil.getParamsListByKey(params, (String)"data");
        if (pathId == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), PATH_ID));
            return result;
        }
        if (configFields == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "data"));
            return result;
        }
        CAPBusinessConfigBO capBusinessConfigBO = this.capBusinessConfigManager.getCAPBusinessConfigBOByPathId(pathId);
        String userId = String.valueOf(AppContext.currentUserId());
        boolean queryResult = false;
        if (capBusinessConfigBO == null) {
            HashMap<String, Object> dataInfo = new HashMap<String, Object>();
            dataInfo.put(CONFIGED_FIELDS, configFields);
            capBusinessConfigBO = new CAPBusinessConfigBO();
            capBusinessConfigBO.setCreateMemberId(userId);
            capBusinessConfigBO.setModifyMemberId(userId);
            capBusinessConfigBO.setDataInfo(dataInfo);
            capBusinessConfigBO.setPathId(String.valueOf(pathId));
            capBusinessConfigBO.setId(String.valueOf(UUIDLong.longUUID()));
            queryResult = this.capBusinessConfigManager.insertCAPBusinessConfigBO(capBusinessConfigBO);
        } else {
            HashMap<String, Object> dataInfo = capBusinessConfigBO.getDataInfo();
            dataInfo = dataInfo == null ? new HashMap<String, Object>() : dataInfo;
            dataInfo.put(CONFIGED_FIELDS, configFields);
            capBusinessConfigBO.setModifyMemberId(userId);
            capBusinessConfigBO.setDataInfo(dataInfo);
            queryResult = this.capBusinessConfigManager.updateCAPBusinessConfigBO(capBusinessConfigBO);
        }
        return this.fastReturnQueryResult(queryResult, result);
    }

    public Map<String, Object> getFlowFieldConfig(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long formId = Long.valueOf((String)params.get(FORM_ID));
        Long pathId = Long.valueOf((String)params.get(PATH_ID));
        if (pathId == null || formId == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "pathId or formId"));
            return result;
        }
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        CAPBusinessConfigBO capBusinessConfigBO = this.capBusinessConfigManager.getCAPBusinessConfigBOByPathId(pathId);
        List configedFields = new ArrayList();
        HashMap<String, Map> configedFieldsObject = new HashMap<String, Map>();
        if (capBusinessConfigBO != null) {
            configedFields = capBusinessConfigBO.getConfigedFields();
            for (Map obj : configedFields) {
                configedFieldsObject.put(CAPParamUtil.getString((Map)obj, (String)FIELD_NAME), obj);
            }
        }
        List formFieldBeans = formBean.getAllFieldBeans();
        ArrayList formFieldArray = new ArrayList();
        List<String> ignoreFields = this.getFlowFieldIgnoreFields();
        for (FormFieldBean formFieldBean : formFieldBeans) {
            if (!formFieldBean.isMasterField() || ignoreFields.contains(formFieldBean.getInputType())) continue;
            HashMap<String, String> jsonObject = new HashMap<String, String>();
            jsonObject.put(FIELD_NAME, formFieldBean.getName());
            jsonObject.put(DISPLAY, formFieldBean.getDisplay());
            Map configedField = (Map)configedFieldsObject.get(formFieldBean.getName());
            jsonObject.put(IS_CONFIG, configedField != null ? CODE_1 : CODE_0);
            if (configedField != null) {
                configedField.put(FIELD_DISPLAY, formFieldBean.getDisplay());
            }
            formFieldArray.add(jsonObject);
        }
        HashMap data = new HashMap();
        data.put(FORM_FIELDS, formFieldArray);
        data.put(CONFIGED_FIELDS, configedFields);
        result.put("code", "1000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        result.put("data", data);
        return result;
    }

    private List<String> getFlowFieldIgnoreFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(FormFieldComEnum.EXTEND_ATTACHMENT.getKey());
        list.add(FormFieldComEnum.EXTEND_IMAGE.getKey());
        list.add(FormFieldComEnum.EXTEND_DOCUMENT.getKey());
        list.add(FormFieldComEnum.MAP_LOCATE.getKey());
        list.add(FormFieldComEnum.MAP_MARKED.getKey());
        list.add(FormFieldComEnum.MAP_PHOTO.getKey());
        return list;
    }

    public Map<String, Object> getUnflowAndFlowTemplates(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long bizId = Long.valueOf((String)params.get("bizId"));
        if (bizId == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "bizId"));
            return result;
        }
        if (!this.capBusinessManager.checkBizOwnerAuth4Template(bizId)) {
            result.put("code", "1201");
            result.put("message", "this user is no auth");
            return result;
        }
        try {
            List<CAPBusinessConfigBO> capBusinessConfigBOS;
            List<FormAppBO> formAppBOS = this.businessManager4.getFormListByBizId(bizId);
            if (formAppBOS == null) {
                result.put("code", "1003");
                result.put("message", ResourceUtil.getString((String)MESSAGE12));
                return result;
            }
            ArrayList unFlowList = new ArrayList();
            ArrayList flowList = new ArrayList();
            HashMap<String, Object> flowAll = new HashMap<String, Object>();
            flowAll.put("name", ResourceUtil.getString((String)FLOW_ALL_NAME));
            flowAll.put(PATH_ID, String.valueOf(bizId));
            flowAll.put("templateType", String.valueOf(CAPBusinessEnum.TemplateType.TP_FLOW.getType()));
            flowAll.put(TEMPLATE_TYPE_NAME, CAPBusinessEnum.TemplateType.TP_FLOW.getName());
            flowAll.put(FORM_ID, String.valueOf(bizId));
            flowAll.put(FORM_NAME, ResourceUtil.getString((String)APP_ALL_FORMS));
            flowAll.put(MOBILE, CAPTemplateDesignService.getCAPBusinessTemplateJSONForFlowOrUnFlow(null));
            flowAll.put(PC, CAPTemplateDesignService.getCAPBusinessTemplateJSONForFlowOrUnFlow(null));
            flowAll.put(CAN_CONFIG_WAIT, CODE_0);
            flowList.add(flowAll);
            HashSet<Long> flowPathIds = new HashSet<Long>();
            for (FormAppBO formAppBO : formAppBOS) {
                FormBean formBean;
                if (Enums.FormType.unFlowForm.getKey() == formAppBO.getSourceType()) {
                    formBean = this.cap4FormCacheManager.getForm(formAppBO.getFormAppmainId());
                    if (formBean != null) {
                        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
                        jsonObject.put("name", formAppBO.getName());
                        jsonObject.put(PATH_ID, String.valueOf(formAppBO.getId()));
                        jsonObject.put("templateType", String.valueOf(CAPBusinessEnum.TemplateType.TP_UNFLOW.getType()));
                        jsonObject.put(TEMPLATE_TYPE_NAME, CAPBusinessEnum.TemplateType.TP_UNFLOW.getName());
                        jsonObject.put(FORM_ID, String.valueOf(formAppBO.getFormAppmainId()));
                        jsonObject.put(FORM_NAME, formBean.getFormName());
                        jsonObject.put(MOBILE, CAPTemplateDesignService.getCAPBusinessTemplateJSONForFlowOrUnFlow(null));
                        jsonObject.put(PC, CAPTemplateDesignService.getCAPBusinessTemplateJSONForFlowOrUnFlow(null));
                        unFlowList.add(jsonObject);
                        continue;
                    }
                    logger.error((Object)("getUnflowAndFlowTemplates is formBean null , unflow , bizId is  " + bizId + " , formId is " + formAppBO.getFormAppmainId()));
                    continue;
                }
                if (Enums.FormType.processesForm.getKey() != formAppBO.getSourceType()) continue;
                formBean = this.cap4FormCacheManager.getForm(formAppBO.getFormAppmainId());
                if (formBean != null) {
                    flowPathIds.add(Long.valueOf(formAppBO.getId()));
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("name", formAppBO.getName());
                    map.put(PATH_ID, String.valueOf(formAppBO.getId()));
                    map.put("templateType", String.valueOf(CAPBusinessEnum.TemplateType.TP_FLOW.getType()));
                    map.put(TEMPLATE_TYPE_NAME, CAPBusinessEnum.TemplateType.TP_FLOW.getName());
                    map.put(FORM_ID, String.valueOf(formAppBO.getFormAppmainId()));
                    map.put(FORM_NAME, formBean.getFormName());
                    map.put(MOBILE, CAPTemplateDesignService.getCAPBusinessTemplateJSONForFlowOrUnFlow(null));
                    map.put(PC, CAPTemplateDesignService.getCAPBusinessTemplateJSONForFlowOrUnFlow(null));
                    map.put(CAN_CONFIG_WAIT, CODE_1);
                    map.put(IS_CONFIG, CODE_0);
                    flowList.add(map);
                    continue;
                }
                logger.error((Object)("getUnflowAndFlowTemplates is formBean null , flow , bizId is  " + bizId + " , formId is " + formAppBO.getFormAppmainId()));
            }
            List<CAPBusinessTemplateBO> capBusinessTemplateBOList = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
            if (capBusinessTemplateBOList != null && capBusinessTemplateBOList.size() > 0) {
                this.addCAPBusinessCustomTemplate(flowList, capBusinessTemplateBOList, CAPBusinessEnum.TemplateType.TP_FLOW.getType());
                this.addCAPBusinessCustomTemplate(unFlowList, capBusinessTemplateBOList, CAPBusinessEnum.TemplateType.TP_UNFLOW.getType());
            }
            if (!flowPathIds.isEmpty() && (capBusinessConfigBOS = this.capBusinessConfigManager.getCAPBusinessConfigBOsByPathIds(flowPathIds)) != null && !capBusinessConfigBOS.isEmpty()) {
                HashMap<String, String> pathIdToConfiged = new HashMap<String, String>();
                for (CAPBusinessConfigBO cAPBusinessConfigBO : capBusinessConfigBOS) {
                    if (cAPBusinessConfigBO.getConfigedFields().size() > 0) {
                        pathIdToConfiged.put(cAPBusinessConfigBO.getPathId(), CODE_1);
                        continue;
                    }
                    pathIdToConfiged.put(cAPBusinessConfigBO.getPathId(), CODE_0);
                }
                for (Map map : flowList) {
                    String configed = (String)pathIdToConfiged.get(String.valueOf(map.get(PATH_ID)));
                    if (configed == null) continue;
                    map.put(IS_CONFIG, configed);
                }
            }
            HashMap data = new HashMap();
            data.put(UN_FLOW, unFlowList);
            data.put(FLOW, flowList);
            result.put("code", "1000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", data);
        }
        catch (BusinessException e) {
            logger.error((Object)e);
            result.put("code", "1003");
            result.put("message", ResourceUtil.getString((String)MESSAGE_QUERY_ERROR));
        }
        return result;
    }

    private void addCAPBusinessCustomTemplate(List list, List<CAPBusinessTemplateBO> capBusinessTemplateBOList, Integer type) {
        for (Map map : list) {
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOList) {
                if (!capBusinessTemplateBO.getPathId().equals(CAPParamUtil.getString((Map)map, (String)PATH_ID)) || !String.valueOf(type).equals(capBusinessTemplateBO.getTemplateType())) continue;
                String key = capBusinessTemplateBO.getClient().equals(String.valueOf(CAPBusinessEnum.Platform.MOBILE.getType())) ? MOBILE : PC;
                map.put(key, CAPTemplateDesignService.getCAPBusinessTemplateJSONForFlowOrUnFlow(capBusinessTemplateBO));
            }
        }
    }

    private static Map<String, Object> getCAPBusinessTemplateJSONForFlowOrUnFlow(CAPBusinessTemplateBO capBusinessTemplateBO) {
        HashMap<String, Object> boObject = new HashMap<String, Object>();
        if (capBusinessTemplateBO == null) {
            boObject.put("goodName", ResourceUtil.getString((String)DEFAULT_STYLE));
        } else {
            boObject.put(ID, String.valueOf(capBusinessTemplateBO.getId()));
            boObject.put("name", capBusinessTemplateBO.getName());
            boObject.put("goodName", Strings.isBlank((String)capBusinessTemplateBO.getGoodName()) ? capBusinessTemplateBO.getName() : capBusinessTemplateBO.getGoodName());
            boObject.put("goodId", String.valueOf(capBusinessTemplateBO.getGoodId()));
        }
        return boObject;
    }

    public Map<String, Object> multiSaveElementConfigType(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map info = (Map)params.get("info");
        List elementsId = CAPParamUtil.convertParamListStringToLong(params, (String)"elementIds");
        if (info == null || Strings.isEmpty((Collection)elementsId)) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "info or elementIds"));
            return result;
        }
        boolean queryResult = false;
        try {
            List<CAPBusinessElement> capBusinessElements = this.capBusinessElementManager.getCAPBusinessElementsByElementIds(elementsId);
            if (capBusinessElements == null) {
                result.put("code", "1004");
                result.put("message", ResourceUtil.getString((String)"cap.template.message.dataNull"));
                return result;
            }
            HashMap jsonObject = new HashMap();
            Iterator it = info.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                jsonObject.put(key, info.get(key));
            }
            ArrayList<Long> cacheColumnIds = new ArrayList<Long>();
            for (CAPBusinessElement capBusinessElement : capBusinessElements) {
                if (!cacheColumnIds.contains(capBusinessElement.getColumnId())) {
                    cacheColumnIds.add(capBusinessElement.getColumnId());
                }
                capBusinessElement.setDataInfo(JSONUtil.toJSONString(jsonObject));
            }
            queryResult = this.capBusinessElementManager.updateCAPBusinessElements(capBusinessElements);
        }
        catch (BusinessException e) {
            logger.error((Object)e);
        }
        return this.fastReturnQueryResult(queryResult, result);
    }

    public Map<String, Object> getElementConfigTypes(Map<String, Object> params) {
        Integer client;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long bizId = params.get("bizId") != null ? Long.valueOf((String)params.get("bizId")) : null;
        Integer type = params.get("type") != null ? Integer.valueOf((String)params.get("type")) : null;
        Integer n = client = params.get(CLIENT) != null ? Integer.valueOf((String)params.get(CLIENT)) : null;
        if (bizId == null || type == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "bizId or type"));
            return result;
        }
        List jsonArray = null;
        try {
            jsonArray = this.capBusinessElementManager.getCAPBusinessDataIds(bizId, type, client);
        }
        catch (BusinessException e) {
            logger.error((Object)e);
            result.put("code", "1003");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getCAPBusinessDataIds"));
            return result;
        }
        result.put("code", "1000");
        result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
        result.put("data", jsonArray);
        return result;
    }

    public Map<String, Object> getElements(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List templateIds = CAPParamUtil.convertParamListStringToLong(params, (String)TEMPLATE_IDS);
        Long bizId = CAPParamUtil.getLong(params, (String)"bizId");
        if (bizId == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "bizId"));
            return result;
        }
        List<CAPBusinessTemplateBO> capBusinessTemplateBOList = null;
        capBusinessTemplateBOList = Strings.isNotEmpty((Collection)templateIds) ? this.capBusinessTemplateManager.getCAPBusinessTemplateBOsByIds(templateIds) : this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        if (Strings.isEmpty(capBusinessTemplateBOList)) {
            result.put("code", "1004");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.dataNull"));
            return result;
        }
        try {
            List<Map<String, Object>> jsonDataArray = this.getClassifyElementsByCAPBusinessTemplateBOList(bizId, capBusinessTemplateBOList);
            result.put("code", "1000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", jsonDataArray);
        }
        catch (BusinessException e) {
            logger.error((Object)e);
            result.put("code", "1003");
            result.put("message", e.getMessage());
        }
        return result;
    }

    public Map<String, Object> getElementsByTemplateIds(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List templateIds = CAPParamUtil.convertParamListStringToLong(params, (String)TEMPLATE_IDS);
        if (Strings.isEmpty((Collection)templateIds)) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), TEMPLATE_IDS));
            return result;
        }
        try {
            List<CAPBusinessTemplateBO> capBusinessTemplateBOList = this.capBusinessTemplateManager.getCAPBusinessTemplateBOsByIds(templateIds);
            List<Map<String, Object>> jsonDataArray = this.getElementsByCAPBusinessTemplateBOList(capBusinessTemplateBOList);
            result.put("code", "1000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", jsonDataArray);
        }
        catch (BusinessException e) {
            logger.error((Object)("getElementsByTemplateIds BusinessException, params=" + params.toString()), (Throwable)e);
            result.put("code", "1003");
            result.put("message", e.getMessage());
        }
        return result;
    }

    public Map<String, Object> getElementsByBizId(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long bizId = null;
        if (params.get("bizId") != null) {
            bizId = Long.valueOf(String.valueOf(params.get("bizId")));
        }
        if (bizId == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "bizId"));
            return result;
        }
        try {
            List<CAPBusinessTemplateBO> capBusinessTemplateBOList = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
            List<Map<String, Object>> jsonDataArray = this.getElementsByCAPBusinessTemplateBOList(capBusinessTemplateBOList);
            result.put("code", "1000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", jsonDataArray);
        }
        catch (BusinessException e) {
            logger.error((Object)e);
            result.put("code", "1003");
            result.put("message", e.getMessage());
        }
        return result;
    }

    private List<CAPBusinessEnum.ColumnType> getAllElementTypeSorts() {
        ArrayList<CAPBusinessEnum.ColumnType> list = new ArrayList<CAPBusinessEnum.ColumnType>();
        list.add(CAPBusinessEnum.ColumnType.MENU_COLLECTION);
        list.add(CAPBusinessEnum.ColumnType.SHORT_CUT);
        list.add(CAPBusinessEnum.ColumnType.BUSINESS_TARGET);
        list.add(CAPBusinessEnum.ColumnType.QUERY_RESULT);
        list.add(CAPBusinessEnum.ColumnType.CACL_RESULT);
        list.add(CAPBusinessEnum.ColumnType.FLOW_LIST);
        list.add(CAPBusinessEnum.ColumnType.UNFLOW_LIST);
        return list;
    }

    private List<Map<String, Object>> getClassifyElementsByCAPBusinessTemplateBOList(Long bizId, List<CAPBusinessTemplateBO> capBusinessTemplateBOList) throws BusinessException {
        ArrayList<Map<String, Object>> jsonDataArray = new ArrayList<Map<String, Object>>();
        HashMap typeMap = new HashMap();
        HashMap<String, HashSet<String>> typeClientMap = new HashMap<String, HashSet<String>>();
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOList) {
            List<CAPBusinessColumnBO> capBusinessColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
            for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOs) {
                List<CAPBusinessElementBO> capBusinessElementBOs = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(Long.valueOf(capBusinessColumnBO.getId()));
                for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOs) {
                    ArrayList<Map<String, Object>> elementList = (ArrayList<Map<String, Object>>)typeMap.get(capBusinessElementBO.getElementType());
                    if (elementList == null) {
                        elementList = new ArrayList<Map<String, Object>>();
                    }
                    Map<String, Object> jsonObject = capBusinessElementBO.exportToMapForDesign();
                    jsonObject.put(COLUMN_NAME, capBusinessColumnBO.getName());
                    jsonObject.put(COLUMN_ID, capBusinessColumnBO.getId());
                    jsonObject.put("templateId", capBusinessTemplateBO.getId());
                    jsonObject.put(TEMPLATE_NAME, capBusinessTemplateBO.getName());
                    jsonObject.put(CLIENT, capBusinessTemplateBO.getClient());
                    jsonObject.put("bizId", capBusinessTemplateBO.getEggId());
                    elementList.add(jsonObject);
                    typeMap.put(capBusinessElementBO.getElementType(), elementList);
                    HashSet<String> typeClientSet = (HashSet<String>)typeClientMap.get(capBusinessElementBO.getElementType());
                    if (typeClientSet == null) {
                        typeClientSet = new HashSet<String>();
                    }
                    typeClientSet.add(capBusinessTemplateBO.getClient());
                    typeClientMap.put(capBusinessElementBO.getElementType(), typeClientSet);
                }
            }
        }
        Iterator iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            List elementList = (List)typeMap.get(iterator.next().toString());
            Collections.sort(elementList, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> argA, Map<String, Object> argB) {
                    Collator collatorInstance = Collator.getInstance(Locale.CHINA);
                    int flag = collatorInstance.compare(CAPParamUtil.getString(argA, (String)CAPTemplateDesignService.COLUMN_NAME), CAPParamUtil.getString(argB, (String)CAPTemplateDesignService.COLUMN_NAME));
                    if (flag == 0) {
                        return collatorInstance.compare(CAPParamUtil.getString(argA, (String)"name"), CAPParamUtil.getString(argB, (String)"name"));
                    }
                    return flag;
                }
            });
        }
        List<CAPBusinessEnum.ColumnType> types = this.getAllElementTypeSorts();
        for (CAPBusinessEnum.ColumnType columnType : types) {
            List elementList = (List)typeMap.get(String.valueOf(columnType.getType()));
            if (elementList == null) continue;
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            jsonObject.put("name", columnType.getName());
            jsonObject.put("elementType", columnType.getType());
            jsonObject.put("data", elementList);
            Set stringSet = (Set)typeClientMap.get(String.valueOf(columnType.getType()));
            for (String client : stringSet) {
                List elementConfigTypes = new ArrayList();
                try {
                    elementConfigTypes = this.capBusinessElementManager.getCAPBusinessDataIds(bizId, columnType.getType(), Integer.valueOf(client));
                }
                catch (BusinessException e) {
                    logger.error((Object)("method getElementConfigTypes is error AND param elementType is " + columnType.getType() + " AND param bizId is " + bizId), (Throwable)e);
                }
                jsonObject.put(CONFIG_TYPES + client, elementConfigTypes);
            }
            jsonDataArray.add(jsonObject);
        }
        return jsonDataArray;
    }

    private List<Map<String, Object>> getElementsByCAPBusinessTemplateBOList(List<CAPBusinessTemplateBO> capBusinessTemplateBOList) throws BusinessException {
        ArrayList<Map<String, Object>> jsonDataArray = new ArrayList<Map<String, Object>>();
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOList) {
            List<CAPBusinessColumnBO> capBusinessColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
            for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOs) {
                List<CAPBusinessElementBO> capBusinessElementBOs = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(Long.valueOf(capBusinessColumnBO.getId()));
                for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOs) {
                    Map<String, Object> jsonObject = capBusinessElementBO.exportToMapForDesign();
                    jsonObject.put(COLUMN_NAME, capBusinessColumnBO.getName());
                    jsonObject.put(COLUMN_ID, capBusinessColumnBO.getId());
                    jsonObject.put(TEMPLATE_NAME, capBusinessTemplateBO.getName());
                    jsonObject.put("templateId", capBusinessTemplateBO.getId());
                    jsonObject.put(SOURCE_PACKAGE, capBusinessTemplateBO.getGoodName());
                    jsonObject.put("bizId", capBusinessTemplateBO.getEggId());
                    jsonObject.put(CLIENT, capBusinessTemplateBO.getClient());
                    jsonDataArray.add(jsonObject);
                }
            }
        }
        return jsonDataArray;
    }

    public Map<String, Object> getTemplateOrgAuth(Long templateId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (templateId == null) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "templateId"));
        } else {
            List<CAPBusinessOrgBO> capBusinessOrgBOs = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByTemplateId(templateId);
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
            for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOs) {
                datas.add(capBusinessOrgBO.exportToSimpleMap());
            }
            result.put("code", "1000");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.success"));
            result.put("data", datas);
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"templateIds"}, code="1001")
    public TemplateDesignResult<List<Map<String, Object>>> multiSaveTemplateOrgAuth(TemplateOperationParamBean bean) {
        ArrayList<CAPBusinessOrgBO> capBusinessOrgBOS = new ArrayList<CAPBusinessOrgBO>();
        Long userId = AppContext.currentUserId();
        TemplateDesignResult<List<Map<String, Object>>> result = new TemplateDesignResult<List<Map<String, Object>>>();
        for (Long templateId : bean.getTemplateIds()) {
            if (!CollectionUtils.isNotEmpty(bean.getData())) continue;
            for (TemplateOperationParamBean.TemplateAuthParamBean obj : bean.getData()) {
                CAPBusinessOrgBO capBusinessOrgBO = new CAPBusinessOrgBO();
                capBusinessOrgBO.setId(String.valueOf(UUIDLong.longUUID()));
                capBusinessOrgBO.setOrgId(String.valueOf(obj.getOrgId()));
                capBusinessOrgBO.setOrgType(String.valueOf(obj.getOrgType()));
                capBusinessOrgBO.setCreateMemberId(String.valueOf(userId));
                capBusinessOrgBO.setTemplateId(String.valueOf(templateId));
                capBusinessOrgBOS.add(capBusinessOrgBO);
            }
        }
        boolean query = this.capBusinessTemplateOrgManager.saveCAPBusinessTemplateOrgs(bean.getTemplateIds(), capBusinessOrgBOS);
        if (query) {
            List<CAPBusinessOrgBO> capBusinessOrgBOList = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByTemplateId(bean.getTemplateIds().get(0));
            ArrayList<Map<String, Object>> authArray = new ArrayList<Map<String, Object>>();
            for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOList) {
                authArray.add(capBusinessOrgBO.exportToSimpleMap());
            }
            result.success(authArray);
        } else {
            result.error("1001");
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"bizId", "templateIds"}, code="1001")
    public TemplateDesignResult multiDeleteTemplate(TemplateOperationParamBean bean) {
        TemplateDesignResult result = new TemplateDesignResult();
        result.error("1001");
        if (!this.capBusinessManager.checkBizOwnerAuth4Template(bean.getBizId())) {
            result.error("1201", "this user is no auth");
            return result;
        }
        List<CAPBusinessTemplate> capBusinessTemplates = this.capBusinessTemplateManager.getCAPBusinessTemplatesByIds(bean.getTemplateIds());
        boolean deleteResult = this.capBusinessTemplateManager.deleteCAPBusinessTemplates(bean.getBizId(), capBusinessTemplates);
        if (deleteResult) {
            result.success();
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"operation", "templateIds", "value"}, code="1001")
    public TemplateDesignResult multiUpdateTemplateSingleField(TemplateOperationParamBean bean) {
        TemplateDesignResult result = new TemplateDesignResult();
        if (!CAPTemplateDesignService.getUpdateTemplateAllowOperation().contains(bean.getOperation())) {
            result.error("1001", ResourceUtil.getString((String)"cap.template.message.denied"));
            return result;
        }
        List<CAPBusinessTemplate> capBusinessTemplates = this.capBusinessTemplateManager.getCAPBusinessTemplatesByIds(bean.getTemplateIds());
        if (CollectionUtils.isEmpty(capBusinessTemplates)) {
            result.error("1004", ResourceUtil.getString((String)"cap.template.message.dataNull"));
        } else {
            try {
                Long modifyMemberId = AppContext.currentUserId();
                HashSet<Long> bizIds = new HashSet<Long>();
                ArrayList<Long> forCacheTemplateIds = new ArrayList<Long>();
                for (CAPBusinessTemplate capBusinessTemplate : capBusinessTemplates) {
                    if ("name".equals(bean.getOperation())) {
                        capBusinessTemplate.setName(bean.getValue());
                    } else if (SORT.equals(bean.getOperation())) {
                        capBusinessTemplate.setSort(Integer.valueOf(bean.getValue()));
                    } else if ("state".equals(bean.getOperation())) {
                        capBusinessTemplate.setState(Integer.valueOf(bean.getValue()));
                    }
                    capBusinessTemplate.setModifyMember(modifyMemberId);
                    bizIds.add(capBusinessTemplate.getEggId());
                    forCacheTemplateIds.add(capBusinessTemplate.getId());
                }
                if (!this.capBusinessManager.checkBizOwnerAuth4Template(bizIds)) {
                    result.error("1201", "this user is no auth");
                    return result;
                }
                boolean execResult = this.capBusinessTemplateManager.updateCAPBusinessTemplates(capBusinessTemplates);
                if (execResult) {
                    ArrayList<Long> idLongs = new ArrayList<Long>();
                    idLongs.addAll(bizIds);
                    this.capBusinessTemplateManager.rewriteTemplateConfig(forCacheTemplateIds, false, false);
                }
                if (execResult) {
                    result.success();
                }
            }
            catch (BusinessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.error("1003", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "multiUpdateTemplateSingleField"));
            }
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"bizId"}, code="1001")
    public TemplateDesignResult<List<Map<String, Object>>> getCAPBusinessTemplates(TemplatesParamBean bean) {
        TemplateDesignResult<List<Map<String, Object>>> result = new TemplateDesignResult<List<Map<String, Object>>>();
        if (bean.getTemplateType() == null) {
            bean.setTemplateType(-1);
        }
        if (!this.capBusinessManager.checkBizOwnerAuth4Template(bean.getBizId())) {
            result.error("1201", "this user is no auth");
            return result;
        }
        ArrayList<Map<String, Object>> jsonArray = new ArrayList<Map<String, Object>>();
        List<CAPBusinessTemplateBO> capBusinessTemplateBOs = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bean.getBizId());
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOs) {
            if (!String.valueOf(bean.getTemplateType()).equals(capBusinessTemplateBO.getTemplateType())) continue;
            Map<String, Object> boObject = capBusinessTemplateBO.exportToMapForDesign();
            String authName = "";
            List<CAPBusinessOrgBO> capBusinessOrgBOS = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
            ArrayList<Map<String, Object>> authArray = new ArrayList<Map<String, Object>>();
            if (Strings.isNotEmpty(capBusinessOrgBOS)) {
                authName = Functions.showOrgEntities(capBusinessOrgBOS, (String)ORG_ID, (String)ORG_TYPE, null);
                for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOS) {
                    authArray.add(capBusinessOrgBO.exportToSimpleMap());
                }
            }
            boObject.put("authName", authName);
            boObject.put(AUTH, authArray);
            jsonArray.add(boObject);
        }
        result.success(jsonArray);
        return result;
    }

    public Map<String, Object> multiUpdateColumnSingleField(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List columnIds = CAPParamUtil.convertParamListStringToLong(params, (String)"columnIds");
        String operation = String.valueOf(params.get("operation"));
        String value = String.valueOf(params.get("value"));
        if (Strings.isBlank((String)operation) || !this.getUpdateColumnAllowOperation().contains(operation)) {
            result.put("code", "1001");
            result.put("message", ResourceUtil.getString((String)"cap.template.message.denied"));
            return result;
        }
        if (Strings.isEmpty((Collection)columnIds)) {
            result.put("code", "1001");
            result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "columnIds"));
            return result;
        }
        try {
            List<CAPBusinessColumn> capBusinessColumns = this.capBusinessColumnManager.getCAPBusinessColumnsByColumnIds(columnIds);
            if (capBusinessColumns == null || capBusinessColumns.size() == 0) {
                result.put("code", "1004");
                result.put("message", String.format(ResourceUtil.getString((String)MESSAGE2), "goodId"));
            } else {
                Long modifyMemberId = AppContext.currentUserId();
                ArrayList<Long> templateIds = new ArrayList<Long>();
                for (CAPBusinessColumn capBusinessColumn : capBusinessColumns) {
                    if (templateIds.contains(capBusinessColumn.getTemplateId())) continue;
                    templateIds.add(capBusinessColumn.getTemplateId());
                }
                List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.capBusinessTemplateManager.getCAPBusinessTemplateBOsByIds(templateIds);
                ArrayList<Long> bizIds = new ArrayList<Long>();
                for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
                    bizIds.add(Long.valueOf(capBusinessTemplateBO.getEggId()));
                }
                if (!this.capBusinessManager.checkBizOwnerAuth4Template(bizIds)) {
                    result.put("code", "1201");
                    result.put("message", "this user is no auth");
                    return result;
                }
                for (CAPBusinessColumn capBusinessColumn : capBusinessColumns) {
                    if ("name".equals(operation)) {
                        capBusinessColumn.setName(value);
                    } else if ("state".equals(operation)) {
                        capBusinessColumn.setState(Integer.valueOf(value));
                    }
                    capBusinessColumn.setModifyMember(modifyMemberId);
                }
                boolean excuResult = this.capBusinessColumnManager.updateCAPBusinessColumns(capBusinessColumns);
                result.put("code", excuResult ? "1000" : "1003");
                result.put("message", excuResult ? ResourceUtil.getString((String)"cap.template.message.success") : ResourceUtil.getString((String)MESSAGE_QUERY_ERROR));
                if (excuResult) {
                    this.capBusinessTemplateManager.rewriteTemplateConfig(templateIds, true, false);
                }
            }
        }
        catch (BusinessException e) {
            logger.error((Object)e);
            result.put("code", "cap.template.message.methodError");
            result.put("message", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "multiUpdateColumnSingleField"));
            return result;
        }
        return result;
    }

    @ValidateRequestParam(notEmpty={"templateIds"}, code="1001")
    public TemplateDesignResult<List> getColumnsByTemplateIds(TemplateEditParamBean bean) {
        TemplateDesignResult<List> result = new TemplateDesignResult<List>();
        try {
            List<CAPBusinessTemplateBO> capBusinessTemplateBOList = this.capBusinessTemplateManager.getCAPBusinessTemplateBOsByIds(bean.getTemplateIds());
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOList) {
                List<CAPBusinessColumnBO> capBusinessColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
                Collections.sort(capBusinessColumnBOs, new CAPBusinessColumnBO.SortCreateDateComparator());
                for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOs) {
                    Map<String, Object> boObject = capBusinessColumnBO.exportToMapForDesign();
                    HashMap<String, String> templateObject = new HashMap<String, String>();
                    templateObject.put("name", capBusinessTemplateBO.getName());
                    templateObject.put(CLIENT, capBusinessTemplateBO.getClient());
                    templateObject.put("goodName", capBusinessTemplateBO.getGoodName());
                    templateObject.put("goodId", capBusinessTemplateBO.getGoodId());
                    boObject.put(TEMPLATE, templateObject);
                    list.add(boObject);
                }
            }
            result.success(list);
        }
        catch (BusinessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.error("1003", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getColumnsByTemplateIds"));
        }
        return result;
    }

    private static List<String> getUpdateTemplateAllowOperation() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("name");
        result.add(SORT);
        result.add("state");
        return result;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapBusinessTemplateOrgManager(CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager) {
        this.capBusinessTemplateOrgManager = capBusinessTemplateOrgManager;
    }

    public void setCapBusinessElementManager(CAPBusinessElementManager capBusinessElementManager) {
        this.capBusinessElementManager = capBusinessElementManager;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }

    public void setCapBusinessConfigManager(CAPBusinessConfigManager capBusinessConfigManager) {
        this.capBusinessConfigManager = capBusinessConfigManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCapBusinessManager(CAPBusinessManager capBusinessManager) {
        this.capBusinessManager = capBusinessManager;
    }
}

