/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.modules.event.UnflowFormBindAuthDeleteEvent;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.template.event.TemplateDeleteEvent;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.events.RemoveReportEvent;
import com.seeyon.ctp.util.annotation.ListenEvent;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPTemplateEventService {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPTemplateEventService.class);
    private CAPBusinessTemplateManager capBusinessTemplateManager;

    @ListenEvent(event=RemoveReportEvent.class, async=true)
    public void onDeleteReportEvent(RemoveReportEvent event) {
        if (event != null) {
            LOGGER.info((Object)("onDeleteFlowTemplateEvent " + event.getDesign().getId()));
            Integer type = this.getDesignType(event.getDesign().getDesignType().name());
            this.deleteTemplate(event.getDesign().getId(), type);
        }
    }

    @ListenEvent(event=TemplateDeleteEvent.class, async=true)
    public void onDeleteFlowTemplateEvent(TemplateDeleteEvent event) {
        if (event != null) {
            LOGGER.info((Object)("onDeleteFlowTemplateEvent " + event.getTemplateId()));
            this.deleteTemplate(event.getTemplateId(), CAPBusinessEnum.TemplateType.TP_FLOW.getType());
        }
    }

    @ListenEvent(event=UnflowFormBindAuthDeleteEvent.class, async=true)
    public void onDeleteUnFlowBindEvent(UnflowFormBindAuthDeleteEvent event) {
        if (event != null) {
            List<CAPBusinessTemplate> list;
            LOGGER.info((Object)("onDeleteUnFlowBindEvent " + event.getFormId() + "," + event.getBindAuthId()));
            if (CollectionUtils.isNotEmpty((Collection)event.getBindAuthId()) && CollectionUtils.isNotEmpty(list = this.capBusinessTemplateManager.getCAPBusinessTemplateByPathIdsAndType(event.getBindAuthId(), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType()))) {
                this.capBusinessTemplateManager.deleteCAPBusinessTemplates(list.get(0).getEggId(), list);
            }
        }
    }

    private void deleteTemplate(Long pathId, Integer templateType) {
        List<CAPBusinessTemplate> list = this.capBusinessTemplateManager.getCAPBusinessTemplateByPathIdAndType(pathId, templateType);
        if (CollectionUtils.isNotEmpty(list)) {
            this.capBusinessTemplateManager.deleteCAPBusinessTemplates(list.get(0).getEggId(), list);
        }
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    private Integer getDesignType(String designType) {
        Integer type = null;
        if (ReportConstants.DesignType.QUERY.name().equals(designType)) {
            type = CAPBusinessEnum.TemplateType.TP_QUERY.getType();
        } else if (ReportConstants.DesignType.MULTSTATS.name().equals(designType) || ReportConstants.DesignType.STATISTICS.name().equals(designType) || ReportConstants.DesignType.SCHEDULEDSTATS.name().equals(designType)) {
            type = CAPBusinessEnum.TemplateType.TP_CACL.getType();
        }
        return type;
    }
}

