/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.service;

import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.template.annotation.ValidateRequestParam;
import com.seeyon.cap4.template.bean.AbstractParamBean;
import com.seeyon.cap4.template.exception.RequestParamsException;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.aop.support.AopUtils;

public class ServiceProxy {
    private static final Log LOGGER = CtpLogFactory.getLog(ServiceProxy.class);

    public static Object invoke(Object service, String methodName, Map<String, Object> params) throws RequestParamsException {
        try {
            Method[] methods;
            for (Method method : methods = (AopUtils.isAopProxy((Object)service) ? AopUtils.getTargetClass((Object)service) : service.getClass()).getMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
                return ServiceProxy.execute(service, method, params, null);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e);
            throw ServiceProxy.exception(e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)e);
            throw ServiceProxy.exception(e);
        }
        return null;
    }

    public static Object invoke(Object service, String methodName, Map<String, Object> params, Class<? extends AbstractParamBean> paramClass) throws RequestParamsException {
        try {
            Method method = (AopUtils.isAopProxy((Object)service) ? AopUtils.getTargetClass((Object)service) : service.getClass()).getMethod(methodName, paramClass);
            return ServiceProxy.execute(service, method, params, paramClass);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e);
            throw ServiceProxy.exception(e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)e);
            throw ServiceProxy.exception(e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)e);
            throw ServiceProxy.exception(e);
        }
    }

    private static RequestParamsException exception(Throwable e) {
        return new RequestParamsException(ResourceUtil.getString((String)"cap.template.message.exception"), "2001", e);
    }

    private static <T> Object execute(Object service, Method method, Map<String, Object> params, Class<T> paramClass) throws IllegalAccessException, InvocationTargetException {
        if (method.isAnnotationPresent(ValidateRequestParam.class)) {
            ServiceProxy.doValidateFilter(params, method.getAnnotation(ValidateRequestParam.class));
        }
        return ServiceProxy.invokeMethod(service, method, params, paramClass);
    }

    private static <T> Object invokeMethod(Object service, Method method, Map<String, Object> params, Class<T> paramClass) throws IllegalAccessException, InvocationTargetException {
        Class<Object> clazz = paramClass = paramClass == null ? method.getParameterTypes()[0] : paramClass;
        if (!paramClass.getName().equals(Map.class.getName())) {
            T bean = AbstractParamBean.convert(params, paramClass);
            return method.invoke(service, bean);
        }
        return method.invoke(service, params);
    }

    private static void doValidateFilter(Map<String, Object> map, ValidateRequestParam annotation) throws RequestParamsException {
        String message = Strings.isEmpty((String)annotation.message()) ? ResourceUtil.getString((String)"cap.template.message.paramNull") : annotation.message();
        for (String key : annotation.notNull()) {
            if (Strings.isBlank((String)key) || map.get(key) != null) continue;
            throw new RequestParamsException(String.format(message, key), annotation.code());
        }
        for (String key : annotation.notEmpty()) {
            Object data;
            if (Strings.isBlank((String)key) || (data = map.get(key)) != null && (!(data instanceof String) || !Strings.isEmpty((String)((String)data))) && (!(data instanceof List) || !Strings.isEmpty((Collection)((List)data)))) continue;
            throw new RequestParamsException(String.format(message, key), annotation.code());
        }
        if (Strings.isNotBlank((String)annotation.validateCacheBeanKey())) {
            String id = (String)map.get(annotation.validateCacheBeanKey());
            if (id == null) {
                throw new RequestParamsException(String.format(message, annotation.validateCacheBeanKey()), annotation.code());
            }
            CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
            if (cap4FormManager.getSessioMasterDataBean(Long.valueOf(id)) == null) {
                throw new RequestParamsException(ResourceUtil.getString((String)"cap.template.form.data.message.cacheDisabled"), "2010");
            }
        }
    }
}

