/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.thread;

import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPAutoUpdateFrameRunnable
implements Runnable {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPAutoUpdateFrameRunnable.class);
    private static final String FOLDER = "folder";
    private static final String FRAME = "frame";
    private Map<String, Object> folderMap;
    private Boolean copyToRuntime;
    private File autoFolder;

    public CAPAutoUpdateFrameRunnable(Map<String, Object> folderMap, Boolean copyToRuntime, File autoFolder) {
        this.folderMap = folderMap;
        this.copyToRuntime = copyToRuntime;
        this.autoFolder = autoFolder;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        Map map = (Map)this.folderMap.get(FRAME);
        String folder = String.valueOf(map.get(FOLDER));
        File updateFolder = new File(this.autoFolder, folder);
        if (!updateFolder.exists()) {
            LOGGER.error((Object)("CAPTemplateFrameUpdate\uff0c\u6765\u6e90\u76ee\u5f55\u4e0d\u5b58\u5728 " + this.folderMap.toString()));
        } else {
            String pcBaseBusinessPath = CAPBusinessTemplateUtil.getBaseCustomTemplateClientAndTypeFolder(CAPBusinessEnum.Platform.PC.getType(), CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType());
            File businessFolder = new File(pcBaseBusinessPath);
            if (!businessFolder.exists()) {
                LOGGER.info((Object)("CAPTemplateFrameUpdate\uff0cbusinessFolder not exits " + businessFolder.getAbsolutePath()));
                return;
            }
            File[] files = businessFolder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getName().equals(FRAME)) {
                    FileUtil.deleteDirectory((File)files[i]);
                    LOGGER.info((Object)("CAPTemplateFrameUpdate\uff0cdelete dirty data " + files[i].getAbsolutePath()));
                    continue;
                }
                File frameFile = new File(files[i], FRAME);
                if (!frameFile.exists()) {
                    LOGGER.info((Object)("CAPTemplateFrameUpdate\uff0cframe not exits " + frameFile.getAbsolutePath()));
                    continue;
                }
                String businessId = files[i].getName();
                try {
                    String backPath = CAPBusinessTemplateUtil.getBaseTemplateUpdateBackupFolder() + DateUtil.currentDateString((String)"yyyy-MM-dd") + File.separator + DateUtil.currentDateString((String)"HHmmss") + "_frame_" + businessId;
                    FileUtil.copyDirectory((File)frameFile, (File)new File(backPath));
                    LOGGER.info((Object)("CAPTemplateFrameUpdate\uff0c\u5907\u4efdbase/frame\u76ee\u5f55 " + businessId + " path: " + backPath));
                    FileUtil.copyDirectory((File)updateFolder, (File)frameFile);
                    LOGGER.info((Object)("CAPTemplateFrameUpdate\uff0cupdate copy frame, src " + updateFolder.getAbsolutePath() + " , dest " + frameFile.getAbsolutePath()));
                    if (!this.copyToRuntime.booleanValue()) continue;
                    String pcRuntimeBusinessPath = CAPBusinessTemplateUtil.getRuntimeCustomTemplateClientAndTypeFolder(CAPBusinessEnum.Platform.PC.getType(), CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType());
                    File f = new File(pcRuntimeBusinessPath + businessId + File.separator + FRAME);
                    FileUtil.copyDirectory((File)frameFile, (File)f);
                    LOGGER.info((Object)("CAPTemplateFrameUpdate\uff0ccopy to runtime src " + frameFile.getAbsolutePath() + " , dest " + f.getAbsolutePath()));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        LOGGER.info((Object)("CAPTemplateFrameUpdate\uff0c\u6765\u6e90\u76ee\u5f55" + folder + " use " + (System.currentTimeMillis() - startTime) + " MS"));
    }
}

