/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.thread;

import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.CAPBuildM3Util;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.vo.CAPBuildTemplateVO;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPAutoUpdateTemplateRunnable
implements Runnable {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPAutoUpdateTemplateRunnable.class);
    private static final String FOLDER = "folder";
    private CAPBusinessTemplate template;
    private Map<String, Object> folderMap;
    private Boolean copyToRuntime;
    private File autoFolder;

    public CAPAutoUpdateTemplateRunnable(CAPBusinessTemplate template, Map<String, Object> folderMap, Boolean copyToRuntime, File autoFolder) {
        this.template = template;
        this.folderMap = folderMap;
        this.copyToRuntime = copyToRuntime;
        this.autoFolder = autoFolder;
    }

    @Override
    public void run() {
        if (this.template == null || this.folderMap == null) {
            LOGGER.error((Object)"CAPTemplateUpdate template or folderMap is null");
            return;
        }
        String templateStr = this.template.getGoodId() + " " + this.template.getId() + " " + this.template.getName();
        Map map = (Map)this.folderMap.get(String.valueOf(this.template.getGoodId()));
        String folder = String.valueOf(map.get(FOLDER));
        LOGGER.info((Object)("CAPTemplateUpdate" + templateStr + " \u5f00\u59cb\uff0c\u6765\u6e90\u76ee\u5f55 " + folder));
        long startTime = System.currentTimeMillis();
        try {
            File updateFolder = new File(this.autoFolder, folder);
            File baseFolder = new File(CAPBusinessTemplateUtil.getTemplatePath("base", this.template, false));
            if (!updateFolder.exists()) {
                LOGGER.error((Object)("CAPTemplateUpdate " + this.template.getId() + "\uff0c\u76ee\u5f55\u4e0d\u5b58\u5728 " + this.folderMap.toString()));
            } else {
                this.backUpBaseTemplate(this.template);
                this.clearBaseFileByUpdate(baseFolder);
                FileUtil.copyDirectory((File)updateFolder, (File)baseFolder);
                LOGGER.error((Object)("CAPTemplateUpdate update copy to base, src " + updateFolder.getAbsolutePath() + " , dest " + baseFolder.getAbsolutePath()));
                if (this.template.getClient().intValue() == CAPBusinessEnum.Platform.MOBILE.getType()) {
                    ArrayList<CAPBuildTemplateVO> buildVos = new ArrayList<CAPBuildTemplateVO>();
                    buildVos.add(new CAPBuildTemplateVO(this.template.getEggId(), this.template.getId(), this.template.getTemplateType(), this.template.getClient(), this.template.getPathId()));
                    CAPBuildM3Util.buildCAPTemplate(buildVos, null);
                }
            }
            if (this.copyToRuntime.booleanValue()) {
                File runtimeFolder = new File(CAPBusinessTemplateUtil.getTemplatePath("runtime", this.template, false));
                FileUtil.deleteDirectory((File)runtimeFolder);
                LOGGER.info((Object)("CAPTemplateUpdate delete runtimeFolder " + runtimeFolder.getAbsolutePath()));
                FileUtil.copyDirectory((File)baseFolder, (File)runtimeFolder);
                LOGGER.info((Object)("CAPTemplateUpdate base copy to runtime, src " + baseFolder.getAbsolutePath() + " , dest " + runtimeFolder.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        LOGGER.info((Object)("CAPTemplateUpdate " + templateStr + " use " + (System.currentTimeMillis() - startTime) + " MS"));
    }

    private void clearBaseFileByUpdate(File folder) {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.clearBaseFileByUpdate(files[i]);
                continue;
            }
            String suffix = files[i].getName().substring(files[i].getName().lastIndexOf(".") + 1);
            if ("json".equals(suffix)) continue;
            FileUtil.deleteFile((File)files[i]);
        }
        if (folder.listFiles().length == 0) {
            FileUtil.deleteDirectory((File)folder);
        }
    }

    private void backUpBaseTemplate(CAPBusinessTemplate template) throws Exception {
        String basePath = CAPBusinessTemplateUtil.getTemplatePath("base", template, false);
        String backPath = CAPBusinessTemplateUtil.getBaseTemplateUpdateBackupFolder() + DateUtil.currentDateString((String)"yyyy-MM-dd") + File.separator + DateUtil.currentDateString((String)"HHmmss") + "_" + template.getId();
        FileUtil.copyDirectory((String)basePath, (String)backPath);
        LOGGER.info((Object)("CAP4\u5347\u7ea7\u6a21\u677f\u5907\u4efdBase\u76ee\u5f55 " + template.getId() + " " + template.getName() + " path: " + backPath));
    }
}

