/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.thread;

import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import org.apache.commons.logging.Log;

public class CAPBackupTemplateFileThread
extends Thread {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBackupTemplateFileThread.class);
    private Long templateId;
    private String savePath;
    private String saveFileName;

    public CAPBackupTemplateFileThread(Long templateId, String savePath, String saveFileName) {
        this.templateId = templateId;
        this.savePath = savePath;
        this.saveFileName = saveFileName;
    }

    @Override
    public void run() {
        LOGGER.info((Object)("backup template file templateId " + this.templateId + " , saveFileName " + this.saveFileName));
        LOGGER.info((Object)("backup template file savePath " + this.savePath));
        long startTime = System.currentTimeMillis();
        FileUtil.deleteFile((String)(this.savePath + File.separator + this.saveFileName + ".zip"));
        FileUtil.deleteFile((String)(this.savePath + File.separator + this.saveFileName + ".json"));
        CAPBusinessTemplateManager capBusinessTemplateManager = (CAPBusinessTemplateManager)AppContext.getBean((String)"capBusinessTemplateManager");
        try {
            capBusinessTemplateManager.zipTemplateFileWithData(this.templateId, this.savePath, this.saveFileName);
        }
        catch (BusinessException e) {
            LOGGER.info((Object)"back thread is exception", (Throwable)e);
        }
        LOGGER.info((Object)("backup template file " + this.templateId + " use time " + (System.currentTimeMillis() - startTime)));
    }
}

