/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.thread;

import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessTemplate4EditManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;

public class CAPDeleteTemplateRunnable
implements Runnable {
    private static final Log logger = CtpLogFactory.getLog(CAPDeleteTemplateRunnable.class);
    private List<CAPBusinessTemplate> capBusinessTemplates;
    private Long bizId;

    public CAPDeleteTemplateRunnable(List<CAPBusinessTemplate> capBusinessTemplates, Long bizId) {
        this.capBusinessTemplates = capBusinessTemplates;
        this.bizId = bizId;
    }

    @Override
    public void run() {
        if (this.capBusinessTemplates != null && !this.capBusinessTemplates.isEmpty()) {
            HashSet<Integer> clientSet = new HashSet<Integer>();
            CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager = (CAPBusinessTemplate4EditManager)AppContext.getBean((String)"capBusinessTemplate4EditManager");
            for (CAPBusinessTemplate capBusinessTemplate : this.capBusinessTemplates) {
                if (capBusinessTemplate == null) continue;
                this.deleteTemplateFile(capBusinessTemplate);
                clientSet.add(capBusinessTemplate.getClient());
                if (capBusinessTemplate.getTemplateType().intValue() != CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() || capBusinessTemplate.getFrameType().intValue() != CAPBusinessEnum.TemplateFrameType.NO_NEED_FRAME.getType()) continue;
                this.deleteTemplateInitialBackup(String.valueOf(capBusinessTemplate.getId()));
                String runtimeEditFolder = CAPBusinessTemplateUtil.getTemplatePath("runtime", capBusinessTemplate, true);
                boolean runtimeEditResult = FileUtil.deleteDirectory((String)runtimeEditFolder);
                logger.info((Object)("delete custom template runtime edit result: " + runtimeEditResult + ", path: " + runtimeEditFolder));
                capBusinessTemplate4EditManager.clearEditableBackupFile(capBusinessTemplate);
            }
            if (this.bizId != null) {
                Iterator iterator = clientSet.iterator();
                while (iterator.hasNext()) {
                    int clientType = (Integer)iterator.next();
                    CAPBusinessUtil.deleteTemplateFrame(this.bizId, clientType);
                }
            }
        }
    }

    private boolean deleteTemplateFile(CAPBusinessTemplate capBusinessTemplate) {
        if (capBusinessTemplate == null) {
            return false;
        }
        String basePath = CAPBusinessTemplateUtil.getTemplatePath("base", capBusinessTemplate, false);
        String runtimePath = CAPBusinessTemplateUtil.getTemplatePath("runtime", capBusinessTemplate, false);
        boolean runtimeResult = FileUtil.deleteDirectory((String)runtimePath);
        boolean baseResult = FileUtil.deleteDirectory((String)basePath);
        logger.info((Object)("delete custom template runtime result: " + runtimeResult + ", path: " + runtimePath));
        logger.info((Object)("delete custom template base result: " + baseResult + ", path: " + basePath));
        return true;
    }

    private void deleteTemplateInitialBackup(String fileName) {
        String filePath = CAPBusinessTemplateUtil.getBaseTemplateInitialBackupFolder() + fileName + ".zip";
        FileUtil.deleteFile((String)filePath);
        logger.info((Object)("deleteTemplateInitialBackup " + filePath));
    }
}

