/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.thread;

import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;

public class CAPSystemInitTemplateRunnable
implements Runnable {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPSystemInitTemplateRunnable.class);
    private Integer clientType;
    private Integer templateType;
    private Set<String> updatedFolders;
    private CountDownLatch countDownLatch;

    public CAPSystemInitTemplateRunnable(Integer clientType, Integer templateType, Set<String> updatedFolders) {
        this(clientType, templateType, updatedFolders, null);
    }

    public CAPSystemInitTemplateRunnable(Integer clientType, Integer templateType, Set<String> updatedFolders, CountDownLatch countDownLatch) {
        this.clientType = clientType;
        this.templateType = templateType;
        this.updatedFolders = updatedFolders;
        this.countDownLatch = countDownLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            LOGGER.info((Object)(this.getLogBefore() + " updatedFolders " + (this.updatedFolders == null ? "null" : this.updatedFolders.toString())));
            this.initCopyFile();
        }
        catch (Exception e) {
            LOGGER.error((Object)(this.getLogBefore() + " IOException " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
        LOGGER.info((Object)(this.getLogBefore() + " use " + (System.currentTimeMillis() - startTime) + " MS"));
    }

    private String getLogBefore() {
        return "CAPTemplateCopy," + this.clientType + "," + this.templateType + ",";
    }

    private String getLogBaseTypePath(String path) {
        return this.getLogBefore() + "base to runtime, baseTypePath " + path + ", ";
    }

    private void initCopyFile() throws Exception {
        File childFile;
        int i;
        String baseTypePath = CAPBusinessTemplateUtil.getBaseCustomTemplateClientAndTypeFolder(this.clientType, this.templateType);
        String runtimeTypePath = CAPBusinessTemplateUtil.getRuntimeCustomTemplateClientAndTypeFolder(this.clientType, this.templateType);
        File baseTypeFile = new File(baseTypePath);
        File runtimeTypeFile = new File(runtimeTypePath);
        LOGGER.info((Object)(this.getLogBefore() + "start base\uff1a" + baseTypePath + " , runtime\uff1a" + runtimeTypePath));
        if (runtimeTypeFile.exists()) {
            String[] runtimeChildFileNames = runtimeTypeFile.list();
            if (runtimeChildFileNames == null) {
                return;
            }
            for (i = 0; i < runtimeChildFileNames.length; ++i) {
                if (Strings.isBlank((String)runtimeChildFileNames[i])) continue;
                childFile = new File(runtimeTypeFile, runtimeChildFileNames[i]);
                if (childFile.isDirectory()) {
                    this.clearEditFile(childFile);
                    if (CAPSystemInitTemplateRunnable.isUUIDLong(runtimeChildFileNames[i])) continue;
                    File toFile = new File(baseTypeFile, runtimeChildFileNames[i]);
                    if (toFile.exists()) {
                        FileUtil.deleteDirectory((File)toFile);
                        LOGGER.info((Object)(this.getLogBefore() + "runtime to base, delete exits " + toFile.getAbsolutePath()));
                    }
                    FileUtil.copyDirectory((File)childFile, (File)toFile);
                    LOGGER.info((Object)(this.getLogBefore() + "runtime to base, copy src " + childFile.getAbsolutePath() + " , dest " + toFile.getAbsolutePath()));
                    continue;
                }
                File f = new File(baseTypeFile, runtimeChildFileNames[i]);
                FileUtil.copyDirectory((File)childFile, (File)f);
                LOGGER.info((Object)(this.getLogBefore() + "runtime to base, copy src " + childFile.getAbsolutePath() + " , dest " + f.getAbsolutePath()));
            }
        }
        if (!baseTypeFile.exists()) {
            LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + " not exits"));
            return;
        }
        Object[] baseChildFileNames = baseTypeFile.list();
        if (baseChildFileNames == null) {
            LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + " baseChildFileNames is null"));
            return;
        }
        LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "length " + baseChildFileNames.length + ", " + Arrays.toString(baseChildFileNames)));
        for (i = 0; i < baseChildFileNames.length; ++i) {
            if (Strings.isBlank((String)baseChildFileNames[i])) {
                LOGGER.error((Object)(this.getLogBaseTypePath(baseTypePath) + "foreach is blank " + i + " " + (String)baseChildFileNames[i]));
                continue;
            }
            childFile = new File(baseTypeFile, (String)baseChildFileNames[i]);
            if (!childFile.exists()) {
                LOGGER.error((Object)(this.getLogBaseTypePath(baseTypePath) + "foreach childFile not exits " + i + " " + childFile.getAbsolutePath()));
                continue;
            }
            if (childFile.isDirectory() && CAPSystemInitTemplateRunnable.isUUIDLong((String)baseChildFileNames[i])) {
                this.clearEditFile(childFile);
                if (this.templateType.intValue() == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) {
                    Object[] childFiles = childFile.list();
                    if (childFiles == null) {
                        LOGGER.error((Object)(this.getLogBaseTypePath(baseTypePath) + "foreach business childFiles is null !" + childFile.getAbsolutePath()));
                        continue;
                    }
                    LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "foreach business childFile " + childFile.getAbsolutePath() + " , length " + childFiles.length + ", files " + Arrays.toString(childFiles)));
                    for (int cf = 0; cf < childFiles.length; ++cf) {
                        if (this.ignoreCopyToRuntime((String)childFiles[cf])) {
                            LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "ignore " + childFile.getAbsolutePath() + File.separator + (String)childFiles[cf]));
                            continue;
                        }
                        File srcFile = new File(childFile, (String)childFiles[cf]);
                        if (!srcFile.exists()) {
                            LOGGER.error((Object)(this.getLogBaseTypePath(baseTypePath) + "base src not exits " + srcFile.getAbsolutePath()));
                            continue;
                        }
                        File dstFile = new File(runtimeTypeFile, (String)baseChildFileNames[i] + File.separator + (String)childFiles[cf]);
                        if (dstFile.exists()) {
                            FileUtil.deleteDirectory((File)dstFile);
                            LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "delete exits dest " + dstFile.getAbsolutePath()));
                        }
                        FileUtil.copyDirectory((File)srcFile, (File)dstFile);
                        LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "index copy src " + srcFile.getAbsolutePath() + " , dest " + dstFile.getAbsolutePath()));
                    }
                    continue;
                }
                if (this.ignoreCopyToRuntime((String)baseChildFileNames[i])) {
                    LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "ignore " + childFile.getAbsolutePath() + File.separator + (String)baseChildFileNames[i]));
                    continue;
                }
                File dstFile = new File(runtimeTypeFile, (String)baseChildFileNames[i]);
                if (dstFile.exists()) {
                    FileUtil.deleteDirectory((File)dstFile);
                    LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "delete exits dest " + dstFile.getAbsolutePath()));
                }
                FileUtil.copyDirectory((File)childFile, (File)dstFile);
                LOGGER.info((Object)(this.getLogBaseTypePath(baseTypePath) + "other copy src " + childFile.getAbsolutePath() + " , dest " + dstFile.getAbsolutePath()));
                continue;
            }
            LOGGER.error((Object)(this.getLogBaseTypePath(baseTypePath) + "is not directory or is not uuid !" + (String)baseChildFileNames[i]));
        }
    }

    private boolean ignoreCopyToRuntime(String folderName) {
        return this.updatedFolders != null && this.updatedFolders.contains(folderName);
    }

    private void clearEditFile(File businessFile) {
        if (this.templateType.intValue() == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) {
            String[] childFiles = businessFile.list();
            for (int i = 0; i < childFiles.length; ++i) {
                if (childFiles[i].indexOf("_edit") <= 0 && childFiles[i].indexOf("_rename") <= 0) continue;
                FileUtil.deleteDirectory((File)new File(businessFile, childFiles[i]));
                LOGGER.info((Object)(this.getLogBefore() + "clear edit file, delete 1 " + businessFile.getAbsolutePath()));
            }
            CAPBusinessTemplateUtil.clearMacOSFile(businessFile);
            if (businessFile.list().length == 0) {
                FileUtil.deleteDirectory((File)businessFile);
                LOGGER.info((Object)(this.getLogBefore() + "clear edit file, delete 2 " + businessFile.getAbsolutePath()));
            }
        }
    }

    private static boolean isUUIDLong(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() <= 5) {
            return false;
        }
        try {
            long v = Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("isUUIDLong " + e.getMessage() + " " + str));
            return false;
        }
    }
}

