/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CAPAttachmentUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPAttachmentUtil.class);

    public static Long copyAttachment(FormDataMasterBean formDataMasterBean, FormFieldBean formFieldBean, Long newReference, Long newSubReference, List<Attachment> attachments, boolean saveDb) {
        AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
        FileManager fileManager = (FileManager)AppContext.getBean((String)"fileManager");
        if (Strings.isEmpty(attachments)) {
            return newSubReference;
        }
        try {
            if (!formFieldBean.isMapPhoto() && newSubReference == null) {
                Object value = formDataMasterBean.getFieldValue(formFieldBean.getName());
                Long l = newSubReference = value == null ? null : Long.valueOf(String.valueOf(value));
                if (newSubReference == null) {
                    newSubReference = UUIDLong.longUUID();
                }
            }
            Date now = new Date();
            ArrayList<Attachment> newAttachments = new ArrayList<Attachment>();
            for (Attachment attachment : attachments) {
                Long newFileId;
                Attachment newAttachment = (Attachment)attachment.clone();
                if (attachment.getType().intValue() != Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal() && attachment.getType().intValue() != Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal()) {
                    V3XFile file = fileManager.clone(attachment.getFileUrl(), !saveDb);
                    newFileId = file.getId();
                } else {
                    newFileId = attachment.getFileUrl();
                }
                newAttachment.setNewId();
                newAttachment.setFileUrl(newFileId);
                newAttachment.setReference(newReference);
                newAttachment.setSubReference(newSubReference);
                newAttachment.setCreatedate(now);
                newAttachment.setCategory(Integer.valueOf(ApplicationCategoryEnum.cap4Form.getKey()));
                newAttachments.add(newAttachment);
            }
            if (saveDb) {
                attachmentManager.create(newAttachments);
            } else {
                formDataMasterBean.putSessionAttachments(String.valueOf(newSubReference), newAttachments);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"copyAttachment exception ", (Throwable)e);
            newSubReference = null;
        }
        return newSubReference;
    }

    public static Long copyAttachment(FormDataMasterBean formDataMasterBean, FormFieldBean formFieldBean, Long subReference, Long newReference, Long newSubReference, boolean saveDb) {
        if (formFieldBean.isAttachment() && subReference != null) {
            AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
            ArrayList<Long> subReferences = new ArrayList<Long>();
            subReferences.add(subReference);
            List attachments = attachmentManager.getBySubReference(subReferences);
            if (Strings.isNotEmpty((Collection)attachments)) {
                Iterator iterator = attachments.iterator();
                while (iterator.hasNext()) {
                    Attachment attachment = (Attachment)iterator.next();
                    if (attachment.getCategory() != null && (attachment.getCategory().intValue() == ApplicationCategoryEnum.cap4Form.getKey() || attachment.getCategory().intValue() == ApplicationCategoryEnum.form.getKey())) continue;
                    iterator.remove();
                }
            }
            newSubReference = CAPAttachmentUtil.copyAttachment(formDataMasterBean, formFieldBean, newReference, newSubReference, attachments, saveDb);
        }
        return newSubReference;
    }

    public static void resetForwardAttachmentForCreate(Map<String, Object> map, Long moduleId) {
        List formsons;
        Map formmainfieldInfo;
        Map dataMap = (Map)map.get("data");
        Map tableInfo = (Map)dataMap.get("tableInfo");
        Map formmain = (Map)tableInfo.get("formmain");
        if (formmain != null && !formmain.isEmpty() && (formmainfieldInfo = (Map)formmain.get("fieldInfo")) != null && !formmainfieldInfo.isEmpty()) {
            for (String key : formmainfieldInfo.keySet()) {
                if (!(formmainfieldInfo.get(key) instanceof Map)) continue;
                CAPAttachmentUtil.resetForwardAttachmentWithFieldData((Map)formmainfieldInfo.get(key), moduleId);
            }
        }
        if ((formsons = CAPParamUtil.getParamsListByKey((Map)tableInfo, (String)"formson")) != null && formsons.size() > 0 && formsons.get(0) != null) {
            for (Map formson : formsons) {
                List dataSubLineInfos;
                if (formson == null || formson.isEmpty() || (dataSubLineInfos = CAPParamUtil.getParamsListByKey((Map)formson, (String)"dataSubLineInfos")) == null || dataSubLineInfos.size() <= 0 || dataSubLineInfos.get(0) == null) continue;
                for (Map subLine : dataSubLineInfos) {
                    if (subLine == null || subLine.isEmpty()) continue;
                    for (String key : subLine.keySet()) {
                        if (!(subLine.get(key) instanceof Map)) continue;
                        CAPAttachmentUtil.resetForwardAttachmentWithFieldData((Map)subLine.get(key), moduleId);
                    }
                }
                formson.put("dataSubLineInfos", dataSubLineInfos);
            }
            tableInfo.put("formson", formsons);
        }
    }

    private static void resetForwardAttachmentWithFieldData(Map<String, Object> fieldDataMap, Long moduleId) {
        if (fieldDataMap == null || fieldDataMap.get("attachmentInfo") == null) {
            return;
        }
        Map attachmentInfo = (Map)fieldDataMap.get("attachmentInfo");
        List attachmentInfos = CAPParamUtil.getParamsListByKey((Map)attachmentInfo, (String)"attachmentInfos");
        Map baseAttachmentInfo = (Map)attachmentInfo.get("baseAttachmentInfo");
        if (attachmentInfos != null && attachmentInfos.size() > 0 && attachmentInfos.get(0) != null && baseAttachmentInfo != null) {
            baseAttachmentInfo.put("reference", String.valueOf(moduleId));
            for (Map attachmentMap : attachmentInfos) {
                if (attachmentMap == null || attachmentMap.isEmpty()) continue;
                Attachment attachment = new Attachment(attachmentMap);
                attachment.setType(Integer.valueOf((String)baseAttachmentInfo.get("type")));
                attachment.setCategory(Integer.valueOf((String)baseAttachmentInfo.get("category")));
                if (Strings.isNotBlank((String)((String)attachmentMap.get("id")))) {
                    attachment.setId(Long.valueOf((String)attachmentMap.get("id")));
                }
                attachment.setReference(moduleId);
                attachment.setDescription((String)attachmentMap.get("description"));
                String genesisId = attachmentMap.get("genesisId") == null ? null : String.valueOf(attachmentMap.get("genesisId"));
                attachment.setGenesisId(Strings.isBlank((String)genesisId) ? null : Long.valueOf(Long.parseLong(genesisId)));
                attachmentMap.clear();
                attachmentMap.putAll(CAPAttachmentUtil.buildAttachmentMap(attachment, true));
            }
        }
        attachmentInfo.put("attachmentInfos", attachmentInfos);
    }

    public static Map<String, Object> getFieldAttachmentMap(Long contentDataId, FormFieldBean formFieldBean, Object fieldValue, Map<String, List<Map<String, String>>> capFormAttachmentsMap) {
        String subReference = fieldValue == null ? null : String.valueOf(fieldValue);
        List<Map<String, String>> attachmentInfos = null;
        if (subReference != null) {
            attachmentInfos = capFormAttachmentsMap.get(subReference);
        } else {
            subReference = String.valueOf(UUIDLong.longUUID());
        }
        return CAPAttachmentUtil.getAttachmentMap(contentDataId, formFieldBean, subReference, attachmentInfos);
    }

    public static Map<String, Object> getAttachmentMap(Long contentDataId, FormFieldBean formFieldBean, String subReference, List<Map<String, String>> attachmentMaps) {
        HashMap<String, String> baseAttachmentInfo = new HashMap<String, String>();
        baseAttachmentInfo.put("subReference", subReference);
        baseAttachmentInfo.put("reference", String.valueOf(contentDataId));
        baseAttachmentInfo.put("maxImgSize", String.valueOf(formFieldBean.getMaxImgSize()));
        baseAttachmentInfo.put("category", String.valueOf(ApplicationCategoryEnum.cap4Form.key()));
        if (formFieldBean.getInputTypeEnum() == FormFieldComEnum.EXTEND_IMAGE || formFieldBean.getInputTypeEnum() == FormFieldComEnum.MAP_PHOTO || formFieldBean.getInputTypeEnum() == FormFieldComEnum.MAP_LOCATE) {
            baseAttachmentInfo.put("mimeType", "image/png");
            baseAttachmentInfo.put("type", String.valueOf(Constants.ATTACHMENT_TYPE.IMAGE.ordinal()));
        } else if (formFieldBean.getInputTypeEnum() == FormFieldComEnum.EXTEND_ATTACHMENT) {
            baseAttachmentInfo.put("mimeType", "application/octet-stream");
            baseAttachmentInfo.put("type", String.valueOf(Constants.ATTACHMENT_TYPE.FILE.ordinal()));
        } else if (formFieldBean.getInputTypeEnum() == FormFieldComEnum.EXTEND_DOCUMENT) {
            baseAttachmentInfo.put("mimeType", "document");
            baseAttachmentInfo.put("type", String.valueOf(Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal()));
        } else {
            baseAttachmentInfo.put("mimeType", "application/octet-stream");
            baseAttachmentInfo.put("type", String.valueOf(Constants.ATTACHMENT_TYPE.FILE.ordinal()));
        }
        HashMap<String, Object> attachmentInfo = new HashMap<String, Object>();
        attachmentInfo.put("attachmentInfos", attachmentMaps == null ? new ArrayList() : attachmentMaps);
        attachmentInfo.put("baseAttachmentInfo", baseAttachmentInfo);
        return attachmentInfo;
    }

    public static Map<String, List<Map<String, String>>> buildAttachmentSubReferenceToListMap(List<Attachment> attachments, boolean isSetOfficeTransform) {
        HashMap<String, List<Map<String, String>>> formAttachmentsMap = new HashMap<String, List<Map<String, String>>>();
        if (Strings.isNotEmpty(attachments)) {
            for (Attachment attachment : attachments) {
                if (attachment.getCategory() == null || attachment.getCategory().intValue() != ApplicationCategoryEnum.cap4Form.key()) continue;
                String subReference = String.valueOf(attachment.getSubReference());
                ArrayList<Map<String, String>> formAttachments = (ArrayList<Map<String, String>>)formAttachmentsMap.get(subReference);
                if (formAttachments == null) {
                    formAttachments = new ArrayList<Map<String, String>>();
                    formAttachmentsMap.put(subReference, formAttachments);
                }
                formAttachments.add(CAPAttachmentUtil.buildAttachmentMap(attachment, isSetOfficeTransform));
            }
        }
        return formAttachmentsMap;
    }

    public static Map<String, List<Attachment>> buildAttachmentSubReferenceToList(List<Attachment> attachments) {
        HashMap<String, List<Attachment>> map = new HashMap<String, List<Attachment>>();
        if (Strings.isNotEmpty(attachments)) {
            for (Attachment attachment : attachments) {
                if (attachment.getCategory() == null || attachment.getCategory().intValue() != ApplicationCategoryEnum.cap4Form.key()) continue;
                String subReference = String.valueOf(attachment.getSubReference());
                ArrayList<Attachment> formAttachments = (ArrayList<Attachment>)map.get(subReference);
                if (formAttachments == null) {
                    formAttachments = new ArrayList<Attachment>();
                    map.put(subReference, formAttachments);
                }
                formAttachments.add(attachment);
            }
        }
        return map;
    }

    public static Attachment importAttachmentFromMap(Map<String, String> attachmentInfo) {
        Attachment attachment = new Attachment();
        attachment.setId(Long.valueOf(attachmentInfo.get("id")));
        attachment.setFileUrl(Long.valueOf(attachmentInfo.get("fileUrl")));
        attachment.setSize(Long.valueOf(attachmentInfo.get("size")));
        attachment.setCreatedate(DateUtil.toDate((String)attachmentInfo.get("createdate")));
        attachment.setFilename(attachmentInfo.get("filename"));
        attachment.setMimeType(attachmentInfo.get("mimeType"));
        attachment.setReference(Long.valueOf(attachmentInfo.get("reference")));
        attachment.setSort(Integer.valueOf(attachmentInfo.get("sort")).intValue());
        attachment.setSubReference(Long.valueOf(attachmentInfo.get("subReference")));
        attachment.setGenesisId(Strings.isBlank((String)attachmentInfo.get("genesisId")) ? null : Long.valueOf(attachmentInfo.get("genesisId")));
        attachment.setDescription(attachmentInfo.get("description"));
        attachment.setCategory(Integer.valueOf(attachmentInfo.get("category")));
        attachment.setType(Integer.valueOf(attachmentInfo.get("type")));
        return attachment;
    }

    public static Map<String, String> buildAttachmentMap(Attachment attachment, boolean isSetOfficeTransform) {
        HashMap<String, String> attachmentInfo = new HashMap<String, String>();
        attachmentInfo.put("id", String.valueOf(attachment.getId()));
        attachmentInfo.put("fileUrl", attachment.getFileUrl() == null ? "" : String.valueOf(attachment.getFileUrl()));
        attachmentInfo.put("size", String.valueOf(attachment.getSize()));
        attachmentInfo.put("createdate", DateUtil.format((Date)attachment.getCreatedate(), (String)"yyyy-MM-dd HH:mm:ss"));
        attachmentInfo.put("filename", String.valueOf(attachment.getFilename()));
        attachmentInfo.put("v", CAPAttachmentUtil.getAttachmentRealV(attachment));
        attachmentInfo.put("mimeType", attachment.getMimeType());
        attachmentInfo.put("reference", String.valueOf(attachment.getReference()));
        attachmentInfo.put("sort", String.valueOf(attachment.getSort()));
        attachmentInfo.put("subReference", String.valueOf(attachment.getSubReference()));
        attachmentInfo.put("genesisId", attachment.getGenesisId() == null ? "" : String.valueOf(attachment.getGenesisId()));
        attachmentInfo.put("description", attachment.getDescription() == null ? "" : String.valueOf(attachment.getDescription()));
        AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.add(attachment);
        if (isSetOfficeTransform) {
            attachmentManager.setOfficeTransformEnable(attachments);
        }
        attachmentInfo.put("officeTransformEnable", attachment.getOfficeTransformEnable());
        return attachmentInfo;
    }

    public static List<Map<String, String>> buildAttachmentMaps(List<Attachment> attachments, boolean isSetOfficeTransform) {
        ArrayList<Map<String, String>> list = null;
        if (attachments != null) {
            list = new ArrayList<Map<String, String>>();
            for (Attachment attachment : attachments) {
                list.add(CAPAttachmentUtil.buildAttachmentMap(attachment, isSetOfficeTransform));
            }
        }
        return list;
    }

    public static void copyApiForwardFormAttachments(List<Attachment> attachments, String newSummaryId, Map<String, List<Map<String, String>>> capFormAttachmentsMap) throws BusinessException {
        HashMap<Long, Long> attOld2NewId = new HashMap<Long, Long>();
        if (Strings.isNotEmpty(attachments)) {
            ArrayList<Attachment> newAtts = new ArrayList<Attachment>();
            for (Attachment att : attachments) {
                Attachment newAtt;
                block6: {
                    if (att.getCategory() == null || att.getCategory().intValue() != ApplicationCategoryEnum.cap4Form.key()) continue;
                    newAtt = null;
                    try {
                        newAtt = (Attachment)att.clone();
                        newAtt.setNewId();
                        attOld2NewId.put(att.getId(), newAtt.getId());
                        if (att.getType().intValue() != Constants.ATTACHMENT_TYPE.FILE.ordinal() && att.getType().intValue() != Constants.ATTACHMENT_TYPE.FormFILE.ordinal()) break block6;
                        newAtt.setFileUrl(att.getFileUrl());
                    }
                    catch (CloneNotSupportedException e) {
                        LOGGER.warn((Object)"copyApiForwardFormAttachments copy file not support clone.", (Throwable)e);
                        continue;
                    }
                }
                newAtt.setReference(Long.valueOf(newSummaryId));
                newAtt.setSubReference(Long.valueOf(100L));
                newAtts.add(newAtt);
            }
            AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
            attachmentManager.create(newAtts);
        }
        for (String key : capFormAttachmentsMap.keySet()) {
            List<Map<String, String>> list = capFormAttachmentsMap.get(key);
            for (Map<String, String> map : list) {
                map.put("reference", newSummaryId);
                map.put("subReference", "100");
                Long newId = map.get("id") == null ? null : (Long)attOld2NewId.get(Long.valueOf(map.get("id")));
                if (newId == null) continue;
                map.put("id", String.valueOf(newId));
            }
        }
    }

    public static String getAttachmentRealV(Attachment attachment) {
        String v = null;
        if (attachment != null && Strings.isBlank((String)(v = attachment.getV())) && Strings.isBlank((String)(v = (String)attachment.getExtraAttr("v"))) && attachment.getFileUrl() != null) {
            v = SecurityHelper.digest((Object[])new Object[]{attachment.getFileUrl()});
        }
        return Strings.isBlank(v) ? "" : v;
    }

    public static List<Attachment> mergeAttachments(List<Attachment> attachments, List<Attachment> waitMergeAttachments) {
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
        }
        if (Strings.isNotEmpty(waitMergeAttachments)) {
            if (!attachments.isEmpty()) {
                HashSet<String> exitAtts = new HashSet<String>();
                for (Attachment attachment : attachments) {
                    exitAtts.add(CAPAttachmentUtil.getUniqueKey(attachment));
                }
                for (Attachment attachment : waitMergeAttachments) {
                    if (attachment.getCategory().intValue() != ApplicationCategoryEnum.cap4Form.key() || exitAtts.contains(CAPAttachmentUtil.getUniqueKey(attachment))) continue;
                    attachments.add(attachment);
                }
            } else {
                attachments.addAll(waitMergeAttachments);
            }
        }
        return attachments;
    }

    public static void putDbAttachmentsToSession(FormDataMasterBean formDataMasterBean, Map<String, List<Attachment>> map) {
        for (String subReference : map.keySet()) {
            List<Attachment> sessionAttachments = formDataMasterBean.getSessionAttachments(subReference);
            sessionAttachments = CAPAttachmentUtil.mergeAttachments(sessionAttachments, map.get(subReference));
            Collections.sort(sessionAttachments, new Comparator<Attachment>(){

                @Override
                public int compare(Attachment o1, Attachment o2) {
                    return o1.getSort() - o2.getSort();
                }
            });
            formDataMasterBean.putSessionAttachments(subReference, sessionAttachments);
        }
    }

    public static void removeSessionAttachmentsBySubReferences(FormDataMasterBean formDataMasterBean, Set<String> subReferences) {
        if (Strings.isEmpty(subReferences)) {
            return;
        }
        for (String str : subReferences) {
            formDataMasterBean.putSessionAttachments(str, null);
        }
    }

    public static String getUniqueKey(Attachment attachment) {
        String str = "";
        if (attachment != null) {
            str = attachment.getSubReference() + "_" + attachment.getFileUrl();
        }
        return str;
    }
}

