/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.seeyon.apps.m3.api.M3Api;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.thread.CAPBuildMobileTemplatePackageThread;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.vo.CAPBuildTemplateVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPBuildM3Util {
    private static final Log logger = CtpLogFactory.getLog(CAPBuildM3Util.class);
    private static final String CODE_EXCEPTION = "1006";
    private static final String CODE_NOT_EXITS_ERROR = "1004";

    public static Map<String, Object> buildM3AppsByBizId(Long bizId, boolean isAsync) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        logger.info((Object)("buildM3AppsByBizId begin build m3 , bizId " + bizId));
        CAPBusinessTemplateManager capBusinessTemplateManager = (CAPBusinessTemplateManager)AppContext.getBean((String)"capBusinessTemplateManager");
        List<CAPBusinessTemplateBO> capBusinessTemplateBOS = capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        if (Strings.isEmpty(capBusinessTemplateBOS)) {
            logger.info((Object)("buildM3AppsByBizId build m3 templates is empty, bizId " + bizId));
            result.put("code", CODE_NOT_EXITS_ERROR);
            result.put("message", "templates is empty");
            return result;
        }
        ArrayList<CAPBuildTemplateVO> waitBuildTemplates = new ArrayList<CAPBuildTemplateVO>();
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
            Integer clientType = Integer.valueOf(capBusinessTemplateBO.getClient());
            if (!clientType.equals(CAPBusinessEnum.Platform.MOBILE.getType())) continue;
            Long pathId = capBusinessTemplateBO.getPathId() == null ? bizId : Long.valueOf(capBusinessTemplateBO.getPathId());
            CAPBuildTemplateVO capBuildTemplateVO = new CAPBuildTemplateVO(bizId, Long.valueOf(capBusinessTemplateBO.getId()), Integer.valueOf(capBusinessTemplateBO.getTemplateType()), clientType, pathId);
            waitBuildTemplates.add(capBuildTemplateVO);
        }
        if (waitBuildTemplates.size() > 0) {
            CAPBuildM3Util.buildMobileCAPTemplatePackage(waitBuildTemplates, isAsync);
        }
        logger.info((Object)("buildM3AppsByBizId end build m3 , eggId " + bizId + " , build size " + ((Object)waitBuildTemplates).toString()));
        result.put("code", "1000");
        result.put("message", ((Object)waitBuildTemplates).toString());
        return result;
    }

    public static Map<String, Object> buildMobileCAPTemplatePackage(List<CAPBuildTemplateVO> waitBuildTemplates, boolean isAsync) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (isAsync) {
            if (Strings.isNotEmpty(waitBuildTemplates)) {
                CAPBuildMobileTemplatePackageThread thread = new CAPBuildMobileTemplatePackageThread(waitBuildTemplates);
                thread.start();
            }
        } else {
            CAPBuildM3Util.buildCAPTemplate(waitBuildTemplates, result);
        }
        return result;
    }

    private static Map<String, Object> getMobileManifestForBuild() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> iconFiles = new HashMap<String, Object>();
        iconFiles.put("default", "");
        iconFiles.put("multi", new ArrayList());
        HashMap<String, String> update = new HashMap<String, String>();
        update.put("checkUpdateUrl", "");
        HashMap<String, String> cmpShellVersion = new HashMap<String, String>();
        cmpShellVersion.put("ios", "1.0.0");
        cmpShellVersion.put("android", "1.0.0");
        ArrayList<String> compatibleVersion = new ArrayList<String>();
        compatibleVersion.add("1.0.0");
        compatibleVersion.add("1.0.1");
        compatibleVersion.add("2.0.0");
        ArrayList<String> supportedPlatforms = new ArrayList<String>();
        supportedPlatforms.add("iOS_6.0");
        supportedPlatforms.add("android_4.0");
        HashMap<String, String> entry = new HashMap<String, String>();
        entry.put("phone", "dist/index.html");
        map.put("buildVersion", "1.0.0");
        map.put("iconFiles", iconFiles);
        map.put("splashscreen", new ArrayList());
        map.put("update", update);
        map.put("serviceProvidear", "seeyon");
        map.put("team", "v5");
        map.put("cmpShellVersion", cmpShellVersion);
        map.put("packageType", "APP");
        map.put("version", "1.0.0");
        map.put("entry", entry);
        map.put("compatibleVersion", compatibleVersion);
        map.put("appType", "default");
        map.put("supportedPlatforms", supportedPlatforms);
        map.put("desc", "cap4 custom template");
        return map;
    }

    public static Map<String, Object> buildCAPTemplate(List<CAPBuildTemplateVO> waitBuildTemplates, Map<String, Object> result) {
        if (result == null) {
            result = new HashMap<String, Object>();
        }
        long startTime = System.currentTimeMillis();
        String unique = String.valueOf(UUIDLong.longUUID());
        logger.info((Object)("buildCAPTemplate \u6784\u5efam3 template zips start. " + unique + " " + waitBuildTemplates.toString()));
        if (Strings.isNotEmpty(waitBuildTemplates)) {
            result.put("code", "1000");
            result.put("message", "the operation is success!!!");
            String waitDelFolder = CAPBusinessTemplateUtil.getTemplateTempFolder() + File.separator + "m3cap" + DateUtil.currentDateString((String)"yyyyMMddHHmmss");
            File waitDelFolderFile = new File(waitDelFolder);
            if (!waitDelFolderFile.getParentFile().exists()) {
                boolean mkdirs = waitDelFolderFile.getParentFile().getParentFile().mkdirs();
                logger.info((Object)("buildCAPTemplate \u6784\u5efam3 mkdirs parent " + mkdirs + " " + waitDelFolderFile.getParentFile().getAbsolutePath()));
            }
            boolean mkdirResult = waitDelFolderFile.mkdirs();
            logger.info((Object)("buildCAPTemplate \u6784\u5efam3 mkdirResult. " + mkdirResult + " " + waitDelFolder));
            File[] buildAppFiles = new File[waitBuildTemplates.size()];
            Map<String, Object> manifestMap = CAPBuildM3Util.getMobileManifestForBuild();
            int i = 0;
            for (CAPBuildTemplateVO vo : waitBuildTemplates) {
                long zipStartTime = System.currentTimeMillis();
                String waitZipBaseFolder = "";
                String tempZipFilePath = waitDelFolder + File.separator;
                String tempId = String.valueOf(vo.getTemplateId());
                if (vo.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
                    waitZipBaseFolder = CAPBusinessTemplateUtil.getBaseCustomTemplateBusinessFolder(String.valueOf(vo.getEggId()), vo.getClient()) + vo.getTemplateId();
                } else {
                    waitZipBaseFolder = CAPBusinessTemplateUtil.getBaseCustomTemplateTypeDataFolder(String.valueOf(vo.getPathId()), vo.getClient(), vo.getTemplateType());
                    tempId = String.valueOf(vo.getPathId());
                }
                tempZipFilePath = tempZipFilePath + tempId + ".zip";
                manifestMap.put("appName", tempId);
                manifestMap.put("bundleIdentifier", "com.seeyon.v5." + tempId);
                manifestMap.put("appId", tempId);
                manifestMap.put("urlSchemes", tempId + ".v5.cmp");
                manifestMap.put("bundleName", tempId);
                File waitZipFolderFile = new File(waitZipBaseFolder);
                if (!waitZipFolderFile.exists()) {
                    logger.error((Object)("buildCAPTemplate zip error template file not exits " + vo.toString() + " " + waitZipBaseFolder));
                    continue;
                }
                File tempManifest = new File(waitZipFolderFile, "manifest.json");
                FileUtil.writeFile((File)tempManifest, (String)JSONUtil.toJSONString(manifestMap));
                File tempZipFile = new File(tempZipFilePath);
                try {
                    ZipUtil.zip((File)waitZipFolderFile, (File)tempZipFile, (boolean)false);
                }
                catch (IOException e) {
                    logger.error((Object)("buildCAPTemplate zip error template " + vo.toString()), (Throwable)e);
                    continue;
                }
                logger.info((Object)("buildCAPTemplate zip templateId " + vo.getTemplateId() + " file length:" + tempZipFile.length() + ", use time:" + (System.currentTimeMillis() - zipStartTime) + " MS"));
                buildAppFiles[i] = tempZipFile;
                FileUtil.deleteFile((File)tempManifest);
                ++i;
            }
            try {
                long buildStartTime = System.currentTimeMillis();
                M3Api m3Api = (M3Api)AppContext.getBean((String)"m3Api");
                m3Api.buildCap4App(buildAppFiles);
                logger.info((Object)("buildCAPTemplate build use time:" + (System.currentTimeMillis() - buildStartTime) + " MS"));
                for (int j = 0; j < buildAppFiles.length; ++j) {
                    FileUtil.deleteFile((File)buildAppFiles[j]);
                }
                CAPBusinessTemplateUtil.clearMacOSFile(waitDelFolder);
                if (waitDelFolderFile.list().length == 0) {
                    FileUtil.deleteDirectory((File)waitDelFolderFile);
                }
            }
            catch (Exception e) {
                logger.error((Object)("buildCAPTemplate is error " + e.getMessage()), (Throwable)e);
                result.put("code", CODE_EXCEPTION);
                result.put("message", e.getMessage());
            }
        } else {
            result.put("code", CODE_NOT_EXITS_ERROR);
            result.put("message", "templates is null");
        }
        logger.info((Object)("buildCAPTemplate \u6784\u5efam3 template zips end. " + unique + " use " + (System.currentTimeMillis() - startTime) + " MS. result:" + result.toString()));
        return result;
    }
}

