/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessConstant;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import org.apache.commons.logging.Log;

public class CAPBusinessTemplateUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessTemplateUtil.class);
    public static final String BASE = "base";
    public static final String RUNTIME = "runtime";
    private static final String TEMPLATE_RUNTIME_PC_FOLDER = "common" + File.separator + "cap4" + File.separator + "template";
    private static final String TEMPLATE_RUNTIME_MOBILE_FOLDER = "m3" + File.separator + "apps" + File.separator + "v5" + File.separator + "cap4";
    private static final String TEMP_FOLDER = "temp";
    private static final String TEMPLATE_FOLDER = "template";
    private static final String BASE_MOBILE_FOLDER = "template_mobile";
    private static final String EDIT = "edit";
    private static final String INITIAL_BACKUP = "initialBackup";
    private static final String TEMPLATE_DISPLAY_FOLDER = "display";
    private static final String TEMPLATE_PC_FOLDER = "pc";
    private static final String TEMPLATE_MOBILE_FOLDER = "mobile";
    private static final String TEMPLATE_UNFLOW_FOLDER = "unflow";
    private static final String TEMPLATE_FLOW_FOLDER = "flow";
    private static final String TEMPLATE_REPORT_FOLDER = "report";
    private static final String TEMPLATE_QUERY_FOLDER = "query";
    private static final String TEMPLATE_HTMLS_FOLDER = "htmls";
    private static final String TEMPLATE_BUSINESS_FOLDER = "business";
    private static final String AUTO_UPDATE = "autoUpdate";

    public static String getRuntimeAutoUpdatePath() {
        return SystemEnvironment.getApplicationFolder() + File.separator + TEMPLATE_RUNTIME_PC_FOLDER + File.separator + AUTO_UPDATE;
    }

    public static String getTemplateConfigPath(String pathType, CAPBusinessTemplateBO templateBO, boolean isEdit) {
        String configDataId;
        String string = configDataId = templateBO.getTemplateType().equals(String.valueOf(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) ? templateBO.getId() : templateBO.getPathId();
        if (isEdit) {
            configDataId = CAPBusinessTemplateUtil.getEditFolderName(configDataId);
        }
        return CAPBusinessTemplateUtil.getTemplateConfigPath(pathType, Integer.valueOf(templateBO.getClient()), Integer.valueOf(templateBO.getTemplateType()), configDataId, Long.valueOf(templateBO.getEggId()));
    }

    public static String getTemplateConfigPath(String pathType, CAPBusinessTemplate template, boolean isEdit) {
        String configDataId = String.valueOf(template.getTemplateType().intValue() == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() ? template.getId() : template.getPathId());
        if (isEdit) {
            configDataId = CAPBusinessTemplateUtil.getEditFolderName(configDataId);
        }
        return CAPBusinessTemplateUtil.getTemplateConfigPath(pathType, template.getClient(), template.getTemplateType(), configDataId, template.getEggId());
    }

    public static String getTemplateConfigPath(String pathType, Integer clientType, Integer templateType, String dataId, Long bizId) {
        return CAPBusinessTemplateUtil.getTemplatePath(pathType, clientType, templateType, dataId, bizId) + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON;
    }

    public static String getTemplatePath(String pathType, CAPBusinessTemplateBO templateBO, boolean isEdit) {
        String configDataId;
        String string = configDataId = templateBO.getTemplateType().equals(String.valueOf(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) ? templateBO.getId() : templateBO.getPathId();
        if (isEdit) {
            configDataId = CAPBusinessTemplateUtil.getEditFolderName(configDataId);
        }
        return CAPBusinessTemplateUtil.getTemplatePath(pathType, Integer.valueOf(templateBO.getClient()), Integer.valueOf(templateBO.getTemplateType()), configDataId, Long.valueOf(templateBO.getEggId()));
    }

    public static String getTemplatePath(String pathType, CAPBusinessTemplate template, boolean isEdit) {
        String configDataId = String.valueOf(template.getTemplateType().intValue() == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() ? template.getId() : template.getPathId());
        if (isEdit) {
            configDataId = CAPBusinessTemplateUtil.getEditFolderName(configDataId);
        }
        return CAPBusinessTemplateUtil.getTemplatePath(pathType, template.getClient(), template.getTemplateType(), configDataId, template.getEggId());
    }

    public static String getTemplatePath(String pathType, Integer clientType, Integer templateType, String dataId, Long bizId) {
        String path = CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() == templateType.intValue() ? (RUNTIME.equals(pathType) ? CAPBusinessTemplateUtil.getRuntimeCustomTemplateTypeDataFolder(String.valueOf(bizId), clientType, templateType) + dataId + File.separator : CAPBusinessTemplateUtil.getBaseCustomTemplateTypeDataFolder(String.valueOf(bizId), clientType, templateType) + dataId + File.separator) : (RUNTIME.equals(pathType) ? CAPBusinessTemplateUtil.getRuntimeCustomTemplateTypeDataFolder(dataId, clientType, templateType) : CAPBusinessTemplateUtil.getBaseCustomTemplateTypeDataFolder(dataId, clientType, templateType));
        return path;
    }

    public static String getEditFolderName(String dataId) {
        return dataId + "_" + EDIT;
    }

    public static String getTemplateTempFolder() {
        if (SystemEnvironment.isDistributedMode()) {
            try {
                File clusterFolder = SystemEnvironment.getClusterPublicFolder((String)"temporary");
                String path = clusterFolder.getAbsolutePath();
                return path + File.separator + "cap";
            }
            catch (BusinessException e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
        return SystemEnvironment.getSystemTempFolder() + File.separator + "cap" + File.separator + TEMP_FOLDER;
    }

    public static String getRuntimeTemplateAbsolutePathByPath(int clientType, int templateType, String path) {
        if (path == null) {
            return "";
        }
        return CAPBusinessTemplateUtil.getRuntimeCustomTemplateRootFolder(clientType, templateType) + path;
    }

    public static String getBaseTemplateRelativePathByPath(int clientType, String path) {
        if (path == null) {
            return "";
        }
        return path.replace(CAPBusinessTemplateUtil.getBaseCustomTemplateRootFolder(clientType), "");
    }

    public static String getRuntimeCustomTemplateClientFolder(int clientType, int templateType) {
        return CAPBusinessTemplateUtil.getCustomTemplateClientFolder(RUNTIME, clientType, templateType);
    }

    public static String getBaseCustomTemplateClientFolder(int clientType, int templateType) {
        return CAPBusinessTemplateUtil.getCustomTemplateClientFolder(BASE, clientType, templateType);
    }

    public static String getRuntimeCustomTemplateTypeDataFolder(String dataId, int clientType, int templateType) {
        return CAPBusinessTemplateUtil.getRuntimeCustomTemplateRootFolder(clientType, templateType) + CAPBusinessTemplateUtil.getOnlyRelativePath(dataId, clientType, templateType);
    }

    public static String getBaseCustomTemplateTypeDataFolder(String dataId, int clientType, int templateType) {
        return CAPBusinessTemplateUtil.getBaseCustomTemplateRootFolder(clientType) + CAPBusinessTemplateUtil.getOnlyRelativePath(dataId, clientType, templateType);
    }

    public static String getRuntimeCustomTemplateClientAndTypeFolder(int clientType, int templateType) {
        return CAPBusinessTemplateUtil.getCustomTemplateTypeRootFolder(RUNTIME, clientType, templateType);
    }

    public static String getBaseCustomTemplateClientAndTypeFolder(int clientType, int templateType) {
        return CAPBusinessTemplateUtil.getCustomTemplateTypeRootFolder(BASE, clientType, templateType);
    }

    public static String getRuntimeCustomTemplateBusinessFolder(String bizId, int clientType) {
        return CAPBusinessTemplateUtil.getCustomTemplateBusinessRootFolder(RUNTIME, clientType, CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) + bizId + File.separator;
    }

    public static String getBaseCustomTemplateBusinessFolder(String bizId, int clientType) {
        return CAPBusinessTemplateUtil.getCustomTemplateBusinessRootFolder(BASE, clientType, CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) + bizId + File.separator;
    }

    public static String getBaseCustomTemplateRootFolder(int clientType) {
        String folder = CAPBusinessTemplateUtil.getBaseFolderPath() + "cap" + File.separator;
        folder = CAPBusinessEnum.Platform.MOBILE.getType() == clientType ? folder + BASE_MOBILE_FOLDER : folder + TEMPLATE_FOLDER;
        return folder + File.separator;
    }

    public static String getBaseTemplateInitialBackupFolder() {
        return CAPBusinessTemplateUtil.getBaseFolderPath() + "cap" + File.separator + INITIAL_BACKUP + File.separator;
    }

    public static String getBaseTemplateUpdateBackupFolder() {
        return SystemEnvironment.getSystemTempFolder() + File.separator + "cap" + File.separator + AUTO_UPDATE + File.separator;
    }

    public static String getBaseFolderPath() {
        try {
            File clusterFolder = SystemEnvironment.getClusterPublicFolder((String)"cap");
            String path = clusterFolder.getAbsolutePath();
            return path.substring(0, path.length() - "cap".length());
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"", (Throwable)e);
            return "";
        }
    }

    public static String getRuntimeCustomTemplateRootFolder(int clientType, int templateType) {
        String folder = SystemEnvironment.getApplicationFolder() + File.separator;
        folder = CAPBusinessEnum.Platform.MOBILE.getType() == clientType ? folder + TEMPLATE_RUNTIME_MOBILE_FOLDER + CAPBusinessTemplateUtil.getTemplateFolderNameByType(templateType) : folder + TEMPLATE_RUNTIME_PC_FOLDER;
        return folder + File.separator;
    }

    public static String getOnlyRelativePath(String dataId, int clientType, int templateType) {
        String folder = "";
        folder = CAPBusinessEnum.Platform.MOBILE.getType() == clientType ? folder + TEMPLATE_HTMLS_FOLDER : folder + TEMPLATE_DISPLAY_FOLDER + File.separator + TEMPLATE_PC_FOLDER;
        folder = folder + File.separator + CAPBusinessTemplateUtil.getTemplateFolderNameByType(templateType);
        return folder + File.separator + dataId + File.separator;
    }

    private static String getCustomTemplateTypeRootFolder(String pathType, int clientType, int templateType) {
        if (templateType == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) {
            return CAPBusinessTemplateUtil.getCustomTemplateBusinessRootFolder(pathType, clientType, templateType);
        }
        String folder = "";
        folder = RUNTIME.equals(pathType) ? CAPBusinessTemplateUtil.getRuntimeCustomTemplateClientFolder(clientType, templateType) : CAPBusinessTemplateUtil.getBaseCustomTemplateClientFolder(clientType, templateType);
        return folder + File.separator + CAPBusinessTemplateUtil.getTemplateFolderNameByType(templateType) + File.separator;
    }

    private static String getTemplateFolderNameByType(int templateType) {
        String folder = "";
        if (templateType == CAPBusinessEnum.TemplateType.TP_CACL.getType()) {
            folder = TEMPLATE_REPORT_FOLDER;
        } else if (templateType == CAPBusinessEnum.TemplateType.TP_FLOW.getType()) {
            folder = TEMPLATE_FLOW_FOLDER;
        } else if (templateType == CAPBusinessEnum.TemplateType.TP_UNFLOW.getType()) {
            folder = TEMPLATE_UNFLOW_FOLDER;
        } else if (templateType == CAPBusinessEnum.TemplateType.TP_QUERY.getType()) {
            folder = TEMPLATE_QUERY_FOLDER;
        } else if (templateType == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) {
            folder = TEMPLATE_BUSINESS_FOLDER;
        }
        return folder;
    }

    private static String getCustomTemplateBusinessRootFolder(String pathType, int clientType, int templateType) {
        String folder = "";
        folder = RUNTIME.equals(pathType) ? CAPBusinessTemplateUtil.getRuntimeCustomTemplateClientFolder(clientType, templateType) : CAPBusinessTemplateUtil.getBaseCustomTemplateClientFolder(clientType, templateType);
        return folder + File.separator + TEMPLATE_BUSINESS_FOLDER + File.separator;
    }

    private static String getCustomTemplateClientFolder(String pathType, int clientType, int templateType) {
        String folder = "";
        folder = RUNTIME.equals(pathType) ? CAPBusinessTemplateUtil.getRuntimeCustomTemplateRootFolder(clientType, templateType) : CAPBusinessTemplateUtil.getBaseCustomTemplateRootFolder(clientType);
        folder = CAPBusinessEnum.Platform.MOBILE.getType() == clientType ? folder + TEMPLATE_HTMLS_FOLDER : folder + TEMPLATE_DISPLAY_FOLDER + File.separator + TEMPLATE_PC_FOLDER;
        return folder;
    }

    public static String getPresetTemplateFolder(int clientType, int templateType) {
        String folder = SystemEnvironment.getApplicationFolder() + File.separator + TEMPLATE_RUNTIME_PC_FOLDER;
        folder = folder + File.separator + TEMPLATE_DISPLAY_FOLDER + File.separator;
        folder = CAPBusinessEnum.Platform.MOBILE.getType() == clientType ? folder + TEMPLATE_MOBILE_FOLDER : folder + TEMPLATE_PC_FOLDER;
        return folder + File.separator + CAPBusinessTemplateUtil.getTemplateFolderNameByType(templateType) + File.separator;
    }

    public static String getPresetTemplateFolder(String dataId, int clientType, int templateType) {
        return CAPBusinessTemplateUtil.getPresetTemplateFolder(clientType, templateType) + dataId + File.separator;
    }

    public static void clearMacOSFile(String path) {
        CAPBusinessTemplateUtil.clearMacOSFile(new File(path));
    }

    public static void clearMacOSFile(File file) {
        if (file != null && file.exists()) {
            FileUtil.deleteFile((File)new File(file, ".DS_Store"));
            FileUtil.deleteDirectory((File)new File(file, "__MACOSX"));
        }
    }
}

