/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.TextEncoder;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

public class CAPBusinessUtil {
    private static final Log logger = CtpLogFactory.getLog(CAPBusinessUtil.class);

    public static String getDogNo() {
        String dogNumber = null;
        Class c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.product.ProductInfo");
        Object invoke = MclclzUtil.invoke((Class)c1, (String)"getDogNo");
        if (invoke != null) {
            dogNumber = String.valueOf(invoke);
        }
        return TextEncoder.decode(dogNumber);
    }

    public static void copyTemplatesFromBaseToRuntime(Long bizId, List<CAPBusinessTemplateBO> capBusinessTemplateBOS, boolean needCopyFrame) throws IOException {
        if (capBusinessTemplateBOS == null) {
            logger.info((Object)"copyTemplatesFromBaseToRuntime capBusinessTemplateBOS is null.");
            return;
        }
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
            CAPBusinessUtil.copyTemplateFromBaseToRuntime(capBusinessTemplateBO, false);
        }
        if (needCopyFrame) {
            CAPBusinessUtil.copyFrameFromBaseToRuntime(bizId);
        }
    }

    public static void copyFrameFromBaseToRuntime(Long bizId) throws IOException {
        String src;
        File srcFile;
        if (bizId != null && (srcFile = new File(src = CAPBusinessTemplateUtil.getBaseCustomTemplateBusinessFolder(String.valueOf(bizId), CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) + "frame" + File.separator)).exists()) {
            String dest = CAPBusinessTemplateUtil.getRuntimeCustomTemplateBusinessFolder(String.valueOf(bizId), CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) + "frame" + File.separator;
            FileUtil.copyDirectory((File)srcFile, (File)new File(dest), (int)5);
        }
    }

    public static void copyTemplateFromBaseToRuntime(CAPBusinessTemplateBO bo, boolean isEdit) throws IOException {
        String copyFromPath = CAPBusinessTemplateUtil.getTemplatePath("base", bo, isEdit);
        File srcFile = new File(copyFromPath);
        if (srcFile.exists()) {
            String copyToPath = CAPBusinessTemplateUtil.getTemplatePath("runtime", bo, isEdit);
            File copyToFile = new File(copyToPath);
            if (copyToFile.isDirectory()) {
                FileUtils.forceMkdir((File)copyToFile);
            }
            FileUtil.copyDirectory((File)srcFile, (File)copyToFile, (int)5);
            logger.info((Object)("copy template to runtime , base  " + copyFromPath));
            logger.info((Object)("copy template to runtime , runtime  " + copyToPath));
        } else {
            logger.error((Object)("copy template to runtime , base is not exits " + copyFromPath));
        }
    }

    public static void copyTemplateFromBaseToRuntime(CAPBusinessTemplate template, boolean isEdit) throws IOException {
        String copyToPath = CAPBusinessTemplateUtil.getTemplatePath("runtime", template, isEdit);
        String copyFromPath = CAPBusinessTemplateUtil.getTemplatePath("base", template, isEdit);
        FileUtil.copyDirectory((String)copyFromPath, (String)copyToPath);
    }

    public static boolean deleteTemplateFrame(String businessPath) {
        File file = new File(businessPath);
        if (!file.exists()) {
            return false;
        }
        CAPBusinessTemplateUtil.clearMacOSFile(file);
        String[] fileNames = file.list();
        if (fileNames.length > 0) {
            ArrayList<String> fileNameAfters = new ArrayList<String>();
            for (int i = 0; i < fileNames.length; ++i) {
                fileNameAfters.add(fileNames[i]);
            }
            if (fileNameAfters.size() == 1 && "frame".equals(fileNameAfters.get(0))) {
                File frameFile = new File(file, "frame");
                FileUtil.deleteDirectory((File)frameFile);
                logger.info((Object)("delete frame execed " + frameFile.getAbsolutePath()));
            }
        }
        return true;
    }

    public static boolean deleteTemplateFrame(Long bizId, int clientType) {
        String businessRuntimePath = CAPBusinessTemplateUtil.getRuntimeCustomTemplateBusinessFolder(String.valueOf(bizId), clientType);
        String businessBasePath = CAPBusinessTemplateUtil.getBaseCustomTemplateBusinessFolder(String.valueOf(bizId), clientType);
        CAPBusinessUtil.deleteTemplateFrame(businessBasePath);
        CAPBusinessUtil.deleteTemplateFrame(businessRuntimePath);
        return true;
    }

    public static String getCtxServerHost(HttpServletRequest request, boolean ignore80443) {
        if (request == null) {
            request = AppContext.getRawRequest();
        }
        String host = request.getScheme() + "://" + request.getServerName();
        if (!ignore80443 || request.getServerPort() != 80 && request.getServerPort() != 443) {
            host = host + ":" + request.getServerPort();
        }
        if (!(host = host + request.getContextPath()).endsWith("/")) {
            host = host + "/";
        }
        return host;
    }

    public static Map<String, Object> readConfigJSON(String configPath) {
        File fileConfigJSON = new File(configPath);
        Map jsonObject = null;
        if (fileConfigJSON.exists()) {
            String configStr = FileUtil.readFile((File)fileConfigJSON);
            if (Strings.isBlank((String)configStr)) {
                logger.error((Object)("method readTemplateConfigJSON is error AND configStr is empty. " + configPath));
                return null;
            }
            try {
                jsonObject = (Map)JSONUtil.parseJSONString((String)configStr);
            }
            catch (Exception e) {
                logger.error((Object)("method readTemplateConfigJSON is error AND configStr is " + configStr), (Throwable)e);
            }
        } else {
            logger.error((Object)("method readTemplateConfigJSON is error AND configPath is not exits. " + configPath));
        }
        return jsonObject;
    }

    public static void writeBaseTemplateConfigJSON(Integer clientType, Integer templateType, String dataId, Map<String, Object> jsonObject, Long bizId) {
        String configJSONPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", clientType, templateType, dataId, bizId);
        CAPBusinessUtil.writeConfigJSON(configJSONPath, jsonObject);
    }

    public static void writeConfigJSON(String configJSONPath, Map<String, Object> jsonObject) {
        File fileConfigJSON = new File(configJSONPath);
        logger.info((Object)("\u5199\u5165\u81ea\u5b9a\u4e49\u95e8\u6237\u914d\u7f6e\u6587\u4ef6\uff1a" + configJSONPath + " !!! "));
        FileUtil.writeFile((File)fileConfigJSON, (String)JSONUtil.toJSONString(jsonObject));
    }
}

