/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.template.service.ServiceProxy;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPFormDataLogUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormDataLogUtil.class);
    private static final Integer TRACE_STACK = Integer.valueOf(AppContext.getSystemProperty((String)"cap4.traceChangeFormDataStackLog"));
    private static final Long TRACE_FORM_ID = AppContext.getSystemProperty((String)"cap4.traceFormId") == null ? null : Long.valueOf(AppContext.getSystemProperty((String)"cap4.traceFormId"));
    private static final String TRACE_SUB_TABLE = AppContext.getSystemProperty((String)"cap4.traceSubTable");

    public static void recordTraceFront(Map<String, Object> map, Long formId, boolean isSub) {
        if (TRACE_FORM_ID == null || !TRACE_FORM_ID.equals(formId)) {
            return;
        }
        if (isSub && Strings.isBlank((String)TRACE_SUB_TABLE)) {
            return;
        }
        String message = "trace \u524d\u7aef\u63d0\u4ea4," + isSub + "," + AppContext.currentUserName() + ":";
        LOGGER.info((Object)(message + map));
    }

    public static void recordTrace(FormDataMasterBean formDataMasterBean, String traceMessage) {
        if (TRACE_FORM_ID == null || formDataMasterBean == null) {
            return;
        }
        if (TRACE_FORM_ID.equals(formDataMasterBean.getFormTable().getFormId())) {
            String message = "trace " + traceMessage + "," + AppContext.currentUserName() + ":";
            LOGGER.info((Object)(message + formDataMasterBean.getRowData()));
            if (Strings.isNotBlank((String)TRACE_SUB_TABLE)) {
                String[] tables;
                for (String table : tables = TRACE_SUB_TABLE.split(",")) {
                    List subBeans = formDataMasterBean.getSubData(table);
                    if (CollectionUtils.isEmpty((Collection)subBeans)) continue;
                    for (FormDataSubBean formDataSubBean : subBeans) {
                        LOGGER.info((Object)(message + formDataSubBean.getRowData()));
                    }
                }
            }
        }
    }

    public static void recordRelation(FormRelationshipMapBean mapBean, Long dataId, Map<String, Object> changeField) {
        LOGGER.info((Object)(CAPFormDataLogUtil.getRelationLogBefore(mapBean, dataId) + ",changeField:" + changeField));
    }

    public static void recordRelation(FormRelationshipMapBean mapBean, Long dataId, Set<String> clearTables) {
        LOGGER.info((Object)(CAPFormDataLogUtil.getRelationLogBefore(mapBean, dataId) + ",clearTables:" + clearTables));
    }

    public static void recordRelation(FormRelationshipMapBean mapBean, Long dataId, String clearTable) {
        LOGGER.info((Object)(CAPFormDataLogUtil.getRelationLogBefore(mapBean, dataId) + ",clearTable:" + clearTable));
    }

    private static String getRelationLogBefore(FormRelationshipMapBean mapBean, Long dataId) {
        String str = "data:" + dataId + ",user:" + AppContext.currentUserId();
        if (TRACE_STACK > 0) {
            StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
            ArrayList<String> traceList = new ArrayList<String>();
            int i = 1;
            for (StackTraceElement traceElement : traceElements) {
                if (i > TRACE_STACK) break;
                if (traceElement.getClassName().equals(CAPFormDataLogUtil.class.getName()) || traceElement.getClassName().equals(ServiceProxy.class.getName()) || !traceElement.getClassName().startsWith("com.seeyon") || traceElement.getLineNumber() <= 0) continue;
                String[] className = traceElement.getClassName().split("[.]");
                traceList.add(className[className.length - 1] + "." + traceElement.getMethodName() + ":" + traceElement.getLineNumber());
                ++i;
            }
            str = str + ",traceCode:" + traceList;
        }
        return str + ",relation:" + mapBean.export4Log();
    }
}

