/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.apps.open.api.BusinessOpenApi;
import com.seeyon.cap4.form.api.ExtendManager;
import com.seeyon.cap4.form.api.FormApi4Cap4;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.formula.CustomSelectEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.po.CAPFormRelationRecord;
import com.seeyon.cap4.form.po.CAPFormTriggerSourceRecord;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lbs.manager.LbsManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.form.po.FormSerialCalculateRecord;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.bo.FilterFieldBO;
import com.seeyon.ctp.report.engine.api.interfaces.CustomEnumHandler;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.v3x.common.security.AccessControlBean;
import com.seeyon.v3x.system.util.WaterMarkUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;

public class CAPFormUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormUtil.class);
    private static final List<CustomSelectEnums.DateTime4CustomSelect> DEFAULT_DATE_ENUMS = new ArrayList<CustomSelectEnums.DateTime4CustomSelect>();
    private static final List<String> extendFilePaths = Collections.synchronizedList(new ArrayList());
    private static AtomicBoolean scanFlag = new AtomicBoolean(false);
    private static final String NOT_INCLUDE_CHILD = "cap.form.unFlow.list.notIncludeChild";
    private static final String ENUM_IMAGE_ATTACHMENT = "enumImageAttachment";
    private static final String FIELD_ENUM_ID = "fieldEnumId";
    private static final String APART_AUTH_MAP = "apartAuthMap";
    private static final String DATE_CUSTOM = "date_custom";

    public static ExtendManager getExtendManager() {
        String outerChecker = AppContext.getSystemProperty((String)"capExtend.bean");
        return !StringUtil.checkNull((String)outerChecker) ? (ExtendManager)AppContext.getBean((String)outerChecker) : null;
    }

    public static Map<String, List<Long>> getTableName2FormSubDataBeanIds(Map<String, List<FormDataSubBean>> map) {
        HashMap<String, List<Long>> result = null;
        if (map == null || map.isEmpty()) {
            return result;
        }
        result = new HashMap<String, List<Long>>();
        for (String tableName : map.keySet()) {
            if (map.get(tableName) == null || map.get(tableName).isEmpty()) continue;
            ArrayList<Long> list = new ArrayList<Long>();
            for (FormDataSubBean formDataSubBean : map.get(tableName)) {
                if (formDataSubBean == null) continue;
                list.add(formDataSubBean.getId());
            }
            result.put(tableName, list);
        }
        return result;
    }

    public static FormAuthViewBean getFormAuthViewBean(FormBean formBean, FormDataMasterBean formDataMasterBean, Long rightId) {
        FormAuthViewBean formAuthViewBean = null;
        if (formDataMasterBean.getExtraMap().containsKey("viewRight")) {
            formAuthViewBean = (FormAuthViewBean)formDataMasterBean.getExtraAttr("viewRight");
        }
        if (formAuthViewBean == null) {
            formAuthViewBean = formBean.getAuthViewBeanById(rightId);
        }
        return formAuthViewBean;
    }

    public static FormAuthViewFieldBean getFormAuthViewFieldBean(FormAuthViewBean formAuthViewBean, FormFieldBean formFieldBean, FormDataMasterBean formDataMasterBean, String subId) {
        String fieldKey = formFieldBean.getName();
        if (subId != null && Strings.isNotBlank((String)subId)) {
            fieldKey = fieldKey + "_" + subId;
        }
        FormAuthViewFieldBean formAuthViewFieldBean = null;
        Map apartAuthMap = (Map)formDataMasterBean.getExtraAttr(APART_AUTH_MAP);
        if (apartAuthMap != null) {
            formAuthViewFieldBean = (FormAuthViewFieldBean)apartAuthMap.get(fieldKey);
        }
        if (formAuthViewFieldBean == null) {
            formAuthViewFieldBean = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
        }
        return formAuthViewFieldBean;
    }

    public static List<String> getExtendFilePath() {
        File[] pluginFiles;
        if (scanFlag.get()) {
            return extendFilePaths;
        }
        String extendSuffix = File.separator + "common" + File.separator + "cap4" + File.separator + "extend";
        String extendPath = SystemEnvironment.getApplicationFolder() + extendSuffix;
        String extendContextPath = SystemEnvironment.getContextPath() + "/common/cap4/extend/";
        File extend = new File(extendPath);
        if (!extend.exists()) {
            extend.mkdirs();
        }
        for (File file : pluginFiles = extend.listFiles()) {
            File[] extendFiles;
            String fileName = file.getName();
            if (!AppContext.hasPlugin((String)fileName) || !file.isDirectory()) continue;
            for (File file1 : extendFiles = file.listFiles()) {
                extendFilePaths.add(extendContextPath + fileName + "/" + file1.getName());
            }
        }
        scanFlag.set(true);
        return extendFilePaths;
    }

    public static Map<String, Object> getFlowInfo(Map<String, Object> flowInfo) throws BusinessException {
        CollaborationApi collaborationApi = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        HashMap<String, Object> result = new HashMap<String, Object>();
        String formMasterDataId = String.valueOf(flowInfo.get("formMasterDataId"));
        ColSummary colSummary = collaborationApi.getColSummaryByFormRecordId(Long.valueOf(Long.parseLong(formMasterDataId)));
        result.put("summaryId", String.valueOf(colSummary.getId()));
        return result;
    }

    public static List<Map<String, Object>> getReportFilterFields(List<FilterFieldBO> filterFieldBOS, Map<String, Map<String, Object>> defaultValueMap) throws BusinessException {
        if (CollectionUtils.isEmpty(filterFieldBOS)) {
            return Collections.emptyList();
        }
        HashSet fileKeys = Sets.newHashSet();
        for (FilterFieldBO filterField : filterFieldBOS) {
            fileKeys.add(CAPFormUtil.getFieldKey(filterField.getAliasTableName(), filterField.getName()));
        }
        EnumManager enumManager = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        FormApi4Cap4 formApi4Cap4 = (FormApi4Cap4)AppContext.getBean((String)"formApi4Cap4");
        ArrayList result = Lists.newArrayList();
        for (FilterFieldBO filterField : filterFieldBOS) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String aliasTableName = filterField.getAliasTableName();
            String name = filterField.getName();
            String fieldKey = CAPFormUtil.getFieldKey(aliasTableName, name);
            String inputType = filterField.getFieldComType();
            if (CAPFormUtil.isEnumField(inputType)) {
                ArrayList enums = Lists.newArrayList();
                for (CustomEnumHandler.ReportEnum reportEnum : CAPFormUtil.findReportEnums(filterField)) {
                    HashMap enumValue = Maps.newHashMap();
                    enumValue.put("id", reportEnum.getId());
                    enumValue.put("showValue", reportEnum.getName());
                    enumValue.put("enumValue", reportEnum.getValue());
                    if (ReportConstants.FieldComType.IMAGEENUM.getComName().equals(inputType)) {
                        CtpEnumItem ctpEnumItem = enumManager.getCtpEnumItem(Long.valueOf(Long.parseLong(reportEnum.getId())));
                        enumValue.put("url", SystemEnvironment.getContextPath() + "/fileUpload.do?method=showRTE&fileId=" + ctpEnumItem.getImageId() + "&type=image" + Functions.csrfSuffix());
                    }
                    enums.add(enumValue);
                }
                map.put("enums", enums);
                FormTableBean formTableBean = formApi4Cap4.getTable(filterField.getTableName());
                int index = filterField.getName().indexOf(filterField.getTableName());
                if (index > -1) {
                    String fieldName = filterField.getName();
                    FormFieldBean fieldBean = formTableBean.getFieldBeanByName(fieldName = fieldName.substring(filterField.getTableName().length() + index + 1));
                    if (fieldBean == null) {
                        map.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    } else {
                        FormRelation formRelation = fieldBean.getFormRelation();
                        if (formRelation == null || !fileKeys.contains(CAPFormUtil.getFieldKey(filterField.getAliasTableName(), CAPFormUtil.getFieldKey(filterField.getTableName(), formRelation.getToRelationAttr())))) {
                            map.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        } else {
                            map.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                            map.put("parentField", CAPFormUtil.getFieldKey(filterField.getAliasTableName(), CAPFormUtil.getFieldKey(filterField.getTableName(), formRelation.getToRelationAttr())));
                        }
                    }
                } else {
                    FormFieldBean fieldBean = formTableBean.getFieldBeanByName(filterField.getName());
                    if (fieldBean == null) {
                        map.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    } else {
                        FormRelation formRelation = fieldBean.getFormRelation();
                        if (formRelation == null || !fileKeys.contains(CAPFormUtil.getFieldKey(filterField.getAliasTableName(), formRelation.getToRelationAttr()))) {
                            map.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        } else {
                            map.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                            map.put("parentField", CAPFormUtil.getFieldKey(filterField.getAliasTableName(), formRelation.getToRelationAttr()));
                        }
                    }
                }
            } else if (ReportConstants.FieldComType.DATETIME.getComName().equals(inputType) || ReportConstants.FieldComType.DATE.getComName().equals(inputType)) {
                FormFieldComEnum comEnum = null;
                comEnum = ReportConstants.FieldComType.DATETIME.getComName().equals(inputType) ? FormFieldComEnum.EXTEND_DATETIME : FormFieldComEnum.EXTEND_DATE;
                List<Map<String, Object>> enums = CAPFormUtil.getDefaultTimeEnum(comEnum);
                if (defaultValueMap.containsKey(fieldKey) && Strings.isNotEmpty((String)String.valueOf(defaultValueMap.get(fieldKey).get("value")))) {
                    HashMap<String, Object> enumValue = new HashMap<String, Object>();
                    enumValue.put("id", DATE_CUSTOM);
                    enumValue.put("showValue", filterField.getAliasDisplay());
                    enumValue.put("enumValue", DATE_CUSTOM);
                    enumValue.put("startTime", defaultValueMap.get(fieldKey).get("startTime"));
                    enumValue.put("endTime", defaultValueMap.get(fieldKey).get("endTime"));
                    enums.add(0, enumValue);
                }
                map.put("enums", enums);
            }
            map.put("tableName", filterField.getTableName());
            map.put("aliasTableName", aliasTableName);
            map.put("inputType", inputType);
            map.put("fieldType", filterField.getDbType());
            map.put("name", name);
            map.put("display", filterField.getAliasDisplay());
            map.put("defaultValue", MapUtils.getMap(defaultValueMap, (Object)fieldKey, new HashMap()));
            result.add(map);
        }
        return result;
    }

    private static String getFieldKey(String tableName, String fieldName) {
        return tableName + "_" + fieldName;
    }

    private static boolean isEnumField(String inputType) {
        return ReportConstants.FieldComType.IMAGEENUM.getComName().equals(inputType) || ReportConstants.FieldComType.SELECT.getComName().equals(inputType) || ReportConstants.FieldComType.RADIO.getComName().equals(inputType) || ReportConstants.FieldComType.CUSTOMENUM.getComName().equals(inputType);
    }

    private static List<CustomEnumHandler.ReportEnum> findReportEnums(FilterFieldBO filterField) throws BusinessException {
        ReportApi reportApi = (ReportApi)AppContext.getBean((String)"reportApi");
        HashMap params = Maps.newHashMap();
        params.put("category", filterField.getCategory());
        params.put("tableName", filterField.getTableName());
        params.put("name", filterField.getName());
        params.put("enumId", String.valueOf(filterField.getEnumId()));
        params.put("fieldComType", filterField.getFieldComType());
        params.put("properties", filterField.getProperties());
        return reportApi.findEnums((Map)params);
    }

    private static List<Map<String, Object>> getDefaultTimeEnum(FormFieldComEnum formFieldComEnum) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (CustomSelectEnums.DateTime4CustomSelect dateTime4CustomSelect : DEFAULT_DATE_ENUMS) {
            HashMap<String, String> tempEnum = new HashMap<String, String>();
            tempEnum.put("id", dateTime4CustomSelect.getKey());
            tempEnum.put("showValue", dateTime4CustomSelect.getText());
            tempEnum.put("enumValue", dateTime4CustomSelect.getKey());
            Date[] datas = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(dateTime4CustomSelect.getKey()).getTimeValue();
            tempEnum.put("startTime", CAPFormUtil.getFormatDate(formFieldComEnum, datas[0]));
            tempEnum.put("endTime", CAPFormUtil.getFormatDate(formFieldComEnum, datas[1]));
            result.add(tempEnum);
        }
        return result;
    }

    private static String getFormatDate(FormFieldComEnum formFieldComEnum, Date date) {
        String formatDate = "";
        switch (formFieldComEnum) {
            case EXTEND_DATETIME: {
                formatDate = DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm");
                break;
            }
            case EXTEND_DATE: {
                formatDate = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
                break;
            }
        }
        return formatDate;
    }

    @Deprecated
    public static List<Map<String, Object>> getFilterFields(FormBean formBean, List<SimpleObjectBean> searchFields) throws BusinessException {
        FormFieldBean formFieldBean;
        ArrayList<Map<String, Object>> filterFields = new ArrayList<Map<String, Object>>();
        if (searchFields == null || searchFields.isEmpty()) {
            return filterFields;
        }
        LinkedHashMap pair = Maps.newLinkedHashMap();
        HashSet fieldKeys = Sets.newHashSet();
        for (SimpleObjectBean simpleObjectBean : searchFields) {
            formFieldBean = FormSearchUtil.getFormFieldBean(formBean, simpleObjectBean);
            if (formFieldBean == null) continue;
            fieldKeys.add(formFieldBean.getName());
            pair.put(formFieldBean, simpleObjectBean);
        }
        for (Map.Entry entry : pair.entrySet()) {
            formFieldBean = (FormFieldBean)entry.getKey();
            SimpleObjectBean simpleObjectBean = (SimpleObjectBean)entry.getValue();
            Map<String, Object> filterField = CAPFormUtil.getFilterField(formFieldBean, simpleObjectBean);
            if (formFieldBean.isEnumField()) {
                FormRelation formRelation = formFieldBean.getFormRelation();
                if (formRelation != null && fieldKeys.contains(formRelation.getToRelationAttr())) {
                    filterField.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
                    filterField.put("parentField", CAPFormUtil.getFieldKey(formBean.getFormTableBeanByFieldName(formRelation.getToRelationAttr()).getTableName(), formRelation.getToRelationAttr()));
                } else {
                    filterField.put("multiEnum", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                }
            }
            filterFields.add(filterField);
        }
        return filterFields;
    }

    public static List<Map<String, Object>> getFlowStateEnum(int formType, String fieldName) {
        ArrayList<Map<String, Object>> enums;
        block4: {
            Enums.FromDataFinishedFlagEnum[] vs;
            block5: {
                Enums.FormDataRatifyFlagEnum[] vs2;
                block3: {
                    enums = new ArrayList<Map<String, Object>>();
                    if (!Enums.MasterTableField.state.getKey().equals(fieldName)) break block3;
                    Enums.FormDataStateEnum[] vs3 = null;
                    vs3 = Enums.FormType.processesForm.getKey() == formType ? new Enums.FormDataStateEnum[]{Enums.FormDataStateEnum.FLOW_DRAFT, Enums.FormDataStateEnum.FLOW_UNAUDITED, Enums.FormDataStateEnum.FLOW_AUDITEDPASS, Enums.FormDataStateEnum.FLOW_AUDITEDUNPASS} : new Enums.FormDataStateEnum[]{Enums.FormDataStateEnum.UNFLOW_UNLOCK, Enums.FormDataStateEnum.UNFLOW_LOCKED};
                    for (Enums.FormDataStateEnum formDataStateEnum : vs3) {
                        HashMap<String, Object> enumObject = new HashMap<String, Object>();
                        enumObject.put("id", String.valueOf(formDataStateEnum.ordinal()));
                        enumObject.put("showValue", formDataStateEnum.getText());
                        enumObject.put("enumValue", formDataStateEnum.getKey());
                        enums.add(enumObject);
                    }
                    break block4;
                }
                if (!Enums.MasterTableField.ratifyflag.getKey().equals(fieldName)) break block5;
                for (Enums.FormDataRatifyFlagEnum formDataRatifyFlagEnum : vs2 = Enums.FormDataRatifyFlagEnum.values()) {
                    HashMap<String, Object> enumObject = new HashMap<String, Object>();
                    enumObject.put("id", String.valueOf(formDataRatifyFlagEnum.ordinal()));
                    enumObject.put("showValue", formDataRatifyFlagEnum.getText());
                    enumObject.put("enumValue", formDataRatifyFlagEnum.getKey());
                    enums.add(enumObject);
                }
                break block4;
            }
            if (!Enums.MasterTableField.finishedflag.getKey().equals(fieldName)) break block4;
            for (Enums.FromDataFinishedFlagEnum fromDataFinishedFlagEnum : vs = Enums.FromDataFinishedFlagEnum.values()) {
                HashMap<String, Object> enumObject = new HashMap<String, Object>();
                enumObject.put("id", String.valueOf(fromDataFinishedFlagEnum.ordinal()));
                enumObject.put("showValue", fromDataFinishedFlagEnum.getText());
                enumObject.put("enumValue", fromDataFinishedFlagEnum.getKey());
                enums.add(enumObject);
            }
        }
        return enums;
    }

    @Deprecated
    public static Map<String, Object> getFilterField(FormFieldBean formFieldBean, SimpleObjectBean simpleObjectBean) throws BusinessException {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        String displayName = formFieldBean.getDisplay();
        if (simpleObjectBean.getValue() != null && !displayName.equals(simpleObjectBean.getValue()) && simpleObjectBean.getValue().indexOf("(") > -1) {
            displayName = simpleObjectBean.getValue().substring(simpleObjectBean.getValue().indexOf("(") + 1, simpleObjectBean.getValue().indexOf(")"));
        }
        HashMap<String, Object> filterField = new HashMap<String, Object>();
        filterField.put("tableName", formFieldBean.getOwnerTableName());
        filterField.put("aliasTableName", formFieldBean.getOwnerTableName());
        filterField.put("fieldType", formFieldBean.getFieldType());
        filterField.put("name", formFieldBean.getName());
        filterField.put("display", displayName);
        filterField.put("formRelation", formFieldBean.getFormRelation());
        HashMap defaultValueJson = (HashMap)JSONUtil.parseJSONString((String)simpleObjectBean.getExtAttr("defaultValJOSN"), Map.class);
        if (defaultValueJson == null) {
            defaultValueJson = new HashMap();
        }
        HashMap defaultValue = new HashMap();
        List<Object> enums = new ArrayList();
        String inputType = formFieldBean.getInputType();
        if (Enums.MasterTableField.state.getKey().equals(formFieldBean.getName()) || Enums.MasterTableField.ratifyflag.getKey().equals(formFieldBean.getName()) || Enums.MasterTableField.finishedflag.getKey().equals(formFieldBean.getName())) {
            inputType = ReportConstants.FieldComType.CUSTOMENUM.getComName();
            enums = CAPFormUtil.getFlowStateEnum(Enums.FormType.processesForm.getKey(), formFieldBean.getName());
            filterField.put("enums", enums);
        } else {
            FormFieldComEnum formFieldComEnum = FormFieldComEnum.getEnumByKey((String)inputType);
            switch (formFieldComEnum) {
                case EXTEND_DATE: {
                    Map dateYzxxValueJson = (Map)defaultValueJson.get("dateTimeYzxxValue");
                    if (dateYzxxValueJson != null) {
                        List rightArray = (List)dateYzxxValueJson.get("rightArray");
                        for (Map rightObject : rightArray) {
                            HashMap tempEnum = new HashMap();
                            tempEnum.put("showValue", rightObject.get("name"));
                            tempEnum.put("id", rightObject.get("value"));
                            tempEnum.put("enumValue", rightObject.get("value"));
                            if ("false".equals(String.valueOf(rightObject.get("isSystemVar")))) {
                                String[] datas = String.valueOf(rightObject.get("value")).split("\\|");
                                tempEnum.put("startTime", datas[0]);
                                tempEnum.put("endTime", datas[1]);
                                tempEnum.put("id", DATE_CUSTOM);
                                tempEnum.put("enumValue", DATE_CUSTOM);
                            } else {
                                String enumKey = String.valueOf(rightObject.get("value"));
                                Date[] datas = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(enumKey).getTimeValue();
                                tempEnum.put("startTime", DateUtil.format((Date)datas[0], (String)"yyyy-MM-dd"));
                                tempEnum.put("endTime", DateUtil.format((Date)datas[1], (String)"yyyy-MM-dd"));
                            }
                            enums.add(tempEnum);
                        }
                    } else {
                        enums = CAPFormUtil.getDefaultTimeEnum(formFieldComEnum);
                    }
                    if (enums.size() >= 1 && defaultValueJson.get("defaultCheckFirst") != null && "1".equals(defaultValueJson.get("defaultCheckFirst"))) {
                        Map firstJson = (Map)enums.get(0);
                        defaultValue.put("value", firstJson.get("enumValue"));
                        defaultValue.put("showValue", firstJson.get("showValue"));
                        defaultValue.put("showValue2", firstJson.get("enumValue"));
                        defaultValue.put("startTime", firstJson.get("startTime"));
                        defaultValue.put("endTime", firstJson.get("endTime"));
                    }
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                    break;
                }
                case EXTEND_DATETIME: {
                    Map dateTimeYzxxValueJson = (Map)defaultValueJson.get("dateTimeYzxxValue");
                    if (dateTimeYzxxValueJson != null) {
                        List rightArray = (List)dateTimeYzxxValueJson.get("rightArray");
                        for (Map rightObject : rightArray) {
                            HashMap tempEnum = new HashMap();
                            tempEnum.put("id", rightObject.get("value"));
                            tempEnum.put("showValue", rightObject.get("name"));
                            tempEnum.put("enumValue", rightObject.get("value"));
                            if ("false".equals(String.valueOf(rightObject.get("isSystemVar")))) {
                                String[] datas = String.valueOf(rightObject.get("value")).split("\\|");
                                tempEnum.put("startTime", datas[0]);
                                tempEnum.put("endTime", datas[1]);
                                tempEnum.put("id", DATE_CUSTOM);
                                tempEnum.put("enumValue", DATE_CUSTOM);
                            } else {
                                String enumKey = String.valueOf(rightObject.get("value"));
                                Date[] datas = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(enumKey).getTimeValue();
                                tempEnum.put("startTime", DateUtil.format((Date)datas[0], (String)"yyyy-MM-dd HH:mm"));
                                tempEnum.put("endTime", DateUtil.format((Date)datas[1], (String)"yyyy-MM-dd HH:mm"));
                            }
                            enums.add(tempEnum);
                        }
                    } else {
                        enums = CAPFormUtil.getDefaultTimeEnum(formFieldComEnum);
                    }
                    if (enums.size() >= 1 && defaultValueJson.get("defaultCheckFirst") != null && "1".equals(defaultValueJson.get("defaultCheckFirst"))) {
                        Map firstJson = (Map)enums.get(0);
                        defaultValue.put("value", firstJson.get("enumValue"));
                        defaultValue.put("showValue", firstJson.get("showValue"));
                        defaultValue.put("showValue2", firstJson.get("enumValue"));
                        defaultValue.put("startTime", firstJson.get("startTime"));
                        defaultValue.put("endTime", firstJson.get("endTime"));
                    }
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                    break;
                }
                case RADIO: 
                case SELECT: {
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", CAPFormUtil.getFieldEnumJSON(formFieldBean, null, null, true));
                    break;
                }
                case IMAGE_RADIO: 
                case IMAGE_SELECT: {
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", CAPFormUtil.getFieldEnumJSON(formFieldBean, null, null, true));
                    break;
                }
                case TEXT: 
                case TEXTAREA: {
                    if ("true".equals(defaultValueJson.get("isSettingDefaultVal")) && defaultValueJson.containsKey("defaultVal")) {
                        String defaultVal = (String)defaultValueJson.get("defaultVal");
                        if ("extend".equals(defaultValueJson.get("defaultType"))) {
                            String showValue = "";
                            FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                            CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                            if (formulaVar != null) {
                                showValue = formulaVar.getValue();
                            }
                            if (systemVar4CustomSelect != null) {
                                showValue = systemVar4CustomSelect.getIdValue();
                            }
                            defaultValue.put("value", showValue);
                            defaultValue.put("showValue", showValue);
                            defaultValue.put("showValue2", defaultVal);
                        } else {
                            defaultValue.put("value", defaultVal);
                            defaultValue.put("showValue", defaultVal);
                            defaultValue.put("showValue2", defaultVal);
                        }
                    }
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                    break;
                }
                case EXTEND_MEMBER: 
                case EXTEND_MULTI_MEMBER: {
                    if (defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal"))) {
                        if ("extend".equals(defaultValueJson.get("defaultType"))) {
                            String defaultVal = (String)defaultValueJson.get("defaultVal");
                            String showValue = "";
                            FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                            CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                            if (formulaVar != null) {
                                showValue = formulaVar.getValue();
                            }
                            if (systemVar4CustomSelect != null) {
                                showValue = systemVar4CustomSelect.getIdValue();
                            }
                            if (Strings.isNotBlank((String)showValue)) {
                                String[] menberStringIds = showValue.split(",");
                                StringBuilder sb = new StringBuilder();
                                StringBuilder relaValueSb = new StringBuilder();
                                for (int i = 0; i < menberStringIds.length; ++i) {
                                    Long memberId = Long.valueOf(menberStringIds[i]);
                                    V3xOrgMember v3xOrgMember = orgManager.getMemberById(memberId);
                                    if (i == menberStringIds.length - 1) {
                                        sb.append(v3xOrgMember.getName());
                                        relaValueSb.append("Member|").append(memberId);
                                        continue;
                                    }
                                    sb.append(v3xOrgMember.getName()).append(",");
                                    relaValueSb.append("Member|").append(memberId).append(",");
                                }
                                defaultValue.put("value", relaValueSb.toString());
                                defaultValue.put("showValue", sb.toString());
                                defaultValue.put("showValue2", defaultVal);
                            }
                        } else {
                            StringBuilder showValueSb = new StringBuilder();
                            StringBuilder sb = new StringBuilder();
                            String value = (String)defaultValueJson.get("handOrgIds");
                            if (value.contains(",")) {
                                String[] values = value.split(",");
                                for (int i = 0; i < values.length; ++i) {
                                    Long memberId = Long.valueOf(values[i]);
                                    V3xOrgMember v3xOrgMember = orgManager.getMemberById(memberId);
                                    if (i == values.length - 1) {
                                        sb.append("Member|").append(memberId);
                                        showValueSb.append(v3xOrgMember.getName());
                                        continue;
                                    }
                                    sb.append("Member|").append(memberId).append(",");
                                    showValueSb.append(v3xOrgMember.getName()).append(",");
                                }
                            } else {
                                V3xOrgMember v3xOrgMember = orgManager.getMemberById(Long.valueOf(value));
                                showValueSb.append(v3xOrgMember.getName());
                                sb.append("Member|").append(value);
                            }
                            defaultValue.put("value", sb.toString());
                            defaultValue.put("showValue", showValueSb.toString());
                            defaultValue.put("showValue2", sb.toString());
                        }
                    }
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                    break;
                }
                case EXTEND_DEPARTMENT: 
                case EXTEND_MULTI_DEPARTMENT: {
                    if (defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal"))) {
                        if ("extend".equals(defaultValueJson.get("defaultType"))) {
                            String defaultVal = (String)defaultValueJson.get("defaultVal");
                            String showValue = "";
                            FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                            CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                            if (formulaVar != null) {
                                showValue = formulaVar.getValue();
                            }
                            if (systemVar4CustomSelect != null) {
                                showValue = systemVar4CustomSelect.getIdValue();
                            }
                            if (Strings.isNotBlank((String)showValue)) {
                                String[] departmentStringIds = showValue.split(",");
                                StringBuilder sb = new StringBuilder();
                                StringBuilder relaValueSb = new StringBuilder();
                                for (int i = 0; i < departmentStringIds.length; ++i) {
                                    String departmentId = departmentStringIds[i];
                                    V3xOrgDepartment v3xOrgDepartment = orgManager.getDepartmentById(Long.valueOf(departmentId));
                                    String departmentName = v3xOrgDepartment.getName();
                                    if (systemVar4CustomSelect != null) {
                                        switch (systemVar4CustomSelect) {
                                            case org_currentUserDepartmentId: 
                                            case org_currentUserJZDeptId: 
                                            case org_currentUserSuperiorDeptId: {
                                                departmentId = showValue + "|1";
                                                departmentName = departmentName + ResourceUtil.getString((String)NOT_INCLUDE_CHILD);
                                            }
                                        }
                                    }
                                    if (i == departmentStringIds.length - 1) {
                                        sb.append(departmentName);
                                        relaValueSb.append("Department|").append(departmentId);
                                        continue;
                                    }
                                    sb.append(departmentName).append(",");
                                    relaValueSb.append("Department|").append(departmentId).append(",");
                                }
                                defaultValue.put("value", relaValueSb.toString());
                                defaultValue.put("showValue", sb.toString());
                                defaultValue.put("showValue2", defaultVal);
                            }
                        } else {
                            StringBuilder showValueSb = new StringBuilder();
                            StringBuilder sb = new StringBuilder();
                            String value = (String)defaultValueJson.get("handOrgIds");
                            if ((value = value.replace("BusinessDepartment|", "")).contains(",")) {
                                String[] values = value.split(",");
                                for (int i = 0; i < values.length; ++i) {
                                    Long departmementId = Long.valueOf(values[i]);
                                    V3xOrgDepartment v3xOrgDepartment = orgManager.getDepartmentById(departmementId);
                                    String type = "Department";
                                    if (4 == v3xOrgDepartment.getExternalType()) {
                                        type = "BusinessDepartment";
                                    }
                                    String showName = v3xOrgDepartment.getName();
                                    if (type.equals("BusinessDepartment")) {
                                        V3xOrgAccount father = orgManager.getAccountById(v3xOrgDepartment.getOrgAccountId());
                                        V3xOrgAccount grandfather = (V3xOrgAccount)orgManager.getAllParentAccount(v3xOrgDepartment.getOrgAccountId()).get(0);
                                        showName = father.getShortName() + "(" + grandfather.getShortName() + ")-" + v3xOrgDepartment.getName();
                                    }
                                    if (i == values.length - 1) {
                                        sb.append(type).append("|").append(departmementId);
                                        showValueSb.append(showName);
                                        continue;
                                    }
                                    sb.append(type).append("|").append(departmementId).append(",");
                                    showValueSb.append(showName).append(",");
                                }
                            } else {
                                V3xOrgDepartment v3xOrgDepartment = orgManager.getDepartmentById(Long.valueOf(value));
                                String type = "Department";
                                if (4 == v3xOrgDepartment.getExternalType()) {
                                    type = "BusinessDepartment";
                                }
                                String showName = v3xOrgDepartment.getName();
                                if (type.equals("BusinessDepartment")) {
                                    V3xOrgAccount father = orgManager.getAccountById(v3xOrgDepartment.getOrgAccountId());
                                    V3xOrgAccount grandfather = (V3xOrgAccount)orgManager.getAllParentAccount(v3xOrgDepartment.getOrgAccountId()).get(0);
                                    showName = father.getShortName() + "(" + grandfather.getShortName() + ")-" + v3xOrgDepartment.getName();
                                }
                                showValueSb.append(showName);
                                sb.append(type).append("|").append(value);
                            }
                            defaultValue.put("value", sb.toString());
                            defaultValue.put("showValue", showValueSb.toString());
                            defaultValue.put("showValue2", sb.toString());
                        }
                    }
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                    break;
                }
                case EXTEND_ACCOUNT: 
                case EXTEND_MULTI_ACCOUNT: {
                    if (defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal"))) {
                        if ("extend".equals(defaultValueJson.get("defaultType"))) {
                            String defaultVal = (String)defaultValueJson.get("defaultVal");
                            String showValue = "";
                            FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                            CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                            if (formulaVar != null) {
                                showValue = formulaVar.getValue();
                            }
                            if (systemVar4CustomSelect != null) {
                                showValue = systemVar4CustomSelect.getIdValue();
                            }
                            if (Strings.isNotBlank((String)showValue)) {
                                String[] accountStringIds = showValue.split(",");
                                StringBuilder sb = new StringBuilder();
                                StringBuilder relaValueSb = new StringBuilder();
                                for (int i = 0; i < accountStringIds.length; ++i) {
                                    Long accountId = Long.valueOf(accountStringIds[i]);
                                    V3xOrgAccount v3xOrgAccount = orgManager.getAccountById(accountId);
                                    if (i == accountStringIds.length - 1) {
                                        sb.append(v3xOrgAccount.getName());
                                        relaValueSb.append("Account|").append(accountId);
                                        continue;
                                    }
                                    sb.append(v3xOrgAccount.getName()).append(",");
                                    relaValueSb.append("Account|").append(accountId).append(",");
                                }
                                defaultValue.put("value", relaValueSb.toString());
                                defaultValue.put("showValue", sb.toString());
                                defaultValue.put("showValue2", defaultVal);
                            }
                        } else {
                            StringBuilder showValueSb = new StringBuilder();
                            StringBuilder sb = new StringBuilder();
                            String value = (String)defaultValueJson.get("handOrgIds");
                            if (value.contains(",")) {
                                String[] values = value.split(",");
                                for (int i = 0; i < values.length; ++i) {
                                    Long accountId = Long.valueOf(values[i]);
                                    V3xOrgAccount v3xOrgAccount = orgManager.getAccountById(accountId);
                                    if (i == values.length - 1) {
                                        sb.append("Account|").append(accountId);
                                        showValueSb.append(v3xOrgAccount.getName());
                                        continue;
                                    }
                                    sb.append("Account|").append(accountId).append(",");
                                    showValueSb.append(v3xOrgAccount.getName()).append(",");
                                }
                            } else {
                                V3xOrgAccount v3xOrgAccount = orgManager.getAccountById(Long.valueOf(value));
                                showValueSb.append(v3xOrgAccount.getName());
                                sb.append("Account|").append(value);
                            }
                            defaultValue.put("value", sb.toString());
                            defaultValue.put("showValue", showValueSb.toString());
                            defaultValue.put("showValue2", sb.toString());
                        }
                    }
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                    break;
                }
                case CHECKBOX: {
                    String defaultVal;
                    if (defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal")) && "1".equals(defaultVal = (String)defaultValueJson.get("defaultVal"))) {
                        defaultValue.put("value", defaultVal);
                        defaultValue.put("showValue", defaultVal);
                        defaultValue.put("showValue2", defaultVal);
                    }
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                    break;
                }
                default: {
                    filterField.put("defaultValue", defaultValue);
                    filterField.put("enums", enums);
                }
            }
        }
        filterField.put("inputType", inputType);
        return filterField;
    }

    public static Long copyLBS(Long formId, Long masterDataId, Long subDataId, Long subReference, FormFieldBean formFieldBean) throws BusinessException {
        Long newSubReference = null;
        if (subReference == null) {
            return null;
        }
        if (formFieldBean.isMap()) {
            LbsManager lbsManager = (LbsManager)AppContext.getBean((String)"lbsManager");
            newSubReference = UUIDLong.longUUID();
            HashMap<String, Object> lbsParams = new HashMap<String, Object>();
            lbsParams.put("lbsId", newSubReference);
            lbsParams.put("referenceFormId", formId);
            lbsParams.put("referenceFormMasterDataId", masterDataId);
            if (subDataId != null) {
                lbsParams.put("referenceRecordId", subDataId);
            }
            lbsParams.put("referenceTemplateId", formId);
            lbsParams.put("referenceFieldName", formFieldBean.getName());
            try {
                lbsManager.lbsBaseCopy(subReference.longValue(), lbsParams);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)e);
                newSubReference = null;
            }
        }
        return newSubReference;
    }

    public static String getFieldEnumIdKey(FormFieldBean formFieldBean, FormDataSubBean formDataSubBean) {
        String key = formFieldBean.getName() + "_" + FIELD_ENUM_ID;
        if (formDataSubBean != null) {
            key = key + "_" + formDataSubBean.getId();
        }
        return key;
    }

    public static void putFieldEnumIdToMasterBean(FormDataMasterBean formDataMasterBean, String key, Object value) {
        if (formDataMasterBean == null || Strings.isBlank((String)key)) {
            return;
        }
        HashMap<String, Object> map = (HashMap<String, Object>)formDataMasterBean.getExtraMap().get("fieldEnumIdMap");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put(key, value);
        formDataMasterBean.getExtraMap().put("fieldEnumIdMap", map);
    }

    public static Object getFieldEnumIdFromMasterBean(FormDataMasterBean formDataMasterBean, String key) {
        Object value = null;
        if (formDataMasterBean == null || Strings.isBlank((String)key)) {
            return value;
        }
        Map map = (Map)formDataMasterBean.getExtraMap().get("fieldEnumIdMap");
        value = map == null ? null : map.get(key);
        return value;
    }

    public static List<Map<String, Object>> getFieldEnumJSON(FormFieldBean formFieldBean, FormDataMasterBean formDataMasterBean, FormDataSubBean formDataSubBean, boolean isFilterField) throws BusinessException {
        Long enumId;
        ArrayList<Map<String, Object>> enumInfos = new ArrayList<Map<String, Object>>();
        List ctpEnumItems = null;
        Long paramEnumId = enumId = Long.valueOf(formFieldBean.getEnumId());
        EnumManager enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        if (isFilterField) {
            ctpEnumItems = formFieldBean.getIsFinalChild() ? enumManagerNew.getLastCtpEnumItem(enumId) : enumManagerNew.getCtpEnumItem(enumId, formFieldBean.getEnumLevel());
        } else {
            String pField = formFieldBean.getEnumParent();
            FormRelation relation = formFieldBean.getFormRelation();
            if (Strings.isNotBlank((String)pField) && relation != null && relation.isDataRelationMultiEnum()) {
                String enumKey = CAPFormUtil.getFieldEnumIdKey(formFieldBean, formDataSubBean);
                Iterator enumIdSessValue = CAPFormUtil.getFieldEnumIdFromMasterBean(formDataMasterBean, enumKey);
                if (enumIdSessValue != null && formDataMasterBean != null) {
                    Object parentValue;
                    FormFieldBean pFieldBean = formDataMasterBean.getFormTable().getFieldBeanByName(pField);
                    if (pFieldBean != null && pFieldBean.isMasterField()) {
                        parentValue = formDataMasterBean.getFieldValue(pField);
                    } else {
                        Object object = parentValue = formDataSubBean == null ? null : formDataSubBean.getFieldValue(pField);
                    }
                    if (parentValue != null && !String.valueOf(enumIdSessValue).equals(String.valueOf(parentValue))) {
                        CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, enumKey, null);
                        enumIdSessValue = null;
                    }
                }
                if (enumIdSessValue == null) {
                    CtpEnumItem ctpEnumItem;
                    enumId = 0L;
                    Object value = null;
                    boolean loadValue = true;
                    if (Strings.isNotBlank((String)formFieldBean.getEnumParent())) {
                        Object parentValue;
                        CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
                        FormBean formBean = cap4FormCacheManager.getForm(relation.getToRelationObj());
                        FormFieldBean parentFieldBean = formBean.getFieldBeanByName(formFieldBean.getEnumParent());
                        Object object = parentFieldBean.isMasterField() ? formDataMasterBean.getFieldValue(parentFieldBean.getName()) : (parentValue = formDataSubBean == null ? null : formDataSubBean.getFieldValue(parentFieldBean.getName()));
                        if (parentValue == null) {
                            loadValue = false;
                        }
                    }
                    if (formDataMasterBean != null && loadValue) {
                        if (formFieldBean.isMasterField()) {
                            value = formDataMasterBean.getFieldValue(formFieldBean.getName());
                        } else {
                            Object object = value = formDataSubBean == null ? null : formDataSubBean.getFieldValue(formFieldBean.getName());
                        }
                    }
                    if (value != null && Strings.isNotBlank((String)String.valueOf(value)) && (ctpEnumItem = enumManagerNew.getCtpEnumItem(Long.valueOf(String.valueOf(value)))) != null) {
                        enumId = Long.valueOf(0L).equals(ctpEnumItem.getParentId()) ? ctpEnumItem.getRefEnumid() : ctpEnumItem.getParentId();
                    }
                } else {
                    enumId = (Long)((Object)enumIdSessValue);
                }
                CtpEnumItem ctpEnumItem = enumManagerNew.getCtpEnumItem(enumId);
                if (ctpEnumItem != null) {
                    ctpEnumItems = enumManagerNew.getCtpEnumItem(ctpEnumItem.getRefEnumid(), formFieldBean.getEnumLevel());
                    paramEnumId = ctpEnumItem.getRefEnumid();
                }
            } else {
                ctpEnumItems = formFieldBean.getIsFinalChild() ? enumManagerNew.getLastCtpEnumItem(enumId) : enumManagerNew.getCtpEnumItem(enumId, formFieldBean.getEnumLevel());
            }
        }
        if (ctpEnumItems != null) {
            Map implMap;
            ArrayList<Long> imageIds = new ArrayList<Long>();
            ArrayList<CtpEnumItem> accordCtpEnumItems = new ArrayList<CtpEnumItem>();
            HashMap<Long, Attachment> enumImageAttachment = (HashMap<Long, Attachment>)AppContext.getThreadContext((String)ENUM_IMAGE_ATTACHMENT);
            if (enumImageAttachment == null) {
                enumImageAttachment = new HashMap<Long, Attachment>();
            }
            for (CtpEnumItem ctpEnumItem : ctpEnumItems) {
                if (ctpEnumItem.getId() == 0L || (isFilterField ? ctpEnumItem.getOutputSwitch() == null || ctpEnumItem.getOutputSwitch() != 1 : !formFieldBean.getIsFinalChild() && ctpEnumItem.getParentId() != 0L && !ctpEnumItem.getParentId().equals(enumId))) continue;
                accordCtpEnumItems.add(ctpEnumItem);
                if (ctpEnumItem.getImageId() == null || enumImageAttachment.get(ctpEnumItem.getImageId()) != null) continue;
                imageIds.add(ctpEnumItem.getImageId());
            }
            if (imageIds.size() > 0) {
                AttachmentManager attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
                List attachments = attachmentManager.getAttachmentByFileURLs(imageIds);
                for (Attachment attachment : attachments) {
                    enumImageAttachment.put(attachment.getFileUrl(), attachment);
                }
            }
            if (!isFilterField && (implMap = AppContext.getBeansOfType(BusinessOpenApi.class)) != null && implMap.size() > 0) {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("enumId", paramEnumId);
                params.put("enumLevel", Integer.valueOf(formFieldBean.getEnumLevel()));
                params.put("isFinalChild", Boolean.valueOf(formFieldBean.getIsFinalChild()));
                Iterator loadValue = implMap.values().iterator();
                if (loadValue.hasNext()) {
                    Object obj = loadValue.next();
                    BusinessOpenApi businessOpenApi = (BusinessOpenApi)obj;
                    businessOpenApi.getFormSelectEnumItemList(params, accordCtpEnumItems);
                }
            }
            for (CtpEnumItem ctpEnumItem : accordCtpEnumItems) {
                HashMap<String, String> enumInfo = new HashMap<String, String>();
                enumInfo.put("id", String.valueOf(ctpEnumItem.getId()));
                enumInfo.put("showValue", ResourceUtil.getString((String)ctpEnumItem.getShowvalue()));
                enumInfo.put("enumValue", ctpEnumItem.getValue());
                enumInfo.put("level", String.valueOf(ctpEnumItem.getLevelNum()));
                enumInfo.put("inputState", String.valueOf(ctpEnumItem.getState()));
                String imageUrl = "";
                if (ctpEnumItem.getImageId() != null && !ctpEnumItem.getImageId().equals(0L)) {
                    String createDate = enumImageAttachment.get(ctpEnumItem.getImageId()) == null ? "" : DateUtil.getDate((Date)((Attachment)enumImageAttachment.get(ctpEnumItem.getImageId())).getCreatedate(), (String)"yyyy-MM-dd");
                    imageUrl = SystemEnvironment.getContextPath() + "/fileUpload.do?method=showRTE&fileId=" + String.valueOf(ctpEnumItem.getImageId()) + "&type=image&createDate=" + createDate + Functions.csrfSuffix();
                }
                enumInfo.put("url", imageUrl);
                enumInfos.add(enumInfo);
            }
            AppContext.putThreadContext((String)ENUM_IMAGE_ATTACHMENT, enumImageAttachment);
        }
        return enumInfos;
    }

    public static Map<String, Object> getFormFieldInfo(FormFieldBean formFieldBean, FormDataMasterBean formDataMasterBean) throws BusinessException {
        HashMap<String, Object> fieldInfo = new HashMap<String, Object>();
        fieldInfo.put("name", formFieldBean.getName());
        fieldInfo.put("display", formFieldBean.getDisplay());
        fieldInfo.put("fieldType", formFieldBean.getFieldType());
        fieldInfo.put("inputType", formFieldBean.getInputType());
        fieldInfo.put("placeHolder", formFieldBean.getPlaceHolder());
        fieldInfo.put("desc", formFieldBean.getDesc());
        fieldInfo.put("formatType", formFieldBean.getFormatType());
        fieldInfo.put("fieldLength", formFieldBean.getFieldLength());
        fieldInfo.put("digitNum", formFieldBean.getDigitNum());
        fieldInfo.put("isInCalculate", formFieldBean.needCalculation() ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        fieldInfo.put("isAttachment", formFieldBean.isAttachment() ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        if (formFieldBean.isEnumField() && (formFieldBean.isMasterField() || formFieldBean.isSubField() && !FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(formFieldBean.getInputType()))) {
            fieldInfo.put("enums", CAPFormUtil.getFieldEnumJSON(formFieldBean, formDataMasterBean, null, false));
        }
        if (formFieldBean.isCustomerCtrl()) {
            HashMap<String, Object> customFieldInfo = new HashMap<String, Object>();
            FormFieldCustomCtrl customCtrl = (FormFieldCustomCtrl)FormFieldUtil.getFormFieldCtrl((String)formFieldBean.getInputType());
            customFieldInfo.put("customParam", JSONUtil.parseJSONString((String)formFieldBean.getCustomParam()));
            customFieldInfo.put("pcInjectionInfo", Strings.isBlank((String)customCtrl.getPCInjectionInfo()) ? null : JSONUtil.parseJSONString((String)customCtrl.getPCInjectionInfo()));
            customFieldInfo.put("mbInjectionInfo", Strings.isBlank((String)customCtrl.getMBInjectionInfo()) ? null : JSONUtil.parseJSONString((String)customCtrl.getMBInjectionInfo()));
            fieldInfo.put("customFieldInfo", customFieldInfo);
            fieldInfo.put("isCustomField", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        } else {
            fieldInfo.put("isCustomField", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        }
        return fieldInfo;
    }

    public static void resetFormFieldInfo(Map<String, Object> fieldInfo, String operateType, Set<String> autoIncConditionFields) {
        if (CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(operateType)) {
            fieldInfo.put("isInCalculate", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        } else if (Strings.isNotEmpty(autoIncConditionFields) && autoIncConditionFields.contains(fieldInfo.get("name"))) {
            fieldInfo.put("isInCalculate", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        }
    }

    public static Map<String, Object> getDisplayValueMap(Object value, FormFieldBean formFieldBean, Object authObject) throws BusinessException {
        HashMap<String, Object> dataInfo = new HashMap<String, Object>();
        Object[] values = formFieldBean.getDisplayValue(value, false);
        if (values[0] != null && FormFieldComEnum.FLOWDEALOPITION.getKey().equalsIgnoreCase(formFieldBean.getInputType()) && formFieldBean.getFormatType().contains(Enums.FlowDealOptionsType.signet.getKey())) {
            Map resMap = FormUtil.getFlowDealSignetHtml((String)String.valueOf(values[0]));
            String dealStr = (String)resMap.get("html");
            values[1] = dealStr;
            values[2] = dealStr;
        }
        if ((FormFieldComEnum.RADIO.getKey().equalsIgnoreCase(formFieldBean.getInputType()) || FormFieldComEnum.RADIO.getKey().equalsIgnoreCase(formFieldBean.getInputType())) && (values[0] == null || Strings.isBlank((String)String.valueOf(values[0]))) && "0".equals(String.valueOf(values[2]))) {
            values[2] = "";
        }
        String auth = null;
        if (authObject != null) {
            auth = authObject instanceof FormAuthViewFieldBean ? ((FormAuthViewFieldBean)authObject).getAccess() : (String)authObject;
        }
        if (auth != null && Enums.FieldAccessType.hide.getKey().equals(auth)) {
            dataInfo.put("value", "***");
            dataInfo.put("showValue", "***");
            dataInfo.put("showValue2", "***");
        } else {
            dataInfo.put("value", values[0] == null ? "" : String.valueOf(values[0]));
            dataInfo.put("showValue", values[1] == null ? "" : String.valueOf(values[1]));
            dataInfo.put("showValue2", values[2] == null ? "" : String.valueOf(values[2]));
        }
        return dataInfo;
    }

    public static void processSerial4Formula(FormDataMasterBean cacheMasterData, FormBean form, FormAuthViewBean auth) throws BusinessException {
        List serialRecordList = (List)cacheMasterData.getExtraAttr("serialCalRecords");
        cacheMasterData.putExtraAttr("needProduceValue", "true");
        if (serialRecordList != null) {
            FormFieldBean ffb;
            CAP4FormDataManager cap4FormDataManager = (CAP4FormDataManager)AppContext.getBean((String)"cap4FormDataManager");
            ArrayList cycleList = new ArrayList(serialRecordList);
            ArrayList<FormSerialCalculateRecord> subMap = new ArrayList<FormSerialCalculateRecord>();
            for (FormSerialCalculateRecord fscr : cycleList) {
                ffb = form.getFieldBeanByName(fscr.getFieldName());
                if (ffb == null) continue;
                if (ffb.isSubField()) {
                    subMap.add(fscr);
                    continue;
                }
                cap4FormDataManager.calc4EditingForm(form, ffb, cacheMasterData, null, null, auth, false);
            }
            for (FormSerialCalculateRecord record : subMap) {
                FormDataSubBean subData;
                if (record == null || null == (subData = cacheMasterData.getFormDataSubBeanById((ffb = form.getFieldBeanByName(record.getFieldName())).getOwnerTableName(), record.getFormSubId())) && !ffb.isMasterField()) continue;
                cap4FormDataManager.calc4EditingForm(form, ffb, cacheMasterData, subData, null, auth, false);
            }
        }
    }

    public static Map<String, List<FormFieldBean>> getTableName2FieldBeans(FormBean formBean, FormViewBean formViewBean) {
        HashMap<String, List<FormFieldBean>> fieldBeanMap = new HashMap<String, List<FormFieldBean>>();
        for (String fieldName : formViewBean.getFieldList()) {
            FormFieldBean fieldBean = formBean.getFieldBeanByName(fieldName);
            if (fieldBean == null) continue;
            ArrayList<FormFieldBean> fieldBeans = (ArrayList<FormFieldBean>)fieldBeanMap.get(fieldBean.getOwnerTableName());
            if (fieldBeans == null) {
                fieldBeans = new ArrayList<FormFieldBean>();
                fieldBeanMap.put(fieldBean.getOwnerTableName(), fieldBeans);
            }
            fieldBeans.add(fieldBean);
        }
        return fieldBeanMap;
    }

    public static List<FormFieldBean> getViewTableNameFieldBeans(FormBean formBean, FormViewBean formViewBean, String tableName) {
        ArrayList<FormFieldBean> fieldBeans = new ArrayList<FormFieldBean>();
        for (String fieldName : formViewBean.getFieldList()) {
            FormFieldBean fieldBean = formBean.getFieldBeanByName(fieldName);
            if (fieldBean == null || !fieldBean.getOwnerTableName().equals(tableName)) continue;
            fieldBeans.add(fieldBean);
        }
        return fieldBeans;
    }

    public static List<Map<String, String>> getRelationInfoMaps(List<FormRelationshipMapBean> mapBeans) {
        ArrayList<Map<String, String>> list = null;
        if (CollectionUtils.isNotEmpty(mapBeans)) {
            list = new ArrayList<Map<String, String>>();
            for (FormRelationshipMapBean formRelationshipMapBean : mapBeans) {
                Map<String, String> relationInfo = CAPFormUtil.getRelationCommonJSON(formRelationshipMapBean);
                list.add(relationInfo);
            }
        }
        return list;
    }

    public static Map<String, String> getRelationCommonJSON(FormRelationshipMapBean formRelationshipMapBean) {
        CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        FormBean formBean = cap4FormCacheManager.getForm(formRelationshipMapBean.getRelationshipBean().getSourceFormId());
        HashMap<String, String> relationInfo = new HashMap<String, String>();
        relationInfo.put("fillInRow", String.valueOf(formRelationshipMapBean.getFillInRow()));
        if (Strings.isBlank((String)formRelationshipMapBean.getSelectorName())) {
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(formRelationshipMapBean.getSelectedField());
            relationInfo.put("buttonName", formFieldBean.getDisplay());
        } else {
            relationInfo.put("buttonName", formRelationshipMapBean.getSelectorName());
        }
        relationInfo.put("relationShipId", String.valueOf(formRelationshipMapBean.getRelationshipBean().getId()));
        FormRelationshipMapBean mainSelector = formRelationshipMapBean.getRelationshipBean().getMainSelector();
        relationInfo.put("mainSelector", mainSelector == null ? "" : mainSelector.getSelectedField());
        String mainSelectorDisplay = "";
        if (mainSelector != null) {
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(mainSelector.getSelectedField());
            mainSelectorDisplay = formFieldBean.getDisplay();
        }
        relationInfo.put("mainSelectorDisplay", mainSelectorDisplay);
        relationInfo.put("toVersion", MagicPrivateUtils.getRelationReadyTargetVersion(formRelationshipMapBean));
        relationInfo.put("fieldInfo", formRelationshipMapBean.getSelectedField());
        return relationInfo;
    }

    public static boolean relationFieldHasEditAuth(List<FormRelationshipMapBean> formRelationshipMapBeans) {
        boolean canEdit = false;
        for (FormRelationshipMapBean mapBean : formRelationshipMapBeans) {
            if (mapBean.getEditFieldValue() != 1) continue;
            canEdit = true;
            break;
        }
        return canEdit;
    }

    public static String getRelationFieldAuth(List<FormRelationshipMapBean> formRelationshipMapBeans, Map<String, String> authMap) {
        String fieldAuth = authMap.get("auth");
        if (CollectionUtils.isNotEmpty(formRelationshipMapBeans) && (Enums.FieldAccessType.edit.getKey().equals(fieldAuth) || Enums.FieldAccessType.add.getKey().equals(fieldAuth))) {
            boolean canEdit = CAPFormUtil.relationFieldHasEditAuth(formRelationshipMapBeans);
            fieldAuth = !canEdit ? Enums.FieldAccessType.browse.getKey() : fieldAuth;
            authMap.put("auth", fieldAuth);
        }
        return fieldAuth;
    }

    public static Map<String, String> getRelationData(List<FormRelationshipMapBean> mapBeans, Map<String, CAPFormRelationRecord> relationRecordMap, FormDataBean formDataBean, String fieldName, Map<String, String> authMap) {
        CAPFormRelationRecord relationRecord = relationRecordMap.get(formDataBean.generageFillbackKey(fieldName));
        return CAPFormUtil.getRelationData(mapBeans, relationRecord, authMap);
    }

    public static Map<String, String> getRelationData(List<FormRelationshipMapBean> mapBeans, Map<String, CAPFormRelationRecord> relationRecordMap, String recordId, String fieldName, Map<String, String> authMap) {
        CAPFormRelationRecord relationRecord = relationRecordMap.get(recordId == null ? fieldName : fieldName + "_" + recordId);
        return CAPFormUtil.getRelationData(mapBeans, relationRecord, authMap);
    }

    public static Map<String, String> getRelationData(List<FormRelationshipMapBean> mapBeans, CAPFormRelationRecord relationRecord, Map<String, String> authMap) {
        boolean isBrowse = Enums.FieldAccessType.browse.getKey().equals(authMap.get("auth")) || Enums.FieldAccessType.hide.getKey().equals(authMap.get("auth"));
        String fieldAuth = CAPFormUtil.getRelationFieldAuth(mapBeans, authMap);
        Map<String, String> relationData = CAPFormUtil.getRelationData(relationRecord, fieldAuth);
        relationData.put("imgShow", isBrowse ? "0" : "1");
        return relationData;
    }

    private static Map<String, String> getRelationData(CAPFormRelationRecord relationRecord, String fieldAuth) {
        HashMap<String, String> relationData = new HashMap<String, String>();
        if (relationRecord == null || relationRecord.getDataInfoVO() == null) {
            relationData.put("viewThrough", "0");
        } else {
            if (!Enums.FieldAccessType.browse.getKey().equals(fieldAuth)) {
                relationData.put("viewThrough", "0");
            } else {
                relationData.put("viewThrough", String.valueOf(relationRecord.getViewThrough()));
            }
            CAPFormRelationRecord.DataInfoVO dataInfoVO = relationRecord.getDataInfoVO();
            relationData.put("pcView", dataInfoVO.getPcView());
            relationData.put("phoneView", dataInfoVO.getPhoneView());
            relationData.put("toFormType", String.valueOf(relationRecord.getFormType()));
            relationData.put("relationShipId", String.valueOf(relationRecord.getRelationShipId()));
            relationData.put("toMasterDataId", String.valueOf(relationRecord.getToMasterDataId()));
        }
        return relationData;
    }

    @Deprecated
    public static Map<String, String> getRelationDataJSON(FormRelationshipMapBean formRelationshipMapBean, Map<String, CAPFormRelationRecord> capFormRelationRecordMap, FormFieldBean formFieldBean, Map<String, String> authMap, Map<String, String> relationInfo, String recordId) throws BusinessException {
        String key;
        CAPFormRelationRecord capFormRelationRecord;
        String fieldAuth = authMap.get("auth");
        HashMap<String, String> relationData = new HashMap<String, String>();
        relationData.put("imgShow", Enums.FieldAccessType.browse.getKey().equals(fieldAuth) || Enums.FieldAccessType.hide.getKey().equals(fieldAuth) ? "0" : "1");
        if (formRelationshipMapBean != null && (Enums.FieldAccessType.edit.getKey().equals(fieldAuth) || Enums.FieldAccessType.add.getKey().equals(fieldAuth))) {
            authMap.put("auth", "0".equals(String.valueOf(formRelationshipMapBean.getEditFieldValue())) ? Enums.FieldAccessType.browse.getKey() : fieldAuth);
            fieldAuth = authMap.get("auth");
        }
        if ((capFormRelationRecord = capFormRelationRecordMap.get(key = formFieldBean.getName() + (Strings.isNotBlank((String)recordId) ? "_" + recordId : ""))) != null) {
            relationData.put("toMasterDataId", String.valueOf(capFormRelationRecord.getToMasterDataId()));
        }
        if (!Enums.FieldAccessType.browse.getKey().equals(fieldAuth)) {
            relationData.put("viewThrough", "0");
        } else {
            CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
            relationData.put("viewThrough", String.valueOf(formRelationshipMapBean.getViewThrough()));
            if (formRelationshipMapBean.getViewThrough() == 1) {
                Long toFormId;
                FormBean toFormBean;
                relationInfo.put("pcView", CAPFormUtil.getManualRelationViewRightId(formRelationshipMapBean, "pcView"));
                relationInfo.put("phoneView", CAPFormUtil.getManualRelationViewRightId(formRelationshipMapBean, "phoneView"));
                CAP4FormRelationActionManager cap4FormRelationActionManager = (CAP4FormRelationActionManager)AppContext.getBean((String)"cap4FormRelationActionManager");
                cap4FormRelationActionManager.addRelationThroughUnFlowRight(formRelationshipMapBean, "view");
                if (capFormRelationRecord != null) {
                    CAPFormUtil.addFormAccessControl(capFormRelationRecord.getToMasterDataId(), AppContext.currentUserId());
                }
                if ((toFormBean = cap4FormCacheManager.getForm(toFormId = Long.valueOf(formRelationshipMapBean.getRelationshipBean().getTargetFormId()))) != null) {
                    if (Enums.FormType.unFlowForm.getKey() == toFormBean.getFormType()) {
                        relationInfo.put("toFormType", ModuleType.cap4UnflowForm.getValue());
                    } else if (Enums.FormType.processesForm.getKey() == toFormBean.getFormType()) {
                        relationInfo.put("toFormType", ModuleType.collaboration.getValue());
                    }
                } else if (capFormRelationRecord != null) {
                    if (Enums.FormType.unFlowForm.getKey() == capFormRelationRecord.getFormType().intValue()) {
                        relationInfo.put("toFormType", ModuleType.cap4UnflowForm.getValue());
                    } else {
                        relationInfo.put("toFormType", String.valueOf(capFormRelationRecord.getFormType()));
                    }
                }
            }
        }
        return relationData;
    }

    private static String getManualRelationViewRightId(FormRelationshipMapBean shipMap, String viewType) throws BusinessException {
        CAP4FormRelationActionManager cap4FormRelationActionManager = (CAP4FormRelationActionManager)AppContext.getBean((String)"cap4FormRelationActionManager");
        String rightId = "";
        if (cap4FormRelationActionManager.isMagicManualRelation(shipMap.getRelationshipBean())) {
            ICAP4MagicManager cap4MagicManager = (ICAP4MagicManager)AppContext.getBean((String)"cap4MagicManager");
            rightId = cap4MagicManager.getRelationRealRightId(shipMap, viewType);
        } else if ("pcView".equals(viewType)) {
            rightId = shipMap.getPcView();
        } else if ("phoneView".equals(viewType)) {
            rightId = shipMap.getPhoneView();
        }
        return rightId;
    }

    public static Map<String, String> getTriggerDataJSON(Map<String, CAPFormTriggerSourceRecord> capFormTriggerSourceRecordMap, FormFieldBean formFieldBean, Map<String, String> authMap, String recordId) {
        String fieldAuth = authMap.get("auth");
        HashMap<String, String> triggerData = new HashMap<String, String>();
        String key = formFieldBean.getName();
        if (Strings.isNotBlank((String)recordId)) {
            key = key + "_" + recordId;
        }
        CAPFormTriggerSourceRecord capFormTriggerSourceRecord = capFormTriggerSourceRecordMap.get(key);
        CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        FormTriggerBean formTriggerBean = null;
        if (null != capFormTriggerSourceRecord) {
            formTriggerBean = cap4FormCacheManager.getFormTriggerBean(capFormTriggerSourceRecord.getTriggerId());
        }
        if (!Enums.FieldAccessType.browse.getKey().equals(fieldAuth) || formTriggerBean == null || formTriggerBean.getState() == 0) {
            triggerData.put("viewThrough", "0");
        } else {
            triggerData.put("viewThrough", "1");
            Long sourceFormId = capFormTriggerSourceRecord.getSourceFormId();
            FormBean sourceFormBean = cap4FormCacheManager.getForm(sourceFormId);
            if (sourceFormBean != null) {
                triggerData.put("toMasterDataId", String.valueOf(capFormTriggerSourceRecord.getModuleId()));
                String viewAuth = capFormTriggerSourceRecord.getViewAuth();
                String pcView = "";
                String phoneView = "";
                if (viewAuth.startsWith(",")) {
                    phoneView = viewAuth.replace(",", "");
                } else if (viewAuth.endsWith(",")) {
                    pcView = viewAuth.replace(",", "");
                } else {
                    pcView = viewAuth.split(",")[0];
                    phoneView = viewAuth.split(",")[1];
                }
                triggerData.put("pcView", pcView);
                triggerData.put("phoneView", phoneView);
                CAPFormManager capFormManager = (CAPFormManager)AppContext.getBean((String)"capFormManager");
                capFormManager.addRight(pcView);
                capFormManager.addRight(phoneView);
                if (Enums.FormType.unFlowForm.getKey() == sourceFormBean.getFormType()) {
                    triggerData.put("toFormType", ModuleType.cap4UnflowForm.getValue());
                } else if (Enums.FormType.processesForm.getKey() == sourceFormBean.getFormType()) {
                    triggerData.put("toFormType", ModuleType.collaboration.getValue());
                }
                if (Strings.isNotBlank((String)pcView) || Strings.isNotBlank((String)phoneView)) {
                    CAPFormUtil.addFormAccessControl(capFormTriggerSourceRecord.getModuleId(), AppContext.currentUserId());
                }
            }
        }
        return triggerData;
    }

    public static Map<String, String> getAuthMap(FormFieldBean formFieldBean, FormAuthViewFieldBean formAuthViewFieldBean, String operateType, boolean isThreshold) {
        HashMap<String, String> fieldAuthInfo = new HashMap<String, String>();
        fieldAuthInfo.put("isNotNull", String.valueOf(formAuthViewFieldBean.getIsNotNull()));
        if (formFieldBean.isSn() && (Enums.FieldAccessType.edit.getKey().equals(formAuthViewFieldBean.getAccess()) || Enums.FieldAccessType.add.getKey().equals(formAuthViewFieldBean.getAccess()))) {
            fieldAuthInfo.put("auth", Enums.FieldAccessType.browse.getKey());
            fieldAuthInfo.put("isNotNull", "0");
        } else if (formFieldBean.isCalcField() && (Enums.FieldAccessType.edit.getKey().equals(formAuthViewFieldBean.getAccess()) || Enums.FieldAccessType.add.getKey().equals(formAuthViewFieldBean.getAccess()))) {
            fieldAuthInfo.put("auth", Enums.FieldAccessType.browse.getKey());
            fieldAuthInfo.put("isNotNull", "0");
        } else if (FormFieldComEnum.FLOWDEALOPITION.getKey().equalsIgnoreCase(formFieldBean.getInputType()) && (Enums.FieldAccessType.edit.getKey().equals(formAuthViewFieldBean.getAccess()) || Enums.FieldAccessType.add.getKey().equals(formAuthViewFieldBean.getAccess()))) {
            fieldAuthInfo.put("auth", Enums.FieldAccessType.browse.getKey());
            fieldAuthInfo.put("isNotNull", "0");
        } else if ((CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(operateType) || isThreshold) && (Enums.FieldAccessType.edit.getKey().equals(formAuthViewFieldBean.getAccess()) || Enums.FieldAccessType.add.getKey().equals(formAuthViewFieldBean.getAccess()))) {
            fieldAuthInfo.put("auth", Enums.FieldAccessType.browse.getKey());
        } else {
            fieldAuthInfo.put("auth", formAuthViewFieldBean.getAccess());
        }
        if (CAPBusinessEnum.FormOperateType.BROWSE.getKey().equals(operateType)) {
            fieldAuthInfo.put("isNotNull", "0");
        }
        return fieldAuthInfo;
    }

    public static void addFormAccessControl(Long moduleId, Long userId) {
        if (moduleId == null || userId == null) {
            return;
        }
        AccessControlBean.getInstance().addAccessControl(ApplicationCategoryEnum.form, moduleId.toString(), userId.longValue());
    }

    public static boolean isPcLogin(int userAgent) {
        return userAgent == Constants.login_sign.pc.value() || userAgent == Constants.login_sign.ucpc.value();
    }

    public static boolean isPhoneLogin(int userAgent) {
        return userAgent == Constants.login_sign.phone.value() || userAgent == Constants.login_sign.wechat.value();
    }

    public static FormDataMasterBean fillMappingData(FormBean formBean, FormDataMasterBean formDataMasterBean, Long fromModuleId, Long fromRecordId, Map<String, Object> mappingData, Map<String, String> mappingField) throws BusinessException {
        for (String fromFieldName : mappingField.keySet()) {
            String toFieldName = mappingField.get(fromFieldName);
            Object value = mappingData.get(fromFieldName);
            FormFieldBean fieldBean = formBean.getFieldBeanByName(toFieldName);
            if (fieldBean.isAttachment() || fieldBean.isMap()) {
                Long newSubReference = null;
                if (value != null) {
                    Long subReference;
                    List attachments = null;
                    if (value instanceof Map) {
                        subReference = Long.parseLong(String.valueOf(((Map)value).get("value")));
                        attachments = (List)((Map)value).get("attachments");
                    } else {
                        subReference = Long.parseLong(String.valueOf(value));
                    }
                    if (fieldBean.isMap()) {
                        newSubReference = CAPFormUtil.copyLBS(formBean.getId(), formDataMasterBean.getId(), fromRecordId, subReference, fieldBean);
                    }
                    if (fieldBean.isAttachment()) {
                        Long newReference = fromModuleId;
                        newSubReference = value instanceof Map ? CAPAttachmentUtil.copyAttachment(formDataMasterBean, fieldBean, newReference, newSubReference, attachments, false) : CAPAttachmentUtil.copyAttachment(formDataMasterBean, fieldBean, subReference, newReference, newSubReference, false);
                    }
                }
                value = newSubReference;
            }
            Object oldValue = null;
            if (fieldBean.isMasterField()) {
                oldValue = formDataMasterBean.getFieldValue(fieldBean.getName());
                formDataMasterBean.addFieldValue(fieldBean.getName(), value);
            } else if (fieldBean.isSubField()) {
                FormDataSubBean formDataSubBean = formDataMasterBean.getFormDataSubBeanById(fieldBean.getOwnerTableName(), fromRecordId);
                oldValue = formDataSubBean.getFieldValue(fieldBean.getName());
                formDataSubBean.addFieldValue(fieldBean.getName(), value);
            }
            if (oldValue == null || String.valueOf(oldValue).equals(String.valueOf(value)) || !fieldBean.isAttachment()) continue;
            formDataMasterBean.putSessionAttachments(String.valueOf(oldValue), null);
        }
        return formDataMasterBean;
    }

    public static Map<String, String> getWaterMark(String type, Map<String, Object> advancedSet) throws BusinessException {
        HashMap systemWaterMarkSetting = new HashMap();
        WaterMarkUtil.getWaterMarkSetings(systemWaterMarkSetting);
        HashMap<String, String> waterMark = null;
        if ("true".equals(systemWaterMarkSetting.get("waterMarkEnable"))) {
            Map waterMarkInfo = (Map)systemWaterMarkSetting.get("waterMarkInfo");
            String pc = (String)((Map)waterMarkInfo.get("pc")).get(type + "Pc");
            String mobile = (String)((Map)waterMarkInfo.get("m")).get(type + "M");
            String pcPrint = (String)((Map)waterMarkInfo.get("pc")).get("printPc");
            String mobilePrint = (String)((Map)waterMarkInfo.get("m")).get("printM");
            if ("form".equals(type)) {
                if (advancedSet != null && advancedSet.get("watermark") != null) {
                    waterMark = new HashMap(7);
                    waterMark.putAll((Map)advancedSet.get("watermark"));
                    waterMark.put("pc", "1".equals(waterMark.get("pc")) && "true".equals(pc) ? "1" : "0");
                    waterMark.put("mobile", "1".equals(waterMark.get("mobile")) && "true".equals(mobile) ? "1" : "0");
                    waterMark.put("pcPrint", "1".equals(waterMark.get("pc")) && "true".equals(pcPrint) ? "1" : "0");
                    waterMark.put("mobilePrint", "1".equals(waterMark.get("mobile")) && "true".equals(mobilePrint) ? "1" : "0");
                }
            } else {
                waterMark = new HashMap(7);
                waterMark.put("pc", "true".equals(pc) ? "1" : "0");
                waterMark.put("mobile", "true".equals(mobile) ? "1" : "0");
                waterMark.put("pcPrint", "true".equals(pcPrint) ? "1" : "0");
                waterMark.put("mobilePrint", "true".equals(mobilePrint) ? "1" : "0");
            }
            if (waterMark != null) {
                waterMark.put("name", systemWaterMarkSetting.get("waterMarkName") == null ? "" : String.valueOf(systemWaterMarkSetting.get("waterMarkName")));
                waterMark.put("depart", systemWaterMarkSetting.get("waterMarkDeptName") == null ? "" : String.valueOf(systemWaterMarkSetting.get("waterMarkDeptName")));
                waterMark.put("time", systemWaterMarkSetting.get("waterMarkTime") == null ? "" : String.valueOf(systemWaterMarkSetting.get("waterMarkTime")));
            }
        }
        if (waterMark == null) {
            waterMark = new HashMap<String, String>(7);
            waterMark.put("pc", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            waterMark.put("mobile", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            waterMark.put("pcPrint", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            waterMark.put("mobilePrint", CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            waterMark.put("name", "");
            waterMark.put("depart", "");
            waterMark.put("time", "");
        }
        return waterMark;
    }

    public static Map<String, String> getFormWaterMark(FormBean formBean) throws BusinessException {
        return CAPFormUtil.getWaterMark("form", formBean.getAdvancedSet());
    }

    public static boolean getMobileAuth(SimpleObjectBean simpleObjectBean) {
        Map position = (Map)JSONUtil.parseJSONString((String)simpleObjectBean.getExtAttr("position"), Map.class);
        Object dataRow = position.get(FormBindAuthBean.ShowPosition.DataRow.getKey());
        if (dataRow instanceof String) {
            return "true".equals(String.valueOf(position.get(FormBindAuthBean.ShowPosition.DataRow.getKey()))) || "true".equals(String.valueOf(position.get(FormBindAuthBean.ShowPosition.ToolBar.getKey())));
        }
        if (dataRow instanceof Boolean) {
            return (Boolean)dataRow != false || (Boolean)position.get(FormBindAuthBean.ShowPosition.ToolBar.getKey()) != false;
        }
        return false;
    }

    public static boolean getPcNewAuth(SimpleObjectBean simpleObjectBean) {
        Map position = (Map)JSONUtil.parseJSONString((String)simpleObjectBean.getExtAttr("position"), Map.class);
        Object dataRow = position.get(FormBindAuthBean.ShowPosition.ToolBar.getKey());
        if (dataRow instanceof String) {
            return "true".equals(String.valueOf(position.get(FormBindAuthBean.ShowPosition.ToolBar.getKey())));
        }
        if (dataRow instanceof Boolean) {
            return (Boolean)dataRow;
        }
        return false;
    }

    static {
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisyear);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisSeason);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisMonth);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisWeek);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_today);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_preMonth);
    }
}

