/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.HttpSessionUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public class PhantomJSUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(PhantomJSUtil.class);
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final String ARCH = System.getProperty("os.arch").toLowerCase();
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String CAP4_PHANTOMJS_ERROR = "CAP4_PHANTOMJS_ERROR";
    private static final String CAP4_PHANTOMRESOURCE_ERROR = "CAP4_PHANTOMRESOURCE_ERROR";
    private static final String BIT_32 = "32";
    private static final String BIT_64 = "64";
    private static final String BLANK = "  ";
    private static final String WEB_SERVER_IP = "127.0.0.1";
    private static final int WEB_SERVER_PORT = 9920;

    public static String doScreenCapture(String url, Map<String, Object> screenParams, Map<String, Object> extParams, String renderType) {
        HashMap<String, Object> execParams = new HashMap<String, Object>();
        execParams.put("renderType", renderType);
        execParams.put("filePath", "");
        return PhantomJSUtil.execute(url, screenParams, extParams, execParams);
    }

    public static V3XFile doScreenCapture4File(String url, Map<String, Object> screenParams, Map<String, Object> extParams, String renderType) {
        V3XFile v3XFile = null;
        Long id = UUIDLong.longUUID();
        String filePath = CAPBusinessTemplateUtil.getTemplateTempFolder() + File.separator;
        FileUtil.makeDir((String)filePath);
        File file = new File(filePath + id + "." + renderType);
        HashMap<String, Object> execParams = new HashMap<String, Object>();
        execParams.put("renderType", renderType);
        execParams.put("filePath", file.getAbsolutePath());
        String result = PhantomJSUtil.execute(url, screenParams, extParams, execParams);
        if ("success".equals(result)) {
            try {
                FileManager fileManager = (FileManager)AppContext.getBean((String)"fileManager");
                v3XFile = fileManager.save(file, ApplicationCategoryEnum.cap4Form, "formScreenCapture-" + id + "." + renderType, DateUtil.currentDate(), Boolean.valueOf(true));
                file.delete();
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("doScreenCapture4File " + e.getMessage()), (Throwable)e);
            }
        }
        return v3XFile;
    }

    private static String execute(String url, Map<String, Object> screenParams, Map<String, Object> extParams, Map<String, Object> execParams) {
        String resultString;
        if (screenParams == null) {
            screenParams = new HashMap<String, Object>();
        }
        long startTime = System.currentTimeMillis();
        Integer width = CAPParamUtil.getInteger(screenParams, (String)"width");
        Integer height = CAPParamUtil.getInteger(screenParams, (String)"height");
        width = width == null ? 1920 : width;
        height = height == null ? 1080 : height;
        String captureType = CAPParamUtil.getString(screenParams, (String)"captureType");
        captureType = Strings.isBlank((String)captureType) ? "process" : captureType;
        HttpServletRequest request = AppContext.getRawRequest();
        execParams.put("url", url);
        execParams.put("width", String.valueOf(width));
        execParams.put("height", String.valueOf(height));
        execParams.put("extParams", extParams);
        execParams.put("JSESSIONID", PhantomJSUtil.getJSESSIONID());
        execParams.put("domain", request.getServerName());
        execParams.put("contextPath", request.getContextPath());
        String serverHostPort = request.getServerName() + (request.getServerPort() == 80 || request.getServerPort() == 443 ? "" : ":" + request.getServerPort());
        execParams.put("serverLocalPort", request.getLocalPort());
        execParams.put("serverHostPort", serverHostPort);
        execParams.put("requestScheme", request.getScheme());
        execParams.put("replaceHost", "1");
        execParams.put("paperSize", screenParams.get("paperSize") != null ? screenParams.get("paperSize") : "");
        HttpSession session = null;
        if (screenParams.get("token") != null && Strings.isNotBlank((String)screenParams.get("token").toString())) {
            session = request.getSession(true);
            session.setAttribute("com.seeyon.current_user", (Object)AppContext.getCurrentUser());
            execParams.put("JSESSIONID", session.getId());
        }
        String string = resultString = "process".equalsIgnoreCase(captureType) ? PhantomJSUtil.doScreenCaptureByProcess(execParams) : PhantomJSUtil.doScreenCaptureByWeb(execParams);
        if (resultString != null && resultString.startsWith(CAP4_PHANTOMRESOURCE_ERROR)) {
            LOGGER.error((Object)("error,\u91cd\u65b0\u6267\u884c\u539furl,\u9519\u8bef\u4fe1\u606f:" + resultString));
            execParams.put("replaceHost", "0");
            String string2 = resultString = "process".equalsIgnoreCase(captureType) ? PhantomJSUtil.doScreenCaptureByProcess(execParams) : PhantomJSUtil.doScreenCaptureByWeb(execParams);
        }
        if (resultString == null || resultString.startsWith(CAP4_PHANTOMJS_ERROR) || resultString.startsWith(CAP4_PHANTOMRESOURCE_ERROR) || Strings.isBlank((String)resultString)) {
            LOGGER.error((Object)("doScreenCapture result error : " + resultString));
            resultString = null;
        }
        if (session != null) {
            session.invalidate();
        }
        LOGGER.info((Object)("doScreenCapture use time " + (System.currentTimeMillis() - startTime) + " MS , url " + url));
        return resultString;
    }

    private static String doScreenCaptureByWeb(Map<String, Object> execParams) {
        boolean isStart = HttpClientUtil.isHostConnectable(WEB_SERVER_IP, 9920);
        if (!isStart && !PhantomJSUtil.startPhantomWebServer()) {
            return PhantomJSUtil.doScreenCaptureByProcess(execParams);
        }
        return HttpClientUtil.doPostReturnHtml("http://127.0.0.1:9920", execParams);
    }

    private static boolean startPhantomWebServer() {
        StringBuilder exec = new StringBuilder();
        exec.append(PhantomJSUtil.getScreenCaptureServiceBySystemOs());
        exec.append(BLANK);
        exec.append(PhantomJSUtil.getScreenCapturePath() + "screenCaptureWebServer.js");
        try {
            Runtime.getRuntime().exec(exec.toString());
        }
        catch (IOException e) {
            LOGGER.error((Object)"startPhantomWebServer exception", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String doScreenCaptureByProcess(Map<String, Object> execParams) {
        String resultString;
        block10: {
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            InputStreamReader inputStreamReader = null;
            Process process = null;
            resultString = null;
            try {
                StringBuilder exec = new StringBuilder();
                exec.append(PhantomJSUtil.getScreenCaptureServiceBySystemOs());
                exec.append(BLANK);
                exec.append(PhantomJSUtil.getScreenCapturePath() + "screenCapture.js");
                exec.append(BLANK);
                String execParamsStr = URLEncoder.encode(JSONUtil.toJSONString(execParams), "UTF-8");
                execParamsStr = execParamsStr.replaceAll("\\+", "%20");
                exec.append(execParamsStr);
                LOGGER.info((Object)("doScreenCapture exec cmd " + exec.toString()));
                process = Runtime.getRuntime().exec(exec.toString());
                inputStream = process.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder buffer = new StringBuilder();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    buffer.append(line);
                }
                resultString = buffer.toString();
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)"doScreenCapture is UnsupportedEncodingException ", (Throwable)e);
                break block10;
            }
            catch (IOException e2) {
                LOGGER.error((Object)"doScreenCapture is exception ", (Throwable)e2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(bufferedReader);
                IOUtils.closeQuietly(inputStream);
                if (process != null) {
                    process.destroy();
                }
            }
            IOUtils.closeQuietly((Reader)inputStreamReader);
            IOUtils.closeQuietly((Reader)bufferedReader);
            IOUtils.closeQuietly((InputStream)inputStream);
            if (process != null) {
                process.destroy();
            }
        }
        return resultString;
    }

    private static String getScreenCaptureServiceBySystemOs() {
        String seeyonHome = SystemEnvironment.getApplicationFolder();
        StringBuilder path = new StringBuilder(seeyonHome);
        path.append(File.separator);
        path.append("common");
        path.append(File.separator);
        path.append("phantomjs");
        path.append(File.separator);
        path.append("bin");
        path.append(File.separator);
        if (PhantomJSUtil.is64Linux()) {
            path.append("phantomjs_linux64");
        } else if (PhantomJSUtil.is32Linux()) {
            path.append("phantomjs_linux32");
        } else if (PhantomJSUtil.isWindows()) {
            path.append("phantomjs_windows.exe");
        } else {
            path.append("phantomjs");
        }
        File binFile = new File(path.toString());
        if (!binFile.canExecute()) {
            binFile.setExecutable(true);
        }
        return path.toString();
    }

    private static String getScreenCapturePath() {
        String seeyonHome = SystemEnvironment.getApplicationFolder();
        StringBuilder path = new StringBuilder(seeyonHome);
        path.append(File.separator);
        path.append("common");
        path.append(File.separator);
        path.append("cap4");
        path.append(File.separator);
        path.append("template");
        path.append(File.separator);
        path.append("screencapture");
        path.append(File.separator);
        return path.toString();
    }

    private static boolean is64Linux() {
        return OS.contains(LINUX) && ARCH.contains(BIT_64);
    }

    private static boolean is32Linux() {
        return OS.contains(LINUX) && ARCH.contains(BIT_32);
    }

    private static boolean isWindows() {
        return OS.contains(WINDOWS);
    }

    private static String getJSESSIONID() {
        return HttpSessionUtil.getSessionId((HttpServletRequest)AppContext.getRawRequest());
    }
}

