/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;

public class RandomVerifyImgCodeUtil {
    private static final Log logger = CtpLogFactory.getLog(RandomVerifyImgCodeUtil.class);
    private static Random random = new Random();
    public static final String RANDOMCODEKEY = "RANDOM_VALIDATE_CODE_KEY";
    public static final String VERIFY_CODES = "23456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz";
    public static final String VERIFY_CODES_NUMBER = "0123456789";
    private static String[] fontName = new String[]{"Algerian", "Arial", "Arial Black", "Agency FB", "Calibri", "Cambria", "Gadugi", "Georgia", "Consolas", "Comic Sans MS", "Courier New", "Gill sans", "Time News Roman", "Tahoma", "Quantzite", "Verdana"};
    private static int[] fontStyle = new int[]{1, 2, 0, 0, 3};
    private static Color[] colorRange = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW, Color.GREEN, Color.BLUE, Color.DARK_GRAY, Color.BLACK, Color.RED};

    public static String generateVerifyCode(int verifySize) {
        return RandomVerifyImgCodeUtil.generateVerifyCode(verifySize, VERIFY_CODES);
    }

    public static String generateVerifyCode(int verifySize, String sources) {
        if (sources == null || sources.length() == 0) {
            sources = VERIFY_CODES;
        }
        int codesLen = sources.length();
        Random rand = new Random(System.currentTimeMillis());
        StringBuilder verifyCode = new StringBuilder(verifySize);
        for (int i = 0; i < verifySize; ++i) {
            verifyCode.append(sources.charAt(rand.nextInt(codesLen - 1)));
        }
        return verifyCode.toString();
    }

    public static BufferedImage getRandomBufferedImage(int w, int h, String code, String type) {
        int verifySize = code.length();
        BufferedImage image = new BufferedImage(w, h, 1);
        Random rand = new Random();
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[5];
        Color[] colorSpaces = colorRange;
        float[] fractions = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorSpaces[rand.nextInt(colorSpaces.length)];
            fractions[i] = rand.nextFloat();
        }
        Arrays.sort(fractions);
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, w, h);
        Color c = RandomVerifyImgCodeUtil.getRandColor(250, 255);
        g2.setColor(c);
        g2.fillRect(0, 2, w, h - 4);
        char[] charts = code.toCharArray();
        for (int i = 0; i < charts.length; ++i) {
            g2.setColor(c);
            g2.setFont(RandomVerifyImgCodeUtil.getRandomFont(h, type));
            g2.fillRect(0, 2, w, h - 4);
        }
        Random random = new Random();
        g2.setColor(RandomVerifyImgCodeUtil.getRandColor(160, 200));
        int lineNumbers = 20;
        lineNumbers = "login".equals(type) || type.contains("mix") || type.contains("3D") ? 20 : ("coupons".equals(type) ? RandomVerifyImgCodeUtil.getRandomDrawLine() : RandomVerifyImgCodeUtil.getRandomDrawLine());
        for (int i = 0; i < lineNumbers; ++i) {
            int x = random.nextInt(w - 1);
            int y = random.nextInt(h - 1);
            int xl = random.nextInt(6) + 1;
            int yl = random.nextInt(12) + 1;
            g2.drawLine(x, y, x + xl + 40, y + yl + 20);
        }
        float yawpRate = 0.05f;
        yawpRate = "login".equals(type) || type.contains("mix") || type.contains("3D") ? 0.05f : ("coupons".equals(type) ? RandomVerifyImgCodeUtil.getRandomDrawPoint() : RandomVerifyImgCodeUtil.getRandomDrawPoint());
        int area = (int)(yawpRate * (float)w * (float)h);
        for (int i = 0; i < area; ++i) {
            int x = random.nextInt(w);
            int y = random.nextInt(h);
            int rgb = RandomVerifyImgCodeUtil.getRandomIntColor();
            image.setRGB(x, y, rgb);
        }
        RandomVerifyImgCodeUtil.shear(g2, w, h, c);
        double height = h;
        double width = w;
        char[] chars = code.toCharArray();
        Double rd = rand.nextDouble();
        Boolean rb = rand.nextBoolean();
        for (int i = 0; i < verifySize; ++i) {
            g2.setColor(RandomVerifyImgCodeUtil.getRandColor(100, 160));
            g2.setFont(RandomVerifyImgCodeUtil.getRandomFont(h, type));
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(0.7853981633974483 * rd * (double)(rb != false ? 1 : -1), width / (double)verifySize * (double)i + (height - 4.0) / 2.0, height / 2.0);
            g2.setTransform(affine);
            g2.drawOval(random.nextInt(w), random.nextInt(h), 5 + random.nextInt(10), 5 + random.nextInt(10));
            g2.drawChars(chars, i, 1, (w - 10) / verifySize * i + 5, h / 2 + (h - 4) / 2 - 10);
        }
        g2.dispose();
        return image;
    }

    private static Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static int getRandomIntColor() {
        int[] rgb = RandomVerifyImgCodeUtil.getRandomRgb();
        int color = 0;
        for (int c : rgb) {
            color <<= 8;
            color |= c;
        }
        return color;
    }

    private static int[] getRandomRgb() {
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = random.nextInt(255);
        }
        return rgb;
    }

    private static Font getRandomFont(int h, String type) {
        String name = fontName[random.nextInt(fontName.length)];
        int style = fontStyle[random.nextInt(fontStyle.length)];
        int size = RandomVerifyImgCodeUtil.getRandomFontSize(h);
        if ("login".equals(type)) {
            return new Font(name, style, size);
        }
        if ("coupons".equals(type)) {
            return new Font(name, style, size);
        }
        if (type.contains("mix")) {
            int flag = random.nextInt(10);
            return new Font(name, style, size);
        }
        return new Font(name, style, size);
    }

    private static int getRandomDrawLine() {
        int min = 20;
        int max = 155;
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    private static float getRandomDrawPoint() {
        float min = 0.05f;
        float max = 0.1f;
        return min + (max - min) * new Random().nextFloat();
    }

    private static int getRandomFontSize(int h) {
        int min = h - 8;
        Random random = new Random();
        return random.nextInt(11) + min;
    }

    private static void shear(Graphics g, int w1, int h1, Color color) {
        RandomVerifyImgCodeUtil.shearX(g, w1, h1, color);
        RandomVerifyImgCodeUtil.shearY(g, w1, h1, color);
    }

    private static void shearX(Graphics g, int w1, int h1, Color color) {
        int period = random.nextInt(2);
        boolean frames = true;
        int phase = random.nextInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private static void shearY(Graphics g, int w1, int h1, Color color) {
        int period = random.nextInt(40) + 10;
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }

    private static float getAlpha(int i, int j, int verifySize) {
        int num = i + j;
        float r = 1.0f / (float)verifySize;
        float s = (float)(verifySize + 1) * r;
        return num > verifySize ? (float)num * r - s : (float)num * r;
    }

    public static BufferedImage getRandomBufferedImage(int w, int h, String code) throws IOException {
        BufferedImage image = RandomVerifyImgCodeUtil.getRandomBufferedImage(w, h, code, "mix2");
        return image;
    }

    public static String getRandomBase64Image(String code, int w, int h) {
        String imageStr = "";
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BufferedImage image = RandomVerifyImgCodeUtil.getRandomBufferedImage(w, h, code, "login");
            ImageIO.write((RenderedImage)image, "jpg", outputStream);
            byte[] bytes = outputStream.toByteArray();
            String jpgBase64 = Base64.encodeBase64String((byte[])bytes).trim();
            jpgBase64 = jpgBase64.replaceAll("\n", "").replaceAll("\r", "");
            imageStr = "data:image/jpg;base64," + jpgBase64;
            outputStream.close();
        }
        catch (IOException e) {
            logger.error((Object)("method getBase64Image is error " + e.getMessage()));
        }
        return imageStr;
    }
}

