/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class SQLWildcardEscaper {
    private JDBCProvider provider = new GenericJDBCProvider();
    private static final Map<ProviderType, SQLWildcardEscaper> InstanceHolder = new HashMap<ProviderType, SQLWildcardEscaper>();

    private SQLWildcardEscaper(ProviderType providerType) {
        if (ProviderType.SqlServer == providerType) {
            this.provider = new MsSqlJDBCProvider();
        } else if (ProviderType.PostgreSQL == providerType) {
            this.provider = new PostgreSQLJDBCProvider();
        } else if (ProviderType.Oracle == providerType) {
            this.provider = new OracleSQLJDBCProvider();
        } else if (ProviderType.MySQL == providerType) {
            this.provider = new MySQLJDBCProvider();
        } else if (ProviderType.SQLite == providerType) {
            this.provider = new SQLiteJDBCProvider();
        }
    }

    public static final SQLWildcardEscaper getInstance() {
        return SQLWildcardEscaper.getInstance(ProviderType.MySQL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SQLWildcardEscaper getInstance(ProviderType providerType) {
        if (!InstanceHolder.containsKey((Object)providerType)) {
            Map<ProviderType, SQLWildcardEscaper> map = InstanceHolder;
            synchronized (map) {
                InstanceHolder.put(providerType, new SQLWildcardEscaper(providerType));
            }
        }
        return InstanceHolder.get((Object)providerType);
    }

    public String escape(String s) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            if (!this.provider.requireEscape(ch)) continue;
            sb.insert(i, this.provider.getSearchStringEscapePrefix());
            String suffix = this.provider.getSearchStringEscapeSuffix();
            sb.insert(++i + 1, suffix);
            if (suffix.length() <= 0) continue;
            ++i;
        }
        return sb.toString();
    }

    public String setEscapeCharacter() {
        return this.provider.appendEscape();
    }

    public String likeLowerCase(String s) {
        return this.provider.likeLowerCase(s);
    }

    public String chineseOrderBy(String field) {
        return this.provider.chineseOrderByConvert(field);
    }

    private static class SQLiteJDBCProvider
    implements JDBCProvider {
        private static Set<String> set = new HashSet<String>();

        private SQLiteJDBCProvider() {
        }

        @Override
        public String getSearchStringEscapePrefix() {
            return "/";
        }

        @Override
        public String getSearchStringEscapeSuffix() {
            return "";
        }

        @Override
        public boolean requireEscape(char ch) {
            return this.getEscapeCharacters().contains(ch + "");
        }

        protected Set<String> getEscapeCharacters() {
            return set;
        }

        @Override
        public String appendEscape() {
            return " ";
        }

        @Override
        public String chineseOrderByConvert(String field) {
            return " convert_gbk(" + field + ") ";
        }

        @Override
        public String likeLowerCase(String s) {
            return s;
        }

        static {
            set.add("/");
            set.add("'");
            set.add("[");
            set.add("]");
            set.add("%");
            set.add("&");
            set.add("_");
            set.add("(");
            set.add(")");
            set.add("\\");
        }
    }

    private static class MySQLJDBCProvider
    implements JDBCProvider {
        private static Set<String> set = new HashSet<String>();

        private MySQLJDBCProvider() {
        }

        @Override
        public String getSearchStringEscapePrefix() {
            return "\\";
        }

        @Override
        public String getSearchStringEscapeSuffix() {
            return "";
        }

        @Override
        public boolean requireEscape(char ch) {
            return this.getEscapeCharacters().contains(ch + "");
        }

        protected Set<String> getEscapeCharacters() {
            return set;
        }

        @Override
        public String appendEscape() {
            return " ";
        }

        @Override
        public String chineseOrderByConvert(String field) {
            return " convert_gbk(" + field + ") ";
        }

        @Override
        public String likeLowerCase(String s) {
            return s;
        }

        static {
            set.add("%");
            set.add("_");
            set.add("\\");
        }
    }

    private static class MsSqlJDBCProvider
    extends GenericJDBCProvider
    implements JDBCProvider {
        private static Set<String> set = new HashSet<String>();

        private MsSqlJDBCProvider() {
        }

        @Override
        protected Set<String> getEscapeCharacters() {
            return set;
        }

        @Override
        public String getSearchStringEscapePrefix() {
            return "[";
        }

        @Override
        public String getSearchStringEscapeSuffix() {
            return "]";
        }

        static {
            set.add("%");
            set.add("_");
            set.add("[");
        }
    }

    private static class PostgreSQLJDBCProvider
    implements JDBCProvider {
        private static Set<String> set = new HashSet<String>();

        private PostgreSQLJDBCProvider() {
        }

        @Override
        public String getSearchStringEscapePrefix() {
            return "\\";
        }

        @Override
        public String getSearchStringEscapeSuffix() {
            return "";
        }

        @Override
        public boolean requireEscape(char ch) {
            return this.getEscapeCharacters().contains(ch + "");
        }

        protected Set<String> getEscapeCharacters() {
            return set;
        }

        @Override
        public String appendEscape() {
            return " ";
        }

        @Override
        public String chineseOrderByConvert(String field) {
            return " convert_to(" + field + ", 'GBK') ";
        }

        @Override
        public String likeLowerCase(String s) {
            return s;
        }

        static {
            set.add("%");
            set.add("_");
            set.add("\\");
            set.add("?");
        }
    }

    private static class OracleSQLJDBCProvider
    implements JDBCProvider {
        private static Set<String> set = new HashSet<String>();

        private OracleSQLJDBCProvider() {
        }

        @Override
        public String getSearchStringEscapePrefix() {
            return "\\";
        }

        @Override
        public String getSearchStringEscapeSuffix() {
            return "";
        }

        @Override
        public boolean requireEscape(char ch) {
            return this.getEscapeCharacters().contains(ch + "");
        }

        protected Set<String> getEscapeCharacters() {
            return set;
        }

        @Override
        public String appendEscape() {
            return " escape '\\' ";
        }

        @Override
        public String chineseOrderByConvert(String field) {
            return " nlssort(" + field + ",'NLS_SORT=SCHINESE_PINYIN_M') ";
        }

        @Override
        public String likeLowerCase(String s) {
            return " lower(" + s + ")  ";
        }

        static {
            set.add("%");
            set.add("\\");
            set.add("_");
        }
    }

    private static class GenericJDBCProvider
    implements JDBCProvider {
        private static Set<String> set = new HashSet<String>();

        private GenericJDBCProvider() {
        }

        @Override
        public String getSearchStringEscapePrefix() {
            return "\\";
        }

        @Override
        public String getSearchStringEscapeSuffix() {
            return "";
        }

        @Override
        public boolean requireEscape(char ch) {
            return this.getEscapeCharacters().contains(ch + "");
        }

        protected Set<String> getEscapeCharacters() {
            return set;
        }

        @Override
        public String appendEscape() {
            return " ";
        }

        @Override
        public String chineseOrderByConvert(String field) {
            return " " + field + " ";
        }

        @Override
        public String likeLowerCase(String s) {
            return s;
        }

        static {
            set.add("%");
            set.add("_");
            set.add("\\");
        }
    }

    static interface JDBCProvider {
        public String getSearchStringEscapePrefix();

        public String getSearchStringEscapeSuffix();

        public boolean requireEscape(char var1);

        public String appendEscape();

        public String chineseOrderByConvert(String var1);

        public String likeLowerCase(String var1);
    }

    public static enum ProviderType {
        MySQL,
        SqlServer,
        Oracle,
        PostgreSQL,
        SQLite;

    }
}

