/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.util.mall;

import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.util.mall.Authcode;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;

@Deprecated
public class MallUtil {
    private static final Log logger = CtpLogFactory.getLog(MallUtil.class);
    public static final String CLOUD_APP_URL = Strings.isBlank((String)AppContext.getSystemProperty((String)"cloudapp.userCenter")) ? "https://chome.seeyon.com" : AppContext.getSystemProperty((String)"cloudapp.userCenter");
    public static final String CLOUD_MALL_URL = Strings.isBlank((String)AppContext.getSystemProperty((String)"cloudapp.newMallCloudUrl")) ? "http://cloud.seeyon.com" : AppContext.getSystemProperty((String)"cloudapp.newMallCloudUrl");
    public static final String TOKEN_LOCATION = CLOUD_APP_URL + "/OAuth/token.php";
    public static final String CLIENT_ID = AppContext.getSystemProperty((String)"cloudapp.clientId");
    public static final String CLIENT_SECRET = AppContext.getSystemProperty((String)"cloudapp.clientSecret");
    public static final String CODE_LOCATION = CLOUD_APP_URL + "/OAuth/authorize.php";
    public static final String RESPONSE_TYPE = "code";
    public static final String STORE_API_URL = CLOUD_APP_URL + "/apiPortal.php";
    public static final String STORE_REST_URL = CLOUD_APP_URL + "/rest/";
    public static final int APP_ID = 9;
    public static final String SUCCESS_CODE = "1";
    public static final String MALL_RESULT = "result";
    public static final String NEED_BUY_CODE = "-5";
    private static final int timeOutMillSeconds = 2000;

    public static boolean isNewMall() {
        return CLOUD_MALL_URL.indexOf("cloud") > 0;
    }

    public static String getRestApiUrl(MallEnum.RestApi restApi) {
        return STORE_REST_URL + restApi.getApiUrl();
    }

    @Deprecated
    public static String getRestApiUrl(RestApi restApi) {
        return STORE_REST_URL + restApi.getApiUrl();
    }

    public static String getRequestMallResult(Map<String, Object> requestResult) {
        if (requestResult == null) {
            return null;
        }
        return requestResult.get(MALL_RESULT) != null ? requestResult.get(MALL_RESULT).toString() : null;
    }

    @Deprecated
    public static Map<String, Object> getMallCommonParams(MallAction mallAction, Map<String, Object> params) {
        String action = null;
        String actionDefine = null;
        if (mallAction != null) {
            action = mallAction.getAction();
            actionDefine = mallAction.name().toLowerCase();
        }
        return MallUtil.getMallCommonParams(params, action, actionDefine);
    }

    private static Map<String, Object> getMallCommonParams(Map<String, Object> params, String action, String actionDefine) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (action != null) {
            obj.put("action", action);
        }
        if (actionDefine != null) {
            obj.put("actionDefine", actionDefine);
        }
        obj.put("time", DateUtil.currentDate().getTime() / 1000L);
        if (params.get("app_uid") != null) {
            obj.put("app_uid", params.get("app_uid"));
        }
        if (params.get("mall_uid") != null) {
            obj.put("mall_uid", params.get("mall_uid"));
        }
        if (params.get("access_token") != null) {
            obj.put("access_token", params.get("access_token"));
        }
        String encodeString = URLEncoder.encode(Authcode.encode(JSONUtil.toJSONString(obj)));
        obj.put("appID", 9);
        obj.put("params", params);
        logger.info((Object)("request mall . params is " + obj));
        obj.put(RESPONSE_TYPE, encodeString);
        return obj;
    }

    public static Map<String, Object> getMallCommonParams(MallEnum.MallAction mallAction, Map<String, Object> params) {
        String action = null;
        String actionDefine = null;
        if (mallAction != null) {
            action = mallAction.getAction();
            actionDefine = mallAction.name().toLowerCase();
        }
        return MallUtil.getMallCommonParams(params, action, actionDefine);
    }

    public static String getMallErrorMessage(Map<String, Object> httpResult) {
        String message;
        if (httpResult == null) {
            return "mall request return null";
        }
        String string = message = httpResult.get("message") != null ? String.valueOf(httpResult.get("message")) : null;
        if (Strings.isBlank((String)message)) {
            logger.error((Object)("mall request error ,no message " + httpResult.toString()));
            message = "mall service exception";
        }
        if (httpResult.get("accessTokenCheck") != null && "0".equals(String.valueOf(httpResult.get("accessTokenCheck")))) {
            MallApi mallApi = (MallApi)AppContext.getBean((String)"mallApi");
            mallApi.unbindMall(null);
        }
        return message;
    }

    public static boolean isRequestSuccess(Map<String, Object> map) {
        return map != null && SUCCESS_CODE.equals(MallUtil.getRequestMallResult(map));
    }

    public static Map<String, Object> getOrgInfoByDogNo(String dogNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dogNo", dogNo);
        Map<String, Object> parameterJson = MallUtil.getMallCommonParams(map, null, null);
        CAPHttpRequestManager capHttpRequestManager = (CAPHttpRequestManager)AppContext.getBean((String)"capHttpRequestManager");
        Map httpResult = capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.UC_GET_ORG_BY_DOG_NO), parameterJson, Map.class);
        if (MallUtil.isRequestSuccess(httpResult)) {
            return (Map)httpResult.get("data");
        }
        return null;
    }

    public static boolean isCloudConnect(String ... urls) {
        if (urls != null && urls.length > 0) {
            for (int i = 0; i < urls.length; ++i) {
                try {
                    HttpURLConnection conn;
                    URL url = new URL(urls[i]);
                    URLConnection co = url.openConnection();
                    co.setConnectTimeout(2000);
                    if (co instanceof HttpURLConnection) {
                        conn = (HttpURLConnection)co;
                        conn.setRequestMethod("GET");
                        conn.setInstanceFollowRedirects(false);
                    }
                    if (co instanceof HttpsURLConnection) {
                        conn = (HttpsURLConnection)co;
                        SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
                        sslcontext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
                        ((HttpsURLConnection)conn).setSSLSocketFactory(sslcontext.getSocketFactory());
                    }
                    co.connect();
                    logger.info((Object)(urls[i] + "\u8fde\u63a5\u53ef\u7528"));
                    continue;
                }
                catch (Exception e1) {
                    logger.error((Object)(urls[i] + "\u8fde\u63a5\u5931\u8d25\uff01"), (Throwable)e1);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isCloudConnect() {
        String newMallCloudUrl = AppContext.getSystemProperty((String)"cloudapp.newMallCloudUrl");
        return MallUtil.isCloudConnect(newMallCloudUrl);
    }

    public static class MyX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    @Deprecated
    public static enum MallAction {
        MAVERICK_BUYING_BY_ORG("Api/Cap4/getMaverickBuyingByOrg"),
        IDENTIFY_UNIT_PWD("identifyUnitAndGetPw");

        public String action;

        private MallAction(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }

    @Deprecated
    public static enum RestApi {
        MALL_INDEX("mall/index"),
        HOME_INDEX("index/index");

        public String apiUrl;

        private RestApi(String apiUrl) {
            this.apiUrl = apiUrl;
        }

        public String getApiUrl() {
            return this.apiUrl;
        }
    }
}

