/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.validity.service;

import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.cap4.validity.po.CAPCloudResource;
import com.seeyon.cap4.validity.service.CloudResourceManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CloudResourceManagerImpl
implements CloudResourceManager {
    private static final Log logger = CtpLogFactory.getLog(CloudResourceManagerImpl.class);
    private static final String getCloudAppPath = "/svr/package";
    private static final String getCloudAppServiceCode = "m20000000000006666";
    private static final String resultCodeValueSuccess = "1000";
    private static final String resultCodeKey = "code";
    private static final String resultMsgKey = "msg";
    private static final String resultDataKey = "data";
    private static final String ticketKey = "ticket";
    private static final String corpIdKey = "corpId";
    private static final String parameterTypeKey = "parameterType";
    private static final String sizeKey = "size";
    private static final String appVersionKey = "app_version";
    private static final String mallUrlKey = "mall_url";
    private static final String serviceNameKey = "service_name";
    private static final String logoKey = "logo";
    private static final String downloadUrlKey = "download_url";
    private static final String isSuccessKey = "isSuccess";
    private static final String typeKey = "type";
    private static final String typeValueKind = "kind";
    private static final String typeValueSingle = "single";
    private static final String valueKey = "value";
    private static final String typeCodeApp = "biz_service";
    private MplusApi mplusApi;

    public void setMplusApi(MplusApi mplusApi) {
        this.mplusApi = mplusApi;
    }

    @Override
    public List<BizConfigBean> getCloudApp() throws BusinessException {
        ArrayList<BizConfigBean> bizConfigBeans = new ArrayList<BizConfigBean>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(typeKey, typeValueKind);
        params.put(valueKey, typeCodeApp);
        List mplusResults = this.callMplus(params);
        for (int index = 0; index < mplusResults.size(); ++index) {
            Map mplusResult = (Map)mplusResults.get(index);
            BizConfigBean bizConfigBean = new BizConfigBean();
            bizConfigBean.setName(ParamUtil.getString((Map)mplusResult, (String)serviceNameKey));
            bizConfigBean.setSize(ParamUtil.getString((Map)mplusResult, (String)sizeKey));
            bizConfigBean.setVersion(ParamUtil.getString((Map)mplusResult, (String)appVersionKey));
            bizConfigBean.setDetailUrl(ParamUtil.getString((Map)mplusResult, (String)mallUrlKey));
            bizConfigBean.setBizIcon(ParamUtil.getString((Map)mplusResult, (String)logoKey));
            bizConfigBean.setDownloadUrl(ParamUtil.getString((Map)mplusResult, (String)downloadUrlKey));
            bizConfigBeans.add(bizConfigBean);
        }
        return bizConfigBeans;
    }

    @Override
    public CAPCloudResource getCloudResourceByGoodsId(String goodsId) throws BusinessException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(typeKey, typeValueSingle);
        params.put(valueKey, goodsId);
        List mplusResults = this.callMplus(params);
        if (mplusResults.size() == 0) {
            return null;
        }
        Map mplusResult = (Map)mplusResults.get(0);
        CAPCloudResource capCloudResource = new CAPCloudResource();
        capCloudResource.setServiceName(ParamUtil.getString((Map)mplusResult, (String)serviceNameKey));
        capCloudResource.setGoodsName(ParamUtil.getString((Map)mplusResult, (String)serviceNameKey));
        capCloudResource.setSize(ParamUtil.getString((Map)mplusResult, (String)sizeKey));
        capCloudResource.setAppVersion(ParamUtil.getString((Map)mplusResult, (String)appVersionKey));
        capCloudResource.setMallUrl(ParamUtil.getString((Map)mplusResult, (String)mallUrlKey));
        capCloudResource.setDownloadUrl(ParamUtil.getString((Map)mplusResult, (String)downloadUrlKey));
        return capCloudResource;
    }

    private List callMplus(Map<String, Object> params) throws BusinessException {
        logger.info((Object)("mplusApi.getDomain():" + this.mplusApi.getDomain()));
        String ticket = this.mplusApi.getTicket(getCloudAppServiceCode);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(ticketKey, ticket);
        param.put(typeKey, ParamUtil.getString(params, (String)typeKey));
        param.put(valueKey, ParamUtil.getString(params, (String)valueKey));
        param.put(parameterTypeKey, HttpClientUtil.ParameterType.SERVLET_TYPE.getValue());
        Map<String, Object> resultMap = HttpClientUtil.doPost(this.mplusApi.getDomain() + getCloudAppPath, param);
        logger.info((Object)("call " + this.mplusApi.getDomain() + getCloudAppPath + ":" + param));
        if (!Boolean.valueOf(resultMap.get(isSuccessKey).toString()).booleanValue()) {
            logger.error((Object)("call " + this.mplusApi.getDomain() + getCloudAppPath + ":" + resultMap.get(resultCodeKey).toString()));
            BusinessException exception = new BusinessException("\u7f51\u7edc\u5f02\u5e38");
            exception.setCode("1001");
            throw exception;
        }
        if (!resultCodeValueSuccess.equals(resultMap.get(resultCodeKey).toString())) {
            logger.error((Object)("call " + this.mplusApi.getDomain() + getCloudAppPath + ":" + resultMap.get(resultMsgKey).toString()));
            BusinessException exception = new BusinessException("\u4e91\u8054\u5f02\u5e38");
            exception.setCode("1002");
            throw exception;
        }
        return (List)resultMap.get(resultDataKey);
    }

    public static void main(String[] args) {
        Map jsonObject = (Map)JSONUtil.parseJSONString((String)"123vv");
        jsonObject.get(ticketKey);
    }
}

