/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.validity.service;

import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.apps.cloudapp.po.CloudAppDatas;
import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.cap4.desensitization.utils.FuzzyPkgUtils;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.biz.vo.BizValidateResultVO;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessDAO;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.cap4.form.util.FormConstant;
import com.seeyon.cap4.form.vo.AppInfo;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.cap4.validity.EncryptUtil;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.cap4.validity.constant.ValidityEnum;
import com.seeyon.cap4.validity.po.CAPCloudResource;
import com.seeyon.cap4.validity.service.ValidateManager;
import com.seeyon.cap4.validity.util.CertificateUtils;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Base64;
import com.seeyon.ctp.util.BeanUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.PropertiesUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import www.seeyon.com.biz.BizChicken4;
import www.seeyon.com.biz.BizEgg;
import www.seeyon.com.biz.enums.BizOperationEnum4;
import www.seeyon.com.utils.DesUtil;
import www.seeyon.com.utils.StringUtil;

public class ValidateManagerImpl
implements ValidateManager {
    private static final Log logger = CtpLogFactory.getLog(ValidateManagerImpl.class);
    private MplusApi mplusApi;
    private BusinessDAO businessDAO4;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FileManager fileManager;
    private OrgManager orgManager;
    private BusinessManager businessManager4;
    private MallApi mallApi;

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setBusinessDAO4(BusinessDAO businessDAO4) {
        this.businessDAO4 = businessDAO4;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setMplusApi(MplusApi mplusApi) {
        this.mplusApi = mplusApi;
    }

    public void setMallApi(MallApi mallApi) {
        this.mallApi = mallApi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public Map<String, Object> packageLicUpdate(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (params.containsKey("fileId") && params.containsKey("bizConfigId")) {
            block11: {
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L));
                Long fileId = ParamUtil.getLong(params, (String)"fileId", (Long)0L);
                FileManager fileManager = (FileManager)AppContext.getBean((String)"fileManager");
                try {
                    File packageFile = fileManager.getFile(fileId, DateUtil.currentDate());
                    if (packageFile == null || !packageFile.exists()) break block11;
                    Map<String, Object> validateResult = this.validatePackage(packageFile, false, "updateLic", new HashMap<String, Object>());
                    if (validateResult.get("code").equals(ValidityEnum.ValidityResult.AppSuccess.getKey())) {
                        BizConfigBean bizConfigBean1 = this.businessManager4.findBizConfigById(Long.valueOf(validateResult.get("resultAppId").toString()));
                        if (bizConfigBean1 == null) {
                            result.put("code", "1001");
                            result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.localInstall.label"));
                            return result;
                        }
                        if (this.checkAppFormNumber(Long.valueOf(validateResult.get("resultAppId").toString()), validateResult)) {
                            String maxFormNum = MapUtils.getString(validateResult, (Object)"maxFormNumber");
                            result.put("code", "1001");
                            result.put("message", ValidityEnum.ValidityResult.MAX_FROM_NUMBER_UPDATE.getName(maxFormNum));
                            return result;
                        }
                        if (!bizConfigBean1.getId().equals(bizConfigBean.getId())) {
                            result.put("code", "1001");
                            result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.updatePakError.label"));
                            return result;
                        }
                        if (validateResult.get("trial") != null && Boolean.valueOf(validateResult.get("trial").toString()).booleanValue()) {
                            result.put("code", "1001");
                            result.put("message", "\u66f4\u65b0\u5305\u662f\u8bd5\u7528\u5305\uff0c\u4e0d\u80fd\u66f4\u65b0\uff01");
                            return result;
                        }
                        try {
                            String endDateStr = validateResult.get("realendtime").toString();
                            Date endDate = DateUtil.parse((String)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
                            this.licUpdate(bizConfigBean, endDate, result);
                            break block11;
                        }
                        catch (Exception e) {
                            result.put("code", "1001");
                            result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.noUpdate.label"));
                            return result;
                        }
                    }
                    if (validateResult.get("code").equals(ValidityEnum.ValidityResult.MAX_FROM_NUMBER_INSTALL.getKey())) {
                        String maxFormNumber = MapUtils.getString(validateResult, (Object)"maxFormNumber");
                        result.put("message", ValidityEnum.ValidityResult.MAX_FROM_NUMBER_UPDATE.getName(maxFormNumber));
                        result.put("code", "1003");
                        return result;
                    }
                    result.put("code", "1002");
                    return result;
                }
                catch (Exception e) {
                    result.put("code", "1003");
                    result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.backendError.label"));
                }
            }
            return result;
        }
        return null;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public Map<String, Object> packageLicUpdateOnLine(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!ValidityUtil.isValidMplusAccount()) {
            resultMap.put("resultCode", "1003");
            resultMap.put("resultMsg", ResourceUtil.getString((String)"com.cap.export.app.certificate.error.tips"));
            return resultMap;
        }
        List listMplus = null;
        Map mapMplus = null;
        try {
            listMplus = this.callMplus(params);
        }
        catch (Exception e) {
            logger.error((Object)"\u5728\u7ebf\u8c03\u7528\u4e91\u8054\u5f02\u5e38", (Throwable)e);
            resultMap.put("resultCode", "1001");
            return resultMap;
        }
        if (CollectionUtils.isEmpty((Collection)listMplus)) {
            listMplus = this.getExpireTimeFromCloudMall(params);
        } else {
            logger.info((Object)("\u8001\u5546\u57ce\u4e1a\u52a1\u66f4\u65b0, configId : " + params));
            mapMplus = (Map)JSONUtil.parseJSONString((String)listMplus.get(0).toString(), Map.class);
        }
        if (CollectionUtils.isEmpty((Collection)listMplus)) {
            resultMap.put("resultCode", "1002");
            resultMap.put("resultMsg", ResourceUtil.getString((String)"com.cap.application.validate.noUpdate.label"));
            return resultMap;
        }
        if (mapMplus == null) {
            mapMplus = (Map)listMplus.get(0);
        }
        logger.info((Object)("mapMplus----" + mapMplus));
        if (null == mapMplus || !mapMplus.containsKey("expire_time") || null == mapMplus.get("expire_time")) {
            resultMap.put("resultCode", "1002");
            resultMap.put("resultMsg", ResourceUtil.getString((String)"com.cap.application.validate.noUpdate.label"));
            return resultMap;
        }
        long expireTime = Long.parseLong(mapMplus.get("expire_time").toString());
        Date expireDate = null;
        try {
            expireDate = DateUtil.parse((String)DateUtil.getDate((Date)new Date(expireTime), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            logger.error((Object)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01", (Throwable)e);
        }
        String bizConfigId = ParamUtil.getString(params, (String)"bizConfigId");
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(Long.valueOf(bizConfigId));
        if (bizConfigBean == null) {
            resultMap.put("resultCode", "1002");
            resultMap.put("resultMsg", "com.cap.application.validate.mustFirstInstall.label");
            return resultMap;
        }
        if (this.checkAppFormNumber(Long.valueOf(bizConfigId), mapMplus)) {
            String maxFormNum = MapUtils.getString((Map)mapMplus, (Object)"maxFormNumber");
            resultMap.put("resultCode", "1002");
            resultMap.put("resultMsg", ValidityEnum.ValidityResult.MAX_FROM_NUMBER_UPDATE.getName(maxFormNum));
            return resultMap;
        }
        this.licUpdate(bizConfigBean, expireDate, resultMap);
        return resultMap;
    }

    private void licUpdate(BizConfigBean bizConfigBean, Date endDate, Map<String, Object> resultMap) throws BusinessException {
        bizConfigBean.getAppInfo().setExpDate(DateUtil.getDate((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
        bizConfigBean.getAppInfo().setAuthto(ValidityUtil.getMplusCorpName());
        bizConfigBean.setEndDate(endDate);
        bizConfigBean.setLicenseUpdateDate(new Date());
        bizConfigBean.setTrial(Integer.valueOf(BizEnums.BizTrial.noTrial.getKey()));
        bizConfigBean.getAppInfo().setTrial("false");
        if (BizEnums.BizCreateSourceType.ImportFromRequir.getKey() != bizConfigBean.getBizCreateType().intValue()) {
            bizConfigBean.setBizCreateType(Integer.valueOf(BizEnums.BizCreateSourceType.ImportFromMall.getKey()));
        }
        bizConfigBean.getAppInfo().setSource(bizConfigBean.getBizCreateType() + "");
        bizConfigBean.setUseFlag(Integer.valueOf(1));
        bizConfigBean.getAppInfo().setTotal(bizConfigBean.getNewTotal());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizConfigId", bizConfigBean.getId());
        params.put("status", "on");
        BizValidateResultVO bizValidateResultVO = this.preValidateBiz(bizConfigBean, BizOperationEnum4.create_app_save);
        if (!bizValidateResultVO.isSuccess()) {
            throw new BusinessException("\u4e0d\u80fd\u66f4\u65b0\u5e94\u7528\uff0c\u672c\u4f01\u4e1a\u6700\u591a\u80fd\u542f\u7528" + BizChicken4.getTotalNum() + "\u4e2a\u4e1a\u52a1\u5e94\u7528\uff0c\u82e5\u9700\u7ee7\u7eed\u65b0\u5efa\u8bf7\u8d2d\u4e70\uff01");
        }
        this.businessManager4.handleStatus(params);
        try {
            bizConfigBean.setBizSourceInfo(ValidityUtil.generateValidate((AppInfo)bizConfigBean.getAppInfo()));
            this.businessDAO4.saveOrUpdateBizConfig(bizConfigBean.getConfig());
        }
        catch (Exception e) {
            logger.error((Object)("\u5e94\u7528\u66f4\u65b0\u5931\u8d25\uff01" + bizConfigBean.getId() + bizConfigBean.getName()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        resultMap.put("resultCode", "1000");
        resultMap.put("resultMsg", "\u5e94\u7528\u300a" + bizConfigBean.getName() + "\u300b\u5df2\u66f4\u65b0\u7ed3\u675f\u65f6\u95f4\u4e3a\uff1a" + bizConfigBean.getAppInfo().getExpDate() + " \uff01");
    }

    private List callMplus(Map<String, Object> params) throws BusinessException {
        String bizConfigId;
        String getCloudAppServiceCode = "m20000000000006666";
        String getPkgPath = "/open/pkginfo";
        String ticketKey = "ticket";
        String pkgIdKey = "pkgId";
        String parameterTypeKey = "parameterType";
        String isSuccessKey = "isSuccess";
        String resultCodeKey = "code";
        String resultCodeValueSuccess = "1000";
        String resultMsgKey = "msg";
        String resultDataKey = "data";
        logger.info((Object)("mplusApi.getDomain():" + this.mplusApi.getDomain()));
        String ticket = this.mplusApi.getTicket(getCloudAppServiceCode);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(ticketKey, ticket);
        String pkgId = bizConfigId = ParamUtil.getString(params, (String)"bizConfigId");
        param.put(pkgIdKey, pkgId);
        param.put(parameterTypeKey, HttpClientUtil.ParameterType.SERVLET_TYPE.getValue());
        Map<String, Object> resultMap = HttpClientUtil.doPost(this.mplusApi.getDomain() + getPkgPath, param);
        logger.info((Object)("call " + this.mplusApi.getDomain() + getPkgPath + ":" + param));
        if (!Boolean.valueOf(resultMap.get(isSuccessKey).toString()).booleanValue()) {
            logger.error((Object)("call " + this.mplusApi.getDomain() + getPkgPath + ":" + resultMap.get(resultCodeKey).toString()));
            BusinessException exception = new BusinessException("\u7f51\u7edc\u5f02\u5e38");
            exception.setCode("1001");
            throw exception;
        }
        if (!resultCodeValueSuccess.equals(resultMap.get(resultCodeKey).toString())) {
            logger.error((Object)("call " + this.mplusApi.getDomain() + getPkgPath + ":" + resultMap.get(resultMsgKey).toString()));
            BusinessException exception = new BusinessException("\u4e91\u8054\u5f02\u5e38");
            exception.setCode("1002");
            throw exception;
        }
        String resultData = EncryptUtil.decrypt(resultMap.get(resultDataKey).toString());
        return (List)JSONUtil.parseJSONString((String)resultData, List.class);
    }

    private List getExpireTimeFromCloudMall(Map<String, Object> map) {
        ArrayList list = new ArrayList();
        String bizConfigId = ParamUtil.getString(map, (String)"bizConfigId");
        String url = MallUtil.CLOUD_APP_URL + "/rest/index/index?action=appLicenseUpdate";
        HashMap params = new HashMap();
        Map corpInfo = null;
        String accessToken = "";
        String code = "";
        try {
            User user = AppContext.getCurrentUser();
            CloudAppDatas ctpCloudAppData = this.mallApi.getByMemberId(user.getId());
            if (ctpCloudAppData != null) {
                accessToken = ctpCloudAppData.getAccessToken();
            }
            code = (String)MallUtil.getMallCommonParams((MallEnum.MallAction)null, new HashMap<String, Object>()).get("code");
            corpInfo = this.mplusApi.getCorpInfo();
        }
        catch (BusinessException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        if (corpInfo == null) {
            logger.info((Object)"\u672a\u7ed1\u5b9a\u4e91\u8054\u8d26\u53f7\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e91\u7aef\u5df2\u8d2d\u5e94\u7528\u5217\u8868");
            return list;
        }
        params.put("corp_id", corpInfo.get("corpid"));
        params.put("access_token", accessToken);
        params.put("goods_app_id", bizConfigId);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("appID", 9);
        requestMap.put("code", code);
        requestMap.put("params", JSONUtil.toJSONString(params));
        logger.info((Object)("cloud mall license update parameter is \uff1a" + requestMap));
        Map<String, Object> resultMap = HttpClientUtil.doPost(url, requestMap);
        HashMap<String, Object> expireTimeMap = null;
        if (resultMap != null && resultMap.containsKey("code") && "1000".equals(CAPParamUtil.getString(resultMap, (String)"code"))) {
            Date date;
            Long timestamp = null;
            try {
                Map expireMap = CAPParamUtil.getParamsMapByKey(resultMap, (String)"data");
                expireTimeMap = new HashMap<String, Object>();
                expireTimeMap.put("orderType", MapUtils.getString((Map)expireMap, (Object)"order_type"));
                expireTimeMap.put("maxFormNumber", MapUtils.getString((Map)expireMap, (Object)"max_form_number"));
                date = Datetimes.parse((String)CAPParamUtil.getString((Map)expireMap, (String)"goods_expire_date"));
            }
            catch (Exception e) {
                logger.error((Object)("\u8bb8\u53ef\u66f4\u65b0 \u65f6\u95f4\u683c\u5f0f\u9519\u8bef " + resultMap));
                return list;
            }
            if (date != null) {
                timestamp = date.getTime();
            }
            expireTimeMap.put("expire_time", timestamp);
        }
        if (expireTimeMap != null) {
            list.add(expireTimeMap);
        }
        return list;
    }

    @Override
    public void preValidateExport(BizConfigBean bizConfigBean, Map<String, Object> params) throws BusinessException {
        boolean result = true;
        String message = ResourceUtil.getString((String)"com.cap.export.app.certificate.mismatch.tips");
        try {
            if (bizConfigBean.getTrial() != null && BizEnums.BizTrial.trial.getKey() == bizConfigBean.getTrial().intValue() && !Boolean.valueOf(ParamUtil.getString(params, (String)"trial", (String)"false")).booleanValue()) {
                result = false;
                message = ResourceUtil.getString((String)"com.cap.export.app.trial.export.official.tips");
                return;
            }
            String jsonStr = DesUtil.decode((String)bizConfigBean.getBizSourceInfo(), (String)bizConfigBean.getId().toString());
            AppInfo appInfo = (AppInfo)JSONUtil.parseJSONString((String)jsonStr, AppInfo.class);
            if (appInfo.getIcorpId() != null) {
                Map mplusCorp = this.mplusApi.getCorpInfo();
                String icorpId = (String)mplusCorp.get("corpid");
                if (!appInfo.getIcorpId().equals(icorpId)) {
                    result = false;
                }
            }
            if (appInfo.getSource() != null && appInfo.getSource().equals(BizEnums.BizCreateSourceType.ImportFromMall.getKey() + "") && (SystemEnvironment.isDev() || AppContext.isRunningModeDevelop())) {
                message = "\u5f00\u53d1\u73af\u5883\u4e0d\u80fd\u5bfc\u51fa\u4e91\u8054\u5305\uff0c\u8bf7\u7ba1\u7406\u5458\u5207\u6362\u73af\u5883\uff01";
                logger.info((Object)(message + bizConfigBean.getName() + bizConfigBean.getId()));
                result = false;
            }
        }
        catch (Exception e) {
            logger.info((Object)"\u5bfc\u51fa\u65b0\u7248\u9a8c\u8bc1\u5f02\u5e38", (Throwable)e);
            try {
                BizEgg.decodeEggId((String)bizConfigBean.getBizSourceInfo());
            }
            catch (Exception ex) {
                result = false;
                logger.info((Object)"\u5bfc\u51fa\u8001\u7248\u9a8c\u8bc1\u5f02\u5e38", (Throwable)ex);
            }
        }
        if (!result) {
            throw new BusinessException(message);
        }
    }

    @Override
    public void signPrivatePackage(BizConfigBean bizConfigBean, File originZipFile, String password, boolean envSensitive) throws BusinessException {
        String tempDir = this.fileManager.getNowFolder(true);
        if ((SystemEnvironment.isDev() || AppContext.isRunningModeDevelop()) && envSensitive) {
            return;
        }
        File unZipFile = new File(tempDir + File.separator + UUIDLong.absLongUUID());
        File signPackage = null;
        File originZipFile1 = null;
        if (!ValidityUtil.isValidMplusAccount()) {
            throw new BusinessException(ValidityEnum.ValidityResult.MplusAccountInvalid.getName());
        }
        try {
            Map mplusCorp = this.mplusApi.getCorpInfo();
            String icorpId = (String)mplusCorp.get("corpid");
            String packageId = icorpId + "_";
            packageId = bizConfigBean != null ? packageId + bizConfigBean.getId() : packageId + ValidityUtil.getUUIDInt10();
            originZipFile1 = new File(tempDir + File.separator + packageId + ".zip");
            String password1 = ValidityUtil.getPwd();
            ZipUtil.unzip((File)originZipFile, (File)unZipFile, (String)password);
            ZipUtil.zip((File)unZipFile, (File)originZipFile1, (String)password1, (boolean)false);
            signPackage = this.mplusApi.signPackage(originZipFile1, password1, packageId, 3153600000L, "1.0");
            FileUtil.copyFile((File)signPackage, (File)originZipFile);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u5e94\u7528\u5305\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("\u5e94\u7528\u5305\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.deleteFile((File)unZipFile);
                if (originZipFile1 != null) {
                    FileUtil.deleteFile(originZipFile1);
                }
                if (signPackage != null) {
                    FileUtil.deleteFile(signPackage);
                }
                throw throwable;
            }
        }
        FileUtil.deleteFile((File)unZipFile);
        if (originZipFile1 != null) {
            FileUtil.deleteFile((File)originZipFile1);
        }
        if (signPackage != null) {
            FileUtil.deleteFile((File)signPackage);
        }
    }

    @Override
    @AjaxAccess
    public Map<String, Object> signPrimitivePackage(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Long fileId = ParamUtil.getLong(params, (String)"fileId", (Long)0L);
        boolean sign = Boolean.valueOf(ParamUtil.getString(params, (String)"sign", (String)"false"));
        File importFile = this.fileManager.getFile(fileId, DateUtil.currentDate());
        if (importFile == null || !importFile.exists() || importFile.length() == 0L) {
            throw new BusinessException("\u627e\u4e0d\u5230\u6307\u5b9a\u6587\u4ef6\uff01");
        }
        this.signPrivatePackage(null, importFile, "ahfhaflafpon", false);
        StringBuilder url = new StringBuilder();
        Date date = new Date();
        url.append("fileUpload.do?method=download&fileId=").append(fileId);
        url.append("&createDate=").append(DateUtil.format((Date)date));
        url.append("&v=").append(SecurityHelper.digest((Object[])new Object[]{fileId})).append("&filename=");
        resultMap.put("fileurl", url.toString());
        resultMap.put("filename", ParamUtil.getString(params, (String)"fileName"));
        return resultMap;
    }

    @Override
    public Map<String, Object> validatePackage(File signedFile, boolean envSensitive, String from, Map<String, Object> params) throws BusinessException {
        String tempDir = this.fileManager.getNowFolder(true);
        String path = UUIDLong.absLongUUID() + "";
        String unZipDir = tempDir + File.separator + path;
        File unZipFile = new File(unZipDir);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (envSensitive && (SystemEnvironment.isDev() || AppContext.isRunningModeDevelop())) {
            this.validateDevPackage(result, signedFile, unZipFile, path, from, params, unZipDir);
            return result;
        }
        if (this.validateUpgradePackage(result, signedFile, unZipFile, path, from, params, unZipDir)) {
            return result;
        }
        if (this.validateTrialPackage(result, signedFile, unZipFile, path, from, params, unZipDir)) {
            return result;
        }
        this.validatePrivatePackage(result, signedFile, unZipFile, from, params);
        return result;
    }

    private void validateDevPackage(Map<String, Object> result, File signedFile, File unZipFile, String path, String from, Map<String, Object> params, String unZipDir) {
        try {
            File[] files;
            ZipUtil.unzip((File)signedFile, (File)unZipFile, (String)"ahfhaflafpon");
            for (File file : files = unZipFile.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".zip")) continue;
                result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
                result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.privateDecryError.label"));
                return;
            }
            String appId = unZipFile.list()[0];
            result.put("resultAppId", appId);
            result.put("path", path);
            result.put("code", ValidityEnum.ValidityResult.AppSuccess.getKey());
            result.put("message", ValidityEnum.ValidityResult.AppSuccess.getName());
            result.put("source", "\u5f00\u53d1\u7248\u6388\u6743\u4f7f\u7528");
            result.put("authto", "\u5317\u4eac\u81f4\u8fdc");
            result.put("authtime", DateUtil.getDate((Date)DateUtil.currentDate(), (String)"yyyy-MM-dd HH:mm"));
            result.put("total", "\u4e0d\u9650");
            result.put("rest", "-");
            result.put("endtime", "9999-12-31");
            if ("appSetup".equals(from)) {
                AppContext.putSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path), (Object)unZipDir);
                if (!this.checkAppCanInstallOrUpgrade(result, params)) {
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5e94\u7528\u5305\u89e3\u538b\u5931\u8d25!", (Throwable)e);
            result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
            result.put("message", ValidityEnum.ValidityResult.AppFail.getName());
        }
    }

    private boolean validateTrialPackage(Map<String, Object> result, File signedFile, File unZipFile, String path, String from, Map<String, Object> params, String unZipDir) {
        boolean trial = false;
        if (CAPParamUtil.getBooleanValue(params, (String)"upgrade")) {
            return false;
        }
        try {
            ZipUtil.unzip((File)signedFile, (File)unZipFile, (String)"ahfhaflafpon");
            File[] files = unZipFile.listFiles();
            result.put("path", path);
            result.put("code", ValidityEnum.ValidityResult.AppSuccess.getKey());
            result.put("message", ValidityEnum.ValidityResult.AppSuccess.getName());
            String appId = unZipFile.list()[0];
            result.put("resultAppId", appId);
            for (File file : files[0].listFiles()) {
                if (!file.isFile() || !"extension.json".equals(file.getName())) continue;
                String extension = FileUtils.readFileToString((File)file, (String)"UTF-8");
                Map extensionMap = (Map)JSONUtil.parseJSONString((String)extension);
                if (extensionMap.containsKey("trial") && Boolean.valueOf(extensionMap.get("trial").toString()).booleanValue()) {
                    trial = true;
                    result.put("trial", "true");
                    CapBizConfig capBizConfig = this.businessDAO4.findBizConfigById(Long.valueOf(appId));
                    if (capBizConfig != null && "appSetup".equals(from)) {
                        String createUserName = "";
                        V3xOrgMember member = this.orgManager.getMemberById(capBizConfig.getCreateUser());
                        if (member != null) {
                            createUserName = member.getName();
                        }
                        logger.info((Object)("\u91cd\u590d\u5b89\u88c5!" + appId));
                        result.put("code", ValidityEnum.ValidityResult.AppExist.getKey());
                        result.put("message", String.format(ValidityEnum.ValidityResult.AppExist.getName(), createUserName));
                    } else {
                        result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.trial.result.tips"));
                    }
                }
                if (extensionMap.containsKey("appName")) {
                    result.put("resultAppName", extensionMap.get("appName"));
                }
                if (extensionMap.containsKey("bizVersion")) {
                    result.put("bizVersion", extensionMap.get("bizVersion"));
                }
                if (!extensionMap.containsKey("createType")) break;
                result.put("sourceValue", extensionMap.get("createType"));
                BizEnums.BizCreateSourceType bizCreateSourceType = BizEnums.BizCreateSourceType.getByKey((int)Integer.valueOf(extensionMap.get("createType").toString()));
                result.put("source", bizCreateSourceType.getName(true));
                if (!trial) break;
                result.put("source", bizCreateSourceType.getTrialName(true));
                if (Strings.isNotEmpty((String)ValidityUtil.getMplusCorpName())) {
                    result.put("authto", ValidityUtil.getMplusCorpName());
                } else {
                    result.put("authto", "**********");
                }
                Date date = DateUtil.currentDate();
                result.put("authtime", DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm"));
                result.put("total", "60 " + ResourceUtil.getString((String)"com.cap.application.validate.trial.time.days.label"));
                result.put("endtime", DateUtil.format((Date)DateUtil.addDay((Date)date, (int)60), (String)"yyyy-MM-dd HH:mm"));
                break;
            }
            if (trial && "appSetup".equals(from)) {
                AppContext.putSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path), (Object)unZipDir);
                this.checkAppCanInstallOrUpgrade(result, params);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u8be5\u5e94\u7528\u4e0d\u662f\u8bd5\u7528!", (Throwable)e);
        }
        return trial;
    }

    private boolean validatePrivatePackage(Map<String, Object> result, File signedFile, File unZipFile, String from, Map<String, Object> params) {
        if (ValidityUtil.isValidMplusAccount()) {
            try {
                String manifestPath;
                Map<String, String> manifestMap;
                String appVer;
                File[] files;
                Map verifyResult = this.mplusApi.verifyPackage(signedFile);
                String password = (String)verifyResult.get("pwd");
                BizEnums.BizCreateSourceType bizCreateSourceType = BizEnums.BizCreateSourceType.getByKey((int)Integer.valueOf((String)verifyResult.get("source")));
                String source = bizCreateSourceType.getName(true);
                String sourceValue = bizCreateSourceType.getKey() + "";
                String authCorp = (String)verifyResult.get("authto");
                String authTime = ValidityUtil.getDateStr((long)Long.valueOf((String)verifyResult.get("authtime")), (String)"yyyy-MM-dd HH:mm:ss");
                String total = (String)verifyResult.get("total");
                String rest = (String)verifyResult.get("rest");
                String endDate = ValidityUtil.getDateStr((long)Long.valueOf((String)verifyResult.get("endtime")), (String)"yyyy-MM-dd HH:mm:ss");
                File resultFile = null;
                ZipUtil.unzip((File)signedFile, (File)unZipFile);
                for (File tempFile : files = unZipFile.listFiles()) {
                    CapBizConfig capBizConfig;
                    if (!tempFile.isFile() || !tempFile.getName().endsWith(".zip")) continue;
                    String resultPath = UUIDLong.absLongUUID() + "";
                    resultFile = new File(FormConstant.TEMPDIR + File.separator + resultPath);
                    ZipUtil.unzip((File)tempFile, (File)resultFile, (String)password);
                    String appId = resultFile.list()[0];
                    String appName = "";
                    boolean isApp = false;
                    File extensionFile = null;
                    if (resultFile.listFiles().length > 0 && resultFile.listFiles()[0].isDirectory() && resultFile.listFiles()[0].listFiles().length > 0) {
                        for (File tempInFile : resultFile.listFiles()[0].listFiles()) {
                            if (!tempInFile.isFile() || !"extension.json".equals(tempInFile.getName())) continue;
                            extensionFile = tempInFile;
                            isApp = true;
                            break;
                        }
                    }
                    if (extensionFile != null) {
                        String extension = FileUtils.readFileToString(extensionFile, (String)"UTF-8");
                        Map extensionMap = (Map)JSONUtil.parseJSONString((String)extension);
                        if (extensionMap.containsKey("orderType")) {
                            result.put("orderType", extensionMap.get("orderType"));
                        }
                        if (extensionMap.containsKey("formTotal")) {
                            result.put("formTotal", extensionMap.get("formTotal"));
                        }
                        if (extensionMap.containsKey("maxFormNumber")) {
                            result.put("maxFormNumber", extensionMap.get("maxFormNumber"));
                        }
                        if (this.checkAppFormNumber(Long.parseLong(appId), extensionMap)) {
                            String maxFormNum = MapUtils.getString((Map)extensionMap, (Object)"maxFormNumber");
                            result.put("code", ValidityEnum.ValidityResult.MAX_FROM_NUMBER_INSTALL.getKey());
                            result.put("message", ValidityEnum.ValidityResult.MAX_FROM_NUMBER_INSTALL.getName(maxFormNum));
                            result.put("maxFormNumber", maxFormNum);
                            return false;
                        }
                        if (extensionMap.containsKey("goodsId")) {
                            result.put("goodsId", extensionMap.get("goodsId"));
                        }
                        if (extensionMap.containsKey("bizVersion")) {
                            result.put("bizVersion", extensionMap.get("bizVersion"));
                        }
                        if (extensionMap.containsKey("orderGoodsId")) {
                            result.put("orderGoodsId", extensionMap.get("orderGoodsId"));
                        }
                        if (extensionMap.containsKey("trial")) {
                            result.put("trial", extensionMap.get("trial"));
                        }
                        if (extensionMap.get("appName") != null) {
                            appName = extensionMap.get("appName").toString();
                        }
                        if (extensionMap.get("appLogs") != null && Strings.isNotEmpty((String)extensionMap.get("appLogs").toString())) {
                            result.put("appLogs", extensionMap.get("appLogs"));
                        }
                        if (extensionMap.get("copyrightOrgName") != null && Strings.isNotEmpty((String)extensionMap.get("copyrightOrgName").toString())) {
                            result.put("copyrightOrgName", extensionMap.get("copyrightOrgName"));
                            result.put("copyrightOrgID", extensionMap.get("copyrightOrgID"));
                        }
                        if (extensionMap.get("validateInfo") != null) {
                            try {
                                String jsonStr = DesUtil.decode((String)extensionMap.get("validateInfo").toString(), (String)appId);
                                AppInfo appInfo = (AppInfo)JSONUtil.parseJSONString((String)jsonStr, AppInfo.class);
                                if (appInfo.getSource().equals(BizEnums.BizCreateSourceType.ImportFromMall.getKey() + "") || appInfo.getSource().equals(BizEnums.BizCreateSourceType.ImportFromRequir.getKey() + "")) {
                                    sourceValue = appInfo.getSource();
                                    bizCreateSourceType = BizEnums.BizCreateSourceType.getByKey((int)Integer.valueOf(sourceValue));
                                    source = bizCreateSourceType.getName(true);
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)("\u7b7e\u540d\u5305\u4e2d\u7684\u5e94\u7528\u4e3a\u8001\u7248\u9a8c\u8bc1\u4fe1\u606f\uff0c\u7565\u8fc7!" + extensionMap.get("validateInfo").toString()), (Throwable)e);
                            }
                        }
                        if (extensionMap.containsKey("trial") && Boolean.valueOf(extensionMap.get("trial").toString()).booleanValue()) {
                            result.put("trial", "true");
                            source = bizCreateSourceType.getTrialName(true);
                        }
                        logger.info((Object)("\u5f53\u524d\u5bfc\u5165\u5e94\u7528" + appName + "\u7684sourceValue\uff1a" + sourceValue));
                        if (sourceValue.equals(BizEnums.BizCreateSourceType.ImportFromMall.getKey() + "")) {
                            String backupFlag;
                            String string = backupFlag = extensionMap.get("backup_app") == null ? "" : extensionMap.get("backup_app").toString();
                            if ("true".equals(backupFlag) && !this.validateCloud(extensionMap)) {
                                result.put("code", ValidityEnum.ValidityResult.BackupAppNoLicenced.getKey());
                                result.put("message", ValidityEnum.ValidityResult.BackupAppNoLicenced.getName());
                                return false;
                            }
                        }
                    }
                    result.put("source", source);
                    result.put("sourceValue", sourceValue);
                    result.put("authto", authCorp);
                    result.put("authtime", authTime);
                    result.put("total", "0".equalsIgnoreCase(total) ? "--" : total);
                    result.put("rest", "0".equalsIgnoreCase(rest) ? "--" : rest);
                    result.put("realendtime", endDate);
                    if (bizCreateSourceType == BizEnums.BizCreateSourceType.Import) {
                        result.put("endtime", "9999-12-31");
                        result.put("endtimeDisplay", "--");
                    } else {
                        result.put("endtime", endDate);
                    }
                    result.put("path", resultPath);
                    result.put("resultFile", resultFile);
                    result.put("resultAppId", appId);
                    result.put("resultAppName", appName);
                    if (!"updateLic".equals(from) && isApp && (sourceValue.equals(BizEnums.BizCreateSourceType.ImportFromMall.getKey() + "") || sourceValue.equals(BizEnums.BizCreateSourceType.ImportFromRequir.getKey() + "")) && (capBizConfig = this.businessDAO4.findBizConfigById(Long.valueOf(appId))) != null) {
                        String createUserName = "";
                        V3xOrgMember member = this.orgManager.getMemberById(capBizConfig.getCreateUser());
                        if (member != null) {
                            createUserName = member.getName();
                        }
                        logger.info((Object)("\u91cd\u590d\u5b89\u88c5!" + appId));
                        result.put("code", ValidityEnum.ValidityResult.AppExist.getKey());
                        result.put("message", String.format(ValidityEnum.ValidityResult.AppExist.getName(), createUserName));
                        return false;
                    }
                    if (!"appSetup".equals(from)) break;
                    AppContext.putSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), resultPath), (Object)resultFile.getCanonicalPath());
                    if (this.checkAppCanInstallOrUpgrade(result, params)) break;
                    return false;
                }
                result.put("code", ValidityEnum.ValidityResult.AppSuccess.getKey());
                result.put("message", ValidityEnum.ValidityResult.AppSuccess.getName());
                if (sourceValue.equals(BizEnums.BizCreateSourceType.ImportFromMall.getKey() + "") && !this.validateAuthentication(unZipFile)) {
                    result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
                    result.put("message", ResourceUtil.getString((String)"com.cap.import.app.not.include.sign.info.tips"));
                }
                if (StringUtils.isNotEmpty((CharSequence)(appVer = (manifestMap = FuzzyPkgUtils.getMapFromPropertiesFile(manifestPath = unZipFile.getCanonicalPath() + File.separator + "META-INF" + File.separator + "MANIFEST.MF")).get("AppVer"))) && appVer.equals("8.16")) {
                    if (!this.validateAuthentication(unZipFile)) {
                        result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
                        result.put("message", ResourceUtil.getString((String)"com.cap.import.app.not.include.sign.info.tips"));
                    }
                    if (!FuzzyPkgUtils.validateFuzzyPackage(unZipFile, password)) {
                        result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
                        result.put("message", "Desenstive package vertify sign errro!");
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u7b7e\u540d\u5305\u89e3\u538b\u5931\u8d25!" + e.getMessage()), (Throwable)e);
                result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
                result.put("message", ValidityEnum.ValidityResult.AppFail.getName());
                this.validateOperate(signedFile, unZipFile, result);
            }
        } else {
            logger.info((Object)ValidityEnum.ValidityResult.MplusAccountInvalid.getName());
            result.put("code", ValidityEnum.ValidityResult.MplusAccountInvalid.getKey());
            result.put("message", ValidityEnum.ValidityResult.MplusAccountInvalid.getName());
        }
        return true;
    }

    private boolean validateUpgradePackage(Map<String, Object> result, File signedFile, File unZipFile, String path, String from, Map<String, Object> params, String unZipDir) {
        if (params == null || !CAPParamUtil.getBooleanValue(params, (String)"upgrade")) {
            return false;
        }
        if (ValidityUtil.isValidMplusAccount()) {
            try {
                File[] files;
                Map verifyResult = this.mplusApi.verifyPackage(signedFile);
                String password = (String)verifyResult.get("pwd");
                BizEnums.BizCreateSourceType bizCreateSourceType = BizEnums.BizCreateSourceType.getByKey((int)Integer.valueOf((String)verifyResult.get("source")));
                String source = bizCreateSourceType.getName(true);
                String sourceValue = bizCreateSourceType.getKey() + "";
                String authCorp = (String)verifyResult.get("authto");
                String authTime = ValidityUtil.getDateStr((long)Long.valueOf((String)verifyResult.get("authtime")), (String)"yyyy-MM-dd HH:mm:ss");
                String total = (String)verifyResult.get("total");
                String rest = (String)verifyResult.get("rest");
                String endDate = ValidityUtil.getDateStr((long)Long.valueOf((String)verifyResult.get("endtime")), (String)"yyyy-MM-dd HH:mm:ss");
                File resultFile = null;
                ZipUtil.unzip((File)signedFile, (File)unZipFile);
                for (File tempFile : files = unZipFile.listFiles()) {
                    if (!tempFile.isFile() || !tempFile.getName().endsWith(".zip")) continue;
                    String resultPath = UUIDLong.absLongUUID() + "";
                    resultFile = new File(FormConstant.TEMPDIR + File.separator + resultPath);
                    ZipUtil.unzip((File)tempFile, (File)resultFile, (String)password);
                    String appId = resultFile.list()[0];
                    String appName = "";
                    boolean isApp = false;
                    File extensionFile = null;
                    if (resultFile.listFiles().length > 0 && resultFile.listFiles()[0].isDirectory() && resultFile.listFiles()[0].listFiles().length > 0) {
                        for (File tempInFile : resultFile.listFiles()[0].listFiles()) {
                            if (!tempInFile.isFile() || !"extension.json".equals(tempInFile.getName())) continue;
                            extensionFile = tempInFile;
                            isApp = true;
                            break;
                        }
                    }
                    if (extensionFile != null) {
                        String extension = FileUtils.readFileToString(extensionFile, (String)"UTF-8");
                        Map extensionMap = (Map)JSONUtil.parseJSONString((String)extension);
                        if (this.checkAppFormNumber(Long.parseLong(appId), extensionMap)) {
                            String maxFormNum = MapUtils.getString((Map)extensionMap, (Object)"maxFormNumber");
                            result.put("code", ValidityEnum.ValidityResult.MAX_FROM_NUMBER_UPDATE.getKey());
                            result.put("message", ValidityEnum.ValidityResult.MAX_FROM_NUMBER_UPDATE.getName(maxFormNum));
                            return true;
                        }
                        if (extensionMap.containsKey("goodsId")) {
                            result.put("goodsId", extensionMap.get("goodsId"));
                        }
                        if (extensionMap.containsKey("bizVersion")) {
                            result.put("bizVersion", extensionMap.get("bizVersion"));
                        }
                        if (extensionMap.containsKey("orderGoodsId")) {
                            result.put("orderGoodsId", extensionMap.get("orderGoodsId"));
                        }
                        if (extensionMap.containsKey("trial")) {
                            result.put("trial", extensionMap.get("trial"));
                        }
                        if (extensionMap.get("appName") != null) {
                            appName = extensionMap.get("appName").toString();
                        }
                        if (extensionMap.get("appLogs") != null && StringUtil.isNotEmpty((String)extensionMap.get("appLogs").toString())) {
                            result.put("appLogs", extensionMap.get("appLogs"));
                        }
                        if (extensionMap.get("copyrightOrgName") != null && StringUtil.isNotEmpty((String)extensionMap.get("copyrightOrgName").toString())) {
                            result.put("copyrightOrgName", extensionMap.get("copyrightOrgName"));
                            result.put("copyrightOrgID", extensionMap.get("copyrightOrgID"));
                        }
                        if (extensionMap.containsKey("trial") && Boolean.valueOf(extensionMap.get("trial").toString()).booleanValue()) {
                            result.put("trial", "true");
                            result.put("code", ValidityEnum.ValidityResult.TRIAL_CANNOT_UPGRADE.getKey());
                            result.put("message", ValidityEnum.ValidityResult.TRIAL_CANNOT_UPGRADE.getName());
                            return true;
                        }
                        if (extensionMap.get("validateInfo") != null) {
                            try {
                                String jsonStr = DesUtil.decode((String)extensionMap.get("validateInfo").toString(), (String)appId);
                                AppInfo appInfo = (AppInfo)JSONUtil.parseJSONString((String)jsonStr, AppInfo.class);
                                if (appInfo.getSource().equals(BizEnums.BizCreateSourceType.ImportFromMall.getKey() + "") || appInfo.getSource().equals(BizEnums.BizCreateSourceType.ImportFromRequir.getKey() + "")) {
                                    sourceValue = appInfo.getSource();
                                    bizCreateSourceType = BizEnums.BizCreateSourceType.getByKey((int)Integer.valueOf(sourceValue));
                                    source = bizCreateSourceType.getName(true);
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)("\u7b7e\u540d\u5305\u4e2d\u7684\u5e94\u7528\u4e3a\u8001\u7248\u9a8c\u8bc1\u4fe1\u606f\uff0c\u7565\u8fc7!" + extensionMap.get("validateInfo").toString()), (Throwable)e);
                            }
                        }
                    }
                    result.put("source", source);
                    result.put("sourceValue", sourceValue);
                    result.put("authto", authCorp);
                    result.put("authtime", authTime);
                    result.put("total", "0".equalsIgnoreCase(total) ? "--" : total);
                    result.put("rest", "0".equalsIgnoreCase(rest) ? "--" : rest);
                    result.put("realendtime", endDate);
                    if (bizCreateSourceType == BizEnums.BizCreateSourceType.Import) {
                        result.put("endtime", "9999-12-31");
                        result.put("endtimeDisplay", "--");
                    } else {
                        result.put("endtime", endDate);
                    }
                    result.put("path", resultPath);
                    result.put("resultFile", resultFile);
                    result.put("resultAppId", appId);
                    result.put("resultAppName", appName);
                    if (!"appSetup".equals(from)) break;
                    AppContext.putSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), resultPath), (Object)resultFile.getCanonicalPath());
                    if (this.checkAppCanInstallOrUpgrade(result, params)) break;
                    return true;
                }
                result.put("code", ValidityEnum.ValidityResult.AppSuccess.getKey());
                result.put("message", ValidityEnum.ValidityResult.AppSuccess.getName());
                if (sourceValue.equals(BizEnums.BizCreateSourceType.ImportFromMall.getKey() + "") && !this.validateAuthentication(unZipFile)) {
                    result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
                    result.put("message", ResourceUtil.getString((String)"com.cap.import.app.not.include.sign.info.tips"));
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u7b7e\u540d\u5305\u89e3\u538b\u5931\u8d25!" + e.getMessage()), (Throwable)e);
                result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
                result.put("message", ValidityEnum.ValidityResult.AppFail.getName());
            }
        } else {
            logger.info((Object)ValidityEnum.ValidityResult.MplusAccountInvalid.getName());
            result.put("code", ValidityEnum.ValidityResult.MplusAccountInvalid.getKey());
            result.put("message", ValidityEnum.ValidityResult.MplusAccountInvalid.getName());
        }
        return true;
    }

    private boolean checkAppFormNumber(Long configId, Map extensionMap) throws BusinessException {
        String orderType = MapUtils.getString((Map)extensionMap, (Object)"orderType");
        String maxFormNumber = MapUtils.getString((Map)extensionMap, (Object)"maxFormNumber");
        String formTotal = MapUtils.getString((Map)extensionMap, (Object)"formTotal");
        if (SystemEnvironment.getProductLine().contains("A6") && "3".equals(orderType) && StringUtil.isNotEmpty((String)maxFormNumber)) {
            if (StringUtil.isNotEmpty((String)formTotal) && Integer.parseInt(formTotal) > Integer.parseInt(maxFormNumber)) {
                logger.error((Object)String.format("A6+\u5b89\u88c5\u5e94\u7528\u8868\u5355\u6570\u8d85\u8fc7\u6700\u5927\u9650\u5236%s", maxFormNumber));
                return true;
            }
            Long maxNumber = Long.parseLong(maxFormNumber);
            List<FormBean> list = this.businessManager4.getFormBeanListByBizId(configId);
            if (CollectionUtils.isNotEmpty(list) && (long)list.size() > maxNumber) {
                logger.error((Object)String.format("A6+\u5b89\u88c5\u5e94\u7528\u8868\u5355\u6570\u8d85\u8fc7\u6700\u5927\u9650\u5236%s", maxFormNumber));
                return true;
            }
        }
        return false;
    }

    private boolean checkAppCanInstallOrUpgrade(Map<String, Object> result, Map<String, Object> params) throws BusinessException {
        Long appId = ParamUtil.getLong(result, (String)"resultAppId", (Long)0L);
        CapBizConfig capBizConfig = this.businessDAO4.findBizConfigById(appId);
        String upgrade = ParamUtil.getString(params, (String)"upgrade", (String)"");
        String resetId = ParamUtil.getString(params, (String)"resetId", (String)"true");
        if ("true".equals(upgrade)) {
            Long upgradeAppId = ParamUtil.getLong(params, (String)"upgradeAppId", (Long)appId);
            if (capBizConfig == null || !appId.equals(upgradeAppId)) {
                result.put("code", ValidityEnum.ValidityResult.WITHOUT_APP.getKey());
                result.put("message", ValidityEnum.ValidityResult.WITHOUT_APP.getName());
                return false;
            }
            if (capBizConfig != null && !capBizConfig.getOwnerId().equals(AppContext.currentUserId())) {
                result.put("code", ValidityEnum.ValidityResult.WITHOUT_APP.getKey());
                result.put("message", ResourceUtil.getString((String)"com.cap.setup.app.not.owner.tips"));
                return false;
            }
        } else if ("false".equals(resetId) && capBizConfig != null) {
            V3xOrgMember member = this.orgManager.getMemberById(capBizConfig.getCreateUser());
            String createUserName = "";
            if (member != null) {
                createUserName = member.getName();
            }
            result.put("code", ValidityEnum.ValidityResult.REPEAT_INSTALL.getKey());
            result.put("message", ValidityEnum.ValidityResult.REPEAT_INSTALL.getName(createUserName));
            return false;
        }
        return true;
    }

    private boolean validateTrial(Map<String, Object> result, File[] files, String appId, String from) {
        result.put("resultAppId", appId);
        boolean trial = false;
        try {
            for (File file : files) {
                if (!file.isFile() || !"extension.json".equals(file.getName())) continue;
                String extension = FileUtils.readFileToString((File)file, (String)"UTF-8");
                Map extensionMap = (Map)JSONUtil.parseJSONString((String)extension);
                if (extensionMap.containsKey("trial") && Boolean.valueOf(extensionMap.get("trial").toString()).booleanValue()) {
                    trial = true;
                    result.put("trial", "true");
                    CapBizConfig capBizConfig = this.businessDAO4.findBizConfigById(Long.valueOf(appId));
                    if (capBizConfig != null && "appSetup".equals(from)) {
                        String createUserName = "";
                        V3xOrgMember member = this.orgManager.getMemberById(capBizConfig.getCreateUser());
                        if (member != null) {
                            createUserName = member.getName();
                        }
                        logger.info((Object)("\u91cd\u590d\u5b89\u88c5!" + appId));
                        result.put("code", ValidityEnum.ValidityResult.AppExist.getKey());
                        result.put("message", String.format(ValidityEnum.ValidityResult.AppExist.getName(), createUserName));
                    } else {
                        result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.trial.result.tips"));
                    }
                }
                if (extensionMap.containsKey("appName")) {
                    result.put("resultAppName", extensionMap.get("appName"));
                }
                if (extensionMap.containsKey("createType")) {
                    result.put("sourceValue", extensionMap.get("createType"));
                    BizEnums.BizCreateSourceType bizCreateSourceType = BizEnums.BizCreateSourceType.getByKey((int)Integer.valueOf(extensionMap.get("createType").toString()));
                    result.put("source", bizCreateSourceType.getName(false));
                    if (trial) {
                        result.put("source", result.get("source") + "_" + bizCreateSourceType.getTrialName());
                        if (Strings.isNotEmpty((String)ValidityUtil.getMplusCorpName())) {
                            result.put("authto", ValidityUtil.getMplusCorpName());
                        } else {
                            result.put("authto", "**********");
                        }
                        Date date = DateUtil.currentDate();
                        result.put("authtime", DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm"));
                        result.put("total", "60 " + ResourceUtil.getString((String)"com.cap.application.validate.trial.time.days.label"));
                        result.put("endtime", DateUtil.format((Date)DateUtil.addDay((Date)date, (int)60), (String)"yyyy-MM-dd HH:mm"));
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.info((Object)("\u975e\u8bd5\u7528" + e.getMessage()));
        }
        return trial;
    }

    private boolean validateOperate(File signedFile, File unZipFile, Map<String, Object> result) {
        block10: {
            try {
                try {
                    ZipUtil.unzip((File)signedFile, (File)unZipFile);
                }
                catch (Exception e) {
                    logger.info((Object)(unZipFile + "\u5df2\u89e3\u538b\u6216\u89e3\u538b\u5931\u8d25\uff01"));
                }
                File manifestFile = new File(unZipFile + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
                String keyStr = PropertiesUtil.getFromFile((File)manifestFile).getProperty("Key");
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("dogNo", CAPBusinessUtil.getDogNo());
                dataMap.put("corpId", ValidityUtil.getMplusCorpId());
                dataMap.put("key", keyStr);
                Map<String, Object> parameterMap = MallUtil.getMallCommonParams(MallUtil.MallAction.IDENTIFY_UNIT_PWD, dataMap);
                Map<String, Object> httpResult = HttpClientUtil.doPost(MallUtil.getRestApiUrl(MallUtil.RestApi.HOME_INDEX), parameterMap);
                if (httpResult.get("data") != null && httpResult.get("data") instanceof Map) {
                    File[] files;
                    logger.info((Object)"\u8fd0\u7ef4\u5355\u4f4d\u9a8c\u8bc1\u901a\u8fc7!");
                    String password = CAPParamUtil.getString((Map)CAPParamUtil.getParamsMapByKey(httpResult, (String)"data"), (String)"password");
                    for (File tempFile : files = unZipFile.listFiles()) {
                        if (!tempFile.isFile() || !tempFile.getName().endsWith(".zip")) continue;
                        String resultPath = UUIDLong.absLongUUID() + "";
                        File resultFile = new File(FormConstant.TEMPDIR + File.separator + resultPath);
                        ZipUtil.unzip((File)tempFile, (File)resultFile, (String)password);
                        AppContext.putSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), resultPath), (Object)resultFile.getCanonicalPath());
                        String appId = resultFile.list()[0];
                        CapBizConfig capBizConfig = this.businessDAO4.findBizConfigById(Long.valueOf(appId));
                        if (capBizConfig != null) {
                            File[] createUserName = "";
                            V3xOrgMember member = this.orgManager.getMemberById(capBizConfig.getCreateUser());
                            if (member != null) {
                                createUserName = member.getName();
                            }
                            logger.info((Object)("\u91cd\u590d\u5b89\u88c5!" + appId));
                            result.put("code", ValidityEnum.ValidityResult.AppExist.getKey());
                            result.put("message", String.format(ValidityEnum.ValidityResult.AppExist.getName(), new Object[]{createUserName}));
                        } else {
                            result.put("code", ValidityEnum.ValidityResult.AppSuccess.getKey());
                            result.put("message", ResourceUtil.getString((String)"com.cap.application.validate.verificationPassed.label"));
                        }
                        for (File file : resultFile.listFiles()[0].listFiles()) {
                            String extension;
                            Map extensionMap;
                            if (!file.isFile() || !"extension.json".equals(file.getName()) || !(extensionMap = (Map)JSONUtil.parseJSONString((String)(extension = FileUtils.readFileToString((File)file, (String)"UTF-8")))).containsKey("appName")) continue;
                            result.put("resultAppName", extensionMap.get("appName"));
                        }
                        result.put("resultAppId", appId);
                        result.put("path", resultPath);
                        result.put("resultFile", resultFile);
                        result.put("trial", "true");
                        result.put("sourceValue", BizEnums.BizCreateSourceType.Operate.getKey());
                        result.put("source", BizEnums.BizCreateSourceType.Operate.getName());
                        result.put("authto", ValidityUtil.getMplusCorpName());
                        Date date = DateUtil.currentDate();
                        result.put("authtime", DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm"));
                        result.put("total", 60 + ResourceUtil.getString((String)"cap4.form.business.day"));
                        result.put("endtime", DateUtil.format((Date)DateUtil.addDay((Date)date, (int)60), (String)"yyyy-MM-dd HH:mm"));
                        break block10;
                    }
                    break block10;
                }
                return false;
            }
            catch (Exception e) {
                logger.error((Object)("\u8fd0\u7ef4\u5355\u4f4d\u9a8c\u8bc1\u5931\u8d25!" + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean validateAuthentication(File unZipFile) throws BusinessException {
        boolean result = true;
        try {
            String currentHash;
            File metaFolder;
            File targetFile = null;
            for (File tempFile : unZipFile.listFiles()) {
                if (!tempFile.isFile() || !tempFile.getName().endsWith(".zip")) continue;
                targetFile = tempFile;
                break;
            }
            if ((metaFolder = new File(unZipFile.getCanonicalPath() + File.separator + "SIGN-INF")) == null || !metaFolder.isDirectory() || metaFolder.listFiles().length == 0) {
                return false;
            }
            File certificateFile = null;
            Properties properties = null;
            ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
            X509Certificate verifyCer = null;
            Properties pkgInfo = null;
            File cerInfoFile = null;
            for (File tempFile : metaFolder.listFiles()) {
                if (tempFile.isFile() && "sign.checksum.cer1".equalsIgnoreCase(tempFile.getName())) {
                    properties = ValidityUtil.getProperties((File)tempFile);
                    continue;
                }
                if (tempFile.isFile() && tempFile.getName().endsWith(".cer")) {
                    X509Certificate tempCer = CertificateUtils.getCert(tempFile.getCanonicalPath());
                    if (!CertificateUtils.verifyCertificate(tempCer)) {
                        logger.info((Object)("\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25\uff1a" + tempFile.getCanonicalPath()));
                        throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.certificate.validate.fail.tips"));
                    }
                    certificateList.add(tempCer);
                    if (!"cer.cer".equalsIgnoreCase(tempFile.getName())) continue;
                    verifyCer = tempCer;
                    certificateFile = tempFile;
                    continue;
                }
                if (tempFile.isFile() && "pkg.info".equalsIgnoreCase(tempFile.getName())) {
                    pkgInfo = ValidityUtil.getProperties((File)tempFile);
                    continue;
                }
                if (!tempFile.isFile() || !"cerinfo.list".equalsIgnoreCase(tempFile.getName())) continue;
                cerInfoFile = tempFile;
            }
            if (verifyCer == null || properties == null || pkgInfo == null || cerInfoFile == null) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.cant.find.certificate.tips"));
            }
            String encryptHash = properties.getProperty("hash");
            String signInfo = properties.getProperty("signInfo");
            byte[] encrypt = Base64.decode((String)encryptHash);
            if (encrypt == null || Strings.isEmpty((String)signInfo)) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.sign.info.error.tips"));
            }
            if (!CertificateUtils.verifySign(encrypt, signInfo, certificateFile.getCanonicalPath())) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.sign.info.error.tips"));
            }
            byte[] decrypt = CertificateUtils.decryptByPublicKey(encrypt, certificateFile.getCanonicalPath());
            String hash = new String(decrypt, "UTF-8");
            if (!hash.equals(currentHash = ValidityUtil.shaHashCode((File)targetFile))) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.sign.info.tamper.tips"));
            }
            String rootCertificatePath = SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "cfgHome" + File.separator + "plugin" + File.separator + "cap4" + File.separator + "cert" + File.separator + "root.cer";
            File rootCertificate = new File(rootCertificatePath);
            if (rootCertificate == null) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.cant.find.root.certificate.tips"));
            }
            X509Certificate rootCer = CertificateUtils.getCert(rootCertificatePath);
            if (!CertificateUtils.verifyCertificate(rootCer)) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.root.certificate.validate.fail.tips"));
            }
            certificateList.add(rootCer);
            List<X509Certificate> orderList = CertificateUtils.orderFromSpecialCert(certificateList, verifyCer);
            if (!CertificateUtils.verifyCertificate(orderList.get(1), orderList.get(0))) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.certificate.validate.fail.tips"));
            }
            String url = AppContext.getSystemProperty((String)"cap4.cloudAuthUrl");
            String pkgid = pkgInfo.getProperty("pkgId");
            String corpId = ValidityUtil.getMplusCorpId();
            StringBuilder pkgSb = new StringBuilder();
            pkgSb.append(pkgid).append(";");
            pkgSb.append(pkgInfo.getProperty("signTime")).append(";");
            pkgSb.append(corpId).append(";");
            pkgSb.append(pkgInfo.getProperty("hash")).append(";");
            pkgSb.append(pkgInfo.getProperty("version")).append(";");
            pkgSb.append(pkgInfo.getProperty("signId")).append(";");
            pkgSb.append(pkgInfo.getProperty("signSn")).append(";");
            pkgSb.append(pkgInfo.getProperty("certId"));
            String pkgInfoSign = pkgInfo.getProperty("pkgInfoSign");
            String pkgInfoMd5 = DigestUtils.md5Hex((String)pkgSb.toString());
            if (!CertificateUtils.verifySign(pkgInfoMd5.getBytes("UTF-8"), pkgInfoSign, certificateFile.getCanonicalPath())) {
                throw new BusinessException("\u4e1a\u52a1\u5305\u5c5e\u6027\u4fe1\u606f\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            LinkedList<String> certInfoList = new LinkedList<String>();
            StringBuilder cerListStr = new StringBuilder();
            this.readFileToMap(cerInfoFile, cerListStr, certInfoList);
            String cerListInfo = cerListStr.toString();
            cerListInfo = cerListInfo.substring(0, cerListInfo.length() - 1);
            String cerListInfoMD5 = DigestUtils.md5Hex((String)cerListInfo);
            String cerListSignInfo = certInfoList.pollLast();
            if (!CertificateUtils.verifySign(cerListInfoMD5.getBytes("UTF-8"), cerListSignInfo, rootCertificate.getCanonicalPath())) {
                throw new BusinessException("\u5305\u8bc1\u4e66\u5217\u8868\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            String currentCertHash = ValidityUtil.shaHashCode((File)certificateFile);
            String hashInPkg = "";
            for (String str : certInfoList) {
                String[] arr = str.split("[-]");
                if (arr.length != 6 || !arr[0].equals(pkgInfo.getProperty("certId")) || !arr[2].equals(pkgInfo.getProperty("signSn"))) continue;
                hashInPkg = arr[5];
                break;
            }
            if (!currentCertHash.equals(hashInPkg)) {
                throw new BusinessException("\u8bc1\u4e66\u53ef\u80fd\u88ab\u7be1\u6539\uff0c\u4e0d\u80fd\u5b89\u88c5\uff01");
            }
            HashMap<String, Object> authMap = new HashMap<String, Object>();
            authMap.put("pkgId", pkgid);
            authMap.put("signTime", pkgInfo.getProperty("signTime"));
            authMap.put("corpId", corpId);
            authMap.put("hash", currentHash);
            authMap.put("version", pkgInfo.getProperty("version"));
            authMap.put("signId", pkgInfo.getProperty("signId"));
            authMap.put("certId", pkgInfo.getProperty("certId"));
            Map<String, Object> authResultMap = HttpClientUtil.doPost(url + "/auth/signtimepass", authMap);
            if ("true".equals(authResultMap.get("isSuccess").toString())) {
                String data;
                String string = data = authResultMap.get("data") == null ? "" : authResultMap.get("data").toString();
                if (Strings.isNotEmpty((String)data)) {
                    logger.info((Object)("\u9a8c\u8bc1\u7ed3\u679c\uff1a" + data));
                    throw new BusinessException("\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                }
            }
            Object[] res = CertificateUtils.getToken(corpId, pkgid);
            String token = (String)res[0];
            byte[] pkBytes = (byte[])res[1];
            String ylHash = DigestUtils.md5Hex((byte[])pkBytes);
            if (!ylHash.equals(CertificateUtils.getYlHash(certInfoList))) {
                throw new BusinessException("\u4e91\u8054\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25\uff0c\u53ef\u80fd\u88ab\u7be1\u6539\uff01");
            }
            HashMap<String, Object> getListParam = new HashMap<String, Object>();
            getListParam.put("corpId", corpId);
            getListParam.put("token", token);
            Map<String, Object> certListMap = HttpClientUtil.doPost(url + "/auth/getcertlist", getListParam);
            boolean isOnline = false;
            LinkedList<String> validateCerInfoList = new LinkedList<String>();
            if ("true".equals(certListMap.get("isSuccess").toString())) {
                isOnline = true;
                List onlineList = (List)certListMap.get("data");
                for (String cerInfo : onlineList) {
                    if (cerInfo.startsWith("certInfoListSign=")) continue;
                    validateCerInfoList.add(cerInfo);
                }
            }
            if (!isOnline) {
                validateCerInfoList.addAll(certInfoList);
            }
            if (!CertificateUtils.vertifySigntime(Long.parseLong(pkgInfo.getProperty("certId")), 1, pkgInfo.getProperty("signSn"), Long.parseLong(pkgInfo.getProperty("signTime")), validateCerInfoList)) {
                throw new BusinessException("\u8bc1\u4e66\u5217\u8868\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u9a8c\u8bc1\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void readFileToMap(File keyFile, StringBuilder cerList, List<String> certInfoList) throws BusinessException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(keyFile));
            String line = reader.readLine();
            HashMap<String, Integer> serialNoMap = new HashMap<String, Integer>();
            while (line != null) {
                if (line.startsWith("certInfoListSign=")) {
                    line = StringUtils.replaceOnce((String)line, (String)"certInfoListSign=", (String)"");
                } else {
                    String[] arr = line.split("[-]");
                    String certSn = arr[2];
                    Integer num = (Integer)serialNoMap.get(certSn);
                    if (num == null) {
                        if (!arr[0].equals("1")) {
                            throw new BusinessException("\u8bc1\u4e66\u5217\u8868\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                        }
                        serialNoMap.put(certSn, 1);
                    } else {
                        if (!arr[0].equals(String.valueOf(num + 1))) {
                            throw new BusinessException("\u8bc1\u4e66\u5217\u8868\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                        }
                        serialNoMap.put(certSn, num + 1);
                    }
                    cerList.append(line).append(";");
                }
                certInfoList.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                logger.info((Object)("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                throw new BusinessException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> validateCtrl(File signedFile) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String tempDir = this.fileManager.getNowFolder(true);
        String path = UUIDLong.absLongUUID() + "";
        String unZipDir = tempDir + File.separator + path;
        File unZipFile = new File(unZipDir);
        File unZipFileTest = new File(tempDir + File.separator + UUIDLong.absLongUUID());
        try {
            File[] files;
            ZipUtil.unzip((File)signedFile, (File)unZipFile, (String)"ahfhaflafpon");
            for (File file : files = unZipFile.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".zip")) continue;
                ZipUtil.unzip((File)file, (File)unZipFileTest);
            }
            result.put("code", ValidityEnum.ValidityResult.AppSuccess.getKey());
            result.put("resultFile", unZipFile);
            result.put("sourceValue", ValidityEnum.ResourceSource.FREE.getKey());
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            logger.info((Object)("\u975e\u88f8\u5305" + signedFile.getName()));
        }
        finally {
            if (unZipFileTest.exists()) {
                unZipFileTest.delete();
            }
        }
        result = this.validatePackage(signedFile, false, "", new HashMap<String, Object>(2));
        return result;
    }

    @Override
    public int getActiveExpireDates() throws BusinessException {
        return 0;
    }

    @Override
    public Map<String, Object> exportActivePackage() throws BusinessException {
        return null;
    }

    @Override
    public Map<String, Object> importActivePackage(Map<String, Object> params) throws BusinessException {
        return null;
    }

    @Override
    public String generateValidate(Object obj) throws BusinessException {
        String result = "";
        AppInfo appInfo = new AppInfo();
        if (obj instanceof CapBizConfig) {
            CapBizConfig config = (CapBizConfig)obj;
            if (config.getExtraMap().containsKey("endtime") && Strings.isNotEmpty((String)config.getExtraAttr("endtime").toString())) {
                try {
                    config.setEndDate(DateUtil.parse((String)config.getExtraAttr("endtime").toString(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (ParseException e) {
                    logger.error((Object)("\u622a\u6b62\u65f6\u95f4\u9519\u8bef\uff1a" + config.getName()), (Throwable)e);
                }
            }
            appInfo.setCreateUserId(config.getCreateUser());
            if (config.getExtraAttr("createDogNo") != null) {
                appInfo.setCreateDogNo(config.getExtraAttr("createDogNo").toString());
            }
            if (config.getExtraAttr("trial") != null) {
                appInfo.setTrial(config.getExtraAttr("trial").toString());
            }
            if (config.getExtraAttr("createCorpId") != null) {
                appInfo.setCreateCorpId(config.getExtraAttr("createCorpId").toString());
            }
            if (config.getExtraAttr("createCorpName") != null) {
                appInfo.setCreateCorpName(config.getExtraAttr("createCorpName").toString());
            }
            if (config.getExtraAttr("goodsId") != null) {
                appInfo.setGoodsId(config.getExtraAttr("goodsId").toString());
            }
            if (config.getExtraAttr("orderGoodsId") != null) {
                appInfo.setOrderGoodsId(config.getExtraAttr("orderGoodsId").toString());
            }
            if (config.getExtraAttr("bizVersion") != null) {
                appInfo.setAppVersion(config.getExtraAttr("bizVersion").toString());
            }
            if (config.getExtraAttr("customCopyrightOrgID") != null) {
                appInfo.setCustomCopyrightOrgID(config.getExtraAttr("customCopyrightOrgID").toString());
            }
            if (config.getExtraAttr("endtime") != null) {
                appInfo.setExpDate(config.getExtraAttr("endtime").toString());
            }
            if (config.getExtraAttr("authto") != null) {
                appInfo.setAuthto(config.getExtraAttr("authto").toString());
            }
            if (config.getExtraAttr("authtime") != null) {
                appInfo.setAuthtime(config.getExtraAttr("authtime").toString());
            }
            if (config.getExtraAttr("total") != null) {
                appInfo.setTotal(config.getExtraAttr("total").toString());
            }
            if (config.getExtraAttr("rest") != null) {
                appInfo.setRest(config.getExtraAttr("rest").toString());
            }
            if (config.getEndDate() == null) {
                config.setEndDate(ValidityUtil.MAX_END_DATE);
            }
            if (config.getLicenseUpdateDate() == null) {
                config.setLicenseUpdateDate(config.getCreateDate());
            }
            if (config.getEndDate() != null) {
                appInfo.setExpDate(DateUtil.getDate((Date)config.getEndDate(), (String)"yyyy-MM-dd HH:mm"));
            }
            if (config.getBizCreateType().intValue() == BizEnums.BizCreateSourceType.SelfCreate.getKey()) {
                appInfo.setTotal("--");
                appInfo.setAuthto(ValidityUtil.getMplusCorpName());
                appInfo.setAuthtime(DateUtil.getDate((Date)config.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            appInfo.setId(config.getId().toString());
            appInfo.setSource(config.getBizCreateType().toString());
        } else if (obj instanceof CAPCloudResource) {
            CAPCloudResource resource = (CAPCloudResource)((Object)obj);
            appInfo.setId(resource.getId().toString());
            appInfo.setSource(resource.getCreateType().toString());
            appInfo.setCreateUserId(resource.getCreateUser());
        }
        try {
            result = ValidityUtil.generateValidate((AppInfo)appInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u751f\u6210\u9a8c\u8bc1\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    private boolean validateRuntime(BizConfigBean configBean, AppInfo appInfoEnv) throws BusinessException {
        try {
            String jsonStr = DesUtil.decode((String)appInfoEnv.getSourceInfo(), (String)appInfoEnv.getId());
            AppInfo appInfo = (AppInfo)JSONUtil.parseJSONString((String)jsonStr, AppInfo.class);
            if (null != configBean) {
                configBean.setAppInfo(appInfo);
                if (configBean.getTrial() != null && configBean.getTrial().intValue() == BizEnums.BizTrial.trial.getKey()) {
                    return true;
                }
            }
            if (appInfo.getCreateUserId() != null) {
                // empty if block
            }
            if (appInfo.getId() != null && !appInfo.getId().equals(appInfoEnv.getId())) {
                logger.info((Object)"\u5e94\u7528\u6570\u636e3\u4e0d\u5339\u914d");
                return false;
            }
            if (appInfo.getSource() != null && !appInfo.getSource().equals(appInfoEnv.getSource())) {
                logger.info((Object)"\u5e94\u7528\u6570\u636e4\u4e0d\u5339\u914d");
                return false;
            }
            if (SystemEnvironment.isDevOrTG() || AppContext.isRunningModeDevelop()) {
                return true;
            }
            if (appInfo.getIcorpId() != null) {
                if (!ValidityUtil.isValidMplusAccount()) {
                    logger.info((Object)ValidityEnum.ValidityResult.MplusAccountInvalid.getName());
                    return false;
                }
                String iCorpId = ValidityUtil.getMplusCorpId();
                if (!appInfo.getIcorpId().equals(iCorpId)) {
                    logger.info((Object)("\u5e94\u7528\u6240\u5c5e\u4e91\u8054\u4f01\u4e1aID\u4e0d\u5339\u914d\uff0c\u5e94\u7528\u6240\u5c5e\u4f01\u4e1aID\uff1a" + appInfo.getIcorpId() + ",\u5f53\u524d\u4f01\u4e1aID\uff1a" + iCorpId));
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.info((Object)("\u8fd0\u884c\u65f6\u9a8c\u8bc1\u5f02\u5e38" + e.getMessage()));
            return false;
        }
    }

    private boolean validateRuntime(BizConfigBean config) throws BusinessException {
        if (config.getBizCreateType().intValue() == BizEnums.BizCreateSourceType.Preset.getKey()) {
            logger.info((Object)("\u9884\u7f6e\u5305\u76f4\u63a5\u901a\u8fc7:" + config.getId()));
            return true;
        }
        if (BizChicken4.isOut((Long)config.getId())) {
            logger.info((Object)("\u7cfb\u7edf\u6700\u5927\u5e94\u7528\u5bb9\u91cf\uff1a" + BizChicken4.getTotalNum() + "\u5f53\u524d\u5df2\u7528\u5bb9\u91cf\uff1a" + BizChicken4.getUsedNum() + "\u8be5\u5e94\u7528\u8d85\u91cf\uff1a" + config.getName() + "-" + config.getId()));
            config.setInvalidType(ValidityEnum.InvalidType.OUT.getKey());
            config.setInvalidReson(String.format(ValidityEnum.InvalidType.OUT.getName(), this.getTotalCount()));
            return false;
        }
        try {
            BizEgg.decodeEggId((String)config.getBizSourceInfo());
            return true;
        }
        catch (Exception e) {
            logger.info((Object)("\u9700\u8981\u65b0\u7248\u9a8c\u8bc1\uff1a" + config.getId()));
            AppInfo appInfoEnv = new AppInfo();
            appInfoEnv.setId(config.getId().toString());
            appInfoEnv.setSource(config.getBizCreateType().toString());
            appInfoEnv.setSourceInfo(config.getBizSourceInfo());
            appInfoEnv.setCreateUserId(config.getCreateUser());
            if (!this.validateRuntime(config, appInfoEnv)) {
                config.setInvalidType(ValidityEnum.InvalidType.UNMATCH.getKey());
                config.setInvalidReson(ValidityEnum.InvalidType.UNMATCH.getName());
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean validateRuntime(Object obj) throws BusinessException {
        if (obj instanceof BizConfigBean) {
            return this.validateRuntime((BizConfigBean)obj);
        }
        if (obj instanceof CAPCloudResource) {
            CAPCloudResource capCloudResource = (CAPCloudResource)((Object)obj);
            AppInfo appInfoEnv = new AppInfo();
            appInfoEnv.setId(capCloudResource.getId().toString());
            appInfoEnv.setSource(capCloudResource.getCreateType().toString());
            appInfoEnv.setSourceInfo(capCloudResource.getResourceInfo());
            appInfoEnv.setCreateUserId(capCloudResource.getCreateUser());
            return this.validateRuntime(null, appInfoEnv);
        }
        return false;
    }

    @Override
    public boolean validateCloud(Map<String, Object> params) throws BusinessException {
        if (StringUtil.isEmpty((String)CAPParamUtil.getString(params, (String)"goodsId"))) {
            return false;
        }
        params.put("corpId", ValidityUtil.getMplusCorpId());
        Map<String, Object> parameterMap = MallUtil.getMallCommonParams(MallEnum.MallAction.IS_FREE, params);
        Map<String, Object> httpResult = HttpClientUtil.doPost(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), parameterMap);
        return MallUtil.isRequestSuccess(httpResult);
    }

    @Override
    public boolean validatePartener() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("corpId", ValidityUtil.getMplusCorpId());
        Map<String, Object> parameterMap = MallUtil.getMallCommonParams(MallEnum.MallAction.PARTENTER, params);
        Map<String, Object> httpResult = HttpClientUtil.doPost(MallUtil.getRestApiUrl(MallUtil.RestApi.MALL_INDEX), parameterMap);
        return MallUtil.isRequestSuccess(httpResult);
    }

    public static void main(String[] args) {
    }

    public void init() throws BusinessException {
        this.initUsedCount();
    }

    private void initUsedCount() throws BusinessException {
        List<CapBizConfig> capBizConfigs = this.getNeedCheckRightAppList();
        try {
            BizChicken4.initUsedCount(capBizConfigs);
        }
        catch (Exception e) {
            throw new BusinessException("\u521d\u59cb\u5316\u4ea7\u80fd\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private List<CapBizConfig> getNeedCheckRightAppList() throws BusinessException {
        List<CapBizConfig> capBizConfigs = this.businessDAO4.getAllCtpBizConfig();
        ArrayList<CapBizConfig> capBizConfigsResult = new ArrayList<CapBizConfig>();
        for (CapBizConfig capBizConfig : capBizConfigs) {
            BizConfigBean bizConfigBean = new BizConfigBean();
            BeanUtils.convert((Object)bizConfigBean, (Object)capBizConfig);
            if (!this.validateRuntime(bizConfigBean)) {
                logger.info((Object)("\u975e\u6cd5\u5e94\u7528\u4e0d\u5360\u5bb9\u91cf\uff1a" + capBizConfig.getName() + "-" + capBizConfig.getId()));
                continue;
            }
            if (capBizConfig.getUseFlag() != null && capBizConfig.getUseFlag().intValue() == BizEnums.BizUseFlag.disable.getKey()) {
                logger.info((Object)("\u5e94\u7528\u672a\u542f\u7528\uff08\u4e0d\u5360\u5bb9\u91cf\uff09\uff1a" + capBizConfig.getName() + "-" + capBizConfig.getId()));
                continue;
            }
            if (capBizConfig.getBizCreateType().intValue() == BizEnums.BizCreateSourceType.SelfCreate.getKey() || capBizConfig.getBizCreateType().intValue() == BizEnums.BizCreateSourceType.Import.getKey()) {
                if (capBizConfig.getTrial() != null && capBizConfig.getTrial().intValue() == BizEnums.BizTrial.trial.getKey()) {
                    logger.info((Object)("\u81ea\u5efa\u5e94\u7528\u8bd5\u7528\uff08\u4e0d\u5360\u5bb9\u91cf\uff09\uff1a" + capBizConfig.getName() + "-" + capBizConfig.getId()));
                    continue;
                }
                logger.info((Object)("\u8be5\u5e94\u7528\u5360\u5bb9\u91cf\uff1a" + capBizConfig.getName() + "-" + capBizConfig.getId()));
                capBizConfigsResult.add(capBizConfig);
            }
            if (capBizConfig.getBizCreateType().intValue() != BizEnums.BizCreateSourceType.ImportFromRequir.getKey() || !AppContext.hasPlugin((String)"cap_advance")) continue;
            logger.info((Object)("\u8be5\u5e94\u7528\u5360\u5bb9\u91cf\uff1a" + capBizConfig.getName() + "-" + capBizConfig.getId()));
            capBizConfigsResult.add(capBizConfig);
        }
        return capBizConfigsResult;
    }

    public boolean needControlCount() {
        return this.getTotalCount() != -1;
    }

    public boolean checkCount4Dev() {
        return SystemEnvironment.isDev() || AppContext.isRunningModeDevelop();
    }

    @Override
    public synchronized BizValidateResultVO preValidateBiz(int createType, BizOperationEnum4 operation) {
        return this.preValidateBiz(createType, operation, 1);
    }

    @Override
    public synchronized BizValidateResultVO preValidateBiz(BizConfigBean bizConfig, BizOperationEnum4 operation) throws BusinessException {
        if (bizConfig.getTrial() != null && bizConfig.getTrial().intValue() == BizEnums.BizTrial.trial.getKey()) {
            BizValidateResultVO resultVO = new BizValidateResultVO();
            resultVO.setSuccess(true);
            return resultVO;
        }
        return this.preValidateBiz(bizConfig.getBizCreateType(), operation);
    }

    @Override
    public synchronized BizValidateResultVO preValidateBiz(int createType, BizOperationEnum4 operation, int addNum) {
        return this.validateBiz(createType, operation, addNum, false);
    }

    @Override
    public synchronized BizValidateResultVO validateBiz(int createType, BizOperationEnum4 operation) {
        return this.validateBiz(createType, operation, 1);
    }

    @Override
    public synchronized BizValidateResultVO validateBiz(BizConfigBean bizConfig, BizOperationEnum4 operation) throws BusinessException {
        if (bizConfig.getTrial() != null && bizConfig.getTrial().intValue() == BizEnums.BizTrial.trial.getKey() && (bizConfig.getBizCreateType().intValue() == BizEnums.BizCreateSourceType.SelfCreate.getKey() || bizConfig.getBizCreateType().intValue() == BizEnums.BizCreateSourceType.Import.getKey())) {
            BizValidateResultVO resultVO = new BizValidateResultVO();
            resultVO.setSuccess(true);
            return resultVO;
        }
        return this.validateBiz(bizConfig.getBizCreateType(), operation);
    }

    @Override
    public synchronized BizValidateResultVO validateBiz(int createType, BizOperationEnum4 operation, int addNum) {
        return this.validateBiz(createType, operation, addNum, true);
    }

    @Override
    public synchronized BizValidateResultVO validateBiz(int createType, BizOperationEnum4 operation, int addNum, boolean isNotPre) {
        BizValidateResultVO resultVO = new BizValidateResultVO();
        if (!this.needControlCount() || createType == BizEnums.BizCreateSourceType.ImportFromMall.getKey() || createType == BizEnums.BizCreateSourceType.Preset.getKey()) {
            resultVO.setSuccess(true);
            return resultVO;
        }
        if (createType == BizEnums.BizCreateSourceType.ImportFromRequir.getKey() && !AppContext.hasPlugin((String)"cap_advance")) {
            resultVO.setSuccess(true);
            return resultVO;
        }
        logger.info((Object)("\u4ea7\u80fd\u6821\u9a8c\u65e5\u5fd7\uff0c\u6821\u9a8c\u524d\uff1a\u64cd\u4f5c\u7c7b\u578b\uff1a" + operation.getName() + " total:" + this.getTotalCount() + " used:" + BizChicken4.getUsedNum() + " \u6821\u9a8c\u6570\uff1a" + addNum + " \u662f\u5426\u9884\u6821\u9a8c\uff1a" + isNotPre));
        if (operation.isAddCount()) {
            if (BizChicken4.isAllowAdd((int)addNum)) {
                if (isNotPre) {
                    this.modifyUsedCount(operation, addNum);
                }
                resultVO.setSuccess(true);
            } else {
                resultVO.setSuccess(false);
                resultVO.setCode(operation.getErrorCode());
            }
        }
        if (operation.isMinusCount()) {
            this.modifyUsedCount(operation, addNum);
            resultVO.setSuccess(true);
        }
        if (operation.isModifyUpgradeCount()) {
            this.modifyUsedCount(operation, addNum);
            resultVO.setSuccess(true);
        }
        logger.info((Object)("\u4ea7\u80fd\u6821\u9a8c\u65e5\u5fd7\uff0c\u6821\u9a8c\u540e\uff1a\u64cd\u4f5c\u7c7b\u578b\uff1a" + operation.getName() + " total:" + this.getTotalCount() + " used:" + BizChicken4.getUsedNum() + " \u662f\u5426\u9884\u6821\u9a8c\uff1a" + isNotPre));
        return resultVO;
    }

    public synchronized void modifyUsedCount(BizOperationEnum4 operation, int addNum) {
        for (int i = 1; i <= addNum; ++i) {
            BizChicken4.modifyUsedCount((BizOperationEnum4)operation);
        }
    }

    public int getTotalCount() {
        return BizChicken4.getTotalNum();
    }
}

