/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.validity.util;

import com.seeyon.apps.mplus.api.MplusExtApi;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;

public class CertificateUtils {
    private static final Log LOGGER = CtpLogFactory.getLog(CertificateUtils.class);
    private static MplusExtApi mplusExtApi = (MplusExtApi)AppContext.getBean((String)"mplusExtApi");
    private static final String KEY_STORE = "JKS";
    private static final String X509 = "X.509";
    private static final int CACHE_SIZE = 2048;
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 256;
    private static final String CHARSET_NAME = "UTF-8";

    public static PrivateKey getPrivateKey(String keyStorePath, String alias, String password) throws Exception {
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        if (keyStore == null) {
            throw new BusinessException("can't find private key!");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String keyStorePath, String password) {
        FileInputStream in = null;
        KeyStore keyStore = null;
        try {
            in = new FileInputStream(keyStorePath);
            keyStore = KeyStore.getInstance(KEY_STORE);
            keyStore.load(in, password.toCharArray());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return keyStore;
    }

    private static PublicKey getPublicKey(String certificatePath) throws CertificateException {
        Certificate certificate = CertificateUtils.getCertificate(certificatePath);
        if (null == certificate) {
            throw new CertificateException("can't find the public key!");
        }
        PublicKey publicKey = certificate.getPublicKey();
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCertificate(String certificatePath) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509);
        FileInputStream in = null;
        Certificate certificate = null;
        try {
            in = new FileInputStream(certificatePath);
            certificate = certificateFactory.generateCertificate(in);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return certificate;
    }

    public static Certificate getCertificate(String keyStorePath, String alias, String password) throws KeyStoreException {
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        if (null == keyStore) {
            throw new KeyStoreException("\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff01");
        }
        Certificate certificate = keyStore.getCertificate(alias);
        return certificate;
    }

    public static byte[] encryptByPrivateKey(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStorePath, alias, password);
        return CertificateUtils.encryptByPrivateKey(data, privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        int inputLen = data.length;
        ByteArrayOutputStream out = null;
        byte[] encryptedData = null;
        try {
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            encryptedData = out.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
        return encryptedData;
    }

    public static byte[] encryptFileByPrivateKey(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] data = CertificateUtils.fileToByte(filePath);
        return CertificateUtils.encryptByPrivateKey(data, keyStorePath, alias, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptFileByPrivateKey(String srcFilePath, String destFilePath, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStorePath, alias, password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        File srcFile = new File(srcFilePath);
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            File destFile = new File(destFilePath);
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            destFile.createNewFile();
            out = new FileOutputStream(destFile);
            byte[] data = new byte[117];
            while (in.read(data) != -1) {
                byte[] encryptedData = cipher.doFinal(data);
                out.write(encryptedData, 0, encryptedData.length);
                out.flush();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != in) {
                in.close();
            }
        }
    }

    public static String encryptFileToBase64ByPrivateKey(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] encryptedData = CertificateUtils.encryptFileByPrivateKey(filePath, keyStorePath, alias, password);
        return new String(com.seeyon.ctp.util.Base64.encode((byte[])encryptedData), CHARSET_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decryptByPrivateKey(byte[] encryptedData, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStorePath, alias, password);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = null;
        byte[] decryptedData = null;
        try {
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(encryptedData, offSet, 256) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 256;
            }
            decryptedData = out.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
        return decryptedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptByPublicKey(byte[] data, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtils.getPublicKey(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(1, publicKey);
        int inputLen = data.length;
        ByteArrayOutputStream out = null;
        byte[] encryptedData = null;
        try {
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            encryptedData = out.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
        return encryptedData;
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtils.getPublicKey(certificatePath);
        return CertificateUtils.decryptByPublicKey(encryptedData, publicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decryptByPublicKey(byte[] encryptedData, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, publicKey);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = null;
        byte[] decryptedData = null;
        try {
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(encryptedData, offSet, 256) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 256;
            }
            decryptedData = out.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
        return decryptedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptFileByPublicKey(String srcFilePath, String destFilePath, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtils.getPublicKey(certificatePath);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, publicKey);
        File srcFile = new File(srcFilePath);
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            File destFile = new File(destFilePath);
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            destFile.createNewFile();
            out = new FileOutputStream(destFile);
            byte[] data = new byte[256];
            while (in.read(data) != -1) {
                byte[] decryptedData = cipher.doFinal(data);
                out.write(decryptedData, 0, decryptedData.length);
                out.flush();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != in) {
                in.close();
            }
        }
    }

    public static byte[] sign(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(keyStorePath, alias, password);
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        if (null == keyStore) {
            throw new BusinessException("\u751f\u6210\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        return CertificateUtils.sign(data, x509Certificate, privateKey);
    }

    public static byte[] sign(byte[] data, X509Certificate x509Certificate, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initSign(privateKey);
        signature.update(data);
        return signature.sign();
    }

    public static String signToBase64(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        return new String(com.seeyon.ctp.util.Base64.encode((byte[])CertificateUtils.sign(data, keyStorePath, alias, password)), CHARSET_NAME);
    }

    public static String signFileToBase64WithEncrypt(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] encryptedData = CertificateUtils.encryptFileByPrivateKey(filePath, keyStorePath, alias, password);
        return CertificateUtils.signToBase64(encryptedData, keyStorePath, alias, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static byte[] signFile(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] sign = new byte[]{};
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(keyStorePath, alias, password);
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        if (null == keyStore) {
            throw new BusinessException("\u751f\u6210\u6587\u4ef6\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initSign(privateKey);
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = null;
            AbstractInterruptibleChannel fileChannel = null;
            try {
                in = new FileInputStream(file);
                fileChannel = in.getChannel();
                MappedByteBuffer byteBuffer = ((FileChannel)fileChannel).map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                signature.update(byteBuffer);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != fileChannel) {
                    fileChannel.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            sign = signature.sign();
        }
        return sign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateFileSign(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] sign = new byte[]{};
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(keyStorePath, alias, password);
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        if (null == keyStore) {
            throw new BusinessException("\u751f\u6210\u6587\u4ef6\u6570\u5b57\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initSign(privateKey);
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                byte[] cache = new byte[2048];
                int nRead = 0;
                while ((nRead = in.read(cache)) != -1) {
                    signature.update(cache, 0, nRead);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != in) {
                    in.close();
                }
            }
            sign = signature.sign();
        }
        return sign;
    }

    public static String signFileToBase64(String filePath, String keyStorePath, String alias, String password) throws Exception {
        return new String(com.seeyon.ctp.util.Base64.encode((byte[])CertificateUtils.generateFileSign(filePath, keyStorePath, alias, password)), CHARSET_NAME);
    }

    public static boolean verifySign(byte[] data, String sign, String certificatePath) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(certificatePath);
        if (null == x509Certificate) {
            throw new BusinessException("\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(com.seeyon.ctp.util.Base64.decode((String)sign));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean verifyFileSign(String filePath, String sign, String certificatePath) throws Exception {
        boolean result = false;
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(certificatePath);
        if (null == x509Certificate) {
            throw new BusinessException("\u9a8c\u8bc1\u6587\u4ef6\u5b8c\u6574\u6027\u5f02\u5e38\uff01");
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        File file = new File(filePath);
        if (file.exists()) {
            byte[] decodedSign = com.seeyon.ctp.util.Base64.decode((String)sign);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                FileChannel fileChannel = in.getChannel();
                MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                signature.update(byteBuffer);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != in) {
                    in.close();
                }
            }
            result = signature.verify(decodedSign);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateFileSign(String filePath, String sign, String certificatePath) throws Exception {
        boolean result = false;
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(certificatePath);
        if (null == x509Certificate) {
            throw new BusinessException("\u9a8c\u8bc1\u6587\u4ef6\u5b8c\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        File file = new File(filePath);
        if (file.exists()) {
            byte[] decodedSign = com.seeyon.ctp.util.Base64.decode((String)sign);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                byte[] cache = new byte[2048];
                int nRead = 0;
                while ((nRead = in.read(cache)) != -1) {
                    signature.update(cache, 0, nRead);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != in) {
                    in.close();
                }
            }
            result = signature.verify(decodedSign);
        }
        return result;
    }

    public static boolean verifyBase64Sign(String base64String, String sign, String certificatePath) throws Exception {
        byte[] data = com.seeyon.ctp.util.Base64.decode((String)base64String);
        return CertificateUtils.verifySign(data, sign, certificatePath);
    }

    public static boolean verifyBase64SignWithDecrypt(String base64String, String sign, String certificatePath) throws Exception {
        byte[] encryptedData = com.seeyon.ctp.util.Base64.decode((String)base64String);
        byte[] data = CertificateUtils.decryptByPublicKey(encryptedData, certificatePath);
        return CertificateUtils.verifySign(data, sign, certificatePath);
    }

    public static boolean verifyFileSignWithDecrypt(String encryptedFilePath, String sign, String certificatePath) throws Exception {
        byte[] encryptedData = CertificateUtils.fileToByte(encryptedFilePath);
        byte[] data = CertificateUtils.decryptByPublicKey(encryptedData, certificatePath);
        return CertificateUtils.verifySign(data, sign, certificatePath);
    }

    public static boolean verifyCertificate(Certificate certificate) {
        return CertificateUtils.verifyCertificate(new Date(), certificate);
    }

    public static boolean verifyCertificate(Date date, Certificate certificate) {
        boolean isValid = true;
        try {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            x509Certificate.checkValidity(date);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            isValid = false;
        }
        return isValid;
    }

    public static boolean verifyCertificate(Date date, String certificatePath) {
        try {
            Certificate certificate = CertificateUtils.getCertificate(certificatePath);
            return CertificateUtils.verifyCertificate(certificate);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean verifyCertificate(Date date, String keyStorePath, String alias, String password) {
        try {
            Certificate certificate = CertificateUtils.getCertificate(keyStorePath, alias, password);
            return CertificateUtils.verifyCertificate(certificate);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean verifyCertificate(String keyStorePath, String alias, String password) {
        return CertificateUtils.verifyCertificate(new Date(), keyStorePath, alias, password);
    }

    public static boolean verifyCertificate(String certificatePath) {
        return CertificateUtils.verifyCertificate(new Date(), certificatePath);
    }

    public static boolean verifyCertificate(X509Certificate parentCert, X509Certificate childCert) {
        boolean valid = false;
        try {
            PublicKey parentCertPublicKey = parentCert.getPublicKey();
            childCert.verify(parentCertPublicKey);
            valid = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u51fa\u9519\uff0c\u8be5\u8bc1\u4e66\u4e0d\u5c5e\u4e8e\u6b64ROOT\u7b7e\u53d1.");
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyCertificate(String parentCertificatePath, String childCertificatePath) throws Exception {
        boolean valid = false;
        CertificateFactory cf = CertificateFactory.getInstance(X509);
        FileInputStream parent = new FileInputStream(new File(parentCertificatePath));
        Certificate parentCert = cf.generateCertificate(parent);
        PublicKey parentCertPublicKey = parentCert.getPublicKey();
        FileInputStream child = null;
        try {
            child = new FileInputStream(new File(childCertificatePath));
            Certificate childCert = cf.generateCertificate(child);
            childCert.verify(parentCertPublicKey);
            valid = true;
        }
        catch (SignatureException e) {
            LOGGER.error((Object)"\u8be5\u8bc1\u4e66\u4e0d\u5c5e\u4e8e \u6b64ROOT\u7b7e\u53d1.");
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != child) {
                child.close();
            }
            parent.close();
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToByte(String filePath) throws Exception {
        byte[] data = new byte[]{};
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = null;
            ByteArrayOutputStream out = null;
            try {
                in = new FileInputStream(file);
                out = new ByteArrayOutputStream(2048);
                byte[] cache = new byte[2048];
                int nRead = 0;
                while ((nRead = in.read(cache)) != -1) {
                    out.write(cache, 0, nRead);
                    out.flush();
                }
                data = out.toByteArray();
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byteArrayToFile(byte[] bytes, String filePath) throws Exception {
        ByteArrayInputStream in = null;
        File destFile = new File(filePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        destFile.createNewFile();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destFile);
            in = new ByteArrayInputStream(bytes);
            byte[] cache = new byte[2048];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                ((OutputStream)out).write(cache, 0, nRead);
                out.flush();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != out) {
                ((OutputStream)out).close();
            }
            if (null != in) {
                ((InputStream)in).close();
            }
        }
    }

    public static X509Certificate findParentCert(List<X509Certificate> parents, X509Certificate child) {
        X500Principal subjectOfChild;
        int size;
        int n = size = null == parents ? 0 : parents.size();
        if (0 == size || null == child) {
            return null;
        }
        X500Principal issuerOfChild = child.getIssuerX500Principal();
        if (issuerOfChild.equals(subjectOfChild = child.getSubjectX500Principal())) {
            return null;
        }
        for (X509Certificate parent : parents) {
            if (!issuerOfChild.equals(parent.getSubjectX500Principal())) continue;
            return parent;
        }
        return null;
    }

    public static List<X509Certificate> orderFromSpecialCert(List<X509Certificate> certs, X509Certificate cert) {
        int size;
        int n = size = null == certs ? 0 : certs.size();
        if (0 == size || null == cert) {
            return null;
        }
        if (!certs.contains(cert)) {
            return null;
        }
        ArrayList<X509Certificate> certInOder = new ArrayList<X509Certificate>();
        X509Certificate currentCert = cert;
        for (int index = 0; index < size; ++index) {
            certInOder.add(currentCert);
            X509Certificate parent = CertificateUtils.findParentCert(certs, currentCert);
            if (parent == null) break;
            currentCert = parent;
        }
        return certInOder;
    }

    public static X509Certificate getCert(String certPath) throws FileNotFoundException {
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance(X509);
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new FileInputStream(certPath));
            return cert;
        }
        catch (CertificateException e) {
            LOGGER.info((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean verifySign(byte[] data, byte[] sign, X509Certificate x509Certificate) throws Exception {
        if (null == x509Certificate) {
            throw new BusinessException("\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38\uff01");
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(sign);
    }

    public static void writeCertKeyToFile(X509Certificate key, String filePath) throws IOException {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(filePath));
            outputStream.writeObject(key);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static X509Certificate readCertKeyFromFile(String filePath) throws IOException, ClassNotFoundException {
        X509Certificate key = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(filePath));
            key = (X509Certificate)objectInputStream.readObject();
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        return key;
    }

    public static Object[] getToken(String corpid, String pkgid) throws BusinessException {
        String separator = "##";
        String planToken = corpid + separator + pkgid;
        byte[] tokenBytes = new byte[]{};
        Object[] result = new Object[2];
        try {
            tokenBytes = planToken.getBytes("utf-8");
            Object[] signTokenBytes = mplusExtApi.signMessage(tokenBytes);
            String signTokenBase64 = new String(Base64.encodeBase64((byte[])((byte[])signTokenBytes[0])));
            result[0] = signTokenBase64;
            byte[] pkBytes = (byte[])signTokenBytes[2];
            result[1] = pkBytes;
            return result;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        catch (BusinessException e) {
            LOGGER.info((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.info((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean vertifySigntime(long certid, int certtype, String certSn, long signtime, List<String> cerInfoList) {
        int listSize;
        int n = listSize = null == cerInfoList ? 0 : cerInfoList.size();
        if (0 == listSize) {
            return true;
        }
        LinkedList<Map> certMapList = new LinkedList<Map>();
        for (int i = 0; i < listSize; ++i) {
            String cerInfo = cerInfoList.get(i);
            String[] splits = cerInfo.split("-");
            if (splits == null || splits.length <= 5) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", splits[0]);
            map.put("type", splits[1]);
            map.put("serial", splits[2]);
            map.put("start", splits[3]);
            map.put("end", splits[4]);
            certMapList.add(map);
        }
        return CertificateUtils.vertifySigntimeByMapElement(certid, certtype, certSn, signtime, certMapList);
    }

    private static boolean vertifySigntimeByMapElement(long certid, int certtype, String certsn, long signtime, List<Map> cerInfoList) {
        int listSize;
        int n = listSize = null == cerInfoList ? 0 : cerInfoList.size();
        if (0 == listSize) {
            return true;
        }
        List<Map> twoList = CertificateUtils.lookfor2cert(certid, certtype, certsn, cerInfoList);
        int nSize = twoList.size();
        if (0 == nSize) {
            return false;
        }
        for (int i = 0; i < twoList.size(); ++i) {
            long endTime;
            Map cert = twoList.get(i);
            String strStart = (String)cert.get("start");
            String strEnd = (String)cert.get("end");
            long startTime = Long.parseLong(strStart);
            if (CertificateUtils.isTimeInSpan(signtime, startTime, endTime = Long.parseLong(strEnd))) continue;
            return false;
        }
        return true;
    }

    private static List<Map> lookfor2cert(long certid, int certtype, String certSn, List<Map> cerInfoList) {
        int listSize;
        LinkedList<Map> certList = new LinkedList<Map>();
        long certStartDate = 0L;
        int n = listSize = null == cerInfoList ? 0 : cerInfoList.size();
        if (0 == listSize) {
            return null;
        }
        for (int i = 0; i < listSize; ++i) {
            Map cert = cerInfoList.get(i);
            String strId = (String)cert.get("id");
            String strType = (String)cert.get("type");
            String curSn = (String)cert.get("serial");
            long curId = Long.parseLong(strId);
            int curType = Integer.parseInt(strType);
            long curCertStartDate = Long.parseLong((String)cert.get("start"));
            if (certList.size() == 0) {
                if (certid != curId || certtype != curType || !curSn.equals(certSn)) continue;
                certStartDate = curCertStartDate;
                certList.add(cert);
                continue;
            }
            if (certtype != curType || certStartDate != curCertStartDate || !curSn.equals(certSn)) continue;
            certList.add(cert);
            break;
        }
        return certList;
    }

    private static boolean isTimeInSpan(long time, long start, long end) {
        return time >= start && time <= end;
    }

    public static String getYlHash(List<String> cerInfoList) {
        int listSize;
        int n = listSize = null == cerInfoList ? 0 : cerInfoList.size();
        if (0 == listSize) {
            return "";
        }
        String ylSerial = "FFFFFFFF";
        for (int i = 0; i < listSize; ++i) {
            String cerInfo = cerInfoList.get(i);
            String[] splits = cerInfo.split("[-]");
            if (splits == null || splits.length <= 5) continue;
            String serial = splits[2];
            String hash = splits[5];
            if (!serial.equals(ylSerial)) continue;
            return hash;
        }
        return "";
    }
}

