/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.cap.api.manager;

import com.seeyon.apps.collaboration.enums.ColHandleType;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.cap4.form.api.FormApi4Cap4;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormCheckRuleBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FormDataStateResultVO;
import com.seeyon.cap4.task.TaskExecuteManager;
import com.seeyon.cap4.template.bean.ScreenCapture4FormParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.service.CAPFormDataForwardService;
import com.seeyon.cap4.template.service.CAPFormDataService;
import com.seeyon.cap4.template.service.CAPScreenCaptureService;
import com.seeyon.cap4.template.service.ServiceProxy;
import com.seeyon.ctp.cap.api.bean.CAPFormBean;
import com.seeyon.ctp.cap.api.constant.CAPFormEnum;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.batch.bo.BatchCheckResult;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.content.comment.Comment;
import com.seeyon.ctp.common.content.mainbody.CtpContentAllBean;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.content.mainbody.MainbodyType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.DataContainer;
import com.seeyon.ctp.common.po.affair.CtpAffair;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.lock.Lock;
import com.seeyon.ctp.form.api.FormApi4Cap3;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.form.bean.FormFormulaBean;
import com.seeyon.ctp.form.modules.engin.base.formData.FormDataManager;
import com.seeyon.ctp.form.modules.engin.formula.FormulaEnums;
import com.seeyon.ctp.form.modules.engin.formula.validate.Stack;
import com.seeyon.ctp.form.modules.engin.relation.FormRelationManager;
import com.seeyon.ctp.form.po.CtpTemplateRelationAuth;
import com.seeyon.ctp.form.service.FormCache;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.service.FormManager;
import com.seeyon.ctp.form.service.FormService;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.form.util.FormUtil;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.JMCallingObj;
import com.seeyon.ctp.monitor.performance.FormRunTypeEnum;
import com.seeyon.ctp.monitor.performance.JMMonitorService;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class CAPFormManagerImpl
implements CAPFormManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormManagerImpl.class);
    private FormManager formManager;
    private CAP4FormManager cap4FormManager;
    private FormCacheManager formCacheManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormRelationManager formRelationManager;
    private FormDataManager formDataManager;
    private MainbodyManager ctpMainbodyManager;
    private TaskExecuteManager taskExecuteManager;
    private CAP4FormRelationActionManager cap4FormRelationActionManager;
    private CAPFormDataService capFormDataService;
    private CAPFormDataForwardService capFormDataForwardService;
    private CAPScreenCaptureService capScreenCaptureService;
    private String rightIdSet = "myRightSetName";
    private JMMonitorService jmMonitorService;
    private FormApi4Cap3 formApi4Cap3;
    private FormApi4Cap4 formApi4Cap4;

    public void setFormApi4Cap3(FormApi4Cap3 formApi4Cap3) {
        this.formApi4Cap3 = formApi4Cap3;
    }

    public void setFormApi4Cap4(FormApi4Cap4 formApi4Cap4) {
        this.formApi4Cap4 = formApi4Cap4;
    }

    public boolean checkRightId(Long rightId) {
        boolean result = false;
        Object o = AppContext.getSessionContext((String)this.rightIdSet);
        if (null == o) {
            result = false;
        } else {
            HashSet rightSet = (HashSet)o;
            result = rightSet.contains(rightId);
        }
        if (!result) {
            LOGGER.error((Object)(AppContext.getCurrentUser().getName() + " \u8bbf\u95ee\u8868\u5355\u53ef\u80fd\u5b58\u5728\u8d8a\u6743\uff0crightId" + rightId));
        }
        return result;
    }

    private List<Long> getRightId(String rightIdStr) {
        ArrayList<Long> result = null;
        if (!StringUtil.checkNull((String)rightIdStr)) {
            result = new ArrayList<Long>();
            if ((rightIdStr = rightIdStr.replace("|", "_")).contains("_")) {
                String[] auths;
                for (String tempStr : auths = rightIdStr.split("[_]")) {
                    if (StringUtil.checkNull((String)tempStr)) continue;
                    if (tempStr.contains(".")) {
                        result.add(Long.parseLong(tempStr.split("[.]")[1]));
                        continue;
                    }
                    result.add(Long.parseLong(tempStr));
                }
            } else if (rightIdStr.contains(".")) {
                result.add(Long.parseLong(rightIdStr.split("[.]")[1]));
            } else {
                result.add(Long.parseLong(rightIdStr));
            }
        }
        return result;
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={BusinessException.class})
    public void addRight(String rightIdStr) {
        List<Long> rightIds = this.getRightId(rightIdStr);
        if (null != rightIds && rightIds.size() > 0) {
            for (Long rightId : rightIds) {
                this.addRightId(rightId);
            }
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={BusinessException.class})
    public void addRightId(Long rightId) {
        Object o = AppContext.getSessionContext((String)this.rightIdSet);
        HashSet<Long> rightSet = null;
        rightSet = null == o ? new HashSet<Long>() : (HashSet<Long>)o;
        rightSet.add(rightId);
        AppContext.putSessionContext((String)this.rightIdSet, rightSet);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={BusinessException.class})
    public void addRightId(Long formId, Long rightId) {
        if (this.isCAP4Form(formId)) {
            this.formApi4Cap4.addRightId(formId, rightId);
        } else {
            this.formApi4Cap3.addRightId(formId, rightId);
        }
    }

    public void addRightId(Long formId, String rightId) {
        List<Long> rights = this.getRightId(rightId);
        if (null != formId && null != rights && rights.size() > 0) {
            if (this.isCAP4Form(formId)) {
                for (Long right : rights) {
                    this.formApi4Cap4.addRightId(formId, right);
                }
            } else {
                for (Long right : rights) {
                    this.formApi4Cap3.addRightId(formId, right);
                }
            }
        } else {
            LOGGER.error((Object)("\u6821\u9a8c\u6743\u9650\u6ca1\u6709\u4f20\u5165\u8868\u5355id\uff0c\u53ea\u4f20\u4e86\u6743\u9650id\uff1a" + rightId));
            this.addRight(rightId);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={BusinessException.class})
    public void addRightId(List<Long> rightIds) {
        if (null != rightIds) {
            for (Long rightId : rightIds) {
                this.addRightId(rightId);
            }
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={BusinessException.class})
    public void addRightId(Long[] rightIds) {
        if (null != rightIds) {
            for (Long rightId : rightIds) {
                this.addRightId(rightId);
            }
        }
    }

    public void removeRightId(Long rightId) {
        Object o = AppContext.getSessionContext((String)this.rightIdSet);
        if (null != o) {
            Set rightSet = (Set)o;
            rightSet.remove(rightId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReadOnlyAuth(Long formId, Long rightId) throws BusinessException {
        boolean isReadOnly = false;
        if (null == formId) return isReadOnly;
        if (null == rightId) {
            return isReadOnly;
        }
        com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormCacheManager.getForm(formId);
        if (cap4FormBean != null) {
            FormAuthViewBean authViewBean = cap4FormBean.getAuthViewBeanById(rightId);
            if (null != authViewBean) {
                return Enums.FormAuthorizationType.show.getKey().equals(authViewBean.getType());
            }
            String errorInfo = "form:" + formId + "can't find rightid\uff1a" + rightId;
            LOGGER.error((Object)errorInfo);
            throw new BusinessException(errorInfo);
        }
        FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
        if (null != cap3FormBean) {
            com.seeyon.ctp.form.bean.FormAuthViewBean authViewBean = cap3FormBean.getAuthViewBeanById(rightId);
            if (null != authViewBean) {
                return Enums.FormAuthorizationType.show.getKey().equals(authViewBean.getType());
            }
            String errorInfo = "form :" + formId + "can't find right\uff1a" + rightId;
            LOGGER.error((Object)errorInfo);
            throw new BusinessException(errorInfo);
        }
        String errorInfo = "can't find form\uff1a" + formId;
        LOGGER.error((Object)errorInfo);
        throw new BusinessException(errorInfo);
    }

    public CAPFormBean getForm(Long formId) {
        com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormCacheManager.getForm(formId);
        if (cap4FormBean != null) {
            return new CAPFormBean((Object)cap4FormBean);
        }
        FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
        if (cap3FormBean != null) {
            return new CAPFormBean((Object)cap3FormBean);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Map> getEndedFieldValByModifyDate(Long formId, String fieldName, Date beginTime, Date endTime, FlipInfo flipInfo) throws BusinessException {
        CAPFormBean formBean = this.getForm(formId);
        JDBCAgent jdbc = new JDBCAgent();
        try {
            String begin = this.getSqlForDifferentDataBase(jdbc, beginTime);
            String end = this.getSqlForDifferentDataBase(jdbc, endTime);
            String sql = "";
            if (formBean.getFormVersion() == CAPFormEnum.FormVersion.FOUR) {
                com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormCacheManager.getForm(formId);
                com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = cap4FormBean.getFieldBeanByName(fieldName);
                if (formFieldBean.isMasterField()) {
                    if (!formFieldBean.isOrg()) throw new BusinessException(fieldName + "\u4e0d\u662f\u7ec4\u7ec7\u673a\u6784\u63a7\u4ef6!");
                    sql = "select " + fieldName + " from " + formFieldBean.getOwnerTableName() + " where modify_date between " + begin + " and " + end;
                } else {
                    String masterTableName = cap4FormBean.getMasterTableBean().getTableName();
                    String formsonName = formFieldBean.getOwnerTableName();
                    if (formFieldBean.isOrg()) {
                        sql = "select distinct " + fieldName + " from " + formsonName + "," + masterTableName + " where " + masterTableName + ".modify_date between " + begin + " and " + end;
                    }
                }
            } else {
                FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
                FormFieldBean capFormField = cap3FormBean.getFieldBeanByName(fieldName);
                String fieldInputType = capFormField.getInputType();
                if (capFormField.isMasterField()) {
                    if (!this.isOrganizationField(fieldInputType)) throw new BusinessException(fieldName + "\u4e0d\u662f\u7ec4\u7ec7\u673a\u6784\u63a7\u4ef6!");
                    sql = "select " + fieldName + " from " + capFormField.getOwnerTableName() + " where modify_date between " + begin + " and " + end;
                } else {
                    String masterTableName = cap3FormBean.getMasterTableBean().getTableName();
                    String formsonName = capFormField.getOwnerTableName();
                    if (!this.isOrganizationField(fieldInputType)) throw new BusinessException(fieldName + "\u4e0d\u662f\u7ec4\u7ec7\u673a\u6784\u63a7\u4ef6!");
                    sql = "select distinct " + fieldName + " from " + formsonName + "," + masterTableName + " where " + masterTableName + ".modify_date between " + begin + " and " + end;
                }
            }
            jdbc.findByPaging(sql.toString(), new ArrayList(), flipInfo);
            return flipInfo.getData();
        }
        catch (Exception e) {
            LOGGER.info((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            jdbc.close();
        }
    }

    private String getSqlForDifferentDataBase(JDBCAgent jdbc, Date time) {
        String formatTime = Datetimes.format((Date)time, (String)"yyyy-MM-dd HH:mm:ss");
        String sql = "";
        sql = ReportDBUtils.isOracleRuntime() || ReportDBUtils.isPostgreSQLRuntime() ? "to_char('" + formatTime + "','yyyy-mm-dd hh24:mi')" : (ReportDBUtils.isSQLServerRuntime() ? "convert(nvarchar(255), '" + formatTime + "',120)" : "DATE_FORMAT('" + formatTime + "','%Y-%m-%d %H:%i:%s')");
        return sql;
    }

    private boolean isOrganizationField(String fieldInputType) {
        return FormFieldComEnum.EXTEND_MEMBER.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_POST.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_MULTI_POST.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_LEVEL.getKey().equals(fieldInputType) || FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey().equals(fieldInputType);
    }

    public List<CAPFormBean> getMyOwnForms(Set<Integer> typeKeys) {
        ArrayList<CAPFormBean> fbList = new ArrayList<CAPFormBean>();
        ArrayList allCap3Forms = new ArrayList(this.formCacheManager.getForms().values());
        HashSet<Integer> s = new HashSet<Integer>(typeKeys);
        long userId = AppContext.currentUserId();
        for (FormBean fb : allCap3Forms) {
            if (fb.getState() == Enums.FormStateEnum.inactive.getKey() || fb.getState() == Enums.FormStateEnum.partialactivation.getKey()) continue;
            Enums.FormType ft = Enums.FormType.getEnumByKey((int)fb.getFormType());
            if (fb.getOwnerId() != userId || !s.contains(ft.getKey())) continue;
            fbList.add(new CAPFormBean((Object)fb));
        }
        ArrayList allCap4Forms = new ArrayList(this.cap4FormCacheManager.getForms().values());
        for (com.seeyon.cap4.form.bean.FormBean fb : allCap4Forms) {
            Enums.FormType ft = Enums.FormType.getEnumByKey((int)fb.getFormType());
            if (fb.getOwnerId() != userId || !s.contains(ft.getKey())) continue;
            fbList.add(new CAPFormBean((Object)fb));
        }
        return fbList;
    }

    public boolean isEnabled(Long formId) {
        com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormManager.getEditingForm(false, formId);
        if (null == cap4FormBean) {
            cap4FormBean = this.cap4FormCacheManager.getForm(formId);
        }
        if (cap4FormBean != null) {
            return cap4FormBean.isEnabled();
        }
        FormBean cap3FormBean = this.formManager.getEditingForm(false);
        if (null == cap3FormBean) {
            cap3FormBean = this.formCacheManager.getForm(formId.longValue());
        }
        if (cap3FormBean != null) {
            return cap3FormBean.isEnabled();
        }
        return false;
    }

    public Object getMasterFieldValue(Long formId, Long masterId, String fieldName, boolean isShowValue) throws BusinessException, SQLException {
        return this.getMasterFieldValue(formId, masterId, fieldName, isShowValue, false);
    }

    public Object getMasterFieldValue(Long formId, Long masterId, String fieldName, boolean isShowValue, boolean isOrgFormulaValue) throws BusinessException, SQLException {
        if (formId != null) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                return this.cap4FormManager.getMasterFieldValue(formId, masterId, fieldName, isShowValue, isOrgFormulaValue);
            }
            if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
                return this.formManager.getMasterFieldValue(formId, masterId, fieldName, isShowValue, isOrgFormulaValue);
            }
        }
        LOGGER.error((Object)("getMasterFieldValue getForm by formId is not found , formId is " + formId));
        return null;
    }

    public String getCollSubjuet(Long formId, String collSubject, Long formRecordid, boolean isForward) throws BusinessException {
        if (formId != null) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                return this.cap4FormManager.getCollSubjuet(formId, collSubject, formRecordid, isForward);
            }
            if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
                return this.formManager.getCollSubjuet(formId, collSubject, formRecordid, isForward);
            }
        } else {
            return this.replaceSysVar4CollSubject(collSubject);
        }
        LOGGER.error((Object)("getCollSubjuet getForm by formId is not found , formId is " + formId));
        return null;
    }

    private String replaceSysVar4CollSubject(String msg) {
        LOGGER.info((Object)("\u5f00\u59cb\u6267\u884c\u5b57\u7b26\u4e32\u8868\u5355\u6570\u636e\u66ff\u6362\uff1a\u5bf9\u8c61->" + msg + " \u5f53\u524d\u767b\u5f55\u8bed\u8a00 " + AppContext.getLocale()));
        String subject = msg;
        char[] msgCharArr = msg.toCharArray();
        Stack bigBracketStack = new Stack();
        Stack squareBracketStack = new Stack();
        HashSet<String> needReplaceStrList = new HashSet<String>();
        block6: for (int i = 0; i < msgCharArr.length; ++i) {
            char ch = msgCharArr[i];
            switch (ch) {
                case '[': {
                    bigBracketStack.push((Object)i);
                    continue block6;
                }
                case ']': {
                    String temp = msg.substring((Integer)bigBracketStack.pop(), i + 1);
                    needReplaceStrList.add(temp);
                    continue block6;
                }
                case '{': {
                    squareBracketStack.push((Object)i);
                    continue block6;
                }
                case '}': {
                    String temp = msg.substring((Integer)squareBracketStack.pop(), i + 1);
                    needReplaceStrList.add(temp);
                }
            }
        }
        String value = null;
        boolean needReplace = false;
        for (String key : needReplaceStrList) {
            String tempKey = key.substring(1, key.length() - 1);
            if (tempKey.contains("System")) {
                String realKey = key.substring(key.indexOf(".") + 1);
                FormulaEnums.FormulaVar var = FormulaEnums.FormulaVar.getEnumByText((String)realKey);
                if (var != null) {
                    needReplace = true;
                    value = var.getValue();
                }
            } else {
                FormulaEnums.FormulaVar var = FormulaEnums.FormulaVar.getEnumByText((String)tempKey);
                if (var != null) {
                    needReplace = true;
                    String obj = var.getValue();
                    value = obj == null ? "" : obj.toString();
                }
            }
            if (!needReplace) continue;
            if (StringUtil.checkNull(value)) {
                value = "";
            }
            subject = subject.replace(key, value);
        }
        LOGGER.info((Object)("\u7ed3\u675f\u6267\u884c\u5b57\u7b26\u4e32\u8868\u5355\u6570\u636e\u66ff\u6362\uff1a\u7ed3\u679c-> " + subject));
        return subject;
    }

    public List<Attachment> getAllFormAttsByModuleId(Long moduleId, Long formId, Long recordId) {
        if (StringUtil.checkNull((String)String.valueOf(formId))) {
            return null;
        }
        if (this.isCAP4Form(formId)) {
            return this.cap4FormManager.getAllFormAttsByModuleId(moduleId, formId, recordId);
        }
        return FormService.getAllFormAttsByModuleId((Long)moduleId);
    }

    public void procDefaultValue(Long formId, Long dataId, Long authId, Long moduleId, Object formData) throws SQLException, BusinessException {
        if (formId == null) {
            return;
        }
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
            this.cap4FormManager.procDefaultValue(formId, dataId, authId, moduleId, formData);
        } else if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
            this.formManager.procDefaultValue(formId, dataId, authId, moduleId, formData);
        }
    }

    public void procDefaultValue(Long formId, Long dataId, String rightId, Long moduleId, Object formData) throws SQLException, BusinessException {
        String[] operations = com.seeyon.cap4.form.util.FormUtil.paraseOperationIds((String)rightId);
        boolean isMbLogin = com.seeyon.cap4.form.util.FormUtil.isPhoneLogin();
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        Long finalAuthId = 0L;
        Long firstAuthId = null;
        LOGGER.error((Object)isMbLogin);
        if (isMbLogin) {
            for (String operation : operations) {
                FormViewBean viewBean;
                Long viewId;
                FormAuthViewBean authViewBean;
                com.seeyon.cap4.form.bean.FormBean formBean;
                if (StringUtils.isEmpty((CharSequence)operation)) continue;
                Long operationId = Long.parseLong(operation);
                if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                    formBean = this.cap4FormCacheManager.getForm(formId);
                    authViewBean = formBean.getAuthViewBeanById(operationId);
                    viewId = authViewBean.getFormViewId();
                    viewBean = formBean.getFormView(viewId.longValue());
                    if (firstAuthId == null) {
                        firstAuthId = operationId;
                    }
                    if (!viewBean.isPhone() || !viewBean.hasFields()) continue;
                    finalAuthId = operationId;
                } else {
                    formBean = this.formCacheManager.getForm(formId.longValue());
                    authViewBean = formBean.getAuthViewBeanById(operationId);
                    viewId = authViewBean.getFormViewId();
                    viewBean = formBean.getFormView(viewId.longValue());
                    if (firstAuthId == null) {
                        firstAuthId = operationId;
                    }
                    if (!viewBean.isPhone()) continue;
                    finalAuthId = operationId;
                }
                break;
            }
        } else {
            for (String operation : operations) {
                FormViewBean viewBean;
                FormAuthViewBean authViewBean;
                Long viewId;
                com.seeyon.cap4.form.bean.FormBean formBean;
                if (StringUtils.isEmpty((CharSequence)operation)) continue;
                Long operationId = Long.parseLong(operation);
                if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                    formBean = this.cap4FormCacheManager.getForm(formId);
                    viewBean = formBean.getFormView((viewId = Long.valueOf((authViewBean = formBean.getAuthViewBeanById(operationId)).getFormViewId())).longValue());
                    if (!viewBean.isPc()) continue;
                    finalAuthId = operationId;
                } else {
                    formBean = this.formCacheManager.getForm(formId.longValue());
                    viewBean = formBean.getFormView((viewId = Long.valueOf((authViewBean = formBean.getAuthViewBeanById(operationId)).getFormViewId())).longValue());
                    if (!viewBean.isPc()) continue;
                    finalAuthId = operationId;
                }
                break;
            }
        }
        if (isMbLogin && finalAuthId.equals(0L) && firstAuthId != null) {
            finalAuthId = firstAuthId;
        }
        if (!finalAuthId.equals(0L)) {
            LOGGER.info((Object)("\u6570\u636e" + dataId + " \u4f7f\u7528\u6743\u9650\uff1a" + finalAuthId + "\u5904\u7406\u521d\u59cb\u503c"));
            this.procDefaultValue(formId, dataId, finalAuthId, moduleId, formData);
        } else {
            LOGGER.error((Object)("\u5f53\u524d\u767b\u5f55\u72b6\u6001" + (isMbLogin ? "\u79fb\u52a8" : "PC") + "\u4e0b\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u72b6\u6001\u6743\u9650\uff0c\u8868\u5355id\uff1a" + formId + " \u6743\u9650\uff1a" + rightId));
        }
    }

    public FormDataStateResultVO updateDataState(Object colSummaryObj, CtpAffair affair, Object typeObj, List<Comment> list) throws BusinessException, SQLException {
        FormDataStateResultVO resultVo = null;
        ColSummary colSummary = (ColSummary)colSummaryObj;
        if (colSummary.getFormAppid() == null) {
            return resultVo;
        }
        ColHandleType type = (ColHandleType)typeObj;
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(colSummary.getFormAppid());
        if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
            resultVo = this.cap4FormManager.updateDataState(colSummary, affair, type, list);
        } else if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
            this.formManager.updateDataState(colSummary, affair, type, list);
        }
        return resultVo;
    }

    public void RelationAuthorityBySummaryId(Long summaryId, int key) {
        this.formRelationManager.RelationAuthorityBySummaryId(summaryId, key);
    }

    public Lock getLock(Long masterDataId) {
        return this.cap4FormManager.getLock(masterDataId);
    }

    public boolean lockFormData(Long masterDataId, Long userId, String from) {
        return this.cap4FormManager.lockFormDataWithHeartbeat(masterDataId, userId, from);
    }

    public void removeSessionMasterDataBean(Long formId, Long formMasterId) {
        this.removeSessionMasterData(formId, formMasterId);
    }

    public String removeSessionMasterData(Long formId, Long formMasterId) {
        if (formId != null) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("masterDataId", formMasterId);
            if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                this.cap4FormManager.removeSessionMasterDataBean(formMasterId);
                HashMap<String, String> result = new HashMap<String, String>(1);
                result.put("success", "true");
                return JSONUtil.toJSONString(result);
            }
            if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
                return this.formManager.removeSessionMasterData(map);
            }
        }
        LOGGER.error((Object)("\u79fb\u9664\u8868\u5355\u7f13\u5b58\u5931\u8d25\uff0c\u8868\u5355id\u4e3a" + formId + "\u6570\u636eid\uff1a" + formMasterId));
        return null;
    }

    public boolean hasRight4UserCol(Long formId, Long member, Long moduleId) throws BusinessException {
        if (formId != null) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                return this.cap4FormRelationActionManager.hasRightForRelation(member, moduleId);
            }
            if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
                boolean checkResult = this.cap4FormRelationActionManager.hasRightForRelation(member, moduleId);
                return !checkResult ? this.formRelationManager.hasRight4UserCol(member, moduleId) : checkResult;
            }
        }
        return false;
    }

    public boolean checkRight(int moduleTypeKey, long moduleId, Long userId, Long formId) throws BusinessException {
        if (formId != null) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                return this.cap4FormManager.checkRight(Enums.FormModuleAuthModuleType.getFormModuleAuthModuleTypeByKey((int)moduleTypeKey), moduleId, userId, formId);
            }
            if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
                return FormService.checkRight((Enums.FormModuleAuthModuleType)Enums.FormModuleAuthModuleType.getFormModuleAuthModuleTypeByKey((int)moduleTypeKey), (long)moduleId, (Long)userId, (Long)formId);
            }
        }
        LOGGER.error((Object)"checkRight \u83b7\u53d6\u6743\u9650\u5f02\u5e38\uff0c\u8868\u5355ID\u4e3anull");
        return false;
    }

    private String splitRightId(Long formId, String formViewOperation, boolean needPhone) {
        String rightStr;
        if (Strings.isBlank((String)formViewOperation)) {
            return null;
        }
        String[] auths = formViewOperation.split("[_]");
        if (needPhone) {
            // empty if block
        }
        if ((rightStr = auths[0]).contains(".")) {
            rightStr = rightStr.split("[.]")[1];
        }
        return rightStr;
    }

    private List<FormAuthViewBean> getCAP4FormAuthViewBeansByRightId(com.seeyon.cap4.form.bean.FormBean formBean, String rightId) {
        String[] operations;
        LinkedList<FormAuthViewBean> formAuthViewBeans = new LinkedList<FormAuthViewBean>();
        if (null == rightId || Strings.isBlank((String)rightId)) {
            return formAuthViewBeans;
        }
        for (String operation : operations = com.seeyon.cap4.form.util.FormUtil.paraseOperationIds((String)rightId)) {
            if (StringUtils.isEmpty((CharSequence)operation)) continue;
            FormAuthViewBean authViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(operation)));
            formAuthViewBeans.add(authViewBean);
        }
        return formAuthViewBeans;
    }

    private String getCAP4SplitRightId(Long formId, String formViewOperation) {
        String rightId = null;
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        List<FormAuthViewBean> formAuthViewBeans = this.getCAP4FormAuthViewBeansByRightId(formBean, formViewOperation);
        boolean isMbLogin = com.seeyon.cap4.form.util.FormUtil.isMobileLogin();
        if (isMbLogin) {
            for (FormAuthViewBean authViewBean : formAuthViewBeans) {
                Long viewId = authViewBean.getFormViewId();
                FormViewBean viewBean = formBean.getFormView(viewId.longValue());
                if (!viewBean.isPhone() || !viewBean.hasFields()) continue;
                rightId = String.valueOf(authViewBean.getId());
                break;
            }
        }
        if (StringUtil.checkNull(rightId)) {
            rightId = formAuthViewBeans.isEmpty() ? null : String.valueOf(formAuthViewBeans.get(0).getId());
        }
        return rightId;
    }

    public Set<String> getNotNullableFields(Long formId, String formViewOperation) {
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        String rightId = null;
        if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
            rightId = this.getCAP4SplitRightId(formId, formViewOperation);
        } else if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
            rightId = this.splitRightId(formId, formViewOperation, false);
        }
        if (StringUtil.checkNull((String)rightId)) {
            return null;
        }
        return this.getNotNullableFields(formId, Long.valueOf(rightId));
    }

    public boolean hasNotNullableField(Long formId, String formViewOperation) {
        if (formId != null) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                String rightIdStr = this.getCAP4SplitRightId(formId, formViewOperation);
                return formBean.hasNotNullableField(Long.valueOf(rightIdStr).longValue());
            }
            if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
                String rightIdStr = this.splitRightId(formId, formViewOperation, false);
                FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
                return cap3FormBean.hasNotNullableField(Long.valueOf(rightIdStr).longValue());
            }
        }
        return false;
    }

    public Set<String> getNotNullableFields(Long formId, Long formRightId) {
        Set<String> notNullFields = new HashSet<String>();
        if (formId != null) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                notNullFields = formBean.notNullableField(formRightId.longValue(), false);
            } else if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
                FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
                notNullFields = cap3FormBean.notNullableField(formRightId.longValue(), false);
            }
        }
        return notNullFields;
    }

    private Map<String, Object> getCheckRuleResult(boolean isPass, boolean isExsitNotStrongValidate, Object formData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isPass", String.valueOf(isPass));
        map.put("isExsitNotStrongValidate", String.valueOf(isExsitNotStrongValidate));
        map.put("formData", formData);
        return map;
    }

    public Map<String, Object> checkRule(Long moduleId, Long formId, Long masterDataId, String formViewOperation) {
        if (Strings.isBlank((String)formViewOperation)) {
            return new HashMap<String, Object>();
        }
        String rightId = "0";
        if (null != formId) {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            rightId = CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion() ? this.getCAP4SplitRightId(formId, formViewOperation) : this.splitRightId(formId, formViewOperation, false);
        }
        return this.checkRule(moduleId, formId, masterDataId, Long.valueOf(rightId));
    }

    public Map<String, Object> checkRule(Long moduleId, Long formId, Long masterDataId, Long formRightId) {
        com.seeyon.ctp.form.bean.FormDataMasterBean formData;
        boolean isExsitNotStrongValidate;
        boolean isPass;
        block14: {
            CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
            isPass = true;
            isExsitNotStrongValidate = false;
            int forceCheck = 1;
            formData = null;
            try {
                com.seeyon.ctp.form.bean.FormDataMasterBean cap3FormDataMasterBean;
                if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
                    com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                    FormCheckRuleBean checkRuleBean = formBean.getCheckRuleBean();
                    List checkRules = checkRuleBean == null ? null : checkRuleBean.getCheckRuleList();
                    int n = forceCheck = checkRuleBean == null ? 1 : checkRuleBean.getForceCheck();
                    if (Strings.isNotEmpty((Collection)checkRules) && forceCheck == 2) {
                        isExsitNotStrongValidate = true;
                    }
                    FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(formRightId);
                    FormDataMasterBean formDataMasterBean = this.cap4FormManager.getDataMasterBeanById(masterDataId, formBean, null);
                    formData = formDataMasterBean;
                    if (forceCheck == 2 || Enums.FormAuthorizationType.show.getKey().equals(formAuthViewBean.getType())) {
                        isPass = true;
                        return this.getCheckRuleResult(isPass, isExsitNotStrongValidate, formDataMasterBean);
                    }
                    String validateResult = this.cap4FormManager.validate(formId, formDataMasterBean = this.cap4FormManager.procDefaultValueAsValidate(formBean, formDataMasterBean, formAuthViewBean, moduleId));
                    if (Strings.isNotBlank((String)validateResult)) {
                        LOGGER.info((Object)("checkRule is validate false . " + validateResult));
                        isPass = false;
                    } else {
                        isPass = true;
                    }
                    break block14;
                }
                if (CAPFormEnum.FormVersion.THREE.getVersion() != formVersion.getVersion()) break block14;
                FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
                com.seeyon.ctp.form.bean.FormAuthViewBean cap3FormAuthViewBean = cap3FormBean.getAuthViewBeanById(formRightId);
                formData = cap3FormDataMasterBean = this.formManager.getDataMasterBeanById(masterDataId, cap3FormBean, null);
                boolean hasCheckRule = this.formManager.hasCheckRule(formId);
                if (hasCheckRule) {
                    Map conditionMap = cap3FormDataMasterBean.getFormulaMap("componentType_condition");
                    Map formulaMap = cap3FormBean.getCheckRuleFormula(conditionMap);
                    forceCheck = Integer.valueOf(formulaMap.get("forceCheck").toString());
                    isExsitNotStrongValidate = forceCheck == 2;
                }
                if (forceCheck == 2 || Enums.FormAuthorizationType.show.getKey().equals(cap3FormAuthViewBean.getType())) {
                    isPass = true;
                    return this.getCheckRuleResult(isPass, isExsitNotStrongValidate, cap3FormDataMasterBean);
                }
                cap3FormDataMasterBean = this.formManager.procDefaultValueAsValidate(cap3FormBean, cap3FormDataMasterBean, cap3FormAuthViewBean, moduleId);
                String validateResult = "";
                try {
                    this.formManager.validate(formId, cap3FormDataMasterBean);
                }
                catch (BusinessException e) {
                    validateResult = e.getMessage();
                }
                if (Strings.isNotBlank((String)validateResult)) {
                    LOGGER.info((Object)("checkRule is validate false . " + validateResult));
                    isPass = false;
                } else {
                    isPass = true;
                }
            }
            catch (BusinessException e) {
                isPass = false;
                LOGGER.error((Object)("api checkRule is exception . moduleId:" + moduleId + ",formId:" + formId + ",masterDataId:" + masterDataId + ",formRightId:" + formRightId), (Throwable)e);
            }
            catch (SQLException e) {
                isPass = false;
                LOGGER.error((Object)("api checkRule is sqlException . moduleId:" + moduleId + ",formId:" + formId + ",masterDataId:" + masterDataId + ",formRightId:" + formRightId), (Throwable)e);
            }
        }
        return this.getCheckRuleResult(isPass, isExsitNotStrongValidate, formData);
    }

    private CAPFormEnum.FormVersion getCAPFormVersion(Long formId) {
        if (formId != null && (this.cap4FormCacheManager.getForm(formId) != null || this.cap4FormManager.getEditingForm(false, formId) != null)) {
            return CAPFormEnum.FormVersion.FOUR;
        }
        return CAPFormEnum.FormVersion.THREE;
    }

    public boolean isCAP4Form(Long formId) {
        return CAPFormEnum.FormVersion.FOUR.equals((Object)this.getCAPFormVersion(formId));
    }

    public List<CtpTemplateRelationAuth> getCtpTemplateRelationAuths(Long templateId) throws BusinessException {
        return this.formRelationManager.getCtpTemplateRelationAuths(templateId);
    }

    public void deleteCtpTemplateRelationAuths(Long templateId) throws BusinessException {
        this.formRelationManager.deleteCtpTemplateRelationAuths(templateId);
    }

    public void saveCtpTemplateRelationAuths(List<CtpTemplateRelationAuth> list) throws BusinessException {
        this.formRelationManager.saveCtpTemplateRelationAuths(list);
    }

    public FormBean getEditingForm() {
        return this.formManager.getEditingForm(false);
    }

    public FormBean addEditForm(FormBean bean) throws CloneNotSupportedException {
        return this.formManager.addEditForm(bean);
    }

    public void deleteContentAndFormData(ModuleType moduleType, Long moduleId, boolean deleteFormData) throws BusinessException {
        JMCallingObj jmCallingObj = null;
        try {
            boolean flag = true;
            if (deleteFormData) {
                CtpContentAll content = MainbodyService.getInstance().getContent(moduleType, moduleId.longValue());
                if (content == null) {
                    flag = false;
                }
                if (flag) {
                    long formId = content.getContentTemplateId();
                    User user = AppContext.getCurrentUser();
                    jmCallingObj = this.jmMonitorService.putJMCall(formId, (Object)FormRunTypeEnum.SAVE, "deleteContentAndFormData", user != null ? user.getName() : "-");
                    long masterId = content.getContentDataId();
                    this.deleteFormData(masterId, formId);
                    LOGGER.info((Object)("deleteFormDataId:" + DateUtil.get19DateAndTime() + "moduleType=" + moduleType.getKey() + " delete formId=" + formId + "formDataId=" + masterId));
                }
            }
            if (flag) {
                this.ctpMainbodyManager.deleteContentAllByModuleId(moduleType, moduleId);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (jmCallingObj != null) {
                this.jmMonitorService.endJMCall(jmCallingObj);
            }
        }
    }

    public void deleteFormData(long masterId, long formId) throws SQLException, BusinessException {
        CAPFormBean form = this.getForm(formId);
        if (null != form) {
            if (CAPFormEnum.FormVersion.FOUR.equals((Object)form.getFormVersion())) {
                this.cap4FormManager.deleteFormData(masterId, formId);
            } else {
                this.formDataManager.deleteData(Long.valueOf(masterId), (FormBean)form.getInputFormBean());
            }
        }
    }

    public boolean hasFormInCategory(Long categoryId) throws BusinessException {
        boolean result = this.cap4FormManager.hasFormInCategory(categoryId);
        if (!result) {
            result = this.formManager.hasFormInCategory(categoryId);
        }
        return result;
    }

    public BatchCheckResult isCapacityFull(int taskCount) throws BusinessException {
        BatchCheckResult batchCheckResult = new BatchCheckResult();
        batchCheckResult.setAllowed(true);
        if (this.taskExecuteManager.isCapacityFull(taskCount)) {
            batchCheckResult.setAllowed(false);
            batchCheckResult.setMsg(ResourceUtil.getString((String)"form.cap4.trigger.task.full.tips.batch"));
        }
        return batchCheckResult;
    }

    public BatchCheckResult isCapacityFull(int taskCount, long formId) throws BusinessException {
        BatchCheckResult batchCheckResult = new BatchCheckResult();
        batchCheckResult.setAllowed(true);
        if (this.taskExecuteManager.isCapacityFull(taskCount, formId)) {
            batchCheckResult.setAllowed(false);
            batchCheckResult.setMsg(ResourceUtil.getString((String)"form.cap4.trigger.task.full.tips.batch"));
        }
        return batchCheckResult;
    }

    public List<String> getFormRightName(long formId, String rightId) {
        LinkedList<String> result;
        block3: {
            String[] authIds;
            block2: {
                result = new LinkedList<String>();
                authIds = com.seeyon.cap4.form.util.FormUtil.paraseOperationIds((String)rightId);
                com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormCacheManager.getForm(formId);
                if (cap4FormBean == null) break block2;
                for (String authId : authIds) {
                    if (StringUtils.isEmpty((CharSequence)authId)) continue;
                    FormAuthViewBean authBean = cap4FormBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(authId)));
                    FormViewBean viewBean = cap4FormBean.getFormView(authBean.getFormViewId());
                    result.add(viewBean.getFormViewName() + "." + authBean.getName());
                }
                break block3;
            }
            FormBean cap3FormBean = this.formCacheManager.getForm(formId);
            if (cap3FormBean == null) break block3;
            for (String authId : authIds) {
                if (StringUtils.isEmpty((CharSequence)authId)) continue;
                com.seeyon.ctp.form.bean.FormAuthViewBean authViewBean = cap3FormBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(authId)));
                com.seeyon.ctp.form.bean.FormViewBean formViewBean = cap3FormBean.getFormView(authViewBean.getFormViewId());
                result.add(formViewBean.getFormViewName() + "." + authViewBean.getName());
            }
        }
        return result;
    }

    public Map<String, String> getFieldDisplayName(Long formId, Long recordId, List<String> fieldNams) throws BusinessException {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)new StringBuilder("\u83b7\u53d6\u8868\u5355\u663e\u793a\u503c\u4f20\u5165\u53c2\u6570:").append("formId=").append(formId).append(", recordId=").append(recordId).append(", fieldNams=").append(fieldNams));
        }
        if (Strings.isEmpty(fieldNams) || formId == null || recordId == null) {
            return ret;
        }
        com.seeyon.cap4.form.bean.FormBean cap4FormBean = this.cap4FormCacheManager.getForm(formId);
        if (cap4FormBean != null) {
            FormDataMasterBean cap4FormDataBean = this.cap4FormManager.getSessioMasterDataBean(recordId);
            if (null == cap4FormDataBean) {
                try {
                    cap4FormDataBean = this.cap4FormManager.getDataMasterBeanById(recordId, cap4FormBean, null);
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"\u83b7\u53d6\u8868\u5355\u6570\u636e\u51fa\u9519", (Throwable)e);
                }
            }
            if (null != cap4FormDataBean) {
                for (String fieldName : fieldNams) {
                    String name;
                    Object val;
                    Object[] objs;
                    com.seeyon.cap4.form.bean.FormFieldBean fieldBean = cap4FormBean.getFieldBeanByDisplay(fieldName);
                    if (fieldBean == null || (objs = fieldBean.getDisplayValue(val = cap4FormDataBean.getFieldValue(name = fieldBean.getName()))) == null || objs[1] == null) continue;
                    String value = objs[1].toString();
                    ret.put(fieldName, value);
                }
            }
        } else {
            FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
            if (cap3FormBean != null) {
                com.seeyon.ctp.form.bean.FormDataMasterBean dataBean = this.formManager.getSessioMasterDataBean(recordId);
                if (dataBean == null) {
                    try {
                        dataBean = FormService.findDataById((long)recordId, (long)formId);
                    }
                    catch (SQLException e) {
                        LOGGER.error((Object)"\u83b7\u53d6\u8868\u5355\u6570\u636e\u4e3a\u7a7a", (Throwable)e);
                    }
                }
                if (dataBean != null) {
                    for (String fieldName : fieldNams) {
                        String name;
                        Object val;
                        Object[] objs;
                        FormFieldBean formFieldBean = cap3FormBean.getFieldBeanByDisplay(fieldName);
                        if (formFieldBean == null || (objs = formFieldBean.getDisplayValue(val = dataBean.getFieldValue(name = formFieldBean.getName()), false)) == null || objs[1] == null) continue;
                        String value = objs[1].toString();
                        ret.put(fieldName, value);
                    }
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("\u8fd4\u56de\u6570\u636e:" + ((Object)ret).toString()));
        }
        return ret;
    }

    public String getFormDataContentForForward(Map<String, Object> params) throws BusinessException {
        String body = "";
        Long formId = Long.valueOf(String.valueOf(params.get("formId")));
        String rightId = String.valueOf(params.get("rightId"));
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.THREE.equals((Object)formVersion)) {
            int moduleType = Integer.valueOf(String.valueOf(params.get("moduleType")));
            Long moduleId = Long.valueOf(String.valueOf(params.get("moduleId")));
            body = MainbodyService.getInstance().getContentHTML(moduleType, moduleId.longValue(), rightId);
        } else if (CAPFormEnum.FormVersion.FOUR.equals((Object)formVersion)) {
            body = JSONUtil.toJSONString((Object)ServiceProxy.invoke(this.capFormDataForwardService, "getFormDataContent", params));
        }
        return body;
    }

    public String getFormDataHtmlForForward(Long formId, int moduleType, Long moduleId, String rightId) throws BusinessException {
        String body = "";
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.THREE.equals((Object)formVersion)) {
            body = MainbodyService.getInstance().getContentHTML(moduleType, moduleId.longValue(), rightId);
        } else if (CAPFormEnum.FormVersion.FOUR.equals((Object)formVersion)) {
            ScreenCapture4FormParamBean paramBean = new ScreenCapture4FormParamBean();
            paramBean.setModuleType(moduleType);
            paramBean.setModuleId(moduleId);
            paramBean.setRightId(rightId);
            body = this.capScreenCaptureService.doFormDataContentScreenCapture(paramBean);
        }
        return body;
    }

    public Set<Attachment> getFormAttsByAuthForForward(Long formId, Long moduleId, Long rightId) throws BusinessException {
        Set retAtts = null;
        if (CAPFormEnum.FormVersion.THREE.equals((Object)this.getCAPFormVersion(formId))) {
            retAtts = FormService.getFormAttsByAuth((Long)moduleId, (Long)rightId);
        }
        return retAtts == null ? new HashSet() : retAtts;
    }

    @Deprecated
    public boolean hasPhoneView(Long formId, String rightId, CtpContentAllBean ctpContentAllBean) throws BusinessException {
        boolean result = false;
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.THREE.equals((Object)formVersion)) {
            result = true;
        } else if (CAPFormEnum.FormVersion.FOUR.equals((Object)formVersion)) {
            if (Strings.isBlank((String)rightId)) {
                if (ctpContentAllBean != null && ctpContentAllBean.getContentType().equals(MainbodyType.HTML.getKey())) {
                    Map map = (Map)JSONUtil.parseJSONString((String)ctpContentAllBean.getContent());
                    String phoneValue = String.valueOf(Constants.login_sign.phone.value());
                    if (map != null && map.get(phoneValue) != null) {
                        Map dataMap = (Map)map.get(phoneValue);
                        result = !dataMap.isEmpty();
                    }
                }
            } else {
                com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                if (rightId.indexOf("_") > -1 || rightId.indexOf(".") > -1) {
                    String[] viewStrs = rightId.split("_");
                    for (int i = 0; i < viewStrs.length; ++i) {
                        String rightIdStr = viewStrs[i].indexOf(".") > -1 ? viewStrs[i].split("\\.")[1] : viewStrs[i];
                        FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightIdStr)));
                        FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
                        if (!formViewBean.isPhone() || !Strings.isNotEmpty((Collection)formViewBean.getFieldList()) || !Strings.isNotBlank((String)((String)formViewBean.getFieldList().get(0)))) continue;
                        result = true;
                        break;
                    }
                } else {
                    FormAuthViewBean formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)));
                    FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
                    result = formViewBean.isPhone();
                }
            }
        }
        return result;
    }

    public Map<String, String> getFormRightInfo(Long formId, String rightId, CtpContentAllBean ctpContentAllBean) throws BusinessException {
        Map<String, String> map = null;
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.THREE.equals((Object)formVersion)) {
            map = new HashMap<String, String>();
            map.put("pc", "1");
            map.put("phone", "0");
            if (!Strings.isBlank((String)rightId)) {
                FormBean cap3FormBean = this.formCacheManager.getForm(formId.longValue());
                if (rightId.indexOf("_") > -1 || rightId.indexOf(".") > -1) {
                    String[] rightStrs = rightId.split("_");
                    for (int i = 0; i < rightStrs.length; ++i) {
                        String viewIdStr = rightStrs[i].indexOf(".") > -1 ? rightStrs[i].split("\\.")[0] : rightStrs[i];
                        com.seeyon.ctp.form.bean.FormViewBean formViewBean = cap3FormBean.getFormView(Long.parseLong(viewIdStr));
                        if (formViewBean != null && formViewBean.isSettedPhoneView() && Strings.isNotEmpty((Collection)formViewBean.getFieldList()) && Strings.isNotBlank((String)((String)formViewBean.getFieldList().get(0)))) {
                            map.put("phone", "1");
                        } else {
                            String rightIdStr = rightStrs[i].indexOf(".") > -1 ? rightStrs[i].split("\\.")[1] : rightStrs[i];
                            com.seeyon.ctp.form.bean.FormAuthViewBean authViewBean = cap3FormBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightIdStr)));
                            if (authViewBean == null || !authViewBean.isSettedPhoneView()) continue;
                            map.put("phone", "1");
                        }
                        break;
                    }
                } else {
                    com.seeyon.ctp.form.bean.FormAuthViewBean authViewBean = cap3FormBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)));
                    if (authViewBean != null && authViewBean.isSettedPhoneView()) {
                        map.put("phone", "1");
                    } else {
                        com.seeyon.ctp.form.bean.FormViewBean formViewBean = cap3FormBean.getFormView(Long.parseLong(rightId));
                        if (formViewBean != null && formViewBean.isSettedPhoneView()) {
                            map.put("phone", "1");
                        }
                    }
                }
            }
        } else if (CAPFormEnum.FormVersion.FOUR.equals((Object)formVersion)) {
            map = this.cap4FormManager.getFormDataRightInfo(formId, rightId, ctpContentAllBean == null ? null : ctpContentAllBean.toContentAll(), AppContext.getLocale().toString());
        }
        return map;
    }

    public boolean checkInputData(long formId, long viewId, long operationId, Map<String, String> masterNameValues, List<Map<String, String>> slaveNameValues, long id) throws BusinessException {
        FormBean cap3FormBean = this.formCacheManager.getForm(formId);
        com.seeyon.cap4.form.bean.FormBean cap4FormBean = null;
        if (cap3FormBean == null) {
            cap4FormBean = this.cap4FormCacheManager.getForm(formId);
            if (null == cap4FormBean) {
                return false;
            }
            return this.cap4FormManager.checkInputData(formId, viewId, operationId, masterNameValues, slaveNameValues, id);
        }
        return FormService.checkInputData((long)formId, (long)viewId, (long)operationId, masterNameValues, slaveNameValues, (long)id);
    }

    public Long structureFormDataMasterBeanByDataJson(Long formId, String rightIdStr, String dataJson, int saveType) throws BusinessException, SQLException {
        boolean validData;
        if (formId == null || formId == -1L || formId == 0L) {
            throw new BusinessException("\u65e0\u6548\u7684\u8868\u5355Id\uff01");
        }
        Long rightId = this.getRealRightId(rightIdStr);
        if (rightId == null || rightId == 0L || rightId == -1L) {
            throw new BusinessException("\u65e0\u6548\u7684\u6743\u9650Id!");
        }
        boolean bl = validData = saveType == CAPFormEnum.SaveType.SAVE.getType();
        if (this.isCAP4Form(formId)) {
            FormDataMasterBean formDataMasterBean = this.cap4FormManager.structureFormDataMasterBeanWithJson(formId, rightId, dataJson, validData);
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            this.cap4FormManager.putSessioMasterDataBean(formBean, formDataMasterBean, true, false);
            this.cap4FormManager.saveOrUpdateFormData(formDataMasterBean, formId, true);
            return formDataMasterBean.getId();
        }
        HashMap<String, Boolean> extMap = new HashMap<String, Boolean>();
        extMap.put("executeValidate", validData);
        com.seeyon.ctp.form.bean.FormDataMasterBean formDataMasterBean = this.formManager.structureFormDataMasterBeanWithJson(formId, rightId, dataJson, extMap);
        FormBean formBean = this.formCacheManager.getForm(formId.longValue());
        this.formManager.putSessioMasterDataBean(formBean, formDataMasterBean, true, false);
        FormService.saveOrUpdateFormData((com.seeyon.ctp.form.bean.FormDataMasterBean)formDataMasterBean, (Long)formId, (boolean)true);
        return formDataMasterBean.getId();
    }

    private Long getRealRightId(String rightId) {
        String realRightId = "";
        if (Strings.isNotBlank((String)rightId)) {
            String[] rightArr = rightId.split("_");
            realRightId = rightArr[0];
            if (realRightId.contains(".")) {
                realRightId = realRightId.substring(realRightId.indexOf(".") + 1);
            }
            return Long.parseLong(realRightId);
        }
        return null;
    }

    public boolean validateFormFlowCanRelive(Long formId) {
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
            return Strings.isEmpty((Collection)this.cap4FormCacheManager.getForm(formId).getFormTriggerIdList());
        }
        return !this.formCacheManager.getForm(formId.longValue()).hasTriggerSet();
    }

    public void updateDataState4FlowRelive(Object colSummaryObj, CtpAffair affair, Object typeObj, List<Comment> list) throws BusinessException, SQLException {
        ColSummary colSummary = (ColSummary)colSummaryObj;
        if (colSummary.getFormAppid() == null) {
            return;
        }
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(colSummary.getFormAppid());
        if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
            this.cap4FormManager.updateDataState(colSummary, affair, ColHandleType.stepBack, list);
        } else if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
            this.formManager.updateDataState(colSummary, affair, ColHandleType.stepBack, list);
        }
    }

    public Map<String, Object> saveFlowFormData(Long formId, Long masterDataId, CAPFormEnum.SaveType saveType, boolean needSn, boolean needCheckRule) throws BusinessException, SQLException {
        LOGGER.info((Object)("saveFlowFormData " + formId + " " + masterDataId + " " + saveType.getName() + " " + needSn + " " + needCheckRule));
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
            CAPBusinessEnum.FormSaveType formSaveType;
            switch (saveType) {
                case SAVE: {
                    formSaveType = CAPBusinessEnum.FormSaveType.SAVE_AND_CLOSED;
                    break;
                }
                case SAVE_WAIT: {
                    formSaveType = CAPBusinessEnum.FormSaveType.SAVE_AS;
                    break;
                }
                case SAVE_TEMPLATE: {
                    formSaveType = CAPBusinessEnum.FormSaveType.SAVE_AS_TEMPLATE;
                    break;
                }
                default: {
                    formSaveType = CAPBusinessEnum.FormSaveType.SAVE_AND_CLOSED;
                }
            }
            Map<String, Object> resultMap = this.capFormDataService.saveOrUpdateFlowFormData(masterDataId, formSaveType.getType(), needSn, needCheckRule);
            return resultMap;
        }
        if (CAPFormEnum.FormVersion.THREE.getVersion() == formVersion.getVersion()) {
            User user = AppContext.getCurrentUser();
            CtpContentAllBean contentAll = this.formManager.getSessioMasterDataBean(masterDataId).getContentAllBean();
            if (null == contentAll) {
                throw new BusinessException("contentAll\u4e3a\u7a7a\uff01");
            }
            AppContext.putThreadContext((String)"THREAD_CONTEXT_JSONSTR_KEY", (Object)JSONUtil.toJSONString((Object)contentAll.toContentAll()));
            contentAll.getExtraMap().put("needCheckRule", needCheckRule);
            contentAll.getExtraMap().put("needSn", needSn);
            AppContext.getRawRequest().setAttribute("optType", (Object)saveType);
            AppContext.getRawRequest().setAttribute("notSaveDB", (Object)false);
            AppContext.putThreadContext((String)"needDealAttachment", (Object)true);
            this.ctpMainbodyManager.transContentSaveOrUpdate(contentAll);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            if (null != contentAll.getAttr("sn")) {
                HashMap snInfoMap = new HashMap();
                ArrayList snInfos = new ArrayList();
                DataContainer sns = (DataContainer)contentAll.getAttr("sn");
                HashMap<String, Object> snInfo = new HashMap<String, Object>();
                for (String key : sns.keySet()) {
                    snInfo.put("snmu", sns.get((Object)key));
                    snInfo.put("display", key);
                    snInfos.add(snInfo);
                }
                snInfoMap.put("snInfo", snInfos);
                resultMap.put("data", snInfoMap);
            }
            this.formManager.getSessioMasterDataBean(masterDataId).removeCtpContentAllCache();
            return resultMap != null ? resultMap : null;
        }
        return null;
    }

    public String getFormDataJSONString(Long formId, Long masterDataId) throws BusinessException {
        if (this.isCAP4Form(formId)) {
            FormDataMasterBean formDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(masterDataId);
            return formDataMasterBean == null ? null : formDataMasterBean.getAllDataJSONString();
        }
        return null;
    }

    public boolean isMatchFilterCondition(Long formId, Long dataId, String formulaStr) throws BusinessException, SQLException {
        CAPFormEnum.FormVersion formVersion = this.getCAPFormVersion(formId);
        if (CAPFormEnum.FormVersion.FOUR.getVersion() == formVersion.getVersion()) {
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            com.seeyon.cap4.form.bean.FormFormulaBean formula4 = new com.seeyon.cap4.form.bean.FormFormulaBean(formBean);
            formula4.loadFromFormula(formulaStr);
            FormDataMasterBean formDataMasterBean = this.cap4FormManager.getDataMasterBeanById(dataId, formBean, null);
            return com.seeyon.cap4.form.util.FormUtil.isMatchFilterCondition((com.seeyon.cap4.form.bean.FormFormulaBean)formula4, (FormDataMasterBean)formDataMasterBean);
        }
        FormBean formBean3 = this.formCacheManager.getForm(formId.longValue());
        FormFormulaBean formula3 = new FormFormulaBean(formBean3);
        formula3.loadFromFormula(formulaStr);
        com.seeyon.ctp.form.bean.FormDataMasterBean masterBean3 = this.formManager.getDataMasterBeanById(dataId, formBean3, null);
        return FormUtil.isMatchFormCondition((FormFormulaBean)formula3, (com.seeyon.ctp.form.bean.FormDataMasterBean)masterBean3);
    }

    public boolean isUseProc() {
        String property = SystemProperties.getInstance().getProperty("ctp.storageprocedure.enabled");
        return "true".equalsIgnoreCase(property);
    }

    public void setFormManager(FormManager formManager) {
        this.formManager = formManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFormRelationManager(FormRelationManager formRelationManager) {
        this.formRelationManager = formRelationManager;
    }

    public FormDataManager getFormDataManager() {
        return this.formDataManager;
    }

    public void setFormDataManager(FormDataManager formDataManager) {
        this.formDataManager = formDataManager;
    }

    public TaskExecuteManager getTaskExecuteManager() {
        return this.taskExecuteManager;
    }

    public void setTaskExecuteManager(TaskExecuteManager taskExecuteManager) {
        this.taskExecuteManager = taskExecuteManager;
    }

    public void setCap4FormRelationActionManager(CAP4FormRelationActionManager cap4FormRelationActionManager) {
        this.cap4FormRelationActionManager = cap4FormRelationActionManager;
    }

    public void setCtpMainbodyManager(MainbodyManager ctpMainbodyManager) {
        this.ctpMainbodyManager = ctpMainbodyManager;
    }

    public void setCapFormDataService(CAPFormDataService capFormDataService) {
        this.capFormDataService = capFormDataService;
    }

    public void setCapFormDataForwardService(CAPFormDataForwardService capFormDataForwardService) {
        this.capFormDataForwardService = capFormDataForwardService;
    }

    public void setCapScreenCaptureService(CAPScreenCaptureService capScreenCaptureService) {
        this.capScreenCaptureService = capScreenCaptureService;
    }

    public JMMonitorService getJmMonitorService() {
        return this.jmMonitorService;
    }

    public void setJmMonitorService(JMMonitorService jmMonitorService) {
        this.jmMonitorService = jmMonitorService;
    }

    public int getNoByEnum(Object e) {
        int result = -1;
        if (e instanceof CAP4FormCache.FormCacheType) {
            CAP4FormCache.FormCacheType type = (CAP4FormCache.FormCacheType)((Object)e);
            result = type.ordinal();
        } else if (e instanceof FormCache.FormCacheType) {
            FormCache.FormCacheType type = (FormCache.FormCacheType)e;
            int cap4Size = CAP4FormCache.FormCacheType.values().length;
            result = cap4Size + type.ordinal() + 1;
        } else {
            LOGGER.error((Object)("\u4e0d\u652f\u6301\u7684\u7f13\u5b58\u540c\u6b65\u7c7b\u578b\uff1a" + e));
        }
        return result;
    }
}

